<?php

/**
 * cardsave 3D-Secure iFrame Redirection and Callback Handler
 *
 * @author     Conor Kerr <cardsave@dev.ceon.net>
 * @copyright  Copyright 2008 Ceon
 * @copyright  Portions Zen to OS-Commerce Conversion 22/03/2010 - David McCann, CardSave Online  
 * @copyright  Portions Copyright 2003-2006 Zen Cart Development Team
 * @copyright  Portions Copyright 2003 osCommerce
 * @link       http://dev.ceon.net/web/zen-cart/cardsave
 * @license    http://www.gnu.org/copyleft/gpl.html   GNU Public License V2.0
 * @version    $Id: cardsave_3d_secure_iframe.php 551 2008-02-20 15:54:47Z conor $
 */

require('includes/application_top.php');

define('FILENAME_CARDSAVE_3D_SECURE_IFRAME', 'cardsave_3d_secure_iframelink.php');

$_SESSION['navigation']->remove_current_page();

/**
 * Require language defines
 */
$cardsave_language_file_path = 'modules/payment/cardsave.php';
if (file_exists(DIR_WS_LANGUAGES . $_SESSION['language'] . '/' . $template_dir_select . $cardsave_language_file_path)) {
	require(DIR_WS_LANGUAGES . $_SESSION['language'] . '/' . $template_dir_select . $cardsave_language_file_path);
} else {
	require(DIR_WS_LANGUAGES . $_SESSION['language'] . '/' . $cardsave_language_file_path);
}

$current_page_base = 'cardsave_3d_secure_iframe';

?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
<head>
	<title>CardSave 3D-Secure Authorisation IFrame</title>
	<?php
	/**
	* Load all template-specific stylesheets, named like "style*.css", alphabetically
	*/
	//$directory_array = $template->get_template_part($template->get_template_dir('.css', DIR_WS_TEMPLATE, $current_page_base, 'css'), '/^style/', '.css');
	//while(list ($key, $value) = each($directory_array)) {
	//	echo '<link rel="stylesheet" type="text/css" href="' . $template->get_template_dir('.css', DIR_WS_TEMPLATE, $current_page_base, 'css') . '/' . $value . '" />' . "\n";
	//}
	/**
	* Load stylesheets on a per-page basis. Concept by Juxi Zoza.
	*/
	//$sheets_array = array('/' . $_SESSION['language'] . '_stylesheet', 
	//	'/' . $current_page_base, 
	//	'/' . $_SESSION['language'] . '_' . $current_page_base, 
	//	);
	//while(list ($key, $value) = each($sheets_array)) {
	//	$perpagefile = $template->get_template_dir('.css', DIR_WS_TEMPLATE, $current_page_base, 'css') . $value . '.css';
	//	if (file_exists($perpagefile)) {
	//		echo '<link rel="stylesheet" type="text/css" href="' . $perpagefile .'" />'."\n";
	//	}
	//}
	?>
  <link href="stylesheet.css" rel="stylesheet" type="text/css" />
</head>
<body>
<?php
// Don't display any messages/buttons if javascript is active within the current session
?>
<script language="Javascript">
<!--
document.write('<' + 'style type="text/css">');
document.write('.CardSaveJavascriptSuppressed { display: none; }');
document.write('<' + '/style>');
// -->
</script>
<?php
if (isset($_GET['ACSURL'])) {
	// Pass the information to the callback URL
?>
<h3 class="CardSaveJavascriptSuppressed"><?php echo MODULE_PAYMENT_CARDSAVE_TEXT_3D_SECURE_WHAT_NOW; ?></h3>
<p class="CardSaveJavascriptSuppressed"><?php echo MODULE_PAYMENT_CARDSAVE_TEXT_3D_SECURE_DISPLAYED_NEXT_1; ?></p>
<p class="CardSaveJavascriptSuppressed"><?php echo MODULE_PAYMENT_CARDSAVE_TEXT_3D_SECURE_DISPLAYED_NEXT_2; ?></p>
<p class="CardSaveJavascriptSuppressed"><?php echo MODULE_PAYMENT_CARDSAVE_TEXT_3D_SECURE_CLICK_TO_AUTHENTICATE; ?></p>

<form name="checkout_cardsave_3d_secure" action="<?php echo htmlspecialchars($_GET['ACSURL']); ?>" method="POST">
	<input type="hidden" name="PaReq" value="<?php echo str_replace(' ', '+', htmlspecialchars($_GET['PaReq'])); ?>" />
	<input type="hidden" name="TermUrl" value="<?php echo str_replace(' ', '+', tep_href_link(FILENAME_CARDSAVE_3D_SECURE_IFRAME, 'made_by=ceon', 'SSL', true, true, true, true)); ?>" />
	<input type="hidden" name="MD" value="<?php echo str_replace(' ', '+', htmlspecialchars($_GET['crossreference'])); ?>" />

	<br clear="all" />
	<div class="buttonRow forward CardSaveJavascriptSuppressed"><?php echo tep_image_submit(BUTTON_IMAGE_CONTINUE_CHECKOUT, BUTTON_CONTINUE_ALT); ?></div>
	<div class="buttonRow back CardSaveJavascriptSuppressed"><?php echo TITLE_CONTINUE_CHECKOUT_PROCEDURE . '<br />' . TEXT_CONTINUE_CHECKOUT_PROCEDURE; ?></div>
</form>
<?php
// Output javascript necessary for auto-submission of form
?>
<script language="Javascript">
<!--
document.checkout_cardsave_3d_secure.submit();
// -->
</script>
<?php
} else if (isset($_POST['PaRes'])){
	// Grab the returned PaRes and post it to the checkout payment page
?>
<p class="CardSaveJavascriptSuppressed"><?php echo MODULE_PAYMENT_CARDSAVE_TEXT_3D_SECURE_COMPLETED_CONTINUE; ?></p>
	
<form name="checkout_cardsave_3d_secure" action="<?php echo tep_href_link(FILENAME_CHECKOUT_PROCESS, '', 'SSL'); ?>" method="POST" target="_parent">
	<input type="hidden" name="PaRes" value="<?php echo str_replace(' ', '+', htmlspecialchars($_POST['PaRes'])); ?>" />
	<input type="hidden" name="MD" value="<?php echo str_replace(' ', '+', htmlspecialchars($_POST['MD'])); ?>" />

	<br clear="all" />
	<div class="buttonRow forward CardSaveJavascriptSuppressed"><?php echo tep_image_submit(BUTTON_IMAGE_CONTINUE_CHECKOUT, BUTTON_CONTINUE_ALT); ?></div>
</form>
<?php
// Output javascript necessary for auto-submission of form
?>
<script language="Javascript">
<!--
document.checkout_cardsave_3d_secure.submit();
// -->
</script>

<?php	
} else {
	// ERROR!
	print "CardSave response failed?!";
}
?>              
</body>
</html>


