<?php

/**
 * cardsave Test Cases
 *
 * @author     Conor Kerr <cardsave@dev.ceon.net>
 * @copyright  Copyright 2008 Ceon
 * @copyright  Portions Copyright 2003-2006 Zen Cart Development Team
 * @copyright  Portions Copyright 2003 osCommerce
 * @link       http://dev.ceon.net/web/zen-cart/cardsave
 * @license    http://www.gnu.org/copyleft/gpl.html   GNU Public License V2.0
 * @version    $Id: test_cases.php 662 2008-06-26 09:59:29Z conor $
 */

$test_cases = array();
$test_case_info = array();

$test_cases[] = array(
	'id' => '-1',
	'text' => MODULE_PAYMENT_CARDSAVE_TEXT_SELECT_TEST_CASE
	);

$test_cases[] = array(
	'id' => sizeof($test_cases),
	'text' => sprintf(MODULE_PAYMENT_CARDSAVE_TEXT_SELECT_TEST_CASE_1, $this->_getCardTypeNameForCode('VISA'))
	);
$test_case_info[sizeof($test_cases) - 1] = array(
	'card_owner' => 'John Watson',
	'card_type' => 'VISA',
	'card_number' => '4976000000003436',
	'card_expires_month' => '12',
	'card_expires_year' => '12',
	'card_start_month' => '01',
	'card_start_year' => '07',
	'card_cv2' => 452,
	'card_address_numeric' => '32 Edward Street',
	'card_city' => 'Camborne',
	'card_state' => 'Cornwall',
	'card_postcode' => 'TR14 8PA'
	);

$test_cases[] = array(
	'id' => sizeof($test_cases),
	'text' => sprintf(MODULE_PAYMENT_CARDSAVE_TEXT_SELECT_TEST_CASE_1, $this->_getCardTypeNameForCode('MAESTRO'))
	);
$test_case_info[sizeof($test_cases) - 1] = array(
	'card_owner' => 'Paul Taylor',
	'card_type' => 'MAESTRO',
	'card_number' => '6759000000005462',
	'card_expires_month' => '12',
	'card_expires_year' => '12',
	'card_start_month' => '01',
	'card_start_year' => '07',
	'card_cv2' => 789,
	'card_address_numeric' => '7 Balmore Drive',
	'card_city' => 'Reading',
	'card_state' => 'Berkshire',
	'card_postcode' => 'RG4 8NL'
	);

$test_cases[] = array(
	'id' => sizeof($test_cases),
	'text' => sprintf(MODULE_PAYMENT_CARDSAVE_TEXT_SELECT_TEST_CASE_2, $this->_getCardTypeNameForCode('VISA'))
	);
$test_case_info[sizeof($test_cases) - 1] = array(
	'card_owner' => 'Ian Lee',
	'card_type' => 'VISA',
	'card_number' => '4221690000004963',
	'card_expires_month' => '12',
	'card_expires_year' => '12',
	'card_start_month' => '01',
	'card_start_year' => '07',
	'card_cv2' => 125,
	'card_address_numeric' => '274 Lymington Avenue',
	'card_city' => 'London',
	'card_state' => 'London',
	'card_postcode' => 'N22 6JN'
	);

$test_cases[] = array(
	'id' => sizeof($test_cases),
	'text' => sprintf(MODULE_PAYMENT_CARDSAVE_TEXT_SELECT_TEST_CASE_3, $this->_getCardTypeNameForCode('MASTERCARD'))
	);
$test_case_info[sizeof($test_cases) - 1] = array(
	'card_owner' => 'Susan Kitchen',
	'card_type' => 'MASTERCARD',
	'card_number' => '5100000000005858',
	'card_expires_month' => '12',
	'card_expires_year' => '12',
	'card_start_month' => '01',
	'card_start_year' => '07',
	'card_cv2' => 844,
	'card_address_numeric' => '17 Suffolk Road',
	'card_city' => 'North Harrow',
	'card_state' => 'London',
	'card_postcode' => 'HA2 7QH'
	);

$test_cases[] = array(
	'id' => sizeof($test_cases),
	'text' => sprintf(MODULE_PAYMENT_CARDSAVE_TEXT_SELECT_TEST_CASE_4, $this->_getCardTypeNameForCode('MAESTRO'))
	);
$test_case_info[sizeof($test_cases) - 1] = array(
	'card_owner' => 'Anthony Walker',
	'card_type' => 'MAESTRO',
	'card_number' => '6759000000001909',
	'card_expires_month' => '12',
	'card_expires_year' => '12',
	'card_start_month' => '01',
	'card_start_year' => '07',
	'card_cv2' => 784,
	'card_address_numeric' => '100 Tachbrook Street',
	'card_city' => 'Leamington Spa',
	'card_state' => 'Warwickshire',
	'card_postcode' => 'CV31 2BH'
	);

$test_cases[] = array(
	'id' => sizeof($test_cases),
	'text' => sprintf(MODULE_PAYMENT_CARDSAVE_TEXT_SELECT_TEST_CASE_5, $this->_getCardTypeNameForCode('MASTERCARD'))
	);
$test_case_info[sizeof($test_cases) - 1] = array(
	'card_owner' => 'Graeme Brown',
	'card_type' => 'MASTERCARD',
	'card_number' => '5100000000008019',
	'card_expires_month' => '12',
	'card_expires_year' => '12',
	'card_start_month' => '01',
	'card_start_year' => '07',
	'card_cv2' => 871,
	'card_address_numeric' => '46 Southfields',
	'card_city' => 'York',
	'card_state' => 'North Yorkshire',
	'card_postcode' => 'YO61 4TH'
	);

$test_cases[] = array(
	'id' => sizeof($test_cases),
	'text' => sprintf(MODULE_PAYMENT_CARDSAVE_TEXT_SELECT_TEST_CASE_6, $this->_getCardTypeNameForCode('VISA_DEBIT'))
	);
$test_case_info[sizeof($test_cases) - 1] = array(
	'card_owner' => 'Nigel Munroe',
	'card_type' => 'VISA_DEBIT',
	'card_number' => '4921810000000471',
	'card_expires_month' => '12',
	'card_expires_year' => '12',
	'card_start_month' => '01',
	'card_start_year' => '07',
	'card_cv2' => 874,
	'card_address_numeric' => '55 Wordsworth Drive',
	'card_city' => 'Market Drayton',
	'card_state' => 'Shropshire',
	'card_postcode' => 'TF9 1ND'
	);

?>