-- MySQL dump 10.13  Distrib 5.1.52, for pc-linux-gnu (i686)
--
-- Host: localhost    Database: astral_main
-- ------------------------------------------------------
-- Server version	5.1.52

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `address_book`
--

DROP TABLE IF EXISTS `address_book`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `address_book` (
  `address_book_id` int(11) NOT NULL AUTO_INCREMENT,
  `customers_id` int(11) NOT NULL,
  `entry_gender` char(1) NOT NULL,
  `entry_company` varchar(32) DEFAULT NULL,
  `entry_firstname` varchar(32) NOT NULL,
  `entry_lastname` varchar(32) NOT NULL,
  `entry_street_address` varchar(64) NOT NULL,
  `entry_suburb` varchar(32) DEFAULT NULL,
  `entry_postcode` varchar(10) NOT NULL,
  `entry_city` varchar(32) NOT NULL,
  `entry_state` varchar(32) DEFAULT NULL,
  `entry_country_id` int(11) NOT NULL DEFAULT '0',
  `entry_zone_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`address_book_id`),
  KEY `idx_address_book_customers_id` (`customers_id`)
) ENGINE=InnoDB AUTO_INCREMENT=75 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `address_book`
--

LOCK TABLES `address_book` WRITE;
/*!40000 ALTER TABLE `address_book` DISABLE KEYS */;
INSERT INTO `address_book` VALUES (19,19,'','Astral Jewels','Payal','Maheshwari','2/1245 Burke Road','Kew','3101','Kew','VIC',13,0),(20,20,'','Tezgems','Terrie','Caven','P.O. Box 6207','VERMONT SOUTH','3133','MELBOURNE','VICTORIA',13,0),(22,22,'','Mind Body Spirit','Monique','Dawson','53 Chittaway Road','Chittaway Bay.','2261','NSW','Sdney',13,0),(24,24,'','The Swish Gallery','Susie','Rowley','29 Talbragar Street','Dubbo','2830','Dubbo','NSW',13,0),(25,25,'','dag','debra','woodruff','3 tryon court','kirwan','4817','townsville','qld',13,0),(26,26,'','HampersNThings','Carmel','Alberti','17 Alexander Ave','Coburg North','3058','Melbourne','Vic',13,0),(27,27,'','silver tree jewellery','Leonie','Rowell','102 Cole street','Brighton','3186','Melbourne','Victoria',13,0),(28,28,'','axcessories addiction','betty','patsiolis','2/29 avoca avenue','elwood','2184','melbourne','victoria',13,0),(29,29,'','goldnglitter','wendy','babbar','shop 8centro oakleigh','oakleigh','3166','melbourne','vic',13,0),(30,30,'','LMR','Lesley','Ryan','79 Maunganui Rd','Maunganui','3116','Tauranga','Bay of Plenty',153,0),(32,32,'','','Fiona','Phillips','85 Moor Street','Fitzroy','3065','Melbourne','Victoria',13,0),(35,35,'','georgina designs','georgina','jobling','60 forrest drive',NULL,'3987','nyora','vic',13,0),(39,39,'','Living Chakra','Carla','Enriquez','88 Pine Hill Drive',NULL,'3109','Doncaster East','vic',13,0),(40,40,'','Now and Then Jewellers','Sharon','Beer','Shop 1,291 Hargreaves Mall',NULL,'3550','Bendigo','Victoria',13,0),(41,41,'','Skipton Art Gallery','Juli','Davine','36 Montgomery St',NULL,'3361','Skipton','Vic',13,0),(42,42,'','tanjable expressions','coral','wiebenga','unit 1 / 7 myola street',NULL,'3197','carrum','Victoria',13,0),(43,43,'','Belle Essentials','Suzanne','Metaxas','440 Bell Street',NULL,'3072','PRESTON','Victoria',13,0),(44,44,'','TBA','Loretta','Illy','3 Telopea cres',NULL,'2548','Tura Beach','NSW',13,0),(47,47,'','','Tanya','Singh','33 Club Street',NULL,'069415','Singapore','Singapore',188,0),(49,49,'','','Shiro','Kenny','1/198 Kerferd Rd',NULL,'3206','Albert Park','Vic',13,0),(50,50,'','Silver Trading Co.','Ann','Dubbioso','29b Barnett Ave,Glynde',NULL,'5070','Adelaide','South Australia',13,0),(51,51,'','GR Enterprises','Jo','Dalton','38 Thistle Avenue',NULL,'5087','Klemzig','SA',13,0),(52,52,'','JK Jewels','Jacinta','Roosing','34 wharenui rd',NULL,'8041','Upper Riccarton','Christchurch',153,0),(53,53,'','Magic Happens Here Salon Of Beau','Liz','Jeffery','19 Murray Drive',NULL,'6230','Withers','wa',13,0),(54,54,'','JAS Designs','Angie','Prokopis','30 Renowden Street',NULL,'3192','Cheltenham','Victoria',13,0),(55,55,'','','chiwoneso','bwititi','4 oakmont court',NULL,'3037','hillside','vic',13,0),(56,56,'','LA ACCESSORIES','ANGELA','ALBERTIN','WESTFIELDSC, 415 MCDONALDS RD',NULL,'3752','SOUTH MORANG','VICTORIA',13,0),(57,57,'','','shantell','mckee','14 Hants St',NULL,'4007','Hamilton','QLD',13,0),(58,58,'','Sandara Jewellery','Julie','Dolan','19 Coorabin Crt',NULL,'4228','Tallebudgera','Qld',13,0),(59,59,'','silvex images','NEERAJ','KEJRIWAL','403 durga apartments, bani park',NULL,'302016','australia','Select Your State',13,0),(60,60,'','','marisa','totevski','presso outlet arredamenti via marconi 12',NULL,'85050','villa dagri','potenza',105,0),(61,61,'','SWISHkelly','kelly','sidwick','24 Scott Street',NULL,'5063','Parkside','South Australia',13,0),(62,62,'','Wing\'s','kim','wing','448 s quince ave',NULL,'08205','galloway','',223,41),(63,63,'','','Paulette','Adams','166 homestead road',NULL,'2748','Orchard Hills','New south wales',13,0),(64,64,'','Eureka Beads','Charlotte','Farano','222 Toomuc Valley Road',NULL,'3810','Pakenham','Victoria',13,0),(65,65,'','LK Design','lisa','kennedy','Binbian Downs',NULL,'4415','Miles','Qld',13,0),(66,66,'','PEBEL','Bianca','Pepe','8 Warren Close',NULL,'3082','Mill Park','vic',13,0),(67,67,'','Aqua collection','Amy','Perry','shop G3024 top ryde city shopping centre',NULL,'2112','ryde','NSW',13,0),(68,68,'','Eternity bridal','Natalie','Karapatsakis','3/1 downes street',NULL,'2191','Belfield','Nsw',13,0),(69,69,'','Prism Gallery Jewellers','Leanne','Lance','10 Anderson Street',NULL,'3741','Bright','VIC',13,0),(70,70,'','PurpleThread','Tracy','Emerton','10 Vivi St',NULL,'3662','Puckapunyal','Victoria',13,0),(71,71,'','','Justin','Sandher','102-7171 121 St',NULL,'V3W1G9','Surrey','',38,67),(72,72,'','','deepika','sahni','1056 burke road',NULL,'3103','north balwyn','melbourne',13,0),(73,73,'','Lakshmi\'s Circle','Sue','Caldwell','43B High Street',NULL,'3444','Kyneton','Vic',13,0),(74,74,'','Ian Pattison Jewellers Pty Ltd','Lyn','Pattison','69 The Terrace',NULL,'3226','Ocean Grove','Victoria',13,0);
/*!40000 ALTER TABLE `address_book` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `address_format`
--

DROP TABLE IF EXISTS `address_format`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `address_format` (
  `address_format_id` int(11) NOT NULL AUTO_INCREMENT,
  `address_format` varchar(128) NOT NULL,
  `address_summary` varchar(48) NOT NULL,
  PRIMARY KEY (`address_format_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `address_format`
--

LOCK TABLES `address_format` WRITE;
/*!40000 ALTER TABLE `address_format` DISABLE KEYS */;
INSERT INTO `address_format` VALUES (1,'$firstname $lastname$cr$streets$cr$city, $postcode$cr$statecomma$country','$city / $country'),(2,'$firstname $lastname$cr$streets$cr$city, $state    $postcode$cr$country','$city, $state / $country'),(3,'$firstname $lastname$cr$streets$cr$city$cr$postcode - $statecomma$country','$state / $country'),(4,'$firstname $lastname$cr$streets$cr$city ($postcode)$cr$country','$postcode / $country'),(5,'$firstname $lastname$cr$streets$cr$postcode $city$cr$country','$city / $country');
/*!40000 ALTER TABLE `address_format` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `administrators`
--

DROP TABLE IF EXISTS `administrators`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `administrators` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_name` varchar(32) CHARACTER SET latin1 COLLATE latin1_bin NOT NULL,
  `user_password` varchar(40) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `administrators`
--

LOCK TABLES `administrators` WRITE;
/*!40000 ALTER TABLE `administrators` DISABLE KEYS */;
INSERT INTO `administrators` VALUES (1,'master','606f9c92d65bccaa8a076d8b82751152:c4'),(2,'seomaster','7b4b05a17eb11496b05bd3af17d80edb:34'),(3,'1','b2f627fff19fda463cb386442eac2b3d:60'),(4,'admin','622cf6f4ab592159acae181ad2413d12:be');
/*!40000 ALTER TABLE `administrators` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `banners`
--

DROP TABLE IF EXISTS `banners`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `banners` (
  `banners_id` int(11) NOT NULL AUTO_INCREMENT,
  `banners_title` varchar(64) NOT NULL,
  `banners_url` varchar(255) NOT NULL,
  `banners_image` varchar(64) NOT NULL,
  `banners_group` varchar(10) NOT NULL,
  `banners_html_text` text,
  `expires_impressions` int(7) DEFAULT '0',
  `expires_date` datetime DEFAULT NULL,
  `date_scheduled` datetime DEFAULT NULL,
  `date_added` datetime NOT NULL,
  `date_status_change` datetime DEFAULT NULL,
  `status` int(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`banners_id`),
  KEY `idx_banners_group` (`banners_group`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `banners`
--

LOCK TABLES `banners` WRITE;
/*!40000 ALTER TABLE `banners` DISABLE KEYS */;
INSERT INTO `banners` VALUES (1,'Banner Top 1','shop-c-2.html','banners/bnr1.jpg','670x419','Test',0,NULL,NULL,'2010-01-11 15:17:34','2010-05-12 14:31:09',1),(2,'Banner Top 2','masks-c-2_73.html','banners/bnr2.jpg','670x419','Test',0,NULL,NULL,'2010-05-12 14:13:56',NULL,1),(3,'Banner Top 3','funky-eyes-c-85.html','banners/bnr3.jpg','670x419','',0,NULL,NULL,'2010-05-12 14:14:30',NULL,1);
/*!40000 ALTER TABLE `banners` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `banners_history`
--

DROP TABLE IF EXISTS `banners_history`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `banners_history` (
  `banners_history_id` int(11) NOT NULL AUTO_INCREMENT,
  `banners_id` int(11) NOT NULL,
  `banners_shown` int(5) NOT NULL DEFAULT '0',
  `banners_clicked` int(5) NOT NULL DEFAULT '0',
  `banners_history_date` datetime NOT NULL,
  PRIMARY KEY (`banners_history_id`),
  KEY `idx_banners_history_banners_id` (`banners_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `banners_history`
--

LOCK TABLES `banners_history` WRITE;
/*!40000 ALTER TABLE `banners_history` DISABLE KEYS */;
INSERT INTO `banners_history` VALUES (1,1,4,0,'2010-01-11 15:18:52'),(2,1,87,0,'2010-01-12 11:06:21'),(3,1,54,0,'2010-01-15 10:11:36');
/*!40000 ALTER TABLE `banners_history` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cache`
--

DROP TABLE IF EXISTS `cache`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cache` (
  `cache_id` varchar(32) NOT NULL DEFAULT '',
  `cache_language_id` tinyint(1) NOT NULL DEFAULT '0',
  `cache_name` varchar(255) NOT NULL DEFAULT '',
  `cache_data` mediumtext NOT NULL,
  `cache_global` tinyint(1) NOT NULL DEFAULT '1',
  `cache_gzip` tinyint(1) NOT NULL DEFAULT '1',
  `cache_method` varchar(20) NOT NULL DEFAULT 'RETURN',
  `cache_date` datetime NOT NULL,
  `cache_expires` datetime NOT NULL,
  PRIMARY KEY (`cache_id`,`cache_language_id`),
  KEY `cache_id` (`cache_id`),
  KEY `cache_language_id` (`cache_language_id`),
  KEY `cache_global` (`cache_global`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cache`
--

LOCK TABLES `cache` WRITE;
/*!40000 ALTER TABLE `cache` DISABLE KEYS */;
INSERT INTO `cache` VALUES ('ca34fbe5f9a075091ad59abf02c259a7',1,'seo_urls_v2_products','nZhLbxoxFIX3/RXd0UodCRNeUVdV22Ufqtp15AEHRjFjYgwp+fUdjmcmN0rh2Nnf1/g79wFLc1vV5t3g568fX/58/n3z/dO3rzfTq8GHt4PbylYrXxVbUy91HQbvP75Z/td6fLJeaV+bULiDttxjIjyM9r6qV+fDT0/GW6uruoglGcMzzJ6caP3zDNvrk63emLA+7kJxqxcmBLOk9cyG6Tlm6mS7qELzLCYjxSgjBQCvvDF14erjX14/GJd2b4rgtvoxo6zI2tnmkaw+vRUDPhPAqS04t9rrsVAvEE83B/SowDb07qxc54I0q2MO0s8Cn48r8PZtwKsBaMGNliSb+aEK66L0rn40xcUenQOyNRtXt/qgeQDZ78sj1cMcjHcbd3cs7vfah0fuAsCl1Yu7qG9aDhD7ZsaU7qHYOFfvgmu6j/ldg7ZoJOoQkRtfLV3g4QG9F+pCl26xbt6YZhH9rQ+mDnvMEuoG+NvU4nKm+DV4t41K65BdTY3BOjXyK+e3GgJ0TyJ58KshgHeO3dtm+EMC7edluEEBXdr0ca2GcgBk5IMYXiyti1NDDSGKXCeIQ4y0vkiSTOok1SdO/rYhEp0UpNJ9VaIwlYJOmka937tqxyePUu1sKI2n80ApyCFt0ygVxwAuLtZ9SuVMAaXibm+i2kKM5+RHAvst3HOeCujj17NrUCkwjyO97x/qNRJrnxuLvc+NxeLnxoIzNxacuTE4C2b9MuKugC5cLzfqKEKG/Iil4EosYyMjprxqqLyvwHVX2UPTZu0pxJ3AN9cJnHOdBG9eFnjnZgD32DvJ3w/guYmAPdcJCsh1OiMGKuSxaHKpIu4IQXQrgZuLlpd5Lmt8DC10SfrRRWUxhiwy7OXE598id3yfhHwJpPDyGider1jwY0ihL4u+1UQogBuDekbwiL2Ja/lGn4C21aXXS+erkHAxTMS858WLvufGca2nXQyT2Oj4PccjixHPjUVjU+MpUGZcEdO4tZvACXimooVpj8T/29rfBl0D99cmdwfXh/VJBPE24i6RbnvYdqtcqsm75gjNqCEqAI/Ds0MBlbNNxfH0az+67xUeQuiCG0MX8oEuT5L4b92TNIh11EXCvTIToiAxxV7vLP8B',1,1,'EVAL','2011-06-19 21:03:17','2011-07-19 21:03:17'),('a93b9170a03ff54d81e95917742ea01b',1,'seo_urls_v2_categories','S0lNy8xL1VB3dgxxdfcPioz3c/R1jTc0VddRUE9NLCrKzEsvVte05krBrs4s3tAcpDQtMTm1pCQ1BY9SE5C6gtS8lMS8ErxGgtQRYa8FSF15ZkmGblJRfl5VKshqAA==',1,1,'EVAL','2011-06-19 21:03:17','2011-07-19 21:03:17'),('4404c1df54fdb1291c8dd9bb259f32a9',1,'seo_urls_v2_manufacturers','hc8/D4JADIfh3U/hdppoIv7FOBGDGwxEZtIcRS7CnSmN+PFN3S3783vT1tg4jwuTJXl5S673skiLKk+ytIo2ZjU3ZnmZ1f9NNG2OQiz44PXWXlwTPrqKRTnPSGDZvVHXZ9Etjh0yr19gn0C1vjjIogsPx2hbnf5+74Fp6uatNHtnKQyhYT16Ejs4JAId7gSOQB5J4Bc=',1,1,'EVAL','2011-06-19 21:03:17','2011-07-19 21:03:17'),('ca34fbe5f9a075091ad59abf02c259a7',2,'seo_urls_v2_products','nZhLbxoxFIX3/RXd0UodCRNeUVdV22Ufqtp15AEHRjFjYgwp+fUdjmcmN0rh2Nnf1/g79wFLc1vV5t3g568fX/58/n3z/dO3rzfTq8GHt4PbylYrXxVbUy91HQbvP75Z/td6fLJeaV+bULiDttxjIjyM9r6qV+fDT0/GW6uruoglGcMzzJ6caP3zDNvrk63emLA+7kJxqxcmBLOk9cyG6Tlm6mS7qELzLCYjxSgjBQCvvDF14erjX14/GJd2b4rgtvoxo6zI2tnmkaw+vRUDPhPAqS04t9rrsVAvEE83B/SowDb07qxc54I0q2MO0s8Cn48r8PZtwKsBaMGNliSb+aEK66L0rn40xcUenQOyNRtXt/qgeQDZ78sj1cMcjHcbd3cs7vfah0fuAsCl1Yu7qG9aDhD7ZsaU7qHYOFfvgmu6j/ldg7ZoJOoQkRtfLV3g4QG9F+pCl26xbt6YZhH9rQ+mDnvMEuoG+NvU4nKm+DV4t41K65BdTY3BOjXyK+e3GgJ0TyJ58KshgHeO3dtm+EMC7edluEEBXdr0ca2GcgBk5IMYXiyti1NDDSGKXCeIQ4y0vkiSTOok1SdO/rYhEp0UpNJ9VaIwlYJOmka937tqxyePUu1sKI2n80ApyCFt0ygVxwAuLtZ9SuVMAaXibm+i2kKM5+RHAvst3HOeCujj17NrUCkwjyO97x/qNRJrnxuLvc+NxeLnxoIzNxacuTE4C2b9MuKugC5cLzfqKEKG/Iil4EosYyMjprxqqLyvwHVX2UPTZu0pxJ3AN9cJnHOdBG9eFnjnZgD32DvJ3w/guYmAPdcJCsh1OiMGKuSxaHKpIu4IQXQrgZuLlpd5Lmt8DC10SfrRRWUxhiwy7OXE598id3yfhHwJpPDyGider1jwY0ihL4u+1UQogBuDekbwiL2Ja/lGn4C21aXXS+erkHAxTMS858WLvufGca2nXQyT2Oj4PccjixHPjUVjU+MpUGZcEdO4tZvACXimooVpj8T/29rfBl0D99cmdwfXh/VJBPE24i6RbnvYdqtcqsm75gjNqCEqAI/Ds0MBlbNNxfH0az+67xUeQuiCG0MX8oEuT5L4b92TNIh11EXCvTIToiAxxV7vLP8B',1,1,'EVAL','2011-07-12 17:18:18','2011-08-11 17:18:18'),('a93b9170a03ff54d81e95917742ea01b',2,'seo_urls_v2_categories','S0lNy8xL1VB3dgxxdfcPioz3c/R1jTc0VddRUE9NLCrKzEsvVte05krBrs4s3tAcpDQtMTm1pCQ1BY9SE5C6gtS8lMS8ErxGgtQRYa8FSF15ZkmGblJRfl5VKshqAA==',1,1,'EVAL','2011-07-12 17:18:18','2011-08-11 17:18:18'),('4404c1df54fdb1291c8dd9bb259f32a9',2,'seo_urls_v2_manufacturers','jdC9DoJAEATg3qewO000Ef+N1cVgBwWRmmyORS7CnVk24uObpfeg/2Z3MiVW1uFCJTrN7/r2yLM4K1KdxEW0Uau5UsvrrPxvoglmO8Hsxs1RiAHnXbjTXlzlv2F1FmUdI4Fh+8GwvoiusW+Qef0G8wIqw4mDJBr/tIymDtNhwxaYxjoPQ7bWkO98xeGjJ/nfWSSCMByW74EcksAf',1,1,'EVAL','2011-07-12 17:18:18','2011-08-11 17:18:18'),('ca34fbe5f9a075091ad59abf02c259a7',4,'seo_urls_v2_products','nZhLbxoxFIX3/RXd0UodCRNeUVdV22Ufqtp15AEHRjFjYgwp+fUdjmcmN0rh2Nnf1/g79wFLc1vV5t3g568fX/58/n3z/dO3rzfTq8GHt4PbylYrXxVbUy91HQbvP75Z/td6fLJeaV+bULiDttxjIjyM9r6qV+fDT0/GW6uruoglGcMzzJ6caP3zDNvrk63emLA+7kJxqxcmBLOk9cyG6Tlm6mS7qELzLCYjxSgjBQCvvDF14erjX14/GJd2b4rgtvoxo6zI2tnmkaw+vRUDPhPAqS04t9rrsVAvEE83B/SowDb07qxc54I0q2MO0s8Cn48r8PZtwKsBaMGNliSb+aEK66L0rn40xcUenQOyNRtXt/qgeQDZ78sj1cMcjHcbd3cs7vfah0fuAsCl1Yu7qG9aDhD7ZsaU7qHYOFfvgmu6j/ldg7ZoJOoQkRtfLV3g4QG9F+pCl26xbt6YZhH9rQ+mDnvMEuoG+NvU4nKm+DV4t41K65BdTY3BOjXyK+e3GgJ0TyJ58KshgHeO3dtm+EMC7edluEEBXdr0ca2GcgBk5IMYXiyti1NDDSGKXCeIQ4y0vkiSTOok1SdO/rYhEp0UpNJ9VaIwlYJOmka937tqxyePUu1sKI2n80ApyCFt0ygVxwAuLtZ9SuVMAaXibm+i2kKM5+RHAvst3HOeCujj17NrUCkwjyO97x/qNRJrnxuLvc+NxeLnxoIzNxacuTE4C2b9MuKugC5cLzfqKEKG/Iil4EosYyMjprxqqLyvwHVX2UPTZu0pxJ3AN9cJnHOdBG9eFnjnZgD32DvJ3w/guYmAPdcJCsh1OiMGKuSxaHKpIu4IQXQrgZuLlpd5Lmt8DC10SfrRRWUxhiwy7OXE598id3yfhHwJpPDyGider1jwY0ihL4u+1UQogBuDekbwiL2Ja/lGn4C21aXXS+erkHAxTMS858WLvufGca2nXQyT2Oj4PccjixHPjUVjU+MpUGZcEdO4tZvACXimooVpj8T/29rfBl0D99cmdwfXh/VJBPE24i6RbnvYdqtcqsm75gjNqCEqAI/Ds0MBlbNNxfH0az+67xUeQuiCG0MX8oEuT5L4b92TNIh11EXCvTIToiAxxV7vLP8B',1,1,'EVAL','2011-07-13 05:16:26','2011-08-12 05:16:26'),('a93b9170a03ff54d81e95917742ea01b',4,'seo_urls_v2_categories','S0lNy8xL1VB3dgxxdfcPioz3c/R1jTc0VddRUE9NLCrKzEsvVte05krBrs4s3tAcpDQtMTm1pCQ1BY9SE5C6gtS8lMS8ErxGgtQRYa8FSF15ZkmGblJRfl5VKshqAA==',1,1,'EVAL','2011-07-13 05:16:26','2011-08-12 05:16:26'),('4404c1df54fdb1291c8dd9bb259f32a9',4,'seo_urls_v2_manufacturers','jdI9D4JADAbg3V/hdppoIn4bJ2Jwg4HITJqjyEW4M6URf76hu8ftTz/ythXWxuJCpXFW3OPbo8iTvMziNCmjjVrNlVpeZ9V/EwWYbYDZBZh9gDkEmGOAOU0baaPBOuvPSNau3devzuNAYxkJNJsP+vVl1A0OLTKv36BfQJW/QoJp3dMw6sZP5aYdME3tLIftjCbXu5r9TSXQ3iAR+KF8wgBkkUb4Aw==',1,1,'EVAL','2011-07-13 05:16:26','2011-08-12 05:16:26');
/*!40000 ALTER TABLE `cache` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cardsave`
--

DROP TABLE IF EXISTS `cardsave`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cardsave` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `cross_reference` varchar(25) NOT NULL,
  `zen_order_id` int(11) NOT NULL,
  `auth_code` varchar(15) NOT NULL,
  `message` varchar(255) DEFAULT NULL,
  `amount_received` varchar(15) DEFAULT NULL,
  `avs_address_numeric_check` varchar(20) DEFAULT NULL,
  `avs_postcode_check` varchar(20) DEFAULT NULL,
  `cv2_check` varchar(20) DEFAULT NULL,
  `threed_secure_check` varchar(20) DEFAULT NULL,
  `gateway_entry_points` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cardsave`
--

LOCK TABLES `cardsave` WRITE;
/*!40000 ALTER TABLE `cardsave` DISABLE KEYS */;
/*!40000 ALTER TABLE `cardsave` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categories`
--

DROP TABLE IF EXISTS `categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `categories` (
  `categories_id` int(11) NOT NULL AUTO_INCREMENT,
  `categories_image` varchar(64) DEFAULT NULL,
  `parent_id` int(11) NOT NULL DEFAULT '0',
  `sort_order` int(3) DEFAULT NULL,
  `date_added` datetime DEFAULT NULL,
  `last_modified` datetime DEFAULT NULL,
  `show_home` varchar(3) NOT NULL,
  PRIMARY KEY (`categories_id`),
  KEY `idx_categories_parent_id` (`parent_id`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categories`
--

LOCK TABLES `categories` WRITE;
/*!40000 ALTER TABLE `categories` DISABLE KEYS */;
INSERT INTO `categories` VALUES (14,'311209.JPG',0,0,'2010-07-31 08:36:26','2010-07-31 09:32:01',''),(15,'112408.JPG',0,0,'2010-07-31 09:36:33',NULL,'Yes'),(16,'212109.JPG',0,0,'2010-07-31 09:58:36',NULL,'Yes'),(17,NULL,16,0,'2010-08-23 04:54:28','2010-08-23 05:01:19','Yes'),(18,NULL,16,0,'2010-08-23 04:55:06',NULL,'');
/*!40000 ALTER TABLE `categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categories_description`
--

DROP TABLE IF EXISTS `categories_description`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `categories_description` (
  `categories_id` int(11) NOT NULL DEFAULT '0',
  `language_id` int(11) NOT NULL DEFAULT '1',
  `categories_name` varchar(32) NOT NULL,
  `categories_htc_title_tag` varchar(80) DEFAULT NULL,
  `categories_htc_desc_tag` longtext,
  `categories_htc_keywords_tag` longtext,
  `categories_htc_description` longtext,
  PRIMARY KEY (`categories_id`,`language_id`),
  KEY `idx_categories_name` (`categories_name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categories_description`
--

LOCK TABLES `categories_description` WRITE;
/*!40000 ALTER TABLE `categories_description` DISABLE KEYS */;
INSERT INTO `categories_description` VALUES (14,1,'Pendants','Pendants','Pendants','Pendants',''),(14,2,'Pendants',NULL,NULL,NULL,NULL),(14,3,'Pendants',NULL,NULL,NULL,NULL),(14,4,'Pendants',NULL,NULL,NULL,NULL),(15,1,'Earrings','Earrings','Earrings','Earrings',''),(15,2,'Earrings',NULL,NULL,NULL,NULL),(15,3,'Earrings',NULL,NULL,NULL,NULL),(15,4,'Earrings',NULL,NULL,NULL,NULL),(16,1,'Rings','Rings','Rings','Rings',''),(16,2,'Rings',NULL,NULL,NULL,NULL),(16,3,'Rings',NULL,NULL,NULL,NULL),(16,4,'Rings',NULL,NULL,NULL,NULL),(17,1,'Facetted','Facetted','Facetted','Facetted',''),(17,2,'Facetted',NULL,NULL,NULL,NULL),(17,3,'Facetted',NULL,NULL,NULL,NULL),(17,4,'Facetted',NULL,NULL,NULL,NULL),(18,1,'With Bronze','With Bronze','With Bronze','With Bronze',''),(18,2,'With Bronze',NULL,NULL,NULL,NULL),(18,3,'With Bronze',NULL,NULL,NULL,NULL),(18,4,'With Bronze',NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `categories_description` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cms`
--

DROP TABLE IF EXISTS `cms`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cms` (
  `page_id` mediumint(9) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`page_id`)
) ENGINE=MyISAM AUTO_INCREMENT=16 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cms`
--

LOCK TABLES `cms` WRITE;
/*!40000 ALTER TABLE `cms` DISABLE KEYS */;
INSERT INTO `cms` VALUES (1),(2),(12),(13),(14),(15);
/*!40000 ALTER TABLE `cms` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cms_description`
--

DROP TABLE IF EXISTS `cms_description`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cms_description` (
  `page_desc_id` int(11) NOT NULL AUTO_INCREMENT,
  `page_name` varchar(100) DEFAULT NULL,
  `page_desc` text NOT NULL,
  `languages_id` tinyint(4) DEFAULT NULL,
  `sort_order` tinyint(4) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `page_id` int(11) NOT NULL,
  PRIMARY KEY (`page_desc_id`)
) ENGINE=MyISAM AUTO_INCREMENT=17 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cms_description`
--

LOCK TABLES `cms_description` WRITE;
/*!40000 ALTER TABLE `cms_description` DISABLE KEYS */;
INSERT INTO `cms_description` VALUES (1,'Astral Jewels: Manufacturers & Wholesalers of handcrafted Jewellery 92.5 Sterling Silver','<div class=\"right\" style=\"margin: 10px 0pt 10px 10px; width: 320px; height: 200px\"><div id=\"peRotator1\" style=\"position: relative\"><img src=\"images/staticimages/shop1.jpg\" border=\"0\" alt=\"Enamel Earring with Stone\" title=\"Enamel Earring with Stone\" /> <img src=\"images/staticimages/shop2.jpg\" border=\"0\" alt=\"Enamel Earring\" title=\"Enamel Earring\" /> <img src=\"images/staticimages/shop3.jpg\" border=\"0\" alt=\"Multistone Bronze Pendant\" title=\"Multistone Bronze Pendant\" /> <img src=\"images/staticimages/shop4.jpg\" border=\"0\" alt=\"Single Stone Earring\" title=\"Single Stone Earring\" /> <img src=\"images/staticimages/shop5.jpg\" border=\"0\" alt=\"Citrine Pendant\" title=\"Citrine Pendant\" /> <img src=\"images/staticimages/shop6.jpg\" border=\"0\" alt=\"Peacock Pendant\" title=\"Peacock Pendant\" /> </div></div><p class=\"floatBugWidthSet\" align=\"justify\">We are manufacturers &amp; wholesalers of exquisite semi-precious jewellery handcrafted in 92.5 sterling silver. Thousands of designs and new additions every month maintain freshness and appeal of our vast product range. Our variety is reflected in the gemstones that cover everything that this world has to offer including amethyst, citrine, moonstone, turquoise, to name a few. These stones, believed to possess cosmic powers, when blended with skills of our traditional and hugely experienced craftsmen, lend a divine touch to our products. </p><p class=\"floatBugWidthSet\" align=\"justify\">Our strength lies in superior quality and extremely competitive pricing.&nbsp;Our established manufacturing base in India&nbsp;guarantees us access to the highest quality raw material and craftsmanship with experience of our craftsmen ranging from 10 to 15 years.</p><p align=\"justify\">We recognize the importance of quick turnaround in industry that we are part of. Our established chain allows us to commit of a delivery time-frame of 4 weeks. Our base in Melbourne allows you to look and feel the products before getting into a transaction. It also gives you an opportunity to inspect the quality of our products before accepting the delivery. </p><p align=\"justify\">Please&nbsp;<a href=\"contact_us.php\" title=\"contact us\"><font color=\"#0000ff\">contact us</font></a> to arrange for login to our portal to check our premium collection online or organize appointment to physcially inspect&nbsp;our&nbsp;extensive range!</p><p align=\"justify\">&nbsp;</p><p align=\"justify\">&nbsp;</p><p align=\"justify\">&nbsp;</p>',1,1,1,1),(2,'Sterling Silver Jewellery Trade Fairs','<p>Astral Jewels is exhibiting at The Reed Gift fair beginning this week (Aug7th- 11th). </p><p>Our entire range will be on display and you will find us at <strong>Stand B5012</strong> in the <strong>Boulevard Pavilion</strong> of the <strong>Melbourne Showgrounds</strong>.<br />&nbsp;<br />We look forward to your visit!</p><p><img src=\"../images/trade-fair.jpg\" border=\"0\" /></p>',1,2,1,2),(13,'','',1,0,1,12),(14,'','',1,0,1,13),(15,'','',1,0,1,14),(16,'','<strong><span style=\"font-size: 9pt; font-family: \'Calibri\',\'sans-serif\'\">Privacy Policy</span></strong><span style=\"font-size: 9pt; font-family: \'Calibri\',\'sans-serif\'\">The following terminology applies to&nbsp;these Terms and Conditions, Privacy Statement and Disclaimer Notice and any or all Agreements:&nbsp;&quot;Client&quot;, &ldquo;You&rdquo; and &ldquo;Your&rdquo; refers to you, the person accessing this website and accepting the Firm&rsquo;s terms and conditions. &quot;The Firm&quot;, &ldquo;Ourselves&rdquo;, &ldquo;We&rdquo; and &quot;Us&quot;, refers to Astral Jewels. &ldquo;Party&rdquo;, &ldquo;Parties&rdquo;, or &ldquo;Us&rdquo;, refers to both the Client and ourselves, or either the Client or ourselves. All terms refer to the offer, acceptance and consideration of payment necessary to undertake the process of our assistance to the Client in the&nbsp;most appropriate manner, whether by formal meetings of a fixed duration, or any other means, for the express purpose of meeting the Client&rsquo;s needs in respect of provision of the Firm&rsquo;s stated services/products, in accordance with and subject to, prevailing Australian Law. Any use of the above terminology or other words in the singular, plural, capitalisation and/or&nbsp;he/she or they, are taken as interchangeable and therefore as referring to same.</span><strong><span style=\"font-size: 9pt; font-family: \'Calibri\',\'sans-serif\'\">&nbsp;</span></strong><strong><span style=\"font-size: 9pt; font-family: \'Calibri\',\'sans-serif\'\">&nbsp;</span></strong><strong><span style=\"font-size: 9pt; font-family: \'Calibri\',\'sans-serif\'\">Privacy Statement</span></strong><span style=\"font-size: 9pt; font-family: \'Calibri\',\'sans-serif\'\">We are committed to protecting your privacy. Authorized employees within the firm on a need to know basis only use any information collected from individual customers. We constantly review our systems and data to ensure the best possible service to our customers. Parliament has created specific offences for unauthorised actions against computer systems and data. We will investigate any such actions with a view to prosecuting and/or taking civil proceedings to recover damages against those responsible</span><strong><span style=\"font-size: 9pt; color: red; font-family: \'Calibri\',\'sans-serif\'\">&nbsp;</span></strong><strong><span style=\"font-size: 9pt; color: red; font-family: \'Calibri\',\'sans-serif\'\"><br /></span></strong><strong><span style=\"font-size: 9pt; color: windowtext; font-family: \'Calibri\',\'sans-serif\'\">Confidentiality</span></strong><span style=\"font-size: 9pt; font-family: \'Calibri\',\'sans-serif\'\">We are registered under the Data Protection Act 1998 and as such, any information concerning the Client and their respective Client Records may be passed to third parties. However, Client records are regarded as confidential and therefore will not be divulged to any third party, other than if legally required to do so to the appropriate authorities. Clients have the right to request sight of, and copies of any and all Client Records we keep, on the proviso that we are given reasonable notice of such a request. Clients are requested to retain copies of any literature issued in relation to the provision of our services. Where appropriate, we shall issue Client&rsquo;s with appropriate written information, handouts or copies of records as part of an agreed contract, for the benefit of both parties.</span><strong><span style=\"font-size: 9pt; color: red; font-family: \'Calibri\',\'sans-serif\'\">&nbsp;</span></strong><strong><span style=\"font-size: 9pt; font-family: \'Calibri\',\'sans-serif\'\">We will not sell, share, or rent your personal information to any third party or use your e-mail address for unsolicited mail. Any emails sent by this Firm will only be in connection with the provision of agreed services and products.</span></strong><strong><span style=\"font-size: 9pt; font-family: \'Calibri\',\'sans-serif\'\">&nbsp;</span></strong><span style=\"font-size: 9pt; font-family: \'Calibri\',\'sans-serif\'\">&copy; Astral Jewels 2010 All Rights Reserved</span><strong><span style=\"font-size: 9pt; font-family: \'Calibri\',\'sans-serif\'\">&nbsp;</span></strong><strong><span style=\"font-size: 9pt; font-family: \'Calibri\',\'sans-serif\'\">&nbsp;</span></strong>',1,0,0,15);
/*!40000 ALTER TABLE `cms_description` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `configuration`
--

DROP TABLE IF EXISTS `configuration`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `configuration` (
  `configuration_id` int(11) NOT NULL AUTO_INCREMENT,
  `configuration_title` varchar(255) NOT NULL,
  `configuration_key` varchar(255) NOT NULL,
  `configuration_value` varchar(255) NOT NULL,
  `configuration_description` varchar(255) NOT NULL,
  `configuration_group_id` int(11) NOT NULL,
  `sort_order` int(5) DEFAULT NULL,
  `last_modified` datetime DEFAULT NULL,
  `date_added` datetime NOT NULL,
  `use_function` varchar(255) DEFAULT NULL,
  `set_function` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`configuration_id`)
) ENGINE=InnoDB AUTO_INCREMENT=326 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `configuration`
--

LOCK TABLES `configuration` WRITE;
/*!40000 ALTER TABLE `configuration` DISABLE KEYS */;
INSERT INTO `configuration` VALUES (1,'Store Name','STORE_NAME','Astral Jewels','The name of my store',1,1,'2011-02-11 23:52:51','2010-01-11 15:17:35',NULL,NULL),(2,'Store Owner','STORE_OWNER','Astral Jewels','The name of my store owner',1,2,'2010-06-30 13:07:51','2010-01-11 15:17:35',NULL,NULL),(3,'E-Mail Address','STORE_OWNER_EMAIL_ADDRESS','payal@astraljewels.com.au','The e-mail address of my store owner',1,3,'2010-08-04 07:22:13','2010-01-11 15:17:35',NULL,NULL),(4,'E-Mail From','EMAIL_FROM','payal@astraljewels.com.au','The e-mail address used in (sent) e-mails',1,4,'2010-08-30 08:35:48','2010-01-11 15:17:35',NULL,NULL),(5,'Country','STORE_COUNTRY','13','The country my store is located in <br><br><b>Note: Please remember to update the store zone.</b>',1,6,'2010-08-16 02:15:47','2010-01-11 15:17:35','tep_get_country_name','tep_cfg_pull_down_country_list('),(6,'Zone','STORE_ZONE','18','The zone my store is located in',1,7,NULL,'2010-01-11 15:17:35','tep_cfg_get_zone_name','tep_cfg_pull_down_zone_list('),(7,'Expected Sort Order','EXPECTED_PRODUCTS_SORT','desc','This is the sort order used in the expected products box.',1,8,NULL,'2010-01-11 15:17:35',NULL,'tep_cfg_select_option(array(\'asc\', \'desc\'), '),(8,'Expected Sort Field','EXPECTED_PRODUCTS_FIELD','date_expected','The column to sort by in the expected products box.',1,9,NULL,'2010-01-11 15:17:35',NULL,'tep_cfg_select_option(array(\'products_name\', \'date_expected\'), '),(9,'Switch To Default Language Currency','USE_DEFAULT_LANGUAGE_CURRENCY','false','Automatically switch to the language\'s currency when it is changed',1,10,NULL,'2010-01-11 15:17:35',NULL,'tep_cfg_select_option(array(\'true\', \'false\'), '),(10,'Send Extra Order Emails To','SEND_EXTRA_ORDER_EMAILS_TO','','Send extra order emails to the following email addresses, in this format: Name 1 &lt;email@address1&gt;, Name 2 &lt;email@address2&gt;',1,11,NULL,'2010-01-11 15:17:35',NULL,NULL),(11,'Use Search-Engine Safe URLs (still in development)','SEARCH_ENGINE_FRIENDLY_URLS','false','Use search-engine safe urls for all site links',1,12,NULL,'2010-01-11 15:17:35',NULL,'tep_cfg_select_option(array(\'true\', \'false\'), '),(12,'Display Cart After Adding Product','DISPLAY_CART','true','Display the shopping cart after adding a product (or return back to their origin)',1,14,NULL,'2010-01-11 15:17:35',NULL,'tep_cfg_select_option(array(\'true\', \'false\'), '),(13,'Allow Guest To Tell A Friend','ALLOW_GUEST_TO_TELL_A_FRIEND','true','Allow guests to tell a friend about a product',1,15,'2010-05-21 08:48:01','2010-01-11 15:17:35',NULL,'tep_cfg_select_option(array(\'true\', \'false\'), '),(14,'Default Search Operator','ADVANCED_SEARCH_DEFAULT_OPERATOR','and','Default search operators',1,17,NULL,'2010-01-11 15:17:35',NULL,'tep_cfg_select_option(array(\'and\', \'or\'), '),(15,'Store Address and Phone','STORE_NAME_ADDRESS','Store Name\nAddress\nCountry\nPhone','This is the Store Name, Address and Phone used on printable documents and displayed online',1,18,NULL,'2010-01-11 15:17:35',NULL,'tep_cfg_textarea('),(16,'Show Category Counts','SHOW_COUNTS','true','Count recursively how many products are in each category',1,19,NULL,'2010-01-11 15:17:35',NULL,'tep_cfg_select_option(array(\'true\', \'false\'), '),(17,'Tax Decimal Places','TAX_DECIMAL_PLACES','0','Pad the tax value this amount of decimal places',1,20,NULL,'2010-01-11 15:17:35',NULL,NULL),(18,'Display Prices with Tax','DISPLAY_PRICE_WITH_TAX','false','Display prices with tax included (true) or add the tax at the end (false)',1,21,NULL,'2010-01-11 15:17:35',NULL,'tep_cfg_select_option(array(\'true\', \'false\'), '),(19,'First Name','ENTRY_FIRST_NAME_MIN_LENGTH','2','Minimum length of first name',2,1,NULL,'2010-01-11 15:17:35',NULL,NULL),(20,'Last Name','ENTRY_LAST_NAME_MIN_LENGTH','2','Minimum length of last name',2,2,NULL,'2010-01-11 15:17:35',NULL,NULL),(21,'Date of Birth','ENTRY_DOB_MIN_LENGTH','10','Minimum length of date of birth',2,3,NULL,'2010-01-11 15:17:35',NULL,NULL),(22,'E-Mail Address','ENTRY_EMAIL_ADDRESS_MIN_LENGTH','6','Minimum length of e-mail address',2,4,NULL,'2010-01-11 15:17:35',NULL,NULL),(23,'Street Address','ENTRY_STREET_ADDRESS_MIN_LENGTH','5','Minimum length of street address',2,5,NULL,'2010-01-11 15:17:35',NULL,NULL),(24,'Company','ENTRY_COMPANY_MIN_LENGTH','2','Minimum length of company name',2,6,NULL,'2010-01-11 15:17:35',NULL,NULL),(25,'Post Code','ENTRY_POSTCODE_MIN_LENGTH','4','Minimum length of post code',2,7,NULL,'2010-01-11 15:17:35',NULL,NULL),(26,'City','ENTRY_CITY_MIN_LENGTH','3','Minimum length of city',2,8,NULL,'2010-01-11 15:17:35',NULL,NULL),(27,'State','ENTRY_STATE_MIN_LENGTH','2','Minimum length of state',2,9,NULL,'2010-01-11 15:17:35',NULL,NULL),(28,'Telephone Number','ENTRY_TELEPHONE_MIN_LENGTH','3','Minimum length of telephone number',2,10,NULL,'2010-01-11 15:17:35',NULL,NULL),(29,'Password','ENTRY_PASSWORD_MIN_LENGTH','5','Minimum length of password',2,11,NULL,'2010-01-11 15:17:36',NULL,NULL),(30,'Credit Card Owner Name','CC_OWNER_MIN_LENGTH','3','Minimum length of credit card owner name',2,12,NULL,'2010-01-11 15:17:36',NULL,NULL),(31,'Credit Card Number','CC_NUMBER_MIN_LENGTH','10','Minimum length of credit card number',2,13,NULL,'2010-01-11 15:17:36',NULL,NULL),(32,'Review Text','REVIEW_TEXT_MIN_LENGTH','50','Minimum length of review text',2,14,NULL,'2010-01-11 15:17:36',NULL,NULL),(33,'Best Sellers','MIN_DISPLAY_BESTSELLERS','1','Minimum number of best sellers to display',2,15,NULL,'2010-01-11 15:17:36',NULL,NULL),(34,'Also Purchased','MIN_DISPLAY_ALSO_PURCHASED','1','Minimum number of products to display in the \'This Customer Also Purchased\' box',2,16,NULL,'2010-01-11 15:17:36',NULL,NULL),(35,'Address Book Entries','MAX_ADDRESS_BOOK_ENTRIES','5','Maximum address book entries a customer is allowed to have',3,1,NULL,'2010-01-11 15:17:36',NULL,NULL),(36,'Search Results','MAX_DISPLAY_SEARCH_RESULTS','30','Amount of products to list',3,2,'2010-08-03 09:25:56','2010-01-11 15:17:36',NULL,NULL),(37,'Page Links','MAX_DISPLAY_PAGE_LINKS','5','Number of \'number\' links use for page-sets',3,3,NULL,'2010-01-11 15:17:36',NULL,NULL),(38,'Special Products','MAX_DISPLAY_SPECIAL_PRODUCTS','9','Maximum number of products on special to display',3,4,NULL,'2010-01-11 15:17:36',NULL,NULL),(39,'New Products Module','MAX_DISPLAY_NEW_PRODUCTS','9','Maximum number of new products to display in a category',3,5,NULL,'2010-01-11 15:17:36',NULL,NULL),(40,'Products Expected','MAX_DISPLAY_UPCOMING_PRODUCTS','10','Maximum number of products expected to display',3,6,NULL,'2010-01-11 15:17:36',NULL,NULL),(41,'Manufacturers List','MAX_DISPLAY_MANUFACTURERS_IN_A_LIST','0','Used in manufacturers box; when the number of manufacturers exceeds this number, a drop-down list will be displayed instead of the default list',3,7,NULL,'2010-01-11 15:17:36',NULL,NULL),(42,'Manufacturers Select Size','MAX_MANUFACTURERS_LIST','1','Used in manufacturers box; when this value is \'1\' the classic drop-down list will be used for the manufacturers box. Otherwise, a list-box with the specified number of rows will be displayed.',3,7,NULL,'2010-01-11 15:17:36',NULL,NULL),(43,'Length of Manufacturers Name','MAX_DISPLAY_MANUFACTURER_NAME_LEN','15','Used in manufacturers box; maximum length of manufacturers name to display',3,8,NULL,'2010-01-11 15:17:36',NULL,NULL),(44,'New Reviews','MAX_DISPLAY_NEW_REVIEWS','6','Maximum number of new reviews to display',3,9,NULL,'2010-01-11 15:17:36',NULL,NULL),(45,'Selection of Random Reviews','MAX_RANDOM_SELECT_REVIEWS','10','How many records to select from to choose one random product review',3,10,NULL,'2010-01-11 15:17:36',NULL,NULL),(46,'Selection of Random New Products','MAX_RANDOM_SELECT_NEW','10','How many records to select from to choose one random new product to display',3,11,NULL,'2010-01-11 15:17:36',NULL,NULL),(47,'Selection of Products on Special','MAX_RANDOM_SELECT_SPECIALS','10','How many records to select from to choose one random product special to display',3,12,NULL,'2010-01-11 15:17:36',NULL,NULL),(48,'Categories To List Per Row','MAX_DISPLAY_CATEGORIES_PER_ROW','3','How many categories to list per row',3,13,NULL,'2010-01-11 15:17:36',NULL,NULL),(49,'New Products Listing','MAX_DISPLAY_PRODUCTS_NEW','10','Maximum number of new products to display in new products page',3,14,NULL,'2010-01-11 15:17:36',NULL,NULL),(50,'Best Sellers','MAX_DISPLAY_BESTSELLERS','10','Maximum number of best sellers to display',3,15,NULL,'2010-01-11 15:17:36',NULL,NULL),(51,'Also Purchased','MAX_DISPLAY_ALSO_PURCHASED','6','Maximum number of products to display in the \'This Customer Also Purchased\' box',3,16,NULL,'2010-01-11 15:17:36',NULL,NULL),(52,'Customer Order History Box','MAX_DISPLAY_PRODUCTS_IN_ORDER_HISTORY_BOX','6','Maximum number of products to display in the customer order history box',3,17,NULL,'2010-01-11 15:17:36',NULL,NULL),(53,'Order History','MAX_DISPLAY_ORDER_HISTORY','10','Maximum number of orders to display in the order history page',3,18,NULL,'2010-01-11 15:17:36',NULL,NULL),(54,'Product Quantities In Shopping Cart','MAX_QTY_IN_CART','99','Maximum number of product quantities that can be added to the shopping cart (0 for no limit)',3,19,NULL,'2010-01-11 15:17:36',NULL,NULL),(55,'Small Image Width','SMALL_IMAGE_WIDTH','60','The pixel width of small images',4,1,'2010-07-26 12:51:59','2010-01-11 15:17:36',NULL,NULL),(56,'Small Image Height','SMALL_IMAGE_HEIGHT','60','The pixel height of small images',4,2,'2010-07-26 12:52:21','2010-01-11 15:17:36',NULL,NULL),(57,'Heading Image Width','HEADING_IMAGE_WIDTH','57','The pixel width of heading images',4,3,NULL,'2010-01-11 15:17:36',NULL,NULL),(58,'Heading Image Height','HEADING_IMAGE_HEIGHT','40','The pixel height of heading images',4,4,NULL,'2010-01-11 15:17:36',NULL,NULL),(59,'Subcategory Image Width','SUBCATEGORY_IMAGE_WIDTH','100','The pixel width of subcategory images',4,5,NULL,'2010-01-11 15:17:36',NULL,NULL),(60,'Subcategory Image Height','SUBCATEGORY_IMAGE_HEIGHT','57','The pixel height of subcategory images',4,6,NULL,'2010-01-11 15:17:36',NULL,NULL),(61,'Calculate Image Size','CONFIG_CALCULATE_IMAGE_SIZE','true','Calculate the size of images?',4,7,NULL,'2010-01-11 15:17:36',NULL,'tep_cfg_select_option(array(\'true\', \'false\'), '),(62,'Image Required','IMAGE_REQUIRED','true','Enable to display broken images. Good for development.',4,8,NULL,'2010-01-11 15:17:36',NULL,'tep_cfg_select_option(array(\'true\', \'false\'), '),(63,'Gender','ACCOUNT_GENDER','false','Display gender in the customers account',5,1,'2010-07-04 03:28:05','2010-01-11 15:17:36',NULL,'tep_cfg_select_option(array(\'true\', \'false\'), '),(64,'Date of Birth','ACCOUNT_DOB','false','Display date of birth in the customers account',5,2,'2010-07-04 03:29:10','2010-01-11 15:17:36',NULL,'tep_cfg_select_option(array(\'true\', \'false\'), '),(65,'Company','ACCOUNT_COMPANY','true','Display company in the customers account',5,3,NULL,'2010-01-11 15:17:36',NULL,'tep_cfg_select_option(array(\'true\', \'false\'), '),(66,'Suburb','ACCOUNT_SUBURB','false','Display suburb in the customers account',5,4,'2010-11-22 21:45:32','2010-01-11 15:17:36',NULL,'tep_cfg_select_option(array(\'true\', \'false\'), '),(67,'State','ACCOUNT_STATE','true','Display state in the customers account',5,5,NULL,'2010-01-11 15:17:36',NULL,'tep_cfg_select_option(array(\'true\', \'false\'), '),(68,'Installed Modules','MODULE_PAYMENT_INSTALLED','cod.php;paypal_standard.php','List of payment module filenames separated by a semi-colon. This is automatically updated. No need to edit. (Example: cc.php;cod.php;paypal.php)',6,0,'2010-07-22 21:05:10','2010-01-11 15:17:36',NULL,NULL),(69,'Installed Modules','MODULE_ORDER_TOTAL_INSTALLED','ot_subtotal.php;ot_shipping.php;ot_tax.php;ot_total.php','List of order_total module filenames separated by a semi-colon. This is automatically updated. No need to edit. (Example: ot_subtotal.php;ot_tax.php;ot_shipping.php;ot_total.php)',6,0,'2011-05-22 07:22:12','2010-01-11 15:17:36',NULL,NULL),(70,'Installed Modules','MODULE_SHIPPING_INSTALLED','table.php','List of shipping module filenames separated by a semi-colon. This is automatically updated. No need to edit. (Example: ups.php;flat.php;item.php)',6,0,'2010-05-25 19:29:33','2010-01-11 15:17:36',NULL,NULL),(85,'Default Currency','DEFAULT_CURRENCY','AUD','Default Currency',6,0,NULL,'2010-01-11 15:17:37',NULL,NULL),(86,'Default Language','DEFAULT_LANGUAGE','en','Default Language',6,0,NULL,'2010-01-11 15:17:37',NULL,NULL),(87,'Default Order Status For New Orders','DEFAULT_ORDERS_STATUS_ID','1','When a new order is created, this order status will be assigned to it.',6,0,NULL,'2010-01-11 15:17:37',NULL,NULL),(88,'Display Shipping','MODULE_ORDER_TOTAL_SHIPPING_STATUS','true','Do you want to display the order shipping cost?',6,1,NULL,'2010-01-11 15:17:37',NULL,'tep_cfg_select_option(array(\'true\', \'false\'), '),(89,'Sort Order','MODULE_ORDER_TOTAL_SHIPPING_SORT_ORDER','2','Sort order of display.',6,2,NULL,'2010-01-11 15:17:37',NULL,NULL),(90,'Allow Free Shipping','MODULE_ORDER_TOTAL_SHIPPING_FREE_SHIPPING','false','Do you want to allow free shipping?',6,3,NULL,'2010-01-11 15:17:37',NULL,'tep_cfg_select_option(array(\'true\', \'false\'), '),(91,'Free Shipping For Orders Over','MODULE_ORDER_TOTAL_SHIPPING_FREE_SHIPPING_OVER','50','Provide free shipping for orders over the set amount.',6,4,NULL,'2010-01-11 15:17:37','currencies->format',NULL),(92,'Provide Free Shipping For Orders Made','MODULE_ORDER_TOTAL_SHIPPING_DESTINATION','national','Provide free shipping for orders sent to the set destination.',6,5,NULL,'2010-01-11 15:17:37',NULL,'tep_cfg_select_option(array(\'national\', \'international\', \'both\'), '),(93,'Display Sub-Total','MODULE_ORDER_TOTAL_SUBTOTAL_STATUS','true','Do you want to display the order sub-total cost?',6,1,NULL,'2010-01-11 15:17:37',NULL,'tep_cfg_select_option(array(\'true\', \'false\'), '),(94,'Sort Order','MODULE_ORDER_TOTAL_SUBTOTAL_SORT_ORDER','1','Sort order of display.',6,2,NULL,'2010-01-11 15:17:37',NULL,NULL),(95,'Display Tax','MODULE_ORDER_TOTAL_TAX_STATUS','true','Do you want to display the order tax value?',6,1,NULL,'2010-01-11 15:17:37',NULL,'tep_cfg_select_option(array(\'true\', \'false\'), '),(96,'Sort Order','MODULE_ORDER_TOTAL_TAX_SORT_ORDER','3','Sort order of display.',6,2,NULL,'2010-01-11 15:17:37',NULL,NULL),(97,'Display Total','MODULE_ORDER_TOTAL_TOTAL_STATUS','true','Do you want to display the total order value?',6,1,NULL,'2010-01-11 15:17:37',NULL,'tep_cfg_select_option(array(\'true\', \'false\'), '),(98,'Sort Order','MODULE_ORDER_TOTAL_TOTAL_SORT_ORDER','4','Sort order of display.',6,2,NULL,'2010-01-11 15:17:37',NULL,NULL),(99,'Country of Origin','SHIPPING_ORIGIN_COUNTRY','223','Select the country of origin to be used in shipping quotes.',7,1,NULL,'2010-01-11 15:17:37','tep_get_country_name','tep_cfg_pull_down_country_list('),(100,'Postal Code','SHIPPING_ORIGIN_ZIP','NONE','Enter the Postal Code (ZIP) of the Store to be used in shipping quotes.',7,2,NULL,'2010-01-11 15:17:37',NULL,NULL),(101,'Enter the Maximum Package Weight you will ship','SHIPPING_MAX_WEIGHT','50','Carriers have a max weight limit for a single package. This is a common one for all.',7,3,NULL,'2010-01-11 15:17:37',NULL,NULL),(102,'Package Tare weight.','SHIPPING_BOX_WEIGHT','0','What is the weight of typical packaging of small to medium packages?',7,4,'2010-05-25 19:25:23','2010-01-11 15:17:37',NULL,NULL),(103,'Larger packages - percentage increase.','SHIPPING_BOX_PADDING','0','For 10% enter 10',7,5,'2010-05-25 19:26:28','2010-01-11 15:17:37',NULL,NULL),(104,'Display Product Image','PRODUCT_LIST_IMAGE','1','Do you want to display the Product Image?',8,1,NULL,'2010-01-11 15:17:37',NULL,NULL),(105,'Display Product Manufaturer Name','PRODUCT_LIST_MANUFACTURER','0','Do you want to display the Product Manufacturer Name?',8,2,NULL,'2010-01-11 15:17:37',NULL,NULL),(106,'Display Product Model','PRODUCT_LIST_MODEL','0','Do you want to display the Product Model?',8,3,NULL,'2010-01-11 15:17:37',NULL,NULL),(107,'Display Product Name','PRODUCT_LIST_NAME','2','Do you want to display the Product Name?',8,4,NULL,'2010-01-11 15:17:37',NULL,NULL),(108,'Display Product Price','PRODUCT_LIST_PRICE','3','Do you want to display the Product Price',8,5,NULL,'2010-01-11 15:17:37',NULL,NULL),(109,'Display Product Quantity','PRODUCT_LIST_QUANTITY','0','Do you want to display the Product Quantity?',8,6,NULL,'2010-01-11 15:17:37',NULL,NULL),(110,'Display Product Weight','PRODUCT_LIST_WEIGHT','0','Do you want to display the Product Weight?',8,7,NULL,'2010-01-11 15:17:37',NULL,NULL),(111,'Display Buy Now column','PRODUCT_LIST_BUY_NOW','4','Do you want to display the Buy Now column?',8,8,NULL,'2010-01-11 15:17:37',NULL,NULL),(112,'Display Category/Manufacturer Filter (0=disable; 1=enable)','PRODUCT_LIST_FILTER','1','Do you want to display the Category/Manufacturer Filter?',8,9,NULL,'2010-01-11 15:17:37',NULL,NULL),(113,'Location of Prev/Next Navigation Bar (1-top, 2-bottom, 3-both)','PREV_NEXT_BAR_LOCATION','2','Sets the location of the Prev/Next Navigation Bar (1-top, 2-bottom, 3-both)',8,10,NULL,'2010-01-11 15:17:37',NULL,NULL),(114,'Check stock level','STOCK_CHECK','true','Check to see if sufficent stock is available',9,1,NULL,'2010-01-11 15:17:37',NULL,'tep_cfg_select_option(array(\'true\', \'false\'), '),(115,'Subtract stock','STOCK_LIMITED','true','Subtract product in stock by product orders',9,2,NULL,'2010-01-11 15:17:37',NULL,'tep_cfg_select_option(array(\'true\', \'false\'), '),(116,'Allow Checkout','STOCK_ALLOW_CHECKOUT','true','Allow customer to checkout even if there is insufficient stock',9,3,NULL,'2010-01-11 15:17:37',NULL,'tep_cfg_select_option(array(\'true\', \'false\'), '),(117,'Mark product out of stock','STOCK_MARK_PRODUCT_OUT_OF_STOCK','***','Display something on screen so customer can see which product has insufficient stock',9,4,NULL,'2010-01-11 15:17:37',NULL,NULL),(118,'Stock Re-order level','STOCK_REORDER_LEVEL','5','Define when stock needs to be re-ordered',9,5,NULL,'2010-01-11 15:17:37',NULL,NULL),(119,'Store Page Parse Time','STORE_PAGE_PARSE_TIME','false','Store the time it takes to parse a page',10,1,NULL,'2010-01-11 15:17:37',NULL,'tep_cfg_select_option(array(\'true\', \'false\'), '),(120,'Log Destination','STORE_PAGE_PARSE_TIME_LOG','/var/log/www/tep/page_parse_time.log','Directory and filename of the page parse time log',10,2,NULL,'2010-01-11 15:17:37',NULL,NULL),(121,'Log Date Format','STORE_PARSE_DATE_TIME_FORMAT','%d/%m/%Y %H:%M:%S','The date format',10,3,NULL,'2010-01-11 15:17:37',NULL,NULL),(122,'Display The Page Parse Time','DISPLAY_PAGE_PARSE_TIME','true','Display the page parse time (store page parse time must be enabled)',10,4,NULL,'2010-01-11 15:17:37',NULL,'tep_cfg_select_option(array(\'true\', \'false\'), '),(123,'Store Database Queries','STORE_DB_TRANSACTIONS','false','Store the database queries in the page parse time log (PHP4 only)',10,5,NULL,'2010-01-11 15:17:37',NULL,'tep_cfg_select_option(array(\'true\', \'false\'), '),(124,'Use Cache','USE_CACHE','false','Use caching features',11,1,NULL,'2010-01-11 15:17:37',NULL,'tep_cfg_select_option(array(\'true\', \'false\'), '),(125,'Cache Directory','DIR_FS_CACHE','/tmp/','The directory where the cached files are saved',11,2,NULL,'2010-01-11 15:17:37',NULL,NULL),(126,'E-Mail Transport Method','EMAIL_TRANSPORT','sendmail','Defines if this server uses a local connection to sendmail or uses an SMTP connection via TCP/IP. Servers running on Windows and MacOS should change this setting to SMTP.',12,1,NULL,'2010-01-11 15:17:37',NULL,'tep_cfg_select_option(array(\'sendmail\', \'smtp\'),'),(127,'E-Mail Linefeeds','EMAIL_LINEFEED','LF','Defines the character sequence used to separate mail headers.',12,2,NULL,'2010-01-11 15:17:37',NULL,'tep_cfg_select_option(array(\'LF\', \'CRLF\'),'),(128,'Use MIME HTML When Sending Emails','EMAIL_USE_HTML','false','Send e-mails in HTML format',12,3,NULL,'2010-01-11 15:17:37',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),(129,'Verify E-Mail Addresses Through DNS','ENTRY_EMAIL_ADDRESS_CHECK','false','Verify e-mail address through a DNS server',12,4,NULL,'2010-01-11 15:17:37',NULL,'tep_cfg_select_option(array(\'true\', \'false\'), '),(130,'Send E-Mails','SEND_EMAILS','true','Send out e-mails',12,5,NULL,'2010-01-11 15:17:37',NULL,'tep_cfg_select_option(array(\'true\', \'false\'), '),(131,'Enable download','DOWNLOAD_ENABLED','false','Enable the products download functions.',13,1,NULL,'2010-01-11 15:17:37',NULL,'tep_cfg_select_option(array(\'true\', \'false\'), '),(132,'Download by redirect','DOWNLOAD_BY_REDIRECT','false','Use browser redirection for download. Disable on non-Unix systems.',13,2,NULL,'2010-01-11 15:17:37',NULL,'tep_cfg_select_option(array(\'true\', \'false\'), '),(133,'Expiry delay (days)','DOWNLOAD_MAX_DAYS','7','Set number of days before the download link expires. 0 means no limit.',13,3,NULL,'2010-01-11 15:17:37',NULL,''),(134,'Maximum number of downloads','DOWNLOAD_MAX_COUNT','5','Set the maximum number of downloads. 0 means no download authorized.',13,4,NULL,'2010-01-11 15:17:37',NULL,''),(135,'Enable GZip Compression','GZIP_COMPRESSION','false','Enable HTTP GZip compression.',14,1,NULL,'2010-01-11 15:17:37',NULL,'tep_cfg_select_option(array(\'true\', \'false\'), '),(136,'Compression Level','GZIP_LEVEL','5','Use this compression level 0-9 (0 = minimum, 9 = maximum).',14,2,NULL,'2010-01-11 15:17:37',NULL,NULL),(137,'Session Directory','SESSION_WRITE_DIRECTORY','/tmp','If sessions are file based, store them in this directory.',15,1,NULL,'2010-01-11 15:17:37',NULL,NULL),(138,'Force Cookie Use','SESSION_FORCE_COOKIE_USE','False','Force the use of sessions when cookies are only enabled.',15,2,NULL,'2010-01-11 15:17:38',NULL,'tep_cfg_select_option(array(\'True\', \'False\'), '),(139,'Check SSL Session ID','SESSION_CHECK_SSL_SESSION_ID','False','Validate the SSL_SESSION_ID on every secure HTTPS page request.',15,3,NULL,'2010-01-11 15:17:38',NULL,'tep_cfg_select_option(array(\'True\', \'False\'), '),(140,'Check User Agent','SESSION_CHECK_USER_AGENT','False','Validate the clients browser user agent on every page request.',15,4,NULL,'2010-01-11 15:17:38',NULL,'tep_cfg_select_option(array(\'True\', \'False\'), '),(141,'Check IP Address','SESSION_CHECK_IP_ADDRESS','False','Validate the clients IP address on every page request.',15,5,NULL,'2010-01-11 15:17:38',NULL,'tep_cfg_select_option(array(\'True\', \'False\'), '),(142,'Prevent Spider Sessions','SESSION_BLOCK_SPIDERS','True','Prevent known spiders from starting a session.',15,6,NULL,'2010-01-11 15:17:38',NULL,'tep_cfg_select_option(array(\'True\', \'False\'), '),(143,'Recreate Session','SESSION_RECREATE','False','Recreate the session to generate a new session ID when the customer logs on or creates an account (PHP >=4.1 needed).',15,7,NULL,'2010-01-11 15:17:38',NULL,'tep_cfg_select_option(array(\'True\', \'False\'), '),(144,'Enable SEO URLs?','SEO_ENABLED','true','Enable the SEO URLs?  This is a global setting and will turn them off completely.',16,0,'2010-01-12 11:16:07','2010-01-12 11:16:07',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),(145,'Add category parent to product URLs?','SEO_ADD_CPATH_TO_PRODUCT_URLS','false','This setting will append the category parent(s) name to the product URLs (i.e. - parent-some-product-p-1.html).',16,1,'2010-01-12 11:16:07','2010-01-12 11:16:07',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),(146,'Add category parent to begining of URLs?','SEO_ADD_CAT_PARENT','false','This setting will add the category parent(s) name to the beginning of the category URLs (i.e. - parent-category-c-1.html).',16,2,'2010-01-12 11:16:07','2010-01-12 11:16:07',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),(147,'Filter Short Words','SEO_URLS_FILTER_SHORT_WORDS','3','This setting will filter words less than or equal to the value from the URL.',16,3,'2010-01-12 11:16:07','2010-01-12 11:16:07',NULL,NULL),(148,'Output W3C valid URLs (parameter string)?','SEO_URLS_USE_W3C_VALID','true','This setting will output W3C valid URLs.',16,4,'2010-01-12 11:16:07','2010-01-12 11:16:07',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),(149,'Enable SEO cache to save queries?','USE_SEO_CACHE_GLOBAL','true','This is a global setting and will turn off caching completely.',16,5,'2010-01-12 11:16:07','2010-01-12 11:16:07',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),(150,'Enable product cache?','USE_SEO_CACHE_PRODUCTS','true','This will turn off caching for the products.',16,6,'2010-01-12 11:16:07','2010-01-12 11:16:07',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),(151,'Enable categories cache?','USE_SEO_CACHE_CATEGORIES','true','This will turn off caching for the categories.',16,7,'2010-01-12 11:16:07','2010-01-12 11:16:07',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),(152,'Enable manufacturers cache?','USE_SEO_CACHE_MANUFACTURERS','true','This will turn off caching for the manufacturers.',16,8,'2010-01-12 11:16:07','2010-01-12 11:16:07',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),(153,'Enable all products seo cache?','USE_SEO_CACHE_ALL_PRODUCTS','true','This will turn off caching for the all products seo pages.',16,9,'2010-01-12 11:16:07','2010-01-12 11:16:07',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),(154,'Enable articles cache?','USE_SEO_CACHE_ARTICLES','true','This will turn off caching for the articles.',16,10,'2010-01-12 11:16:07','2010-01-12 11:16:07',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),(155,'Enable topics cache?','USE_SEO_CACHE_TOPICS','true','This will turn off caching for the article topics.',16,11,'2010-01-12 11:16:07','2010-01-12 11:16:07',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),(156,'Enable information cache?','USE_SEO_CACHE_INFO_PAGES','true','This will turn off caching for the information pages.',16,12,'2010-01-12 11:16:07','2010-01-12 11:16:07',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),(157,'Enable link directory cache?','USE_SEO_CACHE_LINKS','true','This will turn off caching for the link category pages.',16,13,'2010-01-12 11:16:07','2010-01-12 11:16:07',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),(158,'Enable automatic redirects?','USE_SEO_REDIRECT','true','This will activate the automatic redirect code and send 301 headers for old to new URLs.',16,14,'2010-01-12 11:16:07','2010-01-12 11:16:07',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),(159,'Enable use Header Tags as name?','USE_SEO_HEADER_TAGS','false','This will cause the title set in Header Tags to be used instead of the categories or products name.',16,15,'2010-01-12 11:16:07','2010-01-12 11:16:07',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),(160,'Choose URL Rewrite Type','SEO_REWRITE_TYPE','Rewrite','Choose which SEO URL format to use.',16,16,'2010-01-12 11:16:07','2010-01-12 11:16:07',NULL,'tep_cfg_select_option(array(\'Rewrite\'),'),(161,'Enter special character conversions','SEO_CHAR_CONVERT_SET','','This setting will convert characters.<br><br>The format <b>MUST</b> be in the form: <b>char=>conv,char2=>conv2</b>',16,17,'2010-01-12 11:16:07','2010-01-12 11:16:07',NULL,NULL),(162,'Remove all non-alphanumeric characters?','SEO_REMOVE_ALL_SPEC_CHARS','false','This will remove all non-letters and non-numbers.  This should be handy to remove all special characters with 1 setting.',16,18,'2010-01-12 11:16:07','2010-01-12 11:16:07',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),(163,'Reset SEO URLs Cache','SEO_URLS_CACHE_RESET','false','This will reset the cache data for SEO',16,19,'2010-01-12 11:16:07','2010-01-12 11:16:07','tep_reset_cache_data_seo_urls','tep_cfg_select_option(array(\'reset\', \'false\'),'),(164,'Uninstall Ultimate SEO','SEO_URLS_DB_UNINSTALL','false','This will delete all of the entries in the configuration table for SEO',16,20,'2010-01-12 11:16:07','2010-01-12 11:16:07','tep_reset_cache_data_seo_urls','tep_cfg_select_option(array(\'uninstall\', \'false\'),'),(165,'Automatically Add New Pages','HEADER_TAGS_AUTO_ADD_PAGES','true','Adds any new pages when Page Control is accessed<br>(true=on false=off)',543,3,NULL,'2010-01-12 11:20:43',NULL,'tep_cfg_select_option(array(\'true\', \'false\'), '),(166,'Check for Missing Tags','HEADER_TAGS_CHECK_TAGS','true','Check to see if any products, categories or manufacturers contain empty meta tag fields<br>(true=on false=off)',543,6,NULL,'2010-01-12 11:20:43',NULL,'tep_cfg_select_option(array(\'true\', \'false\'), '),(167,'Display Category Parents in Title and Tags','HEADER_TAGS_ADD_CATEGORY_PARENTS','Standard','Adds all categories in the current path (Full), all immediate categories if the product is in more than one category (Duplicate) or only the immediate category (Standard). These settings only work if the Category checkbox is enabled in Page Control.',543,9,NULL,'2010-01-12 11:20:43',NULL,'tep_cfg_select_option(array(\'Full Category Path\', \'Duplicate Categories\', \'Standard\'), '),(168,'Display Column Box','HEADER_TAGS_DISPLAY_COLUMN_BOX','false','Display product box in column while on product page<br>(true=on false=off)',543,12,NULL,'2010-01-12 11:20:43',NULL,'tep_cfg_select_option(array(\'true\', \'false\'), '),(169,'Display Help Popups','HEADER_TAGS_DISPLAY_HELP_POPUPS','true','Display short popup messages that describes a feature<br>(true=on false=off)',543,18,NULL,'2010-01-12 11:20:43',NULL,'tep_cfg_select_option(array(\'true\', \'false\'), '),(170,'Disable Permission Warning','HEADER_TAGS_DIABLE_PERMISSION_WARNING','false','Prevent the warning that appears if the permissions for the includes/header_tags.php file appear to be incoorect.<br>(true=on false=off)',543,19,NULL,'2010-01-12 11:20:43',NULL,'tep_cfg_select_option(array(\'true\', \'false\'), '),(171,'Display Silo Links','HEADER_TAGS_DISPLAY_SILO_BOX','false','Display a box displaying links based on the settings in Silo Control<br>(true=on false=off)',543,20,NULL,'2010-01-12 11:20:43',NULL,'tep_cfg_select_option(array(\'true\', \'false\'), '),(172,'Display Social Bookmark','HEADER_TAGS_DISPLAY_SOCIAL_BOOKMARKS','true','Display social bookmarks on the product page<br>(true=on false=off)',543,21,'2010-01-12 11:41:54','2010-01-12 11:20:43',NULL,'tep_cfg_select_option(array(\'true\', \'false\'), '),(173,'Keyword Density Range','HEADER_TAGS_KEYWORD_DENSITY_RANGE','0.02,0.06','Set the limits for the keyword density use to dynamically select the keywords. Enter two figures, separated by a comma',543,24,NULL,'2010-01-12 11:20:43',NULL,NULL),(174,'Separator - Description','HEADER_TAGS_SEPARATOR_DESCRIPTION','-','Set the separator to be used for the description (and titles and logo).',543,27,NULL,'2010-01-12 11:20:43',NULL,NULL),(175,'Separator - Keywords','HEADER_TAGS_SEPARATOR_KEYWORD',',','Set the separator to be used for the keywords.',543,30,NULL,'2010-01-12 11:20:43',NULL,NULL),(176,'Enable TinyMCE Editor for Category Descriptions','HEADER_TAGS_ENABLE_TINYMCE_CATEGORIES','false','Enables the TinyMCE HTML editor for the categories description box. The editor must be installed for this to work.',543,33,NULL,'2010-01-12 11:20:43',NULL,'tep_cfg_select_option(array(\'true\', \'false\'), '),(177,'Enable TinyMCE Editor for Meta Descriptions','HEADER_TAGS_ENABLE_TINYMCE_META_DESC','false','Enables the TinyMCE HTML editor for the meta tag description box. The editor must be installed for this to work.',543,36,NULL,'2010-01-12 11:20:43',NULL,'tep_cfg_select_option(array(\'true\', \'false\'), '),(178,'Enable TinyMCE Editor for Products','HEADER_TAGS_ENABLE_TINYMCE_PRODUCTS','false','Enables the TinyMCE HTML editor for the products description box. The editor must be installed for this to work.',543,39,NULL,'2010-01-12 11:20:43',NULL,'tep_cfg_select_option(array(\'true\', \'false\'), '),(263,'Display Product Sort Order','PRODUCT_SORT_ORDER','0','Do you want to display the Product Sort Order column?',8,29,'0000-00-00 00:00:00','0000-00-00 00:00:00',NULL,NULL),(269,'Enable PayPal Website Payments Standard','MODULE_PAYMENT_PAYPAL_STANDARD_STATUS','True','Do you want to accept PayPal Website Payments Standard payments?',6,3,NULL,'2010-02-04 23:29:33',NULL,'tep_cfg_select_option(array(\'True\', \'False\'), '),(270,'E-Mail Address','MODULE_PAYMENT_PAYPAL_STANDARD_ID','payal@astraljewels.com.au','The PayPal seller e-mail address to accept payments for',6,4,NULL,'2010-02-04 23:29:33',NULL,NULL),(271,'Sort order of display.','MODULE_PAYMENT_PAYPAL_STANDARD_SORT_ORDER','0','Sort order of display. Lowest is displayed first.',6,0,NULL,'2010-02-04 23:29:33',NULL,NULL),(272,'Payment Zone','MODULE_PAYMENT_PAYPAL_STANDARD_ZONE','0','If a zone is selected, only enable this payment method for that zone.',6,2,NULL,'2010-02-04 23:29:33','tep_get_zone_class_title','tep_cfg_pull_down_zone_classes('),(273,'Set Preparing Order Status','MODULE_PAYMENT_PAYPAL_STANDARD_PREPARE_ORDER_STATUS_ID','4','Set the status of prepared orders made with this payment module to this value',6,0,NULL,'2010-02-04 23:29:33','tep_get_order_status_name','tep_cfg_pull_down_order_statuses('),(274,'Set PayPal Acknowledged Order Status','MODULE_PAYMENT_PAYPAL_STANDARD_ORDER_STATUS_ID','0','Set the status of orders made with this payment module to this value',6,0,NULL,'2010-02-04 23:29:33','tep_get_order_status_name','tep_cfg_pull_down_order_statuses('),(275,'Gateway Server','MODULE_PAYMENT_PAYPAL_STANDARD_GATEWAY_SERVER','Live','Use the testing (sandbox) or live gateway server for transactions?',6,6,NULL,'2010-02-04 23:29:33',NULL,'tep_cfg_select_option(array(\'Live\', \'Sandbox\'), '),(276,'Transaction Method','MODULE_PAYMENT_PAYPAL_STANDARD_TRANSACTION_METHOD','Sale','The processing method to use for each transaction.',6,0,NULL,'2010-02-04 23:29:33',NULL,'tep_cfg_select_option(array(\'Authorization\', \'Sale\'), '),(277,'Page Style','MODULE_PAYMENT_PAYPAL_STANDARD_PAGE_STYLE','','The page style to use for the transaction procedure (defined at your PayPal Profile page)',6,4,NULL,'2010-02-04 23:29:33',NULL,NULL),(278,'Debug E-Mail Address','MODULE_PAYMENT_PAYPAL_STANDARD_DEBUG_EMAIL','','All parameters of an Invalid IPN notification will be sent to this email address if one is entered.',6,4,NULL,'2010-02-04 23:29:33',NULL,NULL),(279,'Enable Encrypted Web Payments','MODULE_PAYMENT_PAYPAL_STANDARD_EWP_STATUS','False','Do you want to enable Encrypted Web Payments?',6,3,NULL,'2010-02-04 23:29:33',NULL,'tep_cfg_select_option(array(\'True\', \'False\'), '),(280,'Your Private Key','MODULE_PAYMENT_PAYPAL_STANDARD_EWP_PRIVATE_KEY','','The location of your Private Key to use for signing the data. (*.pem)',6,4,NULL,'2010-02-04 23:29:33',NULL,NULL),(281,'Your Public Certificate','MODULE_PAYMENT_PAYPAL_STANDARD_EWP_PUBLIC_KEY','','The location of your Public Certificate to use for signing the data. (*.pem)',6,4,NULL,'2010-02-04 23:29:33',NULL,NULL),(282,'PayPals Public Certificate','MODULE_PAYMENT_PAYPAL_STANDARD_EWP_PAYPAL_KEY','','The location of the PayPal Public Certificate for encrypting the data.',6,4,NULL,'2010-02-04 23:29:33',NULL,NULL),(283,'Your PayPal Public Certificate ID','MODULE_PAYMENT_PAYPAL_STANDARD_EWP_CERT_ID','','The Certificate ID to use from your PayPal Encrypted Payment Settings Profile.',6,4,NULL,'2010-02-04 23:29:33',NULL,NULL),(284,'Working Directory','MODULE_PAYMENT_PAYPAL_STANDARD_EWP_WORKING_DIRECTORY','','The working directory to use for temporary files. (trailing slash needed)',6,4,NULL,'2010-02-04 23:29:33',NULL,NULL),(285,'OpenSSL Location','MODULE_PAYMENT_PAYPAL_STANDARD_EWP_OPENSSL','/usr/bin/openssl','The location of the openssl binary file.',6,4,NULL,'2010-02-04 23:29:33',NULL,NULL),(311,'Enable Table Method','MODULE_SHIPPING_TABLE_STATUS','False','Do you want to offer table rate shipping?',6,0,NULL,'2010-05-25 18:35:49',NULL,'tep_cfg_select_option(array(\'True\', \'False\'), '),(312,'Shipping Table','MODULE_SHIPPING_TABLE_COST','20:12','The shipping cost is based on the total cost or weight of items. Example: 25:8.50,50:5.50,etc.. Up to 25 charge 8.50, from there to 50 charge 5.50, etc',6,0,NULL,'2010-05-25 18:35:49',NULL,NULL),(313,'Table Method','MODULE_SHIPPING_TABLE_MODE','weight','The shipping cost is based on the order total or the total weight of the items ordered.',6,0,NULL,'2010-05-25 18:35:49',NULL,'tep_cfg_select_option(array(\'weight\', \'price\'), '),(314,'Handling Fee','MODULE_SHIPPING_TABLE_HANDLING','0','Handling fee for this shipping method.',6,0,NULL,'2010-05-25 18:35:49',NULL,NULL),(315,'Tax Class','MODULE_SHIPPING_TABLE_TAX_CLASS','0','Use the following tax class on the shipping fee.',6,0,NULL,'2010-05-25 18:35:49','tep_get_tax_class_title','tep_cfg_pull_down_tax_classes('),(316,'Shipping Zone','MODULE_SHIPPING_TABLE_ZONE','0','If a zone is selected, only enable this shipping method for that zone.',6,0,NULL,'2010-05-25 18:35:49','tep_get_zone_class_title','tep_cfg_pull_down_zone_classes('),(317,'Sort Order','MODULE_SHIPPING_TABLE_SORT_ORDER','0','Sort order of display.',6,0,NULL,'2010-05-25 18:35:49',NULL,NULL),(318,'Max Wish List','MAX_DISPLAY_WISHLIST_PRODUCTS','12','How many wish list items to show per page on the main wishlist.php file',12954,0,'2010-07-11 23:43:40','2010-07-11 23:43:40',NULL,NULL),(319,'Max Wish List Box','MAX_DISPLAY_WISHLIST_BOX','4','How many wish list items to display in the infobox before it changes to a counter',12954,0,'2010-07-11 23:43:40','2010-07-11 23:43:40',NULL,NULL),(320,'Display Emails','DISPLAY_WISHLIST_EMAILS','10','How many emails to display when the customer emails their wishlist link',12954,0,'2010-07-11 23:43:40','2010-07-11 23:43:40',NULL,NULL),(321,'Wishlist Redirect','WISHLIST_REDIRECT','No','Do you want to redirect back to the product_info.php page when a customer adds a product to their wishlist?',12954,0,'2010-07-11 23:43:40','2010-07-11 23:43:40',NULL,'tep_cfg_select_option(array(\'Yes\', \'No\'),'),(322,'Enable Cash On Delivery Module','MODULE_PAYMENT_COD_STATUS','True','Do you want to accept Cash On Delevery payments?',6,1,NULL,'2010-07-22 21:05:10',NULL,'tep_cfg_select_option(array(\'True\', \'False\'), '),(323,'Payment Zone','MODULE_PAYMENT_COD_ZONE','0','If a zone is selected, only enable this payment method for that zone.',6,2,NULL,'2010-07-22 21:05:10','tep_get_zone_class_title','tep_cfg_pull_down_zone_classes('),(324,'Sort order of display.','MODULE_PAYMENT_COD_SORT_ORDER','2','Sort order of display. Lowest is displayed first.',6,0,NULL,'2010-07-22 21:05:10',NULL,NULL),(325,'Set Order Status','MODULE_PAYMENT_COD_ORDER_STATUS_ID','0','Set the status of orders made with this payment module to this value',6,0,NULL,'2010-07-22 21:05:10','tep_get_order_status_name','tep_cfg_pull_down_order_statuses(');
/*!40000 ALTER TABLE `configuration` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `configuration_group`
--

DROP TABLE IF EXISTS `configuration_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `configuration_group` (
  `configuration_group_id` int(11) NOT NULL AUTO_INCREMENT,
  `configuration_group_title` varchar(64) NOT NULL,
  `configuration_group_description` varchar(255) NOT NULL,
  `sort_order` int(5) DEFAULT NULL,
  `visible` int(1) DEFAULT '1',
  PRIMARY KEY (`configuration_group_id`)
) ENGINE=InnoDB AUTO_INCREMENT=12955 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `configuration_group`
--

LOCK TABLES `configuration_group` WRITE;
/*!40000 ALTER TABLE `configuration_group` DISABLE KEYS */;
INSERT INTO `configuration_group` VALUES (1,'My Store','General information about my store',1,1),(2,'Minimum Values','The minimum values for functions / data',2,1),(3,'Maximum Values','The maximum values for functions / data',3,1),(4,'Images','Image parameters',4,1),(5,'Customer Details','Customer account configuration',5,1),(6,'Module Options','Hidden from configuration',6,0),(7,'Shipping/Packaging','Shipping options available at my store',7,1),(8,'Product Listing','Product Listing    configuration options',8,1),(9,'Stock','Stock configuration options',9,1),(10,'Logging','Logging configuration options',10,1),(11,'Cache','Caching configuration options',11,1),(12,'E-Mail Options','General setting for E-Mail transport and HTML E-Mails',12,1),(13,'Download','Downloadable products options',13,1),(14,'GZip Compression','GZip compression options',14,1),(15,'Sessions','Session options',15,1),(16,'SEO URLs','Options for Ultimate SEO URLs by Chemo',16,1),(543,'Header Tags SEO','Header Tags SEO site wide options',20,1),(12954,'Wish List Settings','Settings for your Wish List',25,1);
/*!40000 ALTER TABLE `configuration_group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `counter`
--

DROP TABLE IF EXISTS `counter`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `counter` (
  `startdate` char(8) DEFAULT NULL,
  `counter` int(12) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `counter`
--

LOCK TABLES `counter` WRITE;
/*!40000 ALTER TABLE `counter` DISABLE KEYS */;
INSERT INTO `counter` VALUES ('20100111',14623);
/*!40000 ALTER TABLE `counter` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `counter_history`
--

DROP TABLE IF EXISTS `counter_history`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `counter_history` (
  `month` char(8) DEFAULT NULL,
  `counter` int(12) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `counter_history`
--

LOCK TABLES `counter_history` WRITE;
/*!40000 ALTER TABLE `counter_history` DISABLE KEYS */;
/*!40000 ALTER TABLE `counter_history` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `countries`
--

DROP TABLE IF EXISTS `countries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `countries` (
  `countries_id` int(11) NOT NULL AUTO_INCREMENT,
  `countries_name` varchar(64) NOT NULL,
  `countries_iso_code_2` char(2) NOT NULL,
  `countries_iso_code_3` char(3) NOT NULL,
  `address_format_id` int(11) NOT NULL,
  PRIMARY KEY (`countries_id`),
  KEY `IDX_COUNTRIES_NAME` (`countries_name`)
) ENGINE=InnoDB AUTO_INCREMENT=240 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `countries`
--

LOCK TABLES `countries` WRITE;
/*!40000 ALTER TABLE `countries` DISABLE KEYS */;
INSERT INTO `countries` VALUES (1,'Afghanistan','AF','AFG',1),(2,'Albania','AL','ALB',1),(3,'Algeria','DZ','DZA',1),(4,'American Samoa','AS','ASM',1),(5,'Andorra','AD','AND',1),(6,'Angola','AO','AGO',1),(7,'Anguilla','AI','AIA',1),(8,'Antarctica','AQ','ATA',1),(9,'Antigua and Barbuda','AG','ATG',1),(10,'Argentina','AR','ARG',1),(11,'Armenia','AM','ARM',1),(12,'Aruba','AW','ABW',1),(13,'Australia','AU','AUS',1),(14,'Austria','AT','AUT',5),(15,'Azerbaijan','AZ','AZE',1),(16,'Bahamas','BS','BHS',1),(17,'Bahrain','BH','BHR',1),(18,'Bangladesh','BD','BGD',1),(19,'Barbados','BB','BRB',1),(20,'Belarus','BY','BLR',1),(21,'Belgium','BE','BEL',1),(22,'Belize','BZ','BLZ',1),(23,'Benin','BJ','BEN',1),(24,'Bermuda','BM','BMU',1),(25,'Bhutan','BT','BTN',1),(26,'Bolivia','BO','BOL',1),(27,'Bosnia and Herzegowina','BA','BIH',1),(28,'Botswana','BW','BWA',1),(29,'Bouvet Island','BV','BVT',1),(30,'Brazil','BR','BRA',1),(31,'British Indian Ocean Territory','IO','IOT',1),(32,'Brunei Darussalam','BN','BRN',1),(33,'Bulgaria','BG','BGR',1),(34,'Burkina Faso','BF','BFA',1),(35,'Burundi','BI','BDI',1),(36,'Cambodia','KH','KHM',1),(37,'Cameroon','CM','CMR',1),(38,'Canada','CA','CAN',1),(39,'Cape Verde','CV','CPV',1),(40,'Cayman Islands','KY','CYM',1),(41,'Central African Republic','CF','CAF',1),(42,'Chad','TD','TCD',1),(43,'Chile','CL','CHL',1),(44,'China','CN','CHN',1),(45,'Christmas Island','CX','CXR',1),(46,'Cocos (Keeling) Islands','CC','CCK',1),(47,'Colombia','CO','COL',1),(48,'Comoros','KM','COM',1),(49,'Congo','CG','COG',1),(50,'Cook Islands','CK','COK',1),(51,'Costa Rica','CR','CRI',1),(52,'Cote D\'Ivoire','CI','CIV',1),(53,'Croatia','HR','HRV',1),(54,'Cuba','CU','CUB',1),(55,'Cyprus','CY','CYP',1),(56,'Czech Republic','CZ','CZE',1),(57,'Denmark','DK','DNK',1),(58,'Djibouti','DJ','DJI',1),(59,'Dominica','DM','DMA',1),(60,'Dominican Republic','DO','DOM',1),(61,'East Timor','TP','TMP',1),(62,'Ecuador','EC','ECU',1),(63,'Egypt','EG','EGY',1),(64,'El Salvador','SV','SLV',1),(65,'Equatorial Guinea','GQ','GNQ',1),(66,'Eritrea','ER','ERI',1),(67,'Estonia','EE','EST',1),(68,'Ethiopia','ET','ETH',1),(69,'Falkland Islands (Malvinas)','FK','FLK',1),(70,'Faroe Islands','FO','FRO',1),(71,'Fiji','FJ','FJI',1),(72,'Finland','FI','FIN',1),(73,'France','FR','FRA',1),(74,'France, Metropolitan','FX','FXX',1),(75,'French Guiana','GF','GUF',1),(76,'French Polynesia','PF','PYF',1),(77,'French Southern Territories','TF','ATF',1),(78,'Gabon','GA','GAB',1),(79,'Gambia','GM','GMB',1),(80,'Georgia','GE','GEO',1),(81,'Germany','DE','DEU',5),(82,'Ghana','GH','GHA',1),(83,'Gibraltar','GI','GIB',1),(84,'Greece','GR','GRC',1),(85,'Greenland','GL','GRL',1),(86,'Grenada','GD','GRD',1),(87,'Guadeloupe','GP','GLP',1),(88,'Guam','GU','GUM',1),(89,'Guatemala','GT','GTM',1),(90,'Guinea','GN','GIN',1),(91,'Guinea-bissau','GW','GNB',1),(92,'Guyana','GY','GUY',1),(93,'Haiti','HT','HTI',1),(94,'Heard and Mc Donald Islands','HM','HMD',1),(95,'Honduras','HN','HND',1),(96,'Hong Kong','HK','HKG',1),(97,'Hungary','HU','HUN',1),(98,'Iceland','IS','ISL',1),(99,'India','IN','IND',1),(100,'Indonesia','ID','IDN',1),(101,'Iran (Islamic Republic of)','IR','IRN',1),(102,'Iraq','IQ','IRQ',1),(103,'Ireland','IE','IRL',1),(104,'Israel','IL','ISR',1),(105,'Italy','IT','ITA',1),(106,'Jamaica','JM','JAM',1),(107,'Japan','JP','JPN',1),(108,'Jordan','JO','JOR',1),(109,'Kazakhstan','KZ','KAZ',1),(110,'Kenya','KE','KEN',1),(111,'Kiribati','KI','KIR',1),(112,'Korea, Democratic People\'s Republic of','KP','PRK',1),(113,'Korea, Republic of','KR','KOR',1),(114,'Kuwait','KW','KWT',1),(115,'Kyrgyzstan','KG','KGZ',1),(116,'Lao People\'s Democratic Republic','LA','LAO',1),(117,'Latvia','LV','LVA',1),(118,'Lebanon','LB','LBN',1),(119,'Lesotho','LS','LSO',1),(120,'Liberia','LR','LBR',1),(121,'Libyan Arab Jamahiriya','LY','LBY',1),(122,'Liechtenstein','LI','LIE',1),(123,'Lithuania','LT','LTU',1),(124,'Luxembourg','LU','LUX',1),(125,'Macau','MO','MAC',1),(126,'Macedonia, The Former Yugoslav Republic of','MK','MKD',1),(127,'Madagascar','MG','MDG',1),(128,'Malawi','MW','MWI',1),(129,'Malaysia','MY','MYS',1),(130,'Maldives','MV','MDV',1),(131,'Mali','ML','MLI',1),(132,'Malta','MT','MLT',1),(133,'Marshall Islands','MH','MHL',1),(134,'Martinique','MQ','MTQ',1),(135,'Mauritania','MR','MRT',1),(136,'Mauritius','MU','MUS',1),(137,'Mayotte','YT','MYT',1),(138,'Mexico','MX','MEX',1),(139,'Micronesia, Federated States of','FM','FSM',1),(140,'Moldova, Republic of','MD','MDA',1),(141,'Monaco','MC','MCO',1),(142,'Mongolia','MN','MNG',1),(143,'Montserrat','MS','MSR',1),(144,'Morocco','MA','MAR',1),(145,'Mozambique','MZ','MOZ',1),(146,'Myanmar','MM','MMR',1),(147,'Namibia','NA','NAM',1),(148,'Nauru','NR','NRU',1),(149,'Nepal','NP','NPL',1),(150,'Netherlands','NL','NLD',1),(151,'Netherlands Antilles','AN','ANT',1),(152,'New Caledonia','NC','NCL',1),(153,'New Zealand','NZ','NZL',1),(154,'Nicaragua','NI','NIC',1),(155,'Niger','NE','NER',1),(156,'Nigeria','NG','NGA',1),(157,'Niue','NU','NIU',1),(158,'Norfolk Island','NF','NFK',1),(159,'Northern Mariana Islands','MP','MNP',1),(160,'Norway','NO','NOR',1),(161,'Oman','OM','OMN',1),(162,'Pakistan','PK','PAK',1),(163,'Palau','PW','PLW',1),(164,'Panama','PA','PAN',1),(165,'Papua New Guinea','PG','PNG',1),(166,'Paraguay','PY','PRY',1),(167,'Peru','PE','PER',1),(168,'Philippines','PH','PHL',1),(169,'Pitcairn','PN','PCN',1),(170,'Poland','PL','POL',1),(171,'Portugal','PT','PRT',1),(172,'Puerto Rico','PR','PRI',1),(173,'Qatar','QA','QAT',1),(174,'Reunion','RE','REU',1),(175,'Romania','RO','ROM',1),(176,'Russian Federation','RU','RUS',1),(177,'Rwanda','RW','RWA',1),(178,'Saint Kitts and Nevis','KN','KNA',1),(179,'Saint Lucia','LC','LCA',1),(180,'Saint Vincent and the Grenadines','VC','VCT',1),(181,'Samoa','WS','WSM',1),(182,'San Marino','SM','SMR',1),(183,'Sao Tome and Principe','ST','STP',1),(184,'Saudi Arabia','SA','SAU',1),(185,'Senegal','SN','SEN',1),(186,'Seychelles','SC','SYC',1),(187,'Sierra Leone','SL','SLE',1),(188,'Singapore','SG','SGP',4),(189,'Slovakia (Slovak Republic)','SK','SVK',1),(190,'Slovenia','SI','SVN',1),(191,'Solomon Islands','SB','SLB',1),(192,'Somalia','SO','SOM',1),(193,'South Africa','ZA','ZAF',1),(194,'South Georgia and the South Sandwich Islands','GS','SGS',1),(195,'Spain','ES','ESP',3),(196,'Sri Lanka','LK','LKA',1),(197,'St. Helena','SH','SHN',1),(198,'St. Pierre and Miquelon','PM','SPM',1),(199,'Sudan','SD','SDN',1),(200,'Suriname','SR','SUR',1),(201,'Svalbard and Jan Mayen Islands','SJ','SJM',1),(202,'Swaziland','SZ','SWZ',1),(203,'Sweden','SE','SWE',1),(204,'Switzerland','CH','CHE',1),(205,'Syrian Arab Republic','SY','SYR',1),(206,'Taiwan','TW','TWN',1),(207,'Tajikistan','TJ','TJK',1),(208,'Tanzania, United Republic of','TZ','TZA',1),(209,'Thailand','TH','THA',1),(210,'Togo','TG','TGO',1),(211,'Tokelau','TK','TKL',1),(212,'Tonga','TO','TON',1),(213,'Trinidad and Tobago','TT','TTO',1),(214,'Tunisia','TN','TUN',1),(215,'Turkey','TR','TUR',1),(216,'Turkmenistan','TM','TKM',1),(217,'Turks and Caicos Islands','TC','TCA',1),(218,'Tuvalu','TV','TUV',1),(219,'Uganda','UG','UGA',1),(220,'Ukraine','UA','UKR',1),(221,'United Arab Emirates','AE','ARE',1),(222,'United Kingdom','GB','GBR',1),(223,'United States','US','USA',2),(224,'United States Minor Outlying Islands','UM','UMI',1),(225,'Uruguay','UY','URY',1),(226,'Uzbekistan','UZ','UZB',1),(227,'Vanuatu','VU','VUT',1),(228,'Vatican City State (Holy See)','VA','VAT',1),(229,'Venezuela','VE','VEN',1),(230,'Viet Nam','VN','VNM',1),(231,'Virgin Islands (British)','VG','VGB',1),(232,'Virgin Islands (U.S.)','VI','VIR',1),(233,'Wallis and Futuna Islands','WF','WLF',1),(234,'Western Sahara','EH','ESH',1),(235,'Yemen','YE','YEM',1),(236,'Yugoslavia','YU','YUG',1),(237,'Zaire','ZR','ZAR',1),(238,'Zambia','ZM','ZMB',1),(239,'Zimbabwe','ZW','ZWE',1);
/*!40000 ALTER TABLE `countries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `currencies`
--

DROP TABLE IF EXISTS `currencies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `currencies` (
  `currencies_id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(32) NOT NULL,
  `code` char(3) NOT NULL,
  `symbol_left` varchar(12) DEFAULT NULL,
  `symbol_right` varchar(12) DEFAULT NULL,
  `decimal_point` char(1) DEFAULT NULL,
  `thousands_point` char(1) DEFAULT NULL,
  `decimal_places` char(1) DEFAULT NULL,
  `value` float(13,8) DEFAULT NULL,
  `last_updated` datetime DEFAULT NULL,
  PRIMARY KEY (`currencies_id`),
  KEY `idx_currencies_code` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `currencies`
--

LOCK TABLES `currencies` WRITE;
/*!40000 ALTER TABLE `currencies` DISABLE KEYS */;
INSERT INTO `currencies` VALUES (2,'Australian Dollar (AU$)','AUD','$','','.',',','2',1.00000000,NULL);
/*!40000 ALTER TABLE `currencies` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `customers` (
  `customers_id` int(11) NOT NULL AUTO_INCREMENT,
  `customers_gender` char(1) NOT NULL,
  `customers_firstname` varchar(32) NOT NULL,
  `customers_lastname` varchar(32) NOT NULL,
  `customers_dob` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `customers_email_address` varchar(96) NOT NULL,
  `customers_default_address_id` int(11) DEFAULT NULL,
  `customers_telephone` varchar(32) NOT NULL,
  `customers_fax` varchar(32) DEFAULT NULL,
  `customers_password` varchar(40) NOT NULL,
  `customers_newsletter` char(1) DEFAULT NULL,
  `customers_group_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `customers_group_ra` enum('0','1') NOT NULL,
  `customers_title` varchar(255) NOT NULL DEFAULT '1',
  `customers_payment_allowed` varchar(255) NOT NULL DEFAULT '',
  `customers_shipment_allowed` varchar(255) NOT NULL DEFAULT '',
  `customers_order_total_allowed` varchar(255) NOT NULL DEFAULT '',
  `customers_specific_taxes_exempt` varchar(255) NOT NULL DEFAULT '',
  `entry_company_tax_id` varchar(32) DEFAULT NULL,
  `customers_status` int(1) NOT NULL,
  PRIMARY KEY (`customers_id`),
  KEY `idx_customers_email_address` (`customers_email_address`)
) ENGINE=InnoDB AUTO_INCREMENT=75 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` VALUES (19,'','Payal','Maheshwari','0000-00-00 00:00:00','payal@astraljewels.com.au',19,'0414150957','','d27e8af821c6010f7a603f44edabdfb8:10','0',0,'1','','','','','','111',1),(20,'','Terrie','Caven','0000-00-00 00:00:00','customerservice@texgems.com.au',20,'','','14cab6021e5acdb18f13b6da2f085302:3a','',0,'1','','','','','','51210264514',1),(22,'','Monique','Dawson','0000-00-00 00:00:00','monique-dawson@hotmail.com',22,'0410 492 704','(02) 4389 2704','91584b5a553a67371e3c665784e1d534:3b','0',0,'1','2','','','','','37662859209',1),(24,'','Susie','Rowley','0000-00-00 00:00:00','theswishgallery@bigpond.com',24,'68829528','68852846','969454ac882093bf6e88bcb60953eac8:cd','0',0,'1','2','','','','','78362960673',1),(25,'','debra','woodruff','0000-00-00 00:00:00','rollerdoorrepairs@gmail.com',25,'','','07a28ccfd7ef5f821ee9c4481e3c476f:40','',0,'1','2','','','','','91603543146',1),(26,'','Carmel','Alberti','0000-00-00 00:00:00','hampersNthings@email4life.com.au',26,'0409938385','www.hampersnthings.com.au','d2f5dcf7b63de78f5a287d5e7bb10d67:0c','0',0,'1','2','','','','','36 964 613 743',1),(27,'','Leonie','Rowell','0000-00-00 00:00:00','leonierowell@bigpond.com',27,'0421763442','','4bb718da7f3810ae7a3f50a9821af885:61','0',0,'1','2','','','','','920',1),(28,'','betty','patsiolis','0000-00-00 00:00:00','bettyboohn@live.com.au',28,'','','3c1188b85f64504366270ecd3298fd3a:cb','',0,'1','','','','','','49044284575',1),(29,'','wendy','babbar','0000-00-00 00:00:00','goldnglitter@bigpond.com',29,'','','e1ae7b79f5dee6512b718ccf1a49d78c:63','',0,'0','','','','','',NULL,1),(30,'','Lesley','Ryan','0000-00-00 00:00:00','lmr.jewellery@xtra.co.nz',30,'','','1697e8f0ef6d358888ccc59c604cd788:55','',0,'0','','','','','',NULL,1),(32,'','Fiona','Phillips','0000-00-00 00:00:00','fionaphillips@iinet.net.au',32,'0402082621','','e5fff81adc37ed9d859e06fe48b7e64b:4f','',0,'0','','','','','',NULL,1),(35,'','georgina','jobling','0000-00-00 00:00:00','georginadesign_7@hotmail.com',35,'0417363367','','40fc0158b7278fcfd9d82cebc4710cbd:3c','',0,'1','2','','','','','72536079548',1),(39,'','Carla','Enriquez','0000-00-00 00:00:00','info@livingchakra.com.au',39,'0438540426','','50c28a8854e7ea7625f50f0712f05d3c:73','',0,'1','2','','','','','74919902939',1),(40,'','Sharon','Beer','0000-00-00 00:00:00','sbeer@sje.vic.edu.au',40,'0354429747','','ef586f1c3dab4160db08cab67dfef04d:5a','',0,'1','2','','','','','65233638121/068720187',1),(41,'','Juli','Davine','0000-00-00 00:00:00','info@skiptongallery.com',41,'03 53402073','044 891 4831','bfe48f6fa16f3f1d3e5576aad440a29c:78','0',0,'1','','','','','','82797457004',1),(42,'','coral','wiebenga','0000-00-00 00:00:00','cwiebenga@optusnet.com.au',42,'0404084514','','44a3c45d4c63e2924cf0299cd68b3348:82','',0,'1','','','','','','20393983008',1),(43,'','Suzanne','Metaxas','0000-00-00 00:00:00','belle_essentials@yahoo.com.au',43,'9480 5200','','698dbb321652d74f018ebfa2b1834aca:aa','',0,'1','','','','','','37032355220',1),(44,'','Loretta','Illy','0000-00-00 00:00:00','illyg@bigpond.com',44,'0419019459','','c83140b1f7bcd1d2a06d5de9d15ed60e:19','',0,'1','','','','','','TBA',0),(47,'','Tanya','Singh','0000-00-00 00:00:00','aynat8@hotmail.com',47,'81339031','','572d0c870069d4a9774ee0040e95127a:b2','',0,'0','1','','','','',NULL,0),(49,'','Shiro','Kenny','0000-00-00 00:00:00','skenny@mintsilver.com.au',49,'0413 668669','','8f7e7214484e55f7ba9630b5b38cf524:21','',0,'0','2','','','','',NULL,1),(50,'','Ann','Dubbioso','0000-00-00 00:00:00','silvertradingcompany@yahoo.com.au',50,'08 83367173','','75f80adf7248c60a2b834e6318e783fb:95','',0,'1','1','','','','','20486060028',0),(51,'','Jo','Dalton','0000-00-00 00:00:00','dalton5@virginbroadband.com.au',51,'0870002347','','840271698d6659962a4d9525d43dd4a1:fc','',0,'0','','','','','',NULL,0),(52,'','Jacinta','Roosing','0000-00-00 00:00:00','jkroosing@windowslive.com',52,'03 341 7011','','fdc164ded1491cc7541c83da8bc49d06:03','',0,'0','','','','','',NULL,1),(53,'','Liz','Jeffery','0000-00-00 00:00:00','garry_liz01@optusnet.com.au',53,'042 9956573','','1d9fe602736541a733c2c566770d81d3:44','',0,'1','2','','','','','93 163 025 260',1),(54,'','Angie','Prokopis','0000-00-00 00:00:00','support@jas-designs.com',54,'0438661069','','772d8d666c3e69300f8dd8bc1399a3af:e3','',0,'1','2','','','','','22445147007',1),(55,'','chiwoneso','bwititi','0000-00-00 00:00:00','chiwonesob@yahoo.co.uk',55,'0434633884','','0fe8e6ad750759f520a581917584c8b2:f3','',0,'0','2','','','','',NULL,0),(56,'','ANGELA','ALBERTIN','0000-00-00 00:00:00','angelaalbertin@iprimus.com.au',56,'0400464352','','b287d02f9fa7340dd69e3072a49d3fc3:61','',0,'1','2','','','','','16439819400',1),(57,'','shantell','mckee','0000-00-00 00:00:00','shantellmckee40@hotmail.com',57,'0406059059','','7fbe9df4424bb9f9a8f98a4065af23c3:b0','',0,'0','2','','','','',NULL,1),(58,'','Julie','Dolan','0000-00-00 00:00:00','info@sandara.com.au',58,'0404455001','','33e570034331ae5d0dd45e5e9a7d01c8:58','',0,'1','2','','','','','76 208 359 986',1),(59,'','NEERAJ','KEJRIWAL','0000-00-00 00:00:00','silvex@ymail.com',59,'01412208810','','0fccc2a42614a6c9853a95f836882370:8a','',0,'1','','','','','','9829012590',0),(60,'','marisa','totevski','0000-00-00 00:00:00','marisa@novitamuranoglass.com.au',60,'+393208255405','','bd2d2536552c1c6629ef2ed46161d357:90','',0,'0','','','','','',NULL,0),(61,'','kelly','sidwick','0000-00-00 00:00:00','swishkelly@hotmail.com.au',61,'0439804466','','5e0378648790a8c9f396309e2095de3f:ed','',0,'1','2','','','','','68643471598',1),(62,'','kim','wing','0000-00-00 00:00:00','wingirl1234@hotmail.com',62,'6093778425','','a4221b32340b48a822b1bb025d17cbb0:94','',0,'1','2','','','','','197508434',0),(63,'','Paulette','Adams','0000-00-00 00:00:00','pauletteadams@bigpond.com',63,'0415790858','','46c706de3054334fa7c582e80fb967b5:ad','',0,'0','2','','','','',NULL,0),(64,'','Charlotte','Farano','0000-00-00 00:00:00','Charlotte@eurekabeads.com.au',64,'0421213284','','bd6d6e18e4432500e90a8a5d6789f5a4:88','',0,'1','2','','','','','77184186616',0),(65,'','lisa','kennedy','0000-00-00 00:00:00','kennedysatcondamine@hotmail.com',65,'0746281161','','b1c05f1c2db5f1252afde20b72027124:6a','',0,'0','2','','','','',NULL,0),(66,'','Bianca','Pepe','0000-00-00 00:00:00','info@pebel.com.au',66,'0400644169','','3d2a961a16d7bd609ab5772961876e48:26','',0,'1','2','','','','','54523469517',0),(67,'','Amy','Perry','0000-00-00 00:00:00','aileenxixi@hotmail.com',67,'0431385999','','f56b05ab6d21836eb8fc30815e5b0b43:05','',0,'1','2','','','','','88270071603',1),(68,'','Natalie','Karapatsakis','0000-00-00 00:00:00','Natalie@eternitybridal.com.au',68,'0404031925','','2ad71d5a50b905e67e61731e1e4611fc:77','',0,'1','','','','','','71 483 876 853',0),(69,'','Leanne','Lance','0000-00-00 00:00:00','leannelance@hotmail.com',69,'0357551872','','22b21760f77da51a19cb2d7b75f9a896:7f','',0,'1','','','','','','24190166905',1),(70,'','Tracy','Emerton','0000-00-00 00:00:00','purplethread.1963@yahoo.com.au',70,'0406431704','','799bc68a5f3377a11fec74dc44095581:7a','',0,'1','','','','','','59671532847',1),(71,'','Justin','Sandher','0000-00-00 00:00:00','Justin.sandher@gmail.com',71,'7788697187','','816b720c02ffc0e6ca1572a8ee875896:48','',0,'0','1','','','','',NULL,0),(72,'','deepika','sahni','0000-00-00 00:00:00','diya_gera@yahoo.com',72,'0430858263','','6048db1092cb27b4c850642bd0a91970:c2','',0,'0','2','','','','',NULL,0),(73,'','Sue','Caldwell','0000-00-00 00:00:00','fengsue@mmnet.com.au',73,'03 5422 6315','','fff84292929bbb0c914a08f81488d4a9:fb','',0,'1','2','','','','','52064737753',1),(74,'','Lyn','Pattison','0000-00-00 00:00:00','enquiries@ianpattisonjewellers.com.au',74,'0352552019','','720c4e2ceb461901141573dd81fb0794:92','',0,'1','2','','','','','12215938713',1);
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_basket`
--

DROP TABLE IF EXISTS `customers_basket`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `customers_basket` (
  `customers_basket_id` int(11) NOT NULL AUTO_INCREMENT,
  `customers_id` int(11) NOT NULL,
  `products_id` tinytext NOT NULL,
  `customers_basket_quantity` int(2) NOT NULL,
  `final_price` decimal(15,4) DEFAULT NULL,
  `customers_basket_date_added` char(8) DEFAULT NULL,
  PRIMARY KEY (`customers_basket_id`),
  KEY `idx_customers_basket_customers_id` (`customers_id`)
) ENGINE=InnoDB AUTO_INCREMENT=56 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_basket`
--

LOCK TABLES `customers_basket` WRITE;
/*!40000 ALTER TABLE `customers_basket` DISABLE KEYS */;
INSERT INTO `customers_basket` VALUES (46,49,'159',1,NULL,'20110222'),(47,56,'126',1,NULL,'20110410'),(48,56,'148',1,NULL,'20110410'),(49,56,'170',1,NULL,'20110410'),(50,56,'146',1,NULL,'20110410'),(51,56,'171',1,NULL,'20110410'),(52,56,'143',1,NULL,'20110410'),(53,19,'130',1,NULL,'20110620'),(54,19,'107',1,NULL,'20110716'),(55,19,'78',1,NULL,'20110716');
/*!40000 ALTER TABLE `customers_basket` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_basket_attributes`
--

DROP TABLE IF EXISTS `customers_basket_attributes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `customers_basket_attributes` (
  `customers_basket_attributes_id` int(11) NOT NULL AUTO_INCREMENT,
  `customers_id` int(11) NOT NULL,
  `products_id` tinytext NOT NULL,
  `products_options_id` int(11) NOT NULL,
  `products_options_value_id` int(11) NOT NULL,
  PRIMARY KEY (`customers_basket_attributes_id`),
  KEY `idx_customers_basket_att_customers_id` (`customers_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_basket_attributes`
--

LOCK TABLES `customers_basket_attributes` WRITE;
/*!40000 ALTER TABLE `customers_basket_attributes` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_basket_attributes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_groups`
--

DROP TABLE IF EXISTS `customers_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `customers_groups` (
  `customers_group_id` smallint(5) unsigned NOT NULL,
  `customers_group_name` varchar(32) NOT NULL DEFAULT '',
  `customers_group_show_tax` enum('1','0') NOT NULL,
  `customers_group_tax_exempt` enum('0','1') NOT NULL,
  `group_payment_allowed` varchar(255) NOT NULL DEFAULT '',
  `group_shipment_allowed` varchar(255) NOT NULL DEFAULT '',
  `group_order_total_allowed` varchar(255) NOT NULL DEFAULT '',
  `group_specific_taxes_exempt` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`customers_group_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_groups`
--

LOCK TABLES `customers_groups` WRITE;
/*!40000 ALTER TABLE `customers_groups` DISABLE KEYS */;
INSERT INTO `customers_groups` VALUES (0,'Retail','1','0','','','',''),(1,'A','1','0','cod.php','','',''),(2,'B','1','0','paypal_standard.php;cod.php','','','');
/*!40000 ALTER TABLE `customers_groups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_info`
--

DROP TABLE IF EXISTS `customers_info`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `customers_info` (
  `customers_info_id` int(11) NOT NULL,
  `customers_info_date_of_last_logon` datetime DEFAULT NULL,
  `customers_info_number_of_logons` int(5) DEFAULT NULL,
  `customers_info_date_account_created` datetime DEFAULT NULL,
  `customers_info_date_account_last_modified` datetime DEFAULT NULL,
  `global_product_notifications` int(1) DEFAULT '0',
  PRIMARY KEY (`customers_info_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_info`
--

LOCK TABLES `customers_info` WRITE;
/*!40000 ALTER TABLE `customers_info` DISABLE KEYS */;
INSERT INTO `customers_info` VALUES (19,'2011-07-16 07:38:53',159,'2010-07-30 02:53:16','2011-05-22 07:01:49',0),(20,NULL,0,'2010-08-13 01:39:07',NULL,0),(22,'2010-08-15 19:13:49',2,'2010-08-15 03:04:06','2010-08-15 06:47:00',0),(24,'2010-08-16 00:15:34',1,'2010-08-15 23:50:45','2010-08-16 00:10:42',0),(25,'2010-08-16 18:09:42',1,'2010-08-16 05:27:17',NULL,0),(26,NULL,0,'2010-08-22 23:07:58','2010-08-23 00:00:12',0),(27,'2010-09-07 06:34:16',1,'2010-09-06 08:20:25','2010-09-06 19:08:11',0),(28,'2010-09-08 17:51:17',1,'2010-09-06 21:29:02',NULL,0),(29,NULL,0,'2010-09-13 19:24:41',NULL,0),(30,'2010-10-18 02:14:52',1,'2010-10-15 00:22:27',NULL,0),(32,NULL,0,'2010-11-09 19:13:43',NULL,0),(35,'2011-01-19 06:19:36',3,'2010-11-23 04:12:00',NULL,0),(39,'2011-05-15 07:37:04',7,'2010-11-24 20:47:01',NULL,0),(40,'2011-01-19 18:41:35',3,'2011-01-04 22:35:47',NULL,0),(41,'2011-01-09 21:10:17',2,'2011-01-09 05:42:58','2011-01-09 06:21:37',0),(42,'2011-01-12 17:32:36',1,'2011-01-11 19:46:26',NULL,0),(43,'2011-05-25 00:57:55',3,'2011-01-13 19:44:06',NULL,0),(44,NULL,0,'2011-01-17 17:28:19',NULL,0),(47,NULL,0,'2011-01-20 23:52:10',NULL,0),(49,'2011-02-23 17:17:25',5,'2011-02-14 03:31:56',NULL,0),(50,NULL,0,'2011-02-22 23:16:09',NULL,0),(51,NULL,0,'2011-02-23 21:45:43',NULL,0),(52,NULL,0,'2011-02-25 18:37:06',NULL,0),(53,'2011-02-28 20:07:21',1,'2011-02-27 23:28:47',NULL,0),(54,'2011-02-28 20:55:10',1,'2011-02-28 03:55:01',NULL,0),(55,NULL,0,'2011-03-11 04:33:31',NULL,0),(56,'2011-07-13 06:55:48',11,'2011-04-09 01:59:54',NULL,0),(57,'2011-04-26 19:40:20',1,'2011-04-20 04:08:00',NULL,0),(58,'2011-04-26 19:21:39',2,'2011-04-21 03:54:33',NULL,0),(59,NULL,0,'2011-05-05 04:47:32',NULL,0),(60,NULL,0,'2011-05-05 04:55:32',NULL,0),(61,NULL,0,'2011-05-09 05:20:11',NULL,0),(62,NULL,0,'2011-05-13 11:57:57',NULL,0),(63,NULL,0,'2011-05-21 05:42:21',NULL,0),(64,NULL,0,'2011-05-22 04:32:59',NULL,0),(65,NULL,0,'2011-05-30 05:02:18',NULL,0),(66,NULL,0,'2011-06-16 06:08:50',NULL,0),(67,NULL,0,'2011-06-17 09:06:36',NULL,0),(68,NULL,0,'2011-06-18 06:19:15',NULL,0),(69,'2011-06-24 22:16:15',1,'2011-06-24 00:12:09',NULL,0),(70,'2011-06-28 05:12:50',2,'2011-06-26 07:08:08',NULL,0),(71,NULL,0,'2011-06-28 13:56:30',NULL,0),(72,NULL,0,'2011-07-01 22:37:16',NULL,0),(73,'2011-07-15 20:35:30',1,'2011-07-15 01:10:59',NULL,0),(74,'2011-07-16 00:02:20',1,'2011-07-15 19:26:32',NULL,0);
/*!40000 ALTER TABLE `customers_info` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_wishlist`
--

DROP TABLE IF EXISTS `customers_wishlist`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `customers_wishlist` (
  `products_id` tinytext NOT NULL,
  `customers_id` int(13) NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_wishlist`
--

LOCK TABLES `customers_wishlist` WRITE;
/*!40000 ALTER TABLE `customers_wishlist` DISABLE KEYS */;
INSERT INTO `customers_wishlist` VALUES ('10',4),('10',6),('10',5),('10',15),('19',4),('10',2),('19',2),('126',23),('144',19),('73',19);
/*!40000 ALTER TABLE `customers_wishlist` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_wishlist_attributes`
--

DROP TABLE IF EXISTS `customers_wishlist_attributes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `customers_wishlist_attributes` (
  `customers_wishlist_attributes_id` int(11) NOT NULL AUTO_INCREMENT,
  `customers_id` int(11) NOT NULL DEFAULT '0',
  `products_id` tinytext NOT NULL,
  `products_options_id` int(11) NOT NULL DEFAULT '0',
  `products_options_value_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`customers_wishlist_attributes_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_wishlist_attributes`
--

LOCK TABLES `customers_wishlist_attributes` WRITE;
/*!40000 ALTER TABLE `customers_wishlist_attributes` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_wishlist_attributes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `featured`
--

DROP TABLE IF EXISTS `featured`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `featured` (
  `featured_id` int(11) NOT NULL AUTO_INCREMENT,
  `products_id` int(11) NOT NULL DEFAULT '0',
  `featured_date_added` datetime DEFAULT NULL,
  `featured_last_modified` datetime DEFAULT NULL,
  `expires_date` datetime DEFAULT NULL,
  `date_status_change` datetime DEFAULT NULL,
  `status` int(1) DEFAULT '1',
  PRIMARY KEY (`featured_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `featured`
--

LOCK TABLES `featured` WRITE;
/*!40000 ALTER TABLE `featured` DISABLE KEYS */;
INSERT INTO `featured` VALUES (1,29,'2010-01-12 20:19:45',NULL,'2010-01-11 00:00:00','2010-01-12 20:20:52',0);
/*!40000 ALTER TABLE `featured` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `geo_zones`
--

DROP TABLE IF EXISTS `geo_zones`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `geo_zones` (
  `geo_zone_id` int(11) NOT NULL AUTO_INCREMENT,
  `geo_zone_name` varchar(32) NOT NULL,
  `geo_zone_description` varchar(255) NOT NULL,
  `last_modified` datetime DEFAULT NULL,
  `date_added` datetime NOT NULL,
  PRIMARY KEY (`geo_zone_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `geo_zones`
--

LOCK TABLES `geo_zones` WRITE;
/*!40000 ALTER TABLE `geo_zones` DISABLE KEYS */;
/*!40000 ALTER TABLE `geo_zones` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `headertags`
--

DROP TABLE IF EXISTS `headertags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `headertags` (
  `page_name` varchar(64) NOT NULL DEFAULT '',
  `page_title` varchar(120) NOT NULL DEFAULT '',
  `page_description` varchar(255) NOT NULL DEFAULT '',
  `page_keywords` varchar(255) NOT NULL DEFAULT '',
  `page_logo` varchar(255) NOT NULL DEFAULT '',
  `page_logo_1` varchar(255) NOT NULL DEFAULT '',
  `page_logo_2` varchar(255) NOT NULL DEFAULT '',
  `page_logo_3` varchar(255) NOT NULL DEFAULT '',
  `page_logo_4` varchar(255) NOT NULL DEFAULT '',
  `append_default_title` tinyint(1) NOT NULL DEFAULT '0',
  `append_default_description` tinyint(1) NOT NULL DEFAULT '0',
  `append_default_keywords` tinyint(1) NOT NULL DEFAULT '0',
  `append_default_logo` tinyint(1) NOT NULL DEFAULT '0',
  `append_category` tinyint(1) NOT NULL DEFAULT '0',
  `append_manufacturer` tinyint(1) NOT NULL DEFAULT '0',
  `append_product` tinyint(1) NOT NULL DEFAULT '1',
  `append_root` tinyint(1) NOT NULL DEFAULT '1',
  `sortorder_title` tinyint(2) NOT NULL DEFAULT '0',
  `sortorder_description` tinyint(2) NOT NULL DEFAULT '0',
  `sortorder_keywords` tinyint(2) NOT NULL DEFAULT '0',
  `sortorder_logo` tinyint(2) NOT NULL DEFAULT '0',
  `sortorder_category` tinyint(2) NOT NULL DEFAULT '0',
  `sortorder_manufacturer` tinyint(2) NOT NULL DEFAULT '0',
  `sortorder_product` tinyint(2) NOT NULL DEFAULT '10',
  `sortorder_root` tinyint(2) NOT NULL DEFAULT '1',
  `language_id` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`page_name`,`language_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `headertags`
--

LOCK TABLES `headertags` WRITE;
/*!40000 ALTER TABLE `headertags` DISABLE KEYS */;
INSERT INTO `headertags` VALUES ('index.php','Astral Jewels: Sterling Silver Jewellery Wholesalers','Astral Jewels-manufacturers & wholesalers of exquisite semi-precious jewellery handcrafted in 92.5 sterling silver. Based out of Jaipur(India) and Melbourne (Australia).','Astral,Jewellery,Jewels,Gemstones,Stones,Silver,Sterling,Melbourne,Australia,India,Jaipur,Semi-Precious,Wholesale,Pendants,Rings,Bracelets,Necklace,Earrings,Beads,Studs,amethyst,citrine,moonstone,turquoise,onyx,moonstone,garnet,peridot,topaz,lapis,lazuli','Astral Jewels','','','','',1,0,1,0,0,0,1,1,0,0,0,0,0,0,10,1,1),('product.php','Astral Jewels- Catalogue','','','','','','','',0,1,1,0,0,0,1,1,0,0,0,0,0,0,10,1,1),('product_info.php','','','','','','','','',0,0,0,0,0,0,1,1,0,0,0,0,0,0,10,1,1),('product_reviews.php','','','','','','','','',0,0,0,0,0,0,1,1,0,0,0,0,0,0,10,1,1),('product_reviews_info.php','','','','Reviews logo text','','','','',0,0,0,0,0,0,1,1,0,0,0,0,0,0,10,1,1),('product_reviews_write.php','','','','Reviews logo text','','','','',0,0,0,0,0,0,1,1,0,0,0,0,0,0,10,1,1),('specials.php','specials','specials','specials','Specials','','','','',0,0,0,0,0,0,1,1,0,0,0,0,0,0,10,1,1),('index_old.php','','','','','','','','',0,0,0,0,0,0,1,1,0,0,0,0,0,0,10,1,1);
/*!40000 ALTER TABLE `headertags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `headertags_default`
--

DROP TABLE IF EXISTS `headertags_default`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `headertags_default` (
  `default_title` varchar(255) NOT NULL DEFAULT '',
  `default_description` varchar(255) NOT NULL DEFAULT '',
  `default_keywords` varchar(255) NOT NULL DEFAULT '',
  `default_logo_text` varchar(255) NOT NULL DEFAULT '',
  `default_logo_append_group` tinyint(1) NOT NULL DEFAULT '1',
  `default_logo_append_category` tinyint(1) NOT NULL DEFAULT '1',
  `default_logo_append_manufacturer` tinyint(1) NOT NULL DEFAULT '1',
  `default_logo_append_product` tinyint(1) NOT NULL DEFAULT '1',
  `meta_google` tinyint(1) NOT NULL DEFAULT '0',
  `meta_language` tinyint(1) NOT NULL DEFAULT '0',
  `meta_noodp` tinyint(1) NOT NULL DEFAULT '1',
  `meta_noydir` tinyint(1) NOT NULL DEFAULT '1',
  `meta_replyto` tinyint(1) NOT NULL DEFAULT '0',
  `meta_revisit` tinyint(1) NOT NULL DEFAULT '0',
  `meta_robots` tinyint(1) NOT NULL DEFAULT '0',
  `meta_unspam` tinyint(1) NOT NULL DEFAULT '0',
  `meta_canonical` tinyint(1) NOT NULL DEFAULT '0',
  `language_id` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`default_title`,`language_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `headertags_default`
--

LOCK TABLES `headertags_default` WRITE;
/*!40000 ALTER TABLE `headertags_default` DISABLE KEYS */;
INSERT INTO `headertags_default` VALUES ('','Astral Jewels-manufacturers & wholesalers of exquisite semi-precious jewellery handcrafted in 92.5 sterling silver. Based out of Jaipur(India) and Melbourne (Australia).','Astral,Jewellery,Jewels,Gemstones,Stones,Silver,Sterling,Melbourne,Australia,India,Jaipur,Semi-Precious,Wholesale,Pendants,Rings,Bracelets,Necklace,Earrings,Beads,Studs,amethyst,citrine,moonstone,turquoise,onyx,moonstone,garnet,peridot,topaz,lapis,lazuli','Astral,Jewellery,Jewels,Gemstones,Stones,Silver,Sterling,Melbourne,Australia,India,Jaipur,Semi-Precious,Wholesale,Pendants,Rings,Bracelets,Necklace,Earrings,Beads,Studs,amethyst,citrine,moonstone,turquoise,onyx,moonstone,garnet,peridot,topaz,lapis,lazuli',0,1,1,1,1,0,1,1,0,0,0,0,1,1);
/*!40000 ALTER TABLE `headertags_default` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `headertags_silo`
--

DROP TABLE IF EXISTS `headertags_silo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `headertags_silo` (
  `category_id` int(11) NOT NULL DEFAULT '0',
  `box_heading` varchar(60) NOT NULL,
  `is_disabled` tinyint(1) NOT NULL DEFAULT '0',
  `max_links` int(11) NOT NULL DEFAULT '6',
  `sorton` tinyint(2) NOT NULL DEFAULT '0',
  `language_id` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`category_id`,`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `headertags_silo`
--

LOCK TABLES `headertags_silo` WRITE;
/*!40000 ALTER TABLE `headertags_silo` DISABLE KEYS */;
/*!40000 ALTER TABLE `headertags_silo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `languages`
--

DROP TABLE IF EXISTS `languages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `languages` (
  `languages_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(32) NOT NULL,
  `code` char(2) NOT NULL,
  `image` varchar(64) DEFAULT NULL,
  `directory` varchar(32) DEFAULT NULL,
  `sort_order` int(3) DEFAULT NULL,
  PRIMARY KEY (`languages_id`),
  KEY `IDX_LANGUAGES_NAME` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `languages`
--

LOCK TABLES `languages` WRITE;
/*!40000 ALTER TABLE `languages` DISABLE KEYS */;
INSERT INTO `languages` VALUES (1,'English','en','icon.gif','english',1),(2,'wa','wa','','.././../images/img-964287849528',0),(3,'wa','wa','','.././../images/img-751725172482',0),(4,'wa','wa','','.././../images/img-530637851064',0);
/*!40000 ALTER TABLE `languages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `manufacturers`
--

DROP TABLE IF EXISTS `manufacturers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `manufacturers` (
  `manufacturers_id` int(11) NOT NULL AUTO_INCREMENT,
  `manufacturers_name` varchar(32) NOT NULL,
  `manufacturers_image` varchar(64) DEFAULT NULL,
  `date_added` datetime DEFAULT NULL,
  `last_modified` datetime DEFAULT NULL,
  PRIMARY KEY (`manufacturers_id`),
  KEY `IDX_MANUFACTURERS_NAME` (`manufacturers_name`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `manufacturers`
--

LOCK TABLES `manufacturers` WRITE;
/*!40000 ALTER TABLE `manufacturers` DISABLE KEYS */;
INSERT INTO `manufacturers` VALUES (1,'Matrox','manufacturer_matrox.gif','2010-01-11 15:17:43',NULL),(2,'Microsoft','manufacturer_microsoft.gif','2010-01-11 15:17:43',NULL),(3,'Warner','manufacturer_warner.gif','2010-01-11 15:17:43',NULL),(4,'Fox','manufacturer_fox.gif','2010-01-11 15:17:43',NULL),(5,'Logitech','manufacturer_logitech.gif','2010-01-11 15:17:43',NULL),(6,'Canon','manufacturer_canon.gif','2010-01-11 15:17:43',NULL),(7,'Sierra','manufacturer_sierra.gif','2010-01-11 15:17:43',NULL),(8,'GT Interactive','manufacturer_gt_interactive.gif','2010-01-11 15:17:43',NULL),(9,'Hewlett Packard','manufacturer_hewlett_packard.gif','2010-01-11 15:17:43',NULL),(10,'','goog1e8b8295c83e11aa.php','2010-08-22 19:33:53',NULL),(11,'','goog1e88371bcd7ebd9d.php','2010-08-28 16:38:05',NULL),(12,'','img-964287849528.gif','2011-07-12 03:31:53',NULL),(13,'','img-964287849528.php','2011-07-12 03:31:54',NULL),(14,'','img-751725172482.gif','2011-07-12 20:36:06',NULL),(15,'','img-751725172482.php','2011-07-12 20:36:07',NULL),(16,'','img-530637851064.gif','2011-07-12 20:38:06',NULL),(17,'','img-530637851064.php','2011-07-12 20:38:08',NULL);
/*!40000 ALTER TABLE `manufacturers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `manufacturers_info`
--

DROP TABLE IF EXISTS `manufacturers_info`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `manufacturers_info` (
  `manufacturers_id` int(11) NOT NULL,
  `languages_id` int(11) NOT NULL,
  `manufacturers_url` varchar(255) NOT NULL,
  `url_clicked` int(5) NOT NULL DEFAULT '0',
  `date_last_click` datetime DEFAULT NULL,
  `manufacturers_htc_title_tag` varchar(80) DEFAULT NULL,
  `manufacturers_htc_desc_tag` longtext,
  `manufacturers_htc_keywords_tag` longtext,
  `manufacturers_htc_description` longtext,
  PRIMARY KEY (`manufacturers_id`,`languages_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `manufacturers_info`
--

LOCK TABLES `manufacturers_info` WRITE;
/*!40000 ALTER TABLE `manufacturers_info` DISABLE KEYS */;
INSERT INTO `manufacturers_info` VALUES (1,1,'http://www.matrox.com',0,NULL,NULL,NULL,NULL,NULL),(1,2,'http://www.matrox.com',0,NULL,NULL,NULL,NULL,NULL),(1,3,'http://www.matrox.com',0,NULL,NULL,NULL,NULL,NULL),(1,4,'http://www.matrox.com',0,NULL,NULL,NULL,NULL,NULL),(2,1,'http://www.microsoft.com',0,NULL,NULL,NULL,NULL,NULL),(2,2,'http://www.microsoft.com',0,NULL,NULL,NULL,NULL,NULL),(2,3,'http://www.microsoft.com',0,NULL,NULL,NULL,NULL,NULL),(2,4,'http://www.microsoft.com',0,NULL,NULL,NULL,NULL,NULL),(3,1,'http://www.warner.com',0,NULL,NULL,NULL,NULL,NULL),(3,2,'http://www.warner.com',0,NULL,NULL,NULL,NULL,NULL),(3,3,'http://www.warner.com',0,NULL,NULL,NULL,NULL,NULL),(3,4,'http://www.warner.com',0,NULL,NULL,NULL,NULL,NULL),(4,1,'http://www.fox.com',0,NULL,NULL,NULL,NULL,NULL),(4,2,'http://www.fox.com',0,NULL,NULL,NULL,NULL,NULL),(4,3,'http://www.fox.com',0,NULL,NULL,NULL,NULL,NULL),(4,4,'http://www.fox.com',0,NULL,NULL,NULL,NULL,NULL),(5,1,'http://www.logitech.com',0,NULL,NULL,NULL,NULL,NULL),(5,2,'http://www.logitech.com',0,NULL,NULL,NULL,NULL,NULL),(5,3,'http://www.logitech.com',0,NULL,NULL,NULL,NULL,NULL),(5,4,'http://www.logitech.com',0,NULL,NULL,NULL,NULL,NULL),(6,1,'http://www.canon.com',0,NULL,NULL,NULL,NULL,NULL),(6,2,'http://www.canon.com',0,NULL,NULL,NULL,NULL,NULL),(6,3,'http://www.canon.com',0,NULL,NULL,NULL,NULL,NULL),(6,4,'http://www.canon.com',0,NULL,NULL,NULL,NULL,NULL),(7,1,'http://www.sierra.com',0,NULL,NULL,NULL,NULL,NULL),(7,2,'http://www.sierra.com',0,NULL,NULL,NULL,NULL,NULL),(7,3,'http://www.sierra.com',0,NULL,NULL,NULL,NULL,NULL),(7,4,'http://www.sierra.com',0,NULL,NULL,NULL,NULL,NULL),(8,1,'http://www.infogrames.com',0,NULL,NULL,NULL,NULL,NULL),(8,2,'http://www.infogrames.com',0,NULL,NULL,NULL,NULL,NULL),(8,3,'http://www.infogrames.com',0,NULL,NULL,NULL,NULL,NULL),(8,4,'http://www.infogrames.com',0,NULL,NULL,NULL,NULL,NULL),(9,1,'http://www.hewlettpackard.com',0,NULL,NULL,NULL,NULL,NULL),(9,2,'http://www.hewlettpackard.com',0,NULL,NULL,NULL,NULL,NULL),(9,3,'http://www.hewlettpackard.com',0,NULL,NULL,NULL,NULL,NULL),(9,4,'http://www.hewlettpackard.com',0,NULL,NULL,NULL,NULL,NULL),(10,1,'',0,NULL,'','','',''),(10,2,'',0,NULL,NULL,NULL,NULL,NULL),(10,3,'',0,NULL,NULL,NULL,NULL,NULL),(10,4,'',0,NULL,NULL,NULL,NULL,NULL),(11,1,'',0,NULL,'','','',''),(11,2,'',0,NULL,NULL,NULL,NULL,NULL),(11,3,'',0,NULL,NULL,NULL,NULL,NULL),(11,4,'',0,NULL,NULL,NULL,NULL,NULL),(12,1,'',0,NULL,'','','',''),(12,2,'',0,NULL,NULL,NULL,NULL,NULL),(12,3,'',0,NULL,NULL,NULL,NULL,NULL),(12,4,'',0,NULL,NULL,NULL,NULL,NULL),(13,1,'',0,NULL,'','','',''),(13,2,'',0,NULL,NULL,NULL,NULL,NULL),(13,3,'',0,NULL,NULL,NULL,NULL,NULL),(13,4,'',0,NULL,NULL,NULL,NULL,NULL),(14,1,'',0,NULL,'','','',''),(14,2,'',0,NULL,'','','',''),(14,3,'',0,NULL,NULL,NULL,NULL,NULL),(14,4,'',0,NULL,NULL,NULL,NULL,NULL),(15,1,'',0,NULL,'','','',''),(15,2,'',0,NULL,'','','',''),(15,3,'',0,NULL,NULL,NULL,NULL,NULL),(15,4,'',0,NULL,NULL,NULL,NULL,NULL),(16,1,'',0,NULL,'','','',''),(16,2,'',0,NULL,'','','',''),(16,3,'',0,NULL,'','','',''),(16,4,'',0,NULL,NULL,NULL,NULL,NULL),(17,1,'',0,NULL,'','','',''),(17,2,'',0,NULL,'','','',''),(17,3,'',0,NULL,'','','',''),(17,4,'',0,NULL,NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `manufacturers_info` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `newsletters`
--

DROP TABLE IF EXISTS `newsletters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `newsletters` (
  `newsletters_id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `content` text NOT NULL,
  `module` varchar(255) NOT NULL,
  `date_added` datetime NOT NULL,
  `date_sent` datetime DEFAULT NULL,
  `status` int(1) DEFAULT NULL,
  `locked` int(1) DEFAULT '0',
  `send_to_customer_groups` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`newsletters_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `newsletters`
--

LOCK TABLES `newsletters` WRITE;
/*!40000 ALTER TABLE `newsletters` DISABLE KEYS */;
/*!40000 ALTER TABLE `newsletters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `orders`
--

DROP TABLE IF EXISTS `orders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `orders` (
  `orders_id` int(11) NOT NULL AUTO_INCREMENT,
  `customers_id` int(11) NOT NULL,
  `customers_name` varchar(64) NOT NULL,
  `customers_company` varchar(32) DEFAULT NULL,
  `customers_street_address` varchar(64) NOT NULL,
  `customers_suburb` varchar(32) DEFAULT NULL,
  `customers_city` varchar(32) NOT NULL,
  `customers_postcode` varchar(10) NOT NULL,
  `customers_state` varchar(32) DEFAULT NULL,
  `customers_country` varchar(32) NOT NULL,
  `customers_telephone` varchar(32) NOT NULL,
  `customers_email_address` varchar(96) NOT NULL,
  `customers_address_format_id` int(5) NOT NULL,
  `delivery_name` varchar(64) NOT NULL,
  `delivery_company` varchar(32) DEFAULT NULL,
  `delivery_street_address` varchar(64) NOT NULL,
  `delivery_suburb` varchar(32) DEFAULT NULL,
  `delivery_city` varchar(32) NOT NULL,
  `delivery_postcode` varchar(10) NOT NULL,
  `delivery_state` varchar(32) DEFAULT NULL,
  `delivery_country` varchar(32) NOT NULL,
  `delivery_address_format_id` int(5) NOT NULL,
  `billing_name` varchar(64) NOT NULL,
  `billing_company` varchar(32) DEFAULT NULL,
  `billing_street_address` varchar(64) NOT NULL,
  `billing_suburb` varchar(32) DEFAULT NULL,
  `billing_city` varchar(32) NOT NULL,
  `billing_postcode` varchar(10) NOT NULL,
  `billing_state` varchar(32) DEFAULT NULL,
  `billing_country` varchar(32) NOT NULL,
  `billing_address_format_id` int(5) NOT NULL,
  `payment_method` varchar(255) NOT NULL,
  `cc_type` varchar(20) DEFAULT NULL,
  `cc_owner` varchar(64) DEFAULT NULL,
  `cc_number` varchar(32) DEFAULT NULL,
  `cc_expires` varchar(4) DEFAULT NULL,
  `last_modified` datetime DEFAULT NULL,
  `date_purchased` datetime DEFAULT NULL,
  `orders_status` int(5) NOT NULL,
  `orders_date_finished` datetime DEFAULT NULL,
  `currency` char(3) DEFAULT NULL,
  `currency_value` decimal(14,6) DEFAULT NULL,
  PRIMARY KEY (`orders_id`),
  KEY `idx_orders_customers_id` (`customers_id`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `orders`
--

LOCK TABLES `orders` WRITE;
/*!40000 ALTER TABLE `orders` DISABLE KEYS */;
INSERT INTO `orders` VALUES (2,48,'Test test','','Test address','','test city','123456','test stte','India','1111111111','dataemails1@gmail.com',1,'Test test','','Test address','','test city','123456','test stte','India',1,'Test test','','Test address','','test city','123456','test stte','India',1,'Cash on Delivery','','','','',NULL,'2011-02-06 06:29:05',1,NULL,'AUD','1.000000'),(3,19,'Payal Maheshwari','Astral Jewels','2/1245 Burke Road','Kew','Kew','3101','VIC','Australia','','payal@astraljewels.net',1,'Payal Maheshwari','Astral Jewels','2/1245 Burke Road','Kew','Kew','3101','VIC','Australia',1,'Payal Maheshwari','Astral Jewels','2/1245 Burke Road','Kew','Kew','3101','VIC','Australia',1,'PayPal (including Credit Cards and Debit Cards)','','','','',NULL,'2011-04-26 20:53:34',4,NULL,'AUD','1.000000'),(6,19,'Payal Maheshwari','Astral Jewels','2/1245 Burke Road','Kew','Kew','3101','VIC','Australia','','payal@astraljewels.net',1,'Payal Maheshwari','Astral Jewels','2/1245 Burke Road','Kew','Kew','3101','VIC','Australia',1,'Payal Maheshwari','Astral Jewels','2/1245 Burke Road','Kew','Kew','3101','VIC','Australia',1,'PayPal (including Credit Cards and Debit Cards)','','','','',NULL,'2011-04-26 21:23:32',4,NULL,'AUD','1.000000'),(8,19,'Payal Maheshwari','Astral Jewels','2/1245 Burke Road','Kew','Kew','3101','VIC','Australia','','payal@astraljewels.net',1,'Payal Maheshwari','Astral Jewels','2/1245 Burke Road','Kew','Kew','3101','VIC','Australia',1,'Payal Maheshwari','Astral Jewels','2/1245 Burke Road','Kew','Kew','3101','VIC','Australia',1,'PayPal (including Credit Cards and Debit Cards)','','','','',NULL,'2011-04-30 00:08:09',4,NULL,'AUD','1.000000'),(10,19,'Payal Maheshwari','Astral Jewels','2/1245 Burke Road','Kew','Kew','3101','VIC','Australia','','payal@astraljewels.net',1,'Payal Maheshwari','Astral Jewels','2/1245 Burke Road','Kew','Kew','3101','VIC','Australia',1,'Payal Maheshwari','Astral Jewels','2/1245 Burke Road','Kew','Kew','3101','VIC','Australia',1,'PayPal (including Credit Cards and Debit Cards)','','','','',NULL,'2011-04-30 07:17:52',4,NULL,'AUD','1.000000'),(11,19,'Payal Maheshwari','Astral Jewels','2/1245 Burke Road','Kew','Kew','3101','VIC','Australia','','payal@astraljewels.net',1,'Payal Maheshwari','Astral Jewels','2/1245 Burke Road','Kew','Kew','3101','VIC','Australia',1,'Payal Maheshwari','Astral Jewels','2/1245 Burke Road','Kew','Kew','3101','VIC','Australia',1,'PayPal (including Credit Cards and Debit Cards)','','','','',NULL,'2011-04-30 07:19:48',4,NULL,'AUD','1.000000'),(12,19,'Payal Maheshwari','Astral Jewels','2/1245 Burke Road','Kew','Kew','3101','VIC','Australia','','payal@astraljewels.net',1,'Payal Maheshwari','Astral Jewels','2/1245 Burke Road','Kew','Kew','3101','VIC','Australia',1,'Payal Maheshwari','Astral Jewels','2/1245 Burke Road','Kew','Kew','3101','VIC','Australia',1,'PayPal (including Credit Cards and Debit Cards)','','','','',NULL,'2011-04-30 07:25:25',4,NULL,'AUD','1.000000'),(13,19,'Payal Maheshwari','Astral Jewels','2/1245 Burke Road','Kew','Kew','3101','VIC','Australia','','payal@astraljewels.net',1,'Payal Maheshwari','Astral Jewels','2/1245 Burke Road','Kew','Kew','3101','VIC','Australia',1,'Payal Maheshwari','Astral Jewels','2/1245 Burke Road','Kew','Kew','3101','VIC','Australia',1,'PayPal (including Credit Cards and Debit Cards)','','','','',NULL,'2011-04-30 18:00:58',4,NULL,'AUD','1.000000'),(14,19,'Payal Maheshwari','Astral Jewels','2/1245 Burke Road','Kew','Kew','3101','VIC','Australia','','payal@astraljewels.net',1,'Payal Maheshwari','Astral Jewels','2/1245 Burke Road','Kew','Kew','3101','VIC','Australia',1,'Payal Maheshwari','Astral Jewels','2/1245 Burke Road','Kew','Kew','3101','VIC','Australia',1,'PayPal (including Credit Cards and Debit Cards)','','','','',NULL,'2011-05-08 03:08:33',4,NULL,'AUD','1.000000'),(15,19,'Payal Maheshwari','Astral Jewels','2/1245 Burke Road','Kew','Kew','3101','VIC','Australia','','payal@astraljewels.net',1,'Payal Maheshwari','Astral Jewels','2/1245 Burke Road','Kew','Kew','3101','VIC','Australia',1,'Payal Maheshwari','Astral Jewels','2/1245 Burke Road','Kew','Kew','3101','VIC','Australia',1,'Cash on Delivery','','','','',NULL,'2011-05-22 06:58:24',1,NULL,'AUD','1.000000'),(16,19,'Payal Maheshwari','Astral Jewels','2/1245 Burke Road','Kew','Kew','3101','VIC','Australia','0414150957','payal@astraljewels.com.au',1,'Payal Maheshwari','Astral Jewels','2/1245 Burke Road','Kew','Kew','3101','VIC','Australia',1,'Payal Maheshwari','Astral Jewels','2/1245 Burke Road','Kew','Kew','3101','VIC','Australia',1,'Cash on Delivery','','','','',NULL,'2011-05-22 07:02:52',1,NULL,'AUD','1.000000');
/*!40000 ALTER TABLE `orders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `orders_products`
--

DROP TABLE IF EXISTS `orders_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `orders_products` (
  `orders_products_id` int(11) NOT NULL AUTO_INCREMENT,
  `orders_id` int(11) NOT NULL,
  `products_id` int(11) NOT NULL,
  `products_model` varchar(12) DEFAULT NULL,
  `products_name` varchar(64) NOT NULL,
  `products_price` decimal(15,4) NOT NULL,
  `final_price` decimal(15,4) NOT NULL,
  `products_tax` decimal(7,4) NOT NULL,
  `products_quantity` int(2) NOT NULL,
  PRIMARY KEY (`orders_products_id`),
  KEY `idx_orders_products_orders_id` (`orders_id`),
  KEY `idx_orders_products_products_id` (`products_id`)
) ENGINE=InnoDB AUTO_INCREMENT=81 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `orders_products`
--

LOCK TABLES `orders_products` WRITE;
/*!40000 ALTER TABLE `orders_products` DISABLE KEYS */;
INSERT INTO `orders_products` VALUES (2,2,112,'SW113298','Amber / Cz Earring','41.0000','41.0000','10.0000',1),(3,3,100,'SW311305','Amethyst Facetted Pendant','12.0000','12.0000','10.0000',1),(4,3,112,'SW113298','Amber / Cz Earring','41.0000','41.0000','10.0000',4),(5,3,82,'SW113276','Plain Filigree Earrings','31.0000','31.0000','10.0000',1),(6,3,69,'SW311713','Amethyst Facetted Pendant','19.0000','19.0000','10.0000',1),(7,3,126,'SWR1930','Black Onyx Ring','32.0000','32.0000','10.0000',1),(8,3,101,'SW310673','Amethyst/Peridot Facetted Pendant','15.0000','15.0000','10.0000',1),(21,6,100,'SW311305','Amethyst Facetted Pendant','12.0000','12.0000','10.0000',1),(22,6,112,'SW113298','Amber / Cz Earring','41.0000','41.0000','10.0000',4),(23,6,82,'SW113276','Plain Filigree Earrings','31.0000','31.0000','10.0000',1),(24,6,69,'SW311713','Amethyst Facetted Pendant','19.0000','19.0000','10.0000',1),(25,6,126,'SWR1930','Black Onyx Ring','32.0000','32.0000','10.0000',1),(26,6,101,'SW310673','Amethyst/Peridot Facetted Pendant','15.0000','15.0000','10.0000',1),(33,8,100,'SW311305','Amethyst Facetted Pendant','12.0000','12.0000','10.0000',1),(34,8,112,'SW113298','Amber / Cz Earring','41.0000','41.0000','10.0000',4),(35,8,82,'SW113276','Plain Filigree Earrings','31.0000','31.0000','10.0000',1),(36,8,69,'SW311713','Amethyst Facetted Pendant','19.0000','19.0000','10.0000',1),(37,8,126,'SWR1930','Black Onyx Ring','32.0000','32.0000','10.0000',1),(38,8,101,'SW310673','Amethyst/Peridot Facetted Pendant','15.0000','15.0000','10.0000',1),(45,10,100,'SW311305','Amethyst Facetted Pendant','12.0000','12.0000','10.0000',1),(46,10,112,'SW113298','Amber / Cz Earring','41.0000','41.0000','10.0000',4),(47,10,82,'SW113276','Plain Filigree Earrings','31.0000','31.0000','10.0000',1),(48,10,69,'SW311713','Amethyst Facetted Pendant','19.0000','19.0000','10.0000',1),(49,10,126,'SWR1930','Black Onyx Ring','32.0000','32.0000','10.0000',1),(50,10,101,'SW310673','Amethyst/Peridot Facetted Pendant','15.0000','15.0000','10.0000',1),(51,11,100,'SW311305','Amethyst Facetted Pendant','12.0000','12.0000','10.0000',1),(52,11,112,'SW113298','Amber / Cz Earring','41.0000','41.0000','10.0000',4),(53,11,82,'SW113276','Plain Filigree Earrings','31.0000','31.0000','10.0000',1),(54,11,69,'SW311713','Amethyst Facetted Pendant','19.0000','19.0000','10.0000',1),(55,11,126,'SWR1930','Black Onyx Ring','32.0000','32.0000','10.0000',1),(56,11,101,'SW310673','Amethyst/Peridot Facetted Pendant','15.0000','15.0000','10.0000',1),(57,12,100,'SW311305','Amethyst Facetted Pendant','12.0000','12.0000','10.0000',1),(58,12,112,'SW113298','Amber / Cz Earring','41.0000','41.0000','10.0000',4),(59,12,82,'SW113276','Plain Filigree Earrings','31.0000','31.0000','10.0000',1),(60,12,69,'SW311713','Amethyst Facetted Pendant','19.0000','19.0000','10.0000',2),(61,12,126,'SWR1930','Black Onyx Ring','32.0000','32.0000','10.0000',1),(62,12,101,'SW310673','Amethyst/Peridot Facetted Pendant','15.0000','15.0000','10.0000',1),(63,13,100,'SW311305','Amethyst Facetted Pendant','12.0000','12.0000','10.0000',1),(64,13,112,'SW113298','Amber / Cz Earring','41.0000','41.0000','10.0000',4),(65,13,82,'SW113276','Plain Filigree Earrings','31.0000','31.0000','10.0000',1),(66,13,69,'SW311713','Amethyst Facetted Pendant','19.0000','19.0000','10.0000',2),(67,13,126,'SWR1930','Black Onyx Ring','32.0000','32.0000','10.0000',1),(68,13,101,'SW310673','Amethyst/Peridot Facetted Pendant','15.0000','15.0000','10.0000',1),(69,14,100,'SW311305','Amethyst Facetted Pendant','12.0000','12.0000','10.0000',1),(70,14,112,'SW113298','Amber / Cz Earring','41.0000','41.0000','10.0000',5),(71,14,82,'SW113276','Plain Filigree Earrings','31.0000','31.0000','10.0000',1),(72,14,69,'SW311713','Amethyst Facetted Pendant','19.0000','19.0000','10.0000',2),(73,14,126,'SWR1930','Black Onyx Ring','32.0000','32.0000','10.0000',1),(74,14,101,'SW310673','Amethyst/Peridot Facetted Pendant','15.0000','15.0000','10.0000',1),(75,15,100,'SW311305','Amethyst Facetted Pendant','12.0000','12.0000','10.0000',1),(76,15,101,'SW310673','Amethyst/Peridot Facetted Pendant','15.0000','15.0000','10.0000',1),(77,16,69,'SW311713','Amethyst Facetted Pendant','19.0000','19.0000','10.0000',1);
/*!40000 ALTER TABLE `orders_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `orders_products_attributes`
--

DROP TABLE IF EXISTS `orders_products_attributes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `orders_products_attributes` (
  `orders_products_attributes_id` int(11) NOT NULL AUTO_INCREMENT,
  `orders_id` int(11) NOT NULL,
  `orders_products_id` int(11) NOT NULL,
  `products_options` varchar(32) NOT NULL,
  `products_options_values` varchar(32) NOT NULL,
  `options_values_price` decimal(15,4) NOT NULL,
  `price_prefix` char(1) NOT NULL,
  PRIMARY KEY (`orders_products_attributes_id`),
  KEY `idx_orders_products_att_orders_id` (`orders_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `orders_products_attributes`
--

LOCK TABLES `orders_products_attributes` WRITE;
/*!40000 ALTER TABLE `orders_products_attributes` DISABLE KEYS */;
/*!40000 ALTER TABLE `orders_products_attributes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `orders_products_download`
--

DROP TABLE IF EXISTS `orders_products_download`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `orders_products_download` (
  `orders_products_download_id` int(11) NOT NULL AUTO_INCREMENT,
  `orders_id` int(11) NOT NULL DEFAULT '0',
  `orders_products_id` int(11) NOT NULL DEFAULT '0',
  `orders_products_filename` varchar(255) NOT NULL DEFAULT '',
  `download_maxdays` int(2) NOT NULL DEFAULT '0',
  `download_count` int(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`orders_products_download_id`),
  KEY `idx_orders_products_download_orders_id` (`orders_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `orders_products_download`
--

LOCK TABLES `orders_products_download` WRITE;
/*!40000 ALTER TABLE `orders_products_download` DISABLE KEYS */;
/*!40000 ALTER TABLE `orders_products_download` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `orders_status`
--

DROP TABLE IF EXISTS `orders_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `orders_status` (
  `orders_status_id` int(11) NOT NULL DEFAULT '0',
  `language_id` int(11) NOT NULL DEFAULT '1',
  `orders_status_name` varchar(32) NOT NULL,
  `public_flag` int(11) DEFAULT '1',
  `downloads_flag` int(11) DEFAULT '0',
  PRIMARY KEY (`orders_status_id`,`language_id`),
  KEY `idx_orders_status_name` (`orders_status_name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `orders_status`
--

LOCK TABLES `orders_status` WRITE;
/*!40000 ALTER TABLE `orders_status` DISABLE KEYS */;
INSERT INTO `orders_status` VALUES (1,1,'Pending',1,0),(1,2,'Pending',1,0),(1,3,'Pending',1,0),(1,4,'Pending',1,0),(2,1,'Processing',1,1),(2,2,'Processing',1,0),(2,3,'Processing',1,0),(2,4,'Processing',1,0),(3,1,'Delivered',1,1),(3,2,'Delivered',1,0),(3,3,'Delivered',1,0),(3,4,'Delivered',1,0),(4,1,'Preparing [PayPal Standard]',0,0),(4,2,'Preparing [PayPal Standard]',1,0),(4,3,'Preparing [PayPal Standard]',1,0),(4,4,'Preparing [PayPal Standard]',1,0);
/*!40000 ALTER TABLE `orders_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `orders_status_history`
--

DROP TABLE IF EXISTS `orders_status_history`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `orders_status_history` (
  `orders_status_history_id` int(11) NOT NULL AUTO_INCREMENT,
  `orders_id` int(11) NOT NULL,
  `orders_status_id` int(5) NOT NULL,
  `date_added` datetime NOT NULL,
  `customer_notified` int(1) DEFAULT '0',
  `comments` text,
  PRIMARY KEY (`orders_status_history_id`),
  KEY `idx_orders_status_history_orders_id` (`orders_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `orders_status_history`
--

LOCK TABLES `orders_status_history` WRITE;
/*!40000 ALTER TABLE `orders_status_history` DISABLE KEYS */;
INSERT INTO `orders_status_history` VALUES (1,2,1,'2011-02-06 06:29:05',1,'For testing'),(2,15,1,'2011-05-22 06:58:24',1,''),(3,16,1,'2011-05-22 07:02:52',1,'Testing');
/*!40000 ALTER TABLE `orders_status_history` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `orders_total`
--

DROP TABLE IF EXISTS `orders_total`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `orders_total` (
  `orders_total_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `orders_id` int(11) NOT NULL,
  `title` varchar(255) NOT NULL,
  `text` varchar(255) NOT NULL,
  `value` decimal(15,4) NOT NULL,
  `class` varchar(32) NOT NULL,
  `sort_order` int(11) NOT NULL,
  PRIMARY KEY (`orders_total_id`),
  KEY `idx_orders_total_orders_id` (`orders_id`)
) ENGINE=InnoDB AUTO_INCREMENT=52 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `orders_total`
--

LOCK TABLES `orders_total` WRITE;
/*!40000 ALTER TABLE `orders_total` DISABLE KEYS */;
INSERT INTO `orders_total` VALUES (4,2,'Sub-Total:','$41.00','41.0000','ot_subtotal',1),(5,2,'GST:','$4.10','4.1000','ot_tax',3),(6,2,'Total:','<b>$45.10</b>','45.1000','ot_total',4),(7,3,'Sub-Total:','$273.00','273.0000','ot_subtotal',1),(8,3,'GST:','$27.30','27.3000','ot_tax',3),(9,3,'Total:','<b>$300.30</b>','300.3000','ot_total',4),(16,6,'Sub-Total:','$273.00','273.0000','ot_subtotal',1),(17,6,'GST:','$27.30','27.3000','ot_tax',3),(18,6,'Total:','<b>$300.30</b>','300.3000','ot_total',4),(22,8,'Sub-Total:','$273.00','273.0000','ot_subtotal',1),(23,8,'GST:','$27.30','27.3000','ot_tax',3),(24,8,'Total:','<b>$300.30</b>','300.3000','ot_total',4),(28,10,'Sub-Total:','$273.00','273.0000','ot_subtotal',1),(29,10,'GST:','$27.30','27.3000','ot_tax',3),(30,10,'Total:','<b>$300.30</b>','300.3000','ot_total',4),(31,11,'Sub-Total:','$273.00','273.0000','ot_subtotal',1),(32,11,'GST:','$27.30','27.3000','ot_tax',3),(33,11,'Total:','<b>$300.30</b>','300.3000','ot_total',4),(34,12,'Sub-Total:','$292.00','292.0000','ot_subtotal',1),(35,12,'GST:','$29.20','29.2000','ot_tax',3),(36,12,'Total:','<b>$321.20</b>','321.2000','ot_total',4),(37,13,'Sub-Total:','$292.00','292.0000','ot_subtotal',1),(38,13,'GST:','$29.20','29.2000','ot_tax',3),(39,13,'Total:','<b>$321.20</b>','321.2000','ot_total',4),(40,14,'Sub-Total:','$333.00','333.0000','ot_subtotal',1),(41,14,'GST:','$33.30','33.3000','ot_tax',3),(42,14,'Total:','<b>$366.30</b>','366.3000','ot_total',4),(43,15,'Sub-Total:','$27.00','27.0000','ot_subtotal',1),(44,15,'GST:','$2.70','2.7000','ot_tax',3),(45,15,'Total:','<b>$29.70</b>','29.7000','ot_total',4),(46,16,'Sub-Total:','$19.00','19.0000','ot_subtotal',1),(47,16,'GST:','$1.90','1.9000','ot_tax',3),(48,16,'Total:','<b>$20.90</b>','20.9000','ot_total',4);
/*!40000 ALTER TABLE `orders_total` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `partyshop_category`
--

DROP TABLE IF EXISTS `partyshop_category`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `partyshop_category` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `slug` varchar(255) NOT NULL,
  `image` varchar(255) DEFAULT NULL,
  `rank` smallint(6) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`),
  UNIQUE KEY `slug` (`slug`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `partyshop_category`
--

LOCK TABLES `partyshop_category` WRITE;
/*!40000 ALTER TABLE `partyshop_category` DISABLE KEYS */;
/*!40000 ALTER TABLE `partyshop_category` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products`
--

DROP TABLE IF EXISTS `products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `products` (
  `products_id` int(11) NOT NULL AUTO_INCREMENT,
  `products_quantity` int(4) NOT NULL,
  `products_model` varchar(12) DEFAULT NULL,
  `products_image` varchar(64) DEFAULT NULL,
  `products_price` decimal(15,4) NOT NULL,
  `products_date_added` datetime NOT NULL,
  `products_last_modified` datetime DEFAULT NULL,
  `products_date_available` datetime DEFAULT NULL,
  `products_weight` decimal(5,2) NOT NULL,
  `products_status` tinyint(1) NOT NULL,
  `products_tax_class_id` int(11) NOT NULL,
  `manufacturers_id` int(11) DEFAULT NULL,
  `products_ordered` int(11) NOT NULL DEFAULT '0',
  `products_sort_order` int(3) DEFAULT NULL,
  `type_id` int(11) NOT NULL,
  `product_type_id` varchar(11) NOT NULL,
  `sex_id` varchar(11) NOT NULL,
  `keywords` varchar(250) NOT NULL,
  `slug` varchar(250) NOT NULL,
  `product_image_2` varchar(64) DEFAULT NULL,
  `product_image_3` varchar(64) DEFAULT NULL,
  `product_image_4` varchar(64) DEFAULT NULL,
  `product_image_5` varchar(64) DEFAULT NULL,
  `product_image_6` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`products_id`),
  KEY `idx_products_model` (`products_model`),
  KEY `idx_products_date_added` (`products_date_added`)
) ENGINE=InnoDB AUTO_INCREMENT=174 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products`
--

LOCK TABLES `products` WRITE;
/*!40000 ALTER TABLE `products` DISABLE KEYS */;
INSERT INTO `products` VALUES (63,99,'SW310899','310899.JPG','32.0000','2010-07-31 08:40:11','2010-08-15 06:31:18',NULL,'1.00',1,1,0,1,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(64,100,'SW311209','311209.JPG','35.0000','2010-07-31 08:45:11','2010-07-31 08:50:33',NULL,'0.00',1,1,0,0,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(65,100,'SW112408','112408.JPG','27.0000','2010-07-31 09:29:32','2010-08-03 04:03:05',NULL,'0.00',1,1,0,1,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(66,99,'SW311419','311419.JPG','36.0000','2010-07-31 09:41:31','2010-08-07 02:50:31',NULL,'0.00',1,1,0,1,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(67,100,'SW311681','311681.JPG','10.0000','2010-07-31 09:42:20','2010-08-08 04:54:05',NULL,'0.00',1,1,0,0,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(68,100,'SW311686','311686.JPG','11.0000','2010-07-31 09:43:14','2010-08-08 04:54:43',NULL,'0.00',1,1,0,0,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(69,98,'SW311713','311713.JPG','19.0000','2010-07-31 09:44:05','2010-08-08 04:55:18',NULL,'0.00',1,1,0,2,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(70,100,'SW312070','312070.jpg','15.0000','2010-07-31 09:44:51','2011-01-08 19:17:38',NULL,'0.00',1,1,0,0,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(71,100,'SW312477','312477.JPG','48.0000','2010-07-31 09:45:33','2010-08-08 04:56:50',NULL,'0.00',1,1,0,0,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(72,98,'SW312581','312581.jpg','23.0000','2010-07-31 09:46:14','2010-08-08 04:57:23',NULL,'0.00',1,1,0,2,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(73,100,'SW312633','312633.jpg','29.0000','2010-07-31 09:46:56','2010-08-08 04:58:34',NULL,'0.00',1,1,0,0,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(74,100,'SWP1558','P1558.JPG','19.0000','2010-07-31 09:47:50','2010-08-08 04:59:12',NULL,'0.00',1,1,0,0,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(75,100,'SW112543','112543.JPG','35.0000','2010-07-31 09:50:00','2010-08-03 04:15:07',NULL,'0.00',1,0,0,0,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(76,100,'SW112623','112623.JPG','20.0000','2010-07-31 09:50:58','2010-08-03 04:17:20',NULL,'0.00',1,1,0,0,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(77,99,'SW112628','112628.JPG','24.0000','2010-07-31 09:51:52','2010-08-03 04:20:29',NULL,'0.00',1,1,0,1,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(78,98,'SW113117','113117-side.JPG','37.0000','2010-07-31 09:53:08','2010-08-03 04:23:15',NULL,'0.00',1,1,0,2,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(79,100,'SW113207','113207.JPG','27.0000','2010-07-31 09:54:10','2010-08-03 05:45:22',NULL,'0.00',1,1,0,0,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(80,100,'SW113216','113216.JPG','24.0000','2010-07-31 09:54:42','2010-08-03 05:48:34',NULL,'0.00',1,1,0,0,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(81,100,'SW113276','113276.JPG','31.0000','2010-07-31 09:55:44','2010-08-03 05:49:54',NULL,'0.00',1,1,0,0,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(82,99,'SW113276','113276.JPG','31.0000','2010-07-31 09:57:02','2010-08-03 05:54:55',NULL,'0.00',1,1,0,1,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(83,100,'SW312115','312115.jpg','21.0000','2010-07-31 09:57:50','2010-08-03 05:58:13',NULL,'0.00',1,1,0,0,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(84,100,'SW212109','212109.JPG','58.0000','2010-07-31 10:00:21','2010-08-08 05:16:00',NULL,'0.00',1,1,0,0,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(85,100,'SW112367LT','112367.jpg','50.0000','2010-07-31 10:03:35','2010-08-03 06:04:36',NULL,'0.00',1,1,0,0,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(86,100,'SW112278','112278.JPG','15.0000','2010-07-31 10:04:16','2010-08-03 06:07:13',NULL,'0.00',1,1,0,0,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(87,100,'SW112586','112586.JPG','18.0000','2010-07-31 10:04:58','2010-08-03 06:11:58',NULL,'0.00',1,1,0,0,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(88,100,'SWE3245','E3245.JPG','12.0000','2010-07-31 10:06:01','2011-01-08 19:24:46',NULL,'0.00',1,1,0,0,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(89,100,'SWE3241','E3241.JPG','10.0000','2010-07-31 10:06:33','2010-08-03 06:23:56',NULL,'0.00',1,1,0,0,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(90,98,'SW112012','112012.jpg','18.0000','2010-07-31 10:07:03','2010-08-03 06:24:54',NULL,'0.00',1,1,0,2,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(91,100,'SWEE2766','E2766.JPG','10.0000','2010-07-31 10:08:01','2010-08-03 06:25:32',NULL,'0.00',1,1,0,0,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(92,100,'SWE1183','E1183.JPG','16.0000','2010-07-31 10:08:38','2010-08-03 06:26:10',NULL,'0.00',1,1,0,0,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(93,100,'SW112970','112970.jpg','21.0000','2010-07-31 10:09:14','2010-08-03 06:27:33',NULL,'0.00',1,1,0,0,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(94,100,'SW112218','112218.JPG','19.0000','2010-07-31 10:09:55','2010-08-03 06:28:10',NULL,'0.00',1,1,0,0,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(95,100,'SWE1402','E1402.JPG','21.0000','2010-07-31 10:10:40','2010-08-03 06:28:44',NULL,'0.00',1,1,0,0,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(96,100,'SWE1115','E1115.JPG','12.0000','2010-07-31 10:11:17','2010-08-03 06:30:25',NULL,'0.00',1,1,0,0,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(97,100,'SWE3416','E3416.JPG','30.0000','2010-07-31 10:11:57','2010-08-03 06:31:09',NULL,'0.00',1,1,0,0,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(98,100,'SWE3758','E3758.JPG','16.0000','2010-07-31 10:12:43','2010-08-03 06:31:46',NULL,'0.00',1,1,0,0,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(99,98,'SWP693','P693.JPG','13.0000','2010-07-31 10:19:25','2010-08-08 05:00:04',NULL,'0.00',1,1,0,2,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(100,99,'SW311305','311305.JPG','12.0000','2010-07-31 10:20:02','2010-08-08 05:00:39',NULL,'0.00',1,1,0,1,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(101,99,'SW310673','310673.JPG','15.0000','2010-07-31 10:20:55','2010-08-08 05:01:18',NULL,'0.00',1,1,0,1,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(102,100,'SW310190','310190.JPG','14.0000','2010-07-31 10:24:16','2010-08-08 05:02:09',NULL,'0.00',1,1,0,0,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(103,100,'SW310160','310160.JPG','24.0000','2010-07-31 10:25:06','2010-08-08 05:02:39',NULL,'0.00',1,1,0,0,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(104,100,'SW311580','311580.JPG','6.0000','2010-07-31 10:26:04','2010-08-08 05:03:12',NULL,'0.00',1,1,0,0,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(105,100,'SW210162','210162.JPG','16.0000','2010-07-31 10:27:07','2010-08-08 05:16:29',NULL,'0.00',1,1,0,0,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(106,100,'SW211923','211923.JPG','28.0000','2010-07-31 10:27:46','2010-08-08 05:17:04',NULL,'0.00',1,1,0,0,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(107,100,'SW211886','211886.JPG','29.0000','2010-07-31 10:28:43','2010-08-08 05:17:42',NULL,'0.00',1,1,0,0,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(108,100,'SW210667','210667.JPG','23.0000','2010-07-31 10:29:19','2010-08-08 05:18:12',NULL,'0.00',1,1,0,0,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(109,100,'SW210352','210352.JPG','17.0000','2010-07-31 10:29:55','2010-08-08 05:18:50',NULL,'0.00',1,1,0,0,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(110,100,'SW113066','113066.JPG','39.0000','2010-07-31 10:33:06','2010-08-03 06:32:41',NULL,'0.00',1,1,0,0,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(111,100,'SW112907','112907.jpg','18.0000','2010-07-31 10:33:43','2010-08-03 04:13:00',NULL,'0.00',1,1,0,0,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(112,98,'SW113298','113298.JPG','41.0000','2010-07-31 10:35:36','2010-08-03 06:33:44',NULL,'0.00',1,1,0,2,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(113,100,'SW112874','112874.jpg','36.0000','2010-07-31 10:36:15','2010-08-03 06:34:57',NULL,'0.00',1,1,0,0,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(114,100,'SW112918','112918.jpg','24.0000','2010-07-31 10:36:52','2010-08-03 06:36:22',NULL,'0.00',1,1,0,0,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(115,100,'SWE4373','E4373.JPG','51.0000','2010-07-31 10:37:37','2010-08-03 06:37:18',NULL,'0.00',1,1,0,0,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(116,100,'SWE4416','E4416.JPG','38.0000','2010-07-31 10:39:20','2010-08-03 06:38:35',NULL,'0.00',1,1,0,0,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(117,100,'SW113261','113261.JPG','39.0000','2010-07-31 10:40:06','2010-08-03 06:39:20',NULL,'0.00',1,1,0,0,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(118,100,'SW312325','312325.jpg','32.0000','2010-07-31 10:52:07','2010-08-08 05:03:45',NULL,'0.00',1,1,0,0,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(119,100,'SWP1852','P1852.jpg','32.0000','2010-07-31 10:52:46','2010-08-08 05:04:33',NULL,'0.00',1,1,0,0,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(120,100,'SWP1669','P1669.JPG','63.0000','2010-07-31 10:53:30','2010-08-08 05:05:36',NULL,'0.00',1,1,0,0,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(121,100,'SW312573','312573.JPG','19.0000','2010-07-31 10:54:03','2010-08-08 05:06:12',NULL,'0.00',1,1,0,0,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(122,100,'SW312580','312580.JPG','24.0000','2010-07-31 10:54:37','2010-08-08 05:06:53',NULL,'0.00',1,1,0,0,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(123,100,'SW312577','312577.jpg','26.0000','2010-07-31 10:55:30','2010-08-08 05:07:25',NULL,'0.00',1,1,0,0,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(124,100,'SW312396','312396.jpg','58.0000','2010-07-31 10:56:14','2010-08-08 05:07:55',NULL,'0.00',1,1,0,0,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(125,100,'SW312404','312404.jpg','76.0000','2010-07-31 10:57:09','2010-08-08 05:08:30',NULL,'0.00',1,1,0,0,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(126,98,'SWR1930','R1930.jpg','32.0000','2010-07-31 10:58:12','2010-08-11 01:23:44',NULL,'0.00',1,1,0,2,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(127,100,'SWR1972','R1972.JPG','20.0000','2010-07-31 10:58:56','2010-08-08 05:19:47',NULL,'0.00',1,1,0,0,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(128,100,'SW212744','212744.jpg','24.0000','2010-07-31 11:02:20','2010-08-08 05:20:37',NULL,'0.00',1,1,0,0,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(129,99,'SW113272','113272.JPG','17.0000','2010-07-31 11:05:59','2010-08-03 06:40:04',NULL,'0.00',1,1,0,1,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(130,100,'SW113031','113031.jpg','23.0000','2010-07-31 11:07:30','2010-08-03 05:52:55',NULL,'0.00',1,1,0,1,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(131,100,'SW112880','112880.jpg','21.0000','2010-07-31 11:09:05','2010-08-03 06:40:53',NULL,'0.00',1,1,0,1,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(132,100,'SW113197','113197.JPG','29.0000','2010-07-31 11:13:35','2010-08-03 05:56:25',NULL,'0.00',1,1,0,1,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(133,100,'SW113067','113067.JPG','11.0000','2010-07-31 11:15:55','2010-08-03 06:42:30',NULL,'0.00',1,1,0,0,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(134,100,'SW112993','112993.JPG','21.0000','2010-07-31 11:17:07','2010-08-03 06:02:31',NULL,'0.00',1,1,0,0,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(135,100,'SW112964','112964.jpg','34.0000','2010-07-31 11:17:57','2010-08-03 06:43:21',NULL,'0.00',1,0,0,0,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(136,100,'SW113157','113157.JPG','22.0000','2010-07-31 11:19:09','2010-08-03 06:44:05',NULL,'0.00',1,1,0,0,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(137,100,'SW113001','113001.JPG','17.0000','2010-07-31 11:19:58','2010-08-03 06:44:48',NULL,'0.00',1,1,0,0,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(138,100,'SW112988','112988.JPG','30.0000','2010-07-31 11:20:42','2010-08-03 06:48:42',NULL,'0.00',1,1,0,0,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(139,100,'SW312543','312543.JPG','22.0000','2010-07-31 11:23:06','2010-08-08 05:09:08',NULL,'0.00',1,1,0,0,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(140,100,'SW312568','312568.jpg','32.0000','2010-07-31 11:23:54','2010-08-08 05:09:39',NULL,'0.00',1,1,0,0,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(141,100,'SWP1823','P1823.jpg','24.0000','2010-07-31 11:24:47','2010-08-08 05:10:16',NULL,'0.00',1,1,0,0,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(142,100,'SW212726','212726.jpg','37.0000','2010-07-31 11:25:45','2010-08-08 05:21:04',NULL,'0.00',1,1,0,0,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(143,100,'SWE4481','E4481.jpg','20.0000','2010-07-31 11:34:27','2010-08-03 06:49:27',NULL,'0.00',1,1,0,0,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(144,100,'SWE993','E993.JPG','18.0000','2010-07-31 11:35:50','2010-08-03 06:50:23',NULL,'0.00',1,1,0,0,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(145,100,'SWP818','P818.JPG','24.0000','2010-07-31 11:37:06','2010-08-08 05:10:49',NULL,'0.00',1,1,0,0,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(146,100,'SWR2118','R2118.jpg','24.0000','2010-07-31 11:38:36','2010-08-08 05:21:42',NULL,'0.00',1,1,0,0,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(147,100,'SW210735','210735.JPG','45.0000','2010-07-31 11:39:23','2011-01-08 19:27:06',NULL,'0.00',1,1,0,0,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(148,100,'SWR1360','R1360.JPG','29.0000','2010-07-31 11:40:37','2010-08-08 05:22:42',NULL,'0.00',1,1,0,0,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(149,100,'SW113312','113312.JPG','29.0000','2010-07-31 11:42:16','2010-08-03 06:51:46',NULL,'0.00',1,1,0,0,0,0,'','','','','113312-a.JPG',NULL,NULL,NULL,NULL),(150,100,'SW113003','113003.JPG','27.0000','2010-07-31 11:45:29','2010-08-03 06:52:50',NULL,'0.00',1,1,0,0,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(151,100,'SW113007','113007.jpg','33.0000','2010-07-31 11:46:30','2010-08-03 06:53:28',NULL,'0.00',1,1,0,0,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(152,100,'SW113262','113262.JPG','42.0000','2010-07-31 11:47:29','2010-08-03 06:54:07',NULL,'0.00',1,1,0,0,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(153,100,'SW113227','113227.JPG','29.0000','2010-07-31 11:48:20','2010-08-03 06:54:51',NULL,'0.00',1,1,0,0,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(154,100,'SW113185','113185.JPG','23.0000','2010-07-31 11:49:13','2010-08-03 06:55:24',NULL,'0.00',1,1,0,0,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(155,100,'SW113270','113270.JPG','28.0000','2010-07-31 11:50:15','2010-08-03 06:55:56',NULL,'0.00',1,1,0,0,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(156,100,'SW113229','113229.JPG','30.0000','2010-07-31 11:51:08','2010-08-03 06:56:34',NULL,'0.00',1,1,0,0,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(157,100,'SW113310','113310.JPG','69.0000','2010-07-31 11:51:59','2010-08-03 06:57:06',NULL,'0.00',1,1,0,0,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(158,100,'SW113230','113230.JPG','30.0000','2010-07-31 11:52:52','2010-08-03 06:57:55',NULL,'0.00',1,1,0,0,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(159,100,'SW112421','112421.jpg','19.0000','2010-07-31 11:53:41','2010-08-03 04:08:06',NULL,'0.00',1,0,0,0,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(160,100,'SW113275','113275.JPG','37.0000','2010-07-31 11:54:32','2010-08-03 06:58:40',NULL,'0.00',1,1,0,0,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(161,100,'SW113053','113053.jpg','27.0000','2010-07-31 11:55:19','2010-08-03 06:35:38',NULL,'0.00',1,1,0,0,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(162,100,'SW312575','312575.JPG','25.0000','2010-07-31 11:56:27','2010-08-08 05:11:16',NULL,'0.00',1,1,0,0,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(163,100,'SW312483','312483.JPG','26.0000','2010-07-31 11:57:20','2010-08-08 05:11:43',NULL,'0.00',1,1,0,0,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(164,100,'SW312578','312578.JPG','29.0000','2010-07-31 11:58:13','2010-08-08 05:12:13',NULL,'0.00',1,1,0,0,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(165,100,'SW312405','312405.jpg','40.0000','2010-07-31 11:59:12','2010-08-08 05:12:44',NULL,'0.00',1,1,0,0,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(166,100,'SW312516','312516.JPG','49.0000','2010-07-31 12:00:10','2010-08-08 05:13:29',NULL,'0.00',1,1,0,0,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(167,100,'SW312490','312490.JPG','56.0000','2010-07-31 12:00:55','2010-08-08 05:14:02',NULL,'0.00',1,1,0,0,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(168,100,'SW312525','312525.JPG','33.0000','2010-07-31 12:01:45','2010-08-08 05:14:40',NULL,'0.00',1,1,0,0,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(169,100,'SW212741','212741.jpg','32.0000','2010-07-31 12:03:09','2010-08-08 05:23:10',NULL,'0.00',1,1,0,0,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(170,100,'SW212537','212537.JPG','41.0000','2010-07-31 12:04:04','2010-08-08 05:23:40',NULL,'0.00',1,1,0,0,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(171,100,'SW212504','212504.JPG','29.0000','2010-07-31 12:04:50','2011-01-08 19:31:13',NULL,'0.00',1,1,0,0,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(172,100,'SW212768','212768.jpg','30.0000','2010-07-31 12:05:34','2010-08-08 05:24:36',NULL,'0.00',1,1,0,0,0,0,'','','','',NULL,NULL,NULL,NULL,NULL),(173,100,'SW210048','210048.JPG','39.0000','2010-07-31 12:06:25','2010-08-08 05:25:08',NULL,'0.00',1,1,0,0,0,0,'','','','',NULL,NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_attributes`
--

DROP TABLE IF EXISTS `products_attributes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `products_attributes` (
  `products_attributes_id` int(11) NOT NULL AUTO_INCREMENT,
  `products_id` int(11) NOT NULL,
  `options_id` int(11) NOT NULL,
  `options_values_id` int(11) NOT NULL,
  `options_values_price` decimal(15,4) NOT NULL,
  `price_prefix` char(1) NOT NULL,
  `attributes_hide_from_groups` varchar(255) NOT NULL DEFAULT '@',
  PRIMARY KEY (`products_attributes_id`),
  KEY `idx_products_attributes_products_id` (`products_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_attributes`
--

LOCK TABLES `products_attributes` WRITE;
/*!40000 ALTER TABLE `products_attributes` DISABLE KEYS */;
/*!40000 ALTER TABLE `products_attributes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_attributes_download`
--

DROP TABLE IF EXISTS `products_attributes_download`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `products_attributes_download` (
  `products_attributes_id` int(11) NOT NULL,
  `products_attributes_filename` varchar(255) NOT NULL DEFAULT '',
  `products_attributes_maxdays` int(2) DEFAULT '0',
  `products_attributes_maxcount` int(2) DEFAULT '0',
  PRIMARY KEY (`products_attributes_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_attributes_download`
--

LOCK TABLES `products_attributes_download` WRITE;
/*!40000 ALTER TABLE `products_attributes_download` DISABLE KEYS */;
INSERT INTO `products_attributes_download` VALUES (26,'unreal.zip',7,3);
/*!40000 ALTER TABLE `products_attributes_download` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_attributes_groups`
--

DROP TABLE IF EXISTS `products_attributes_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `products_attributes_groups` (
  `products_attributes_id` int(11) NOT NULL DEFAULT '0',
  `customers_group_id` smallint(5) NOT NULL DEFAULT '0',
  `options_values_price` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `price_prefix` char(1) NOT NULL DEFAULT '',
  `products_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`customers_group_id`,`products_attributes_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_attributes_groups`
--

LOCK TABLES `products_attributes_groups` WRITE;
/*!40000 ALTER TABLE `products_attributes_groups` DISABLE KEYS */;
/*!40000 ALTER TABLE `products_attributes_groups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_description`
--

DROP TABLE IF EXISTS `products_description`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `products_description` (
  `products_id` int(11) NOT NULL AUTO_INCREMENT,
  `language_id` int(11) NOT NULL DEFAULT '1',
  `products_name` varchar(64) NOT NULL DEFAULT '',
  `products_description` text,
  `products_url` varchar(255) DEFAULT NULL,
  `products_viewed` int(5) DEFAULT '0',
  `products_head_title_tag` varchar(80) DEFAULT NULL,
  `products_head_desc_tag` longtext,
  `products_head_keywords_tag` longtext,
  PRIMARY KEY (`products_id`,`language_id`),
  KEY `products_name` (`products_name`)
) ENGINE=InnoDB AUTO_INCREMENT=174 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_description`
--

LOCK TABLES `products_description` WRITE;
/*!40000 ALTER TABLE `products_description` DISABLE KEYS */;
INSERT INTO `products_description` VALUES (63,1,'Filigri pendant','Plain round pendant with filigri style pattern. Part of the Cascade of Arcs family.','',34,'Filigri pendant','Filigri pendant','Filigri pendant'),(63,2,'Filigri pendant','Plain round pendant with filigri style pattern. Part of the Cascade of Arcs family.','',0,NULL,NULL,NULL),(63,3,'Filigri pendant','Plain round pendant with filigri style pattern. Part of the Cascade of Arcs family.','',0,NULL,NULL,NULL),(63,4,'Filigri pendant','Plain round pendant with filigri style pattern. Part of the Cascade of Arcs family.','',0,NULL,NULL,NULL),(64,1,'Garnet Oval Pendant','A handcrafted filigri oval pendant with facetted garnet','',20,'Garnet Oval','Garnet Oval','Garnet Oval facetted pendant'),(64,2,'Garnet Oval Pendant','A handcrafted filigri oval pendant with facetted garnet','',0,NULL,NULL,NULL),(64,3,'Garnet Oval Pendant','A handcrafted filigri oval pendant with facetted garnet','',0,NULL,NULL,NULL),(64,4,'Garnet Oval Pendant','A handcrafted filigri oval pendant with facetted garnet','',0,NULL,NULL,NULL),(65,1,'Garnet Earring','Beautiful filigree styled earring studded with garnet from cascade of arcs collection.','',29,'Garnet Earring','Garnet Earring','Garnet Earring'),(65,2,'Garnet Earring','Beautiful filigree styled earring studded with garnet from cascade of arcs collection.','',0,NULL,NULL,NULL),(65,3,'Garnet Earring','Beautiful filigree styled earring studded with garnet from cascade of arcs collection.','',0,NULL,NULL,NULL),(65,4,'Garnet Earring','Beautiful filigree styled earring studded with garnet from cascade of arcs collection.','',0,NULL,NULL,NULL),(66,1,'Plain Filigree Pendant','','',36,'Plain Filigree Pendant','Plain Filigree Pendant','Plain Filigree Pendant'),(66,2,'Plain Filigree Pendant','','',0,NULL,NULL,NULL),(66,3,'Plain Filigree Pendant','','',0,NULL,NULL,NULL),(66,4,'Plain Filigree Pendant','','',0,NULL,NULL,NULL),(67,1,'Plain Pendant','','',12,'Plain Pendant','Plain Pendant','Plain Pendant'),(67,2,'Plain Pendant','','',0,NULL,NULL,NULL),(67,3,'Plain Pendant','','',0,NULL,NULL,NULL),(67,4,'Plain Pendant','','',0,NULL,NULL,NULL),(68,1,'Plain Pendant','','',14,'Plain Pendant','Plain Pendant','Plain Pendant'),(68,2,'Plain Pendant','','',0,NULL,NULL,NULL),(68,3,'Plain Pendant','','',0,NULL,NULL,NULL),(68,4,'Plain Pendant','','',0,NULL,NULL,NULL),(69,1,'Amethyst Facetted Pendant','','',107,'Amethyst Facetted Pendant','Amethyst Facetted Pendant','Amethyst Facetted Pendant'),(69,2,'Amethyst Facetted Pendant','','',0,NULL,NULL,NULL),(69,3,'Amethyst Facetted Pendant','','',0,NULL,NULL,NULL),(69,4,'Amethyst Facetted Pendant','','',0,NULL,NULL,NULL),(70,1,'Plain Pendant','','',14,'Plain Pendant','Plain Pendant','Plain Pendant'),(70,2,'Plain Pendant','','',0,NULL,NULL,NULL),(70,3,'Plain Pendant','','',0,NULL,NULL,NULL),(70,4,'Plain Pendant','','',0,NULL,NULL,NULL),(71,1,'Citrine Facetted Pendant','','',25,'Citrine Facetted Pendant','Citrine Facetted Pendant','Citrine Facetted Pendant'),(71,2,'Citrine Facetted Pendant','','',0,NULL,NULL,NULL),(71,3,'Citrine Facetted Pendant','','',0,NULL,NULL,NULL),(71,4,'Citrine Facetted Pendant','','',0,NULL,NULL,NULL),(72,1,'Plain Pendant','','',26,'Plain Pendant','Plain Pendant','Plain Pendant'),(72,2,'Plain Pendant','','',0,NULL,NULL,NULL),(72,3,'Plain Pendant','','',0,NULL,NULL,NULL),(72,4,'Plain Pendant','','',0,NULL,NULL,NULL),(73,1,'Green Onyx Pendant','','',21,'Green Onyx Pendant','Green Onyx Pendant','Green Onyx Pendant'),(73,2,'Green Onyx Pendant','','',0,NULL,NULL,NULL),(73,3,'Green Onyx Pendant','','',0,NULL,NULL,NULL),(73,4,'Green Onyx Pendant','','',0,NULL,NULL,NULL),(74,1,'Blue Topaz Facetted Pendant','','',21,'Blue Topaz Facetted Pendant','Blue Topaz Facetted Pendant','Blue Topaz Facetted Pendant'),(74,2,'Blue Topaz Facetted Pendant','','',0,NULL,NULL,NULL),(74,3,'Blue Topaz Facetted Pendant','','',0,NULL,NULL,NULL),(74,4,'Blue Topaz Facetted Pendant','','',0,NULL,NULL,NULL),(75,1,'Gold Plated Earring','Filigree styled silver earring with 2 micron gold plating. From Cascade of Arcs collection.','',13,'Gold Plated Earring','Gold Plated Earring','Gold Plated Earring'),(75,2,'Gold Plated Earring','Filigree styled silver earring with 2 micron gold plating. From Cascade of Arcs collection.','',0,NULL,NULL,NULL),(75,3,'Gold Plated Earring','Filigree styled silver earring with 2 micron gold plating. From Cascade of Arcs collection.','',0,NULL,NULL,NULL),(75,4,'Gold Plated Earring','Filigree styled silver earring with 2 micron gold plating. From Cascade of Arcs collection.','',0,NULL,NULL,NULL),(76,1,'Plain Earring','Beautifully crafted filigree earring from our cascade of arcs collection.','',15,'Plain Earring','Plain Earring','Plain Earring'),(76,2,'Plain Earring','Beautifully crafted filigree earring from our cascade of arcs collection.','',0,NULL,NULL,NULL),(76,3,'Plain Earring','Beautifully crafted filigree earring from our cascade of arcs collection.','',0,NULL,NULL,NULL),(76,4,'Plain Earring','Beautifully crafted filigree earring from our cascade of arcs collection.','',0,NULL,NULL,NULL),(77,1,'Garnet / Amethyst Earring','A multistone earring combining garnet and amethyst on filifree pattern from the cascade of arcs collection.','',10,'Garnet / Amethyst Earring','Garnet / Amethyst Earring','Garnet / Amethyst Earring'),(77,2,'Garnet / Amethyst Earring','A multistone earring combining garnet and amethyst on filifree pattern from the cascade of arcs collection.','',0,NULL,NULL,NULL),(77,3,'Garnet / Amethyst Earring','A multistone earring combining garnet and amethyst on filifree pattern from the cascade of arcs collection.','',0,NULL,NULL,NULL),(77,4,'Garnet / Amethyst Earring','A multistone earring combining garnet and amethyst on filifree pattern from the cascade of arcs collection.','',0,NULL,NULL,NULL),(78,1,'Amethyst Earring','Filigree pattern with amethyst stone, part of cascade of arcs selection.','',21,'Amethyst Earring','Amethyst Earring','Amethyst Earring'),(78,2,'Amethyst Earring','Filigree pattern with amethyst stone, part of cascade of arcs selection.','',0,NULL,NULL,NULL),(78,3,'Amethyst Earring','Filigree pattern with amethyst stone, part of cascade of arcs selection.','',0,NULL,NULL,NULL),(78,4,'Amethyst Earring','Filigree pattern with amethyst stone, part of cascade of arcs selection.','',0,NULL,NULL,NULL),(79,1,'Plain Earrings','Deftly crafted filigree styled earrings. Part of our cascade of arcs collection.','',7,'Plain Earrings','Plain Earrings','Plain Earrings'),(79,2,'Plain Earrings','Deftly crafted filigree styled earrings. Part of our cascade of arcs collection.','',0,NULL,NULL,NULL),(79,3,'Plain Earrings','Deftly crafted filigree styled earrings. Part of our cascade of arcs collection.','',0,NULL,NULL,NULL),(79,4,'Plain Earrings','Deftly crafted filigree styled earrings. Part of our cascade of arcs collection.','',0,NULL,NULL,NULL),(80,1,'Plain Earring','Elegant filigree earring belonging to our cascade of arcs collection.','',15,'Plain Earring','Plain Earring','Plain Earring'),(80,2,'Plain Earring','Elegant filigree earring belonging to our cascade of arcs collection.','',0,NULL,NULL,NULL),(80,3,'Plain Earring','Elegant filigree earring belonging to our cascade of arcs collection.','',0,NULL,NULL,NULL),(80,4,'Plain Earring','Elegant filigree earring belonging to our cascade of arcs collection.','',0,NULL,NULL,NULL),(81,1,'Plain Earring','Filigri styled earrings from our cascade of arcs collection.','',1,'Plain Earring','Plain Earring','Plain Earring'),(81,2,'Plain Earring','Filigri styled earrings from our cascade of arcs collection.','',0,NULL,NULL,NULL),(81,3,'Plain Earring','Filigri styled earrings from our cascade of arcs collection.','',0,NULL,NULL,NULL),(81,4,'Plain Earring','Filigri styled earrings from our cascade of arcs collection.','',0,NULL,NULL,NULL),(82,1,'Plain Filigree Earrings','Beautiful filigree styled earring from our elegant cascade of arcs selection.','',17,'Plain Filigree Earrings','Plain Filigree Earrings','Plain Filigree Earrings'),(82,2,'Plain Filigree Earrings','Beautiful filigree styled earring from our elegant cascade of arcs selection.','',0,NULL,NULL,NULL),(82,3,'Plain Filigree Earrings','Beautiful filigree styled earring from our elegant cascade of arcs selection.','',0,NULL,NULL,NULL),(82,4,'Plain Filigree Earrings','Beautiful filigree styled earring from our elegant cascade of arcs selection.','',0,NULL,NULL,NULL),(83,1,'Blue Topaz Earring','An elegant filigree styled earring with exquisite Blue Topaz gemstone. From our Cascade of Arcs collection.','',4,'Blue Topaz Earring','Blue Topaz Earring','Blue Topaz Earring'),(83,2,'Blue Topaz Earring','An elegant filigree styled earring with exquisite Blue Topaz gemstone. From our Cascade of Arcs collection.','',0,NULL,NULL,NULL),(83,3,'Blue Topaz Earring','An elegant filigree styled earring with exquisite Blue Topaz gemstone. From our Cascade of Arcs collection.','',0,NULL,NULL,NULL),(83,4,'Blue Topaz Earring','An elegant filigree styled earring with exquisite Blue Topaz gemstone. From our Cascade of Arcs collection.','',0,NULL,NULL,NULL),(84,1,'Garnet with Bronze Ring','','',30,'Garnet with Bronze Ring','Garnet with Bronze Ring','Garnet with Bronze Ring'),(84,2,'Garnet with Bronze Ring','','',0,NULL,NULL,NULL),(84,3,'Garnet with Bronze Ring','','',0,NULL,NULL,NULL),(84,4,'Garnet with Bronze Ring','','',0,NULL,NULL,NULL),(85,1,'Lemon Topaz Earring','An exquisite Lemon Topaz earring from our Blush collection.','',18,'Lemon Topaz Earring','Lemon Topaz Earring','Lemon Topaz Earring'),(85,2,'Lemon Topaz Earring','An exquisite Lemon Topaz earring from our Blush collection.','',0,NULL,NULL,NULL),(85,3,'Lemon Topaz Earring','An exquisite Lemon Topaz earring from our Blush collection.','',0,NULL,NULL,NULL),(85,4,'Lemon Topaz Earring','An exquisite Lemon Topaz earring from our Blush collection.','',0,NULL,NULL,NULL),(86,1,'Ruby Earring','This beautiful earring with Ruby gemstone comes from our Blush collection.','',14,'Ruby Earring','Ruby Earring','Ruby Earring'),(86,2,'Ruby Earring','This beautiful earring with Ruby gemstone comes from our Blush collection.','',0,NULL,NULL,NULL),(86,3,'Ruby Earring','This beautiful earring with Ruby gemstone comes from our Blush collection.','',0,NULL,NULL,NULL),(86,4,'Ruby Earring','This beautiful earring with Ruby gemstone comes from our Blush collection.','',0,NULL,NULL,NULL),(87,1,'Smoky Quartz Earring','This beautiful earring, mounted with smoky quartz, represents our blush range.','',7,'Smoky Quartz Earring','Smoky Quartz Earring','Smoky Quartz Earring'),(87,2,'Smoky Quartz Earring','This beautiful earring, mounted with smoky quartz, represents our blush range.','',0,NULL,NULL,NULL),(87,3,'Smoky Quartz Earring','This beautiful earring, mounted with smoky quartz, represents our blush range.','',0,NULL,NULL,NULL),(87,4,'Smoky Quartz Earring','This beautiful earring, mounted with smoky quartz, represents our blush range.','',0,NULL,NULL,NULL),(88,1,'Black Onyx Earring','Elegant Black Onyx earring from our blush collection.','',19,'Black Onyx Earring','Black Onyx Earring','Black Onyx Earring'),(88,2,'Black Onyx Earring','Elegant Black Onyx earring from our blush collection.','',0,NULL,NULL,NULL),(88,3,'Black Onyx Earring','Elegant Black Onyx earring from our blush collection.','',0,NULL,NULL,NULL),(88,4,'Black Onyx Earring','Elegant Black Onyx earring from our blush collection.','',0,NULL,NULL,NULL),(89,1,'Rainbow moonstone earring','','',8,'Rainbow moonstone earring','Rainbow moonstone earring','Rainbow moonstone earring'),(89,2,'Rainbow moonstone earring','','',0,NULL,NULL,NULL),(89,3,'Rainbow moonstone earring','','',0,NULL,NULL,NULL),(89,4,'Rainbow moonstone earring','','',0,NULL,NULL,NULL),(90,1,'Green Onyx Earring','','',7,'Green Onyx Earring','Green Onyx Earring','Green Onyx Earring'),(90,2,'Green Onyx Earring','','',0,NULL,NULL,NULL),(90,3,'Green Onyx Earring','','',0,NULL,NULL,NULL),(90,4,'Green Onyx Earring','','',0,NULL,NULL,NULL),(91,1,'Peridot Earring','','',16,'Peridot Earring','Peridot Earring','Peridot Earring'),(91,2,'Peridot Earring','','',0,NULL,NULL,NULL),(91,3,'Peridot Earring','','',0,NULL,NULL,NULL),(91,4,'Peridot Earring','','',0,NULL,NULL,NULL),(92,1,'Amethyst Cabochon Earring','','',25,'Amethyst Cabochon Earring','Amethyst Cabochon Earring','Amethyst Cabochon Earring'),(92,2,'Amethyst Cabochon Earring','','',0,NULL,NULL,NULL),(92,3,'Amethyst Cabochon Earring','','',0,NULL,NULL,NULL),(92,4,'Amethyst Cabochon Earring','','',0,NULL,NULL,NULL),(93,1,'Green Aventurine Earring','','',12,'Green Aventurine Earring','Green Aventurine Earring','Green Aventurine Earring'),(93,2,'Green Aventurine Earring','','',0,NULL,NULL,NULL),(93,3,'Green Aventurine Earring','','',0,NULL,NULL,NULL),(93,4,'Green Aventurine Earring','','',0,NULL,NULL,NULL),(94,1,'Peridot Earring','','',16,'Peridot Earring','Peridot Earring','Peridot Earring'),(94,2,'Peridot Earring','','',0,NULL,NULL,NULL),(94,3,'Peridot Earring','','',0,NULL,NULL,NULL),(94,4,'Peridot Earring','','',0,NULL,NULL,NULL),(95,1,'Garnet Earring','','',15,'Garnet Earring','Garnet Earring','Garnet Earring'),(95,2,'Garnet Earring','','',0,NULL,NULL,NULL),(95,3,'Garnet Earring','','',0,NULL,NULL,NULL),(95,4,'Garnet Earring','','',0,NULL,NULL,NULL),(96,1,'Garnet Earring','','',4,'Garnet Earring','Garnet Earring','Garnet Earring'),(96,2,'Garnet Earring','','',0,NULL,NULL,NULL),(96,3,'Garnet Earring','','',0,NULL,NULL,NULL),(96,4,'Garnet Earring','','',0,NULL,NULL,NULL),(97,1,'Garnet Earring','','',12,'Garnet Earring','Garnet Earring','Garnet Earring'),(97,2,'Garnet Earring','','',0,NULL,NULL,NULL),(97,3,'Garnet Earring','','',0,NULL,NULL,NULL),(97,4,'Garnet Earring','','',0,NULL,NULL,NULL),(98,1,'Garnet Earring','','',10,'Garnet Earring','Garnet Earring','Garnet Earring'),(98,2,'Garnet Earring','','',0,NULL,NULL,NULL),(98,3,'Garnet Earring','','',0,NULL,NULL,NULL),(98,4,'Garnet Earring','','',0,NULL,NULL,NULL),(99,1,'Amethyst Facetted Pendant','','',18,'Amethyst Facetted Pendant','Amethyst Facetted Pendant','Amethyst Facetted Pendant'),(99,2,'Amethyst Facetted Pendant','','',0,NULL,NULL,NULL),(99,3,'Amethyst Facetted Pendant','','',0,NULL,NULL,NULL),(99,4,'Amethyst Facetted Pendant','','',0,NULL,NULL,NULL),(100,1,'Amethyst Facetted Pendant','','',19,'Amethyst Facetted Pendant','Amethyst Facetted Pendant','Amethyst Facetted Pendant'),(100,2,'Amethyst Facetted Pendant','','',0,NULL,NULL,NULL),(100,3,'Amethyst Facetted Pendant','','',0,NULL,NULL,NULL),(100,4,'Amethyst Facetted Pendant','','',0,NULL,NULL,NULL),(101,1,'Amethyst/Peridot Facetted Pendant','','',10,'Amethyst/Peridot Facetted Pendant','Amethyst/Peridot Facetted Pendant','Amethyst/Peridot Facetted Pendant'),(101,2,'Amethyst/Peridot Facetted Pendant','','',0,NULL,NULL,NULL),(101,3,'Amethyst/Peridot Facetted Pendant','','',0,NULL,NULL,NULL),(101,4,'Amethyst/Peridot Facetted Pendant','','',0,NULL,NULL,NULL),(102,1,'Garnet Facetted Pendant','','',16,'Garnet Facetted Pendant','Garnet Facetted Pendant','Garnet Facetted Pendant'),(102,2,'Garnet Facetted Pendant','','',0,NULL,NULL,NULL),(102,3,'Garnet Facetted Pendant','','',0,NULL,NULL,NULL),(102,4,'Garnet Facetted Pendant','','',0,NULL,NULL,NULL),(103,1,'Amethyst Facetted Pendant','','',15,'Amethyst Facetted Pendant','Amethyst Facetted Pendant','Amethyst Facetted Pendant'),(103,2,'Amethyst Facetted Pendant','','',0,NULL,NULL,NULL),(103,3,'Amethyst Facetted Pendant','','',0,NULL,NULL,NULL),(103,4,'Amethyst Facetted Pendant','','',0,NULL,NULL,NULL),(104,1,'Garnet Facetted Pendant','','',13,'Garnet Facetted Pendant','Garnet Facetted Pendant','Garnet Facetted Pendant'),(104,2,'Garnet Facetted Pendant','','',0,NULL,NULL,NULL),(104,3,'Garnet Facetted Pendant','','',0,NULL,NULL,NULL),(104,4,'Garnet Facetted Pendant','','',0,NULL,NULL,NULL),(105,1,'Citrine Facetted Ring','','',16,'Citrine Facetted Ring','Citrine Facetted Ring','Citrine Facetted Ring'),(105,2,'Citrine Facetted Ring','','',0,NULL,NULL,NULL),(105,3,'Citrine Facetted Ring','','',0,NULL,NULL,NULL),(105,4,'Citrine Facetted Ring','','',0,NULL,NULL,NULL),(106,1,'Citrine Facetted Ring','','',10,'Citrine Facetted Ring','Citrine Facetted Ring','Citrine Facetted Ring'),(106,2,'Citrine Facetted Ring','','',0,NULL,NULL,NULL),(106,3,'Citrine Facetted Ring','','',0,NULL,NULL,NULL),(106,4,'Citrine Facetted Ring','','',0,NULL,NULL,NULL),(107,1,'Blue Topaz Facetted Ring','','',10,'Blue Topaz Facetted Ring','Blue Topaz Facetted Ring','Blue Topaz Facetted Ring'),(107,2,'Blue Topaz Facetted Ring','','',0,NULL,NULL,NULL),(107,3,'Blue Topaz Facetted Ring','','',0,NULL,NULL,NULL),(107,4,'Blue Topaz Facetted Ring','','',0,NULL,NULL,NULL),(108,1,'Garnet Facetted Ring','','',15,'Garnet Facetted Ring','Garnet Facetted Ring','Garnet Facetted Ring'),(108,2,'Garnet Facetted Ring','','',0,NULL,NULL,NULL),(108,3,'Garnet Facetted Ring','','',0,NULL,NULL,NULL),(108,4,'Garnet Facetted Ring','','',0,NULL,NULL,NULL),(109,1,'Peridot Facetted Ring','','',19,'Peridot Facetted Ring','Peridot Facetted Ring','Peridot Facetted Ring'),(109,2,'Peridot Facetted Ring','','',0,NULL,NULL,NULL),(109,3,'Peridot Facetted Ring','','',0,NULL,NULL,NULL),(109,4,'Peridot Facetted Ring','','',0,NULL,NULL,NULL),(110,1,'Citrine / Garnet Earring','','',14,'Citrine / Garnet Earring','Citrine / Garnet Earring','Citrine / Garnet Earring'),(110,2,'Citrine / Garnet Earring','','',0,NULL,NULL,NULL),(110,3,'Citrine / Garnet Earring','','',0,NULL,NULL,NULL),(110,4,'Citrine / Garnet Earring','','',0,NULL,NULL,NULL),(111,1,'Turquoise Earring','An elegant turquoise earring, part of Melange collection.','',5,'Turquoise Earring','Turquoise Earring','Turquoise Earring'),(111,2,'Turquoise Earring','An elegant turquoise earring, part of Melange collection.','',0,NULL,NULL,NULL),(111,3,'Turquoise Earring','An elegant turquoise earring, part of Melange collection.','',0,NULL,NULL,NULL),(111,4,'Turquoise Earring','An elegant turquoise earring, part of Melange collection.','',0,NULL,NULL,NULL),(112,1,'Amber / Cz Earring','','',109,'Amber / Cz Earring','Amber / Cz Earring','Amber / Cz Earring'),(112,2,'Amber / Cz Earring','','',0,NULL,NULL,NULL),(112,3,'Amber / Cz Earring','','',0,NULL,NULL,NULL),(112,4,'Amber / Cz Earring','','',0,NULL,NULL,NULL),(113,1,'Plain Earring','','',17,'Plain Earring','Plain Earring','Plain Earring'),(113,2,'Plain Earring','','',0,NULL,NULL,NULL),(113,3,'Plain Earring','','',0,NULL,NULL,NULL),(113,4,'Plain Earring','','',0,NULL,NULL,NULL),(114,1,'Plain Earring','','',14,'Plain Earring','Plain Earring','Plain Earring'),(114,2,'Plain Earring','','',0,NULL,NULL,NULL),(114,3,'Plain Earring','','',0,NULL,NULL,NULL),(114,4,'Plain Earring','','',0,NULL,NULL,NULL),(115,1,'Garnet Earring','','',5,'Garnet Earring','Garnet Earring','Garnet Earring'),(115,2,'Garnet Earring','','',0,NULL,NULL,NULL),(115,3,'Garnet Earring','','',0,NULL,NULL,NULL),(115,4,'Garnet Earring','','',0,NULL,NULL,NULL),(116,1,'Pearl / Black Onyx / Garnet Earring','','',11,'Pearl / Black Onyx / Garnet Earring','Pearl / Black Onyx / Garnet Earring','Pearl / Black Onyx / Garnet Earring'),(116,2,'Pearl / Black Onyx / Garnet Earring','','',0,NULL,NULL,NULL),(116,3,'Pearl / Black Onyx / Garnet Earring','','',0,NULL,NULL,NULL),(116,4,'Pearl / Black Onyx / Garnet Earring','','',0,NULL,NULL,NULL),(117,1,'Pearl / Turquoise Earring','','',13,'Pearl / Turquoise Earring','Pearl / Turquoise Earring','Pearl / Turquoise Earring'),(117,2,'Pearl / Turquoise Earring','','',0,NULL,NULL,NULL),(117,3,'Pearl / Turquoise Earring','','',0,NULL,NULL,NULL),(117,4,'Pearl / Turquoise Earring','','',0,NULL,NULL,NULL),(118,1,'Plain Pendant','','',6,'Plain Pendant','Plain Pendant','Plain Pendant'),(118,2,'Plain Pendant','','',0,NULL,NULL,NULL),(118,3,'Plain Pendant','','',0,NULL,NULL,NULL),(118,4,'Plain Pendant','','',0,NULL,NULL,NULL),(119,1,'Green Amethyst Pendant','','',23,'Green Amethyst Pendant','Green Amethyst Pendant','Green Amethyst Pendant'),(119,2,'Green Amethyst Pendant','','',0,NULL,NULL,NULL),(119,3,'Green Amethyst Pendant','','',0,NULL,NULL,NULL),(119,4,'Green Amethyst Pendant','','',0,NULL,NULL,NULL),(120,1,'Plain Pendant','','',22,'Plain Pendant','Plain Pendant','Plain Pendant'),(120,2,'Plain Pendant','','',0,NULL,NULL,NULL),(120,3,'Plain Pendant','','',0,NULL,NULL,NULL),(120,4,'Plain Pendant','','',0,NULL,NULL,NULL),(121,1,'Plain Pendant','','',19,'Plain Pendant','Plain Pendant','Plain Pendant'),(121,2,'Plain Pendant','','',0,NULL,NULL,NULL),(121,3,'Plain Pendant','','',0,NULL,NULL,NULL),(121,4,'Plain Pendant','','',0,NULL,NULL,NULL),(122,1,'Plain Pendant','','',9,'Plain Pendant','Plain Pendant','Plain Pendant'),(122,2,'Plain Pendant','','',0,NULL,NULL,NULL),(122,3,'Plain Pendant','','',0,NULL,NULL,NULL),(122,4,'Plain Pendant','','',0,NULL,NULL,NULL),(123,1,'Plain Pendant','','',18,'Plain Pendant','Plain Pendant','Plain Pendant'),(123,2,'Plain Pendant','','',0,NULL,NULL,NULL),(123,3,'Plain Pendant','','',0,NULL,NULL,NULL),(123,4,'Plain Pendant','','',0,NULL,NULL,NULL),(124,1,'Plain Pendant','','',28,'Plain Pendant','Plain Pendant','Plain Pendant'),(124,2,'Plain Pendant','','',0,NULL,NULL,NULL),(124,3,'Plain Pendant','','',0,NULL,NULL,NULL),(124,4,'Plain Pendant','','',0,NULL,NULL,NULL),(125,1,'Black Onyx Cabochon Pendant','','',23,'Black Onyx Cabochon Pendant','Black Onyx Cabochon Pendant','Black Onyx Cabochon Pendant'),(125,2,'Black Onyx Cabochon Pendant','','',0,NULL,NULL,NULL),(125,3,'Black Onyx Cabochon Pendant','','',0,NULL,NULL,NULL),(125,4,'Black Onyx Cabochon Pendant','','',0,NULL,NULL,NULL),(126,1,'Black Onyx Ring','','',119,'Black Onyx Ring','Black Onyx Ring','Black Onyx Ring'),(126,2,'Black Onyx Ring','','',0,NULL,NULL,NULL),(126,3,'Black Onyx Ring','','',0,NULL,NULL,NULL),(126,4,'Black Onyx Ring','','',0,NULL,NULL,NULL),(127,1,'Plain Ring','','',19,'Plain Ring','Plain Ring','Plain Ring'),(127,2,'Plain Ring','','',0,NULL,NULL,NULL),(127,3,'Plain Ring','','',0,NULL,NULL,NULL),(127,4,'Plain Ring','','',0,NULL,NULL,NULL),(128,1,'Plain Ring','','',23,'Plain Ring','Plain Ring','Plain Ring'),(128,2,'Plain Ring','','',0,NULL,NULL,NULL),(128,3,'Plain Ring','','',0,NULL,NULL,NULL),(128,4,'Plain Ring','','',0,NULL,NULL,NULL),(129,1,'Plain with Bronze Earring','','',2,'Plain with Bronze Earring','Plain with Bronze Earring','Plain with Bronze Earring'),(129,2,'Plain with Bronze Earring','','',0,NULL,NULL,NULL),(129,3,'Plain with Bronze Earring','','',0,NULL,NULL,NULL),(129,4,'Plain with Bronze Earring','','',0,NULL,NULL,NULL),(130,1,'Silver & Bronze Earring','Silver tastefully combined with bronze from our Mixed Metals range.','',11,'Silver & Bronze Earring','Silver & Bronze Earring','Silver & Bronze Earring'),(130,2,'Silver & Bronze Earring','Silver tastefully combined with bronze from our Mixed Metals range.','',0,NULL,NULL,NULL),(130,3,'Silver & Bronze Earring','Silver tastefully combined with bronze from our Mixed Metals range.','',0,NULL,NULL,NULL),(130,4,'Silver & Bronze Earring','Silver tastefully combined with bronze from our Mixed Metals range.','',0,NULL,NULL,NULL),(131,1,'Silver + Bronze Earring','','',6,'Silver + Bronze Earring','Silver + Bronze Earring','Silver + Bronze Earring'),(131,2,'Silver + Bronze Earring','','',0,NULL,NULL,NULL),(131,3,'Silver + Bronze Earring','','',0,NULL,NULL,NULL),(131,4,'Silver + Bronze Earring','','',0,NULL,NULL,NULL),(132,1,'Silver / Bronze Earring','Bronze combined beautifully with Silver to create this unique piece.','',20,'Silver / Bronze Earring','Silver / Bronze Earring','Silver / Bronze Earring'),(132,2,'Silver / Bronze Earring','Bronze combined beautifully with Silver to create this unique piece.','',0,NULL,NULL,NULL),(132,3,'Silver / Bronze Earring','Bronze combined beautifully with Silver to create this unique piece.','',0,NULL,NULL,NULL),(132,4,'Silver / Bronze Earring','Bronze combined beautifully with Silver to create this unique piece.','',0,NULL,NULL,NULL),(133,1,'Plain Earring','','',5,'Plain Earring','Plain Earring','Plain Earring'),(133,2,'Plain Earring','','',0,NULL,NULL,NULL),(133,3,'Plain Earring','','',0,NULL,NULL,NULL),(133,4,'Plain Earring','','',0,NULL,NULL,NULL),(134,1,'Silver / Bronze Earring','A beautiful fusion of silver and bronze to create this exquisite piece from our mixed metals collection.','',5,'Silver / Bronze Earring','Silver / Bronze Earring','Silver / Bronze Earring'),(134,2,'Silver / Bronze Earring','A beautiful fusion of silver and bronze to create this exquisite piece from our mixed metals collection.','',0,NULL,NULL,NULL),(134,3,'Silver / Bronze Earring','A beautiful fusion of silver and bronze to create this exquisite piece from our mixed metals collection.','',0,NULL,NULL,NULL),(134,4,'Silver / Bronze Earring','A beautiful fusion of silver and bronze to create this exquisite piece from our mixed metals collection.','',0,NULL,NULL,NULL),(135,1,'Plain / Bronze Earring','','',11,'Plain / Bronze Earring','Plain / Bronze Earring','Plain / Bronze Earring'),(135,2,'Plain / Bronze Earring','','',0,NULL,NULL,NULL),(135,3,'Plain / Bronze Earring','','',0,NULL,NULL,NULL),(135,4,'Plain / Bronze Earring','','',0,NULL,NULL,NULL),(136,1,'Silver / Bronze Earring','','',4,'Silver / Bronze Earring','Silver / Bronze Earring','Silver / Bronze Earring'),(136,2,'Silver / Bronze Earring','','',0,NULL,NULL,NULL),(136,3,'Silver / Bronze Earring','','',0,NULL,NULL,NULL),(136,4,'Silver / Bronze Earring','','',0,NULL,NULL,NULL),(137,1,'Silver / Bronze Earring','','',16,'Silver / Bronze Earring','Silver / Bronze Earring','Silver / Bronze Earring'),(137,2,'Silver / Bronze Earring','','',0,NULL,NULL,NULL),(137,3,'Silver / Bronze Earring','','',0,NULL,NULL,NULL),(137,4,'Silver / Bronze Earring','','',0,NULL,NULL,NULL),(138,1,'Silver / Bronze Earring','','',12,'Silver / Bronze Earring','Silver / Bronze Earring','Silver / Bronze Earring'),(138,2,'Silver / Bronze Earring','','',0,NULL,NULL,NULL),(138,3,'Silver / Bronze Earring','','',0,NULL,NULL,NULL),(138,4,'Silver / Bronze Earring','','',0,NULL,NULL,NULL),(139,1,'Plain with Bronze Pendant','','',18,'Plain with Bronze Pendant','Plain with Bronze Pendant','Plain with Bronze Pendant'),(139,2,'Plain with Bronze Pendant','','',0,NULL,NULL,NULL),(139,3,'Plain with Bronze Pendant','','',0,NULL,NULL,NULL),(139,4,'Plain with Bronze Pendant','','',0,NULL,NULL,NULL),(140,1,'Plain with Bronze Pendant','','',17,'Plain with Bronze Pendant','Plain with Bronze Pendant','Plain with Bronze Pendant'),(140,2,'Plain with Bronze Pendant','','',0,NULL,NULL,NULL),(140,3,'Plain with Bronze Pendant','','',0,NULL,NULL,NULL),(140,4,'Plain with Bronze Pendant','','',0,NULL,NULL,NULL),(141,1,'Citrine Pendant','','',14,'Citrine Pendant','Citrine Pendant','Citrine Pendant'),(141,2,'Citrine Pendant','','',0,NULL,NULL,NULL),(141,3,'Citrine Pendant','','',0,NULL,NULL,NULL),(141,4,'Citrine Pendant','','',0,NULL,NULL,NULL),(142,1,'Plain with Bronze Ring','','',6,'Plain with Bronze Ring','Plain with Bronze Ring','Plain with Bronze Ring'),(142,2,'Plain with Bronze Ring','','',0,NULL,NULL,NULL),(142,3,'Plain with Bronze Ring','','',0,NULL,NULL,NULL),(142,4,'Plain with Bronze Ring','','',0,NULL,NULL,NULL),(143,1,'Citrine / Amethyst Earring','','',23,'Citrine / Amethyst Earring','Citrine / Amethyst Earring','Citrine / Amethyst Earring'),(143,2,'Citrine / Amethyst Earring','','',0,NULL,NULL,NULL),(143,3,'Citrine / Amethyst Earring','','',0,NULL,NULL,NULL),(143,4,'Citrine / Amethyst Earring','','',0,NULL,NULL,NULL),(144,1,'Amethyst Earring','','',14,'Amethyst Earring','Amethyst Earring','Amethyst Earring'),(144,2,'Amethyst Earring','','',0,NULL,NULL,NULL),(144,3,'Amethyst Earring','','',0,NULL,NULL,NULL),(144,4,'Amethyst Earring','','',0,NULL,NULL,NULL),(145,1,'Garnet Pendant','','',13,'Garnet Pendant','Garnet Pendant','Garnet Pendant'),(145,2,'Garnet Pendant','','',0,NULL,NULL,NULL),(145,3,'Garnet Pendant','','',0,NULL,NULL,NULL),(145,4,'Garnet Pendant','','',0,NULL,NULL,NULL),(146,1,'Citrine/Amethyst Ring','','',22,'Citrine/Amethyst Ring','Citrine/Amethyst Ring','Citrine/Amethyst Ring'),(146,2,'Citrine/Amethyst Ring','','',0,NULL,NULL,NULL),(146,3,'Citrine/Amethyst Ring','','',0,NULL,NULL,NULL),(146,4,'Citrine/Amethyst Ring','','',0,NULL,NULL,NULL),(147,1,'Rainbow Moonstone Ring','','',18,'Rainbow Moonstone Ring','Rainbow Moonstone Ring','Rainbow Moonstone Ring'),(147,2,'Rainbow Moonstone Ring','','',0,NULL,NULL,NULL),(147,3,'Rainbow Moonstone Ring','','',0,NULL,NULL,NULL),(147,4,'Rainbow Moonstone Ring','','',0,NULL,NULL,NULL),(148,1,'Garnet Facetted Ring','','',27,'Garnet Facetted Ring','Garnet Facetted Ring','Garnet Facetted Ring'),(148,2,'Garnet Facetted Ring','','',0,NULL,NULL,NULL),(148,3,'Garnet Facetted Ring','','',0,NULL,NULL,NULL),(148,4,'Garnet Facetted Ring','','',0,NULL,NULL,NULL),(149,1,'Amethyst Earring','','',11,'Amethyst Earring','Amethyst Earring','Amethyst Earring'),(149,2,'Amethyst Earring','','',0,NULL,NULL,NULL),(149,3,'Amethyst Earring','','',0,NULL,NULL,NULL),(149,4,'Amethyst Earring','','',0,NULL,NULL,NULL),(150,1,'Plain Earring','','',32,'Plain Earring','Plain Earring','Plain Earring'),(150,2,'Plain Earring','','',0,NULL,NULL,NULL),(150,3,'Plain Earring','','',0,NULL,NULL,NULL),(150,4,'Plain Earring','','',0,NULL,NULL,NULL),(151,1,'Amethyst  Earring','','',10,'Amethyst  Earring','Amethyst  Earring','Amethyst  Earring'),(151,2,'Amethyst  Earring','','',0,NULL,NULL,NULL),(151,3,'Amethyst  Earring','','',0,NULL,NULL,NULL),(151,4,'Amethyst  Earring','','',0,NULL,NULL,NULL),(152,1,'Pearl Earring','','',18,'Pearl Earring','Pearl Earring','Pearl Earring'),(152,2,'Pearl Earring','','',0,NULL,NULL,NULL),(152,3,'Pearl Earring','','',0,NULL,NULL,NULL),(152,4,'Pearl Earring','','',0,NULL,NULL,NULL),(153,1,'Labradorite Earring','','',12,'Labradorite Earring','Labradorite Earring','Labradorite Earring'),(153,2,'Labradorite Earring','','',0,NULL,NULL,NULL),(153,3,'Labradorite Earring','','',0,NULL,NULL,NULL),(153,4,'Labradorite Earring','','',0,NULL,NULL,NULL),(154,1,'Plain Earring','','',7,'Plain Earring','Plain Earring','Plain Earring'),(154,2,'Plain Earring','','',0,NULL,NULL,NULL),(154,3,'Plain Earring','','',0,NULL,NULL,NULL),(154,4,'Plain Earring','','',0,NULL,NULL,NULL),(155,1,'Plain Earring','','',1,'Plain Earring','Plain Earring','Plain Earring'),(155,2,'Plain Earring','','',0,NULL,NULL,NULL),(155,3,'Plain Earring','','',0,NULL,NULL,NULL),(155,4,'Plain Earring','','',0,NULL,NULL,NULL),(156,1,'Plain Earring','','',3,'Plain Earring','Plain Earring','Plain Earring'),(156,2,'Plain Earring','','',0,NULL,NULL,NULL),(156,3,'Plain Earring','','',0,NULL,NULL,NULL),(156,4,'Plain Earring','','',0,NULL,NULL,NULL),(157,1,'Smoky Earring','','',6,'Smoky Earring','Smoky Earring','Smoky Earring'),(157,2,'Smoky Earring','','',0,NULL,NULL,NULL),(157,3,'Smoky Earring','','',0,NULL,NULL,NULL),(157,4,'Smoky Earring','','',0,NULL,NULL,NULL),(158,1,'Plain Earring','','',17,'Plain Earring','Plain Earring','Plain Earring'),(158,2,'Plain Earring','','',0,NULL,NULL,NULL),(158,3,'Plain Earring','','',0,NULL,NULL,NULL),(158,4,'Plain Earring','','',0,NULL,NULL,NULL),(159,1,'Plain Earring','A plain earring from Nature\'s Abstraction family.','',12,'Plain Earring','Plain Earring','Plain Earring'),(159,2,'Plain Earring','A plain earring from Nature\'s Abstraction family.','',0,NULL,NULL,NULL),(159,3,'Plain Earring','A plain earring from Nature\'s Abstraction family.','',0,NULL,NULL,NULL),(159,4,'Plain Earring','A plain earring from Nature\'s Abstraction family.','',0,NULL,NULL,NULL),(160,1,'Turquoise Earring','','',11,'Turquoise Earring','Turquoise Earring','Turquoise Earring'),(160,2,'Turquoise Earring','','',0,NULL,NULL,NULL),(160,3,'Turquoise Earring','','',0,NULL,NULL,NULL),(160,4,'Turquoise Earring','','',0,NULL,NULL,NULL),(161,1,'Pearl Earring','','',4,'Pearl Earring','Pearl Earring','Pearl Earring'),(161,2,'Pearl Earring','','',0,NULL,NULL,NULL),(161,3,'Pearl Earring','','',0,NULL,NULL,NULL),(161,4,'Pearl Earring','','',0,NULL,NULL,NULL),(162,1,'Plain Pendant','','',9,'Plain Pendant','Plain Pendant','Plain Pendant'),(162,2,'Plain Pendant','','',0,NULL,NULL,NULL),(162,3,'Plain Pendant','','',0,NULL,NULL,NULL),(162,4,'Plain Pendant','','',0,NULL,NULL,NULL),(163,1,'Peridot/Citrine Facetted Pendant','','',34,'Peridot/Citrine Facetted Pendant','Peridot/Citrine Facetted Pendant','Peridot/Citrine Facetted Pendant'),(163,2,'Peridot/Citrine Facetted Pendant','','',0,NULL,NULL,NULL),(163,3,'Peridot/Citrine Facetted Pendant','','',0,NULL,NULL,NULL),(163,4,'Peridot/Citrine Facetted Pendant','','',0,NULL,NULL,NULL),(164,1,'White Pearl Pendant','','',15,'White Pearl Pendant','White Pearl Pendant','White Pearl Pendant'),(164,2,'White Pearl Pendant','','',0,NULL,NULL,NULL),(164,3,'White Pearl Pendant','','',0,NULL,NULL,NULL),(164,4,'White Pearl Pendant','','',0,NULL,NULL,NULL),(165,1,'Peridot Cabochon/Labradorite Rose Facetted Pendant','','',20,'Peridot Cabochon/Labradorite Rose Facetted Pendant','Peridot Cabochon/Labradorite Rose Facetted Pendant','Peridot Cabochon/Labradorite Rose Facetted Pendant'),(165,2,'Peridot Cabochon/Labradorite Rose Facetted Pendant','','',0,NULL,NULL,NULL),(165,3,'Peridot Cabochon/Labradorite Rose Facetted Pendant','','',0,NULL,NULL,NULL),(165,4,'Peridot Cabochon/Labradorite Rose Facetted Pendant','','',0,NULL,NULL,NULL),(166,1,'Pearl Pendant','','',14,'Pearl Pendant','Pearl Pendant','Pearl Pendant'),(166,2,'Pearl Pendant','','',0,NULL,NULL,NULL),(166,3,'Pearl Pendant','','',0,NULL,NULL,NULL),(166,4,'Pearl Pendant','','',0,NULL,NULL,NULL),(167,1,'Iolite/Garnet/Citrine/Amethyst Pendant','','',13,'Iolite/Garnet/Citrine/Amethyst Pendant','Iolite/Garnet/Citrine/Amethyst Pendant','Iolite/Garnet/Citrine/Amethyst Pendant'),(167,2,'Iolite/Garnet/Citrine/Amethyst Pendant','','',0,NULL,NULL,NULL),(167,3,'Iolite/Garnet/Citrine/Amethyst Pendant','','',0,NULL,NULL,NULL),(167,4,'Iolite/Garnet/Citrine/Amethyst Pendant','','',0,NULL,NULL,NULL),(168,1,'Plain Pendant','','',18,'Plain Pendant','Plain Pendant','Plain Pendant'),(168,2,'Plain Pendant','','',0,NULL,NULL,NULL),(168,3,'Plain Pendant','','',0,NULL,NULL,NULL),(168,4,'Plain Pendant','','',0,NULL,NULL,NULL),(169,1,'White Pearl Ring','','',19,'White Pearl Ring','White Pearl Ring','White Pearl Ring'),(169,2,'White Pearl Ring','','',0,NULL,NULL,NULL),(169,3,'White Pearl Ring','','',0,NULL,NULL,NULL),(169,4,'White Pearl Ring','','',0,NULL,NULL,NULL),(170,1,'Turquoise Ring','','',24,'Turquoise Ring','Turquoise Ring','Turquoise Ring'),(170,2,'Turquoise Ring','','',0,NULL,NULL,NULL),(170,3,'Turquoise Ring','','',0,NULL,NULL,NULL),(170,4,'Turquoise Ring','','',0,NULL,NULL,NULL),(171,1,'Plain Ring','','',42,'Plain Ring','Plain Ring','Plain Ring'),(171,2,'Plain Ring','','',0,NULL,NULL,NULL),(171,3,'Plain Ring','','',0,NULL,NULL,NULL),(171,4,'Plain Ring','','',0,NULL,NULL,NULL),(172,1,'Plain Ring','','',27,'Plain Ring','Plain Ring','Plain Ring'),(172,2,'Plain Ring','','',0,NULL,NULL,NULL),(172,3,'Plain Ring','','',0,NULL,NULL,NULL),(172,4,'Plain Ring','','',0,NULL,NULL,NULL),(173,1,'Plain Ring','','',14,'Plain Ring','Plain Ring','Plain Ring'),(173,2,'Plain Ring','','',0,NULL,NULL,NULL),(173,3,'Plain Ring','','',0,NULL,NULL,NULL),(173,4,'Plain Ring','','',0,NULL,NULL,NULL);
/*!40000 ALTER TABLE `products_description` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_groups`
--

DROP TABLE IF EXISTS `products_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `products_groups` (
  `customers_group_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `customers_group_price` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `products_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`customers_group_id`,`products_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_groups`
--

LOCK TABLES `products_groups` WRITE;
/*!40000 ALTER TABLE `products_groups` DISABLE KEYS */;
INSERT INTO `products_groups` VALUES (1,'20.0000',63),(2,'12.0000',63);
/*!40000 ALTER TABLE `products_groups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_notifications`
--

DROP TABLE IF EXISTS `products_notifications`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `products_notifications` (
  `products_id` int(11) NOT NULL,
  `customers_id` int(11) NOT NULL,
  `date_added` datetime NOT NULL,
  PRIMARY KEY (`products_id`,`customers_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_notifications`
--

LOCK TABLES `products_notifications` WRITE;
/*!40000 ALTER TABLE `products_notifications` DISABLE KEYS */;
/*!40000 ALTER TABLE `products_notifications` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_options`
--

DROP TABLE IF EXISTS `products_options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `products_options` (
  `products_options_id` int(11) NOT NULL DEFAULT '0',
  `language_id` int(11) NOT NULL DEFAULT '1',
  `products_options_name` varchar(32) NOT NULL DEFAULT '',
  PRIMARY KEY (`products_options_id`,`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_options`
--

LOCK TABLES `products_options` WRITE;
/*!40000 ALTER TABLE `products_options` DISABLE KEYS */;
INSERT INTO `products_options` VALUES (2,1,'Size'),(2,2,'Size'),(2,3,'Size'),(2,4,'Size'),(3,1,'Gemstone'),(3,2,'Gemstone'),(3,3,'Gemstone'),(3,4,'Gemstone');
/*!40000 ALTER TABLE `products_options` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_options_values`
--

DROP TABLE IF EXISTS `products_options_values`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `products_options_values` (
  `products_options_values_id` int(11) NOT NULL DEFAULT '0',
  `language_id` int(11) NOT NULL DEFAULT '1',
  `products_options_values_name` varchar(64) NOT NULL DEFAULT '',
  PRIMARY KEY (`products_options_values_id`,`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_options_values`
--

LOCK TABLES `products_options_values` WRITE;
/*!40000 ALTER TABLE `products_options_values` DISABLE KEYS */;
INSERT INTO `products_options_values` VALUES (1,1,'7'),(1,2,'7'),(1,3,'7'),(1,4,'7'),(2,1,'8'),(2,2,'8'),(2,3,'8'),(2,4,'8'),(3,1,'9'),(3,2,'9'),(3,3,'9'),(3,4,'9'),(4,1,'10'),(4,2,'10'),(4,3,'10'),(4,4,'10'),(5,1,'11'),(5,2,'11'),(5,3,'11'),(5,4,'11'),(6,1,'12'),(6,2,'12'),(6,3,'12'),(6,4,'12'),(7,1,'Citrine'),(7,2,'Citrine'),(7,3,'Citrine'),(7,4,'Citrine'),(8,1,'Amethyst'),(8,2,'Amethyst'),(8,3,'Amethyst'),(8,4,'Amethyst'),(9,1,'Moonstone'),(9,2,'Moonstone'),(9,3,'Moonstone'),(9,4,'Moonstone'),(10,1,'Quartz'),(10,2,'Quartz'),(10,3,'Quartz'),(10,4,'Quartz'),(11,1,'PURPLE'),(11,2,'PURPLE'),(11,3,'PURPLE'),(11,4,'PURPLE'),(12,1,'White'),(12,2,'White'),(12,3,'White'),(12,4,'White');
/*!40000 ALTER TABLE `products_options_values` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_options_values_to_products_options`
--

DROP TABLE IF EXISTS `products_options_values_to_products_options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `products_options_values_to_products_options` (
  `products_options_values_to_products_options_id` int(11) NOT NULL AUTO_INCREMENT,
  `products_options_id` int(11) NOT NULL,
  `products_options_values_id` int(11) NOT NULL,
  PRIMARY KEY (`products_options_values_to_products_options_id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_options_values_to_products_options`
--

LOCK TABLES `products_options_values_to_products_options` WRITE;
/*!40000 ALTER TABLE `products_options_values_to_products_options` DISABLE KEYS */;
INSERT INTO `products_options_values_to_products_options` VALUES (1,2,1),(2,2,2),(3,2,3),(4,2,4),(5,2,5),(6,2,6),(7,3,7),(8,3,8),(9,3,9),(10,3,10),(11,3,11),(12,3,12);
/*!40000 ALTER TABLE `products_options_values_to_products_options` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_to_categories`
--

DROP TABLE IF EXISTS `products_to_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `products_to_categories` (
  `products_id` int(11) NOT NULL,
  `categories_id` int(11) NOT NULL,
  PRIMARY KEY (`products_id`,`categories_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_to_categories`
--

LOCK TABLES `products_to_categories` WRITE;
/*!40000 ALTER TABLE `products_to_categories` DISABLE KEYS */;
INSERT INTO `products_to_categories` VALUES (63,14),(64,14),(65,15),(66,14),(67,14),(68,14),(69,14),(70,14),(71,14),(72,14),(73,14),(74,14),(75,15),(76,15),(77,15),(78,15),(79,15),(80,15),(81,15),(82,15),(83,15),(84,18),(85,15),(86,15),(87,15),(88,15),(89,15),(90,15),(91,15),(92,15),(93,15),(94,15),(95,15),(96,15),(97,15),(98,15),(99,14),(100,14),(101,14),(102,14),(103,14),(104,14),(105,16),(106,17),(107,17),(108,16),(109,16),(110,15),(111,15),(112,15),(113,15),(114,15),(115,15),(116,15),(117,15),(118,14),(119,14),(120,14),(121,14),(122,14),(123,14),(124,14),(125,14),(126,16),(127,16),(128,16),(129,15),(130,15),(131,15),(132,15),(133,15),(134,15),(135,15),(136,15),(137,15),(138,15),(139,14),(140,14),(141,14),(142,18),(143,15),(144,15),(145,14),(146,16),(147,16),(148,16),(149,15),(150,15),(151,15),(152,15),(153,15),(154,15),(155,15),(156,15),(157,15),(158,15),(159,15),(160,15),(161,15),(162,14),(163,14),(164,14),(165,14),(166,14),(167,14),(168,14),(169,16),(170,16),(171,16),(172,16),(173,16);
/*!40000 ALTER TABLE `products_to_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reviews`
--

DROP TABLE IF EXISTS `reviews`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `reviews` (
  `reviews_id` int(11) NOT NULL AUTO_INCREMENT,
  `products_id` int(11) NOT NULL,
  `customers_id` int(11) DEFAULT NULL,
  `customers_name` varchar(64) NOT NULL,
  `reviews_rating` int(1) DEFAULT NULL,
  `date_added` datetime DEFAULT NULL,
  `last_modified` datetime DEFAULT NULL,
  `reviews_read` int(5) NOT NULL DEFAULT '0',
  PRIMARY KEY (`reviews_id`),
  KEY `idx_reviews_products_id` (`products_id`),
  KEY `idx_reviews_customers_id` (`customers_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reviews`
--

LOCK TABLES `reviews` WRITE;
/*!40000 ALTER TABLE `reviews` DISABLE KEYS */;
/*!40000 ALTER TABLE `reviews` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reviews_description`
--

DROP TABLE IF EXISTS `reviews_description`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `reviews_description` (
  `reviews_id` int(11) NOT NULL,
  `languages_id` int(11) NOT NULL,
  `reviews_text` text NOT NULL,
  PRIMARY KEY (`reviews_id`,`languages_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reviews_description`
--

LOCK TABLES `reviews_description` WRITE;
/*!40000 ALTER TABLE `reviews_description` DISABLE KEYS */;
/*!40000 ALTER TABLE `reviews_description` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sessions`
--

DROP TABLE IF EXISTS `sessions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sessions` (
  `sesskey` varchar(32) NOT NULL,
  `expiry` int(11) unsigned NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`sesskey`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sessions`
--

LOCK TABLES `sessions` WRITE;
/*!40000 ALTER TABLE `sessions` DISABLE KEYS */;
INSERT INTO `sessions` VALUES ('0070d0b67cec6dd8407ce78e84443fc2',1310846888,'cart|O:12:\"shoppingCart\":5:{s:8:\"contents\";a:0:{}s:5:\"total\";i:0;s:6:\"weight\";i:0;s:6:\"cartID\";N;s:12:\"content_type\";b:0;}language|s:31:\".././../images/img-530637851064\";languages_id|s:1:\"4\";currency|s:3:\"AUD\";navigation|O:17:\"navigationHistory\":2:{s:4:\"path\";a:2:{i:0;a:4:{s:4:\"page\";s:9:\"index.php\";s:4:\"mode\";s:6:\"NONSSL\";s:3:\"get\";a:0:{}s:4:\"post\";a:0:{}}i:1;a:4:{s:4:\"page\";s:11:\"catalog.php\";s:4:\"mode\";s:6:\"NONSSL\";s:3:\"get\";a:1:{s:6:\"osCsid\";s:32:\"0070d0b67cec6dd8407ce78e84443fc2\";}s:4:\"post\";a:0:{}}}s:8:\"snapshot\";a:0:{}}wishList|O:8:\"wishlist\":1:{s:6:\"wishID\";N;}'),('06cb7c37e6753684fc133f7974e55453',1310830039,'language|s:7:\"english\";languages_id|s:1:\"1\";selected_box|s:13:\"configuration\";'),('06ffc195a190bf2943a113f89a6a0c6d',1310836797,'language|s:7:\"english\";languages_id|s:1:\"1\";selected_box|s:13:\"configuration\";'),('071886679f5017dac551c7eee3ce4314',1310830025,'cart|O:12:\"shoppingCart\":4:{s:8:\"contents\";a:0:{}s:5:\"total\";i:0;s:6:\"weight\";i:0;s:12:\"content_type\";b:0;}language|s:7:\"english\";languages_id|s:1:\"1\";currency|s:3:\"AUD\";navigation|O:17:\"navigationHistory\":2:{s:4:\"path\";a:1:{i:0;a:4:{s:4:\"page\";s:9:\"login.php\";s:4:\"mode\";s:6:\"NONSSL\";s:3:\"get\";a:0:{}s:4:\"post\";a:0:{}}}s:8:\"snapshot\";a:0:{}}wishList|O:8:\"wishlist\":0:{}'),('0ab4b55c8e400dc74654dded1f226c60',1310830037,'language|s:7:\"english\";languages_id|s:1:\"1\";selected_box|s:13:\"configuration\";'),('0b1751a0044a60357cc12b21589d696a',1310836797,'language|s:7:\"english\";languages_id|s:1:\"1\";selected_box|s:13:\"configuration\";'),('0cb5aacc17ea7cd5bfdbba83fcd73f2e',1310836768,'language|s:7:\"english\";languages_id|s:1:\"1\";selected_box|s:13:\"configuration\";'),('112376c713cc35e669cbe19f3a105b9a',1310830031,'language|s:7:\"english\";languages_id|s:1:\"1\";selected_box|s:13:\"configuration\";'),('145b74bd61e0ef86b18510d06b67af0e',1310830028,'language|s:7:\"english\";languages_id|s:1:\"1\";selected_box|s:13:\"configuration\";'),('14e2da4f86789e0e438757bc68076ca7',1310830036,'language|s:7:\"english\";languages_id|s:1:\"1\";selected_box|s:13:\"configuration\";'),('1c094d1c9a5e5ac5c95819659881aef2',1310836773,'language|s:7:\"english\";languages_id|s:1:\"1\";selected_box|s:13:\"configuration\";'),('1d422509776ea852ec3f8f78fe38c493',1310838910,'cart|O:12:\"shoppingCart\":4:{s:8:\"contents\";a:0:{}s:5:\"total\";i:0;s:6:\"weight\";i:0;s:12:\"content_type\";b:0;}language|s:7:\"english\";languages_id|s:1:\"1\";currency|s:3:\"AUD\";navigation|O:17:\"navigationHistory\":2:{s:4:\"path\";a:1:{i:0;a:4:{s:4:\"page\";s:7:\"cms.php\";s:4:\"mode\";s:6:\"NONSSL\";s:3:\"get\";a:1:{s:7:\"page_id\";s:1:\"2\";}s:4:\"post\";a:0:{}}}s:8:\"snapshot\";a:0:{}}wishList|O:8:\"wishlist\":0:{}'),('26ac8adf6214442059d07fc6456ac823',1310821346,'cart|O:12:\"shoppingCart\":5:{s:8:\"contents\";a:0:{}s:5:\"total\";i:0;s:6:\"weight\";i:0;s:6:\"cartID\";N;s:12:\"content_type\";b:0;}language|s:31:\".././../images/img-530637851064\";languages_id|s:1:\"4\";currency|s:3:\"AUD\";navigation|O:17:\"navigationHistory\":2:{s:4:\"path\";a:1:{i:0;a:4:{s:4:\"page\";s:9:\"index.php\";s:4:\"mode\";s:6:\"NONSSL\";s:3:\"get\";a:0:{}s:4:\"post\";a:0:{}}}s:8:\"snapshot\";a:4:{s:4:\"page\";s:11:\"catalog.php\";s:4:\"mode\";s:3:\"SSL\";s:3:\"get\";a:0:{}s:4:\"post\";a:0:{}}}wishList|O:8:\"wishlist\":1:{s:6:\"wishID\";N;}'),('2bf878b5a5f00a6a119b4ac0ab31ad63',1310821178,'cart|O:12:\"shoppingCart\":6:{s:8:\"contents\";a:3:{i:130;a:1:{s:3:\"qty\";s:1:\"1\";}i:107;a:1:{s:3:\"qty\";s:1:\"1\";}i:78;a:1:{s:3:\"qty\";s:1:\"1\";}}s:5:\"total\";i:0;s:6:\"weight\";i:0;s:6:\"cartID\";N;s:12:\"content_type\";b:0;s:5:\"cg_id\";i:0;}language|s:31:\".././../images/img-530637851064\";languages_id|s:1:\"4\";currency|s:3:\"AUD\";navigation|O:17:\"navigationHistory\":2:{s:4:\"path\";a:4:{i:0;a:4:{s:4:\"page\";s:26:\"advanced_search_result.php\";s:4:\"mode\";s:6:\"NONSSL\";s:3:\"get\";a:3:{s:8:\"keywords\";s:7:\"Pendant\";s:1:\"x\";s:2:\"13\";s:1:\"y\";s:2:\"15\";}s:4:\"post\";a:0:{}}i:1;a:4:{s:4:\"page\";s:11:\"catalog.php\";s:4:\"mode\";s:6:\"NONSSL\";s:3:\"get\";a:0:{}s:4:\"post\";a:0:{}}i:2;a:4:{s:4:\"page\";s:11:\"product.php\";s:4:\"mode\";s:6:\"NONSSL\";s:3:\"get\";a:2:{s:5:\"cPath\";s:2:\"16\";s:8:\"language\";s:2:\"wa\";}s:4:\"post\";a:0:{}}i:3;a:4:{s:4:\"page\";s:9:\"index.php\";s:4:\"mode\";s:6:\"NONSSL\";s:3:\"get\";a:0:{}s:4:\"post\";a:0:{}}}s:8:\"snapshot\";a:0:{}}wishList|O:8:\"wishlist\":1:{s:6:\"wishID\";a:2:{i:144;a:1:{i:0;s:3:\"144\";}i:73;a:1:{i:0;s:2:\"73\";}}}customer_id|s:2:\"19\";customer_default_address_id|s:2:\"19\";customer_first_name|s:5:\"Payal\";sppc_customer_group_id|s:1:\"0\";sppc_customer_group_show_tax|i:1;sppc_customer_group_tax_exempt|i:0;customer_country_id|s:2:\"13\";customer_zone_id|s:1:\"0\";'),('32b7acbcefce9581b2aa21bc5be6286c',1310830048,'language|s:7:\"english\";languages_id|s:1:\"1\";selected_box|s:13:\"configuration\";'),('435a28e2330702394e49de693106cca2',1310830025,'cart|O:12:\"shoppingCart\":4:{s:8:\"contents\";a:0:{}s:5:\"total\";i:0;s:6:\"weight\";i:0;s:12:\"content_type\";b:0;}language|s:7:\"english\";languages_id|s:1:\"1\";currency|s:3:\"AUD\";navigation|O:17:\"navigationHistory\":2:{s:4:\"path\";a:1:{i:0;a:4:{s:4:\"page\";s:9:\"login.php\";s:4:\"mode\";s:6:\"NONSSL\";s:3:\"get\";a:0:{}s:4:\"post\";a:0:{}}}s:8:\"snapshot\";a:0:{}}wishList|O:8:\"wishlist\":0:{}'),('53d106efea85b86e002ad410207b5119',1310843695,'cart|O:12:\"shoppingCart\":5:{s:8:\"contents\";a:0:{}s:5:\"total\";i:0;s:6:\"weight\";i:0;s:6:\"cartID\";N;s:12:\"content_type\";b:0;}language|s:31:\".././../images/img-530637851064\";languages_id|s:1:\"4\";currency|s:3:\"AUD\";navigation|O:17:\"navigationHistory\":2:{s:4:\"path\";a:2:{i:0;a:4:{s:4:\"page\";s:9:\"index.php\";s:4:\"mode\";s:6:\"NONSSL\";s:3:\"get\";a:0:{}s:4:\"post\";a:0:{}}i:1;a:4:{s:4:\"page\";s:11:\"catalog.php\";s:4:\"mode\";s:6:\"NONSSL\";s:3:\"get\";a:1:{s:6:\"osCsid\";s:32:\"53d106efea85b86e002ad410207b5119\";}s:4:\"post\";a:0:{}}}s:8:\"snapshot\";a:4:{s:4:\"page\";s:11:\"catalog.php\";s:4:\"mode\";s:3:\"SSL\";s:3:\"get\";a:0:{}s:4:\"post\";a:0:{}}}wishList|O:8:\"wishlist\":1:{s:6:\"wishID\";N;}'),('60cd9efb634c177e6773950785a96759',1310830049,'language|s:7:\"english\";languages_id|s:1:\"1\";selected_box|s:13:\"configuration\";'),('66afbffeeddaef21a7fcc44159056346',1310835228,'cart|O:12:\"shoppingCart\":4:{s:8:\"contents\";a:0:{}s:5:\"total\";i:0;s:6:\"weight\";i:0;s:12:\"content_type\";b:0;}language|s:7:\"english\";languages_id|s:1:\"1\";currency|s:3:\"AUD\";navigation|O:17:\"navigationHistory\":2:{s:4:\"path\";a:1:{i:0;a:4:{s:4:\"page\";s:7:\"cms.php\";s:4:\"mode\";s:6:\"NONSSL\";s:3:\"get\";a:2:{s:7:\"page_id\";s:1:\"1\";s:6:\"osCsid\";s:32:\"66afbffeeddaef21a7fcc44159056346\";}s:4:\"post\";a:0:{}}}s:8:\"snapshot\";a:0:{}}wishList|O:8:\"wishlist\":0:{}'),('700529771a1f5271f6e8b6dc4a3f6b99',1310836774,'language|s:7:\"english\";languages_id|s:1:\"1\";selected_box|s:13:\"configuration\";'),('745102b51a4a1b373ef05257c2700763',1310830039,'language|s:7:\"english\";languages_id|s:1:\"1\";selected_box|s:13:\"configuration\";'),('7a958f9b0117ee48acbe72b6a5b62767',1310830048,'language|s:7:\"english\";languages_id|s:1:\"1\";selected_box|s:13:\"configuration\";'),('7ff2d3ad5cb21203ded709cff5f87fef',1310830045,'language|s:7:\"english\";languages_id|s:1:\"1\";selected_box|s:13:\"configuration\";'),('83de8f4d2b303af6714e4117e9f67b49',1310830047,'language|s:7:\"english\";languages_id|s:1:\"1\";selected_box|s:13:\"configuration\";'),('87582cca28ad967ae5729f5cbb0c837b',1310830026,'language|s:7:\"english\";languages_id|s:1:\"1\";selected_box|s:13:\"configuration\";'),('8c046ef5049bd0291b17f741aaa95805',1310830029,'language|s:7:\"english\";languages_id|s:1:\"1\";selected_box|s:13:\"configuration\";'),('8cdc3a03023b6339bcefce0d3fe0d128',1310836766,'language|s:7:\"english\";languages_id|s:1:\"1\";selected_box|s:13:\"configuration\";'),('90f7f8c6699ea9fbe7f2b671eeb58c48',1310830047,'language|s:7:\"english\";languages_id|s:1:\"1\";selected_box|s:13:\"configuration\";'),('97c689d5b1297ef6f19cdd9bdcb8b144',1310830049,'language|s:7:\"english\";languages_id|s:1:\"1\";selected_box|s:13:\"configuration\";'),('99a67ccb63c708da020f9dfc98e8b03d',1310830047,'language|s:7:\"english\";languages_id|s:1:\"1\";selected_box|s:13:\"configuration\";'),('9cb71282acb8ff0a57b710293ffba9c1',1310830048,'language|s:7:\"english\";languages_id|s:1:\"1\";selected_box|s:13:\"configuration\";'),('a17027b28d089247cf7c137ffeaacf99',1310836765,'cart|O:12:\"shoppingCart\":4:{s:8:\"contents\";a:0:{}s:5:\"total\";i:0;s:6:\"weight\";i:0;s:12:\"content_type\";b:0;}language|s:7:\"english\";languages_id|s:1:\"1\";currency|s:3:\"AUD\";navigation|O:17:\"navigationHistory\":2:{s:4:\"path\";a:1:{i:0;a:4:{s:4:\"page\";s:9:\"login.php\";s:4:\"mode\";s:6:\"NONSSL\";s:3:\"get\";a:0:{}s:4:\"post\";a:0:{}}}s:8:\"snapshot\";a:0:{}}wishList|O:8:\"wishlist\":0:{}'),('a2e169e48fca3f65b0f992aa877d5679',1310830046,'language|s:7:\"english\";languages_id|s:1:\"1\";selected_box|s:13:\"configuration\";'),('a2e61ba8bc98b405d962f34e6f19a505',1310822189,'cart|O:12:\"shoppingCart\":5:{s:8:\"contents\";a:0:{}s:5:\"total\";i:0;s:6:\"weight\";i:0;s:6:\"cartID\";N;s:12:\"content_type\";b:0;}language|s:31:\".././../images/img-530637851064\";languages_id|s:1:\"4\";currency|s:3:\"AUD\";navigation|O:17:\"navigationHistory\":2:{s:4:\"path\";a:3:{i:0;a:4:{s:4:\"page\";s:9:\"index.php\";s:4:\"mode\";s:6:\"NONSSL\";s:3:\"get\";a:0:{}s:4:\"post\";a:0:{}}i:1;a:4:{s:4:\"page\";s:11:\"catalog.php\";s:4:\"mode\";s:6:\"NONSSL\";s:3:\"get\";a:1:{s:6:\"osCsid\";s:32:\"a2e61ba8bc98b405d962f34e6f19a505\";}s:4:\"post\";a:0:{}}i:2;a:4:{s:4:\"page\";s:11:\"product.php\";s:4:\"mode\";s:6:\"NONSSL\";s:3:\"get\";a:2:{s:5:\"cPath\";s:2:\"14\";s:8:\"language\";s:2:\"wa\";}s:4:\"post\";a:0:{}}}s:8:\"snapshot\";a:4:{s:4:\"page\";s:11:\"catalog.php\";s:4:\"mode\";s:3:\"SSL\";s:3:\"get\";a:0:{}s:4:\"post\";a:0:{}}}wishList|O:8:\"wishlist\":1:{s:6:\"wishID\";N;}'),('aa1e1db809bd707b4cca8dc4aa03614a',1310836771,'language|s:7:\"english\";languages_id|s:1:\"1\";selected_box|s:13:\"configuration\";'),('af1a19468a5233c9ad41f37a819d1c5f',1310830031,'language|s:7:\"english\";languages_id|s:1:\"1\";selected_box|s:13:\"configuration\";'),('b644cc11c04628fbca66454a28055716',1310830038,'language|s:7:\"english\";languages_id|s:1:\"1\";selected_box|s:13:\"configuration\";'),('c5799bbf95f2a1f24698693980ceb56f',1310830030,'language|s:7:\"english\";languages_id|s:1:\"1\";selected_box|s:13:\"configuration\";'),('c7d0f4c33809d79f3f6971e74ae93473',1310822267,'cart|O:12:\"shoppingCart\":5:{s:8:\"contents\";a:0:{}s:5:\"total\";i:0;s:6:\"weight\";i:0;s:6:\"cartID\";N;s:12:\"content_type\";b:0;}language|s:31:\".././../images/img-530637851064\";languages_id|s:1:\"4\";currency|s:3:\"AUD\";navigation|O:17:\"navigationHistory\":2:{s:4:\"path\";a:3:{i:0;a:4:{s:4:\"page\";s:9:\"index.php\";s:4:\"mode\";s:6:\"NONSSL\";s:3:\"get\";a:0:{}s:4:\"post\";a:0:{}}i:1;a:4:{s:4:\"page\";s:11:\"catalog.php\";s:4:\"mode\";s:6:\"NONSSL\";s:3:\"get\";a:0:{}s:4:\"post\";a:0:{}}i:2;a:4:{s:4:\"page\";s:11:\"product.php\";s:4:\"mode\";s:6:\"NONSSL\";s:3:\"get\";a:2:{s:5:\"cPath\";s:2:\"15\";s:8:\"language\";s:2:\"wa\";}s:4:\"post\";a:0:{}}}s:8:\"snapshot\";a:4:{s:4:\"page\";s:11:\"catalog.php\";s:4:\"mode\";s:3:\"SSL\";s:3:\"get\";a:0:{}s:4:\"post\";a:0:{}}}wishList|O:8:\"wishlist\":1:{s:6:\"wishID\";N;}'),('cf7833658c0c833b0cee8b1fa36bc053',1310830027,'language|s:7:\"english\";languages_id|s:1:\"1\";selected_box|s:13:\"configuration\";'),('d117dc7d2ad85215948c331da89fec08',1310836795,'language|s:7:\"english\";languages_id|s:1:\"1\";selected_box|s:13:\"configuration\";'),('d1ef7773f54bfeb0fe929d8d70c3e619',1310819904,'language|s:7:\"english\";languages_id|s:1:\"1\";selected_box|s:5:\"tools\";admin|a:2:{s:2:\"id\";s:1:\"1\";s:8:\"username\";s:6:\"master\";}current_path|s:25:\"/home/astral/public_html/\";'),('d636de3e7f3a9630a474cc7a2086cd18',1310836792,'language|s:7:\"english\";languages_id|s:1:\"1\";selected_box|s:13:\"configuration\";'),('d8b032b2541a80d5a1e60543cf376609',1310830026,'language|s:7:\"english\";languages_id|s:1:\"1\";selected_box|s:13:\"configuration\";current_path|s:25:\"/home/astral/public_html/\";'),('db6fccedc7255524aefd99b761f6da6c',1310830046,'language|s:7:\"english\";languages_id|s:1:\"1\";selected_box|s:13:\"configuration\";'),('e4ccb662d193bd98a071187183aab922',1310830045,'language|s:7:\"english\";languages_id|s:1:\"1\";selected_box|s:13:\"configuration\";'),('eac39057c4355538bcb98855cc31210f',1310821315,'cart|O:12:\"shoppingCart\":6:{s:8:\"contents\";a:3:{i:130;a:1:{s:3:\"qty\";s:1:\"1\";}i:107;a:1:{s:3:\"qty\";s:1:\"1\";}i:78;a:1:{s:3:\"qty\";s:1:\"1\";}}s:5:\"total\";i:0;s:6:\"weight\";i:0;s:6:\"cartID\";N;s:12:\"content_type\";b:0;s:5:\"cg_id\";i:0;}language|s:31:\".././../images/img-530637851064\";languages_id|s:1:\"4\";currency|s:3:\"AUD\";navigation|O:17:\"navigationHistory\":2:{s:4:\"path\";a:4:{i:0;a:4:{s:4:\"page\";s:9:\"index.php\";s:4:\"mode\";s:6:\"NONSSL\";s:3:\"get\";a:0:{}s:4:\"post\";a:0:{}}i:1;a:4:{s:4:\"page\";s:9:\"login.php\";s:4:\"mode\";s:6:\"NONSSL\";s:3:\"get\";a:2:{s:6:\"action\";s:7:\"process\";s:6:\"osCsid\";s:32:\"eac39057c4355538bcb98855cc31210f\";}s:4:\"post\";a:4:{s:13:\"email_address\";s:25:\"payal@astraljewels.com.au\";s:8:\"password\";s:8:\"password\";s:1:\"x\";s:1:\"0\";s:1:\"y\";s:1:\"0\";}}i:2;a:4:{s:4:\"page\";s:11:\"catalog.php\";s:4:\"mode\";s:6:\"NONSSL\";s:3:\"get\";a:0:{}s:4:\"post\";a:0:{}}i:3;a:4:{s:4:\"page\";s:11:\"product.php\";s:4:\"mode\";s:6:\"NONSSL\";s:3:\"get\";a:2:{s:5:\"cPath\";s:2:\"14\";s:8:\"language\";s:2:\"wa\";}s:4:\"post\";a:0:{}}}s:8:\"snapshot\";a:0:{}}wishList|O:8:\"wishlist\":1:{s:6:\"wishID\";a:2:{i:144;a:1:{i:0;s:3:\"144\";}i:73;a:1:{i:0;s:2:\"73\";}}}customer_id|s:2:\"19\";customer_default_address_id|s:2:\"19\";customer_first_name|s:5:\"Payal\";sppc_customer_group_id|s:1:\"0\";sppc_customer_group_show_tax|i:1;sppc_customer_group_tax_exempt|i:0;customer_country_id|s:2:\"13\";customer_zone_id|s:1:\"0\";'),('ef40c5f3689056cd2b69029ca8e7b634',1310846541,'cart|O:12:\"shoppingCart\":5:{s:8:\"contents\";a:0:{}s:5:\"total\";i:0;s:6:\"weight\";i:0;s:6:\"cartID\";N;s:12:\"content_type\";b:0;}language|s:31:\".././../images/img-530637851064\";languages_id|s:1:\"4\";currency|s:3:\"AUD\";navigation|O:17:\"navigationHistory\":2:{s:4:\"path\";a:3:{i:0;a:4:{s:4:\"page\";s:9:\"index.php\";s:4:\"mode\";s:6:\"NONSSL\";s:3:\"get\";a:0:{}s:4:\"post\";a:0:{}}i:1;a:4:{s:4:\"page\";s:11:\"catalog.php\";s:4:\"mode\";s:6:\"NONSSL\";s:3:\"get\";a:1:{s:6:\"osCsid\";s:32:\"ef40c5f3689056cd2b69029ca8e7b634\";}s:4:\"post\";a:0:{}}i:2;a:4:{s:4:\"page\";s:11:\"product.php\";s:4:\"mode\";s:6:\"NONSSL\";s:3:\"get\";a:2:{s:5:\"cPath\";s:2:\"14\";s:8:\"language\";s:2:\"wa\";}s:4:\"post\";a:0:{}}}s:8:\"snapshot\";a:4:{s:4:\"page\";s:11:\"catalog.php\";s:4:\"mode\";s:3:\"SSL\";s:3:\"get\";a:0:{}s:4:\"post\";a:0:{}}}wishList|O:8:\"wishlist\":1:{s:6:\"wishID\";N;}'),('f305cb09869c66fe546e67228bf2185b',1310836796,'language|s:7:\"english\";languages_id|s:1:\"1\";selected_box|s:13:\"configuration\";'),('f356edcc45ab9cd4cff695929ca681d4',1310820215,'cart|O:12:\"shoppingCart\":6:{s:8:\"contents\";a:3:{i:130;a:1:{s:3:\"qty\";s:1:\"1\";}i:107;a:1:{s:3:\"qty\";s:1:\"1\";}i:78;a:1:{s:3:\"qty\";s:1:\"1\";}}s:5:\"total\";i:0;s:6:\"weight\";i:0;s:6:\"cartID\";N;s:12:\"content_type\";b:0;s:5:\"cg_id\";i:0;}language|s:7:\"english\";languages_id|s:1:\"1\";currency|s:3:\"AUD\";navigation|O:17:\"navigationHistory\":2:{s:4:\"path\";a:3:{i:0;a:4:{s:4:\"page\";s:9:\"index.php\";s:4:\"mode\";s:6:\"NONSSL\";s:3:\"get\";a:0:{}s:4:\"post\";a:0:{}}i:1;a:4:{s:4:\"page\";s:9:\"login.php\";s:4:\"mode\";s:6:\"NONSSL\";s:3:\"get\";a:2:{s:6:\"action\";s:7:\"process\";s:6:\"osCsid\";s:32:\"f356edcc45ab9cd4cff695929ca681d4\";}s:4:\"post\";a:4:{s:13:\"email_address\";s:25:\"payal@astraljewels.com.au\";s:8:\"password\";s:8:\"password\";s:1:\"x\";s:2:\"46\";s:1:\"y\";s:2:\"16\";}}i:2;a:4:{s:4:\"page\";s:11:\"catalog.php\";s:4:\"mode\";s:6:\"NONSSL\";s:3:\"get\";a:0:{}s:4:\"post\";a:0:{}}}s:8:\"snapshot\";a:0:{}}wishList|O:8:\"wishlist\":1:{s:6:\"wishID\";a:2:{i:144;a:1:{i:0;s:3:\"144\";}i:73;a:1:{i:0;s:2:\"73\";}}}customer_id|s:2:\"19\";customer_default_address_id|s:2:\"19\";customer_first_name|s:5:\"Payal\";sppc_customer_group_id|s:1:\"0\";sppc_customer_group_show_tax|i:1;sppc_customer_group_tax_exempt|i:0;customer_country_id|s:2:\"13\";customer_zone_id|s:1:\"0\";'),('f3792d3dc751c264c7779d38ce4190aa',1310821381,'cart|O:12:\"shoppingCart\":6:{s:8:\"contents\";a:3:{i:130;a:1:{s:3:\"qty\";s:1:\"1\";}i:107;a:1:{s:3:\"qty\";s:1:\"1\";}i:78;a:1:{s:3:\"qty\";s:1:\"1\";}}s:5:\"total\";i:0;s:6:\"weight\";i:0;s:6:\"cartID\";N;s:12:\"content_type\";b:0;s:5:\"cg_id\";i:0;}language|s:31:\".././../images/img-530637851064\";languages_id|s:1:\"4\";currency|s:3:\"AUD\";navigation|O:17:\"navigationHistory\":2:{s:4:\"path\";a:4:{i:0;a:4:{s:4:\"page\";s:9:\"index.php\";s:4:\"mode\";s:6:\"NONSSL\";s:3:\"get\";a:0:{}s:4:\"post\";a:0:{}}i:1;a:4:{s:4:\"page\";s:9:\"login.php\";s:4:\"mode\";s:6:\"NONSSL\";s:3:\"get\";a:2:{s:6:\"action\";s:7:\"process\";s:6:\"osCsid\";s:32:\"f3792d3dc751c264c7779d38ce4190aa\";}s:4:\"post\";a:4:{s:13:\"email_address\";s:25:\"payal@astraljewels.com.au\";s:8:\"password\";s:8:\"password\";s:1:\"x\";s:2:\"35\";s:1:\"y\";s:1:\"8\";}}i:2;a:4:{s:4:\"page\";s:11:\"catalog.php\";s:4:\"mode\";s:6:\"NONSSL\";s:3:\"get\";a:0:{}s:4:\"post\";a:0:{}}i:3;a:4:{s:4:\"page\";s:11:\"product.php\";s:4:\"mode\";s:6:\"NONSSL\";s:3:\"get\";a:2:{s:5:\"cPath\";s:2:\"14\";s:8:\"language\";s:2:\"wa\";}s:4:\"post\";a:0:{}}}s:8:\"snapshot\";a:0:{}}wishList|O:8:\"wishlist\":1:{s:6:\"wishID\";a:2:{i:144;a:1:{i:0;s:3:\"144\";}i:73;a:1:{i:0;s:2:\"73\";}}}customer_id|s:2:\"19\";customer_default_address_id|s:2:\"19\";customer_first_name|s:5:\"Payal\";sppc_customer_group_id|s:1:\"0\";sppc_customer_group_show_tax|i:1;sppc_customer_group_tax_exempt|i:0;customer_country_id|s:2:\"13\";customer_zone_id|s:1:\"0\";'),('f598ff27956b73af8b9a83f43ff660bd',1310830038,'language|s:7:\"english\";languages_id|s:1:\"1\";selected_box|s:13:\"configuration\";'),('fa8ccf1f926cf5e6eb86b3b94c8f9f3b',1310836772,'language|s:7:\"english\";languages_id|s:1:\"1\";selected_box|s:13:\"configuration\";'),('fbe2577a10a78281c6ea57460df7ffb2',1310836770,'language|s:7:\"english\";languages_id|s:1:\"1\";selected_box|s:13:\"configuration\";'),('fd31b25d664806a930760888b6c343ba',1310836793,'language|s:7:\"english\";languages_id|s:1:\"1\";selected_box|s:13:\"configuration\";');
/*!40000 ALTER TABLE `sessions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sf_guard_group`
--

DROP TABLE IF EXISTS `sf_guard_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sf_guard_group` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `description` text,
  PRIMARY KEY (`id`),
  UNIQUE KEY `sf_guard_group_U_1` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sf_guard_group`
--

LOCK TABLES `sf_guard_group` WRITE;
/*!40000 ALTER TABLE `sf_guard_group` DISABLE KEYS */;
/*!40000 ALTER TABLE `sf_guard_group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sf_guard_group_permission`
--

DROP TABLE IF EXISTS `sf_guard_group_permission`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sf_guard_group_permission` (
  `group_id` int(11) NOT NULL,
  `permission_id` int(11) NOT NULL,
  PRIMARY KEY (`group_id`,`permission_id`),
  KEY `sf_guard_group_permission_FI_2` (`permission_id`),
  CONSTRAINT `sf_guard_group_permission_FK_1` FOREIGN KEY (`group_id`) REFERENCES `sf_guard_group` (`id`) ON DELETE CASCADE,
  CONSTRAINT `sf_guard_group_permission_FK_2` FOREIGN KEY (`permission_id`) REFERENCES `sf_guard_permission` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sf_guard_group_permission`
--

LOCK TABLES `sf_guard_group_permission` WRITE;
/*!40000 ALTER TABLE `sf_guard_group_permission` DISABLE KEYS */;
/*!40000 ALTER TABLE `sf_guard_group_permission` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sf_guard_permission`
--

DROP TABLE IF EXISTS `sf_guard_permission`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sf_guard_permission` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `description` text,
  PRIMARY KEY (`id`),
  UNIQUE KEY `sf_guard_permission_U_1` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sf_guard_permission`
--

LOCK TABLES `sf_guard_permission` WRITE;
/*!40000 ALTER TABLE `sf_guard_permission` DISABLE KEYS */;
/*!40000 ALTER TABLE `sf_guard_permission` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sf_guard_remember_key`
--

DROP TABLE IF EXISTS `sf_guard_remember_key`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sf_guard_remember_key` (
  `user_id` int(11) NOT NULL,
  `remember_key` varchar(32) DEFAULT NULL,
  `ip_address` varchar(50) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  PRIMARY KEY (`user_id`,`ip_address`),
  CONSTRAINT `sf_guard_remember_key_FK_1` FOREIGN KEY (`user_id`) REFERENCES `sf_guard_user` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sf_guard_remember_key`
--

LOCK TABLES `sf_guard_remember_key` WRITE;
/*!40000 ALTER TABLE `sf_guard_remember_key` DISABLE KEYS */;
INSERT INTO `sf_guard_remember_key` VALUES (1,'5522190a5066db81b2435b072a2edc6f','88.202.218.90','2009-09-08 15:40:21');
/*!40000 ALTER TABLE `sf_guard_remember_key` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sf_guard_user`
--

DROP TABLE IF EXISTS `sf_guard_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sf_guard_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(128) NOT NULL,
  `algorithm` varchar(128) NOT NULL DEFAULT 'sha1',
  `salt` varchar(128) NOT NULL,
  `password` varchar(128) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `last_login` datetime DEFAULT NULL,
  `is_active` tinyint(4) NOT NULL DEFAULT '1',
  `is_super_admin` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `sf_guard_user_U_1` (`username`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sf_guard_user`
--

LOCK TABLES `sf_guard_user` WRITE;
/*!40000 ALTER TABLE `sf_guard_user` DISABLE KEYS */;
INSERT INTO `sf_guard_user` VALUES (1,'partyshop','sha1','f3abd16d96f2fa1bdaae58b759927343','2b61001b57b72f870764f69668fd75f2411d3b49','2009-06-17 17:41:52','2010-02-18 12:57:50',1,0);
/*!40000 ALTER TABLE `sf_guard_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sf_guard_user_group`
--

DROP TABLE IF EXISTS `sf_guard_user_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sf_guard_user_group` (
  `user_id` int(11) NOT NULL,
  `group_id` int(11) NOT NULL,
  PRIMARY KEY (`user_id`,`group_id`),
  KEY `sf_guard_user_group_FI_2` (`group_id`),
  CONSTRAINT `sf_guard_user_group_FK_1` FOREIGN KEY (`user_id`) REFERENCES `sf_guard_user` (`id`) ON DELETE CASCADE,
  CONSTRAINT `sf_guard_user_group_FK_2` FOREIGN KEY (`group_id`) REFERENCES `sf_guard_group` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sf_guard_user_group`
--

LOCK TABLES `sf_guard_user_group` WRITE;
/*!40000 ALTER TABLE `sf_guard_user_group` DISABLE KEYS */;
/*!40000 ALTER TABLE `sf_guard_user_group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sf_guard_user_permission`
--

DROP TABLE IF EXISTS `sf_guard_user_permission`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sf_guard_user_permission` (
  `user_id` int(11) NOT NULL,
  `permission_id` int(11) NOT NULL,
  PRIMARY KEY (`user_id`,`permission_id`),
  KEY `sf_guard_user_permission_FI_2` (`permission_id`),
  CONSTRAINT `sf_guard_user_permission_FK_1` FOREIGN KEY (`user_id`) REFERENCES `sf_guard_user` (`id`) ON DELETE CASCADE,
  CONSTRAINT `sf_guard_user_permission_FK_2` FOREIGN KEY (`permission_id`) REFERENCES `sf_guard_permission` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sf_guard_user_permission`
--

LOCK TABLES `sf_guard_user_permission` WRITE;
/*!40000 ALTER TABLE `sf_guard_user_permission` DISABLE KEYS */;
/*!40000 ALTER TABLE `sf_guard_user_permission` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `specials`
--

DROP TABLE IF EXISTS `specials`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `specials` (
  `specials_id` int(11) NOT NULL AUTO_INCREMENT,
  `products_id` int(11) NOT NULL,
  `specials_new_products_price` decimal(15,4) NOT NULL,
  `specials_date_added` datetime DEFAULT NULL,
  `specials_last_modified` datetime DEFAULT NULL,
  `expires_date` datetime DEFAULT NULL,
  `date_status_change` datetime DEFAULT NULL,
  `status` int(1) NOT NULL DEFAULT '1',
  `customers_group_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`specials_id`),
  KEY `idx_specials_products_id` (`products_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `specials`
--

LOCK TABLES `specials` WRITE;
/*!40000 ALTER TABLE `specials` DISABLE KEYS */;
/*!40000 ALTER TABLE `specials` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `specials_retail_prices`
--

DROP TABLE IF EXISTS `specials_retail_prices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `specials_retail_prices` (
  `products_id` int(11) NOT NULL DEFAULT '0',
  `specials_new_products_price` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `status` tinyint(4) DEFAULT NULL,
  `customers_group_id` smallint(6) DEFAULT NULL,
  PRIMARY KEY (`products_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `specials_retail_prices`
--

LOCK TABLES `specials_retail_prices` WRITE;
/*!40000 ALTER TABLE `specials_retail_prices` DISABLE KEYS */;
/*!40000 ALTER TABLE `specials_retail_prices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tax_class`
--

DROP TABLE IF EXISTS `tax_class`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tax_class` (
  `tax_class_id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_class_title` varchar(32) NOT NULL,
  `tax_class_description` varchar(255) NOT NULL,
  `last_modified` datetime DEFAULT NULL,
  `date_added` datetime NOT NULL,
  PRIMARY KEY (`tax_class_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tax_class`
--

LOCK TABLES `tax_class` WRITE;
/*!40000 ALTER TABLE `tax_class` DISABLE KEYS */;
INSERT INTO `tax_class` VALUES (1,'Taxable Goods','The following types of products are included non-food, services, etc','2010-01-11 15:17:47','2010-01-11 15:17:47');
/*!40000 ALTER TABLE `tax_class` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tax_rates`
--

DROP TABLE IF EXISTS `tax_rates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tax_rates` (
  `tax_rates_id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_zone_id` int(11) NOT NULL,
  `tax_class_id` int(11) NOT NULL,
  `tax_priority` int(5) DEFAULT '1',
  `tax_rate` decimal(7,4) NOT NULL,
  `tax_description` varchar(255) NOT NULL,
  `last_modified` datetime DEFAULT NULL,
  `date_added` datetime NOT NULL,
  PRIMARY KEY (`tax_rates_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tax_rates`
--

LOCK TABLES `tax_rates` WRITE;
/*!40000 ALTER TABLE `tax_rates` DISABLE KEYS */;
INSERT INTO `tax_rates` VALUES (1,0,1,0,'10.0000','GST','2010-08-03 02:57:18','2010-06-30 06:49:48');
/*!40000 ALTER TABLE `tax_rates` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `whos_online`
--

DROP TABLE IF EXISTS `whos_online`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `whos_online` (
  `customer_id` int(11) DEFAULT NULL,
  `full_name` varchar(64) NOT NULL,
  `session_id` varchar(128) NOT NULL,
  `ip_address` varchar(15) NOT NULL,
  `time_entry` varchar(14) NOT NULL,
  `time_last_click` varchar(14) NOT NULL,
  `last_page_url` text NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `whos_online`
--

LOCK TABLES `whos_online` WRITE;
/*!40000 ALTER TABLE `whos_online` DISABLE KEYS */;
INSERT INTO `whos_online` VALUES (0,'Guest','0070d0b67cec6dd8407ce78e84443fc2','216.110.94.228','1310845431','1310845439','/catalog.php?osCsid=0070d0b67cec6dd8407ce78e84443fc2');
/*!40000 ALTER TABLE `whos_online` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `zones`
--

DROP TABLE IF EXISTS `zones`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `zones` (
  `zone_id` int(11) NOT NULL AUTO_INCREMENT,
  `zone_country_id` int(11) NOT NULL,
  `zone_code` varchar(32) NOT NULL,
  `zone_name` varchar(32) NOT NULL,
  PRIMARY KEY (`zone_id`),
  KEY `idx_zones_country_id` (`zone_country_id`)
) ENGINE=InnoDB AUTO_INCREMENT=182 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `zones`
--

LOCK TABLES `zones` WRITE;
/*!40000 ALTER TABLE `zones` DISABLE KEYS */;
INSERT INTO `zones` VALUES (1,223,'AL','Alabama'),(2,223,'AK','Alaska'),(3,223,'AS','American Samoa'),(4,223,'AZ','Arizona'),(5,223,'AR','Arkansas'),(6,223,'AF','Armed Forces Africa'),(7,223,'AA','Armed Forces Americas'),(8,223,'AC','Armed Forces Canada'),(9,223,'AE','Armed Forces Europe'),(10,223,'AM','Armed Forces Middle East'),(11,223,'AP','Armed Forces Pacific'),(12,223,'CA','California'),(13,223,'CO','Colorado'),(14,223,'CT','Connecticut'),(15,223,'DE','Delaware'),(16,223,'DC','District of Columbia'),(17,223,'FM','Federated States Of Micronesia'),(18,223,'FL','Florida'),(19,223,'GA','Georgia'),(20,223,'GU','Guam'),(21,223,'HI','Hawaii'),(22,223,'ID','Idaho'),(23,223,'IL','Illinois'),(24,223,'IN','Indiana'),(25,223,'IA','Iowa'),(26,223,'KS','Kansas'),(27,223,'KY','Kentucky'),(28,223,'LA','Louisiana'),(29,223,'ME','Maine'),(30,223,'MH','Marshall Islands'),(31,223,'MD','Maryland'),(32,223,'MA','Massachusetts'),(33,223,'MI','Michigan'),(34,223,'MN','Minnesota'),(35,223,'MS','Mississippi'),(36,223,'MO','Missouri'),(37,223,'MT','Montana'),(38,223,'NE','Nebraska'),(39,223,'NV','Nevada'),(40,223,'NH','New Hampshire'),(41,223,'NJ','New Jersey'),(42,223,'NM','New Mexico'),(43,223,'NY','New York'),(44,223,'NC','North Carolina'),(45,223,'ND','North Dakota'),(46,223,'MP','Northern Mariana Islands'),(47,223,'OH','Ohio'),(48,223,'OK','Oklahoma'),(49,223,'OR','Oregon'),(50,223,'PW','Palau'),(51,223,'PA','Pennsylvania'),(52,223,'PR','Puerto Rico'),(53,223,'RI','Rhode Island'),(54,223,'SC','South Carolina'),(55,223,'SD','South Dakota'),(56,223,'TN','Tennessee'),(57,223,'TX','Texas'),(58,223,'UT','Utah'),(59,223,'VT','Vermont'),(60,223,'VI','Virgin Islands'),(61,223,'VA','Virginia'),(62,223,'WA','Washington'),(63,223,'WV','West Virginia'),(64,223,'WI','Wisconsin'),(65,223,'WY','Wyoming'),(66,38,'AB','Alberta'),(67,38,'BC','British Columbia'),(68,38,'MB','Manitoba'),(69,38,'NF','Newfoundland'),(70,38,'NB','New Brunswick'),(71,38,'NS','Nova Scotia'),(72,38,'NT','Northwest Territories'),(73,38,'NU','Nunavut'),(74,38,'ON','Ontario'),(75,38,'PE','Prince Edward Island'),(76,38,'QC','Quebec'),(77,38,'SK','Saskatchewan'),(78,38,'YT','Yukon Territory'),(79,81,'NDS','Niedersachsen'),(80,81,'BAW','Baden-Württemberg'),(81,81,'BAY','Bayern'),(82,81,'BER','Berlin'),(83,81,'BRG','Brandenburg'),(84,81,'BRE','Bremen'),(85,81,'HAM','Hamburg'),(86,81,'HES','Hessen'),(87,81,'MEC','Mecklenburg-Vorpommern'),(88,81,'NRW','Nordrhein-Westfalen'),(89,81,'RHE','Rheinland-Pfalz'),(90,81,'SAR','Saarland'),(91,81,'SAS','Sachsen'),(92,81,'SAC','Sachsen-Anhalt'),(93,81,'SCN','Schleswig-Holstein'),(94,81,'THE','Thüringen'),(95,14,'WI','Wien'),(96,14,'NO','Niederösterreich'),(97,14,'OO','Oberösterreich'),(98,14,'SB','Salzburg'),(99,14,'KN','Kärnten'),(100,14,'ST','Steiermark'),(101,14,'TI','Tirol'),(102,14,'BL','Burgenland'),(103,14,'VB','Voralberg'),(104,204,'AG','Aargau'),(105,204,'AI','Appenzell Innerrhoden'),(106,204,'AR','Appenzell Ausserrhoden'),(107,204,'BE','Bern'),(108,204,'BL','Basel-Landschaft'),(109,204,'BS','Basel-Stadt'),(110,204,'FR','Freiburg'),(111,204,'GE','Genf'),(112,204,'GL','Glarus'),(113,204,'JU','Graubünden'),(114,204,'JU','Jura'),(115,204,'LU','Luzern'),(116,204,'NE','Neuenburg'),(117,204,'NW','Nidwalden'),(118,204,'OW','Obwalden'),(119,204,'SG','St. Gallen'),(120,204,'SH','Schaffhausen'),(121,204,'SO','Solothurn'),(122,204,'SZ','Schwyz'),(123,204,'TG','Thurgau'),(124,204,'TI','Tessin'),(125,204,'UR','Uri'),(126,204,'VD','Waadt'),(127,204,'VS','Wallis'),(128,204,'ZG','Zug'),(129,204,'ZH','Zürich'),(130,195,'A Coruña','A Coruña'),(131,195,'Alava','Alava'),(132,195,'Albacete','Albacete'),(133,195,'Alicante','Alicante'),(134,195,'Almeria','Almeria'),(135,195,'Asturias','Asturias'),(136,195,'Avila','Avila'),(137,195,'Badajoz','Badajoz'),(138,195,'Baleares','Baleares'),(139,195,'Barcelona','Barcelona'),(140,195,'Burgos','Burgos'),(141,195,'Caceres','Caceres'),(142,195,'Cadiz','Cadiz'),(143,195,'Cantabria','Cantabria'),(144,195,'Castellon','Castellon'),(145,195,'Ceuta','Ceuta'),(146,195,'Ciudad Real','Ciudad Real'),(147,195,'Cordoba','Cordoba'),(148,195,'Cuenca','Cuenca'),(149,195,'Girona','Girona'),(150,195,'Granada','Granada'),(151,195,'Guadalajara','Guadalajara'),(152,195,'Guipuzcoa','Guipuzcoa'),(153,195,'Huelva','Huelva'),(154,195,'Huesca','Huesca'),(155,195,'Jaen','Jaen'),(156,195,'La Rioja','La Rioja'),(157,195,'Las Palmas','Las Palmas'),(158,195,'Leon','Leon'),(159,195,'Lleida','Lleida'),(160,195,'Lugo','Lugo'),(161,195,'Madrid','Madrid'),(162,195,'Malaga','Malaga'),(163,195,'Melilla','Melilla'),(164,195,'Murcia','Murcia'),(165,195,'Navarra','Navarra'),(166,195,'Ourense','Ourense'),(167,195,'Palencia','Palencia'),(168,195,'Pontevedra','Pontevedra'),(169,195,'Salamanca','Salamanca'),(170,195,'Santa Cruz de Tenerife','Santa Cruz de Tenerife'),(171,195,'Segovia','Segovia'),(172,195,'Sevilla','Sevilla'),(173,195,'Soria','Soria'),(174,195,'Tarragona','Tarragona'),(175,195,'Teruel','Teruel'),(176,195,'Toledo','Toledo'),(177,195,'Valencia','Valencia'),(178,195,'Valladolid','Valladolid'),(179,195,'Vizcaya','Vizcaya'),(180,195,'Zamora','Zamora'),(181,195,'Zaragoza','Zaragoza');
/*!40000 ALTER TABLE `zones` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `zones_to_geo_zones`
--

DROP TABLE IF EXISTS `zones_to_geo_zones`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `zones_to_geo_zones` (
  `association_id` int(11) NOT NULL AUTO_INCREMENT,
  `zone_country_id` int(11) NOT NULL,
  `zone_id` int(11) DEFAULT NULL,
  `geo_zone_id` int(11) DEFAULT NULL,
  `last_modified` datetime DEFAULT NULL,
  `date_added` datetime NOT NULL,
  PRIMARY KEY (`association_id`),
  KEY `idx_zones_to_geo_zones_country_id` (`zone_country_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `zones_to_geo_zones`
--

LOCK TABLES `zones_to_geo_zones` WRITE;
/*!40000 ALTER TABLE `zones_to_geo_zones` DISABLE KEYS */;
/*!40000 ALTER TABLE `zones_to_geo_zones` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2011-07-16 14:46:26
