<?php 
class ControllerLocalisationStock5 extends Controller { 
	private $error = array();
   
  	public function index() {
		$this->language->load('localisation/stock5');
	
    	$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('localisation/stock');
		
    	$this->getList();
  	}
              
  	public function insert() {
		$this->language->load('localisation/stock5');
	
    	$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('localisation/stock');
			
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
      		$this->model_localisation_stock->addStock($this->request->post);
		  	
			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';
			
			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}
						
      		$this->redirect($this->url->link('localisation/stock5', 'token=' . $this->session->data['token'] . $url, 'SSL'));
		}
	
    	$this->getForm();
  	}

  	public function update() {
		$this->language->load('localisation/stock5');
	
    	$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('localisation/stock');
		$this->log->write("in update" . $this->request->server['REQUEST_METHOD']);
    	if (($this->request->server['REQUEST_METHOD'] == 'GET')  ) {
		$this->log->write("in model");
	  		$this->model_localisation_stock->editStock($this->request->get['stock_id'], $this->request->post);
			
			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';
			
			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}
			
			$this->redirect($this->url->link('localisation/stock5', 'token=' . $this->session->data['token'] . $url, 'SSL'));
    	}
	
    	$this->getList();
  	}

  	public function clearFilter() {
		$this->language->load('localisation/stock5');
	
    	$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('localisation/stock');
		
		$this->redirect($this->url->link('localisation/stock5', 'token=' . $this->session->data['token'] , 'SSL'));
  	}
  	public function delete() {
		$this->language->load('localisation/stock5');
	
    	$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('localisation/stock');
		
    	if (isset($this->request->post['selected']) && $this->validateDelete()) {
			foreach ($this->request->post['selected'] as $stock_id) {
				$this->model_localisation_stock->deleteStock($stock_id);
			}
			      		
			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';
			
			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}
			
			$this->redirect($this->url->link('localisation/stock5', 'token=' . $this->session->data['token'] . $url, 'SSL'));
   		}
	
    	$this->getList();
  	}
    
  	protected function getList() {
	
		if (isset($this->request->get['filter_DateOfIssue'])) {
			$filter_DateOfIssue = $this->request->get['filter_DateOfIssue'];
		} else {
			$filter_DateOfIssue = null;
		}
		if (isset($this->request->get['filter_Gemstone'])) {
			$filter_Gemstone = $this->request->get['filter_Gemstone'];
		} else {
			$filter_Gemstone = null;
		}
		
		
		if (isset($this->request->get['filter_Category'])) {
			$filter_Category = $this->request->get['filter_Category'];
		} else {
			$filter_Category = null;
		}
		if (isset($this->request->get['filter_Price'])) {
			$filter_Price = $this->request->get['filter_Price'];
		} else {
			$filter_Price = null;
		}
		if (isset($this->request->get['filter_SupplierCode'])) {
			$filter_SupplierCode = $this->request->get['filter_SupplierCode'];
		} else {
			$filter_SupplierCode = null;
		}
		if (isset($this->request->get['filter_ProductCode'])) {
			$filter_ProductCode = $this->request->get['filter_ProductCode'];
		} else {
			$filter_ProductCode = null;
		}
		if (isset($this->request->get['filter_status'])) {
			$filter_status = $this->request->get['filter_status'];
		} else {
			$filter_status = null;
		}
		if (isset($this->request->get['filter_UserId'])) {
			$filter_UserId = $this->request->get['filter_UserId'];
		} else {
			$filter_UserId = null;
		}
		if (isset($this->request->get['filter_DateSold'])) {
			$filter_DateSold = $this->request->get['filter_DateSold'];
		} else {
			$filter_DateSold = null;
		}
		if (isset($this->request->get['filter_GoldPlatingIssueDate'])) {
			$filter_GoldPlatingIssueDate = $this->request->get['filter_GoldPlatingIssueDate'];
		} else {
			$filter_GoldPlatingIssueDate = $this->model_localisation_stock->getLatestDate();;
		}
	
		
	
		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'Category';
		}
		
		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'ASC';
		}
		
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
				
		$url = '';
			
		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
		
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		
		if (isset($this->request->get['filter_DateSold'])) {
			$url .= '&filter_DateSold=' . $this->request->get['filter_DateSold'];
		}
		if (isset($this->request->get['filter_GoldPlatingIssueDate'])) {
			$url .= '&filter_GoldPlatingIssueDate=' . $this->request->get['filter_GoldPlatingIssueDate'];
		}
		
		
		if (isset($this->request->get['filter_DateOfIssue'])) {
			$url .= '&filter_DateOfIssue=' . $this->request->get['filter_DateOfIssue'];
		}
		if (isset($this->request->get['filter_Gemstone'])) {
			$url .= '&filter_Gemstone=' . $this->request->get['filter_Gemstone'];
		}
		if (isset($this->request->get['filter_Category'])) {
			$url .= '&filter_Category=' . $this->request->get['filter_Category'];
		}
		if (isset($this->request->get['filter_SupplierCode'])) {
			$url .= '&filter_SupplierCode=' . $this->request->get['filter_SupplierCode'];
		}
		if (isset($this->request->get['filter_status'])) {
			$url .= '&filter_status=' . $this->request->get['filter_status'];
		}
		if (isset($this->request->get['filter_ProductCode'])) {
			$url .= '&filter_ProductCode=' . $this->request->get['filter_ProductCode'];
		}
		if (isset($this->request->get['filter_UserId'])) {
			$url .= '&filter_UserId=' . $this->request->get['filter_UserId'];
		}
		if (isset($this->request->get['filter_Price'])) {
			$url .= '&filter_Price=' . $this->request->get['filter_Price'];
		}
		$this->data['button_filter'] = "Filter";

    	$this->data['Gemstones'] = $this->model_localisation_stock->getGemstones();
    	$this->data['Categorys'] = $this->model_localisation_stock->getCategorys();
    	$this->data['SupplierCodes'] = $this->model_localisation_stock->getSupplierCodes();
    	$this->data['ProductCodes'] = $this->model_localisation_stock->getProductCodes();
    	$this->data['UserIds'] = $this->model_localisation_stock->getUserIds();
    	$this->data['report'] = 2;
		$report=2;
  		$this->data['breadcrumbs'] = array();
/*
   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);
*/

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('localisation/stock5', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);
							
		$this->data['insert'] = $this->url->link('localisation/stock5/clearFilter', 'token=' . $this->session->data['token'] . $url, 'SSL');
		$this->data['delete'] = $this->url->link('localisation/stock5/delete', 'token=' . $this->session->data['token'] . $url, 'SSL');	

		$this->data['stockes'] = array();
		$this->data['token'] = $this->session->data['token'] ;
		$data = array(
			'filter_DateSold'              => $filter_DateSold,
			'filter_GoldPlatingIssueDate'              => $filter_GoldPlatingIssueDate,
			
			'filter_DateOfIssue'              => $filter_DateOfIssue,
			'filter_Gemstone'              => $filter_Gemstone,
			'filter_Category'              => $filter_Category,
			'filter_SupplierCode'              => $filter_SupplierCode,
			'filter_status'              => $filter_status,
			'filter_ProductCode'              => $filter_ProductCode,
			'filter_Price'              => $filter_Price,
			'filter_UserId'              => $filter_UserId,

			'sort'  => $sort,
			'order' => $order,
			'start' => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit' => $this->config->get('config_admin_limit')
		);
		
		$stock_total = $this->model_localisation_stock->getTotalStockes();
	
		$results = $this->model_localisation_stock->getStockes($data,$report);
 
    	foreach ($results as $result) {
			$action = array();
			
			$action[] = array(
				'text' => $this->language->get('text_edit'),
				'href' => $this->url->link('localisation/stock5/update', 'token=' . $this->session->data['token'] . '&stock_id=' . $result['stock_id'] . $url, 'SSL')
			);

	
			$this->data['stockes'][] = array(
				'stock_id' => $result['stock_id'],
				'DateOfIssue'            => $result['DateOfIssue']  ,
				'Gemstone'            => $result['Gemstone']  ,
				'Category'            => $result['Category']  ,
				'selected'            => 0  ,
				'update'            => $this->url->link('localisation/stock5/update', 'stock_id= '. $result['stock_id'] .'&token=' . $this->session->data['token'] . $url, 'SSL') ,				
				'Price'            => $result['Price']  ,
				'SupplierCode'            => $result['SupplierCode']  ,
				'DateSold'            => $result['DateSold']  ,
				'status'            => $result['status']  ,
				'UserId'            => $result['UserId']  ,
				'Descr'            => $result['Descr']  ,
				'OldPrice'            => $result['OldPrice']  ,
				'PlatingColour'            => $result['PlatingColour']  ,
				'SilverChainSize'            => $result['SilverChainSize']  ,
				'ProductCode'            => $result['ProductCode']  
			);
		}	
	
		$this->data['heading_title'] = $this->language->get('heading_title');

		$this->data['text_no_results'] = $this->language->get('text_no_results');
		$this->data['text_enabled']  =  'Sold';
		$this->data['text_disabled'] =   'Not Sold';

		$this->data['column_name'] = $this->language->get('column_name');
		$this->data['column_action'] = $this->language->get('column_action');		
		
		$this->data['button_insert'] = $this->language->get('button_insert');
		$this->data['button_delete'] = $this->language->get('button_delete');
 
 		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}
		
		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}

		$url = '';

		if ($order == 'ASC') {
			$url .= '&order=DESC';
		} else {
			$url .= '&order=ASC';
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		
		
		$this->data['filter_DateOfIssue'] = $filter_DateOfIssue;
		$this->data['filter_Gemstone'] = $filter_Gemstone;
		$this->data['filter_Category'] = $filter_Category;
		$this->data['filter_status'] = $filter_status;
		$this->data['filter_SupplierCode'] = $filter_SupplierCode;
		$this->data['filter_ProductCode'] = $filter_ProductCode;
		$this->data['filter_Price'] = $filter_Price;
		$this->data['filter_UserId'] = $filter_UserId;
		$this->data['filter_DateSold'] = $filter_DateSold;
		$this->data['filter_GoldPlatingIssueDate'] = $filter_GoldPlatingIssueDate;
		
		$this->data['sort_name'] = $this->url->link('localisation/stock5', 'token=' . $this->session->data['token'] . '&sort=gemstone' . $url, 'SSL');
		$this->data['sort_DateOfIssue'] = $this->url->link('localisation/stock5', 'token=' . $this->session->data['token'] . '&sort=DateOfIssue' . $url, 'SSL');
		$this->data['sort_Category'] = $this->url->link('localisation/stock5', 'token=' . $this->session->data['token'] . '&sort=Category' . $url, 'SSL');
		$this->data['sort_Price'] = $this->url->link('localisation/stock5', 'token=' . $this->session->data['token'] . '&sort=Price' . $url, 'SSL');
		$this->data['sort_SupplierCode'] = $this->url->link('localisation/stock5', 'token=' . $this->session->data['token'] . '&sort=SupplierCode' . $url, 'SSL');
		$this->data['sort_DateSold'] = $this->url->link('localisation/stock5', 'token=' . $this->session->data['token'] . '&sort=DateSold' . $url, 'SSL');
		$this->data['sort_ProductCode'] = $this->url->link('localisation/stock5', 'token=' . $this->session->data['token'] . '&sort=ProductCode' . $url, 'SSL');
		$this->data['sort_Status'] = $this->url->link('localisation/stock5', 'token=' . $this->session->data['token'] . '&sort=status' . $url, 'SSL');
		$this->data['sort_UserId'] = $this->url->link('localisation/stock5', 'token=' . $this->session->data['token'] . '&sort=UserId' . $url, 'SSL');

		$url = '';

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}
												
		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		$pagination = new Pagination();
		$pagination->total = $stock_total;
		$pagination->page = $page;
//		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->limit = 10000;
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('localisation/stock5', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');
			
		$this->data['pagination'] = $pagination->render();

		$this->data['sort'] = $sort;
		$this->data['order'] = $order;

		$this->template = 'localisation/stock5.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
  	}
  
  	public function updatePrice() {
		$this->language->load('localisation/stock4');
	
    	$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('localisation/stock');
    	if (($this->request->server['REQUEST_METHOD'] == 'GET')  ) {
	  		$this->model_localisation_stock->editStockNewPrice($this->request->get['stock_id'],  $this->request->get['NewPrice']);
			
			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';
			
			
			if (isset($this->request->get['filter_GoldPlatingIssueDate'])) {
				$url .= '&filter_GoldPlatingIssueDate=' . $this->request->get['filter_GoldPlatingIssueDate'];
			}
			
			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}
			
			$this->redirect($this->url->link('localisation/stock5', 'token=' . $this->session->data['token'] . $url, 'SSL'));			
    	}
	
    	$this->getList();
  	}

  	protected function getForm() {
     	$this->data['heading_title'] = $this->language->get('heading_title');

    	$this->data['entry_name'] = $this->language->get('entry_name');

    	$this->data['button_save'] = $this->language->get('button_save');
    	$this->data['button_cancel'] = $this->language->get('button_cancel');
    
 		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}

 		if (isset($this->error['name'])) {
			$this->data['error_name'] = $this->error['name'];
		} else {
			$this->data['error_name'] = array();
		}
		
		$url = '';
		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
		
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
      	 	'text'      => $this->language->get('text_home'),	
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('localisation/stock5', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);
				$this->session->data['redirect'] = $this->curPageURL();

		if (!isset($this->request->get['stock_id'])) {
			$this->data['action'] = $this->url->link('localisation/stock5/insert', 'token=' . $this->session->data['token'] . $url, 'SSL');
		} else {
			$this->data['action'] = $this->url->link('localisation/stock5/update', 'token=' . $this->session->data['token'] . '&stock_id=' . $this->request->get['stock_id'] . $url, 'SSL');
		}
			
		$this->data['cancel'] = $this->url->link('localisation/stock5', 'token=' . $this->session->data['token'] . $url, 'SSL');
		
		$this->load->model('localisation/language');
		
		$this->data['languages'] = $this->model_localisation_language->getLanguages();
		
		if (isset($this->request->post['stock'])) {
			$this->data['stock'] = $this->request->post['stock'];
		} elseif (isset($this->request->get['stock_id'])) {
			$this->data['stock'] = $this->model_localisation_stock->getStockDescriptions($this->request->get['stock_id']);
		} else {
			$this->data['stock'] = array();
		}

		$this->template = 'localisation/stock5_form1.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());	
  	}
  	
	protected function validateForm() {
	
    	if (!$this->user->hasPermission('modify', 'localisation/stock5')) {
      		$this->error['warning'] = $this->language->get('error_permission');
    	}
	
			  		return true;

  	}

  	protected function validateDelete() {
		if (!$this->user->hasPermission('modify', 'localisation/stock5')) {
      		$this->error['warning'] = $this->language->get('error_permission');
    	}
		
		$this->load->model('setting/store');
		$this->load->model('sale/order');
		
		foreach ($this->request->post['selected'] as $stock_id) {
    		if ($this->config->get('config_stock_id') == $stock_id) {
	  			$this->error['warning'] = $this->language->get('error_default');	
			}  
			
    		if ($this->config->get('config_download_status_id') == $stock_id) {
	  			$this->error['warning'] = $this->language->get('error_download');	
			}  
			
			$store_total = $this->model_setting_store->getTotalStoresByStockId($stock_id);

			if ($store_total) {
				$this->error['warning'] = sprintf($this->language->get('error_store'), $store_total);
			}
			
			$order_total = $this->model_sale_order->getTotalOrderHistoriesByStockId($stock_id);
		
			if ($order_total) {
	  			$this->error['warning'] = sprintf($this->language->get('error_order'), $order_total);	
			}  
	  	}
		
		if (!$this->error) { 
	  		return true;
		} else {
	  		return false;
		}
  	}	  
}
?>