<?php

/**
 * cardsave Debug Warning
 *
 * @author     Conor Kerr <cardsave@dev.ceon.net>
 * @copyright  Copyright 2008 Ceon
 * @link       http://dev.ceon.net/web/zen-cart/cardsave
 * @license    http://www.gnu.org/copyleft/gpl.html   GNU Public License V2.0
 * @version    $Id: class.cardsaveConfigCheck.php 734 2008-08-18 14:23:35Z conor $
 */

// {{{ class cardsaveConfigCheck

/**
 * Checks if the CardSave module is installed and in test/debug mode so that the user can be
 * alerted! Also checks if storage of details in the session is enabled but encryption is not
 * possible as the PEAR:Crypt_Blowfish package can't be accessed!
 *
 * @author     Conor Kerr <cardsave@dev.ceon.net>
 * @copyright  Copyright 2008 Ceon
 * @link       http://dev.ceon.net/web/zen-cart/cardsave
 * @license    http://www.gnu.org/copyleft/gpl.html   GNU Public License V2.0
 * @version    $Id: class.cardsaveConfigCheck.php 734 2008-08-18 14:23:35Z conor $
 */
class cardsaveConfigCheck extends base {
	
	function cardsaveConfigCheck()
	{
		global $messageStack;
		
		if ((defined('MODULE_PAYMENT_CARDSAVE_DEBUGGING_ENABLED') &&
				MODULE_PAYMENT_CARDSAVE_DEBUGGING_ENABLED == 'Yes') &&
				(defined('MODULE_PAYMENT_CARDSAVE_STATUS') &&
				MODULE_PAYMENT_CARDSAVE_STATUS == 'Yes')) {
			$messageStack->add('header', 'CARDSAVE IS IN DEBUG MODE', 'warning');
		} else if ((defined('MODULE_PAYMENT_CARDSAVE_TEST_MODE_ENABLED') &&
				MODULE_PAYMENT_CARDSAVE_TEST_MODE_ENABLED == 'Yes') &&
				(defined('MODULE_PAYMENT_CARDSAVE_STATUS') &&
				MODULE_PAYMENT_CARDSAVE_STATUS == 'Yes')) {
			$messageStack->add('header', 'CARDSAVE TEST MODE ENABLED', 'warning');
		}
		
		if (defined('MODULE_PAYMENT_CARDSAVE_DEBUGGING_ENABLED') &&
				MODULE_PAYMENT_CARDSAVE_STORE_DETAILS_IN_SESSION == 'Yes') {
			if (!file_exists_in_include_path('Crypt/Blowfish.php')) {
				$messageStack->add('header', 'CARDSAVE: Warning: You do NOT have PEAR:Crypt_Blowfish installed on your server!', 'warning');
			}
			
			if (!file_exists_in_include_path('PEAR.php')) {
				$messageStack->add('header', 'CARDSAVE: Warning: Your PHP installation does NOT have access to PEAR on your server!', 'warning');
			}
		}
	}
}

// }}}
 
?>