<?php

/**
 * cardsave Language Definitions
 *
 * @author     Conor Kerr <cardsave@dev.ceon.net>
 * @copyright  Copyright 2008 Ceon
 * @copyright  Portions Zen to OS-Commerce Conversion 22/03/2010 - David McCann, CardSave Online 
 * @link       http://dev.ceon.net/web/zen-cart/cardsave
 * @license    http://www.gnu.org/copyleft/gpl.html   GNU Public License V2.0
 * @version    $Id: cardsave.php 734 2008-08-18 14:23:35Z conor $
 */

// You should take a look at the following definitions and amend them as necessary ///////////////// 

/**
 * The following two definitions are used as the message to be shown the user whenever it has been
 * determined that their card requires 3D-Secure authentication and the module is set to use a
 * simple submission form rather than the full template.
 *
 * HTML is allowed if/as desired.
 */
define('MODULE_PAYMENT_CARDSAVE_TEXT_3D_SECURE_WHAT_NOW', 'What do I do now?');

define('MODULE_PAYMENT_CARDSAVE_TEXT_3D_SECURE_DISPLAYED_BELOW_1', 'Your Card Issuer\'s 3D-Secure Authorisation Page is displayed below. Please complete the form your Card Issuer presents you with so that your card can be securely authorised. Your order will then be created.');
define('MODULE_PAYMENT_CARDSAVE_TEXT_3D_SECURE_DISPLAYED_BELOW_2', 'If your card isn\'t registered for 3D-Secure your Card Issuer may include a link below to register your card now. Alternatively, they may even offer the facility to skip 3D-Secure authorisation at this time. If so, a means to do so will also be displayed below (not all Card Issuers offer this facility).');

define('MODULE_PAYMENT_CARDSAVE_TEXT_3D_SECURE_DISPLAYED_NEXT_1', 'Your Card Issuer\'s 3D-Secure Authorisation Page will be displayed on the next page. Please complete the form your Card Issuer presents you with so that your card can be securely authorised. Your order will then be created.');
define('MODULE_PAYMENT_CARDSAVE_TEXT_3D_SECURE_DISPLAYED_NEXT_2', 'If your card isn\'t registered for 3D-Secure your Card Issuer may include a link on the next page to register your card now. Alternatively, they may even offer the facility to skip 3D-Secure authorisation at this time. If so, a means to do so will also be displayed on the next page (not all Card Issuers offer this facility).');

define('MODULE_PAYMENT_CARDSAVE_TEXT_3D_SECURE_CLICK_TO_AUTHENTICATE', 'Please click the \'Continue\' button below to continue to your Card Issuer\'s 3D-Secure page...');

define('TITLE_CONTINUE_CHECKOUT_PROCEDURE', '<strong>Final Step</strong>');
define('TEXT_CONTINUE_CHECKOUT_PROCEDURE', '- continue to confirm your Card Details. Thank you!');

define('MODULE_PAYMENT_CARDSAVE_TEXT_3D_SECURE_COMPLETED_CONTINUE', 'Thank you! You have completed 3D-Secure Authorisation. Please click the \'Continue\' button below to complete your order...');

// HTML is allowed in the following message!
define('MODULE_PAYMENT_CARDSAVE_CUSTOM_SURCHARGES_DISCOUNTS_MESSAGE', '');


/**
 * Default (fall back) Definitions for information about card surcharges/discounts. The "SHORT"
 * version is added after the card's title in the Card Type selection gadget. The "LONG" version is
 * used as the title for the Order Total Summary Line in the ot_payment_surcharges_discounts Order
 * Total module.
 *
 * These are only used if no text was specified for a Card Type which is making use of the
 * surcharge/discount functionality.
 */
define('MODULE_PAYMENT_CARDSAVE_TEXT_DISCOUNT_SHORT', 'Discount');
define('MODULE_PAYMENT_CARDSAVE_TEXT_DISCOUNT_LONG', 'Card Discount');
define('MODULE_PAYMENT_CARDSAVE_TEXT_SURCHARGE_SHORT', 'Surcharge');
define('MODULE_PAYMENT_CARDSAVE_TEXT_SURCHARGE_LONG', 'Card Surcharge');


// The remaining definitions should rarely require changing but feel free if you like! /////////////

define('MODULE_PAYMENT_CARDSAVE_TEXT_CATALOG_TITLE', 'Credit/Debit Card (Secured By CardSave)');  // Payment option title as displayed to the customer
define('MODULE_PAYMENT_CARDSAVE_TEXT_CARDS_ACCEPTED', 'Cards Accepted: ');
define('MODULE_PAYMENT_CARDSAVE_TEXT_TEST_CASE', 'Test Case: ');
define('MODULE_PAYMENT_CARDSAVE_TEXT_SELECT_TEST_CASE', 'Don\'t use a quick test case, use card/address details entered.');
define('MODULE_PAYMENT_CARDSAVE_TEXT_CARD_TYPE', 'Card Type: ');
define('MODULE_PAYMENT_CARDSAVE_TEXT_SELECT_CARD_TYPE', 'Select Card Type');
define('MODULE_PAYMENT_CARDSAVE_TEXT_CARD_OWNER', 'Card Owner: ');
define('MODULE_PAYMENT_CARDSAVE_TEXT_CARD_NUMBER', 'Card Number: ');
define('MODULE_PAYMENT_CARDSAVE_TEXT_CARD_EXPIRES', 'Card Expiry Date: ');
//define('MODULE_PAYMENT_CARDSAVE_TEXT_CV2', 'CV2 Number (<a href="javascript:popupWindow(\'/popup_info?file=' . (FILENAME_POPUP_CVV_HELP) . '.html&amp;title=More+Info\')">' . 'More Info' . '</a>):');
define('MODULE_PAYMENT_CARDSAVE_TEXT_CV2', 'CV2 Number (<a href="javascript:popupWindow(\'' . tep_href_link(FILENAME_POPUP_CVV_HELP) . '\')">' . 'More Info' . '</a>): ');
define('MODULE_PAYMENT_CARDSAVE_TEXT_CARD_START_DATE', 'Card Start Date (If on card): ');
define('MODULE_PAYMENT_CARDSAVE_TEXT_CARD_ISSUE', 'Card Issue No. (If on card): ');

define('MODULE_PAYMENT_CARDSAVE_TEXT_JS_CARD_OWNER', '* The Card Owner\'s Name must be at least ' . CC_OWNER_MIN_LENGTH . ' characters.\n');
define('MODULE_PAYMENT_CARDSAVE_TEXT_JS_CARD_NUMBER', '* The Card Number must be at least ' . CC_NUMBER_MIN_LENGTH . ' characters.\n');
define('MODULE_PAYMENT_CARDSAVE_TEXT_JS_CARD_CV2', '* The 3 or 4 digit CV2 Number must be entered from the back of the Card.\n');
define('MODULE_PAYMENT_CARDSAVE_TEXT_JS_CARD_TYPE', '* You must select the Type of Credit/Debit Card you are using.\n');
define('MODULE_PAYMENT_CARDSAVE_TEXT_JS_CARD_EXPIRY', '* You must select the Expiry Date of the Card you are using.\n');
define('MODULE_PAYMENT_CARDSAVE_TEXT_JS_CARD_START', '* You have selected an invalid Start Date for the Card\n--> Please select a valid Start Date or Reset to \"Month\" \"Year\" if your card does not have a Start Date.\n');
define('MODULE_PAYMENT_CARDSAVE_TEXT_ERROR', 'Card Error!');

define('MODULE_PAYMENT_CARDSAVE_SELECT_MONTH', 'Month');
define('MODULE_PAYMENT_CARDSAVE_SELECT_YEAR', 'Year');

define('MODULE_PAYMENT_CARDSAVE_TEXT_VISA', 'Visa');
define('MODULE_PAYMENT_CARDSAVE_TEXT_MASTERCARD', 'MasterCard');
define('MODULE_PAYMENT_CARDSAVE_TEXT_VISA_DEBIT', 'Visa Debit');
define('MODULE_PAYMENT_CARDSAVE_TEXT_SOLO', 'Solo');
define('MODULE_PAYMENT_CARDSAVE_TEXT_MAESTRO', 'Maestro');
define('MODULE_PAYMENT_CARDSAVE_TEXT_VISA_ELECTRON', 'Visa Electron (UKE)');
define('MODULE_PAYMENT_CARDSAVE_TEXT_VISA_PURCHASING', 'Visa Purchasing');
define('MODULE_PAYMENT_CARDSAVE_TEXT_AMERICAN_EXPRESS', 'American Express');
define('MODULE_PAYMENT_CARDSAVE_TEXT_DINERS_CLUB', 'Diners Club');
define('MODULE_PAYMENT_CARDSAVE_TEXT_JCB', 'JCB');
define('MODULE_PAYMENT_CARDSAVE_TEXT_LASER', 'Laser');

define('MODULE_PAYMENT_CARDSAVE_TEXT_3D_SECURE_VERIFIED_BY_VISA', 'Verified By Visa');
define('MODULE_PAYMENT_CARDSAVE_TEXT_3D_SECURE_MASTERCARD_SECURECODE', 'MasterCard SecureCode');

define('MODULE_PAYMENT_CARDSAVE_TEXT_SELECT_TEST_CASE_1', 'Use Test Case 1 (Authorisation Successful with no 3D Secure) - %s');
define('MODULE_PAYMENT_CARDSAVE_TEXT_SELECT_TEST_CASE_2', 'Use Test Case 2 (Authorisation Declined with no 3D Secure) - %s');
define('MODULE_PAYMENT_CARDSAVE_TEXT_SELECT_TEST_CASE_3', 'Use Test Case 3 (Authorisation Referred with no 3D Secure) - %s');
define('MODULE_PAYMENT_CARDSAVE_TEXT_SELECT_TEST_CASE_4', 'Use Test Case 4 (Authorisation Successful with 3D Secure) - %s');
define('MODULE_PAYMENT_CARDSAVE_TEXT_SELECT_TEST_CASE_5', 'Use Test Case 5 (Authorisation Declined with 3D Secure) - %s');
define('MODULE_PAYMENT_CARDSAVE_TEXT_SELECT_TEST_CASE_6', 'Use Test Case 6 (Authorisation Referred with 3D Secure) - %s');

// The following messages can include HTML. (Unformatted text isn't always appropriate as it can't
// always convey the necessary information as easily as formatted text).
define('MODULE_PAYMENT_CARDSAVE_TEST_MODE_MESSAGE', 'The CardSave module is running in test mode. Instead of entering card details and entering/selecting an appropriate address, a quick test case can be chosen from the following list. This is the quickest and easiest way to test this module as the card and address details for the selected quick test case will be used instead of any details entered in the form.');

define('MODULE_PAYMENT_CARDSAVE_TEXT_TRANSACTION_PROBLEM', 'Sorry but a technical problem has occurred when attempting to contact the Payment Gateway. Please contact us immediately so that we can get this resolved for you. Thank you!');

define('MODULE_PAYMENT_CARDSAVE_TEXT_CARD_TYPE_DOES_NOT_MATCH', 'The Card Type selected doesn&rsquo;t match the Card Number you have entered! Our systems have identified the card number entered as belonging to a %s card. Please correct any details below and try again, try another card or contact us for further assistance.');
define('MODULE_PAYMENT_CARDSAVE_TEXT_ERROR_MESSAGE', 'Unable to continue! A problem has occurred with our systems. Please contact us immediately for assistance. (%s)');
define('MODULE_PAYMENT_CARDSAVE_TEXT_UNSUPPORTED_CURRENCY_CODE', 'Currency %s Not Supported! A problem has occurred with our systems. Please contact us immediately for assistance.');
define('MODULE_PAYMENT_CARDSAVE_TEXT_DECLINED_MESSAGE', 'Your card could not be authorised! Please correct any details below and try again, try another card or contact us for further assistance.(%s)');

define('MODULE_PAYMENT_CARDSAVE_TEXT_PREVIOUS_TRANSACTION_PASSED', 'Transaction already completed! Our records indicate that this transaction has already been completed. If this is not the case, please contact us for further assistance.(%s) (%s)');
define('MODULE_PAYMENT_CARDSAVE_TEXT_PREVIOUS_TRANSACTION_FAILED', 'Transaction previously failed! Our records indicate that this transaction has already been attempted and that it had failed. Please try again, otherwise please try another card. If you are still having difficulties please contact us for further assistance.(%s) (%s)');
define('MODULE_PAYMENT_CARDSAVE_TEXT_3D_SECURE_DECLINED_MESSAGE', 'Your card could not be authorised! Did you enter the correct 3D-Secure password? If not, please try again, otherwise please try another card. If you are still having difficulties please contact us for further assistance.(%s)');

define('MODULE_PAYMENT_CARDSAVE_TEXT_CARD_TYPE_ERROR', 'You must select the type of credit/debit card you are using.');
define('MODULE_PAYMENT_CARDSAVE_TEXT_CARD_NUMBER_ERROR', 'The card number entered is invalid. Please check the number and try again, try another card or contact us for further assistance.');
define('MODULE_PAYMENT_CARDSAVE_TEXT_CARD_EXPIRY_ERROR', 'The expiration date entered for the card is invalid. Please check the date and try again, try another card or contact us for further assistance.');
define('MODULE_PAYMENT_CARDSAVE_TEXT_CARD_EXPIRED_ERROR', 'Your card has expired! Please try another card or contact us for further assistance.');
define('MODULE_PAYMENT_CARDSAVE_TEXT_CARD_ISSUE_NUMBER_LENGTH_ERROR', 'The issue number is invalid! Please correct the number and try again, try another card or contact us for further assistance.');
define('MODULE_PAYMENT_CARDSAVE_TEXT_CARD_HOLDER_LENGTH_ERROR', 'The length of the card holder name is invalid! Please check the card holders name and try again, try another card or contact us for further assistance.');
define('MODULE_PAYMENT_CARDSAVE_TEXT_ADDRESS_ERROR', 'The billing address does not match the address registered for the card. Please make sure the first line of the address starts with the correct street number and that the postcode is correct and try again, try another card or contact us for further assistance.');
define('MODULE_PAYMENT_CARDSAVE_TEXT_ADDRESS_NUMERIC_ERROR', 'The billing address does not match the address registered for the card. Please make sure the first line of the address starts with the correct street number and try again, try another card or contact us for further assistance.');
define('MODULE_PAYMENT_CARDSAVE_TEXT_POSTCODE_ERROR', 'The postcode entered in the billing address does not match the postcode registered for the card. Please make sure the postcode is correct and try again, try another card or contact us for further assistance.');
define('MODULE_PAYMENT_CARDSAVE_TEXT_CV2_NUMBER_ERROR', 'The CV2 number entered is invalid. Please check the number and try again, try another card or contact us for further assistance.');
define('MODULE_PAYMENT_CARDSAVE_TEXT_CARD_START_ERROR', 'The start date entered for the card is invalid. Please check the date and try again, try another card or contact us for further assistance.');
define('MODULE_PAYMENT_CARDSAVE_TEXT_CARD_UNKNOWN_ERROR', 'The card number entered does not match any known card types. Please check the number entered. If it is correct, we do not accept that type of card. If it is wrong, please try again, try another card or contact us for further assistance.');


// Admin text definitions
define('MODULE_PAYMENT_CARDSAVE_TEXT_ADMIN_TITLE', 'CardSave v%s');
define('MODULE_PAYMENT_CARDSAVE_TEXT_DESCRIPTION_BASE', '<fieldset style="background: #fff; margin-bottom: 1.5em; color: #000;">
	<legend style="font-size: 1.2em; font-weight: bold">About CardSave</legend>
	<p style="margin: 0.4em 0 0.1em 0;">This module provides everything a osCommerce Cart shop owner needs to accept credit/debit card payments over the internet.</p>
</fieldset>

<fieldset style="background: #F7F6F0; margin-bottom: 1.5em"><legend style="font-size: 1.2em; font-weight: bold">MMS Link</legend><a target="_blank" href="https://mms.cardsaveonlinepayments.com/">Merchant Management System</a></fieldset>');

define('MODULE_PAYMENT_CARDSAVE_CROSS_REFERENCE', 'Cross Reference:');
define('MODULE_PAYMENT_CARDSAVE_AUTH_CODE', 'Auth Code:');
define('MODULE_PAYMENT_CARDSAVE_MESSAGE', 'Message:');
define('MODULE_PAYMENT_CARDSAVE_AMOUNT_RECEIVED', 'Amount Received:');
define('MODULE_PAYMENT_CARDSAVE_ADDRESS_NUMERIC_CHECK', 'Address Numeric Check:');
define('MODULE_PAYMENT_CARDSAVE_POSTCODE_CHECK', 'Postcode Check:');
define('MODULE_PAYMENT_CARDSAVE_CV2_CHECK', 'CV2 Check:');
define('MODULE_PAYMENT_CARDSAVE_3D_SECURE_CHECK', '3D-Secure Check:');
define('MODULE_PAYMENT_CARDSAVE_GATEWAY_ENTRY_POINTS', 'Gateway Entry Points:');

?>