<?php
class ControllerExtrasBlogSetting extends Controller { 
	private $error = array();

	public function index() {
		$this->load->language('extras/blog_setting');

		$this->document->setTitle($this->language->get('heading_title'));
		 
		$this->load->model('extras/blog_setting');
		
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
			
			$this->model_extras_blog_setting->editBlogSetting('blog_setting', $this->request->post);
			
			$this->session->data['success'] = $this->language->get('text_success');

			$this->redirect($this->url->link('extras/blog_setting', 'token=' . $this->session->data['token'], 'SSL'));
		}
	
		$this->data['heading_title'] = $this->language->get('heading_title');

		$this->data['tab_general'] = $this->language->get('tab_general');
		$this->data['tab_share'] = $this->language->get('tab_share');
		
		$this->data['text_default'] = $this->language->get('text_default');
		$this->data['text_yes'] = $this->language->get('text_yes');
		$this->data['text_no'] = $this->language->get('text_no');
		
		$this->data['entry_blog_per_page'] = $this->language->get('entry_blog_per_page');
		$this->data['entry_blog_comments_per_page'] = $this->language->get('entry_blog_comments_per_page');
		$this->data['entry_blog_list_image_dimension'] = $this->language->get('entry_blog_list_image_dimension');
		$this->data['entry_blog_list_short_description_max_chars'] = $this->language->get('entry_blog_list_short_description_max_chars');
		$this->data['entry_show_category_description'] = $this->language->get('entry_show_category_description');
		$this->data['entry_share_button_code'] = $this->language->get('entry_share_button_code');
		
		$this->data['column_status'] = $this->language->get('column_status');
		
		$this->data['button_save'] = $this->language->get('button_save');
		$this->data['button_cancel'] = $this->language->get('button_cancel');

		$this->data['token'] = $this->session->data['token'];

 		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}
		
		$url = '';
					
  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),     		
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('extras/blog_setting', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);
		
		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
							
		$this->data['action'] = $this->url->link('extras/blog_setting', 'token=' . $this->session->data['token'], 'SSL');
		
		$this->data['cancel'] = $this->url->link('extras/blog', 'token=' . $this->session->data['token'], 'SSL');
				
		if (isset($this->request->post['blog_setting_blog_per_page'])) {
			$this->data['blog_setting_blog_per_page'] = $this->request->post['blog_setting_blog_per_page'];
		} else {
			$this->data['blog_setting_blog_per_page'] = $this->config->get('blog_setting_blog_per_page');
		}
		
		if (isset($this->request->post['blog_setting_blog_comments_per_page'])) {
			$this->data['blog_setting_blog_comments_per_page'] = $this->request->post['blog_setting_blog_comments_per_page'];
		} else {
			$this->data['blog_setting_blog_comments_per_page'] = $this->config->get('blog_setting_blog_comments_per_page');
		}
		
		if (isset($this->request->post['blog_setting_blog_list_image_dimension_width'])) {
			$this->data['blog_setting_blog_list_image_dimension_width'] = $this->request->post['blog_setting_blog_list_image_dimension_width'];
		} else {
			$this->data['blog_setting_blog_list_image_dimension_width'] = $this->config->get('blog_setting_blog_list_image_dimension_width');
		}
		
		if (isset($this->request->post['blog_setting_blog_list_image_dimension_height'])) {
			$this->data['blog_setting_blog_list_image_dimension_height'] = $this->request->post['blog_setting_blog_list_image_dimension_height'];
		} else {
			$this->data['blog_setting_blog_list_image_dimension_height'] = $this->config->get('blog_setting_blog_list_image_dimension_height');
		}
		
		if (isset($this->request->post['blog_setting_blog_list_short_description_max_chars'])) {
			$this->data['blog_setting_blog_list_short_description_max_chars'] = $this->request->post['blog_setting_blog_list_short_description_max_chars'];
		} else {
			$this->data['blog_setting_blog_list_short_description_max_chars'] = $this->config->get('blog_setting_blog_list_short_description_max_chars');
		}
		
		if (isset($this->request->post['blog_setting_show_category_description'])) {
			$this->data['blog_setting_show_category_description'] = $this->request->post['blog_setting_show_category_description'];
		} else {
			$this->data['blog_setting_show_category_description'] = $this->config->get('blog_setting_show_category_description');
		}
		
		if (isset($this->request->post['blog_setting_share_button_code'])) {
			$this->data['blog_setting_share_button_code'] = $this->request->post['blog_setting_share_button_code'];
		} else {
			$this->data['blog_setting_share_button_code'] = $this->config->get('blog_setting_share_button_code');
		}
		
		$this->template = 'extras/blog_setting_form.tpl';
		$this->children = array(
			'common/header',	
			'common/footer'	
		);
		
		$this->response->setOutput($this->render()); 
	}

	private function validate() {
		if (!$this->user->hasPermission('modify', 'extras/blog_setting')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		if (!$this->error) {
			return TRUE;
		} else {
			if (!isset($this->error['warning'])) {
				$this->error['warning'] = $this->language->get('error_required_data');
			}
			return FALSE;
		}
	}

}
?>