<?php 
class ControllerSaleGemstone extends Controller {
	private $error = array();
 
	public function index() {
		$this->load->language('sale/gemstone');
 
		$this->document->setTitle($this->language->get('heading_title'));
 		
		$this->load->model('sale/gemstone');
		
		$this->getList();
	}

	public function insert() {
		$this->load->language('sale/gemstone');

		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('sale/gemstone');
		
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
			$this->model_sale_gemstone->addCustomerGroup($this->request->post);
			
			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}
			
			$this->redirect($this->url->link('sale/gemstone', 'token=' . $this->session->data['token'] . $url, 'SSL'));
		}

		$this->getForm();
	}

	public function update() {
		$this->load->language('sale/gemstone');

		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('sale/gemstone');
		
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
			$this->model_sale_gemstone->editCustomerGroup($this->request->get['shape_id'], $this->request->post);
			
			$this->session->data['success'] = $this->language->get('text_success');
			
			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}
			
			$this->redirect($this->url->link('sale/gemstone', 'token=' . $this->session->data['token'] . $url, 'SSL'));
		}

		$this->getForm();
	}

	public function delete() { 
		$this->load->language('sale/gemstone');

		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('sale/gemstone');
		
		if (isset($this->request->post['selected']) && $this->validateDelete()) {
      		foreach ($this->request->post['selected'] as $shape_id) {
				$this->model_sale_gemstone->deleteCustomerGroup($shape_id);	
			}
						
			$this->session->data['success'] = $this->language->get('text_success');
			
			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}
			
			$this->redirect($this->url->link('sale/gemstone', 'token=' . $this->session->data['token'] . $url, 'SSL'));
		}

		$this->getList();
	}

	private function getList() {
		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'shape';
		}
		 
		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'ASC';
		}
		
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
		
		$url = '';
		
		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}	
		
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
			
  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('sale/gemstone', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);
							
		$this->data['insert'] = $this->url->link('sale/gemstone/insert', 'token=' . $this->session->data['token'] . $url, 'SSL');
		$this->data['delete'] = $this->url->link('sale/gemstone/delete', 'token=' . $this->session->data['token'] . $url, 'SSL');	
	
		$this->data['gemstones'] = array();

		$data = array(
			'sort'  => $sort,
			'order' => $order,
			'start' => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit' => $this->config->get('config_admin_limit')
		);
		
		$gemstone_total = $this->model_sale_gemstone->getTotalCustomerGroups();
		
		$results = $this->model_sale_gemstone->getCustomerGroups($data);

		foreach ($results as $result) {
			$action = array();
			
			$action[] = array(
				'text' => $this->language->get('text_edit'),
				'href' => $this->url->link('sale/gemstone/update', 'token=' . $this->session->data['token'] . '&shape_id=' . $result['shape_id'] . $url, 'SSL')
			);		
		
			$this->data['gemstones'][] = array(
				'shape_id' => $result['shape_id'],
				'shape'              => $result['shape'] . (($result['shape_id'] == $this->config->get('config_shape_id')) ? $this->language->get('text_default') : null),
				'selected'          => isset($this->request->post['selected']) && in_array($result['shape_id'], $this->request->post['selected']),
				'enable'            => $result['enable'],
				'image'            => $result['image'],
				'shape1'            => $result['shape1'],
				'shape2'            => $result['shape2'],
				'action'            => $action
			);
		}	
	
		$this->data['heading_title'] = $this->language->get('heading_title');
		
		$this->data['text_no_results'] = $this->language->get('text_no_results');

		$this->data['column_name'] = $this->language->get('column_name');
		$this->data['column_action'] = $this->language->get('column_action');

		$this->data['button_insert'] = $this->language->get('button_insert');
		$this->data['button_delete'] = $this->language->get('button_delete');
 
 		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}
		
		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		
		$url = '';

		if ($order == 'ASC') {
			$url .= '&order=DESC';
		} else {
			$url .= '&order=ASC';
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$this->data['sort_shape'] = $this->url->link('sale/gemstone', 'token=' . $this->session->data['token'] . '&sort=shape' . $url, 'SSL');
		
		$url = '';

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}
												
		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
				
		$pagination = new Pagination();
		$pagination->total = $gemstone_total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('sale/gemstone', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');
		
		$this->data['pagination'] = $pagination->render();				

		$this->data['sort'] = $sort; 
		$this->data['order'] = $order;

		$this->template = 'sale/gemstone_list.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
 	}

	private function getForm() {
		$this->data['heading_title'] = $this->language->get('heading_title');
				$this->load->language('sale/metalmaster');
		 $this->data['token'] = $this->session->data['token'];

		$this->data['entry_name'] = $this->language->get('entry_name');
		$this->data['entry_description'] = $this->language->get('entry_description');
		
		$this->data['button_save'] = $this->language->get('button_save');
		$this->data['button_cancel'] = $this->language->get('button_cancel');

		$this->data['tab_general'] = $this->language->get('tab_general');

 		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}
		if (isset($this->error['image'])) {
			$this->data['error_image'] = $this->error['image'];
		} else {
			$this->data['error_image'] = '';
		}
				$this->data['text_image_manager'] = $this->language->get('text_image_manager');

 		if (isset($this->error['shape'])) {
			$this->data['error_shape'] = $this->error['shape'];
		} else {
			$this->data['error_shape'] = '';
		}
		
 		if (isset($this->error['description'])) {
			$this->data['error_description'] = $this->error['description'];
		} else {
			$this->data['error_description'] = '';
		}

		$url = '';
			
		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order']; 
		}
		
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		$this->load->model('tool/image');
  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('sale/gemstone', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);
			
		if (!isset($this->request->get['shape_id'])) {
			$this->data['action'] = $this->url->link('sale/gemstone/insert', 'token=' . $this->session->data['token'] . $url, 'SSL');
		} else {
			$this->data['action'] = $this->url->link('sale/gemstone/update', 'token=' . $this->session->data['token'] . '&shape_id=' . $this->request->get['shape_id'] . $url, 'SSL');
		}
		  
    	$this->data['cancel'] = $this->url->link('sale/gemstone', 'token=' . $this->session->data['token'] . $url, 'SSL');

		if (isset($this->request->get['shape_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
			$gemstone_info = $this->model_sale_gemstone->getCustomerGroup($this->request->get['shape_id']);
		}

		if (isset($this->request->post['image'])) {
			$this->data['thumb'] = $this->request->post['image'];
		} elseif (isset($gemstone_info) && $gemstone_info['image'] && file_exists(DIR_IMAGE . $gemstone_info['image'])) {
			$this->data['thumb'] = $this->model_tool_image->resize($gemstone_info['image'], 32, 32);
		} else {
			$this->data['thumb'] = $this->model_tool_image->resize('no_image.jpg', 32, 32);
		}
		if (isset($this->request->post['image1'])) {
			$this->data['thumb1'] = $this->request->post['image1'];
		} elseif (isset($gemstone_info) && $gemstone_info['image1'] && file_exists(DIR_IMAGE . $gemstone_info['image1'])) {
			$this->data['thumb1'] = $this->model_tool_image->resize($gemstone_info['image1'], 32, 32);
		} else {
			$this->data['thumb1'] = $this->model_tool_image->resize('no_image.jpg', 32, 32);
		}
		if (isset($this->request->post['image2'])) {
			$this->data['thumb2'] = $this->request->post['image2'];
		} elseif (isset($gemstone_info) && $gemstone_info['image2'] && file_exists(DIR_IMAGE . $gemstone_info['image2'])) {
			$this->data['thumb2'] = $this->model_tool_image->resize($gemstone_info['image2'], 32, 32);
		} else {
			$this->data['thumb2'] = $this->model_tool_image->resize('no_image.jpg', 32, 32);
		}
		
		if (isset($this->request->post['shape'])) {
			$this->data['shape'] = $this->request->post['shape'];
		} elseif (isset($gemstone_info)) {
			$this->data['shape'] = $gemstone_info['shape'];
		} else {
			$this->data['shape'] = '';
		}
		
		
		if (isset($this->request->post['image'])) {
			$this->data['image'] = $this->request->post['image'];
		} elseif (isset($gemstone_info)) {
			$this->data['image'] = $gemstone_info['image'];
		} else {
			$this->data['image'] = '';
		}
		
		if (isset($this->request->post['shape1'])) {
			$this->data['shape1'] = $this->request->post['shape1'];
		} elseif (isset($gemstone_info)) {
			$this->data['shape1'] = $gemstone_info['shape1'];
		} else {
			$this->data['shape1'] = '';
		}
		
		if (isset($this->request->post['shape2'])) {
			$this->data['shape2'] = $this->request->post['shape2'];
		} elseif (isset($gemstone_info)) {
			$this->data['shape2'] = $gemstone_info['shape2'];
		} else {
			$this->data['shape2'] = '';
		}
		
		if (isset($this->request->post['enable'])) {
			$this->data['enable'] = $this->request->post['enable'];
		} elseif (isset($gemstone_info)) {
			$this->data['enable'] = $gemstone_info['enable'];
		} else {
			$this->data['enable'] = '';
		}

		if (isset($this->request->post['description'])) {
			$this->data['description'] = $this->request->post['description'];
		} elseif (isset($gemstone_info)) {
			$this->data['description'] = $gemstone_info['description'];
		} else {
			$this->data['description'] = '';
		}
	
		$this->template = 'sale/gemstone_form.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());  
	}

	private function validateForm() {
		if (!$this->user->hasPermission('modify', 'sale/gemstone')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		if ((utf8_strlen($this->request->post['shape']) < 3) || (utf8_strlen($this->request->post['shape']) > 64)) {
			$this->error['shape'] = $this->language->get('error_shape');
		}

		if ((utf8_strlen($this->request->post['description']) < 3) || (utf8_strlen($this->request->post['description']) > 64)) {
			$this->error['description'] = $this->language->get('error_description');
		}
		if (!$this->request->post['image']) {
			$this->error['image'] = $this->language->get('error_image');
		}
		if (!$this->error) {
			return true;
		} else {
			return false;
		}


		if (!$this->error) {
			return true;
		} else {
			return false;
		}
	}

	private function validateDelete() {
		if (!$this->user->hasPermission('modify', 'sale/gemstone')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}
		
		$this->load->model('setting/store');
		$this->load->model('sale/customer');
      	
		foreach ($this->request->post['selected'] as $shape_id) {
    		if ($this->config->get('config_shape_id') == $shape_id) {
	  			$this->error['warning'] = $this->language->get('error_default');	
			}  
			
			$store_total = $this->model_setting_store->getTotalStoresByCustomerGroupId($shape_id);

			if ($store_total) {
				$this->error['warning'] = sprintf($this->language->get('error_store'), $store_total);
			}
			
			$customer_total = $this->model_sale_customer->getTotalCustomersByCustomerGroupId($shape_id);

			if ($customer_total) {
				$this->error['warning'] = sprintf($this->language->get('error_customer'), $customer_total);
			}
		}
		
		if (!$this->error) {
			return true;
		} else {
			return false;
		}
	}
}
?>