<?php
class ControllerSaleMetalmaster extends Controller {
	private $error = array();
 
	public function index() {
		$this->load->language('sale/metalmaster');
 
		$this->document->setTitle($this->language->get('heading_title'));
 		
		$this->load->model('sale/metalmaster');
		
		$this->getList();
	}

	public function insert() {
		$this->load->language('sale/metalmaster');

		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('sale/metalmaster');
		
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
			$this->model_sale_metalmaster->addCustomerGroup($this->request->post);
			
			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}
			
			$this->redirect($this->url->link('sale/metalmaster', 'token=' . $this->session->data['token'] . $url, 'SSL'));
		}

		$this->getForm();
	}

	public function update() {
		$this->load->language('sale/metalmaster');

		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('sale/metalmaster');
		
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
			$this->model_sale_metalmaster->editCustomerGroup($this->request->get['metal_id'], $this->request->post);
			
			$this->session->data['success'] = $this->language->get('text_success');
			
			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}
			
			$this->redirect($this->url->link('sale/metalmaster', 'token=' . $this->session->data['token'] . $url, 'SSL'));
		}

		$this->getForm();
	}

	public function delete() { 
		$this->load->language('sale/metalmaster');

		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('sale/metalmaster');
		
		if (isset($this->request->post['selected']) && $this->validateDelete()) {
      		foreach ($this->request->post['selected'] as $metal_id) {
				$this->model_sale_metalmaster->deleteCustomerGroup($metal_id);	
			}
						
			$this->session->data['success'] = $this->language->get('text_success');
			
			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}
			
			$this->redirect($this->url->link('sale/metalmaster', 'token=' . $this->session->data['token'] . $url, 'SSL'));
		}

		$this->getList();
	}

	private function getList() {
		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'metal_code';
		}
		 
		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'ASC';
		}
		
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
		
		$url = '';
		
		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}	
		
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
			
  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('sale/metalmaster', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);
							
		$this->data['insert'] = $this->url->link('sale/metalmaster/insert', 'token=' . $this->session->data['token'] . $url, 'SSL');
		$this->data['delete'] = $this->url->link('sale/metalmaster/delete', 'token=' . $this->session->data['token'] . $url, 'SSL');	
	
		$this->data['metalmasters'] = array();

		$data = array(
			'sort'  => $sort,
			'order' => $order,
			'start' => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit' => $this->config->get('config_admin_limit')
		);
		
		$metalmaster_total = $this->model_sale_metalmaster->getTotalCustomerGroups();
		
		$results = $this->model_sale_metalmaster->getCustomerGroups($data);

		foreach ($results as $result) {
			$action = array();
			
			$action[] = array(
				'text' => $this->language->get('text_edit'),
				'href' => $this->url->link('sale/metalmaster/update', 'token=' . $this->session->data['token'] . '&metal_id=' . $result['metal_id'] . $url, 'SSL')
			);		
		
			$this->data['metalmasters'][] = array(
				'metal_id' => $result['metal_id'],
				'metal_code'              => $result['metal_code'] . (($result['metal_id'] == $this->config->get('config_metal_id')) ? $this->language->get('text_default') : null),
				'pricepergram' => $result['pricepergram'],
				'priceperounce' => $result['priceperounce'],
				'selected'          => isset($this->request->post['selected']) && in_array($result['metal_id'], $this->request->post['selected']),
				'action'            => $action
			);
		}	
	
		$this->data['heading_title'] = $this->language->get('heading_title');
		
		$this->data['text_no_results'] = $this->language->get('text_no_results');

		$this->data['column_name'] = $this->language->get('column_name');
		$this->data['column_priceperounce'] = $this->language->get('column_priceperounce');
		$this->data['column_pricepergram'] = $this->language->get('column_pricepergram');
		$this->data['column_action'] = $this->language->get('column_action');

		$this->data['button_insert'] = $this->language->get('button_insert');
		$this->data['button_delete'] = $this->language->get('button_delete');
 
 		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}
		
		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		
		$url = '';

		if ($order == 'ASC') {
			$url .= '&order=DESC';
		} else {
			$url .= '&order=ASC';
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$this->data['sort_metal_code'] = $this->url->link('sale/metalmaster', 'token=' . $this->session->data['token'] . '&sort=metal_code' . $url, 'SSL');
		
		$url = '';

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}
												
		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
				
		$pagination = new Pagination();
		$pagination->total = $metalmaster_total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('sale/metalmaster', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');
		
		$this->data['pagination'] = $pagination->render();				

		$this->data['sort'] = $sort; 
		$this->data['order'] = $order;

		$this->template = 'sale/metalmaster_list.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
 	}

	private function getForm() {
		$this->data['heading_title'] = $this->language->get('heading_title');
		
		$this->data['entry_name'] = $this->language->get('entry_name');
		$this->data['entry_metalname'] = $this->language->get('entry_metalname');
		$this->data['entry_description'] = $this->language->get('entry_description');
		$this->data['entry_pricepergram'] = $this->language->get('entry_pricepergram');
		$this->data['entry_priceperounce'] = $this->language->get('entry_priceperounce');
		$this->data['entry_currency'] = $this->language->get('entry_currency');
		$this->data['entry_image'] = $this->language->get('entry_image');
		$this->data['text_browse'] = $this->language->get('text_browse');
		$this->data['text_clear'] = $this->language->get('text_clear');
		$this->data['text_image_manager'] = $this->language->get('text_image_manager');
		$this->data['button_save'] = $this->language->get('button_save');
		$this->data['button_cancel'] = $this->language->get('button_cancel');
		$this->data['entry_sort_order'] = $this->language->get('entry_sort_order');

		$this->data['tab_general'] = $this->language->get('tab_general');

 		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}
if (isset($this->error['image'])) {
			$this->data['error_image'] = $this->error['image'];
		} else {
			$this->data['error_image'] = '';
		}
		
 		if (isset($this->error['metal_code'])) {
			$this->data['error_metal_code'] = $this->error['metal_code'];
		} else {
			$this->data['error_metal_code'] = '';
		}
		
 		if (isset($this->error['metalname'])) {
			$this->data['error_metalname'] = $this->error['metalname'];
		} else {
			$this->data['error_metalname'] = '';
		}
		
 		if (isset($this->error['description'])) {
			$this->data['error_description'] = $this->error['description'];
		} else {
			$this->data['error_description'] = '';
		}
		
		
 		if (isset($this->error['silver_ratio'])) {
			$this->data['error_silver_ratio'] = $this->error['silver_ratio'];
		} else {
			$this->data['error_silver_ratio'] = '';
		}
		
 		if (isset($this->error['pricepergram'])) {
			$this->data['error_pricepergram'] = $this->error['pricepergram'];
		} else {
			$this->data['error_pricepergram'] = '';
		}
		
 		if (isset($this->error['priceperounce'])) {
			$this->data['error_priceperounce'] = $this->error['priceperounce'];
		} else {
			$this->data['error_priceperounce'] = '';
		}

		$url = '';
			
		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
		
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

  		$this->data['breadcrumbs'] = array();
		 $this->data['token'] = $this->session->data['token'];

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('sale/metalmaster', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);
			
		if (!isset($this->request->get['metal_id'])) {
			$this->data['action'] = $this->url->link('sale/metalmaster/insert', 'token=' . $this->session->data['token'] . $url, 'SSL');
		} else {
			$this->data['action'] = $this->url->link('sale/metalmaster/update', 'token=' . $this->session->data['token'] . '&metal_id=' . $this->request->get['metal_id'] . $url, 'SSL');
		}
		  
    	$this->data['cancel'] = $this->url->link('sale/metalmaster', 'token=' . $this->session->data['token'] . $url, 'SSL');
		$this->data['ExcelUpdate'] = $this->url->link('report/product_report2/updateMetalDetails', 'token=' . $this->session->data['token'] . '&metal_id=' . $this->request->get['metal_id'], 'SSL');

		if (isset($this->request->get['metal_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
			$metalmaster_info = $this->model_sale_metalmaster->getCustomerGroup($this->request->get['metal_id']);
		}

		if (isset($this->request->post['metal_code'])) {
			$this->data['metal_code'] = $this->request->post['metal_code'];
		} elseif (isset($metalmaster_info)) {
			$this->data['metal_code'] = $metalmaster_info['metal_code'];
		} else {
			$this->data['metal_code'] = '';
		}

		if (isset($this->request->post['sort_order'])) {
			$this->data['sort_order'] = $this->request->post['sort_order'];
		} elseif (isset($metalmaster_info)) {
			$this->data['sort_order'] = $metalmaster_info['sort_order'];
		} else {
			$this->data['sort_order'] = '';
		}

		if (isset($this->request->post['metalname'])) {
			$this->data['metalname'] = $this->request->post['metalname'];
		} elseif (isset($metalmaster_info)) {
			$this->data['metalname'] = $metalmaster_info['metalname'];
		} else {
			$this->data['metalname'] = '';
		}
		
		if (isset($this->request->post['silver_ratio'])) {
			$this->data['silver_ratio'] = $this->request->post['silver_ratio'];
		} elseif (!empty($metalmaster_info)) {
			$this->data['silver_ratio'] = $metalmaster_info['silver_ratio'];
		} else {
			$this->data['silver_ratio'] = '';
		}
		
		if (isset($this->request->post['image'])) {
			$this->data['image'] = $this->request->post['image'];
		} elseif (!empty($metalmaster_info)) {
			$this->data['image'] = $metalmaster_info['image'];
		} else {
			$this->data['image'] = '';
		}
		$this->load->model('tool/image');

		if (isset($metalmaster_info) && $metalmaster_info['image'] && file_exists(DIR_IMAGE . $metalmaster_info['image'])) {
			$this->data['thumb'] = $this->model_tool_image->resize($metalmaster_info['image'], 100, 100);
		} else {
			$this->data['thumb'] = $this->model_tool_image->resize('no_image.jpg', 100, 100);
		}
		
		$this->data['no_image'] = $this->model_tool_image->resize('no_image.jpg', 100, 100);
		
		if (isset($this->request->post['description'])) {
			$this->data['description'] = $this->request->post['description'];
		} elseif (isset($metalmaster_info)) {
			$this->data['description'] = $metalmaster_info['description'];
		} else {
			$this->data['description'] = '';
		}

		if (isset($this->request->post['pricepergram'])) {
			$this->data['pricepergram'] = $this->request->post['pricepergram'];
		} elseif (isset($metalmaster_info)) {
			$this->data['pricepergram'] = $metalmaster_info['pricepergram'];
		} else {
			$this->data['pricepergram'] = '';
		}

		if (isset($this->request->post['priceperounce'])) {
			$this->data['priceperounce'] = $this->request->post['priceperounce'];
		} elseif (isset($metalmaster_info)) {
			$this->data['priceperounce'] = $metalmaster_info['priceperounce'];
		} else {
			$this->data['priceperounce'] = '';
		}
		
		if ($this->config->get('config_currency_auto')) {
			$this->load->model('localisation/currency');
		
			$this->model_localisation_currency->updateCurrencies();
		}	

		if (isset($this->request->post['ccurrency'])) {
			$this->data['ccurrency'] = $this->request->post['ccurrency'];
		} elseif (isset($metalmaster_info)) {
			$this->data['ccurrency'] = $metalmaster_info['ccurrency'];
		} else {
			$this->data['ccurrency'] = '';
		}
		
		$this->load->model('localisation/currency');
		
		$this->data['currencies'] = $this->model_localisation_currency->getCurrencies();
	
		$this->template = 'sale/metalmaster_form.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render()); 
	}

	private function validateForm() {
		if (!$this->user->hasPermission('modify', 'sale/metalmaster')) {
			$this->error['warning'] = $this->language->get('error_permission');
		} 

		if ((utf8_strlen($this->request->post['metal_code']) < 1) || (utf8_strlen($this->request->post['metal_code']) > 64)) {
			$this->error['metal_code'] = $this->language->get('error_metal_code');
		}

		if ((utf8_strlen($this->request->post['metalname']) < 1) || (utf8_strlen($this->request->post['metalname']) > 64)) {
			$this->error['metalname'] = $this->language->get('error_metalname');
		}

		if ((utf8_strlen($this->request->post['description']) < 1) || (utf8_strlen($this->request->post['description']) > 64)) {
			$this->error['description'] = $this->language->get('error_description');
		}

		if ((utf8_strlen($this->request->post['priceperounce']) < 1) || (utf8_strlen($this->request->post['priceperounce']) > 64)) {
			$this->error['priceperounce'] = $this->language->get('error_priceperounce');
		}

		if ((utf8_strlen($this->request->post['pricepergram']) < 1) || (utf8_strlen($this->request->post['pricepergram']) > 64)) {
			$this->error['pricepergram'] = $this->language->get('error_pricepergram');
		}
if (!$this->request->post['image']) {
			$this->error['image'] = $this->language->get('error_image');
		}
		if (!$this->error) {
			return true;
		} else {
			return false;
		}
	}

	private function validateDelete() {
		if (!$this->user->hasPermission('modify', 'sale/metalmaster')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}
		
		$this->load->model('setting/store');
		$this->load->model('sale/customer');
      	
		foreach ($this->request->post['selected'] as $metal_id) {
    		if ($this->config->get('config_metal_id') == $metal_id) {
	  			$this->error['warning'] = $this->language->get('error_default');	
			}  
			
			$store_total = $this->model_setting_store->getTotalStoresByCustomerGroupId($metal_id);

			if ($store_total) {
				$this->error['warning'] = sprintf($this->language->get('error_store'), $store_total);
			}
			
			$customer_total = $this->model_sale_customer->getTotalCustomersByCustomerGroupId($metal_id);

			if ($customer_total) {
				$this->error['warning'] = sprintf($this->language->get('error_customer'), $customer_total);
			}
		}
		
		if (!$this->error) {
			return true;
		} else {
			return false;
		}
	}
}
?>