<?php
class ControllerTotalLoyal extends Controller {
	private $error = array();  
 
	public function index() {
		$this->load->language('total/loyal');

		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('catalog/loyal');
		
		$this->getList();
	}

	public function insert() {
		$this->load->language('total/loyal');

		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('catalog/loyal');
		
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
			$this->model_catalog_loyal->addloyal($this->request->post);
			
			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';
			
			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}
			
			$this->redirect($this->url->link('catalog/loyal', 'token=' . $this->session->data['token'] . $url, 'SSL'));
		}

		$this->getForm();
	}

	public function update() {
		$this->load->language('total/loyal');

		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('catalog/loyal');
		
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
			$this->model_catalog_loyal->editloyal($this->request->get['loyal_id'], $this->request->post);
			
			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';
			
			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}
			
			$this->redirect($this->url->link('catalog/loyal', 'token=' . $this->session->data['token'] . $url, 'SSL'));
		}

		$this->getForm();
	}

	public function delete() {
		$this->load->language('total/loyal');

		$this->document->setTitle($this->language->get('heading_title'));
 		
		$this->load->model('catalog/loyal');
		
		if (isset($this->request->post['selected']) && $this->validateDelete()) {
			foreach ($this->request->post['selected'] as $loyal_id) {
				$this->model_catalog_loyal->deleteloyal($loyal_id);
			}
			
			$this->session->data['success'] = $this->language->get('text_success');
			
			$url = '';
			
			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}
			
			$this->redirect($this->url->link('catalog/loyal', 'token=' . $this->session->data['token'] . $url, 'SSL'));
		}

		$this->getList();
	}

	private function getList() {
		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'od.name';
		}
		
		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'ASC';
		}
		
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
			
		$url = '';
			
		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
		
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('catalog/loyal', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);
		
		$this->data['insert'] = $this->url->link('catalog/loyal/insert', 'token=' . $this->session->data['token'] . $url, 'SSL');
		$this->data['delete'] = $this->url->link('catalog/loyal/delete', 'token=' . $this->session->data['token'] . $url, 'SSL');
		 
		$this->data['loyals'] = array();
		
		$data = array(
			'sort'  => $sort,
			'order' => $order,
			'start' => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit' => $this->config->get('config_admin_limit')
		);
		
		$loyal_total = $this->model_catalog_loyal->getTotalloyals();
		
		$results = $this->model_catalog_loyal->getloyals($data);
		
		foreach ($results as $result) {
			$action = array();
			
			$action[] = array(
				'text' => $this->language->get('text_edit'),
				'href' => $this->url->link('catalog/loyal/update', 'token=' . $this->session->data['token'] . '&loyal_id=' . $result['loyal_id'] . $url, 'SSL')
			);

			$this->data['loyals'][] = array(
				'loyal_id'  => $result['loyal_id'],
				'name'       => $result['name'],
				'sort_order' => $result['sort_order'],
				'selected'   => isset($this->request->post['selected']) && in_array($result['loyal_id'], $this->request->post['selected']),
				'action'     => $action
			);
		}

		$this->data['heading_title'] = $this->language->get('heading_title');
		
		$this->data['text_no_results'] = $this->language->get('text_no_results');
		
		$this->data['column_name'] = $this->language->get('column_name');
		$this->data['column_sort_order'] = $this->language->get('column_sort_order');
		$this->data['column_action'] = $this->language->get('column_action');	

		$this->data['button_insert'] = $this->language->get('button_insert');
		$this->data['button_delete'] = $this->language->get('button_delete');
 
 		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}
		
		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}

		$url = '';

		if ($order == 'ASC') {
			$url .= '&order=DESC';
		} else {
			$url .= '&order=ASC';
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		
		$this->data['sort_name'] = $this->url->link('catalog/loyal', 'token=' . $this->session->data['token'] . '&sort=od.name' . $url, 'SSL');
		$this->data['sort_sort_order'] = $this->url->link('catalog/loyal', 'token=' . $this->session->data['token'] . '&sort=o.sort_order' . $url, 'SSL');
		
		$url = '';

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}
												
		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		$pagination = new Pagination();
		$pagination->total = $loyal_total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('catalog/loyal', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');

		$this->data['pagination'] = $pagination->render();
		
		$this->data['sort'] = $sort;
		$this->data['order'] = $order;

		$this->template = 'catalog/loyal_list.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
	}

	private function getForm() {
		$this->data['heading_title'] = $this->language->get('heading_title');
		
		$this->data['text_choose'] = $this->language->get('text_choose');
		$this->data['text_select'] = $this->language->get('text_select');
		$this->data['text_radio'] = $this->language->get('text_radio');
		$this->data['text_checkbox'] = $this->language->get('text_checkbox');
		$this->data['text_image'] = $this->language->get('text_image');
		$this->data['text_input'] = $this->language->get('text_input');
		$this->data['text_text'] = $this->language->get('text_text');
		$this->data['text_textarea'] = $this->language->get('text_textarea');
		$this->data['text_file'] = $this->language->get('text_file');
		$this->data['text_date'] = $this->language->get('text_date');
		$this->data['text_datetime'] = $this->language->get('text_datetime');
		$this->data['text_time'] = $this->language->get('text_time');
		$this->data['text_image_manager'] = $this->language->get('text_image_manager');
		$this->data['text_browse'] = $this->language->get('text_browse');
		$this->data['text_clear'] = $this->language->get('text_clear');	
		
		$this->data['entry_name'] = $this->language->get('entry_name');
		$this->data['entry_type'] = $this->language->get('entry_type');
		$this->data['entry_value'] = $this->language->get('entry_value');
		$this->data['entry_image'] = $this->language->get('entry_image');
		$this->data['entry_sort_order'] = $this->language->get('entry_sort_order');

		$this->data['button_save'] = $this->language->get('button_save');
		$this->data['button_cancel'] = $this->language->get('button_cancel');
		$this->data['button_add_loyal_value'] = $this->language->get('button_add_loyal_value');
		$this->data['button_remove'] = $this->language->get('button_remove');

		$this->data['tab_general'] = $this->language->get('tab_general');

 		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}
		
 		if (isset($this->error['name'])) {
			$this->data['error_name'] = $this->error['name'];
		} else {
			$this->data['error_name'] = array();
		}	
				
 		if (isset($this->error['loyal_value'])) {
			$this->data['error_loyal_value'] = $this->error['loyal_value'];
		} else {
			$this->data['error_loyal_value'] = array();
		}	

		$url = '';

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
		
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('catalog/loyal', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);
		
		if (!isset($this->request->get['loyal_id'])) {
			$this->data['action'] = $this->url->link('catalog/loyal/insert', 'token=' . $this->session->data['token'] . $url, 'SSL');
		} else { 
			$this->data['action'] = $this->url->link('catalog/loyal/update', 'token=' . $this->session->data['token'] . '&loyal_id=' . $this->request->get['loyal_id'] . $url, 'SSL');
		}

		$this->data['cancel'] = $this->url->link('catalog/loyal', 'token=' . $this->session->data['token'] . $url, 'SSL');

		$this->data['token'] = $this->session->data['token'];

		if (isset($this->request->get['loyal_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
      		$loyal_info = $this->model_catalog_loyal->getloyal($this->request->get['loyal_id']);
    	}
		
		$this->load->model('localisation/language');
		
		$this->data['languages'] = $this->model_localisation_language->getLanguages();
		
		if (isset($this->request->post['loyal_description'])) {
			$this->data['loyal_description'] = $this->request->post['loyal_description'];
		} elseif (isset($this->request->get['loyal_id'])) {
			$this->data['loyal_description'] = $this->model_catalog_loyal->getloyalDescriptions($this->request->get['loyal_id']);
		} else {
			$this->data['loyal_description'] = array();
		}	

		if (isset($this->request->post['type'])) {
			$this->data['type'] = $this->request->post['type'];
		} elseif (!empty($loyal_info)) {
			$this->data['type'] = $loyal_info['type'];
		} else {
			$this->data['type'] = '';
		}
		
		if (isset($this->request->post['sort_order'])) {
			$this->data['sort_order'] = $this->request->post['sort_order'];
		} elseif (!empty($loyal_info)) {
			$this->data['sort_order'] = $loyal_info['sort_order'];
		} else {
			$this->data['sort_order'] = '';
		}
		
		if (isset($this->request->post['loyal_value'])) {
			$loyal_values = $this->request->post['loyal_value'];
		} elseif (isset($this->request->get['loyal_id'])) {
			$loyal_values = $this->model_catalog_loyal->getloyalValueDescriptions($this->request->get['loyal_id']);
		} else {
			$loyal_values = array();
		}
		
		$this->load->model('tool/image');
		
		$this->data['loyal_values'] = array();
		 
		foreach ($loyal_values as $loyal_value) {
			if ($loyal_value['image'] && file_exists(DIR_IMAGE . $loyal_value['image'])) {
				$image = $loyal_value['image'];
			} else {
				$image = 'no_image.jpg';
			}
			
			$this->data['loyal_values'][] = array(
				'loyal_value_id'          => $loyal_value['loyal_value_id'],
				'loyal_value_description' => $loyal_value['loyal_value_description'],
				'image'                    => $image,
				'thumb'                    => $this->model_tool_image->resize($image, 100, 100),
				'sort_order'               => $loyal_value['sort_order']
			);
		}

		$this->data['no_image'] = $this->model_tool_image->resize('no_image.jpg', 100, 100);

		$this->template = 'catalog/loyal_form.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
	}

	private function validateForm() {
		if (!$this->user->hasPermission('modify', 'catalog/loyal')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		foreach ($this->request->post['loyal_description'] as $language_id => $value) {
			if ((utf8_strlen($value['name']) < 1) || (utf8_strlen($value['name']) > 128)) {
				$this->error['name'][$language_id] = $this->language->get('error_name');
			}
		}

		if (($this->request->post['type'] == 'select' || $this->request->post['type'] == 'radio' || $this->request->post['type'] == 'checkbox') && !isset($this->request->post['loyal_value'])) {
			$this->error['warning'] = $this->language->get('error_type');
		}

		if (isset($this->request->post['loyal_value'])) {
			foreach ($this->request->post['loyal_value'] as $loyal_value_id => $loyal_value) {
				foreach ($loyal_value['loyal_value_description'] as $language_id => $loyal_value_description) {
					if ((utf8_strlen($loyal_value_description['name']) < 1) || (utf8_strlen($loyal_value_description['name']) > 128)) {
						$this->error['loyal_value'][$loyal_value_id][$language_id] = $this->language->get('error_loyal_value'); 
					}					
				}
			}	
		}

		if (!$this->error) {
			return true;
		} else {
			return false;
		}
	}

	private function validateDelete() {
		if (!$this->user->hasPermission('modify', 'catalog/loyal')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}
		
		$this->load->model('catalog/product');
		
		foreach ($this->request->post['selected'] as $loyal_id) {
			$product_total = $this->model_catalog_product->getTotalProductsByloyalId($loyal_id);

			if ($product_total) {
				$this->error['warning'] = sprintf($this->language->get('error_product'), $product_total);
			}
		}

		if (!$this->error) {
			return true;
		} else {
			return false;
		}
	}	
	
	public function autocomplete() {
		$json = array();
		
		if (isset($this->request->get['filter_name'])) {
			$this->load->language('total/loyal');
			
			$this->load->model('catalog/loyal');
			
			$this->load->model('tool/image');
			
			$data = array(
				'filter_name' => $this->request->get['filter_name'],
				'start'       => 0,
				'limit'       => 20
			);
			
			$loyals = $this->model_catalog_loyal->getloyals($data);
			
			foreach ($loyals as $loyal) {
				$loyal_value_data = array();
				
				if ($loyal['type'] == 'select' || $loyal['type'] == 'radio' || $loyal['type'] == 'checkbox' || $loyal['type'] == 'image') {
					$loyal_values = $this->model_catalog_loyal->getloyalValues($loyal['loyal_id']);
					
					foreach ($loyal_values as $loyal_value) {
						if ($loyal_value['image'] && file_exists(DIR_IMAGE . $loyal_value['image'])) {
							$image = $this->model_tool_image->resize($loyal_value['image'], 50, 50);
						} else {
							$image = '';
						}
													
						$loyal_value_data[] = array(
							'loyal_value_id' => $loyal_value['loyal_value_id'],
							'name'            => html_entity_decode($loyal_value['name'], ENT_QUOTES, 'UTF-8'),
							'image'           => $image					
						);
					}
					
					$sort_order = array();
				  
					foreach ($loyal_value_data as $key => $value) {
						$sort_order[$key] = $value['name'];
					}
			
					array_multisort($sort_order, SORT_ASC, $loyal_value_data);					
				}
				
				$type = '';
				
				if ($loyal['type'] == 'select' || $loyal['type'] == 'radio' || $loyal['type'] == 'checkbox' || $loyal['type'] == 'image') {
					$type = $this->language->get('text_choose');
				}
				
				if ($loyal['type'] == 'text' || $loyal['type'] == 'textarea') {
					$type = $this->language->get('text_input');
				}
				
				if ($loyal['type'] == 'file') {
					$type = $this->language->get('text_file');
				}
				
				if ($loyal['type'] == 'date' || $loyal['type'] == 'datetime' || $loyal['type'] == 'time') {
					$type = $this->language->get('text_date');
				}
												
				$json[] = array(
					'loyal_id'    => $loyal['loyal_id'],
					'name'         => html_entity_decode($loyal['name'], ENT_QUOTES, 'UTF-8'),
					'category'     => $type,
					'type'         => $loyal['type'],
					'loyal_value' => $loyal_value_data
				);
			}
		}

		$sort_order = array();
	  
		foreach ($json as $key => $value) {
			$sort_order[$key] = $value['name'];
		}

		array_multisort($sort_order, SORT_ASC, $json);
				
		$this->response->setOutput(json_encode($json));
	}
}
?>