<?php
class ControllerModuleBPFeatured extends Controller {
	protected function index($setting) {
		static $module = 0;
		
		$this->language->load('module/bp_featured');
		
		if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/stylesheet/bp_featured.css')) {
			$this->document->addStyle('catalog/view/theme/' .  $this->config->get('config_template') . '/stylesheet/bp_featured.css');
		} else {
			$this->document->addStyle('catalog/view/theme/default/stylesheet/bp_featured.css');
		}	
		
      	$this->data['heading_title'] = $this->language->get('heading_title');
		
		$this->load->model('blog/post'); 
		
		$this->load->model('tool/image');

		$this->data['posts'] = array();

		$posts = explode(',', $this->config->get('bp_featured_post'));		

		if (empty($setting['limit'])) {
			$setting['limit'] = 5;
		}
		
		$posts = array_slice($posts, 0, (int)$setting['limit']);
		
		foreach ($posts as $post_id) {
			$post_info = $this->model_blog_post->getPost($post_id);
			
			if ($post_info) {
				if ($post_info['image']) {
					$image = $this->model_tool_image->resize($post_info['image'], $setting['image_width'], $setting['image_height']);
				} else {
					$image = false;
				}
					
				$this->data['posts'][] = array(
					'post_id' 		    => $post_info['post_id'],
					'author_name'       => $post_info['author_name'],
					'thumb'   	 		=> $image,
					'name'    	 		=> $post_info['name'],
					'short_description' => utf8_substr(strip_tags(html_entity_decode($post_info['description'], ENT_QUOTES, 'UTF-8')), 0, 300) . '..',
					'views'    		    => sprintf($this->language->get('text_views'), (int)$post_info['viewed']),
					'reviews'    		=> sprintf($this->language->get('text_reviews'), (int)$post_info['reviews']),
					'href'    	 		=> $this->url->link('blog/post', 'post_id=' . $post_info['post_id']),
					'comments_href'    	=> $this->url->link('blog/post', 'post_id=' . $post_info['post_id'] . '&to_comments=1'),
					'author_href'       => $this->url->link('blog/search', '&filter_author_id=' . $post_info['author_id']),		
				);
			}
		}
		
		$this->data['module'] = $module++;

		if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/module/bp_featured.tpl')) {
			$this->template = $this->config->get('config_template') . '/template/module/bp_featured.tpl';
		} else {
			$this->template = 'default/template/module/bp_featured.tpl';
		}

		$this->render();
	}
}
?>