<?php   
class ControllerBlogHeader extends Controller {
	protected function index() {
		$this->data['title'] = $this->document->getTitle();
		
		if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/stylesheet/blog_stylesheet.css')) {
			$this->document->addStyle('catalog/view/theme/' . $this->config->get('config_template') . '/stylesheet/blog_stylesheet.css');
		} else {
			$this->document->addStyle('catalog/view/theme/default/stylesheet/blog_stylesheet.css');
		}
		
		if (isset($this->request->server['HTTPS']) && (($this->request->server['HTTPS'] == 'on') || ($this->request->server['HTTPS'] == '1'))) {
			$server = $this->config->get('config_ssl');
		} else {
			$server = $this->config->get('config_url');
		}
		
		$this->data['base'] = $server;
		$this->data['description'] = $this->document->getDescription();
		$this->data['keywords'] = $this->document->getKeywords();
		$this->data['links'] = $this->document->getLinks();	 
		$this->data['styles'] = $this->document->getStyles();
		$this->data['scripts'] = $this->document->getScripts();
		$this->data['lang'] = $this->language->get('code');
		$this->data['direction'] = $this->language->get('direction');
		$this->data['google_analytics'] = html_entity_decode($this->config->get('config_google_analytics'), ENT_QUOTES, 'UTF-8');
		$this->data['whos_amung_us'] = html_entity_decode($this->config->get('blog_whos_amung_us'), ENT_QUOTES, 'UTF-8');
				
		$this->language->load('blog/header');
		
				
		if ($this->config->get('blog_icon') && file_exists(DIR_IMAGE . $this->config->get('blog_icon'))) {
			$this->data['icon'] = HTTP_IMAGE1 . 'image/' . $this->config->get('blog_icon');
		} else {
			$this->data['icon'] = '';
		}
		
		$this->data['name'] = $this->config->get('blog_name');
				
		if ($this->config->get('blog_logo') && file_exists(DIR_IMAGE . $this->config->get('blog_logo'))) {
			$this->data['logo'] = HTTP_IMAGE1 . 'image/' . $this->config->get('blog_logo');
		} else {
			$this->data['logo'] = '';
		}
		
		$this->data['text_home']    = $this->language->get('text_home');
    	$this->data['text_search']  = $this->language->get('text_search');
		$this->data['text_account'] = $this->language->get('text_account');
		$this->data['text_rss']     = $this->language->get('text_rss');
		$this->data['text_back_store'] = $this->language->get('text_back_store');
    	
		$this->data['home'] = $this->url->link('blog/home');
		$this->data['account'] = $this->url->link('account/account', '', 'SSL');
		$this->data['rss']  = $this->url->link('blog/rss', '', 'SSL');
		
		if (isset($this->request->get['filter_name'])) {
			$this->data['filter_name'] = $this->request->get['filter_name'];
		} else {
			$this->data['filter_name'] = '';
		}
		
		// Menu
		$this->load->model('blog/category');
		
		$this->data['categories'] = array();
					
		$categories = $this->model_blog_category->getCategories(0);
		
		foreach ($categories as $category) {
			if ($category['top']) {
				$children_data = array();
				
				$children = $this->model_blog_category->getCategories($category['category_id']);
				
				foreach ($children as $child) {
					$data = array(
						'filter_category_id'  => $child['category_id'],
						'filter_sub_category' => true
					);
									
					$children_data[] = array(
						'name'  => $child['name'],
						'href'  => $this->url->link('blog/category', 'bpath=' . $category['category_id'] . '_' . $child['category_id'])	
					);						
				}
				
				// Level 1
				$this->data['categories'][] = array(
					'name'     => $category['name'],
					'children' => $children_data,
					'column'   => $category['column'] ? $category['column'] : 1,
					'href'     => $this->url->link('blog/category', 'bpath=' . $category['category_id'])
				);
			}
		}
		
		// start header banners 
		$this->load->model('design/banner');
		$this->load->model('tool/image');
				
		$this->data['bph_banners'] = array();
		
		if ($this->config->get('bp_header_banner_status') && $this->config->get('bp_header_banner_banner_id')) {
		
			$results = $this->model_design_banner->getBanner($this->config->get('bp_header_banner_banner_id'));
			  
			foreach ($results as $result) {
				if (file_exists(DIR_IMAGE . $result['image'])) {
					$this->data['bph_banners'][] = array(
						'title' => $result['title'],
						'link'  => $result['link'],
						'image' => $this->model_tool_image->resize($result['image'], 468, 60)
					);
				}
			}
		}

		$this->data['bph_image_width'] = 468;	
		$this->data['bph_image_height'] = 60;	
		// stop header banners
		
		$this->children = array(
			'module/blog_language'
		);
				
		if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/blog/header.tpl')) {
			$this->template = $this->config->get('config_template') . '/template/blog/header.tpl';
		} else {
			$this->template = 'default/template/blog/header.tpl';
		}
		
    	$this->render();
	} 	
}
?>