<?php  
class ControllerModuleBPCumulus extends Controller {
	protected function index($setting) {
		static $module = 0;
		
		$this->language->load('module/bp_cumulus');
		$this->load->model('blog/post');
		
		$this->data['heading_title'] = $this->language->get('heading_title');

		$tags = $this->model_blog_post->getCumulusTags();
		
		$tagcloud  = '<tags>';
		
		foreach($tags as $tag) {
			$tagcloud .= '<a href=\'' . $this->url->link('blog/search', 'filter_tag=' . $tag) . '\' title=\'' . $tag . '\' style=\'font-size: 13.25pt;\'>' . $tag . '</a>';
		}
		
		$tagcloud .= '</tags>';
		
		$this->data['tagcloud'] = urlencode($tagcloud);
		
		if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/flash/tagcloud.swf')) {
			$this->data['swf_path'] = HTTP_SERVER . 'catalog/view/theme/' . $this->config->get('config_template') . 'flash/tagcloud.swf'; 
		} else {
			$this->data['swf_path'] = HTTP_SERVER . 'catalog/view/theme/default/flash/tagcloud.swf'; 
		}
		
		$this->data['module'] = $module++;
		
		if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/module/bp_cumulus.tpl')) {
			$this->template = $this->config->get('config_template') . '/template/module/bp_cumulus.tpl';
		} else {
			$this->template = 'default/template/module/bp_cumulus.tpl';
		}
		
		$this->render();
	}
}
?>