<?php  
class ControllerModuleBPPostInfo extends Controller {
	protected function index($setting) {
		$this->language->load('module/bp_post_info');
		
		$this->load->model('blog/post');
		$this->load->model('blog/category');
		
		if (isset($this->request->get['post_id'])){
			
			$post_info = $this->model_blog_post->getPost($this->request->get['post_id']);
			$categories = $this->model_blog_category->getCategoriesByPostId($this->request->get['post_id']);
			
			$posted_in = array();
			
			if ($categories){
				foreach($categories as $category){
					$posted_in[] = sprintf($this->language->get('text_posted_categories'), $category['href'], $category['name']);
				}				
			}
			
			$this->data['posted_in_categories'] = implode(",", $posted_in);
			
			$this->data['heading_title'] = $this->language->get('heading_title');
			$this->data['text_posted_in']= $this->language->get('text_posted_in');
			$this->data['text_comments'] = sprintf($this->language->get('text_comments'), $post_info['reviews']);
			$this->data['text_views']    = sprintf($this->language->get('text_views'), $post_info['viewed']);
			$this->data['text_print']    = sprintf($this->language->get('text_print'), '');
			
			if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/module/bp_post_info.tpl')) {
				$this->template = $this->config->get('config_template') . '/template/module/bp_post_info.tpl';
			} else {
				$this->template = 'default/template/module/bp_post_info.tpl';
			}
			
			$this->render();
		}
	}
}
?>