<?php 
class ControllerAffiliateAccount extends Controller { 
	public function index() {
		if (!$this->affiliate->isLogged()) {
	  		$this->session->data['redirect'] = $this->url->link('affiliate/account', '', 'SSL');
	  
	  		$this->redirect($this->url->link('affiliate/login', '', 'SSL'));
    	} 
	 
		$this->language->load('affiliate/account');

      	$this->data['breadcrumbs'] = array();

      	$this->data['breadcrumbs'][] = array(
        	'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home'),
        	'separator' => false
      	); 

      	$this->data['breadcrumbs'][] = array(       	
        	'text'      => $this->language->get('text_account'),
			'href'      => $this->url->link('affiliate/account', '', 'SSL'),
        	'separator' => $this->language->get('text_separator')
      	);
		
		$this->load->model('affiliate/affiliate');
		
		$this->data['information_info'] = $this->model_affiliate_affiliate->getInformations();

		foreach ($this->model_affiliate_affiliate->getInformations() as $result)
		{
      		$this->data['informations'][] = array(
        		'title' => $result['title'],
	      		'href'  => $this->url->link('affiliate/information&affinformation_id='.$result['affinformation_id'])
      		);
    	}

		$this->document->setTitle($this->language->get('heading_title'));

    	$this->data['heading_title'] = $this->language->get('heading_title');

    	$this->data['text_my_account'] = $this->language->get('text_my_account');
    	$this->data['text_my_tracking'] = $this->language->get('text_my_tracking');
		$this->data['text_my_transactions'] = $this->language->get('text_my_transactions');
		$this->data['text_edit'] = $this->language->get('text_edit');
		$this->data['text_password'] = $this->language->get('text_password');
		$this->data['text_payment'] = $this->language->get('text_payment');
		$this->data['text_tracking'] = $this->language->get('text_tracking');
		$this->data['text_transaction'] = $this->language->get('text_transaction');
		$this->data['text_salesdetails'] = $this->language->get('text_salesdetails');
    	$this->data['text_Banners'] = $this->language->get('text_Banners');
    	$this->data['text_MyBanner'] = $this->language->get('text_MyBanner');
		$this->data['text_my_orders'] = $this->language->get('text_my_orders');
    	$this->data['text_Company_Info'] = $this->language->get('text_Company_Info');
		$this->data['text_Affiliate_Info'] = $this->language->get('text_Affiliate_Info');
    	$this->data['text_Logout'] = $this->language->get('text_Logout');
    	$this->data['text_LogOff'] = $this->language->get('text_LogOff');
		$this->data['text_customers'] = $this->language->get('text_customers');
		$this->data['text_customer'] = $this->language->get('text_customer');
		$this->data['customer'] = $this->url->link('affiliate/customer', '', 'SSL');

		
		if (isset($this->session->data['success'])) {
    		$this->data['success'] = $this->session->data['success'];
			
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}

    	$this->data['edit'] = $this->url->link('affiliate/edit', '', 'SSL');
		$this->data['password'] = $this->url->link('affiliate/password', '', 'SSL');
		$this->data['payment'] = $this->url->link('affiliate/payment', '', 'SSL');
		$this->data['tracking'] = $this->url->link('affiliate/tracking', '', 'SSL');
    	$this->data['transaction'] = $this->url->link('affiliate/transaction', '', 'SSL');
		$this->data['history'] =$this->url->link('affiliate/sales', '', 'SSL');
		$this->data['download'] =$this->url->link('affiliate/affdownload', '', 'SSL');
		$this->data['newsletter'] =$this->url->link('affiliate/affnewsletter', '', 'SSL');
		$this->data['banner'] =$this->url->link('affiliate/banners', '', 'SSL');
		$this->data['AboutAffiliate'] =$this->url->link('affiliate/about', '', 'SSL');
		$this->data['afflogout'] =$this->url->link('affiliate/logout', '', 'SSL');


		if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/affiliate/account.tpl')) {
			$this->template = $this->config->get('config_template') . '/template/affiliate/account.tpl';
		} else {
			$this->template = 'default/template/affiliate/account.tpl';
		}
		
		$this->children = array(
			'common/column_left',
			'common/column_right',
			'common/content_top',
			'common/content_bottom',
			'common/footer',
			'common/header'	
		);
				
		$this->response->setOutput($this->render());		
  	}
}
?>