<?php  
class ControllerCheckoutCart extends Controller {
	public function index() {
		$this->language->load('checkout/cart');
//		$this->log->write('cart in cart  controller before ' );


	
	if ($this->request->server['REQUEST_METHOD'] == 'POST' ) {

			
	
      		if (isset($this->request->post['quantity'])) {
				if (!is_array($this->request->post['quantity'])) {
					if (isset($this->request->post['option'])) {
						$option = $this->request->post['option'];
					} else {
						$option = array();	
					}
			
					$product_dtl = $this->model_catalog_product->getProductOptions_NEW($this->request->post['product_id']);
					$this->load->model('catalog/product');
					if (isset($this->request->post['product_id'])) {
					$prd_zeroprice = $this->model_catalog_product->getProductPrice($this->request->post['product_id']);
					if($prd_zeroprice<=0){
							$this->redirect($this->url->link('product/product', 'product_id=' . $this->request->post['product_id'] ) );
						}
					}
      				$this->cart->add($this->request->post['product_id'], $this->request->post['quantity'],$this->request->post['size'], $option);
				} else {
					foreach ($this->request->post['quantity'] as $key => $value) {
						 				
	      				$this->cart->update($key, $value);
					}
					
				}
				
				
      		}

			    if (isset($this->request->post['engravetxt'])) {

					foreach ($this->request->post['engravetxt'] as $key => $value) {
						$this->session->data[$key.'_engravetxt'] = $value;
					}
				}
			    if (isset($this->request->post['engravefont'])) {

					foreach ($this->request->post['engravefont'] as $key => $value) {
						$this->session->data[$key.'_engravefont'] = $value;
					}
				}

			    if (isset($this->request->post['country'])) {
					foreach ($this->request->post['country'] as $key => $value) {
						$this->session->data[$key.'_country'] = $value;
					}
				}

			    if (isset($this->request->post['ringsize'])) {

					foreach ($this->request->post['ringsize'] as $key => $value) {
						$this->session->data[$key.'_ringsize'] = $value;
					}
				}

      		if (isset($this->request->post['remove'])) {
	    		foreach ($this->request->post['remove'] as $key) {
          			$this->cart->remove($key);
				}
      		}
			
      		if (isset($this->request->post['voucher']) && $this->request->post['voucher']) {
	    		foreach ($this->request->post['voucher'] as $key) {
          			if (isset($this->session->data['vouchers'][$key])) {
						unset($this->session->data['vouchers'][$key]);
					}
				}
      		}
									
			if (isset($this->request->post['redirect'])) {
				$this->session->data['redirect'] = $this->request->post['redirect'];
			}	
			
			if (isset($this->request->post['quantity']) || isset($this->request->post['remove']) || isset($this->request->post['voucher'])) {
				unset($this->session->data['shipping_methods']);
				unset($this->session->data['shipping_method']);
				unset($this->session->data['payment_methods']);
				unset($this->session->data['payment_method']);	
				unset($this->session->data['reward']);	
				
//				$this->redirect($this->url->link('checkout/cart'));
			}
			
			//$this->redirect($this->url->link('onecheckout/checkout'));
    	}

    	$this->document->setTitle($this->language->get('heading_title'));

      	$this->data['breadcrumbs'] = array();

      	$this->data['breadcrumbs'][] = array(
        	'href'      => $this->url->link('common/home'),
        	'text'      => $this->language->get('text_home'),
        	'separator' => false
      	); 

      	$this->data['breadcrumbs'][] = array(
        	'href'      => $this->url->link('checkout/cart'),
        	'text'      => $this->language->get('heading_title'),
        	'separator' => $this->language->get('text_separator')
      	);
			
			
		if (isset($this->request->post['country'])) {
      		$this->data['country'] = $this->request->post['country'];
		} else {	
      		$this->data['country'] = '';
    	}

    	if (isset($this->request->post['ringsize'])) {
      		$this->data['ringsize'] = $this->request->post['ringsize']; 	
		} else {
      		$this->data['ringsize'] = '';
    	}
    	if (isset($this->request->post['engravetxt'])) {
      		$this->data['engravetxt'] = $this->request->post['engravetxt']; 	
		} else {
      		$this->data['engravetxt'] = '';
    	}
    	if (isset($this->request->post['engravefont'])) {
      		$this->data['engravefont'] = $this->request->post['engravefont']; 	
		} else {
      		$this->data['engravefont'] = 'default';
    	}
		
	$this->load->model('information/myown');
		
    	$this->data['countries'] = $this->model_information_myown->getCountries();
    	$this->data['ringsizes'] = $this->model_information_myown->getRingsizes();
		
		
    	if ($this->cart->hasProducts() || (isset($this->session->data['vouchers']) && $this->session->data['vouchers'])) {
      		$this->data['heading_title'] = $this->language->get('heading_title');
			
			$this->data['text_select'] = $this->language->get('text_select');
			$this->data['text_weight'] = $this->language->get('text_weight');
		
     		$this->data['column_remove'] = $this->language->get('column_remove');
      		$this->data['column_image'] = $this->language->get('column_image');
      		$this->data['column_name'] = $this->language->get('column_name');
      		$this->data['column_model'] = $this->language->get('column_model');
      		$this->data['column_quantity'] = $this->language->get('column_quantity');
			$this->data['column_price'] = $this->language->get('column_price');
      		$this->data['column_total'] = $this->language->get('column_total');
			
      		$this->data['button_update'] = $this->language->get('button_update');
      		$this->data['button_shopping'] = $this->language->get('button_shopping');
      		$this->data['button_checkout'] = $this->language->get('button_checkout');
			
			if ($this->config->get('config_customer_price') && !$this->customer->isLogged()) {
				$this->data['attention'] = sprintf($this->language->get('text_login'), $this->url->link('account/login'), $this->url->link('account/register'));
			} else {
				$this->data['attention'] = '';
			}
			
			if (!$this->cart->hasStock() && (!$this->config->get('config_stock_checkout') || $this->config->get('config_stock_warning'))) {
      			$this->data['error_warning'] = $this->language->get('error_stock');
			} elseif (isset($this->session->data['error'])) {
				$this->data['error_warning'] = $this->session->data['error'];
			
				unset($this->session->data['error']);			
			} else {
				$this->data['error_warning'] = '';
			}
			
			if (isset($this->session->data['success'])) {
				$this->data['success'] = $this->session->data['success'];
			
				unset($this->session->data['success']);
			} else {
				$this->data['success'] = '';
			}

			$this->data['action'] = $this->url->link('checkout/cart');
						
			if ($this->config->get('config_cart_weight')) {
				$this->data['weight'] = $this->weight->format($this->cart->getWeight(), $this->config->get('config_weight_class_id'), $this->language->get('decimal_point'), $this->language->get('thousand_point'));
			} else {
				$this->data['weight'] = false;
			}
						 
			$this->load->model('tool/image');
			$this->load->model('catalog/product');
      		$this->data['products'] = array();

			$products = $this->cart->getProducts();
			$ringSizeColumn=0;
			$blockCheckout=0;
			$this->data['blockCheckoutText']='';
      		foreach ($products as $product) {
				$this->log->write(' Parent product id :'.$product['parent_product_id'].' ; product id :'.$product['product_id']);
				$product_total = 0;
					
				foreach ($products as $product_2) {
					if ($product_2['product_id'] == $product['product_id']) {
						$product_total += $product_2['quantity'];
					}
				}			
				
				if ($product['minimum'] > $product_total) {
					$this->data['error_warning'] = sprintf($this->language->get('error_minimum'), $product['name'], $product['minimum']);
				}				
					
				if ($product['image']) {
					$image = $this->model_tool_image->resize($product['image'], $this->config->get('config_image_cart_width'), $this->config->get('config_image_cart_height'));
				} else {
					$image = '';
				}

				$option_data = array();

        		foreach ($product['option'] as $option) {
					if ($option['type'] != 'file') {
						$option_data[] = array(
							'name'  => $option['name'],
							'value' => (strlen($option['option_value']) > 20 ? substr($option['option_value'], 0, 20) . '..' : $option['option_value'])
						);
					} else {
						$this->load->library('encryption');
						
						$encryption = new Encryption($this->config->get('config_encryption'));
						
						$file = substr($encryption->decrypt($option['option_value']), 0, strrpos($encryption->decrypt($option['option_value']), '.'));
						
						$option_data[] = array(
							'name'  => $option['name'],
							'value' => (strlen($file) > 20 ? substr($file, 0, 20) . '..' : $file)
						);						
					}
        		}
				
				if (($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) {
					$price = $this->currency->format($this->tax->calculate($product['price'], $product['tax_class_id'], $this->config->get('config_tax')));
				} else {
					$price = false;
				}

				if (($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) {
					$total = $this->currency->format($this->tax->calculate($product['total'], $product['tax_class_id'], $this->config->get('config_tax')));
				} else {
					$total = false;
				}
				$parentimage = str_replace(".png-80x80.jpg", "", $image );
				$parentimage = str_replace("http://www.chameleon.rocks/image/cache/TEMP/", "", $parentimage );
				$parentimage = substr($parentimage,0,strpos($parentimage,"."));

				
				$isRing=$this->model_catalog_product->isRing($product['product_id']);
//				if(!$product['optionname'] || !$product['option']) {
				if($product['optionname']=='') {
					$DefaultCombination = '<br>';

					$this->data['metalname'] = array();
					$iCount=1;
					$results2=$this->model_catalog_product->getProductMetalName($product['parent_product_id']);
					foreach ($results2 as $result) {
						$this->data['metalname'][] = array(
//							'metalname' => $result['metalname']
						);
						if($iCount==1){
							$DefaultCombination .= 'Primary Metal - '.$result['metalname'] .'<br/>';
						}else{
							$DefaultCombination .= 'Metal '.$iCount. ' - '.$result['metalname'] .'<br/>';
						}
						$iCount++;
					}
					$this->data['gemstone'] = array();
					$results12=$this->model_catalog_product->getProductGemNameDefault($product['parent_product_id']);
					$iCount=1;
					foreach ($results12 as $result) {

						$this->data['gemstone'][] = array(
//							'gemstone' => $result['gemname'] 
						);
						if($iCount==1){
							$DefaultCombination .=  'Center Gemstone - ' .$result['gemname'] .'<br/>';
						}else{
							$DefaultCombination .=  'Accent Gemstones '.$iCount . ' - '.$result['gemname'] .'<br/>';
						}
						$iCount++;
					}
					$product['optionname'] = $DefaultCombination;
					$this->model_catalog_product->UpdateOptionName($product['product_id'],$DefaultCombination);
					
				}
				if($isRing=="Yes" && $ringSizeColumn==0){
					$ringSizeColumn=1;
				}
				if($isRing=='Yes' && ($product['country']=="aaaa" || $product['country']=='' || $product['ringsize']=="bbbb"  || $product['ringsize']=='' )){
					$blockCheckout=1;
					$this->data['blockCheckoutText']="alert('Please select your ring size and click update before checking out !');";
				}
				if($product['type']==0){
					$href  = ($product['parent_product_id']==0 ?  $this->url->link('product/product', 'product_id=' . $product['product_id']) : $this->url->link('product/product', 'product_id=' . $product['parent_product_id'] .'&image=' .$parentimage ) );
				}else{
					$href  = $this->url->link('product/product', 'product_id=' . $product['product_id']);
				}

        		$this->data['products'][] = array(
          			'key'      => $product['key'],
          			'thumb'    => $image,
				'name'     => $product['name'],
				'optionname'     => $product['optionname'],
          			//'optionname'     => $this->session->data[$product['product_id'].'prdoptionname'],
				'model'    => $product['model'],
          			'option'   => $option_data,
          			//'gemstone'   =>$gemstone,
          			//'metalname'   =>$metalname,
          			'quantity' => $product['quantity'],
          			'country'  => $product['country'],
          			'engrave'  => $product['engrave'],
					'engravetxt'  => $product['engravetxt'], 
					'engravefont'  => $product['engravefont'],
          			'ringsize' => $product['ringsize'],
					'svgContents' => $product['svgContents'],
					'engravePrd'     => $product['engravePrd'],
          			'isring'   => $isRing,
          			'stock'    => $product['stock'],
					'reward'   => ($product['reward'] ? sprintf($this->language->get('text_reward'), $product['reward']) : ''),
					'price'    => $price,
					'total'    => $total,
					'href'     => $href 
        		);
      		}
			
			
			/*New Codes Starts
			$this->data['metals'] = array();
			
			foreach ($this->model_catalog_product->getProductMetal($this->data['product_id']) as $metal) { 
				$metal_available = array();
				foreach ($this->model_catalog_product->getProductMetalAvail($this->data['product_id'],$metal['metal']) as $metalavail) {
					$metal_available[] = array(						
						'product_metalavail_id'  => $metalavail['product_metalavail_id'],
						'metal'  			 => $metalavail['metal'],
						'metal_id'           => $metalavail['metal_id'],
						'metal_code'         => $metalavail['metal_code'],
						'image'  			 => $metalavail['image'],
						'metal_image'  		 => $metalavail['metal_image'],
						'imgdescription'  	 => '<span class="short-body"><strong>'.$metalavail['metalname'].'</strong><br/>'.$metalavail['description'].'</span>', 
						'metalDescContent'   => ($metal['metal']==1?'Primary Metal : ':'Other Metals : ') .  $metalavail['metalname'].'<br />Weight : ' . round(($metal['weight'] *  $metalavail['silver_ratio']),2) . ' gm (approx.)<br /><br />', 
						'defaultnew'         => $metalavail['defaultnew'],
						'metalName'          => $metalavail['metalname'],
						'metalWeight'        => $metal['weight'] *  $metalavail['silver_ratio'],
						'price'  			 => $metalavail['price'],
						'currency'           => $metalavail['currency']
					);
					if($metalavail['defaultnew']==1){
						$metalBoxImage   = $metalavail['image'];
						$metalName   	 = $metalavail['metalname'];
						$metalWeight   	 = $metal['weight'] *  $metalavail['silver_ratio'];
						$metalBoxContent = '<span class="short-body"><strong>'.$metalavail['metalname'].'</strong><br/>'.$metalavail['description'].'</span>';
					}
				}
				
				$this->data['metals'][] = array(
						'metal'  			=> $metal['metal'],
						'weight'            => $metal['weight'],
						'metalName'    		=> $metalName,
						'metalWeight'    	=> $metalWeight,
						'metalBoxImage'     => $metalBoxImage,
						'metalBoxContent'   => $metalBoxContent,
						'metal_available'   => $metal_available
				);
			}

			$this->data['gemstones'] = array();
			
			foreach ($this->model_catalog_product->getProductGemstones($product['product_id']) as $gemstone) { 
				$gemstone_available = array();
				foreach ($this->model_catalog_product->getProductGemstonesAvail($product['product_id'],$gemstone['gem']) as $gemstone_avail) {
					$gemQuality = $this->model_catalog_product->getGemQuality($gemstone_avail['gemstone_id']);
					$gemWeight = round($this->model_catalog_product->getGemWeight($gemstone_avail['product_gemavail_id']),2);
					$rapnet_url = '';
					if($gemstone_avail['rapnet']==1){
						$gemQuality_1 = $gemstone_avail['rapnet_quality'];
						$gemSize_1 = $gemstone_avail['rapnet_size'];
						$gemWeight_1 = round($gemstone['count'] * $gemstone_avail['rapnet_weight'],2);
						$rapnet_url = $gemstone_avail['rapnet_url'];
					}else{
						$gemQuality_1 = $gemQuality;
						$gemSize_1 = $gemstone['size'];
						$gemWeight_1 = $gemWeight;
					}
					$gemstone_available[] = array(	
						'product_gemavail_id' => $gemstone_avail['product_gemavail_id'],
						'gem'  			 	 => $gemstone_avail['gem'],
						'gemstone_id'    	 => $gemstone_avail['gemstone_id'], 
						'image'  			 => $gemstone_avail['image'],
						'image1'  			 => $gemstone_avail['image1'],
						'gemName'         	 => $gemstone_avail['gemname'],
						'gemQuality'         => $gemQuality_1,
						'gemSize'            => $gemSize_1,
						'gemCount'           => $gemstone['count'],
						'gemShape'           => $gemstone['shape'],
						'gemWeight'          => $gemWeight_1,
						'gemSetting'         => $gemstone['setting'],
						'imgdescription'  	 => '<div class="short-title"><strong>'. strtoupper($gemstone_avail['gemdescr']) .'</strong></div><b>Birthstone: </b>'. $gemstone_avail['birthstone'] .'<br><span class="short-body"><strong>Anniversary: </strong>'. $gemstone_avail['anniversary']  .'</span>', 
						'defaultnew'         => $gemstone_avail['defaultnew'],
						'gemDescContent'     => ($gemstone['gem']==1?'Center Gemstone : ':'Accent Gemstone : ' ) . $gemstone_avail['gemname'] . $rapnet_url .'<br />Quality : ' . $gemQuality_1 .'<br />Size : ' . $gemSize_1 .'<br />Shape : ' . $gemstone['shape'] .'<br />Total Weight : ' . $gemWeight_1 .' carats (approx.)<br />Count : ' . $gemstone['count'] .' pc<br />Setting : ' . $gemstone['setting'] . '<br /><br />'
						
					);
					
					if($gemstone_avail['defaultnew']==1){
						$gemName = $gemstone_avail['gemname'] . $rapnet_url;
						$gemBoxImage = $gemstone_avail['image1'];
						$gemBoxContent = '<div class="short-title"><strong>'. strtoupper($gemstone_avail['gemdescr']) .'</strong></div><b>Birthstone: </b>'. $gemstone_avail['birthstone'] .'<br><span class="short-body"><strong>Anniversary: </strong>'. $gemstone_avail['anniversary']  .'</span>';
						$gemQuality         = $gemQuality_1;
						$gemSize            = $gemSize_1;
						$gemShape           = $gemstone['shape'];
						$gemWeightFinal     = round($this->model_catalog_product->getGemWeight($gemstone_avail['product_gemavail_id']),2); 
						$gemQualityFinal     = $this->model_catalog_product->getGemQuality($gemstone_avail['gemstone_id']);
						$gemSetting         = $gemstone['setting'];
					}
					if($gemstone_avail['rapnet']==1 ){
						$gemWeightFinal = $gemWeight_1;
						$gemQualityFinal = $gemQuality_1;
					}
				}
				$this->data['gemstones'][] = array(
						'gem'  				 => $gemstone['gem'],
						'weight'             => $gemstone['weight'],
						'gemName'            => $gemName,
						'gemQuality'         => $gemQualityFinal,
						'gemSize'            => $gemSize,
						'gemCount'           => $gemstone['count'],
						'gemShape'           => $gemShape,
						'gemWeight'          => $gemWeightFinal,
						'gemSetting'         => $gemSetting,
						'gemBoxContent'      => $gemBoxContent,
						'gemBoxImage'        => $gemBoxImage,
						'gemstone_available' => $gemstone_available
				);
			}
			//New Codes Ends */
			
			
			// Gift Voucher
			$this->data['vouchers'] = array();
			
			if (isset($this->session->data['vouchers']) && $this->session->data['vouchers']) {
				foreach ($this->session->data['vouchers'] as $key => $voucher) {
					$this->data['vouchers'][] = array(
						'key'         => $key,
						'description' => $voucher['description'],
						'cid' => $voucher['cid'],
						'amount'      => $this->currency->format($voucher['amount'])
					);
				}
			} 
						
			$total_data = array();
			$total = 0;
			$taxes = $this->cart->getTaxes();
			
			if (($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) {						 
				$this->load->model('setting/extension');
				$sort_order = array(); 
				
				$results = $this->model_setting_extension->getExtensions('total');
				
				foreach ($results as $key => $value) {
					$sort_order[$key] = $this->config->get($value['code'] . '_sort_order');
				}
				
				array_multisort($sort_order, SORT_ASC, $results);
				
				foreach ($results as $result) {
					if ($this->config->get($result['code'] . '_status')) {
						$this->load->model('total/' . $result['code']);
		
						$this->{'model_total_' . $result['code']}->getTotal($total_data, $total, $taxes);
					}
				}
				
				$sort_order = array(); 
			  
				foreach ($total_data as $key => $value) {
					$sort_order[$key] = $value['sort_order'];
				}
	
				array_multisort($sort_order, SORT_ASC, $total_data);
			}
			
			$this->data['totals'] = $total_data;
				
			// Modules
			$this->data['modules'] = array();
			
			if (isset($results)) {
				foreach ($results as $result) {
					if ($this->config->get($result['code'] . '_status') && file_exists(DIR_APPLICATION . 'controller/total/' . $result['code'] . '.php')) {
						$this->data['modules'][] = $this->getChild('total/' . $result['code']);
					}
				}
			}
			
			if (isset($this->session->data['redirect'])) {
      			$this->data['continue'] = $this->session->data['redirect'];
				
				unset($this->session->data['redirect']);
			} else {
				$this->data['continue'] = $this->url->link('common/home');
			}
			
			
			//$this->log->write(' BlockCheckout ' . $blockCheckout . ' ' . $this->request->post['redirection'] );

			if($blockCheckout==0){
				if(isset($this->request->post['redirection']) && $this->request->post['redirection']=='Yes' ){
					$this->redirect($this->url->link('onecheckout/checkout','', 'SSL'));
				}
				$this->data['checkout'] = $this->url->link('onecheckout/checkout', '', 'SSL');				
			}else{
//				$this->data['checkout'] = 'javascript:void(0)';
				$this->data['checkout'] = $this->url->link('checkout/cart', '&redirect=Y', 'SSL');;
			}
			
			if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/checkout/cart.tpl')) {
				$this->template = $this->config->get('config_template') . '/template/checkout/cart.tpl';
			} else {
				$this->template = 'default/template/checkout/cart.tpl';
			}
			
			$this->children = array(
				'common/column_left',
				'common/column_right',
				'common/content_top',
				'common/content_bottom',
				'common/footer',
				'common/header'	
			);
			$this->data['ringSizeColumn'] = $ringSizeColumn;

					
			$this->response->setOutput($this->render());					
    	} else {
      		$this->data['heading_title'] = $this->language->get('heading_title');

      		$this->data['text_error'] = $this->language->get('text_empty');

      		$this->data['button_continue'] = $this->language->get('button_continue');

      		$this->data['continue'] = $this->url->link('common/home');

			if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/error/not_found.tpl')) {
				$this->template = $this->config->get('config_template') . '/template/error/not_found.tpl';
			} else {
				$this->template = 'default/template/error/not_found.tpl';
			}
			
			$this->children = array(
				'common/column_left',
				'common/column_right',
				'common/content_top',
				'common/content_bottom',
				'common/footer',
				'common/header'	
			);
					
			$this->response->setOutput($this->render());			
    	}
  	}
	
	public function update() {
		
		$this->load->model('catalog/product');
		if (isset($this->request->post['product_id'])) {
			$prd_zeroprice = $this->model_catalog_product->getProductPrice($this->request->post['product_id']);
			if($prd_zeroprice<=0){
				$this->redirect($this->url->link('product/product', 'product_id=' . $this->request->post['product_id'] ) );
			}
		}

		$this->language->load('checkout/cart');
		
		$json = array();
		
		if (isset($this->request->post['product_id'])) {
			
			$product_info = $this->model_catalog_product->getProduct_new($this->request->post['product_id']);
			
			$this->log->write('i am in ' . $this->request->post['product_id'] );
			
			if (isset($this->request->post[ 'curveNewtext1' ] ) ){
			$this->log->write( 'engraveText1 ing section' );
			for ($engrave_row = 0; $engrave_row < 8 ; $engrave_row++) {
				$this->log->write( 'engraveText1 ing section loope '.  $engrave_row );
				$eng_row = $engrave_row + 1 ;
				if (isset($this->request->post[ 'curveNewtext'. $engrave_row ] ) ){
					$this->session->data['engraveText' . $engrave_row ] = $this->request->post[ 'curveNewtext'. $engrave_row ];
					$this->log->write( 'engraveText1 : '. $this->session->data['engraveText' . $engrave_row ] );
				} 
			}
			}
		
			
			if ($product_info) 
			{					
				if (isset($this->request->post['quantity'])) {
					$quantity = $this->request->post['quantity'];
				} else {
					$quantity = 1;
				}
				
				$product_total = 0;
				
				$products = $this->cart->getProducts();
				
				foreach ($products as $product_2) {
					if ($product_2['product_id'] == $this->request->post['product_id']) {
						$product_total += $product_2['quantity'];
					}
				}
				
				if ($product_info['minimum'] > ($product_total + $quantity)) {
					$json['error']['warning'] = sprintf($this->language->get('error_minimum'), $product_info['name'], $product_info['minimum']);
				}
				
				if (isset($this->request->post['option'])) {
					$option = array_filter($this->request->post['option']);
				} else {
					$option = array();	
				}				
	
				$product_options = $this->model_catalog_product->getProductOptions_NEW($this->request->post['product_id']);
				
				foreach ($product_options as $product_option) {
					if ($product_option['required'] && (!isset($this->request->post['option'][$product_option['product_option_id']]) || !$this->request->post['option'][$product_option['product_option_id']])) {
						$json['error'][$product_option['product_option_id']] = sprintf($this->language->get('error_required'), $product_option['name']);
					}
				}
			}
			
			if (!isset($json['error'])   ) {
				$this->cart->add($this->request->post['product_id'], $quantity, $option);
			
//				$json['success'] = sprintf($this->language->get('text_success'), $this->url->link('product/product', 'product_id=' . $this->request->post['product_id']), $product_info['name'], $this->url->link('checkout/cart'));
				$json['success'] = sprintf($this->language->get('text_success'),  $product_info['name'], $this->url->link('checkout/cart'));
			
				unset($this->session->data['shipping_methods']);
				unset($this->session->data['shipping_method']);
				unset($this->session->data['payment_methods']);
				unset($this->session->data['payment_method']);			
			} else {
				$json['redirect'] = str_replace('&amp;', '&', $this->url->link('product/product', 'product_id=' . $this->request->post['product_id']));
			}
		}	
		
      	if (isset($this->request->post['remove'])) {
        	$this->cart->remove($this->request->post['remove']);
			
			unset($this->session->data['shipping_methods']);
			unset($this->session->data['shipping_method']);
			unset($this->session->data['payment_methods']);
			unset($this->session->data['payment_method']);				
      	}

      	if (isset($this->request->post['voucher'])) {
			if ($this->session->data['vouchers'][$this->request->post['voucher']]) {
				unset($this->session->data['vouchers'][$this->request->post['voucher']]);
			}
		}
					
		$this->load->model('tool/image');
		
		$this->data['text_empty'] = $this->language->get('text_empty');
		
		$this->data['button_checkout'] = $this->language->get('button_checkout');
		$this->data['button_remove'] = $this->language->get('button_remove');

		$this->data['products'] = array();

		foreach ($this->cart->getProducts() as $result) {
			if ($result['image']) {
				$image = $this->model_tool_image->resize($result['image'], 40, 40);
			} else {
				$image = '';
			}			
			
			$option_data = array();

			foreach ($result['option'] as $option) {
				if ($option['type'] != 'file') {
					$option_data[] = array(
						'name'  => $option['name'],
						'value' => (strlen($option['option_value']) > 20 ? substr($option['option_value'], 0, 20) . '..' : $option['option_value'])
					);
				} else {
					$this->load->library('encryption');
					
					$encryption = new Encryption($this->config->get('config_encryption'));
					
					$file = substr($encryption->decrypt($option['option_value']), 0, strrpos($encryption->decrypt($option['option_value']), '.'));
					
					$option_data[] = array(
						'name'  => $option['name'],
						'value' => (strlen($file) > 20 ? substr($file, 0, 20) . '..' : $file)
					);					
				}
			}
				
			if (($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) {
				$price = $this->currency->format($this->tax->calculate($result['price'], $result['tax_class_id'], $this->config->get('config_tax')));
			} else {
				$price = false;
			}

			if (($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) {
				$total = $this->currency->format($this->tax->calculate($result['total'], $result['tax_class_id'], $this->config->get('config_tax')));
			} else {
				$total = false;
			}
				
			$this->data['products'][] = array(
				'key'        => $result['key'],
				'product_id' => $result['product_id'],
				'thumb'      => $image,
				'name'       => $result['name'],
				'model'      => $result['model'],
				'option'     => $option_data,
				'engrave'   => $result['engrave'],
				'engravetxt' => $result['engravetxt'],
				'engravefont' => $result['engravefont'],
				'quantity'   => $result['quantity'],
				'svgContents'   => $result['svgContents'],
				'engravePrd'     => $result['engravePrd'],
				'stock'      => $result['stock'],
				'price'      => $price,
				'total'      => $total,
				'href'       => $this->url->link('product/product', 'product_id=' . $result['product_id'])
			);
		}
		
		// Gift Voucher
		$this->data['vouchers'] = array();
		
		if (isset($this->session->data['vouchers']) && $this->session->data['vouchers']) {
			foreach ($this->session->data['vouchers'] as $key => $voucher) {
				$this->data['vouchers'][] = array(
					'key'         => $key,
					'description' => $voucher['description'],
					'cid' => $voucher['cid'],
					'amount'      => $this->currency->format($voucher['amount'])
				);
			}
		} 
		
		// Calculate Totals
		$total_data = array();					
		$total = 0;
		$taxes = $this->cart->getTaxes();
		
		if (($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) {						 
			$this->load->model('setting/extension');
			
			$sort_order = array(); 
			
			$results = $this->model_setting_extension->getExtensions('total');
			
			foreach ($results as $key => $value) {
				$sort_order[$key] = $this->config->get($value['code'] . '_sort_order');
			}
			
			array_multisort($sort_order, SORT_ASC, $results);
			
			foreach ($results as $result) {
				if ($this->config->get($result['code'] . '_status')) {
					$this->load->model('total/' . $result['code']);
		
					$this->{'model_total_' . $result['code']}->getTotal($total_data, $total, $taxes);
				}
			}
			
			$sort_order = array(); 
		  
			foreach ($total_data as $key => $value) {
				$sort_order[$key] = $value['sort_order'];
			}
	
			array_multisort($sort_order, SORT_ASC, $total_data);
		}
		
		$json['total'] = sprintf($this->language->get('text_items'), $this->cart->countProducts() + (isset($this->session->data['vouchers']) ? count($this->session->data['vouchers']) : 0), $this->currency->format($total));
		
		$this->data['totals'] = $total_data;
		
		$this->data['checkout'] = $this->url->link('onecheckout/checkout', '', 'SSL');
		
		if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/common/cart.tpl')) {
			$this->template = $this->config->get('config_template') . '/template/common/cart.tpl';
		} else {
			$this->template = 'default/template/common/cart.tpl';
		}
		
		$json['output'] = $this->render();
		$this->log->write('End - '.date("Y-m-d H:i:s"));
		
		$this->response->setOutput(json_encode($json));
	}
	
	public function ringsize() {
		$output = '<option value="">' . 'Size' . '</option>';
		
		$this->load->model('information/myown');

    	$results = $this->model_information_myown->getSizeByCountry($this->request->get['country']);
        
      	foreach ($results as $result) {
        	$output .= '<option value="' . $result['ring_size'] . '"';
	
	    	$output .= '>' . $result['ring_size'] . '</option>';
    	} 
		
		if (!$results) {
		  	$output .= '<option value="0">' . $this->language->get('text_none') . '</option>';
		}
	
		$this->response->setOutput($output);
  	}  
}
?>