<?php 
class ControllerExtrasBlog extends Controller {
	private $error = array();
	
	public function index() {  
    	$this->language->load('extras/blog');
		
		$this->load->model('extras/blog');	
		
		$this->data['breadcrumbs']  = array();
		
      	$this->data['breadcrumbs'] [] = array(
        	'href'      => $this->url->link('common/home'),
        	'text'      => $this->language->get('text_home'),
        	'separator' => FALSE
      	);
		
		$this->getBlogs();
	}
	
	public function sendComment() {
		$this->load->language('extras/blog');

		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('extras/blog');
				
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
			$blog_info = $this->model_extras_blog->getBlog($this->request->get['blog_id']);
			$this->data['comment_need_approval'] = $blog_info['comment_need_approval'];
			if($this->data['comment_need_approval'] == '1'){
				$comment_status = '1';
				$comment_success_message = $this->language->get('success_messages_approval');
			}else{
				$comment_status = '0';
				$comment_success_message = $this->language->get('success_messages');
			}
			
			$this->model_extras_blog->addComment($this->request->get['blog_id'], $this->request->post['name'], $this->request->post['email'], $this->request->post['comment'], $comment_status);	
			$this->data['success_messages'] = $comment_success_message;
			
		}

		$this->getBlog();
	}
	
	public function getBlogs() { 
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
		
		$this->language->load('extras/blog');
		
		$this->load->model('extras/blog');
		
		//$this->load->model('tool/seo_url');
		$this->load->model('tool/image');
		
		$this->data['breadcrumbs'] = array();

      	$this->data['breadcrumbs'][] = array(
        	'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home'),        	
        	'separator' => false
      	);

      	$this->data['breadcrumbs'][] = array(
        	'text'      => $this->language->get('text_blog'),
			'href'      => $this->url->link('extras/blog'),
        	'separator' => $this->language->get('text_separator')
      	);	
		
		$this->data['blogs'] = array();

		$data = array(
			'start' => ($page - 1) * $this->config->get('blog_setting_blog_per_page'),
			'limit' => $this->config->get('blog_setting_blog_per_page')
		);
		
		$blog_total = $this->model_extras_blog->getTotalBlogs();
	
		$results = $this->model_extras_blog->getBlogs(($page - 1) * $this->config->get('blog_setting_blog_per_page'), $this->config->get('blog_setting_blog_per_page'));
 
    	foreach ($results as $result) {
						
			$this->data['blogs'][] = array(
			   'count_read' => $result['count_read'],
				'blog_id' => $result['blog_id'],
				'title'      => $result['title'],
				'short_description'      => substr(strip_tags(html_entity_decode($result['short_description'], ENT_QUOTES, 'UTF-8')), 0, $this->config->get('blog_setting_blog_list_short_description_max_chars')) . ' <a href="' . $this->url->link('extras/blog/getblog', 'blog_id=' . $result['blog_id']) . '" title="' . $this->language->get('text_read_more') . '">[...]</a>',
				'date_added' => $result['date_added'],
				'image'   		=> $this->model_tool_image->resize($result['image'], $this->config->get('blog_setting_blog_list_image_dimension_width'), $this->config->get('blog_setting_blog_list_image_dimension_height')),
				//'sort_order' => $result['sort_order'],
				'href' => $this->url->link('extras/blog/getblog', 'blog_id=' . $result['blog_id'])
			);
			
		}	
		$this->document->setTitle($this->language->get('text_blog')); 
		
		$this->data['heading_title'] = $this->language->get('text_blog');
		
		$this->data['text_posted_on'] = $this->language->get('text_posted_on');
		$this->data['text_read'] = $this->language->get('text_read');
		$this->data['text_time'] = $this->language->get('text_time');
		$this->data['text_not_found'] = $this->language->get('text_not_found');
		$this->data['text_read_more'] = $this->language->get('text_read_more');
		$this->data['text_blog_rss'] = $this->language->get('text_blog_rss');

		$this->data['blog_feed_status'] = $this->config->get('blog_feed_status');
		$this->data['data_feed'] = $this->url->link('extras/blog_feed');

		$url = '';
		
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		
		$url = '';
		
		$pagination = new Pagination();
		$pagination->total = $blog_total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('blog_setting_blog_per_page');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('extras/blog', $url . '&page={page}');
			
		$this->data['pagination'] = $pagination->render();
		
		if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/extras/blog_all.tpl')) {
				$this->template = $this->config->get('config_template') . '/template/extras/blog_all.tpl';
			} else {
				$this->template = 'default/template/extras/blog_all.tpl';
			}
			
			$this->children = array(
				'common/column_left',
				'common/column_right',
				'common/content_top',
				'common/content_bottom',
				'common/footer',
				'common/header'
			);	
		
		$this->response->setOutput($this->render()); 
	}
	public function getBlogCategory() { 
		$this->language->load('extras/blog');
	
		$this->data['breadcrumbs'] = array();

      	$this->data['breadcrumbs'][] = array(
        	'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home'),        	
        	'separator' => false
      	);

      	$this->data['breadcrumbs'][] = array(
        	'text'      => $this->language->get('text_blog'),
			'href'      => $this->url->link('extras/blog'),
        	'separator' => $this->language->get('text_separator')
      	);	
		
		$this->load->model('extras/blog_category');
		$this->load->model('extras/blog');
		//$this->load->model('tool/seo_url');  
				
		if (isset($this->request->get['blogpath'])) {
			$path = '';
		
			$parts = explode('_', $this->request->get['blogpath']);
		
			foreach ($parts as $path_id) {
				$blog_category_info = $this->model_extras_blog_category->getBlogCategory($path_id);
				
				if ($blog_category_info) {
					if (!$path) {
						$path = $path_id;
					} else {
						$path .= '_' . $path_id;
					}

	       			$this->data['breadcrumbs'] [] = array(
   	    				'href'      => $this->url->link('extras/blog/getblogcategory', 'blogpath=' . $path),
    	   				'text'      => $blog_category_info['name'],
        				'separator' => $this->language->get('text_separator')
        			);
				}
			}		
		
			$blog_category_id = array_pop($parts);
		} else {
			$blog_category_id = 0;
		}
		
		$blog_category_info = $this->model_extras_blog_category->getBlogCategory($blog_category_id);
		
		if ($blog_category_info) {
		
			$this->document->setTitle($blog_category_info['name']);
			$this->document->setDescription($blog_category_info['meta_description']);
			$this->document->setKeywords($blog_category_info['meta_keywords']);
			
			$this->data['heading_title'] = $blog_category_info['name'];
			
			$this->data['blog_category_description'] = html_entity_decode($blog_category_info['description']);
			$this->data['blog_setting_show_category_description'] = $this->config->get('blog_setting_show_category_description');
			
			$this->data['text_blog'] = $this->language->get('text_blog');
      		$this->data['text_posted_on'] = $this->language->get('text_posted_on');
      		$this->data['text_read'] = $this->language->get('text_read');
      		$this->data['text_time'] = $this->language->get('text_time');
      		$this->data['text_not_found'] = $this->language->get('text_not_found');
      		$this->data['text_updated_on'] = $this->language->get('text_updated_on');
         	$this->data['text_read_more'] = $this->language->get('text_read_more');
         	$this->data['text_comments'] = $this->language->get('text_comments');
			$this->data['text_category_description'] = $this->language->get('text_category_description');
			
			$this->data['description'] = html_entity_decode($blog_category_info['description'], ENT_QUOTES, 'UTF-8');
			
			// Mengambil data blog berdasarkan blog category id start
			
			if (isset($this->request->get['page'])) {
				$page = $this->request->get['page'];
			} else {
				$page = 1;
			}  
			
			$this->load->model('extras/blog');
			$this->load->model('tool/image');
				
			$this->data['blogs'] = array();
			
			$data = array(
				'start' => ($page - 1) * $this->config->get('blog_setting_blog_per_page'),
				'limit' => $this->config->get('blog_setting_blog_per_page')
			);
        		
			$results = $this->model_extras_blog->getBlogsByBlogCategoryId($blog_category_id, ($page - 1) * $this->config->get('blog_setting_blog_per_page'), $this->config->get('blog_setting_blog_per_page'));
			foreach ($results as $result) {
      		$this->data['blogs'][] = array(
				'count_read' => $result['count_read'],
        		'title' => $result['title'],
        		'date_added' => $result['date_added'],
        		'date_modified' => $result['date_modified'],
        		'description' => html_entity_decode($result['description']),
        		'short_description' => substr(strip_tags(html_entity_decode($result['short_description'], ENT_QUOTES, 'UTF-8')), 0, $this->config->get('blog_setting_blog_list_short_description_max_chars')) . ' <a href="' . $this->url->link('extras/blog/getblog', 'blog_id=' . $result['blog_id']) . '" title="' . $this->language->get('text_read_more') . '">[...]</a>',
        		//'count_read' => $result['count_read'],
        		'image' => $this->model_tool_image->resize($result['image'], $this->config->get('blog_setting_blog_list_image_dimension_width'), $this->config->get('blog_setting_blog_list_image_dimension_height')),
	    		'href'  => $this->url->link('extras/blog/getblog', 'blog_id=' . $result['blog_id'])
				//'href_comment'  => $this->model_tool_seo_url->rewrite(HTTP_SERVER . 'index.php?route=blog/blog&blog_id=' . $result['blog_id'] . '#comment_area'),
				//'blog_comment_count' =>$this->model_extras_blog->getTotalCommentsByBlogId($result['blog_id'])
      		);
    		}
			
			// Mengambil data blog berdasarkan blog category id start
			
			// Pagination All Blog start      		
				
			$blog_total = $this->model_extras_blog->getTotalBlogsByBlogCategoryId($blog_category_id);
			
			$url = '';
			
			$pagination = new Pagination();
			$pagination->total = $blog_total;
			$pagination->page = $page;
			$pagination->limit = $this->config->get('blog_setting_blog_per_page'); 
			$pagination->text = $this->language->get('text_pagination');
			$pagination->url = $this->url->link('extras/blog/getblogcategory', 'blogpath=' . $this->request->get['blogpath'] . $url . '&page={page}');
			
			$this->data['pagination'] = $pagination->render();
      	// Pagination All Blog end
			
			
			if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/extras/blog_category.tpl')) {
				$this->template = $this->config->get('config_template') . '/template/extras/blog_category.tpl';
			} else {
				$this->template = 'default/template/extras/blog_category.tpl';
			}	
				
			$this->children = array(
				'common/column_left',
				'common/column_right',
				'common/content_top',
				'common/content_bottom',
				'common/footer',
				'common/header'
			);
			$this->response->setOutput($this->render()); 	
		} else {
		
			$this->language->load('error/not_found');
			
			$url = '';
			
			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}	
			
			if (isset($this->request->get['blogpath'])) {	
	       		$this->data['breadcrumbs'] [] = array(
   	    			'href'      => $this->url->link('extras/blog/getblogcategory', 'blogpath=' . $path),
    	   			'text'      => $this->language->get('text_error'),
        			'separator' => $this->language->get('text_separator')
        		);
			}
			
			$this->document->setTitle($this->language->get('text_error'));

      	$this->data['heading_title'] = $this->language->get('text_error');

      	$this->data['text_error'] = $this->language->get('text_error');

      	$this->data['button_continue'] = $this->language->get('button_continue');

      	$this->data['continue'] = $this->url->link('common/home');
      	
      	if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/error/not_found.tpl')) {
				$this->template = $this->config->get('config_template') . '/template/error/not_found.tpl';
			} else {
				$this->template = 'default/template/error/not_found.tpl';
			}	
			
			$this->children = array(
				'common/column_left',
				'common/column_right',
				'common/content_top',
				'common/content_bottom',
				'common/footer',
				'common/header'
			);
			
			$this->response->setOutput($this->render()); 
		
		}
		
	}
	
	public function getBlog() { 
		
		$this->language->load('extras/blog');
		
		$this->load->model('extras/blog');
		//$this->load->model('tool/seo_url');
		$this->load->model('tool/image');
		
		$this->data['breadcrumbs'] = array();

      	$this->data['breadcrumbs'][] = array(
        	'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home'),        	
        	'separator' => false
      	);

      	$this->data['breadcrumbs'][] = array(
        	'text'      => $this->language->get('text_blog'),
			'href'      => $this->url->link('extras/blog'),
        	'separator' => $this->language->get('text_separator')
      	);	
		
		$this->data['share_button_code'] = html_entity_decode($this->config->get('blog_setting_share_button_code')); 
		
		if (isset($this->request->get['blog_id'])) {
			$blog_id = $this->request->get['blog_id'];
		} else {
			$blog_id = 0;
		}
		
		$blog_info = $this->model_extras_blog->getBlog($blog_id);
   		
		if ($blog_info) {
	  		// Count Read start
			$this->data['new_read_counter_value'] = $blog_info['count_read']+1;
			$this->model_extras_blog->updateBlogReadCounter($this->request->get['blog_id'], $this->data['new_read_counter_value']);
			// Count Read end
			// Related Blog start
			if (isset($this->request->get['blog_id'])) {
				$this->data['related_blogs'] = array();
		
				foreach ($this->model_extras_blog->getRelatedBlog($this->request->get['blog_id']) as $result) {
      			$this->data['related_blogs'][] = array(
        			'title' => $result['title'],   
					'date_added' => $result['date_added'], 
					'count_read' => $result['count_read'], 
					'short_description' => substr(strip_tags(html_entity_decode($result['short_description'], ENT_QUOTES, 'UTF-8')), 0, $this->config->get('blog_setting_blog_list_short_description_max_chars')) . ' <a href="' . $this->url->link('extras/blog/getblog', 'blog_id=' . $result['blog_id']) . '" title="' . $this->language->get('text_read_more') . '">[...]</a>',
        			'image' => $this->model_tool_image->resize($result['image'], $this->config->get('blog_setting_blog_list_image_dimension_width'), $this->config->get('blog_setting_blog_list_image_dimension_height')),
	    			'href'  => $this->url->link('extras/blog/getblog', 'blog_id=' . $result['blog_id'])
      			);
    			}
    		}
			// Related Blog end
			// Get Comment start
			
			if (isset($this->request->get['page'])) {
				$page = $this->request->get['page'];
			} else {
				$page = 1;
			}  
		
			$this->data['comments'] = array();
			
			$results = $this->model_extras_blog->getCommentsByBlogId($this->request->get['blog_id'], ($page - 1) * $this->config->get('blog_setting_blog_comments_per_page'), $this->config->get('blog_setting_blog_comments_per_page'));
      		
			foreach ($results as $result) {
        		$this->data['comments'][] = array(
        			'name'     => $result['name'],
					'email'     => $result['email'],
					'comment'       => strip_tags($result['comment']),
        			'date_added' => $result['date_added']
        		);
      	}			
		
			$comment_total = $this->model_extras_blog->getTotalCommentsByBlogId($this->request->get['blog_id']);
			
			$url = '';
			
			$pagination = new Pagination();
			$pagination->total = $comment_total;
			$pagination->page = $page;
			$pagination->limit = $this->config->get('blog_setting_blog_comments_per_page'); 
			$pagination->text = $this->language->get('text_pagination');
			$pagination->url = $this->url->link('extras/blog/getblog', 'blog_id=' . $this->request->get['blog_id'] . $url . '&page={page}#comment_area');
			
			$this->data['pagination'] = $pagination->render();

			// Get Comment end
			
			$this->document->setTitle($blog_info['title']);
			$this->document->setDescription($blog_info['meta_description']);
			$this->document->setKeywords($blog_info['meta_keyword']);

      		$this->data['breadcrumbs'][] = array(
				'text'      => $blog_info['title'],
				'href'      => $this->url->link('extras/blog/getblog', $url . '&blog_id=' . $this->request->get['blog_id']),
				'separator' => $this->language->get('text_separator')
			);
									
      	$this->data['heading_title'] = $blog_info['title'];
      	
			$this->data['text_posted_on'] = $this->language->get('text_posted_on');
			$this->data['text_read'] = $this->language->get('text_read');
      	$this->data['text_time'] = $this->language->get('text_time');
      	$this->data['text_related_blog'] = $this->language->get('text_related_blog');
      	$this->data['text_comment'] = $this->language->get('text_comment');
      	$this->data['text_no_comment'] = $this->language->get('text_no_comment');
      	$this->data['text_write_comment'] = $this->language->get('text_write_comment');
			$this->data['text_note'] = $this->language->get('text_note');
			$this->data['text_comment_must_logged_in'] = $this->language->get('text_comment_must_logged_in');

      	$this->data['entry_name'] = $this->language->get('entry_name');
      	$this->data['entry_email'] = $this->language->get('entry_email');
      	$this->data['entry_comment'] = $this->language->get('entry_comment');
      	$this->data['entry_captcha'] = $this->language->get('entry_captcha');
			
      	$this->data['button_continue'] = $this->language->get('button_continue');
      	$this->data['button_send'] = $this->language->get('button_send');
			
			$this->data['description'] = html_entity_decode($blog_info['description']);
			$this->data['date_added'] = html_entity_decode($blog_info['date_added']);
			$this->data['allow_comment'] = $blog_info['allow_comment']; 
			$this->data['comment_permission'] = $blog_info['comment_permission']; 
			$this->data['comment_need_approval'] = $blog_info['comment_need_approval'];
      		
			$this->data['logged'] = $this->customer->isLogged();
			$this->data['continue'] = $this->url->link('common/home');
			$this->data['action'] = HTTP_SERVER . 'index.php?route=extras/blog/sendcomment&blog_id=' . $this->request->get['blog_id'] . '#comment_form';
			//$this->data['action'] = $this->url->link('extras/blog/sendcomment', '', 'SSL');
			//$this->data['action'] = $this->url->link('extras/blog/sendcomment', '&blog_id=' . $this->request->get['blog_id']);
			
			if (isset($this->error['name'])) {
				$this->data['error_name'] = $this->error['name'];
			} else {
				$this->data['error_name'] = '';
			}
			
			if (isset($this->error['email'])) {
				$this->data['error_email'] = $this->error['email'];
			} else {
				$this->data['error_email'] = '';
			}
			
			if (isset($this->error['comment'])) {
				$this->data['error_comment'] = $this->error['comment'];
			} else {
				$this->data['error_comment'] = '';
			}
			
			if (isset($this->error['captcha'])) {
				$this->data['error_captcha'] = $this->error['captcha'];
			} else {
				$this->data['error_captcha'] = '';
			}
			
			if (isset($this->request->post['name'])) {
				$this->data['name'] = $this->request->post['name'];
			} else {
				$this->data['name'] = '';
			}
			
			if (isset($this->request->post['email'])) {
				$this->data['email'] = $this->request->post['email'];
			} else {
				$this->data['email'] = '';
			}
			
			if (isset($this->request->post['comment'])) {
				$this->data['comment'] = $this->request->post['comment'];
			} else {
				$this->data['comment'] = '';
			}

			if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/extras/blog.tpl')) {
				$this->template = $this->config->get('config_template') . '/template/extras/blog.tpl';
			} else {
				$this->template = 'default/template/extras/blog.tpl';
			}
			
			$this->children = array(
				'common/column_left',
				'common/column_right',
				'common/content_top',
				'common/content_bottom',
				'common/footer',
				'common/header'
			);		
			
	  		$this->response->setOutput($this->render()); 
    	} else {
      		$this->data['breadcrumbs'] [] = array(
        		'href'      => $this->url->link('extras/blog', $url . '&blog_id=' . $this->request->get['blog_id']),
        		'text'      => $this->language->get('text_error'),
        		'separator' => $this->language->get('text_separator')
      		);
				
	  		$this->document->setTitle($this->language->get('text_error'));
			
      		$this->data['heading_title'] = $this->language->get('text_error');

      		$this->data['text_error'] = $this->language->get('text_error');

      		$this->data['button_continue'] = $this->language->get('button_continue');

      		$this->data['continue'] = $this->url->link('common/home');

			if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/error/not_found.tpl')) {
				$this->template = $this->config->get('config_template') . '/template/error/not_found.tpl';
			} else {
				$this->template = 'default/template/error/not_found.tpl';
			}
			
			$this->children = array(
				'common/column_left',
				'common/column_right',
				'common/content_top',
				'common/content_bottom',
				'common/footer',
				'common/header'
			);
		
	  		$this->response->setOutput($this->render()); 
    	}
  	}
	
	public function loadInfo() {
		$this->load->model('extras/blog');
		if (isset($this->request->get['blog_id'])) {
			$blog_id = $this->request->get['blog_id'];
		} else {
			if (isset($this->request->get['create'])) {
				$blog_id = $this->config->get('config_account_id');
			} else {
				$blog_id = $this->config->get('config_checkout_id');
			}
		}      
		$blog_info = $this->model_extras_blog->getBlog($blog_id);

		$output = '
			<div id="content" style="margin: 0pt; padding: 0pt;">
			  <div class="top">
			    <div class="left"></div>
			    <div class="right"></div>
			    <div class="center">
			      <h1>'.$blog_info['title'].'</h1>
			    </div>
			  </div>
			  <div class="middle">
			    <p>'.html_entity_decode($blog_info['description']).'</p>
			  </div>
			  <div class="bottom">
			    <div class="left"></div>
			    <div class="right"></div>
			    <div class="center"></div>
			  </div>
			</div>';

		$this->response->setOutput($output, $this->config->get('config_compression'));
	}
	
	public function captcha() {
		$this->load->library('captcha');
		
		$captcha = new Captcha();
		
		$this->session->data['captcha'] = $captcha->getCode();
		
		$captcha->showImage();
	}
	
	private function validateForm() {
    	if ((strlen(utf8_decode($this->request->post['name'])) < 1) || (strlen(utf8_decode($this->request->post['name'])) > 128)) {
      		$this->error['name'] = $this->language->get('error_name');
    	}
		
		if ((strlen(utf8_decode($this->request->post['email'])) > 96) || !preg_match('/^[_a-z0-9-]+(\.[_a-z0-9-]+)*@[a-z0-9-]+(\.[a-z0-9-]+)*(\.[a-z]{2,3})$/i', $this->request->post['email'])) {
      		$this->error['email'] = $this->language->get('error_email');
    	}
		
		if ((strlen(utf8_decode($this->request->post['comment'])) < 5) || (strlen(utf8_decode($this->request->post['comment'])) > 1000)) {
      		$this->error['comment'] = $this->language->get('error_comment');
    	}
		
		if (!isset($this->session->data['captcha']) || ($this->session->data['captcha'] != $this->request->post['captcha'])) {
			$this->error['captcha'] = $this->language->get('error_captcha');
		}
		
    	if (!$this->error) {
      		return TRUE;
    	} else {
      		return FALSE;
    	}
  	}
	
}
?>