<?php
class ControllerModuleBPLatest extends Controller {
	protected function index($setting) {
		$this->language->load('module/bp_latest');
		
      	$this->data['heading_title'] = $this->language->get('heading_title');
				
		$this->load->model('blog/post');
		
		$this->load->model('tool/image');
		
		$this->data['posts'] = array();
		
		$data = array(
			'sort'  => 'p.date_added',
			'order' => 'DESC',
			'start' => 0,
			'limit' => $setting['limit']
		);

		$results = $this->model_blog_post->getPosts($data);

		foreach ($results as $result) {
			if ($result['image']) {
				$image = $this->model_tool_image->resize($result['image'], $setting['image_width'], $setting['image_height']);
			} else {
				$image = $this->model_tool_image->resize('blog_no_image.jpg', $setting['image_width'], $setting['image_height']);
			}
			
			$this->data['posts'][] = array(
				'post_id' 		    => $result['post_id'],
				'author_name'       => $result['author_name'],
				'thumb'   	 		=> $image,
				'name'    	 		=> $result['name'],
				'short_description' => utf8_substr(strip_tags(html_entity_decode($result['description'], ENT_QUOTES, 'UTF-8')), 0, 300) . '..',
				'views'    		    => sprintf($this->language->get('text_views'), (int)$result['viewed']),
				'reviews'    		=> sprintf($this->language->get('text_reviews'), (int)$result['reviews']),
				'href'    	 		=> $this->url->link('blog/post', 'post_id=' . $result['post_id']),
				'comments_href'    	=> $this->url->link('blog/post', 'post_id=' . $result['post_id'] . '&to_comments=1'),
				'author_href'       => $this->url->link('blog/search', '&filter_author_id=' . $result['author_id']),		
			);
		}
		
		$this->data['show_more_actions'] = $setting['show_more_actions'];
		
		$template_file = 'bp_latest_ctb.tpl';
		
		if ($setting['position'] == 'column_right' || $setting['position'] == 'column_left') {
			$template_file = 'bp_latest_clr.tpl';
		}

		if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/module/' . $template_file)) {
			$this->template = $this->config->get('config_template') . '/template/module/' . $template_file;
		} else {
			$this->template = 'default/template/module/' . $template_file;
		}

		$this->render();
	}
}
?>