<?php
class ControllerModuleBPHeaderBanner extends Controller {
	private $error = array(); 
	
	public function index() {   
		$this->load->language('module/bp_header_banner');

		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('setting/setting');
				
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
			$this->model_setting_setting->editSetting('bp_header_banner', $this->request->post);		
					
			$this->session->data['success'] = $this->language->get('text_success');
						
			$this->redirect($this->url->link('extension/module', 'token=' . $this->session->data['token'], 'SSL'));
		}
				
		$this->data['heading_title'] = $this->language->get('heading_title');

		$this->data['text_enabled'] = $this->language->get('text_enabled');
		$this->data['text_disabled'] = $this->language->get('text_disabled');
		
		$this->data['entry_banner'] = $this->language->get('entry_banner');
		$this->data['entry_status'] = $this->language->get('entry_status');

		$this->data['button_save'] = $this->language->get('button_save');
		$this->data['button_cancel'] = $this->language->get('button_cancel');

 		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}
				
  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_module'),
			'href'      => $this->url->link('extension/module', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => ' :: '
   		);
		
   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('module/bp_header_banner', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => ' :: '
   		);
		
		$this->data['action'] = $this->url->link('module/bp_header_banner', 'token=' . $this->session->data['token'], 'SSL');
		
		$this->data['cancel'] = $this->url->link('extension/module', 'token=' . $this->session->data['token'], 'SSL');
		
		$this->data['modules'] = array();
		
		if (isset($this->request->post['bp_header_banner_banner_id'])) {
			$this->data['bp_header_banner_banner_id'] = $this->request->post['bp_header_banner_banner_id'];
		} elseif ($this->config->get('bp_header_banner_banner_id')) { 
			$this->data['bp_header_banner_banner_id'] = $this->config->get('bp_header_banner_banner_id');
		} else {
			$this->data['bp_header_banner_banner_id'] = '';
		}	

		if (isset($this->request->post['bp_header_banner_status'])) {
			$this->data['bp_header_banner_status'] = $this->request->post['bp_header_banner_status'];
		} elseif ($this->config->get('bp_header_banner_status')) { 
			$this->data['bp_header_banner_status'] = $this->config->get('bp_header_banner_status');
		} else {
			$this->data['bp_header_banner_status'] = '';
		}	

		$this->load->model('design/banner');
		
		$this->data['banners'] = $this->model_design_banner->getBanners();
				
		$this->template = 'module/bp_header_banner.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
	}
	
	private function validate() {
		if (!$this->user->hasPermission('modify', 'module/bp_header_banner')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}
		
		if (!$this->error) {
			return true;
		} else {
			return false;
		}	
	}
}
?>