<?php
class ControllerModuleBPPCP extends Controller {
	private $error = array(); 
	
	public function index() {   
		$this->load->language('module/bp_pcp');
		
		$this->document->setTitle($this->language->get('heading_title'));
		$this->document->addStyle('view/stylesheet/bp_stylesheet.css');
		
		$this->load->model('blog/category');
		$this->load->model('setting/setting');
				
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
			$this->model_setting_setting->editSetting('bp_pcp', $this->request->post);		
			
			$this->session->data['success'] = $this->language->get('text_success');
						
			$this->redirect($this->url->link('extension/module', 'token=' . $this->session->data['token'], 'SSL'));
		}
				
		$this->data['heading_title']           = $this->language->get('heading_title');

		$this->data['text_enabled'] 		   = $this->language->get('text_enabled');
		$this->data['text_disabled'] 		   = $this->language->get('text_disabled');
		$this->data['text_yes'] 	           = $this->language->get('text_yes');
		$this->data['text_no'] 				   = $this->language->get('text_no');
		$this->data['text_content_top'] 	   = $this->language->get('text_content_top');
		$this->data['text_content_bottom'] 	   = $this->language->get('text_content_bottom');		
		$this->data['text_column_left'] 	   = $this->language->get('text_column_left');
		$this->data['text_column_right'] 	   = $this->language->get('text_column_right');
		
		$this->data['entry_choose_categories'] = $this->language->get('entry_choose_categories');
		$this->data['entry_sub_categories']    = $this->language->get('entry_sub_categories');
		$this->data['entry_more_stories']      = $this->language->get('entry_more_stories');
		$this->data['entry_available'] 		   = $this->language->get('entry_available');
		$this->data['entry_selected_left'] 	   = $this->language->get('entry_selected_left');
		$this->data['entry_selected_right']    = $this->language->get('entry_selected_right');
		$this->data['entry_layout'] 		   = $this->language->get('entry_layout');
		$this->data['entry_layout'] 		   = $this->language->get('entry_layout');
		$this->data['entry_position']		   = $this->language->get('entry_position');
		$this->data['entry_status'] 		   = $this->language->get('entry_status');
		$this->data['entry_sort_order']		   = $this->language->get('entry_sort_order');
		
		$this->data['button_save'] = $this->language->get('button_save');
		$this->data['button_cancel'] = $this->language->get('button_cancel');
		$this->data['button_add_module'] = $this->language->get('button_add_module');
		$this->data['button_remove'] = $this->language->get('button_remove');
		
 		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}
		
		
  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_module'),
			'href'      => $this->url->link('extension/module', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => ' :: '
   		);
		
   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('module/bp_pcp', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => ' :: '
   		);
		
		$this->data['action'] = $this->url->link('module/bp_pcp', 'token=' . $this->session->data['token'], 'SSL');
		
		$this->data['cancel'] = $this->url->link('extension/module', 'token=' . $this->session->data['token'], 'SSL');
		
		$this->data['modules'] = array();
		
		if (isset($this->request->post['bp_pcp_module'])) {
			$this->data['modules'] = $this->request->post['bp_pcp_module'];
		} elseif ($this->config->get('bp_pcp_module')) { 
			$this->data['modules'] = $this->config->get('bp_pcp_module');
		}				
		
		if (isset($this->request->post['bp_pcp_selected_left'])) {
			$selected_left_ids = $this->request->post['bp_pcp_selected_left'];
		} elseif ($this->config->get('bp_pcp_selected_left')) { 
			$selected_left_ids = $this->config->get('bp_pcp_selected_left');
		} else {
			$selected_left_ids = '';
		}
		
		$selected_left_arr = explode(",", $selected_left_ids);
		
		if (isset($this->request->post['bp_pcp_selected_right'])) {
			$selected_right_ids = $this->request->post['bp_pcp_selected_right'];
		} elseif ($this->config->get('bp_pcp_selected_right')) { 
			$selected_right_ids = $this->config->get('bp_pcp_selected_right');
		} else {
			$selected_right_ids = '';
		}
		
		$selected_right_arr = explode(",", $selected_right_ids);
		
		$this->data['selected_left_ids']  = $selected_left_ids;
		$this->data['selected_right_ids'] = $selected_right_ids;
		
		$this->data['available_categories'] = array();
		$this->data['selected_left'] 		= array();
		$this->data['selected_right'] 		= array();
		
		$categories = $this->model_blog_category->getCategories();
		
		if ($categories){
			foreach($categories as $category) {
				if (!in_array($category['category_id'], $selected_left_arr) && !in_array($category['category_id'], $selected_right_arr) ) {
					
					$this->data['available_categories'][] = array(
						'category_id' => $category['category_id'],
						'name'        => $category['name']
					);
					
				} elseif ( in_array($category['category_id'], $selected_left_arr) ) {
					
					$this->data['selected_left'][] = array(
						'category_id' => $category['category_id'],
						'name'        => $category['name']
					);
					
				} else {
					
					$this->data['selected_right'][] = array(
						'category_id' => $category['category_id'],
						'name'        => $category['name']
					);
					
				}
			}
		}
		
		if (isset($this->request->post['bp_pcp_sub_category'])) {
			$this->data['bp_pcp_sub_category'] = $this->request->post['bp_pcp_sub_category'];
		} elseif ($this->config->get('bp_pcp_sub_category')) { 
			$this->data['bp_pcp_sub_category'] = $this->config->get('bp_pcp_sub_category');
		} else {
			$this->data['bp_pcp_sub_category'] = '';
		}
		
		if (isset($this->request->post['bp_pcp_more_stories'])) {
			$this->data['bp_pcp_more_stories'] = $this->request->post['bp_pcp_more_stories'];
		} elseif ($this->config->get('bp_pcp_more_stories')) { 
			$this->data['bp_pcp_more_stories'] = $this->config->get('bp_pcp_more_stories');
		} else {
			$this->data['bp_pcp_more_stories'] = '';
		}	
		
		$this->load->model('design/layout');
		
		$this->data['layouts'] = $this->model_design_layout->getLayouts();

		$this->template = 'module/bp_pcp.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
	}
	
	private function validate() {
		if (!$this->user->hasPermission('modify', 'module/bp_pcp')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}
				
		if (!$this->error) {
			return true;
		} else {
			return false;
		}	
	}
}
?>