<?php
class ControllerSaleGemstonelist extends Controller {
	private $error = array();
 
	public function index() {
		$this->load->language('sale/gemstonelist');
 
		$this->document->setTitle($this->language->get('heading_title'));
 		
		$this->load->model('sale/gemstonelist');
		
		$this->getList();
	}

	public function insert() {
		$this->load->language('sale/gemstonelist');

		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('sale/gemstonelist');
		
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
			$this->model_sale_gemstonelist->addCustomerGroup($this->request->post);
			
			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}
			
			$this->redirect($this->url->link('sale/gemstonelist', 'token=' . $this->session->data['token'] . $url, 'SSL'));
		}

		$this->getForm();
	}

	public function update() {
		$this->load->language('sale/gemstonelist');

		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('sale/gemstonelist');
		
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
			$this->model_sale_gemstonelist->editCustomerGroup($this->request->get['gemstone_id'], $this->request->post);
			
			$this->session->data['success'] = $this->language->get('text_success');
			
			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}
			
			$this->redirect($this->url->link('sale/gemstonelist', 'token=' . $this->session->data['token'] . $url, 'SSL'));
		}

		$this->getForm();
	}

	public function delete() { 
		$this->load->language('sale/gemstonelist');

		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('sale/gemstonelist');
		
		if (isset($this->request->post['selected']) && $this->validateDelete()) {
      		foreach ($this->request->post['selected'] as $gemstone_id) {
				$this->model_sale_gemstonelist->deleteCustomerGroup($gemstone_id);	
			}
						
			$this->session->data['success'] = $this->language->get('text_success');
			
			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}
			
			$this->redirect($this->url->link('sale/gemstonelist', 'token=' . $this->session->data['token'] . $url, 'SSL'));
		}

		$this->getList();
	}

	private function getList() {
		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'gemname';
		}
		 
		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'ASC';
		}
		
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
		
		$url = '';
		
		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}	
		
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
			
  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('sale/gemstonelist', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);
							
		$this->data['insert'] = $this->url->link('sale/gemstonelist/insert', 'token=' . $this->session->data['token'] . $url, 'SSL');
		$this->data['delete'] = $this->url->link('sale/gemstonelist/delete', 'token=' . $this->session->data['token'] . $url, 'SSL');	
	
		$this->data['gemstonelists'] = array();

		$data = array(
			'sort'  => $sort,
			'order' => $order,
			'start' => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit' => $this->config->get('config_admin_limit')
		);
		
		$gemstonelist_total = $this->model_sale_gemstonelist->getTotalCustomerGroups();
		
		$results = $this->model_sale_gemstonelist->getCustomerGroups($data);

		foreach ($results as $result) {
			$action = array();
			
			$action[] = array(
				'text' => $this->language->get('text_edit'),
				'href' => $this->url->link('sale/gemstonelist/update', 'token=' . $this->session->data['token'] . '&gemstone_id=' . $result['gemstone_id'] . $url, 'SSL')
			);		
		
			$this->data['gemstonelists'][] = array(
				'gemstone_id' => $result['gemstone_id'],
				'gemname'              => $result['gemname'] . (($result['gemstone_id'] == $this->config->get('config_gemstonelist_id')) ? $this->language->get('text_default') : null),
				'selected'          => isset($this->request->post['selected']) && in_array($result['gemstone_id'], $this->request->post['selected']),
				'action'            => $action
			);
		}	
	
		$this->data['heading_title'] = $this->language->get('heading_title');
		
		$this->data['text_no_results'] = $this->language->get('text_no_results');

		$this->data['column_gem'] = $this->language->get('column_gem');
		$this->data['column_action'] = $this->language->get('column_action');

		$this->data['button_insert'] = $this->language->get('button_insert');
		$this->data['button_delete'] = $this->language->get('button_delete');
 
 		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}
		
		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		
		$url = '';

		if ($order == 'ASC') {
			$url .= '&order=DESC';
		} else {
			$url .= '&order=ASC';
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$this->data['sort_gem'] = $this->url->link('sale/gemstonelist', 'token=' . $this->session->data['token'] . '&sort=gemname' . $url, 'SSL');
		
		$url = '';

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}
												
		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
				
		$pagination = new Pagination();
		$pagination->total = $gemstonelist_total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('sale/gemstonelist', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');
		
		$this->data['pagination'] = $pagination->render();				

		$this->data['sort'] = $sort; 
		$this->data['order'] = $order;

		$this->template = 'sale/gemstonelist_list.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
 	}

	private function getForm() {
		$this->data['heading_title'] = $this->language->get('heading_title');
		$this->data['entry_sort_order'] = $this->language->get('entry_sort_order');

		$this->data['entry_gem'] = $this->language->get('entry_gem');
		$this->data['entry_birthstone'] = $this->language->get('entry_birthstone');
		$this->data['entry_gemdescr'] = $this->language->get('entry_gemdescr');
		$this->data['entry_gemdetail'] = $this->language->get('entry_gemdetail');
		$this->data['entry_anniversary'] = $this->language->get('entry_anniversary');
		$this->data['entry_species'] = $this->language->get('entry_species');
		$this->data['entry_zodiac'] = $this->language->get('entry_zodiac');
		$this->data['entry_months'] = $this->language->get('entry_months');
		$this->data['entry_mohshardness'] = $this->language->get('entry_mohshardness');
		$this->data['entry_specificgravity'] = $this->language->get('entry_specificgravity');
		$this->data['entry_refractiveindex'] = $this->language->get('entry_refractiveindex');
		$this->data['entry_birefringence'] = $this->language->get('entry_birefringence');
		$this->data['entry_opticsign'] = $this->language->get('entry_opticsign');
		$this->data['entry_icacode'] = $this->language->get('entry_icacode');
		$this->data['entry_treatment'] = $this->language->get('entry_treatment');
		$this->data['entry_incidence'] = $this->language->get('entry_incidence');
		$this->data['entry_purpose'] = $this->language->get('entry_purpose');
		$this->data['entry_durability'] = $this->language->get('entry_durability');
		$this->data['entry_detection'] = $this->language->get('entry_detection');
		$this->data['entry_specialcare'] = $this->language->get('entry_specialcare');
		$this->data['entry_limitations'] = $this->language->get('entry_limitations');
		$this->data['entry_image'] = $this->language->get('entry_image');
		$this->data['text_browse'] = $this->language->get('text_browse');
		$this->data['text_clear'] = $this->language->get('text_clear');
		$this->data['text_image_manager'] = $this->language->get('text_image_manager');
		
		$this->data['button_save'] = $this->language->get('button_save');
		$this->data['button_cancel'] = $this->language->get('button_cancel');

		$this->data['tab_general'] = $this->language->get('tab_general');

 		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}

 		if (isset($this->error['gemname'])) {
			$this->data['error_gem'] = $this->error['gemname'];
		} else {
			$this->data['error_gem'] = '';
		}

 		if (isset($this->error['birthstone'])) {
			$this->data['error_birthstone'] = $this->error['birthstone'];
		} else {
			$this->data['error_birthstone'] = '';
		}

 		if (isset($this->error['anniversary'])) {
			$this->data['error_anniversary'] = $this->error['anniversary'];
		} else {
			$this->data['error_anniversary'] = '';
		}

 		if (isset($this->error['species'])) {
			$this->data['error_species'] = $this->error['species'];
		} else {
			$this->data['error_species'] = '';
		}

 		if (isset($this->error['zodiac'])) {
			$this->data['error_zodiac'] = $this->error['zodiac'];
		} else {
			$this->data['error_zodiac'] = '';
		}

 		if (isset($this->error['months'])) {
			$this->data['error_months'] = $this->error['months'];
		} else {
			$this->data['error_months'] = '';
		}

 		if (isset($this->error['mohshardness'])) {
			$this->data['error_mohshardness'] = $this->error['mohshardness'];
		} else {
			$this->data['error_mohshardness'] = '';
		}

 		if (isset($this->error['specificgravity'])) {
			$this->data['error_specificgravity'] = $this->error['specificgravity'];
		} else {
			$this->data['error_specificgravity'] = '';
		}

 		if (isset($this->error['refractiveindex'])) {
			$this->data['error_refractiveindex'] = $this->error['refractiveindex'];
		} else {
			$this->data['error_refractiveindex'] = '';
		}

 		if (isset($this->error['birefringence'])) {
			$this->data['error_birefringence'] = $this->error['birefringence'];
		} else {
			$this->data['error_birefringence'] = '';
		}

 		if (isset($this->error['opticsign'])) {
			$this->data['error_opticsign'] = $this->error['opticsign'];
		} else {
			$this->data['error_opticsign'] = '';
		}

 		if (isset($this->error['icacode'])) {
			$this->data['error_icacode'] = $this->error['icacode'];
		} else {
			$this->data['error_icacode'] = '';
		}

 		if (isset($this->error['treatment'])) {
			$this->data['error_treatment'] = $this->error['treatment'];
		} else {
			$this->data['error_treatment'] = '';
		}

 		if (isset($this->error['incidence'])) {
			$this->data['error_incidence'] = $this->error['incidence'];
		} else {
			$this->data['error_incidence'] = '';
		}

 		if (isset($this->error['purpose'])) {
			$this->data['error_purpose'] = $this->error['purpose'];
		} else {
			$this->data['error_purpose'] = '';
		}

 		if (isset($this->error['durability'])) {
			$this->data['error_durability'] = $this->error['durability'];
		} else {
			$this->data['error_durability'] = '';
		}

 		if (isset($this->error['detection'])) {
			$this->data['error_detection'] = $this->error['detection'];
		} else {
			$this->data['error_detection'] = '';
		}

 		if (isset($this->error['specialcare'])) {
			$this->data['error_specialcare'] = $this->error['specialcare'];
		} else {
			$this->data['error_specialcare'] = '';
		}

 		if (isset($this->error['limitations'])) {
			$this->data['error_limitations'] = $this->error['limitations'];
		} else {
			$this->data['error_limitations'] = '';
		}
		
		if (isset($this->error['image'])) {
			$this->data['error_image'] = $this->error['image'];
		} else {
			$this->data['error_image'] = '';
		}

		$url = '';
			
		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
		
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('sale/gemstonelist', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);
			
		if (!isset($this->request->get['gemstone_id'])) {
			$this->data['action'] = $this->url->link('sale/gemstonelist/insert', 'token=' . $this->session->data['token'] . $url, 'SSL');
		} else {
			$this->data['action'] = $this->url->link('sale/gemstonelist/update', 'token=' . $this->session->data['token'] . '&gemstone_id=' . $this->request->get['gemstone_id'] . $url, 'SSL');
		}
		  
    	$this->data['cancel'] = $this->url->link('sale/gemstonelist', 'token=' . $this->session->data['token'] . $url, 'SSL');
		$this->data['ExcelUpdate'] = $this->url->link('report/product_report2/updateGemDetails', 'token=' . $this->session->data['token'] . '&gemstone_id=' . $this->request->get['gemstone_id'], 'SSL');

		$this->data['token'] = $this->session->data['token'];

		if (isset($this->request->get['gemstone_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
			$gemstonelist_info = $this->model_sale_gemstonelist->getCustomerGroup($this->request->get['gemstone_id']);
		}

		if (isset($this->request->post['gemname'])) {
			$this->data['gemname'] = $this->request->post['gemname'];
		} elseif (isset($gemstonelist_info)) {
			$this->data['gemname'] = $gemstonelist_info['gemname'];
		} else {
			$this->data['gemname'] = '';
		}
		if (isset($this->request->post['gemdetail'])) {
			$this->data['gemdetail'] = $this->request->post['gemdetail'];
		} elseif (isset($gemstonelist_info)) {
			$this->data['gemdetail'] = $gemstonelist_info['gemdetail'];
		} else {
			$this->data['gemdetail'] = '';
		}
		if (isset($this->request->post['gemdescr'])) {
			$this->data['gemdescr'] = $this->request->post['gemdescr'];
		} elseif (isset($gemstonelist_info)) {
			$this->data['gemdescr'] = $gemstonelist_info['gemdescr'];
		} else {
			$this->data['gemdescr'] = '';
		}

		if (isset($this->request->post['birthstone'])) {
			$this->data['birthstone'] = $this->request->post['birthstone'];
		} elseif (isset($gemstonelist_info)) {
			$this->data['birthstone'] = $gemstonelist_info['birthstone'];
		} else {
			$this->data['birthstone'] = '';
		}

		if (isset($this->request->post['sort_order'])) {
			$this->data['sort_order'] = $this->request->post['sort_order'];
		} elseif (isset($metalmaster_info)) {
			$this->data['sort_order'] = $metalmaster_info['sort_order'];
		} else {
			$this->data['sort_order'] = '';
		}
		if (isset($this->request->post['anniversary'])) {
			$this->data['anniversary'] = $this->request->post['anniversary'];
		} elseif (isset($gemstonelist_info)) {
			$this->data['anniversary'] = $gemstonelist_info['anniversary'];
		} else {
			$this->data['anniversary'] = '';
		}
		if (isset($this->request->post['category_display'])) {
			$this->data['category_display'] = $this->request->post['category_display'];
		} elseif (isset($gemstonelist_info)) {
			$this->data['category_display'] = $gemstonelist_info['category_display'];
		} else {
			$this->data['category_display'] = '';
		}

		if (isset($this->request->post['species'])) {
			$this->data['species'] = $this->request->post['species'];
		} elseif (isset($gemstonelist_info)) {
			$this->data['species'] = $gemstonelist_info['species'];
		} else {
			$this->data['species'] = '';
		}

		if (isset($this->request->post['zodiac'])) {
			$this->data['zodiac'] = $this->request->post['zodiac'];
		} elseif (isset($gemstonelist_info)) {
			$this->data['zodiac'] = $gemstonelist_info['zodiac'];
		} else {
			$this->data['zodiac'] = '';
		}

		if (isset($this->request->post['months'])) {
			$this->data['months'] = $this->request->post['months'];
		} elseif (isset($gemstonelist_info)) {
			$this->data['months'] = $gemstonelist_info['months'];
		} else {
			$this->data['months'] = '';
		}

		if (isset($this->request->post['mohshardness'])) {
			$this->data['mohshardness'] = $this->request->post['mohshardness'];
		} elseif (isset($gemstonelist_info)) {
			$this->data['mohshardness'] = $gemstonelist_info['mohshardness'];
		} else {
			$this->data['mohshardness'] = '';
		}

		if (isset($this->request->post['specificgravity'])) {
			$this->data['specificgravity'] = $this->request->post['specificgravity'];
		} elseif (isset($gemstonelist_info)) {
			$this->data['specificgravity'] = $gemstonelist_info['specificgravity'];
		} else {
			$this->data['specificgravity'] = '';
		}

		if (isset($this->request->post['refractiveindex'])) {
			$this->data['refractiveindex'] = $this->request->post['refractiveindex'];
		} elseif (isset($gemstonelist_info)) {
			$this->data['refractiveindex'] = $gemstonelist_info['refractiveindex'];
		} else {
			$this->data['refractiveindex'] = '';
		}

		if (isset($this->request->post['birefringence'])) {
			$this->data['birefringence'] = $this->request->post['birefringence'];
		} elseif (isset($gemstonelist_info)) {
			$this->data['birefringence'] = $gemstonelist_info['birefringence'];
		} else {
			$this->data['birefringence'] = '';
		}

		if (isset($this->request->post['opticsign'])) {
			$this->data['opticsign'] = $this->request->post['opticsign'];
		} elseif (isset($gemstonelist_info)) {
			$this->data['opticsign'] = $gemstonelist_info['opticsign'];
		} else {
			$this->data['opticsign'] = '';
		}

		if (isset($this->request->post['icacode'])) {
			$this->data['icacode'] = $this->request->post['icacode'];
		} elseif (isset($gemstonelist_info)) {
			$this->data['icacode'] = $gemstonelist_info['icacode'];
		} else {
			$this->data['icacode'] = '';
		}

		if (isset($this->request->post['treatment'])) {
			$this->data['treatment'] = $this->request->post['treatment'];
		} elseif (isset($gemstonelist_info)) {
			$this->data['treatment'] = $gemstonelist_info['treatment'];
		} else {
			$this->data['treatment'] = '';
		}

		if (isset($this->request->post['incidence'])) {
			$this->data['incidence'] = $this->request->post['incidence'];
		} elseif (isset($gemstonelist_info)) {
			$this->data['incidence'] = $gemstonelist_info['incidence'];
		} else {
			$this->data['incidence'] = '';
		}

		if (isset($this->request->post['purpose'])) {
			$this->data['purpose'] = $this->request->post['purpose'];
		} elseif (isset($gemstonelist_info)) {
			$this->data['purpose'] = $gemstonelist_info['purpose'];
		} else {
			$this->data['purpose'] = '';
		}

		if (isset($this->request->post['durability'])) {
			$this->data['durability'] = $this->request->post['durability'];
		} elseif (isset($gemstonelist_info)) {
			$this->data['durability'] = $gemstonelist_info['durability'];
		} else {
			$this->data['durability'] = '';
		}

		if (isset($this->request->post['detection'])) {
			$this->data['detection'] = $this->request->post['detection'];
		} elseif (isset($gemstonelist_info)) {
			$this->data['detection'] = $gemstonelist_info['detection'];
		} else {
			$this->data['detection'] = '';
		}

		if (isset($this->request->post['specialcare'])) {
			$this->data['specialcare'] = $this->request->post['specialcare'];
		} elseif (isset($gemstonelist_info)) {
			$this->data['specialcare'] = $gemstonelist_info['specialcare'];
		} else {
			$this->data['specialcare'] = '';
		}

		if (isset($this->request->post['limitations'])) {
			$this->data['limitations'] = $this->request->post['limitations'];
		} elseif (isset($gemstonelist_info)) {
			$this->data['limitations'] = $gemstonelist_info['limitations'];
		} else {
			$this->data['limitations'] = '';
		}
		
		if (isset($this->request->post['image'])) {
			$this->data['image'] = $this->request->post['image'];
		} elseif (!empty($gemstonelist_info)) {
			$this->data['image'] = $gemstonelist_info['image1'];
		} else {
			$this->data['image'] = '';
		}
		
		$this->load->model('tool/image');

		if (isset($gemstonelist_info) && $gemstonelist_info['image1'] && file_exists(DIR_IMAGE . $gemstonelist_info['image1'])) {
			$this->data['thumb'] = $this->model_tool_image->resize($gemstonelist_info['image1'], 100, 100);
		} else {
			$this->data['thumb'] = $this->model_tool_image->resize('no_image.jpg', 100, 100);
		}
		
		$this->data['no_image'] = $this->model_tool_image->resize('no_image.jpg', 100, 100);
	
		$this->template = 'sale/gemstonelist_form.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render()); 
	}

	private function validateForm() {
		if (!$this->user->hasPermission('modify', 'sale/gemstonelist')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		if ((utf8_strlen($this->request->post['gemname']) < 2) || (utf8_strlen($this->request->post['gemname']) > 64)) {
			$this->error['gemname'] = $this->language->get('error_gem');
		}

		if ((utf8_strlen($this->request->post['birthstone']) < 2) || (utf8_strlen($this->request->post['birthstone']) > 64)) {
			$this->error['birthstone'] = $this->language->get('error_birthstone');
		}

		if ((utf8_strlen($this->request->post['anniversary']) < 2) || (utf8_strlen($this->request->post['anniversary']) > 64)) {
			$this->error['anniversary'] = $this->language->get('error_anniversary');
		}

		if ((utf8_strlen($this->request->post['species']) < 2) || (utf8_strlen($this->request->post['species']) > 64)) {
			$this->error['species'] = $this->language->get('error_species');
		}

		if ((utf8_strlen($this->request->post['zodiac']) < 2) || (utf8_strlen($this->request->post['zodiac']) > 64)) {
			$this->error['zodiac'] = $this->language->get('error_zodiac');
		}

		if ((utf8_strlen($this->request->post['months']) < 2) || (utf8_strlen($this->request->post['months']) > 64)) {
			$this->error['months'] = $this->language->get('error_months');
		}

		if ((utf8_strlen($this->request->post['mohshardness']) < 2) || (utf8_strlen($this->request->post['mohshardness']) > 64)) {
			$this->error['mohshardness'] = $this->language->get('error_mohshardness');
		}

		if ((utf8_strlen($this->request->post['specificgravity']) < 2) || (utf8_strlen($this->request->post['specificgravity']) > 64)) {
			$this->error['specificgravity'] = $this->language->get('error_specificgravity');
		}

		if ((utf8_strlen($this->request->post['refractiveindex']) < 2) || (utf8_strlen($this->request->post['refractiveindex']) > 64)) {
			$this->error['refractiveindex'] = $this->language->get('error_refractiveindex');
		}

		if ((utf8_strlen($this->request->post['birefringence']) < 2) || (utf8_strlen($this->request->post['birefringence']) > 64)) {
			$this->error['birefringence'] = $this->language->get('error_birefringence');
		}

		if ((utf8_strlen($this->request->post['opticsign']) < 2) || (utf8_strlen($this->request->post['opticsign']) > 64)) {
			$this->error['opticsign'] = $this->language->get('error_opticsign');
		}

		if ((utf8_strlen($this->request->post['icacode']) < 2) || (utf8_strlen($this->request->post['icacode']) > 64)) {
			$this->error['icacode'] = $this->language->get('error_icacode');
		}

		if ((utf8_strlen($this->request->post['treatment']) < 2) || (utf8_strlen($this->request->post['treatment']) > 64)) {
			$this->error['treatment'] = $this->language->get('error_treatment');
		}

		if ((utf8_strlen($this->request->post['incidence']) < 2) || (utf8_strlen($this->request->post['incidence']) > 64)) {
			$this->error['incidence'] = $this->language->get('error_incidence');
		}

		if ((utf8_strlen($this->request->post['purpose']) < 2) || (utf8_strlen($this->request->post['purpose']) > 64)) {
			$this->error['purpose'] = $this->language->get('error_purpose');
		}

		if ((utf8_strlen($this->request->post['durability']) < 2) || (utf8_strlen($this->request->post['durability']) > 64)) {
			$this->error['durability'] = $this->language->get('error_durability');
		}

		if ((utf8_strlen($this->request->post['detection']) < 2) || (utf8_strlen($this->request->post['detection']) > 64)) {
			$this->error['detection'] = $this->language->get('error_detection');
		}

		if ((utf8_strlen($this->request->post['specialcare']) < 2) || (utf8_strlen($this->request->post['specialcare']) > 64)) {
			$this->error['specialcare'] = $this->language->get('error_specialcare');
		}

		if ((utf8_strlen($this->request->post['limitations']) < 2) || (utf8_strlen($this->request->post['limitations']) > 64)) {
			$this->error['limitations'] = $this->language->get('error_limitations');
		}
		
		if (!$this->request->post['image']) {
			$this->error['image'] = $this->language->get('error_image');
		}

		if (!$this->error) {
			return true;
		} else {
			return false;
		}
	}

	private function validateDelete() {
		if (!$this->user->hasPermission('modify', 'sale/gemstonelist')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}
		
		$this->load->model('setting/store');
		$this->load->model('sale/customer');
      	
		foreach ($this->request->post['selected'] as $gemstone_id) {
    		if ($this->config->get('config_gemstonelist_id') == $gemstone_id) {
	  			$this->error['warning'] = $this->language->get('error_default');	
			}  
			
			$store_total = $this->model_setting_store->getTotalStoresByCustomerGroupId($gemstone_id);

			if ($store_total) {
				$this->error['warning'] = sprintf($this->language->get('error_store'), $store_total);
			}
			
			$customer_total = $this->model_sale_customer->getTotalCustomersByCustomerGroupId($gemstone_id);

			if ($customer_total) {
				$this->error['warning'] = sprintf($this->language->get('error_customer'), $customer_total);
			}
		}
		
		if (!$this->error) {
			return true;
		} else {
			return false;
		}
	}
}
?>