<?php
class ModelCatalogVote extends Model {
	public function addVote($data) {
      	$this->db->query("INSERT INTO " . DB_PREFIX . "vote SET name = '" . $this->db->escape($data['name']) . "', sort_order = '" . (int)$data['sort_order'] . "'");
		
		$vote_id = $this->db->getLastId();

		if (isset($data['image'])) {
			$this->db->query("UPDATE " . DB_PREFIX . "vote SET image = '" . $this->db->escape($data['image']) . "' WHERE vote_id = '" . (int)$vote_id . "'");
		}
		
		if (isset($data['vote_store'])) {
			foreach ($data['vote_store'] as $store_id) {
				$this->db->query("INSERT ignore INTO " . DB_PREFIX . "vote_to_store SET vote_id = '" . (int)$vote_id . "', store_id = '" . (int)$store_id . "'");
			}
		}
				
		if ($data['keyword']) {
			$this->db->query("INSERT INTO " . DB_PREFIX . "url_alias SET query = 'vote_id=" . (int)$vote_id . "', keyword = '" . $this->db->escape($data['keyword']) . "'");
		}
		
		$this->cache->delete('vote');
	}
	
	public function editVote($vote_id, $data) {
      	$this->db->query("UPDATE " . DB_PREFIX . "vote SET name = '" . $this->db->escape($data['name']) . "', sort_order = '" . (int)$data['sort_order'] . "' WHERE vote_id = '" . (int)$vote_id . "'");

		if (isset($data['image'])) {
			$this->db->query("UPDATE " . DB_PREFIX . "vote SET image = '" . $this->db->escape($data['image']) . "' WHERE vote_id = '" . (int)$vote_id . "'");
		}
		
		$this->db->query("DELETE FROM " . DB_PREFIX . "vote_to_store WHERE vote_id = '" . (int)$vote_id . "'");

		if (isset($data['vote_store'])) {
			foreach ($data['vote_store'] as $store_id) {
				$this->db->query("INSERT ignore INTO " . DB_PREFIX . "vote_to_store SET vote_id = '" . (int)$vote_id . "', store_id = '" . (int)$store_id . "'");
			}
		}
			
		$this->db->query("DELETE FROM " . DB_PREFIX . "url_alias WHERE query = 'vote_id=" . (int)$vote_id. "'");
		
		if ($data['keyword']) {
			$this->db->query("INSERT INTO " . DB_PREFIX . "url_alias SET query = 'vote_id=" . (int)$vote_id . "', keyword = '" . $this->db->escape($data['keyword']) . "'");
		}
		
		$this->cache->delete('vote');
	}
	
	public function deleteVote($vote_id) {
		$this->db->query("DELETE FROM " . DB_PREFIX . "vote WHERE vote_id = '" . (int)$vote_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "vote_to_store WHERE vote_id = '" . (int)$vote_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "url_alias WHERE query = 'vote_id=" . (int)$vote_id . "'");
			
		$this->cache->delete('vote');
	}	
	
	public function getVote($vote_id) {
		$query = $this->db->query("SELECT DISTINCT *, (SELECT keyword FROM " . DB_PREFIX . "url_alias WHERE query = 'vote_id=" . (int)$vote_id . "') AS keyword FROM " . DB_PREFIX . "vote WHERE vote_id = '" . (int)$vote_id . "'");
		
		return $query->row;
	}
	
	public function getVotes($data = array()) {
		if ($data) {
			$sql = "SELECT * FROM " . DB_PREFIX . "vote";
			
			$sort_data = array(
				'name',
				'sort_order'
			);	
			
			if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
				$sql .= " ORDER BY " . $data['sort'];	
			} else {
				$sql .= " ORDER BY name";	
			}
			
			if (isset($data['order']) && ($data['order'] == 'DESC')) {
				$sql .= " DESC";
			} else {
				$sql .= " ASC";
			}
			
			if (isset($data['start']) || isset($data['limit'])) {
				if ($data['start'] < 0) {
					$data['start'] = 0;
				}					

				if ($data['limit'] < 1) {
					$data['limit'] = 20;
				}	
			
				$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
			}				
			
			$query = $this->db->query($sql);
		
			return $query->rows;
		} else {
			$vote_data = $this->cache->get('vote');
		
			if (!$vote_data) {
				$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "vote ORDER BY name");
	
				$vote_data = $query->rows;
			
				$this->cache->set('vote', $vote_data);
			}
		 
			return $vote_data;
		}
	}
	
	public function getVoteStores($vote_id) {
		$vote_store_data = array();
		
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "vote_to_store WHERE vote_id = '" . (int)$vote_id . "'");

		foreach ($query->rows as $result) {
			$vote_store_data[] = $result['store_id'];
		}
		
		return $vote_store_data;
	}
	
	public function getTotalVotesByImageId($image_id) {
      	$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "vote WHERE image_id = '" . (int)$image_id . "'");

		return $query->row['total'];
	}

	public function getTotalVotes() {
      	$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "vote");
		
		return $query->row['total'];
	}	
}
?>