<?php
class ModelSaleGemstonelist extends Model {
	public function addCustomerGroup($data) {
		$this->db->query("INSERT INTO " . DB_PREFIX . "gemstone SET gemname = '" . $this->db->escape($data['gemname']) . "',category_display = '" . $this->db->escape($data['category_display']) . "',gemdetail = '" . $this->db->escape($data['gemdetail']) . "',gemdescr = '" . $this->db->escape($data['gemdescr']) . "',image1 = '" . $this->db->escape($data['image']) . "',birthstone = '" . $this->db->escape($data['birthstone']) . "',anniversary = '" . $this->db->escape($data['anniversary']) . "',species = '" . $this->db->escape($data['species']) . "',zodiac = '" . $this->db->escape($data['zodiac']) . "',months = '" . $this->db->escape($data['months']) . "',mohshardness = '" . $this->db->escape($data['mohshardness']) . "',specificgravity = '" . $this->db->escape($data['specificgravity']) . "',refractiveindex = '" . $this->db->escape($data['refractiveindex']) . "',birefringence = '" . $this->db->escape($data['birefringence']) . "',opticsign = '" . $this->db->escape($data['opticsign']) . "',icacode = '" . $this->db->escape($data['icacode']) . "',treatment = '" . $this->db->escape($data['treatment']) . "',incidence = '" . $this->db->escape($data['incidence']) . "',purpose = '" . $this->db->escape($data['purpose']) . "',durability = '" . $this->db->escape($data['durability']) . "',detection = '" . $this->db->escape($data['detection']) . "',specialcare = '" . $this->db->escape($data['specialcare']) . "',sort_order = '" . $this->db->escape($data['sort_order']) . "',limitations = '" . $this->db->escape($data['limitations']) . "'");
	}
	
	public function editCustomerGroup($gemstone_id, $data) {
		$this->db->query("UPDATE " . DB_PREFIX . "gemstone SET gemname = '" . $this->db->escape($data['gemname']) . "',category_display = '" . $this->db->escape($data['category_display']) . "',gemdetail = '" . $this->db->escape($data['gemdetail']) . "',gemdescr = '" . $this->db->escape($data['gemdescr']) . "',image1 = '" . $this->db->escape($data['image']) . "',birthstone = '" . $this->db->escape($data['birthstone']) . "' ,anniversary = '" . $this->db->escape($data['anniversary']) . "',species = '" . $this->db->escape($data['species']) . "',zodiac = '" . $this->db->escape($data['zodiac']) . "',months = '" . $this->db->escape($data['months']) . "',mohshardness = '" . $this->db->escape($data['mohshardness']) . "',specificgravity = '" . $this->db->escape($data['specificgravity']) . "',refractiveindex = '" . $this->db->escape($data['refractiveindex']) . "',birefringence = '" . $this->db->escape($data['birefringence']) . "',opticsign = '" . $this->db->escape($data['opticsign']) . "',icacode = '" . $this->db->escape($data['icacode']) . "',treatment = '" . $this->db->escape($data['treatment']) . "',incidence = '" . $this->db->escape($data['incidence']) . "',purpose = '" . $this->db->escape($data['purpose']) . "',durability = '" . $this->db->escape($data['durability']) . "',detection = '" . $this->db->escape($data['detection']) . "',specialcare = '" . $this->db->escape($data['specialcare']) . "',sort_order = '" . $this->db->escape($data['sort_order']) . "',limitations = '" . $this->db->escape($data['limitations']) . "' WHERE gemstone_id = '" . (int)$gemstone_id . "'");
	}
	
	public function deleteCustomerGroup($gemstone_id) {
		$this->db->query("DELETE FROM " . DB_PREFIX . "gemstone WHERE gemstone_id = '" . (int)$gemstone_id . "'");
	//	$this->db->query("DELETE FROM " . DB_PREFIX . "product_discount WHERE customer_group_id = '" . (int)$customer_group_id . "'");
	}
	
	public function getCustomerGroup($gemstone_id) {
		$query = $this->db->query("SELECT DISTINCT * FROM " . DB_PREFIX . "gemstone WHERE gemstone_id = '" . (int)$gemstone_id . "'");
		
		return $query->row;
	}
	
	public function getCustomerGroups($data = array()) {
		$sql = "SELECT * FROM " . DB_PREFIX . "gemstone";
		
		$sql .= " ORDER BY gemname";	
			
		if (isset($data['order']) && ($data['order'] == 'DESC')) {
			$sql .= " DESC";
		} else {
			$sql .= " ASC";
		}
		
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}			

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}	
			
			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}
			
		$query = $this->db->query($sql);
		
		return $query->rows;
	}
	
	public function getTotalCustomerGroups() {
		$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "gemstone");
		
		return $query->row['total'];
	}
}
?>