<?php
/*
 * simonfilters - 2.5.0 Build 0011
*/

class ControllerModuleFilter extends Controller {
    private $error = array();
    private $supported_themes = array();
    private $defaultCSS = array();
    private $SFs_version = 'simonfilters - 2.5.0 Build 0011';

    public function managecache() {
        $allowedRoutes = Array(
                "catalog/product/update",
                "module/filter"
        );

        if(in_array($this->request->get['route'], $allowedRoutes)) {
            $this->cache->delete("simonfilters");
            $simonfilterstimestamp = time();
            $this->db->query("UPDATE ". DB_PREFIX ."setting s SET s.value='{$simonfilterstimestamp}' WHERE s.key='simonfilterstimestamp'");
        }
    }

    public function rebuildclientside() {
        $this->cache->delete("simonfilters");
        $this->cache->delete("product");
        $simonfilterstimestamp = time();
        $this->db->query("UPDATE ". DB_PREFIX ."setting s SET s.value='{$simonfilterstimestamp}' WHERE s.key='simonfilterstimestamp'");

        $vqmoddir = preg_replace('/system[\\|\/]$/','vqmod/vqcache',DIR_SYSTEM);
        $files = glob("$vqmoddir/*product*");
        if ($files) {
            foreach ($files as $file) {
                if (file_exists($file)) {
                    unlink($file);
                }
            }
        }
    }

    public function getdomids() {
        $template = $this->config->get('config_template');
        $html = @file_get_contents("http://www.simonoop.com/simonservices/opencart/mymodules/simonfilters/getdomid.php?theme={$template}",0);
        echo $html;
    }

    public function fillcss() {

        $this->defaultCSS['default']=
                array(
                "orientation"=>"vertical",
                "collapsible"=>"0",
                "css"=>
                "/*************************************************************
common
*************************************************************/
div.box.simonfilters ul{
    list-style: none;
    margin: 0;
    padding: 0;
}

div.box.simonfilters .filter_title{
    font-weight: bold;
    color:red;
    border-bottom: 1px solid #eaeaea;
    padding-top:4px
}

div.box.simonfilters .clear_filters_global,
div.box.simonfilters .clear_filters_local{
    float:right;
    color:#38B0E3;
    cursor:pointer;
    clear:right;
}

div.box.simonfilters .add_filter{
    padding:3px;
    font-size: 12px;
    font-weight: bold;
    cursor:pointer;
    color:#38B0E3;
    clear:right;
}

/*************************************************************
default specific
*************************************************************/
div.box.simonfilters li.checked{
    display:none;
}


/************************************************************
extras
************************************************************/
div.box.simonfilters .clear_filters_local_container{
  display:inline;
}

div.box.simonfilters .clear_filters_global,
div.box.simonfilters .clear_filters_local{
  display:none;
}

div.box.simonfilters .clear_filters_global_container{

}
");

        $this->defaultCSS['checkbox']=
                array(
                "orientation"=>"vertical",
                "collapsible"=>"0",
                "css"=>
                "/*************************************************************
common
*************************************************************/
div.box.simonfilters ul{
    list-style: none;
    margin: 0;
    padding: 0;
}

div.box.simonfilters .filter_title{
    font-weight: bold;
    color:red;
    border-bottom: 1px solid #eaeaea;
    padding-top:4px
}

div.box.simonfilters .clear_filters_global,
div.box.simonfilters .clear_filters_local{
  float:right;
  color:#38B0E3;
  cursor:pointer;
  clear:right;
}

div.box.simonfilters .add_filter{
    padding:3px;
    font-size: 12px;
    font-weight: bold;
    cursor:pointer;
    color:#38B0E3;
    clear:right;
}

/************************************************************
checkbox specific
************************************************************/

div.box.simonfilters .unchecked{
    padding: 2px 3px 3px 20px;
    background-repeat: no-repeat !important;
    background: url(\"image/simonfilters/check_small_off.png\");
}
div.box.simonfilters .checked{
    padding: 2px 3px 3px 20px;
    background-repeat: no-repeat !important;
    background: url(\"image/simonfilters/check_small_on.png\");
}

/************************************************************
extras
************************************************************/
div.box.simonfilters .clear_filters_local_container{

}

div.box.simonfilters .clear_filters_global,
div.box.simonfilters .clear_filters_local{
  display:none;
}

div.box.simonfilters .clear_filters_global_container{

}
                ");

        $this->defaultCSS['dropdown']=
                array(
                "orientation"=>"vertical",
                "collapsible"=>"1",
                "css"=>
                "/*************************************************************
common
*************************************************************/
div.box.simonfilters ul{
    list-style: none;
    margin: 0;
    padding: 0;
}

div.box.simonfilters .filter_title{
    font-weight: bold;
    color:red;
    border-bottom: 1px solid #eaeaea;
    padding-top:4px
}

div.box.simonfilters .clear_filters_global,
div.box.simonfilters .clear_filters_local{
    float:right;
    color:#38B0E3;
    cursor:pointer;
    clear:right;
}

div.box.simonfilters .add_filter{
    padding:3px;
    font-size: 12px;
    font-weight: bold;
    cursor:pointer;
    color:#38B0E3;
    clear:right;
}

/************************************************************
checkbox specific
************************************************************/

div.box.simonfilters .unchecked{
    padding: 2px 3px 3px 20px;
    background-repeat: no-repeat !important;
    background: url(\"image/simonfilters/check_small_off.png\");
}
div.box.simonfilters .checked{
    padding: 2px 3px 3px 20px;
    background-repeat: no-repeat !important;
    background: url(\"image/simonfilters/check_small_on.png\");
}

/************************************************************
dropdown specific
************************************************************/
div.box.simonfilters div.filter_title{
    cursor:pointer;
}

div.box.simonfilters .expanded{
    padding: 2px 3px 3px 20px;
    background: url(\"image/simonfilters/collapse.png\");
    background-repeat: no-repeat;
    background-position:0px 4px;
}

div.box.simonfilters .collapsed{
    padding: 2px 3px 3px 20px;
    background: url(\"image/simonfilters/expand.png\");
    background-repeat: no-repeat;
    background-position:0px 4px;
}

/************************************************************
extras
************************************************************/
div.box.simonfilters .clear_filters_local_container{
    display:none;
}
div.box.simonfilters .clear_filters_global_container{
    display:inline;
}
div.box.simonfilters .filter_title{
  position:relative;
  left:-15px;
  padding-left:15px;
}

");

        $this->defaultCSS['horizontal']=
                array(
                "orientation"=>"horizontal",
                "collapsible"=>"0",
                "css"=>
                "/*************************************************************
common
*************************************************************/
div.box.simonfilters ul{
    list-style: none;
    margin: 0;
    padding: 0;
}

div.box.simonfilters .filter_title{
    font-weight: bold;
    color:red;
    border-bottom: 1px solid #eaeaea;
    padding-top:4px
}

div.box.simonfilters .clear_filters_global,
div.box.simonfilters .clear_filters_local{
    float:right;
    color:#38B0E3;
    cursor:pointer;
    display:none;
    clear:right;
}

div.box.simonfilters .add_filter{
    padding:3px;
    padding-left:15px;
    font-size: 12px;
    font-weight: bold;
    cursor:pointer;
    color:#38B0E3;
    clear:right;
}

div.box.simonfilters .filter_title{
    background-color: #eee;
    padding:2px;
    font-family: Verdana, Geneva, sans-serif;
    font-size: 11px;
    font-weight: bold;
    width:100%;
}

div.box.simonfilters td{
    padding:0px;
    white-space:nowrap;
}

div.box.simonfilters ul. table{
    width:100%;
    border-bottom:1px solid #dadada;
}

div.box.simonfilters ul  li:last-child table{
    border:0px;
}

div.box.simonfilters ul tr td:first-child{
    padding-left: 2px;
    padding-right: 10px;
}

div.box.simonfilters li.add_filter
, li.separator{
    float:left;
    padding:0px;
    padding-right:5px;
}

div.box.simonfilters .filter_ul li:last-child{
    display: none;
}

div.box.simonfilters .checked{
    font-style:italic;
    color:#a1a1a1;
}
");

    }


    public function getDefaultCSS() {

        $this->fillcss();
        $stylename = $this->request->post['stylename'];
        echo $this->defaultCSS[$stylename]['css'];
    }


    public function index() {

        $this->fillcss();


        if($this->config->get('simonfilters_allow_debug_data')=='1') {
            @file_get_contents("http://www.simonoop.com/simonservices/opencart/mymodules/simonfilters/allowed.php?email=". urlencode($this->config->get('config_email')) ."&theme=". urlencode($this->config->get('config_template')) ."&OC_version=".VERSION."&SFs_version=". urlencode($this->SFs_version) ,0);
        }

        $this->load->language('module/filter');
        $this->document->addStyle("view/stylesheet/simonfilters.css");
        $this->document->addScript('view/javascript/simonoop/simonsaveandstayforsimonfilters.js');

        $this->document->setTitle($this->language->get('heading_title'));
        $this->load->model('setting/setting');

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {

            if (!is_numeric($this->request->post["simonfilters_slider_step"])) {
                $this->request->post["simonfilters_slider_step"]="5";
            }

            $cansave=true;
            foreach ( $this->request->post as $key => $value) {
                if (is_array($value)) {
                    $structlen = strlen ($this->db->escape(serialize($value)));
                    if($structlen >= 65535 ) {
                        $cansave=false;
                        switch($key) {
                            case 'activefilter_simonfilters_attribute':
                                $message = "Attributes";
                                break;
                            case 'activefilter_simonfilters_options':
                                $message = "Options";
                                break;
                            case 'activefilter_simonfilters_tags':
                                $message = "Tags";
                                break;
                            case 'activefilter_simonfilters_manufacturer':
                                $message = "Manufacturers";
                                break;
                        }
                        $perc = 100*$structlen/65535-100;
                        $arilen = count($value);
                        $nitems = $arilen * $perc / 100;
                        $this->error['warning']="ERROR! Data Structure in filter category <b>{$message}</b> is greater than what the database can handle.<br><br>Max length is <b>65535</b> bytes and the structure you want to save is <b>{$structlen}</b> bytes.<br><br> Please disable some filters in that category.<br><br>Press <a href='#' key='$key' nitems='{$nitems}' class='button' id='disable10'><span>HERE</span></a> to disable enough items to be able to save. An estimate of the number of items needed will be made and the items at the end of your list will be disabled. Try to save again after clicking and disable further items if needed until this message is gone. <br><br><b>NOTICE:</b>This is a limitation of OpenCart, not SimonFilters.";
                    }
                }
            }


            if($cansave) {
                #die(var_dump($this->request->post));
                $this->request->post['simonfilterstimestamp']=time();
                $this->model_setting_setting->editSetting('filter', $this->request->post);
                $this->session->data['success'] = $this->language->get('text_success');
                $this->redirect($this->url->link('extension/module', 'token=' . $this->session->data['token'], 'SSL'));
            }
        }

        $this->data['heading_title'] = $this->language->get('heading_title');

        $this->data['text_enabled'] = $this->language->get('text_enabled');
        $this->data['text_disabled'] = $this->language->get('text_disabled');
        $this->data['text_content_top'] = $this->language->get('text_content_top');
        $this->data['text_content_bottom'] = $this->language->get('text_content_bottom');
        $this->data['text_column_left'] = $this->language->get('text_column_left');
        $this->data['text_column_right'] = $this->language->get('text_column_right');

        $this->data['entry_layout'] = $this->language->get('entry_layout');
        $this->data['entry_position'] = $this->language->get('entry_position');
        $this->data['entry_status'] = $this->language->get('entry_status');
        $this->data['entry_sort_order'] = $this->language->get('entry_sort_order');

        $this->data['button_save'] = $this->language->get('button_save');
        $this->data['button_cancel'] = $this->language->get('button_cancel');
        $this->data['button_add_module'] = $this->language->get('button_add_module');
        $this->data['button_remove'] = $this->language->get('button_remove');

        if (isset($this->error['warning'])) {
            $this->data['error_warning'] = $this->error['warning'];
        } else {
            $this->data['error_warning'] = '';
        }

        $this->data['breadcrumbs'] = array();

        $this->data['breadcrumbs'][] = array(
                'text'      => $this->language->get('text_home'),
                'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
                'separator' => false
        );

        $this->data['breadcrumbs'][] = array(
                'text'      => $this->language->get('text_module'),
                'href'      => $this->url->link('extension/module', 'token=' . $this->session->data['token'], 'SSL'),
                'separator' => ' :: '
        );

        $this->data['breadcrumbs'][] = array(
                'text'      => $this->language->get('heading_title'),
                'href'      => $this->url->link('module/filter', 'token=' . $this->session->data['token'], 'SSL'),
                'separator' => ' :: '
        );

        $this->data['action'] = $this->url->link('module/filter', 'token=' . $this->session->data['token'], 'SSL');

        $this->data['cancel'] = $this->url->link('extension/module', 'token=' . $this->session->data['token'], 'SSL');

        $this->data['modules'] = array();

        if (isset($this->request->post['filter_module'])) {
            $this->data['modules'] = $this->request->post['filter_module'];
        } elseif ($this->config->get('filter_module')) {
            $this->data['modules'] = $this->config->get('filter_module');
        }

        $this->load->model('design/layout');

        $this->data['layouts'] = $this->model_design_layout->getLayouts();

        /* SimonFilters */


        $this->load->model('catalog/filter');

        $this->data['allfilters'] = $this->model_catalog_filter->getPossibleFilters($this->config->get('config_language_id'));

        if (isset($this->request->post['activefilter_simonfilters_attribute'])) {
            $this->data['activefilter_simonfilters_attribute'] = $this->request->post['activefilter_simonfilters_attribute'];
        } else {
            $this->data['activefilter_simonfilters_attribute'] = $this->config->get('activefilter_simonfilters_attribute');
        }

        if (isset($this->request->post['activefilter_simonfilters_options'])) {
            $this->data['activefilter_simonfilters_options'] = $this->request->post['activefilter_simonfilters_options'];
        } else {
            $this->data['activefilter_simonfilters_options'] = $this->config->get('activefilter_simonfilters_options');
        }

        if (isset($this->request->post['activefilter_simonfilters_manufacturer'])) {
            $this->data['activefilter_simonfilters_manufacturer'] = $this->request->post['activefilter_simonfilters_manufacturer'];
        } else {
            $this->data['activefilter_simonfilters_manufacturer'] = $this->config->get('activefilter_simonfilters_manufacturer');
        }

        if (isset($this->request->post['activefilter_simonfilters_stock'])) {
            $this->data['activefilter_simonfilters_stock'] = $this->request->post['activefilter_simonfilters_stock'];
        } else {
            $this->data['activefilter_simonfilters_stock'] = $this->config->get('activefilter_simonfilters_stock');
        }

        if (isset($this->request->post['activefilter_simonfilters_price'])) {
            $this->data['activefilter_simonfilters_price'] = $this->request->post['activefilter_simonfilters_price'];
        } else {
            $this->data['activefilter_simonfilters_price'] = $this->config->get('activefilter_simonfilters_price');
        }

        if (isset($this->request->post['activefilter_simonfilters_tags'])) {
            $this->data['activefilter_simonfilters_tags'] = $this->request->post['activefilter_simonfilters_tags'];
        } else {
            $this->data['activefilter_simonfilters_tags'] = $this->config->get('activefilter_simonfilters_tags');
        }

        if (isset($this->request->post['activefilter_simonfilters_categories'])) {
            $this->data['activefilter_simonfilters_categories'] = $this->request->post['activefilter_simonfilters_categories'];
        } else {
            $this->data['activefilter_simonfilters_categories'] = $this->config->get('activefilter_simonfilters_categories');
        }

        if (isset($this->request->post['simonfilters_category_domid'])) {
            $this->data['simonfilters_category_domid'] = $this->request->post['simonfilters_category_domid'];

        } else {
            $this->data['simonfilters_category_domid'] = $this->config->get('simonfilters_category_domid');
            if(!isset($this->data['simonfilters_category_domid']['default'])) {
                $this->data['simonfilters_category_domid']['default']='#content';
            }
        }

        if (isset($this->request->post['simonfilters_manufacturer_domid'])) {
            $this->data['simonfilters_manufacturer_domid'] = $this->request->post['simonfilters_manufacturer_domid'];
        } else {
            $this->data['simonfilters_manufacturer_domid'] = $this->config->get('simonfilters_manufacturer_domid');
            if(!isset($this->data['simonfilters_manufacturer_domid']['default'])) {
                $this->data['simonfilters_manufacturer_domid']['default']='#content';
            }
        }

        if (isset($this->request->post['simonfilters_homepage_domid'])) {
            $this->data['simonfilters_homepage_domid'] = $this->request->post['simonfilters_homepage_domid'];
        } else {
            $this->data['simonfilters_homepage_domid'] = $this->config->get('simonfilters_homepage_domid');
            if(!isset($this->data['simonfilters_homepage_domid']['default'])) {
                $this->data['simonfilters_homepage_domid']['default']='#content';
            }
        }

        if (isset($this->request->post['simonfilters_search_domid'])) {
            $this->data['simonfilters_search_domid'] = $this->request->post['simonfilters_search_domid'];
        } else {
            $this->data['simonfilters_search_domid'] = $this->config->get('simonfilters_search_domid');
            if(!isset($this->data['simonfilters_search_domid']['default'])) {
                $this->data['simonfilters_search_domid']['default']='#content';
            }
        }

        if (isset($this->request->post['simonfilters_product_domid'])) {
            $this->data['simonfilters_product_domid'] = $this->request->post['simonfilters_product_domid'];
        } else {
            $this->data['simonfilters_product_domid'] = $this->config->get('simonfilters_product_domid');
            if(!isset($this->data['simonfilters_product_domid']['default'])) {
                $this->data['simonfilters_product_domid']['default']='#content';
            }
        }

        if (isset($this->request->post['simonfilters_force_siblings'])) {
            $this->data['simonfilters_force_siblings'] = $this->request->post['simonfilters_force_siblings'];
        } else {
            $this->data['simonfilters_force_siblings'] = $this->config->get('simonfilters_force_siblings');
        }

        if (isset($this->request->post['simonfilters_persist'])) {
            $this->data['simonfilters_persist'] = $this->request->post['simonfilters_persist'];
        } else {
            $this->data['simonfilters_persist'] = $this->config->get('simonfilters_persist');
        }

        if (isset($this->request->post['simonfilters_allow_debug_data'])) {
            $this->data['simonfilters_allow_debug_data'] = $this->request->post['simonfilters_allow_debug_data'];
        } else {
            $this->data['simonfilters_allow_debug_data'] = $this->config->get('simonfilters_allow_debug_data');
        }

        if (isset($this->request->post['simonfilters_front_end_diagnostics'])) {
            $this->data['simonfilters_front_end_diagnostics'] = $this->request->post['simonfilters_front_end_diagnostics'];
        } else {
            $this->data['simonfilters_front_end_diagnostics'] = $this->config->get('simonfilters_front_end_diagnostics');
        }

        $this->data['simonfilters_styles'] = array();

        if (isset($this->request->post['simonfilters_styles'])) {
            $this->data['simonfilters_styles'] = $this->request->post['simonfilters_styles'];
        } elseif ($this->config->get('simonfilters_styles')) {
            $this->data['simonfilters_styles'] = $this->config->get('simonfilters_styles');
        }

        if (!count($this->config->get('simonfilters_styles'))) {
            foreach($this->defaultCSS as $csskey=>$cssari) {
                $this->data['simonfilters_styles'][]=array(
                        'name'=>$csskey
                        , 'css'=>$cssari['css']
                        , 'orientation'=>$cssari['orientation']
                        , 'collapsible'=>$cssari['collapsible']
                );
            }
        }
        if (isset($this->request->post['simonfilters_sort'])) {
            $this->data['simonfilters_sort'] = $this->request->post['simonfilters_sort'];
        } else {
            $this->data['simonfilters_sort'] = $this->config->get('simonfilters_sort')!=''?$this->config->get('simonfilters_sort'):'a,o,t,m,s,p';
        }
        if(!preg_match('/c/',$this->data['simonfilters_sort']))$this->data['simonfilters_sort'].=',c';

        if (isset($this->request->post['simonfilters_enable_attribute_separator'])) {
            $this->data['simonfilters_enable_attribute_separator'] = $this->request->post['simonfilters_enable_attribute_separator'];
        } else {
            $this->data['simonfilters_enable_attribute_separator'] = $this->config->get('simonfilters_enable_attribute_separator');
        }

        if (isset($this->request->post['simonfilters_attribute_separator_char'])) {
            $this->data['simonfilters_attribute_separator_char'] = $this->request->post['simonfilters_attribute_separator_char'];
        } else {
            $this->data['simonfilters_attribute_separator_char'] = $this->config->get('simonfilters_attribute_separator_char');
        }

        if (isset($this->request->post['simonfilters_option_zero_quantity'])) {
            $this->data['simonfilters_option_zero_quantity'] = $this->request->post['simonfilters_option_zero_quantity'];
        } else {
            $this->data['simonfilters_option_zero_quantity'] = $this->config->get('simonfilters_option_zero_quantity');
        }

        if (isset($this->request->post['simonfilters_dynamic'])) {
            $this->data['simonfilters_dynamic'] = $this->request->post['simonfilters_dynamic'];
        } else {
            $this->data['simonfilters_dynamic'] = $this->config->get('simonfilters_dynamic');
        }

        if (isset($this->request->post['simonfilters_force_all'])) {
            $this->data['simonfilters_force_all'] = $this->request->post['simonfilters_force_all'];
        } else {
            $this->data['simonfilters_force_all'] = $this->config->get('simonfilters_force_all');
        }


        if (isset($this->request->post['simonfilters_slider_step'])) {
            $this->data['simonfilters_slider_step'] = $this->request->post['simonfilters_slider_step'];
        } else {
            $this->data['simonfilters_slider_step'] = $this->config->get('simonfilters_slider_step');
        }
        if($this->data['simonfilters_slider_step']=='')$this->data['simonfilters_slider_step']=5;


        if (isset($this->request->post['simonfilters_script_ignore_text'])) {
            $this->data['simonfilters_script_ignore_text'] = $this->request->post['simonfilters_script_ignore_text'];
        } else {
            $this->data['simonfilters_script_ignore_text'] = $this->config->get('simonfilters_script_ignore_text');
        }
        if($this->data['simonfilters_script_ignore_text']=='')$this->data['simonfilters_script_ignore_text']='';

        if (isset($this->request->post['simonfilters_script_ignore'])) {
            $this->data['simonfilters_script_ignore'] = $this->request->post['simonfilters_script_ignore'];
        } else {
            $this->data['simonfilters_script_ignore'] = $this->config->get('simonfilters_script_ignore');
        }
        if($this->data['simonfilters_script_ignore_text']=='')$this->data['simonfilters_script_ignore']=0;

        if (isset($this->request->post['client_side_items_sorting'])) {
            $this->data['client_side_items_sorting'] = $this->request->post['client_side_items_sorting'];
        } else {
            $this->data['client_side_items_sorting'] = $this->config->get('client_side_items_sorting');
        }

        if (isset($this->request->post['activefilter_simonfilters_stock_instock'])) {
            $this->data['activefilter_simonfilters_stock_instock'] = $this->request->post['activefilter_simonfilters_stock_instock'];
        } else {
            $this->data['activefilter_simonfilters_stock_instock'] = $this->config->get('activefilter_simonfilters_stock_instock');
        }

        if (isset($this->request->post['simonfilters_delete_cache_for_debug'])) {
            $this->data['simonfilters_delete_cache_for_debug'] = $this->request->post['simonfilters_delete_cache_for_debug'];
        } else {
            $this->data['simonfilters_delete_cache_for_debug'] = $this->config->get('simonfilters_delete_cache_for_debug');
        }

        if (isset($this->request->post['activefilter_simonfilters_options_behavior'])) {
            $this->data['activefilter_simonfilters_options_behavior'] = $this->request->post['activefilter_simonfilters_options_behavior'];
        } else {
            $this->data['activefilter_simonfilters_options_behavior'] = $this->config->get('activefilter_simonfilters_options_behavior');
        }

        if (isset($this->request->post['activefilter_simonfilters_attributes_behavior'])) {
            $this->data['activefilter_simonfilters_attributes_behavior'] = $this->request->post['activefilter_simonfilters_attributes_behavior'];
        } else {
            $this->data['activefilter_simonfilters_attributes_behavior'] = $this->config->get('activefilter_simonfilters_attributes_behavior');
        }

        if (isset($this->request->post['activefilter_simonfilters_expanded'])) {
            $this->data['activefilter_simonfilters_expanded'] = $this->request->post['activefilter_simonfilters_expanded'];
        } else {
            $this->data['activefilter_simonfilters_expanded'] = $this->config->get('activefilter_simonfilters_expanded');
        }

        if (isset($this->request->post['simonfilters_disableajax'])) {
            $this->data['simonfilters_disableajax'] = $this->request->post['simonfilters_disableajax'];
        } else {
            $this->data['simonfilters_disableajax'] = $this->config->get('simonfilters_disableajax');
        }


        $this->load->model('localisation/stock_status');
        $this->data['stock_statuses'] = $this->model_localisation_stock_status->getStockStatuses();

        $this->data['entry_SFs_version'] = $this->SFs_version;

        $this->data['entry_display_type'] = $this->language->get('entry_display_type');
        $this->data['entry_display_type_vertical'] = $this->language->get('entry_display_type_vertical');
        $this->data['entry_display_totals'] = $this->language->get('entry_display_totals');
        $this->data['entry_active_filters'] = $this->language->get('entry_active_filters');

        $this->data['entry_active_filters_attribute'] = $this->language->get('entry_active_filters_attribute');
        $this->data['entry_theme_config'] = $this->language->get('entry_theme_config');
        $this->data['entry_styles'] = $this->language->get('entry_styles');
        $this->data['entry_active_filters_options'] = $this->language->get('entry_active_filters_options');
        $this->data['entry_active_filters_tags'] = $this->language->get('entry_active_filters_tags');
        $this->data['entry_active_filters_manufacturer'] = $this->language->get('entry_active_filters_manufacturer');
        $this->data['entry_active_filters_stock'] = $this->language->get('entry_active_filters_stock');
        $this->data['entry_active_filters_price'] = $this->language->get('entry_active_filters_price');
        $this->data['entry_active_filters_price_tax'] = $this->language->get('entry_active_filters_price_tax');
        $this->data['entry_active_filters_price_special'] = $this->language->get('entry_active_filters_price_special');
        $this->data['entry_active_filters_misc'] = $this->language->get('entry_active_filters_misc');
        $this->data['entry_client_side_attributes'] = $this->language->get('entry_client_side_attributes');
        $this->data['entry_client_side_attributes_button'] = $this->language->get('entry_client_side_attributes_button');
        $this->data['entry_client_side_sorting'] = $this->language->get('entry_client_side_sorting');
        $this->data['entry_client_side_items_sorting'] = $this->language->get('entry_client_side_items_sorting');
        $this->data['entry_attribute_separator'] = $this->language->get('entry_attribute_separator');

        $this->data['entry_category_domid'] = $this->language->get('entry_category_domid');
        $this->data['entry_manufacturer_domid'] = $this->language->get('entry_manufacturer_domid');
        $this->data['entry_homepage_domid'] = $this->language->get('entry_homepage_domid');
        $this->data['entry_search_domid'] = $this->language->get('entry_search_domid');
        $this->data['entry_product_domid'] = $this->language->get('entry_product_domid');
        $this->data['entry_get_domids'] = $this->language->get('entry_get_domids');
        $this->data['entry_get_domids_button'] = $this->language->get('entry_get_domids_button');
        $this->data['entry_force_siblings'] = $this->language->get('entry_force_siblings');
        $this->data['entry_filter_persist'] = $this->language->get('entry_filter_persist');
        $this->data['entry_allow_debug_data'] = $this->language->get('entry_allow_debug_data');
        $this->data['entry_enable_front_end_diagnostics'] = $this->language->get('entry_enable_front_end_diagnostics');
        $this->data['entry_option_quantity_zero'] = $this->language->get('entry_option_quantity_zero');
        $this->data['entry_dynamic'] = $this->language->get('entry_dynamic');
        $this->data['entry_force_all'] = $this->language->get('entry_force_all');
        $this->data['entry_filters_slider_step'] = $this->language->get('entry_filters_slider_step');
        $this->data['entry_script_ignore'] = $this->language->get('entry_script_ignore');
        $this->data['entry_active_filters_categories'] = $this->language->get('entry_active_filters_categories');
        $this->data['entry_activefilter_simonfilters_stock_instock'] = $this->language->get('entry_activefilter_simonfilters_stock_instock');
        $this->data['entry_delete_cache_for_debug'] = $this->language->get('entry_delete_cache_for_debug');
        $this->data['entry_options_behavior'] = $this->language->get('entry_options_behavior');
        $this->data['entry_attributes_behavior'] = $this->language->get('entry_attributes_behavior');
        $this->data['entry_expanded_collapsed'] = $this->language->get('entry_expanded_collapsed');
        $this->data['entry_disableajax'] = $this->language->get('entry_disableajax');

        $this->data['ajax_action_client_side_rebuild'] = $this->url->link('module/filter/rebuildclientside', 'token=' . $this->session->data['token'], 'SSL');
        $this->data['ajax_action_get_domids'] = $this->url->link('module/filter/getdomids', 'token=' . $this->session->data['token'], 'SSL');
        $this->data['ajax_action_get_default_style'] = $this->url->link('module/filter/getDefaultCSS', 'token=' . $this->session->data['token'], 'SSL');

        $this->data['text_type_default'] = $this->language->get('text_type_default');
        $this->data['text_type_checkbox'] = $this->language->get('text_type_checkbox');
        $this->data['text_type_dropdown'] = $this->language->get('text_type_dropdown');
        $this->data['text_type_clean'] = $this->language->get('text_type_clean');
        $this->data['text_type_horizontal'] = $this->language->get('text_type_horizontal');
        $this->data['text_type_yes'] = $this->language->get('text_type_yes');
        $this->data['text_type_no'] = $this->language->get('text_type_no');
        $this->data['text_type_collapsed'] = $this->language->get('text_type_collapsed');
        $this->data['text_type_expanded'] = $this->language->get('text_type_expanded');

        $this->data['config_template'] = $this->config->get('config_template');
        $this->data['warning_unsupported_theme'] = preg_replace('/\{0\}/', $this->config->get('config_template'), $this->language->get('warning_unsupported_theme'));
        $this->data['warning_main_index'] = $this->language->get('warning_main_index');
        $this->data['warning_admin_index'] = $this->language->get('warning_admin_index');

        $this->data['simon_save_and_stay'] = $this->language->get('simon_save_and_stay');

        $this->data['valid_main_index'] = true;
        $this->data['valid_admin_index'] = true;

        $main_index_filename = preg_replace('/system[\\|\/]$/','index.php',DIR_SYSTEM);
        if(file_exists($main_index_filename)) {
            $main_index_contents = file_get_contents( $main_index_filename );
            $this->data['valid_main_index'] = preg_match('/[\s]\$controller->addPreAction\(new Action\(\'module\/filter\/checkvalidity\'\)\);/', $main_index_contents);
        }
        $admin_index_filename = DIR_APPLICATION.'index.php';
        if(file_exists($admin_index_filename)) {
            $admin_index_contents = file_get_contents( $admin_index_filename );
            $this->data['valid_admin_index'] = preg_match('/[\s]\$controller->addPreAction\(new Action\(\'module\/filter\/managecache\'\)\);/', $admin_index_contents);
        }

        /* SimonFilters */

        $this->template = 'module/filter.tpl';
        $this->children = array(
                'common/header',
                'common/footer',
        );

        $this->response->setOutput($this->render());
    }

    private function validate() {
        if (!$this->user->hasPermission('modify', 'module/filter')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        if (!$this->error) {
            return true;
        } else {
            return false;
        }
    }
}
?>