<?php
class ControllerSaleweightbasedcosts extends Controller {
	private $error = array();
   
	public function index() {
		$this->load->language('sale/weightbasedcosts');
 
		$this->document->setTitle($this->language->get('heading_title'));
 		
		$this->load->model('sale/weightbasedcosts');
		
		$this->getList();
	}

	public function insert() {
		$this->load->language('sale/weightbasedcosts');

		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('sale/weightbasedcosts');
		
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
			$this->model_sale_weightbasedcosts->addCustomerGroup($this->request->post);
			
			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}
			
			$this->redirect($this->url->link('sale/weightbasedcosts', 'token=' . $this->session->data['token'] . $url, 'SSL'));
		}

		$this->getForm();
	}

	public function update() {
		$this->load->language('sale/weightbasedcosts');

		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('sale/weightbasedcosts');
		
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
			$this->model_sale_weightbasedcosts->editCustomerGroup($this->request->get['weightcost_id'], $this->request->post);
			
			$this->session->data['success'] = $this->language->get('text_success');
			
			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}
			
			$this->redirect($this->url->link('sale/weightbasedcosts', 'token=' . $this->session->data['token'] . $url, 'SSL'));
		}

		$this->getForm();
	}

	public function delete() { 
		$this->load->language('sale/weightbasedcosts');

		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('sale/weightbasedcosts');
		
		if (isset($this->request->post['selected']) && $this->validateDelete()) {
      		foreach ($this->request->post['selected'] as $weightcost_id) {
				$this->model_sale_weightbasedcosts->deleteCustomerGroup($weightcost_id);	
			}
						
			$this->session->data['success'] = $this->language->get('text_success');
			
			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}
			
			$this->redirect($this->url->link('sale/weightbasedcosts', 'token=' . $this->session->data['token'] . $url, 'SSL'));
		}

		$this->getList();
	}

	private function getList() {
		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'metal_code';
		}
		 
		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'ASC';
		}
		
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
		
		$url = '';
		
		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}	
		
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
			
  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('sale/weightbasedcosts', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);
							
		$this->data['insert'] = $this->url->link('sale/weightbasedcosts/insert', 'token=' . $this->session->data['token'] . $url, 'SSL');
		$this->data['delete'] = $this->url->link('sale/weightbasedcosts/delete', 'token=' . $this->session->data['token'] . $url, 'SSL');	
	
		$this->data['weightbasedcostss'] = array();

		$data = array(
			'sort'  => $sort,
			'order' => $order,
			'start' => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit' => $this->config->get('config_admin_limit')
		);
		
		$weightbasedcosts_total = $this->model_sale_weightbasedcosts->getTotalCustomerGroups();
		
		$results = $this->model_sale_weightbasedcosts->getCustomerGroups($data);

		foreach ($results as $result) {
			$action = array();
			
			$action[] = array(
				'text' => $this->language->get('text_edit'),
				'href' => $this->url->link('sale/weightbasedcosts/update', 'token=' . $this->session->data['token'] . '&weightcost_id=' . $result['weightcost_id'] . $url, 'SSL')
			);		
		
			$this->data['weightbasedcostss'][] = array(
				'weightcost_id' => $result['weightcost_id'],
				'low_weight' => $result['low_weight'],
				'high_weight' => $result['high_weight'],
				'cost' => $result['cost'],
				'selected'          => isset($this->request->post['selected']) && in_array($result['weightcost_id'], $this->request->post['selected']),
				'action'            => $action
			);
		}	
	
		$this->data['heading_title'] = $this->language->get('heading_title');
		
		$this->data['text_no_results'] = $this->language->get('text_no_results');

		$this->data['column_name'] = $this->language->get('column_name');
		$this->data['column_priceperounce'] = $this->language->get('column_priceperounce');
		$this->data['column_pricepergram'] = $this->language->get('column_pricepergram');
		$this->data['column_action'] = $this->language->get('column_action');
		$this->data['column_lowweight'] = $this->language->get('column_lowweight');
		$this->data['column_highweight'] = $this->language->get('column_highweight');
		$this->data['column_cost'] = $this->language->get('column_cost');
		$this->data['column_appilicablecost'] = $this->language->get('column_appilicablecost');

		$this->data['button_insert'] = $this->language->get('button_insert');
		$this->data['button_delete'] = $this->language->get('button_delete');
 
 		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}
		
		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		
		$url = '';

		if ($order == 'ASC') {
			$url .= '&order=DESC';
		} else {
			$url .= '&order=ASC';
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$this->data['sort_metal_code'] = $this->url->link('sale/weightbasedcosts', 'token=' . $this->session->data['token'] . '&sort=metal_code' . $url, 'SSL');
		
		$url = '';

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}
												
		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
				
		$pagination = new Pagination();
		$pagination->total = $weightbasedcosts_total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('sale/weightbasedcosts', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');
		
		$this->data['pagination'] = $pagination->render();				

		$this->data['sort'] = $sort; 
		$this->data['order'] = $order;

		$this->template = 'sale/weightbasedcosts_list.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
 	}

	private function getForm() {
		$this->data['heading_title'] = $this->language->get('heading_title');
		
		$this->data['entry_lowweight'] = $this->language->get('entry_lowweight');
		$this->data['entry_highweight'] = $this->language->get('entry_highweight');
		$this->data['entry_cost'] = $this->language->get('entry_cost');
		$this->data['entry_appilicablecost'] = $this->language->get('entry_appilicablecost');
		
		$this->data['button_save'] = $this->language->get('button_save');
		$this->data['button_cancel'] = $this->language->get('button_cancel');

		$this->data['tab_general'] = $this->language->get('tab_general');

 		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}

 		if (isset($this->error['low_weight'])) {
			$this->data['error_low_weight'] = $this->error['low_weight'];
		} else {
			$this->data['error_low_weight'] = '';
		}
		
 		if (isset($this->error['high_weight'])) {
			$this->data['error_high_weight'] = $this->error['high_weight'];
		} else {
			$this->data['error_high_weight'] = '';
		}
		
 		if (isset($this->error['cost'])) {
			$this->data['error_cost'] = $this->error['cost'];
		} else {
			$this->data['error_cost'] = '';
		}
		
		$url = '';
			
		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
		
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('sale/weightbasedcosts', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);
			
		if (!isset($this->request->get['weightcost_id'])) {
			$this->data['action'] = $this->url->link('sale/weightbasedcosts/insert', 'token=' . $this->session->data['token'] . $url, 'SSL');
		} else {
			$this->data['action'] = $this->url->link('sale/weightbasedcosts/update', 'token=' . $this->session->data['token'] . '&weightcost_id=' . $this->request->get['weightcost_id'] . $url, 'SSL');
		}
		  
    	$this->data['cancel'] = $this->url->link('sale/weightbasedcosts', 'token=' . $this->session->data['token'] . $url, 'SSL');

		if (isset($this->request->get['weightcost_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
			$weightbasedcosts_info = $this->model_sale_weightbasedcosts->getCustomerGroup($this->request->get['weightcost_id']);
		}
$this->load->model('sale/supplier_group');
		
    	$this->data['suppliers'] = $this->model_sale_supplier_group->getCustomerGroups();

    	if (isset($this->request->post['supplier_group_id'])) {
      		$this->data['supplier_group_id'] = $this->request->post['supplier_group_id'];
		} elseif (!empty($weightbasedcosts_info)) {
			$this->data['supplier_group_id'] = $weightbasedcosts_info['supplier_group_id'];
		} else {
      		$this->data['supplier_group_id'] = 0;
    	} 	
		if (isset($this->request->post['low_weight'])) {
			$this->data['low_weight'] = $this->request->post['low_weight'];
		} elseif (isset($weightbasedcosts_info)) {
			$this->data['low_weight'] = $weightbasedcosts_info['low_weight'];
		} else {
			$this->data['low_weight'] = '';
		}

		if (isset($this->request->post['high_weight'])) {
			$this->data['high_weight'] = $this->request->post['high_weight'];
		} elseif (isset($weightbasedcosts_info)) {
			$this->data['high_weight'] = $weightbasedcosts_info['high_weight'];
		} else {
			$this->data['high_weight'] = '';
		}

		if (isset($this->request->post['cost'])) {
			$this->data['cost'] = $this->request->post['cost'];
		} elseif (isset($weightbasedcosts_info)) {
			$this->data['cost'] = $weightbasedcosts_info['cost'];
		} else {
			$this->data['cost'] = '';
		}
if ($this->config->get('config_currency_auto')) {
			$this->load->model('localisation/currency');
		
			$this->model_localisation_currency->updateCurrencies();
		}	

		if (isset($this->request->post['ccurrency'])) {
			$this->data['ccurrency'] = $this->request->post['ccurrency'];
		} elseif (isset($weightbasedcosts_info)) {
			$this->data['ccurrency'] = $weightbasedcosts_info['ccurrency'];
		} else {
			$this->data['ccurrency'] = '';
		}
		
		$this->load->model('localisation/currency');
		
		$this->data['currencies'] = $this->model_localisation_currency->getCurrencies();
		
		$this->template = 'sale/weightbasedcosts_form.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render()); 
	}

	private function validateForm() {
		if (!$this->user->hasPermission('modify', 'sale/weightbasedcosts')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		if ((utf8_strlen($this->request->post['low_weight']) < 1) || (utf8_strlen($this->request->post['low_weight']) > 64)) {
			$this->error['low_weight'] = $this->language->get('error_low_weight');
		}

		if ((utf8_strlen($this->request->post['high_weight']) < 1) || (utf8_strlen($this->request->post['high_weight']) > 64)) {
			$this->error['high_weight'] = $this->language->get('error_high_weight');
		}

		if ((utf8_strlen($this->request->post['cost']) < 1) || (utf8_strlen($this->request->post['cost']) > 64)) {
			$this->error['cost'] = $this->language->get('error_cost');
		}

		if (!$this->error) {
			return true;
		} else {
			return false;
		}
	}

	private function validateDelete() {
		if (!$this->user->hasPermission('modify', 'sale/weightbasedcosts')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}
		
		$this->load->model('setting/store');
		$this->load->model('sale/customer');
      	
		foreach ($this->request->post['selected'] as $weightcost_id) {
    		if ($this->config->get('config_weightcost_id') == $weightcost_id) {
	  			$this->error['warning'] = $this->language->get('error_default');	
			}  
			
			$store_total = $this->model_setting_store->getTotalStoresByCustomerGroupId($weightcost_id);

			if ($store_total) {
				$this->error['warning'] = sprintf($this->language->get('error_store'), $store_total);
			}
			
			$customer_total = $this->model_sale_customer->getTotalCustomersByCustomerGroupId($weightcost_id);

			if ($customer_total) {
				$this->error['warning'] = sprintf($this->language->get('error_customer'), $customer_total);
			}
		}
		
		if (!$this->error) {
			return true;
		} else {
			return false;
		}
	}
}
?>