<?php 
class ModelSalevaluer extends Model {
	public function addvaluer($data) {
      	$this->db->query("INSERT INTO " . DB_PREFIX . "valuer SET firstname = '" . $this->db->escape($data['firstname']) . "', lastname = '" . $this->db->escape($data['lastname']) . "', email = '" . $this->db->escape($data['email']) . "',  telephone = '" . $this->db->escape($data['telephone']) . "', image = '" . $this->db->escape($data['image']) . "',fax = '" . $this->db->escape($data['fax']) . "',   newsletter = '" . (int)$data['newsletter'] . "', valuer_group_id = '" . (int)$data['valuer_group_id'] . "', password = '" . $this->db->escape(md5($data['password'])) . "', status = '" . (int)$data['status'] . "', date_added = NOW()");
      	
      	$valuer_id = $this->db->getLastId();
      	
      	if (isset($data['address'])) {		
      		foreach ($data['address'] as $address) {	
      			$this->db->query("INSERT INTO " . DB_PREFIX . "valuer_address SET valuer_id = '" . (int)$valuer_id . "', firstname = '" . $this->db->escape($address['firstname']) . "', lastname = '" . $this->db->escape($address['lastname']) . "', company = '" . $this->db->escape($address['company']) . "', address_1 = '" . $this->db->escape($address['address_1']) . "', address_2 = '" . $this->db->escape($address['address_2']) . "', city = '" . $this->db->escape($address['city']) . "', postcode = '" . $this->db->escape($address['postcode']) . "', country_id = '" . (int)$address['country_id'] . "', zone_id = '" . (int)$address['zone_id'] . "'");
				if (isset($address['default'])) {
					$address_id = $this->db->getLastId();
					
					$this->db->query("UPDATE " . DB_PREFIX . "valuer SET address_id = '" . $address_id . "' WHERE valuer_id = '" . (int)$valuer_id . "'");
				}
			} 
		}
	}
	
	public function editvaluer($valuer_id, $data) {
		$this->db->query("UPDATE " . DB_PREFIX . "valuer SET firstname = '" . $this->db->escape($data['firstname']) . "', lastname = '" . $this->db->escape($data['lastname']) . "', email = '" . $this->db->escape($data['email']) . "', telephone = '" . $this->db->escape($data['telephone']) . "',  image = '" . $this->db->escape($data['image']) . "', fax = '" . $this->db->escape($data['fax']) . "',  newsletter = '" . (int)$data['newsletter'] . "', valuer_group_id = '" . (int)$data['valuer_group_id'] . "', status = '" . (int)$data['status'] . "' WHERE valuer_id = '" . (int)$valuer_id . "'");
	
      	if ($data['password']) {
        	$this->db->query("UPDATE " . DB_PREFIX . "valuer SET password = '" . $this->db->escape(md5($data['password'])) . "' WHERE valuer_id = '" . (int)$valuer_id . "'");
      	}
      	
      	$this->db->query("DELETE FROM " . DB_PREFIX . "valuer_address WHERE valuer_id = '" . (int)$valuer_id . "'");
      	
      	if (isset($data['address'])) {
      		foreach ($data['address'] as $address) {
				if ($address['address_id']) {
					$this->db->query("INSERT INTO " . DB_PREFIX . "valuer_address SET address_id = '" . $this->db->escape($address['address_id']) . "', valuer_id = '" . (int)$valuer_id . "', firstname = '" . $this->db->escape($address['firstname']) . "', lastname = '" . $this->db->escape($address['lastname']) . "', company = '" . $this->db->escape($address['company']) . "', address_1 = '" . $this->db->escape($address['address_1']) . "', address_2 = '" . $this->db->escape($address['address_2']) . "', city = '" . $this->db->escape($address['city']) . "', postcode = '" . $this->db->escape($address['postcode']) . "', country_id = '" . (int)$address['country_id'] . "', zone_id = '" . (int)$address['zone_id'] . "'");
					
					if (isset($address['default'])) {
						$this->db->query("UPDATE " . DB_PREFIX . "valuer SET address_id = '" . (int)$address['address_id'] . "' WHERE valuer_id = '" . (int)$valuer_id . "'");
					}
				} else {
					$this->db->query("INSERT INTO " . DB_PREFIX . "valuer_address SET valuer_id = '" . (int)$valuer_id . "', firstname = '" . $this->db->escape($address['firstname']) . "', lastname = '" . $this->db->escape($address['lastname']) . "', company = '" . $this->db->escape($address['company']) . "', address_1 = '" . $this->db->escape($address['address_1']) . "', address_2 = '" . $this->db->escape($address['address_2']) . "', city = '" . $this->db->escape($address['city']) . "', postcode = '" . $this->db->escape($address['postcode']) . "', country_id = '" . (int)$address['country_id'] . "', zone_id = '" . (int)$address['zone_id'] . "'");
					
					if (isset($address['default'])) {
						$address_id = $this->db->getLastId();
						
						$this->db->query("UPDATE " . DB_PREFIX . "valuer SET address_id = '" . (int)$address_id . "' WHERE valuer_id = '" . (int)$valuer_id . "'");
					}
				}
			}
		}
	}

	public function editToken($valuer_id, $token) {
		$this->db->query("UPDATE " . DB_PREFIX . "valuer SET token = '" . $this->db->escape($token) . "' WHERE valuer_id = '" . (int)$valuer_id . "'");
	}
	
	public function deletevaluer($valuer_id) {
		$this->db->query("DELETE FROM " . DB_PREFIX . "valuer WHERE valuer_id = '" . (int)$valuer_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "valuer_reward WHERE valuer_id = '" . (int)$valuer_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "valuer_transaction WHERE valuer_id = '" . (int)$valuer_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "valuer_ip WHERE valuer_id = '" . (int)$valuer_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "valuer_address WHERE valuer_id = '" . (int)$valuer_id . "'");
	}
	
	public function getvaluer($valuer_id) {
		$query = $this->db->query("SELECT DISTINCT * FROM " . DB_PREFIX . "valuer WHERE valuer_id = '" . (int)$valuer_id . "'");
	
		return $query->row;
	}
	
	public function getvaluerByEmail($email) {
		$query = $this->db->query("SELECT DISTINCT * FROM " . DB_PREFIX . "valuer WHERE email = '" . $this->db->escape($email) . "'");
	
		return $query->row;
	}
			
	public function getvaluers($data = array()) {
		$sql = "SELECT *, CONCAT(c.firstname, ' ', c.lastname) AS name, cg.name AS valuer_group FROM " . DB_PREFIX . "valuer c LEFT JOIN " . DB_PREFIX . "valuer_group cg ON (c.valuer_group_id = cg.valuer_group_id)";

		$implode = array();
		
		if (!empty($data['filter_name'])) {
			$implode[] = "LCASE(CONCAT(c.firstname, ' ', c.lastname)) LIKE '" . $this->db->escape(utf8_strtolower($data['filter_name'])) . "%'";
		}
		
		if (!empty($data['filter_email'])) {
			$implode[] = "LCASE(c.email) LIKE '" . $this->db->escape(utf8_strtolower($data['filter_email'])) . "%'";
		}
		
		if (!empty($data['filter_valuer_group_id'])) {
			$implode[] = "cg.valuer_group_id = '" . $this->db->escape($data['filter_valuer_group_id']) . "'";
		}	
		
		if (isset($data['filter_status']) && !is_null($data['filter_status'])) {
			$implode[] = "c.status = '" . (int)$data['filter_status'] . "'";
		}	
		
		if (isset($data['filter_approved']) && !is_null($data['filter_approved'])) {
			$implode[] = "c.approved = '" . (int)$data['filter_approved'] . "'";
		}	
			
		if (!empty($data['filter_ip'])) {
			$implode[] = "c.valuer_id IN (SELECT valuer_id FROM " . DB_PREFIX . "valuer_ip WHERE ip = '" . $this->db->escape($data['filter_ip']) . "')";
		}	
				
		if (!empty($data['filter_date_added'])) {
			$implode[] = "DATE(c.date_added) = DATE('" . $this->db->escape($data['filter_date_added']) . "')";
		}
		
		if ($implode) {
			$sql .= " WHERE " . implode(" AND ", $implode);
		}
		
		$sort_data = array(
			'name',
			'c.email',
			'valuer_group',
			'c.status',
			'c.ip',
			'c.date_added'
		);	
			
		if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
			$sql .= " ORDER BY " . $data['sort'];	
		} else {
			$sql .= " ORDER BY name";	
		}
			
		if (isset($data['order']) && ($data['order'] == 'DESC')) {
			$sql .= " DESC";
		} else {
			$sql .= " ASC";
		}
		
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}			

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}	
			
			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}		
		
		$query = $this->db->query($sql);
		
		return $query->rows;	
	}
	
	public function approve($valuer_id) {
		$valuer_info = $this->getvaluer($valuer_id);

		if ($valuer_info) {
			$this->db->query("UPDATE " . DB_PREFIX . "valuer SET approved = '1' WHERE valuer_id = '" . (int)$valuer_id . "'");

			$this->load->language('mail/valuer');
			
			$this->load->model('setting/store');
						
			$store_info = $this->model_setting_store->getStore($valuer_info['store_id']);
			
			if ($store_info) {
				$store_name = $store_info['name'];
				$store_url = $store_info['url'] . 'index.php?route=account/login';
			} else {
				$store_name = $this->config->get('config_name');
				$store_url = HTTP_CATALOG . 'index.php?route=account/login';
			}
	
			$message  = sprintf($this->language->get('text_approve_welcome'), $store_name) . "\n\n";
			$message .= $this->language->get('text_approve_login') . "\n";
			$message .= $store_url . "\n\n";
			$message .= $this->language->get('text_approve_services') . "\n\n";
			$message .= $this->language->get('text_approve_thanks') . "\n";
			$message .= $store_name;
	
			$mail = new Mail();
			$mail->protocol = $this->config->get('config_mail_protocol');
			$mail->parameter = $this->config->get('config_mail_parameter');
			$mail->hostname = $this->config->get('config_smtp_host');
			$mail->username = $this->config->get('config_smtp_username');
			$mail->password = $this->config->get('config_smtp_password');
			$mail->port = $this->config->get('config_smtp_port');
			$mail->timeout = $this->config->get('config_smtp_timeout');							
			$mail->setTo($valuer_info['email']);
			$mail->setFrom($this->config->get('config_email'));
			$mail->setSender($store_name);
			$mail->setSubject(sprintf($this->language->get('text_approve_subject'), $store_name));
			$mail->setText(html_entity_decode($message, ENT_QUOTES, 'UTF-8'));
			$mail->send();
		}		
	}
		
	public function getvaluersByNewsletter() {
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "valuer WHERE newsletter = '1' ORDER BY firstname, lastname, email");
	
		return $query->rows;
	}
	
	public function getvaluersByvaluerGroupId($valuer_group_id) {
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "valuer WHERE valuer_group_id = '" . (int)$valuer_group_id . "' ORDER BY firstname, lastname, email");
	
		return $query->rows;
	}
		
	public function getvaluersByProduct($product_id) {
		if ($product_id) {
			$query = $this->db->query("SELECT DISTINCT `email` FROM `" . DB_PREFIX . "order` o LEFT JOIN " . DB_PREFIX . "order_product op ON (o.order_id = op.order_id) WHERE op.product_id = '" . (int)$product_id . "' AND o.order_status_id <> '0'");
	
			return $query->rows;
		} else {
			return array();	
		}
	}
	
	public function getAddress($address_id) {
		$address_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "valuer_address WHERE address_id = '" . (int)$address_id . "'");

		$default_query = $this->db->query("SELECT address_id FROM " . DB_PREFIX . "valuer WHERE valuer_id = '" . (int)$address_query->row['valuer_id'] . "'");
				
		if ($address_query->num_rows) {
			$country_query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "country` WHERE country_id = '" . (int)$address_query->row['country_id'] . "'");
			
			if ($country_query->num_rows) {
				$country = $country_query->row['name'];
				$iso_code_2 = $country_query->row['iso_code_2'];
				$iso_code_3 = $country_query->row['iso_code_3'];
				$address_format = $country_query->row['address_format'];
			} else {
				$country = '';
				$iso_code_2 = '';
				$iso_code_3 = '';	
				$address_format = '';
			}
			
			$zone_query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "zone` WHERE zone_id = '" . (int)$address_query->row['zone_id'] . "'");
			
			if ($zone_query->num_rows) {
				$zone = $zone_query->row['name'];
				$code = $zone_query->row['code'];
			} else {
				$zone = '';
				$code = '';
			}		
		
			return array(
				'address_id'     => $address_query->row['address_id'],
				'valuer_id'    => $address_query->row['valuer_id'],
				'firstname'      => $address_query->row['firstname'],
				'lastname'       => $address_query->row['lastname'],
				'company'        => $address_query->row['company'],
				'address_1'      => $address_query->row['address_1'],
				'address_2'      => $address_query->row['address_2'],
				'postcode'       => $address_query->row['postcode'],
				'city'           => $address_query->row['city'],
				'zone_id'        => $address_query->row['zone_id'],
				'zone'           => $zone,
				'zone_code'      => $code,
				'country_id'     => $address_query->row['country_id'],
				'country'        => $country,	
				'iso_code_2'     => $iso_code_2,
				'iso_code_3'     => $iso_code_3,
				'address_format' => $address_format,
				'default'		 => ($default_query->row['address_id'] == $address_query->row['address_id']) ? true : false
			);
		}
	}
		
	public function getAddresses($valuer_id) {
		$address_data = array();
		
		$query = $this->db->query("SELECT address_id FROM " . DB_PREFIX . "valuer_address WHERE valuer_id = '" . (int)$valuer_id . "'");
	
		foreach ($query->rows as $result) {
			$address_info = $this->getAddress($result['address_id']);
		
			if ($address_info) {
				$address_data[] = $address_info;
			}
		}		
		
		return $address_data;
	}	
				
	public function getTotalvaluers($data = array()) {
      	$sql = "SELECT COUNT(*) AS total FROM " . DB_PREFIX . "valuer";
		
		$implode = array();
		
		if (!empty($data['filter_name'])) {
			$implode[] = "LCASE(CONCAT(firstname, ' ', lastname)) LIKE '" . $this->db->escape(utf8_strtolower($data['filter_name'])) . "%'";
		}
		
		if (!empty($data['filter_email'])) {
			$implode[] = "LCASE(email) LIKE '" . $this->db->escape(utf8_strtolower($data['filter_email'])) . "%'";
		}
		
		if (!empty($data['filter_valuer_group_id'])) {
			$implode[] = "valuer_group_id = '" . $this->db->escape($data['filter_valuer_group_id']) . "'";
		}	
				
		if (isset($data['filter_status']) && !is_null($data['filter_status'])) {
			$implode[] = "status = '" . (int)$data['filter_status'] . "'";
		}			
		
		if (isset($data['filter_approved']) && !is_null($data['filter_approved'])) {
			$implode[] = "approved = '" . (int)$data['filter_approved'] . "'";
		}		
				
		if (!empty($data['filter_date_added'])) {
			$implode[] = "DATE(date_added) = DATE('" . $this->db->escape($data['filter_date_added']) . "')";
		}
		
		if ($implode) {
			$sql .= " WHERE " . implode(" AND ", $implode);
		}
				
		$query = $this->db->query($sql);
				
		return $query->row['total'];
	}
		
	public function getTotalvaluersAwaitingApproval() {
      	$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "valuer WHERE status = '0' OR approved = '0'");

		return $query->row['total'];
	}
	
	public function getTotalAddressesByvaluerId($valuer_id) {
      	$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "valuer_address WHERE valuer_id = '" . (int)$valuer_id . "'");
		
		return $query->row['total'];
	}
	
	public function getTotalAddressesByCountryId($country_id) {
		$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "valuer_address WHERE country_id = '" . (int)$country_id . "'");
		
		return $query->row['total'];
	}	
	
	public function getTotalAddressesByZoneId($zone_id) {
		$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "valuer_address WHERE zone_id = '" . (int)$zone_id . "'");
		
		return $query->row['total'];
	}
	
	public function getTotalvaluersByvaluerGroupId($valuer_group_id) {
		$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "valuer WHERE valuer_group_id = '" . (int)$valuer_group_id . "'");
		
		return $query->row['total'];
	}
	public function getTotalvaluersBySizeId($size_id) {
		$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "size WHERE size_id = '" . (int)$size_id . "'");
		
		return $query->row['total'];
	}
			
	public function addTransaction($valuer_id, $description = '', $amount = '', $order_id = 0) {
		$valuer_info = $this->getvaluer($valuer_id);
		
		if ($valuer_info) { 
			$this->db->query("INSERT INTO " . DB_PREFIX . "valuer_transaction SET valuer_id = '" . (int)$valuer_id . "', order_id = '" . (int)$order_id . "', description = '" . $this->db->escape($description) . "', amount = '" . (float)$amount . "', date_added = NOW()");

			$this->language->load('mail/valuer');
			
			if ($valuer_info['store_id']) {
				$this->load->model('setting/store');
		
				$store_info = $this->model_setting_store->getStore($valuer_info['store_id']);
				
				if ($store_info) {
					$store_name = $store_info['store_name'];
				} else {
					$store_name = $this->config->get('config_name');
				}	
			} else {
				$store_name = $this->config->get('config_name');
			}	
						
			$message  = sprintf($this->language->get('text_transaction_received'), $this->currency->format($amount, $this->config->get('config_currency'))) . "\n\n";
			$message .= sprintf($this->language->get('text_transaction_total'), $this->currency->format($this->getTransactionTotal($valuer_id)));
								
			$mail = new Mail();
			$mail->protocol = $this->config->get('config_mail_protocol');
			$mail->parameter = $this->config->get('config_mail_parameter');
			$mail->hostname = $this->config->get('config_smtp_host');
			$mail->username = $this->config->get('config_smtp_username');
			$mail->password = $this->config->get('config_smtp_password');
			$mail->port = $this->config->get('config_smtp_port');
			$mail->timeout = $this->config->get('config_smtp_timeout');
			$mail->setTo($valuer_info['email']);
			$mail->setFrom($this->config->get('config_email'));
			$mail->setSender($store_name);
			$mail->setSubject(sprintf($this->language->get('text_transaction_subject'), $this->config->get('config_name')));
			$mail->setText($message);
			$mail->send();
		}
	}
	
	public function deleteTransaction($order_id) {
		$this->db->query("DELETE FROM " . DB_PREFIX . "valuer_transaction WHERE order_id = '" . (int)$order_id . "'");
	}
	
	public function getTransactions($valuer_id, $start = 0, $limit = 10) {
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "valuer_transaction WHERE valuer_id = '" . (int)$valuer_id . "' ORDER BY date_added DESC LIMIT " . (int)$start . "," . (int)$limit);
	
		return $query->rows;
	}

	public function getTotalTransactions($valuer_id) {
		$query = $this->db->query("SELECT COUNT(*) AS total  FROM " . DB_PREFIX . "valuer_transaction WHERE valuer_id = '" . (int)$valuer_id . "'");
	
		return $query->row['total'];
	}
			
	public function getTransactionTotal($valuer_id) {
		$query = $this->db->query("SELECT SUM(amount) AS total FROM " . DB_PREFIX . "valuer_transaction WHERE valuer_id = '" . (int)$valuer_id . "'");
	
		return $query->row['total'];
	}
	
	public function getTotalTransactionsByOrderId($order_id) {
		$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "valuer_transaction WHERE order_id = '" . (int)$order_id . "'");
	
		return $query->row['total'];
	}	
				
	public function addReward($valuer_id, $description = '', $points = '', $order_id = 0) {
		$valuer_info = $this->getvaluer($valuer_id);
			
		if ($valuer_info) { 
			$this->db->query("INSERT INTO " . DB_PREFIX . "valuer_reward SET valuer_id = '" . (int)$valuer_id . "', order_id = '" . (int)$order_id . "', points = '" . (int)$points . "', description = '" . $this->db->escape($description) . "', date_added = NOW()");

			$this->language->load('mail/valuer');
			
			if ($order_id) {
				$this->load->model('sale/order');
		
				$order_info = $this->model_sale_order->getOrder($order_id);
				
				if ($order_info) {
					$store_name = $order_info['store_name'];
				} else {
					$store_name = $this->config->get('config_name');
				}	
			} else {
				$store_name = $this->config->get('config_name');
			}		
				
			$message  = sprintf($this->language->get('text_reward_received'), $points) . "\n\n";
			$message .= sprintf($this->language->get('text_reward_total'), $this->getRewardTotal($valuer_id));
				
			$mail = new Mail();
			$mail->protocol = $this->config->get('config_mail_protocol');
			$mail->parameter = $this->config->get('config_mail_parameter');
			$mail->hostname = $this->config->get('config_smtp_host');
			$mail->username = $this->config->get('config_smtp_username');
			$mail->password = $this->config->get('config_smtp_password');
			$mail->port = $this->config->get('config_smtp_port');
			$mail->timeout = $this->config->get('config_smtp_timeout');
			$mail->setTo($valuer_info['email']);
			$mail->setFrom($this->config->get('config_email'));
			$mail->setSender($store_name);
			$mail->setSubject(sprintf($this->language->get('text_reward_subject'), $store_name));
			$mail->setText($message);
			$mail->send();
		}
	}

	public function deleteReward($order_id) {
		$this->db->query("DELETE FROM " . DB_PREFIX . "valuer_reward WHERE order_id = '" . (int)$order_id . "'");
	}
	
	public function getRewards($valuer_id, $start = 0, $limit = 10) {
		$query = $this->db->query("SELECT o.date_added as date_added,r.order_id,r.product_id,r.sale_amount,r.currency,drd.reward_amount as points FROM " . DB_PREFIX . "valuer_rewards_distribution drd," . DB_PREFIX . "rewards r,`" . DB_PREFIX . "order` o WHERE  drd.reward_id=r.reward_id AND  r.order_id=o.order_id AND drd.customer_valuer_id = '" . (int)$valuer_id . "' ORDER BY o.date_added DESC LIMIT " . (int)$start . "," . (int)$limit);
	
		return $query->rows;
	}
	
	public function getTotalRewards($valuer_id) {
		$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "valuer_reward WHERE valuer_id = '" . (int)$valuer_id . "'");
	
		return $query->row['total'];
	}
			
	public function getRewardTotal($valuer_id) {
		$query = $this->db->query("SELECT SUM(points) AS total FROM " . DB_PREFIX . "valuer_reward WHERE valuer_id = '" . (int)$valuer_id . "'");
	
		return $query->row['total'];
	}		
	
	public function getTotalvaluerRewardsByOrderId($order_id) {
		$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "valuer_reward WHERE order_id = '" . (int)$order_id . "'");
	
		return $query->row['total'];
	}
	
	public function getIpsByvaluerId($valuer_id) {
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "valuer_ip WHERE valuer_id = '" . (int)$valuer_id . "'");

		return $query->rows;
	}	
	
	public function getTotalvaluersByIp($ip) {
		$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "valuer_ip WHERE ip = '" . $this->db->escape($ip) . "'");

		return $query->row['total'];
	}				
}
?>