<?php echo $header; ?> 
<div id="content">
  <div class="breadcrumb">
    <?php foreach ($breadcrumbs as $breadcrumb) { ?>
    <?php echo $breadcrumb['separator']; ?><a href="<?php echo $breadcrumb['href']; ?>"><?php echo $breadcrumb['text']; ?></a>
    <?php } ?>
  </div>
  <?php if ($error_warning) { ?>
  <div class="warning"><?php echo $error_warning; ?></div>
  <?php } ?>
  <?php if ($success) { ?>
  <div class="success"><?php echo $success; ?></div>
  <?php } ?>
  <div class="box">
    <div class="heading">
      <h1><img src="view/image/setting.png" alt="" /> <?php echo $heading_title; ?></h1>
      <div class="buttons"><a onclick="$('#form').submit();" class="button"><?php echo $button_save; ?></a>
      <a onclick="location = '<?php echo $cancel; ?>';" class="button"><?php echo $button_cancel; ?></a>
      
      </div>
    </div>
    <div class="content">
      <div id="tabs" class="htabs"><a href="#tab-general"><?php echo $tab_general; ?></a><a href="#tab-store"><?php echo $tab_store; ?></a>
	  <a href="#tab-local"><?php echo $tab_local; ?></a>
	  <a href="#tab-option"><?php echo $tab_option; ?></a>
	  <a href="#tab-image"><?php echo $tab_image; ?></a>
	  <a href="#tab-mail"><?php echo $tab_mail; ?></a>
	  <a href="#tab-server"><?php echo $tab_server; ?></a>
	  <a href="#tab-productsetting">Mark Up Setting</a>
	  <a href="#tab-diamondproductsetting">Diamond Mark Up Setting</a>
	  <a href="#tab-rapnet">Rapnet</a>
	  <a href="#tab-rewardmaster">Reward Master</a>
	  </div>
      <form action="<?php echo $action; ?>" method="post" enctype="multipart/form-data" id="form">
        <div id="tab-general">
          <table class="form">
            <tr>
              <td><span class="required">*</span> <?php echo $entry_name; ?></td>
              <td><input type="text" name="config_name" value="<?php echo $config_name; ?>" size="40" />
                <?php if ($error_name) { ?>
                <span class="error"><?php echo $error_name; ?></span>
                <?php } ?></td>
            </tr>
            <tr>
              <td><span class="required">*</span> <?php echo $entry_owner; ?></td>
              <td><input type="text" name="config_owner" value="<?php echo $config_owner; ?>" size="40" />
                <?php if ($error_owner) { ?>
                <span class="error"><?php echo $error_owner; ?></span>
                <?php } ?></td>
            </tr>
            <tr>
              <td><span class="required">*</span> <?php echo $entry_address; ?></td>
              <td><textarea name="config_address" cols="40" rows="5"><?php echo $config_address; ?></textarea>
                <?php if ($error_address) { ?>
                <span class="error"><?php echo $error_address; ?></span>
                <?php } ?></td>
            </tr>
            <tr>
              <td><span class="required">*</span> <?php echo $entry_email; ?></td>
              <td><input type="text" name="config_email" value="<?php echo $config_email; ?>" size="40" />
                <?php if ($error_email) { ?>
                <span class="error"><?php echo $error_email; ?></span>
                <?php } ?></td>
            </tr>
            <tr>
              <td><span class="required">*</span> <?php echo $entry_telephone; ?></td>
              <td><input type="text" name="config_telephone" value="<?php echo $config_telephone; ?>" />
                <?php if ($error_telephone) { ?>
                <span class="error"><?php echo $error_telephone; ?></span>
                <?php } ?></td>
            </tr>
            <tr>
              <td><?php echo $entry_fax; ?></td>
              <td><input type="text" name="config_fax" value="<?php echo $config_fax; ?>" /></td>
            </tr>
          </table>
        </div>
        <div id="tab-store">
          <table class="form">
            <tr>
              <td><span class="required">*</span> <?php echo $entry_title; ?></td>
              <td><input type="text" name="config_title" value="<?php echo $config_title; ?>" />
                <?php if ($error_title) { ?>
                <span class="error"><?php echo $error_title; ?></span>
                <?php } ?></td>
            </tr>
            <tr>
              <td><?php echo $entry_meta_description; ?></td>
              <td><textarea name="config_meta_description" cols="40" rows="5"><?php echo $config_meta_description; ?></textarea></td>
            </tr>
            <tr>
              <td><?php echo $entry_template; ?></td>
              <td><select name="config_template" onchange="$('#template').load('index.php?route=setting/setting/template&token=<?php echo $token; ?>&template=' + encodeURIComponent(this.value));">
                  <?php foreach ($templates as $template) { ?>
                  <?php if ($template == $config_template) { ?>
                  <option value="<?php echo $template; ?>" selected="selected"><?php echo $template; ?></option>
                  <?php } else { ?>
                  <option value="<?php echo $template; ?>"><?php echo $template; ?></option>
                  <?php } ?>
                  <?php } ?>
                </select></td>
            </tr>
            <tr>
              <td></td>
              <td id="template"></td>
            </tr>
            <tr>
              <td><?php echo $entry_layout; ?></td>
              <td><select name="config_layout_id">
                  <?php foreach ($layouts as $layout) { ?>
                  <?php if ($layout['layout_id'] == $config_layout_id) { ?>
                  <option value="<?php echo $layout['layout_id']; ?>" selected="selected"><?php echo $layout['name']; ?></option>
                  <?php } else { ?>
                  <option value="<?php echo $layout['layout_id']; ?>"><?php echo $layout['name']; ?></option>
                  <?php } ?>
                  <?php } ?>
                </select></td>
            </tr>
          </table>
        </div>
        <div id="tab-local">
          <table class="form">
            <tr>
              <td><?php echo $entry_country; ?></td>
              <td><select name="config_country_id" onchange="$('select[name=\'config_zone_id\']').load('index.php?route=setting/setting/zone&token=<?php echo $token; ?>&country_id=' + this.value + '&zone_id=<?php echo $config_zone_id; ?>');">
                  <?php foreach ($countries as $country) { ?>
                  <?php if ($country['country_id'] == $config_country_id) { ?>
                  <option value="<?php echo $country['country_id']; ?>" selected="selected"><?php echo $country['name']; ?></option>
                  <?php } else { ?>
                  <option value="<?php echo $country['country_id']; ?>"><?php echo $country['name']; ?></option>
                  <?php } ?>
                  <?php } ?>
                </select></td>
            </tr>
            <tr>
              <td><?php echo $entry_zone; ?></td>
              <td><select name="config_zone_id">
                </select></td>
            </tr>
            <tr>
              <td><?php echo $entry_language; ?></td>
              <td><select name="config_language">
                  <?php foreach ($languages as $language) { ?>
                  <?php if ($language['code'] == $config_language) { ?>
                  <option value="<?php echo $language['code']; ?>" selected="selected"><?php echo $language['name']; ?></option>
                  <?php } else { ?>
                  <option value="<?php echo $language['code']; ?>"><?php echo $language['name']; ?></option>
                  <?php } ?>
                  <?php } ?>
                </select></td>
            </tr>
            <tr>
              <td><?php echo $entry_admin_language; ?></td>
              <td><select name="config_admin_language">
                  <?php foreach ($languages as $language) { ?>
                  <?php if ($language['code'] == $config_admin_language) { ?>
                  <option value="<?php echo $language['code']; ?>" selected="selected"><?php echo $language['name']; ?></option>
                  <?php } else { ?>
                  <option value="<?php echo $language['code']; ?>"><?php echo $language['name']; ?></option>
                  <?php } ?>
                  <?php } ?>
                </select></td>
            </tr>
            <tr>
              <td><?php echo $entry_currency; ?></td>
              <td><select name="config_currency">
                  <?php foreach ($currencies as $currency) { ?>
                  <?php if ($currency['code'] == $config_currency) { ?>
                  <option value="<?php echo $currency['code']; ?>" selected="selected"><?php echo $currency['title']; ?></option>
                  <?php } else { ?>
                  <option value="<?php echo $currency['code']; ?>"><?php echo $currency['title']; ?></option>
                  <?php } ?>
                  <?php } ?>
                </select></td>
            </tr>
            <tr>
              <td><?php echo $entry_currency_auto; ?></td>
              <td><?php if ($config_currency_auto) { ?>
                <input type="radio" name="config_currency_auto" value="1" checked="checked" />
                <?php echo $text_yes; ?>
                <input type="radio" name="config_currency_auto" value="0" />
                <?php echo $text_no; ?>
                <?php } else { ?>
                <input type="radio" name="config_currency_auto" value="1" />
                <?php echo $text_yes; ?>
                <input type="radio" name="config_currency_auto" value="0" checked="checked" />
                <?php echo $text_no; ?>
                <?php } ?></td>
            </tr>
            <tr>
              <td><?php echo $entry_length_class; ?></td>
              <td><select name="config_length_class_id">
                  <?php foreach ($length_classes as $length_class) { ?>
                  <?php if ($length_class['length_class_id'] == $config_length_class_id) { ?>
                  <option value="<?php echo $length_class['length_class_id']; ?>" selected="selected"><?php echo $length_class['title']; ?></option>
                  <?php } else { ?>
                  <option value="<?php echo $length_class['length_class_id']; ?>"><?php echo $length_class['title']; ?></option>
                  <?php } ?>
                  <?php } ?>
                </select></td>
            </tr>
            <tr>
              <td><?php echo $entry_weight_class; ?></td>
              <td><select name="config_weight_class_id">
                  <?php foreach ($weight_classes as $weight_class) { ?>
                  <?php if ($weight_class['weight_class_id'] == $config_weight_class_id) { ?>
                  <option value="<?php echo $weight_class['weight_class_id']; ?>" selected="selected"><?php echo $weight_class['title']; ?></option>
                  <?php } else { ?>
                  <option value="<?php echo $weight_class['weight_class_id']; ?>"><?php echo $weight_class['title']; ?></option>
                  <?php } ?>
                  <?php } ?>
                </select></td>
            </tr>
          </table>
        </div>
        <div id="tab-option">
          <table class="form">
            <tr>
              <td><span class="required">*</span> <?php echo $entry_catalog_limit; ?></td>
              <td><input type="text" name="config_catalog_limit" value="<?php echo $config_catalog_limit; ?>" size="3" />
                <?php if ($error_catalog_limit) { ?>
                <span class="error"><?php echo $error_catalog_limit; ?></span>
                <?php } ?></td>
            </tr>
            <tr>
              <td><span class="required">*</span> <?php echo $entry_admin_limit; ?></td>
              <td><input type="text" name="config_admin_limit" value="<?php echo $config_admin_limit; ?>" size="3" />
                <?php if ($error_admin_limit) { ?>
                <span class="error"><?php echo $error_admin_limit; ?></span>
                <?php } ?></td>
            </tr>
            <tr>
              <td><?php echo $entry_tax; ?></td>
              <td><?php if ($config_tax) { ?>
                <input type="radio" name="config_tax" value="1" checked="checked" />
                <?php echo $text_yes; ?>
                <input type="radio" name="config_tax" value="0" />
                <?php echo $text_no; ?>
                <?php } else { ?>
                <input type="radio" name="config_tax" value="1" />
                <?php echo $text_yes; ?>
                <input type="radio" name="config_tax" value="0" checked="checked" />
                <?php echo $text_no; ?>
                <?php } ?></td>
            </tr>
            <tr>
              <td><?php echo $entry_tax_default; ?></td>
              <td><select name="config_tax_default">
                  <option value=""><?php echo $text_none; ?></option>
                  <?php  if ($config_tax_default == 'shipping') { ?>
                  <option value="shipping" selected="selected"><?php echo $text_shipping; ?></option>
                  <?php } else { ?>
                  <option value="shipping"><?php echo $text_shipping; ?></option>
                  <?php } ?>
                  <?php  if ($config_tax_default == 'payment') { ?>
                  <option value="payment" selected="selected"><?php echo $text_payment; ?></option>
                  <?php } else { ?>
                  <option value="payment"><?php echo $text_payment; ?></option>
                  <?php } ?>
                </select></td>
            </tr>
            <tr>
              <td><?php echo $entry_tax_customer; ?></td>
              <td><select name="config_tax_customer">
              	  <option value=""><?php echo $text_none; ?></option>
                  <?php  if ($config_tax_customer == 'shipping') { ?>
                  <option value="shipping" selected="selected"><?php echo $text_shipping; ?></option>
                  <?php } else { ?>
                  <option value="shipping"><?php echo $text_shipping; ?></option>
                  <?php } ?>
                  <?php  if ($config_tax_customer == 'payment') { ?>
                  <option value="payment" selected="selected"><?php echo $text_payment; ?></option>
                  <?php } else { ?>
                  <option value="payment"><?php echo $text_payment; ?></option>
                  <?php } ?>
                </select></td>
            </tr>
            <tr>
              <td><?php echo $entry_invoice_prefix; ?></td>
              <td><input type="text" name="config_invoice_prefix" value="<?php echo $config_invoice_prefix; ?>" /></td>
            </tr>
            <tr>
              <td><?php echo $entry_customer_group; ?></td>
              <td><select name="config_customer_group_id">
                  <?php foreach ($customer_groups as $customer_group) { ?>
                  <?php if ($customer_group['customer_group_id'] == $config_customer_group_id) { ?>
                  <option value="<?php echo $customer_group['customer_group_id']; ?>" selected="selected"><?php echo $customer_group['name']; ?></option>
                  <?php } else { ?>
                  <option value="<?php echo $customer_group['customer_group_id']; ?>"><?php echo $customer_group['name']; ?></option>
                  <?php } ?>
                  <?php } ?>
                </select></td>
            </tr>
            <tr>
              <td><?php echo $entry_customer_price; ?></td>
              <td><?php if ($config_customer_price) { ?>
                <input type="radio" name="config_customer_price" value="1" checked="checked" />
                <?php echo $text_yes; ?>
                <input type="radio" name="config_customer_price" value="0" />
                <?php echo $text_no; ?>
                <?php } else { ?>
                <input type="radio" name="config_customer_price" value="1" />
                <?php echo $text_yes; ?>
                <input type="radio" name="config_customer_price" value="0" checked="checked" />
                <?php echo $text_no; ?>
                <?php } ?></td>
            </tr>
            <tr>
              <td><?php echo $entry_customer_approval; ?></td>
              <td><?php if ($config_customer_approval) { ?>
                <input type="radio" name="config_customer_approval" value="1" checked="checked" />
                <?php echo $text_yes; ?>
                <input type="radio" name="config_customer_approval" value="0" />
                <?php echo $text_no; ?>
                <?php } else { ?>
                <input type="radio" name="config_customer_approval" value="1" />
                <?php echo $text_yes; ?>
                <input type="radio" name="config_customer_approval" value="0" checked="checked" />
                <?php echo $text_no; ?>
                <?php } ?></td>
            </tr>
            <tr>
              <td><?php echo $entry_guest_checkout; ?></td>
              <td><?php if ($config_guest_checkout) { ?>
                <input type="radio" name="config_guest_checkout" value="1" checked="checked" />
                <?php echo $text_yes; ?>
                <input type="radio" name="config_guest_checkout" value="0" />
                <?php echo $text_no; ?>
                <?php } else { ?>
                <input type="radio" name="config_guest_checkout" value="1" />
                <?php echo $text_yes; ?>
                <input type="radio" name="config_guest_checkout" value="0" checked="checked" />
                <?php echo $text_no; ?>
                <?php } ?></td>
            </tr>
            <tr>
              <td><?php echo $entry_account; ?></td>
              <td><select name="config_account_id">
                  <option value="0"><?php echo $text_none; ?></option>
                  <?php foreach ($informations as $information) { ?>
                  <?php if ($information['information_id'] == $config_account_id) { ?>
                  <option value="<?php echo $information['information_id']; ?>" selected="selected"><?php echo $information['title']; ?></option>
                  <?php } else { ?>
                  <option value="<?php echo $information['information_id']; ?>"><?php echo $information['title']; ?></option>
                  <?php } ?>
                  <?php } ?>
                </select></td>
            </tr>
            <tr>
              <td><?php echo $entry_checkout; ?></td>
              <td><select name="config_checkout_id">
                  <option value="0"><?php echo $text_none; ?></option>
                  <?php foreach ($informations as $information) { ?>
                  <?php if ($information['information_id'] == $config_checkout_id) { ?>
                  <option value="<?php echo $information['information_id']; ?>" selected="selected"><?php echo $information['title']; ?></option>
                  <?php } else { ?>
                  <option value="<?php echo $information['information_id']; ?>"><?php echo $information['title']; ?></option>
                  <?php } ?>
                  <?php } ?>
                </select></td>
            </tr>
            <tr>
              <td><?php echo $entry_affiliate; ?></td>
              <td><select name="config_affiliate_id">
                  <option value="0"><?php echo $text_none; ?></option>
                  <?php foreach ($informations as $information) { ?>
                  <?php if ($information['information_id'] == $config_affiliate_id) { ?>
                  <option value="<?php echo $information['information_id']; ?>" selected="selected"><?php echo $information['title']; ?></option>
                  <?php } else { ?>
                  <option value="<?php echo $information['information_id']; ?>"><?php echo $information['title']; ?></option>
                  <?php } ?>
                  <?php } ?>
                </select></td>
            </tr>
            <tr>
              <td><?php echo $entry_commission; ?></td>
              <td><input type="text" name="config_commission" value="<?php echo $config_commission; ?>" size="3" /></td>
            </tr>
            <tr>
              <td><?php echo $entry_stock_display; ?></td>
              <td><?php if ($config_stock_display) { ?>
                <input type="radio" name="config_stock_display" value="1" checked="checked" />
                <?php echo $text_yes; ?>
                <input type="radio" name="config_stock_display" value="0" />
                <?php echo $text_no; ?>
                <?php } else { ?>
                <input type="radio" name="config_stock_display" value="1" />
                <?php echo $text_yes; ?>
                <input type="radio" name="config_stock_display" value="0" checked="checked" />
                <?php echo $text_no; ?>
                <?php } ?></td>
            </tr>
            <tr>
              <td><?php echo $entry_stock_warning; ?></td>
              <td><?php if ($config_stock_warning) { ?>
                <input type="radio" name="config_stock_warning" value="1" checked="checked" />
                <?php echo $text_yes; ?>
                <input type="radio" name="config_stock_warning" value="0" />
                <?php echo $text_no; ?>
                <?php } else { ?>
                <input type="radio" name="config_stock_warning" value="1" />
                <?php echo $text_yes; ?>
                <input type="radio" name="config_stock_warning" value="0" checked="checked" />
                <?php echo $text_no; ?>
                <?php } ?></td>
            </tr>
            <tr>
              <td><?php echo $entry_stock_checkout; ?></td>
              <td><?php if ($config_stock_checkout) { ?>
                <input type="radio" name="config_stock_checkout" value="1" checked="checked" />
                <?php echo $text_yes; ?>
                <input type="radio" name="config_stock_checkout" value="0" />
                <?php echo $text_no; ?>
                <?php } else { ?>
                <input type="radio" name="config_stock_checkout" value="1" />
                <?php echo $text_yes; ?>
                <input type="radio" name="config_stock_checkout" value="0" checked="checked" />
                <?php echo $text_no; ?>
                <?php } ?></td>
            </tr>
            <tr>
              <td><?php echo $entry_stock_status; ?></td>
              <td><select name="config_stock_status_id">
                  <?php foreach ($stock_statuses as $stock_status) { ?>
                  <?php if ($stock_status['stock_status_id'] == $config_stock_status_id) { ?>
                  <option value="<?php echo $stock_status['stock_status_id']; ?>" selected="selected"><?php echo $stock_status['name']; ?></option>
                  <?php } else { ?>
                  <option value="<?php echo $stock_status['stock_status_id']; ?>"><?php echo $stock_status['name']; ?></option>
                  <?php } ?>
                  <?php } ?>
                </select></td>
            </tr>
            <tr>
              <td><?php echo $entry_order_status; ?></td>
              <td><select name="config_order_status_id">
                  <?php foreach ($order_statuses as $order_status) { ?>
                  <?php if ($order_status['order_status_id'] == $config_order_status_id) { ?>
                  <option value="<?php echo $order_status['order_status_id']; ?>" selected="selected"><?php echo $order_status['name']; ?></option>
                  <?php } else { ?>
                  <option value="<?php echo $order_status['order_status_id']; ?>"><?php echo $order_status['name']; ?></option>
                  <?php } ?>
                  <?php } ?>
                </select></td>
            </tr>
            <tr>
              <td><?php echo $entry_complete_status; ?></td>
              <td><select name="config_complete_status_id">
                  <?php foreach ($order_statuses as $order_status) { ?>
                  <?php if ($order_status['order_status_id'] == $config_complete_status_id) { ?>
                  <option value="<?php echo $order_status['order_status_id']; ?>" selected="selected"><?php echo $order_status['name']; ?></option>
                  <?php } else { ?>
                  <option value="<?php echo $order_status['order_status_id']; ?>"><?php echo $order_status['name']; ?></option>
                  <?php } ?>
                  <?php } ?>
                </select></td>
            </tr>
            <tr>
              <td><?php echo $entry_return_status; ?></td>
              <td><select name="config_return_status_id">
                  <?php foreach ($return_statuses as $return_status) { ?>
                  <?php if ($return_status['return_status_id'] == $config_return_status_id) { ?>
                  <option value="<?php echo $return_status['return_status_id']; ?>" selected="selected"><?php echo $return_status['name']; ?></option>
                  <?php } else { ?>
                  <option value="<?php echo $return_status['return_status_id']; ?>"><?php echo $return_status['name']; ?></option>
                  <?php } ?>
                  <?php } ?>
                </select></td>
            </tr>
            <tr>
              <td><?php echo $entry_review; ?></td>
              <td><?php if ($config_review_status) { ?>
                <input type="radio" name="config_review_status" value="1" checked="checked" />
                <?php echo $text_yes; ?>
                <input type="radio" name="config_review_status" value="0" />
                <?php echo $text_no; ?>
                <?php } else { ?>
                <input type="radio" name="config_review_status" value="1" />
                <?php echo $text_yes; ?>
                <input type="radio" name="config_review_status" value="0" checked="checked" />
                <?php echo $text_no; ?>
                <?php } ?></td>
            </tr>
            <tr>
              <td><?php echo $entry_download; ?></td>
              <td><?php if ($config_download) { ?>
                <input type="radio" name="config_download" value="1" checked="checked" />
                <?php echo $text_yes; ?>
                <input type="radio" name="config_download" value="0" />
                <?php echo $text_no; ?>
                <?php } else { ?>
                <input type="radio" name="config_download" value="1" />
                <?php echo $text_yes; ?>
                <input type="radio" name="config_download" value="0" checked="checked" />
                <?php echo $text_no; ?>
                <?php } ?></td>
            </tr>
            <tr>
              <td><?php echo $entry_upload_allowed; ?></td>
              <td><textarea name="config_upload_allowed" cols="40" rows="5"><?php echo $config_upload_allowed; ?></textarea></td>
            </tr>
            <tr>
              <td><?php echo $entry_cart_weight; ?></td>
              <td><?php if ($config_cart_weight) { ?>
                <input type="radio" name="config_cart_weight" value="1" checked="checked" />
                <?php echo $text_yes; ?>
                <input type="radio" name="config_cart_weight" value="0" />
                <?php echo $text_no; ?>
                <?php } else { ?>
                <input type="radio" name="config_cart_weight" value="1" />
                <?php echo $text_yes; ?>
                <input type="radio" name="config_cart_weight" value="0" checked="checked" />
                <?php echo $text_no; ?>
                <?php } ?></td>
            </tr>
          </table>
        </div>
        <div id="tab-image">
          <table class="form">
            <tr>
              <td><?php echo $entry_logo; ?></td>
              <td><div class="image"><img src="<?php echo $logo; ?>" alt="" id="thumb-logo" />
                  <input type="hidden" name="config_logo" value="<?php echo $config_logo; ?>" id="logo" />
                  <br />
                  <a onclick="image_upload('logo', 'thumb-logo');"><?php echo $text_browse; ?></a>&nbsp;&nbsp;|&nbsp;&nbsp;<a onclick="$('#thumb-logo').attr('src', '<?php echo $no_image; ?>'); $('#logo').attr('value', '');"><?php echo $text_clear; ?></a></div></td>
            </tr>
            <tr>
              <td><?php echo $entry_icon; ?></td>
              <td><div class="image"><img src="<?php echo $icon; ?>" alt="" id="thumb-icon" />
                  <input type="hidden" name="config_icon" value="<?php echo $config_icon; ?>" id="icon" />
                  <br />
                  <a onclick="image_upload('icon', 'thumb-icon');"><?php echo $text_browse; ?></a>&nbsp;&nbsp;|&nbsp;&nbsp;<a onclick="$('#thumb-icon').attr('src', '<?php echo $no_image; ?>'); $('#icon').attr('value', '');"><?php echo $text_clear; ?></a></div></td>
            </tr>
            <tr>
              <td><span class="required">*</span> <?php echo $entry_image_category; ?></td>
              <td><input type="text" name="config_image_category_width" value="<?php echo $config_image_category_width; ?>" size="3" />
                x
                <input type="text" name="config_image_category_height" value="<?php echo $config_image_category_height; ?>" size="3" />
                <?php if ($error_image_category) { ?>
                <span class="error"><?php echo $error_image_category; ?></span>
                <?php } ?></td>
            </tr>
            <tr>
              <td><span class="required">*</span> <?php echo $entry_image_thumb; ?></td>
              <td><input type="text" name="config_image_thumb_width" value="<?php echo $config_image_thumb_width; ?>" size="3" />
                x
                <input type="text" name="config_image_thumb_height" value="<?php echo $config_image_thumb_height; ?>" size="3" />
                <?php if ($error_image_thumb) { ?>
                <span class="error"><?php echo $error_image_thumb; ?></span>
                <?php } ?></td>
            </tr>
            <tr>
              <td><span class="required">*</span> <?php echo $entry_image_popup; ?></td>
              <td><input type="text" name="config_image_popup_width" value="<?php echo $config_image_popup_width; ?>" size="3" />
                x
                <input type="text" name="config_image_popup_height" value="<?php echo $config_image_popup_height; ?>" size="3" />
                <?php if ($error_image_popup) { ?>
                <span class="error"><?php echo $error_image_popup; ?></span>
                <?php } ?></td>
            </tr>
            <tr>
              <td><span class="required">*</span> <?php echo $entry_image_product; ?></td>
              <td><input type="text" name="config_image_product_width" value="<?php echo $config_image_product_width; ?>" size="3" />
                x
                <input type="text" name="config_image_product_height" value="<?php echo $config_image_product_height; ?>" size="3" />
                <?php if ($error_image_product) { ?>
                <span class="error"><?php echo $error_image_product; ?></span>
                <?php } ?></td>
            </tr>
            <tr>
              <td><span class="required">*</span> <?php echo $entry_image_additional; ?></td>
              <td><input type="text" name="config_image_additional_width" value="<?php echo $config_image_additional_width; ?>" size="3" />
                x
                <input type="text" name="config_image_additional_height" value="<?php echo $config_image_additional_height; ?>" size="3" />
                <?php if ($error_image_additional) { ?>
                <span class="error"><?php echo $error_image_additional; ?></span>
                <?php } ?></td>
            </tr>
            <tr>
              <td><span class="required">*</span> <?php echo $entry_image_related; ?></td>
              <td><input type="text" name="config_image_related_width" value="<?php echo $config_image_related_width; ?>" size="3" />
                x
                <input type="text" name="config_image_related_height" value="<?php echo $config_image_related_height; ?>" size="3" />
                <?php if ($error_image_related) { ?>
                <span class="error"><?php echo $error_image_related; ?></span>
                <?php } ?></td>
            </tr>
            <tr>
              <td><span class="required">*</span> <?php echo $entry_image_compare; ?></td>
              <td><input type="text" name="config_image_compare_width" value="<?php echo $config_image_compare_width; ?>" size="3" />
                x
                <input type="text" name="config_image_compare_height" value="<?php echo $config_image_compare_height; ?>" size="3" />
                <?php if ($error_image_compare) { ?>
                <span class="error"><?php echo $error_image_compare; ?></span>
                <?php } ?></td>
            </tr>
            <tr>
              <td><span class="required">*</span> <?php echo $entry_image_wishlist; ?></td>
              <td><input type="text" name="config_image_wishlist_width" value="<?php echo $config_image_wishlist_width; ?>" size="3" />
                x
                <input type="text" name="config_image_wishlist_height" value="<?php echo $config_image_wishlist_height; ?>" size="3" />
                <?php if ($error_image_wishlist) { ?>
                <span class="error"><?php echo $error_image_wishlist; ?></span>
                <?php } ?></td>
            </tr>
            <tr>
              <td><span class="required">*</span> <?php echo $entry_image_cart; ?></td>
              <td><input type="text" name="config_image_cart_width" value="<?php echo $config_image_cart_width; ?>" size="3" />
                x
                <input type="text" name="config_image_cart_height" value="<?php echo $config_image_cart_height; ?>" size="3" />
                <?php if ($error_image_cart) { ?>
                <span class="error"><?php echo $error_image_cart; ?></span>
                <?php } ?></td>
            </tr>
          </table>
        </div>
        <div id="tab-mail">
          <table class="form">
            <tr>
              <td><?php echo $entry_mail_protocol; ?></td>
              <td><select name="config_mail_protocol">
                  <?php if ($config_mail_protocol == 'mail') { ?>
                  <option value="mail" selected="selected"><?php echo $text_mail; ?></option>
                  <?php } else { ?>
                  <option value="mail"><?php echo $text_mail; ?></option>
                  <?php } ?>
                  <?php if ($config_mail_protocol == 'smtp') { ?>
                  <option value="smtp" selected="selected"><?php echo $text_smtp; ?></option>
                  <?php } else { ?>
                  <option value="smtp"><?php echo $text_smtp; ?></option>
                  <?php } ?>
                </select></td>
            </tr>
            <tr>
              <td><?php echo $entry_mail_parameter; ?></td>
              <td><input type="text" name="config_mail_parameter" value="<?php echo $config_mail_parameter; ?>" /></td>
            </tr>
            <tr>
              <td><?php echo $entry_smtp_host; ?></td>
              <td><input type="text" name="config_smtp_host" value="<?php echo $config_smtp_host; ?>" /></td>
            </tr>
            <tr>
              <td><?php echo $entry_smtp_username; ?></td>
              <td><input type="text" name="config_smtp_username" value="<?php echo $config_smtp_username; ?>" /></td>
            </tr>
            <tr>
              <td><?php echo $entry_smtp_password; ?></td>
              <td><input type="text" name="config_smtp_password" value="<?php echo $config_smtp_password; ?>" /></td>
            </tr>
            <tr>
              <td><?php echo $entry_smtp_port; ?></td>
              <td><input type="text" name="config_smtp_port" value="<?php echo $config_smtp_port; ?>" /></td>
            </tr>
            <tr>
              <td><?php echo $entry_smtp_timeout; ?></td>
              <td><input type="text" name="config_smtp_timeout" value="<?php echo $config_smtp_timeout; ?>" /></td>
            </tr>
            <tr>
              <td><?php echo $entry_alert_mail; ?></td>
              <td><?php if ($config_alert_mail) { ?>
                <input type="radio" name="config_alert_mail" value="1" checked="checked" />
                <?php echo $text_yes; ?>
                <input type="radio" name="config_alert_mail" value="0" />
                <?php echo $text_no; ?>
                <?php } else { ?>
                <input type="radio" name="config_alert_mail" value="1" />
                <?php echo $text_yes; ?>
                <input type="radio" name="config_alert_mail" value="0" checked="checked" />
                <?php echo $text_no; ?>
                <?php } ?></td>
            </tr>
            <tr>
              <td><?php echo $entry_account_mail; ?></td>
              <td><?php if ($config_account_mail) { ?>
                <input type="radio" name="config_account_mail" value="1" checked="checked" />
                <?php echo $text_yes; ?>
                <input type="radio" name="config_account_mail" value="0" />
                <?php echo $text_no; ?>
                <?php } else { ?>
                <input type="radio" name="config_account_mail" value="1" />
                <?php echo $text_yes; ?>
                <input type="radio" name="config_account_mail" value="0" checked="checked" />
                <?php echo $text_no; ?>
                <?php } ?></td>
            </tr>
            <tr>
              <td><?php echo $entry_alert_emails; ?></td>
              <td><textarea name="config_alert_emails" cols="40" rows="5"><?php echo $config_alert_emails; ?></textarea></td>
            </tr>
          </table>
        </div>
        <div id="tab-server">
          <table class="form">
            <tr>
              <td><?php echo $entry_use_ssl; ?></td>
              <td><?php if ($config_use_ssl) { ?>
                <input type="radio" name="config_use_ssl" value="1" checked="checked" />
                <?php echo $text_yes; ?>
                <input type="radio" name="config_use_ssl" value="0" />
                <?php echo $text_no; ?>
                <?php } else { ?>
                <input type="radio" name="config_use_ssl" value="1" />
                <?php echo $text_yes; ?>
                <input type="radio" name="config_use_ssl" value="0" checked="checked" />
                <?php echo $text_no; ?>
                <?php } ?></td>
            </tr>
            <tr>
              <td><?php echo $entry_seo_url; ?></td>
              <td><?php if ($config_seo_url) { ?>
                <input type="radio" name="config_seo_url" value="1" checked="checked" />
                <?php echo $text_yes; ?>
                <input type="radio" name="config_seo_url" value="0" />
                <?php echo $text_no; ?>
                <?php } else { ?>
                <input type="radio" name="config_seo_url" value="1" />
                <?php echo $text_yes; ?>
                <input type="radio" name="config_seo_url" value="0" checked="checked" />
                <?php echo $text_no; ?>
                <?php } ?></td>
            </tr>
            <tr>
              <td><?php echo $entry_maintenance; ?></td>
              <td><?php if ($config_maintenance) { ?>
                <input type="radio" name="config_maintenance" value="1" checked="checked" />
                <?php echo $text_yes; ?>
                <input type="radio" name="config_maintenance" value="0" />
                <?php echo $text_no; ?>
                <?php } else { ?>
                <input type="radio" name="config_maintenance" value="1" />
                <?php echo $text_yes; ?>
                <input type="radio" name="config_maintenance" value="0" checked="checked" />
                <?php echo $text_no; ?>
                <?php } ?></td>
            </tr>
            <tr>
              <td><?php echo $entry_encryption; ?></td>
              <td><input type="text" name="config_encryption" value="<?php echo $config_encryption; ?>" /></td>
            </tr>
            <tr>
              <td><?php echo $entry_compression; ?></td>
              <td><input type="text" name="config_compression" value="<?php echo $config_compression; ?>" size="3" /></td>
            </tr>
            <tr>
              <td><?php echo $entry_error_display; ?></td>
              <td><?php if ($config_error_display) { ?>
                <input type="radio" name="config_error_display" value="1" checked="checked" />
                <?php echo $text_yes; ?>
                <input type="radio" name="config_error_display" value="0" />
                <?php echo $text_no; ?>
                <?php } else { ?>
                <input type="radio" name="config_error_display" value="1" />
                <?php echo $text_yes; ?>
                <input type="radio" name="config_error_display" value="0" checked="checked" />
                <?php echo $text_no; ?>
                <?php } ?></td>
            </tr>
            <tr>
              <td><?php echo $entry_error_log; ?></td>
              <td><?php if ($config_error_log) { ?>
                <input type="radio" name="config_error_log" value="1" checked="checked" />
                <?php echo $text_yes; ?>
                <input type="radio" name="config_error_log" value="0" />
                <?php echo $text_no; ?>
                <?php } else { ?>
                <input type="radio" name="config_error_log" value="1" />
                <?php echo $text_yes; ?>
                <input type="radio" name="config_error_log" value="0" checked="checked" />
                <?php echo $text_no; ?>
                <?php } ?></td>
            </tr>
            <tr>
              <td><span class="required">*</span> <?php echo $entry_error_filename; ?></td>
              <td><input type="text" name="config_error_filename" value="<?php echo $config_error_filename; ?>" />
                <?php if ($error_error_filename) { ?>
                <span class="error"><?php echo $error_error_filename; ?></span>
                <?php } ?></td>
            </tr>
            <tr>
              <td><?php echo $entry_google_analytics; ?></td>
              <td><textarea name="config_google_analytics" cols="40" rows="5"><?php echo $config_google_analytics; ?></textarea></td>
            </tr>
          </table>
        </div>
		
		<div id="tab-productsetting">
          <table class="form">
             <tr>
              <td>Additional Costs:</td>
              <td><input type="text" name="additionalCosts" value="<?php echo $additionalCosts; ?>" /></td>
            </tr>
			 <!-- <tr>
              <td>Overriding Markup Absolute:</td>
              <td><input type="text" name="overriding_mark_up_ubsolute" value="<?php echo $overriding_mark_up_ubsolute; ?>" /></td>
            </tr> --->
			 <tr>
              <td>Overriding Markup Percentage:</td>
              <td><input type="text" name="overriding_markup_percentage" value="<?php echo $overriding_markup_percentage; ?>" /></td>
            </tr>
          </table>
		  <table border="0" cellspacing="10" width="70%">
			<tr>
				<th>Price Limit</th>
				<th>Additional Costs</th>
				<th>Overriding Markup Percentage</th>
				<th>Wholesale Overriding Markup Percentage</th>
				<th>Wholesale Markup Multiple</th>
			</tr>
			<tr>
				<td width="20%" style="text-align:center;"><input type="text" name="pricelimit_one" value="<?php echo $pricelimit_one; ?>" /></td> 
				<td width="20%" style="text-align:center;"><input type="text" name="additionalcost_one" value="<?php echo $additionalcost_one; ?>" /></td>
				<td width="20%" style="text-align:center;"><input type="text" name="overriding_one" value="<?php echo $overriding_one; ?>" /></td>
				<td width="20%" style="text-align:center;"><input type="text" name="wholeoverriding_one" value="<?php echo $wholeoverriding_one; ?>" /></td>
				<td width="20%" style="text-align:center;"><input type="text" name="wholemarkup_one" value="<?php echo $wholemarkup_one; ?>" /></td>
			</tr>
			<tr>
				<td style="text-align:center;"><input type="text" name="pricelimit_two" value="<?php echo $pricelimit_two; ?>" /></td>
				<td style="text-align:center;"><input type="text" name="additionalcost_two" value="<?php echo $additionalcost_two; ?>" /></td>
				<td style="text-align:center;"><input type="text" name="overriding_two" value="<?php echo $overriding_two; ?>" /></td>
				<td style="text-align:center;"><input type="text" name="wholeoverriding_two" value="<?php echo $wholeoverriding_two; ?>" /></td>
				<td style="text-align:center;"><input type="text" name="wholemarkup_two" value="<?php echo $wholemarkup_two; ?>" /></td>
			</tr>
			<tr>
				<td style="text-align:center;"><input type="text" name="pricelimit_three" value="<?php echo $pricelimit_three; ?>" /></td>
				<td style="text-align:center;"><input type="text" name="additionalcost_three" value="<?php echo $additionalcost_three; ?>" /></td>
				<td style="text-align:center;"><input type="text" name="overriding_three" value="<?php echo $overriding_three; ?>" /></td>
				<td style="text-align:center;"><input type="text" name="wholeoverriding_three" value="<?php echo $wholeoverriding_three; ?>" /></td>
				<td style="text-align:center;"><input type="text" name="wholemarkup_three" value="<?php echo $wholemarkup_three; ?>" /></td>
			</tr>
			<tr>
				<td style="text-align:center;"><input type="text" name="pricelimit_four" value="<?php echo $pricelimit_four; ?>" /></td>
				<td style="text-align:center;"><input type="text" name="additionalcost_four" value="<?php echo $additionalcost_four; ?>" /></td>
				<td style="text-align:center;"><input type="text" name="overriding_four" value="<?php echo $overriding_four; ?>" /></td>
				<td style="text-align:center;"><input type="text" name="wholeoverriding_four" value="<?php echo $wholeoverriding_four; ?>" /></td>
				<td style="text-align:center;"><input type="text" name="wholemarkup_four" value="<?php echo $wholemarkup_four; ?>" /></td>
			</tr>
			<tr>
				<td style="text-align:center;"><input type="text" name="pricelimit_five" value="<?php echo $pricelimit_five; ?>" /></td>
				<td style="text-align:center;"><input type="text" name="additionalcost_five" value="<?php echo $additionalcost_five; ?>" /></td>
				<td style="text-align:center;"><input type="text" name="overriding_five" value="<?php echo $overriding_five; ?>" /></td>
				<td style="text-align:center;"><input type="text" name="wholeoverriding_five" value="<?php echo $wholeoverriding_five; ?>" /></td>
				<td style="text-align:center;"><input type="text" name="wholemarkup_five" value="<?php echo $wholemarkup_five; ?>" /></td>
			</tr>
		</table>
        </div>
		

		<div id="tab-diamondproductsetting">
          <table class="form">
             <tr>
              <td>Additional Costs:</td>
              <td><input type="text" name="additionalDiamondCosts" value="<?php echo $additionalDiamondCosts; ?>" /></td>
            </tr>
			 <!-- <tr>
              <td>Overriding Markup Absolute:</td>
              <td><input type="text" name="overriding_mark_up_ubsolute" value="<?php echo $overriding_mark_up_ubsolute; ?>" /></td>
            </tr> --->
			 <tr>
              <td>Overriding Markup Percentage:</td>
              <td><input type="text" name="overriding_markup_diamond_percentage" value="<?php echo $overriding_markup_diamond_percentage; ?>" /></td>
            </tr>
          </table>
		  <table border="0" cellspacing="10" width="70%">
			<tr>
				<th>Price Limit</th>
				<th>Additional Costs Absolute</th>
				<th>Additional Cost %</th>
				<th>Wholesale Markup%</th>
				<th>Retail Markup%</th>
			</tr>
			<tr>
				<td width="20%" style="text-align:center;"><input type="text" name="pricelimit_1" value="<?php echo $pricelimit_1; ?>" /></td> 
				<td width="20%" style="text-align:center;"><input type="text" name="additionalcost_1" value="<?php echo $additionalcost_1; ?>" /></td>
				<td width="20%" style="text-align:center;"><input type="text" name="additionalcostpercent_1" value="<?php echo $additionalcostpercent_1; ?>" /></td>
				<td width="20%" style="text-align:center;"><input type="text" name="overriding_1" value="<?php echo $overriding_1; ?>" /></td>
				<td width="20%" style="text-align:center;"><input type="text" name="wholeoverriding_1" value="<?php echo $wholeoverriding_1; ?>" /></td>
			</tr>
			<tr>
				<td style="text-align:center;"><input type="text" name="pricelimit_2" value="<?php echo $pricelimit_2; ?>" /></td>
				<td style="text-align:center;"><input type="text" name="additionalcost_2" value="<?php echo $additionalcost_2; ?>" /></td>
				<td style="text-align:center;"><input type="text" name="additionalcostpercent_2" value="<?php echo $additionalcostpercent_2; ?>" /></td>
				<td style="text-align:center;"><input type="text" name="overriding_2" value="<?php echo $overriding_2; ?>" /></td>
				<td style="text-align:center;"><input type="text" name="wholeoverriding_2" value="<?php echo $wholeoverriding_2; ?>" /></td>
			</tr>
			<tr>
				<td style="text-align:center;"><input type="text" name="pricelimit_3" value="<?php echo $pricelimit_3; ?>" /></td>
				<td style="text-align:center;"><input type="text" name="additionalcost_3" value="<?php echo $additionalcost_3; ?>" /></td>
				<td style="text-align:center;"><input type="text" name="additionalcostpercent_3" value="<?php echo $additionalcostpercent_3; ?>" /></td>
				<td style="text-align:center;"><input type="text" name="overriding_3" value="<?php echo $overriding_3; ?>" /></td>
				<td style="text-align:center;"><input type="text" name="wholeoverriding_3" value="<?php echo $wholeoverriding_3; ?>" /></td>
			</tr>
			<tr>
				<td style="text-align:center;"><input type="text" name="pricelimit_4" value="<?php echo $pricelimit_4; ?>" /></td>
				<td style="text-align:center;"><input type="text" name="additionalcost_4" value="<?php echo $additionalcost_4; ?>" /></td>
				<td style="text-align:center;"><input type="text" name="additionalcostpercent_4" value="<?php echo $additionalcostpercent_4; ?>" /></td>
				<td style="text-align:center;"><input type="text" name="overriding_4" value="<?php echo $overriding_4; ?>" /></td>
				<td style="text-align:center;"><input type="text" name="wholeoverriding_4" value="<?php echo $wholeoverriding_4; ?>" /></td>
			</tr>
			<tr>
				<td style="text-align:center;"><input type="text" name="pricelimit_5" value="<?php echo $pricelimit_5; ?>" /></td>
				<td style="text-align:center;"><input type="text" name="additionalcost_5" value="<?php echo $additionalcost_5; ?>" /></td>
				<td style="text-align:center;"><input type="text" name="additionalcostpercent_5" value="<?php echo $additionalcostpercent_5; ?>" /></td>
				<td style="text-align:center;"><input type="text" name="overriding_5" value="<?php echo $overriding_5; ?>" /></td>
				<td style="text-align:center;"><input type="text" name="wholeoverriding_5" value="<?php echo $wholeoverriding_5; ?>" /></td>
			</tr>

			<tr>
				<td style="text-align:center;"><input type="text" name="pricelimit_6" value="<?php echo $pricelimit_6; ?>" /></td>
				<td style="text-align:center;"><input type="text" name="additionalcost_6" value="<?php echo $additionalcost_6; ?>" /></td>
				<td style="text-align:center;"><input type="text" name="additionalcostpercent_6" value="<?php echo $additionalcostpercent_6; ?>" /></td>
				<td style="text-align:center;"><input type="text" name="overriding_6" value="<?php echo $overriding_6; ?>" /></td>
				<td style="text-align:center;"><input type="text" name="wholeoverriding_6" value="<?php echo $wholeoverriding_6; ?>" /></td>
			</tr>
			<tr>
				<td style="text-align:center;"><input type="text" name="pricelimit_7" value="<?php echo $pricelimit_7; ?>" /></td>
				<td style="text-align:center;"><input type="text" name="additionalcost_7" value="<?php echo $additionalcost_7; ?>" /></td>
				<td style="text-align:center;"><input type="text" name="additionalcostpercent_7" value="<?php echo $additionalcostpercent_7; ?>" /></td>
				<td style="text-align:center;"><input type="text" name="overriding_7" value="<?php echo $overriding_7; ?>" /></td>
				<td style="text-align:center;"><input type="text" name="wholeoverriding_7" value="<?php echo $wholeoverriding_7; ?>" /></td>
			</tr>
			<tr>
				<td style="text-align:center;"><input type="text" name="pricelimit_8" value="<?php echo $pricelimit_8; ?>" /></td>
				<td style="text-align:center;"><input type="text" name="additionalcost_8" value="<?php echo $additionalcost_8; ?>" /></td>
				<td style="text-align:center;"><input type="text" name="additionalcostpercent_8" value="<?php echo $additionalcostpercent_8; ?>" /></td>
				<td style="text-align:center;"><input type="text" name="overriding_8" value="<?php echo $overriding_8; ?>" /></td>
				<td style="text-align:center;"><input type="text" name="wholeoverriding_8" value="<?php echo $wholeoverriding_8; ?>" /></td>
			</tr>
			<tr>
				<td style="text-align:center;"><input type="text" name="pricelimit_9" value="<?php echo $pricelimit_9; ?>" /></td>
				<td style="text-align:center;"><input type="text" name="additionalcost_9" value="<?php echo $additionalcost_9; ?>" /></td>
				<td style="text-align:center;"><input type="text" name="additionalcostpercent_9" value="<?php echo $additionalcostpercent_9; ?>" /></td>
				<td style="text-align:center;"><input type="text" name="overriding_9" value="<?php echo $overriding_9; ?>" /></td>
				<td style="text-align:center;"><input type="text" name="wholeoverriding_9" value="<?php echo $wholeoverriding_9; ?>" /></td>
			</tr>
			<tr>
				<td style="text-align:center;"><input type="text" name="pricelimit_10" value="<?php echo $pricelimit_10; ?>" /></td>
				<td style="text-align:center;"><input type="text" name="additionalcost_10" value="<?php echo $additionalcost_10; ?>" /></td>
				<td style="text-align:center;"><input type="text" name="additionalcostpercent_10" value="<?php echo $additionalcostpercent_10; ?>" /></td>
				<td style="text-align:center;"><input type="text" name="overriding_10" value="<?php echo $overriding_10; ?>" /></td>
				<td style="text-align:center;"><input type="text" name="wholeoverriding_10" value="<?php echo $wholeoverriding_10; ?>" /></td>
			</tr>	
			<tr>
				<td style="text-align:center;"><input type="text" name="pricelimit_11" value="<?php echo $pricelimit_11; ?>" /></td>
				<td style="text-align:center;"><input type="text" name="additionalcost_11" value="<?php echo $additionalcost_11; ?>" /></td>
				<td style="text-align:center;"><input type="text" name="additionalcostpercent_11" value="<?php echo $additionalcostpercent_11; ?>" /></td>
				<td style="text-align:center;"><input type="text" name="overriding_11" value="<?php echo $overriding_11; ?>" /></td>
				<td style="text-align:center;"><input type="text" name="wholeoverriding_11" value="<?php echo $wholeoverriding_11; ?>" /></td>
			</tr>
			<tr>
				<td style="text-align:center;"><input type="text" name="pricelimit_12" value="<?php echo $pricelimit_12; ?>" /></td>
				<td style="text-align:center;"><input type="text" name="additionalcost_12" value="<?php echo $additionalcost_12; ?>" /></td>
				<td style="text-align:center;"><input type="text" name="additionalcostpercent_12" value="<?php echo $additionalcostpercent_12; ?>" /></td>
				<td style="text-align:center;"><input type="text" name="overriding_12" value="<?php echo $overriding_12; ?>" /></td>
				<td style="text-align:center;"><input type="text" name="wholeoverriding_12" value="<?php echo $wholeoverriding_12; ?>" /></td>
			</tr>
			<tr>
				<td style="text-align:center;"><input type="text" name="pricelimit_13" value="<?php echo $pricelimit_13; ?>" /></td>
				<td style="text-align:center;"><input type="text" name="additionalcost_13" value="<?php echo $additionalcost_13; ?>" /></td>
				<td style="text-align:center;"><input type="text" name="additionalcostpercent_13" value="<?php echo $additionalcostpercent_13; ?>" /></td>
				<td style="text-align:center;"><input type="text" name="overriding_13" value="<?php echo $overriding_13; ?>" /></td>
				<td style="text-align:center;"><input type="text" name="wholeoverriding_13" value="<?php echo $wholeoverriding_13; ?>" /></td>
			</tr>
			<tr>
				<td style="text-align:center;"><input type="text" name="pricelimit_14" value="<?php echo $pricelimit_14; ?>" /></td>
				<td style="text-align:center;"><input type="text" name="additionalcost_14" value="<?php echo $additionalcost_14; ?>" /></td>
				<td style="text-align:center;"><input type="text" name="additionalcostpercent_14" value="<?php echo $additionalcostpercent_14; ?>" /></td>
				<td style="text-align:center;"><input type="text" name="overriding_14" value="<?php echo $overriding_14; ?>" /></td>
				<td style="text-align:center;"><input type="text" name="wholeoverriding_14" value="<?php echo $wholeoverriding_14; ?>" /></td>
			</tr>	
			
		</table>
        </div>		
		
		
		
		<div id="tab-rapnet">
          <table class="form">
             <tr>
              <td>URL:</td>
              <td><textarea name="rapneturl" style="margin: 2px; width: 400px; height: 225px;" /><?php echo $rapneturl; ?></textarea></td>
            </tr>
          </table>
			<a style="float:right;" target="_blank" href='http://www.tresorjewellery.com.au/rapnet/sample.php' class="button">Click to Run Rapnet Script</a>
        </div>
		<div id="tab-rewardmaster">
          <table class="form">
             <tr>
              <td>Designer Reward Sale Based    (in Percentage) :</td>
              <td><input type="text" name="designer_reward_sale_based" value="<?php echo $designer_reward_sale_based; ?>" /></textarea></td>
            </tr>
             <tr>
              <td>Customer Reward Sale Based    (in Percentage) :</td>
              <td><input type="text" name="customer_reward_sale_based" value="<?php echo $customer_reward_sale_based; ?>" /></textarea></td>
            </tr>
             <tr>
              <td>Group Reward Sale Based    (in Percentage) :</td>
              <td><input type="text" name="group_reward_sale_based" value="<?php echo $group_reward_sale_based; ?>" /></textarea></td>
            </tr>
          </table>
        </div>
		
		
      </form>
    </div>
  </div>
</div>
<script type="text/javascript"><!--
$('#template').load('index.php?route=setting/setting/template&token=<?php echo $token; ?>&template=' + encodeURIComponent($('select[name=\'config_template\']').attr('value')));

$('select[name=\'config_zone_id\']').load('index.php?route=setting/setting/zone&token=<?php echo $token; ?>&country_id=<?php echo $config_country_id; ?>&zone_id=<?php echo $config_zone_id; ?>');
//--></script> 
<script type="text/javascript"><!--
function image_upload(field, thumb) {
	$('#dialog').remove();
	
	$('#content').prepend('<div id="dialog" style="padding: 3px 0px 0px 0px;"><iframe src="index.php?route=common/filemanager&token=<?php echo $token; ?>&field=' + encodeURIComponent(field) + '" style="padding:0; margin: 0; display: block; width: 100%; height: 100%;" frameborder="no" scrolling="auto"></iframe></div>');
	
	$('#dialog').dialog({
		title: '<?php echo $text_image_manager; ?>',
		close: function (event, ui) {
			if ($('#' + field).attr('value')) {
				$.ajax({
					url: 'index.php?route=common/filemanager/image&token=<?php echo $token; ?>&image=' + encodeURIComponent($('#' + field).val()),
					dataType: 'text',
					success: function(data) {
						$('#' + thumb).replaceWith('<img src="' + data + '" alt="" id="' + thumb + '" />');
					}
				});
			}
		},	
		bgiframe: false,
		width: 800,
		height: 400,
		resizable: false,
		modal: false
	});
};
//--></script> 
<script type="text/javascript"><!--
$('#tabs a').tabs();
//--></script> 
<?php echo $footer; ?>