<?php
class ControllerAffiliateSales extends Controller {
	private $error = array();

	public function index() {
		if (!$this->affiliate->isLogged()) {
      		$this->redirect(HTTP_SERVER . 'index.php?route=affiliate/account');
    	}

      	$this->document->breadcrumbs = array();

      	$this->document->breadcrumbs[] = array(
        	'href'      => HTTP_SERVER . 'index.php?route=common/home',
        	'text'      => $this->language->get('text_home'),
        	'separator' => FALSE
      	);

      	$this->document->breadcrumbs[] = array(
        	'href'      => HTTP_SERVER . 'index.php?route=affiliate/account',
        	'text'      => $this->language->get('Account'),
        	'separator' => $this->language->get('text_separator')
      	);

      	$this->document->breadcrumbs[] = array(
        	'href'      => HTTP_SERVER . 'index.php?route=affiliate/sales',
        	'text'      => $this->language->get('Sales'),
        	'separator' => $this->language->get('text_separator')
      	);


   	$this->language->load('affiliate/sales');

   	$this->data['text_Account_Details'] = $this->language->get('text_Account_Details');
   	$this->data['text_Pay_Inprogress'] = $this->language->get('text_Pay_Inprogress');
	$this->data['text_Payment_History'] = $this->language->get('text_Payment_History');
   	$this->data['text_Customer_Details'] = $this->language->get('text_Customer_Details');
   	$this->data['text_InActive'] = $this->language->get('text_InActive');
	$this->data['text_Active'] = $this->language->get('text_Active');
	$this->data['button_continue'] = $this->language->get('button_continue');

    $this->data['continue'] = $this->url->link('affiliate/account');

   	$this->data['heading_title'] = $this->language->get('heading_title');
   	$this->data['text_my_account'] = $this->language->get('text_my_account');
	$this->data['text_my_orders'] = $this->language->get('text_my_orders');


	$this->load->model('affiliate/afforder');

	$this->data['affiliate_id']=$this->affiliate->isLogged();

	$refamounts = $this->model_affiliate_afforder->getrefamount();
	$this->data['myrefamounts'] = array();
	foreach ($refamounts as $refamount)
	{
	      $this->data['myrefamounts'] = array(
	                'key'     => $refamount['key'],
	                'value'   => $refamount['value']
	      );
  }
	$refbonus = $this->model_affiliate_afforder->getrefbonus();
	$this->data['refbonusamt'] = array();
	foreach ($refbonus as $refbonus1)
	{
	      $this->data['refbonusamt'] = array(
	                'key'     => $refbonus1['key'],
	                'value'   => $refbonus1['value']
	      );
  }
	$refpercents = $this->model_affiliate_afforder->getrefpercent();
	$this->data['refpercentage'] = array();
	foreach ($refpercents as $refpercent)
	{
	      $this->data['refpercentage'] = array(
	                'key'     => $refpercent['key'],
	                'value'   => $refpercent['value']
	      );
  }

	$MyTotalReferrals = $this->model_affiliate_afforder->getTotalReferrals($this->data['affiliate_id']);
	$this->data['TotalRef'][] = array();
	foreach ($MyTotalReferrals as $TotalReferrals)
	{
	      $this->data['TotalRef'] = array(
	                  'Total' => $TotalReferrals['tot']
	      );
  }

	$GuestReferrals = $this->model_affiliate_afforder->getTotalGuestReferrals($this->data['affiliate_id']);
	$this->data['GuestCount'][] = array();
	foreach ($GuestReferrals as $GuestReferral)
	{
	      $this->data['GuestCount'] = array(
	                  'Total' => $GuestReferral['tot']
	      );
  }
	$this->data['config_refcustomer'] = $this->config->get('config_refcustomer');

	// if ($this->affiliate->affiliate_grp() != 1 )exit;
	$referral_info = $this->model_affiliate_afforder->getReferralsDetails($this->data['affiliate_id']);
  $this->data['referrals'] = array();
	foreach ($referral_info as $refers)
	{

		$this->data['referrals'][] = array(
			      'referral_id' => $refers['referral_id'],
       			'affiliate_id' => $refers['affiliate_id'],
        		'customer_id' => $refers['customer_id'],
        		'firstname' => $refers['firstname'],
        		'lastname' => $refers['lastname'],
        		'status' => $refers['status'],
       			'referred_date' => $refers['referred_date'],
   			);
	}


	$referralorder_info = $this->model_affiliate_afforder->getReferralOrderDetails($this->data['affiliate_id']);
  $this->data['referralorders'] = array();
	foreach ($referralorder_info as $refers)
	{

		$this->data['referralorders'][] = array(
			      'referral_id' => $refers['referral_id'],
       			'affiliate_id' => $refers['affiliate_id'],
        		'customer_id' => $refers['customer_id'],
        		'firstname' => $refers['firstname'],
        		'lastname' => $refers['lastname'],
       			'referred_date' => $refers['referred_date'],
       			'total' => $refers['total'],
       			'ordered_date' => $refers['date_added'],
       			'Earnings' => $refers['Earnings'],
       			'Payment_Status' => $refers['Payment_Status'],
       			'Payment_date' => $refers['Payment_date']
      			);
	}

	  $this->data['flag_payclickcount_enable']=$this->affiliate->getPayClickEnable();
	  $this->data['flag_paypercust_enable']=$this->affiliate->getPayPerCustEnable();
	  if (isset($this->request->post['config_payperaffiliate_enable'])) {
			$this->data['payperaffiliate_enable'] = $this->request->post['config_payperaffiliate_enable'];
		} else {
			$this->data['payperaffiliate_enable'] = $this->config->get('config_payperaffiliate_enable');
		}
		
		
		
		$this->load->model('affiliate/transaction');
		
 		
	  $this->data['flag_paypersale_enable']=$this->affiliate->getPayPerSaleEnable();
	  $this->data['flag_flatratesale_enable']=$this->affiliate->getFlatRateSaleEnable();

	  $AffAccInfo = $this->model_affiliate_afforder->getAffAcctDetails($this->data['affiliate_id']);
	  $this->data['AffAccDetails']= array();
	  
			$this->data['UrlCount']     =  $this->model_affiliate_afforder->getURLCount($this->data['affiliate_id']);
			$this->data['Sale_Click']   =  $this->currency->format($this->data['UrlCount'] * $this->affiliate->getPayClickCount() / $this->affiliate->getClickCount());
			$Sale_Click   =  $this->data['UrlCount'] * $this->affiliate->getPayClickCount() / $this->affiliate->getClickCount();
			
			$this->data['Total_Customers']     =  $this->model_affiliate_afforder->getTotalReferralsCount($this->data['affiliate_id']);
			$this->data['Total_Guests']		   =  $this->model_affiliate_afforder->getTotalGuestCount($this->data['affiliate_id']);
			$Sale_CustomerCount  =  $this->data['Total_Customers'] * $this->affiliate->getPayperCust();
			$this->data['Sale_CustomerCount']  =  $this->currency->format($this->data['Total_Customers'] * $this->affiliate->getPayperCust() );
			
			$Sale_Order		   =  $this->model_affiliate_afforder->getTotalSaleOrder($this->data['affiliate_id']);
			$this->data['Sale_Order']		   =  $this->currency->format($this->model_affiliate_afforder->getTotalSaleOrder($this->data['affiliate_id']));
			$this->data['Sale_Commission']     =  $this->data['UrlCount'] * $this->affiliate->getPayClickCount() / $this->affiliate->getClickCount();
			
			$this->data['afftransaction'] = $this->model_affiliate_transaction->getAffRegistration();
			$afftransaction	 =	$this->data['afftransaction'];
			
			$Sale_Total   =  $Sale_Click + $Sale_CustomerCount + $Sale_Order + $afftransaction ;
			$this->data['Sale_Total']   =  $this->currency->format($Sale_Click + $Sale_CustomerCount + $Sale_Order + $afftransaction ) ;

			

		
		if($afftransaction){
			$this->data['payperaffiliate_enable']=1;
		}
		//$balance	 =	$this->model_affiliate_transaction->getBalance(); 
		//$balance	 =	$Sale_Click + $Sale_CustomerCount  + $Sale_Order + $Sale_Total + $afftransaction;
		$balance	 =	$Sale_Click + $Sale_CustomerCount  + $Sale_Order + $afftransaction;

		$this->data['balance'] = $this->currency->format($balance);
		
		$combalances	 =	$this->model_affiliate_transaction->myadminadjustments(); 
		$this->data['combalances'] = $this->currency->format($combalances);
		
		$totalbalance   =  $balance + $combalances ;
		$this->data['totalbalance']   =  $this->currency->format($balance + $combalances) ;			
			
			
        $this->data['heading_title'] = $this->language->get('heading_title');
		$this->id       = 'content';

		if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/affiliate/sales.tpl')) {
			$this->template = $this->config->get('config_template') . '/template/affiliate/sales.tpl';
		} else {
			$this->template = 'default/template/affiliate/sales.tpl';
		}

		$this->children = array(
			'common/header',
			'common/footer',
			'common/column_left',
			'common/column_right'
		);

		$this->response->setOutput($this->render(TRUE), $this->config->get('config_compression'));


  	}



  	private function validate() {
    	if (!$this->customer->login($this->request->post['email'], $this->request->post['password'])) {
      		$this->error['message'] = $this->language->get('error_login');
    	}

    	if (!$this->error) {
      		return TRUE;
    	} else {
      		return FALSE;
    	}
  	}
}
?>