<?php
class ControllerDesaccountContest extends Controller {
	private $error = array();

	public function index() {
		if (!$this->designer->isLogged()) {
			$this->session->data['redirect'] = $this->url->link('desaccount/contest', '', 'SSL');

			$this->redirect($this->url->link('desaccount/login', '', 'SSL'));
		}

		$this->language->load('desaccount/contest');
		
		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('desaccount/designer');
		$this->load->model('information/myown');
		
		if (($this->request->server['REQUEST_METHOD'] == 'POST')) {
			$this->model_desaccount_designer->editdesigner($this->request->post);
			
			$this->session->data['success'] = $this->language->get('text_success');

			$this->redirect($this->url->link('desaccount/account', '', 'SSL'));
		}

      	$this->data['breadcrumbs'] = array();

      	$this->data['breadcrumbs'][] = array(
        	'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home'),     	
        	'separator' => false
      	); 

      	$this->data['breadcrumbs'][] = array(
        	'text'      => $this->language->get('text_account'),
			'href'      => $this->url->link('desaccount/account', '', 'SSL'),        	
        	'separator' => $this->language->get('text_separator')
      	);

      	$this->data['breadcrumbs'][] = array(
        	'text'      => $this->language->get('text_edit'),
			'href'      => $this->url->link('desaccount/contest', '', 'SSL'),       	
        	'separator' => $this->language->get('text_separator')
      	);
		
		$this->data['heading_title'] = $this->language->get('heading_title');

		$this->data['text_your_details'] = $this->language->get('text_your_details');

		$this->data['entry_firstname'] = $this->language->get('entry_firstname');
		$this->data['entry_lastname'] = $this->language->get('entry_lastname');
		$this->data['entry_email'] = $this->language->get('entry_email');
		$this->data['entry_fax'] = $this->language->get('entry_fax');
		$this->data['entry_password'] = $this->language->get('entry_password');
    	$this->data['entry_confirm'] = $this->language->get('entry_confirm');

		$this->data['button_continue'] = $this->language->get('button_continue');
		$this->data['button_back'] = $this->language->get('button_back');
		$this->data['desin'] = $this->designer->getId();

		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}

		if (isset($this->error['firstname'])) {
			$this->data['error_firstname'] = $this->error['firstname'];
		} else {
			$this->data['error_firstname'] = '';
		}

		if (isset($this->error['lastname'])) {
			$this->data['error_lastname'] = $this->error['lastname'];
		} else {
			$this->data['error_lastname'] = '';
		}
		
		if (isset($this->error['email'])) {
			$this->data['error_email'] = $this->error['email'];
		} else {
			$this->data['error_email'] = '';
		}	
	
		
		if (isset($this->error['password'])) { 
			$this->data['error_password'] = $this->error['password'];
		} else {
			$this->data['error_password'] = '';
		}

		if (isset($this->error['confirm'])) { 
			$this->data['error_confirm'] = $this->error['confirm'];
		} else {
			$this->data['error_confirm'] = '';
		}

		$this->data['action'] = $this->url->link('desaccount/contest', '', 'SSL');

		if ($this->request->server['REQUEST_METHOD'] != 'POST') {
			$designer_info = $this->model_desaccount_designer->getdesigner($this->designer->getId());
		}

		if (isset($this->request->post['firstname'])) {
			$this->data['firstname'] = $this->request->post['firstname'];
		} elseif (isset($designer_info)) {
			$this->data['firstname'] = $designer_info['firstname'];
		} else {
			$this->data['firstname'] = '';
		}

		if (isset($this->request->post['lastname'])) {
			$this->data['lastname'] = $this->request->post['lastname'];
		} elseif (isset($designer_info)) {
			$this->data['lastname'] = $designer_info['lastname'];
		} else {
			$this->data['lastname'] = '';
		}

		if (isset($this->request->post['email'])) {
			$this->data['email'] = $this->request->post['email'];
		} elseif (isset($designer_info)) {
			$this->data['email'] = $designer_info['email'];
		} else {
			$this->data['email'] = '';
		}

		if (isset($this->request->post['newsletter'])) {
			$this->data['newsletter'] = $this->request->post['newsletter'];
		} else {
			$this->data['newsletter'] = '';
		}
		
		if (isset($this->request->post['password'])) {
    		$this->data['password'] = $this->request->post['password'];
		} else {
			$this->data['password'] = '';
		}

		if (isset($this->request->post['confirm'])) {
    		$this->data['confirm'] = $this->request->post['confirm'];
		} else {
			$this->data['confirm'] = '';
		}
		
		// address Starts
		
		$this->data['button_edit'] = $this->language->get('button_edit');
		$this->data['entry_newsletter'] = $this->language->get('entry_newsletter');
    	$this->data['button_delete'] = $this->language->get('button_delete');
		
		$this->data['addresses'] = array();
		$this->load->model('desaccount/address');
		$results = $this->model_desaccount_address->getAddresses();

    	foreach ($results as $result) {
			if ($result['address_format']) {
      			$format = $result['address_format'];
    		} else {
				$format = '{firstname} {lastname}' . "\n" . '{company}' . "\n" . '{address_1}' . "\n" . '{address_2}' . "\n" . '{city} {postcode}' . "\n" . '{zone}' . "\n" . '{country}';
			}
		
    		$find = array(
	  			'{firstname}',
	  			'{lastname}',
	  			'{company}',
      			'{address_1}',
      			'{address_2}',
     			'{city}',
      			'{postcode}',
      			'{zone}',
				'{zone_code}',
      			'{country}'
			);
	
			$replace = array(
	  			'firstname' => $result['firstname'],
	  			'lastname'  => $result['lastname'],
	  			'company'   => $result['company'],
      			'address_1' => $result['address_1'],
      			'address_2' => $result['address_2'],
      			'city'      => $result['city'],
      			'postcode'  => $result['postcode'],
      			'zone'      => $result['zone'],
				'zone_code' => $result['zone_code'],
      			'country'   => $result['country']  
			);

      		$this->data['addresses'][] = array(
        		'address_id' => $result['address_id'],
        		'address'    => str_replace(array("\r\n", "\r", "\n"), '<br />', preg_replace(array("/\s\s+/", "/\r\r+/", "/\n\n+/"), '<br />', trim(str_replace($find, $replace, $format)))),
        		'update'     => $this->url->link('desaccount/address/update', 'address_id=' . $result['address_id'], 'SSL'),
				'delete'     => $this->url->link('desaccount/address/delete', 'address_id=' . $result['address_id'], 'SSL')
      		);
    	}
		
		$this->data['newsletter'] = $this->designer->getNewsletter();
		$this->data['text_yes'] = $this->language->get('text_yes');
		$this->data['text_no'] = $this->language->get('text_no');
		
		// address Ends
		
		$this->data['contests'] = array();
		 
		
		$results = $this->model_information_myown->getcontests();
		
		foreach ($results as $result) {
		
		$this->data['contests'][] = array(
				'contest_id'    => $result['contest_id'],
				'customer_id'    => $result['customer_id'],
				'code'            => $result['currency_code'],
				'description'           => $result['description'],
				'prize_amount'           => $result['prize_amount'],
				'entry'          => $this->model_information_myown->getcontestentry($result['contest_id']),
				'feedback'          => $this->model_information_myown->getcontestfeedback($result['contest_id']),
				'status'          => $this->model_information_myown->getconteststatus($result['status'])
			);
		}	

		$this->data['activecontests'] = array(); 
		
		$results = $this->model_information_myown->getactivecontests();
		
		foreach ($results as $result) {
		
		$this->data['activecontests'][] = array(
				'contest_id'    => $result['contest_id'],
				'customer_id'    => $result['customer_id'],
				'description'           => $result['description'],
				'code'            => $result['currency_code'],
				'prize_amount'           => $result['prize_amount'],
				'image'           => $this->model_desaccount_designer->passing_id1($this->designer->getId(),$result['contest_id']),
				'entry'          => $this->model_information_myown->getcontestentry($result['contest_id']),
				'feedback'          => $this->model_information_myown->getcontestfeedback($result['contest_id']),
				'status'          => $this->model_information_myown->getconteststatus($result['status'])
			);
		}	

		$this->data['mycontests'] = array();
		  
		
		$results = $this->model_information_myown->getmycontests();
		
		foreach ($results as $result) {
		
		$this->data['mycontests'][] = array(
				'contest_id'    => $result['contest_id'],
				'customer_id'    => $result['customer_id'],
				'description'           => $result['description'],
				'code'            => $result['currency_code'],
				'prize_amount'           => $result['prize_amount'],
				'entry'          => $this->model_information_myown->getcontestentry($result['contest_id']),
				'feedback'          => $this->model_information_myown->getcontestfeedback($result['contest_id']),
				'status'          => $this->model_information_myown->getconteststatus($result['status'])
			);
		}	

		$this->data['back'] = $this->url->link('desaccount/account', '', 'SSL');
		
		$this->data['designerid'] = $this->designer->getId();
		
		$this->data['designer_details'] = array();
		
		$this->load->model('tool/image');
		
		$results2 = $this->model_desaccount_designer->passing_id($this->data['designerid']);
		
		foreach ($results2 as $result) {
			
		$this->data['designer_details'][] = array(
					'product_id'  => $result['product_id'],
					'sketch_id'  => $result['sketch_id'],
					'image'  => $this->model_tool_image->resize($result['image'], 50, 50)
				);
		}

		if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/desaccount/contest.tpl')) {
			$this->template = $this->config->get('config_template') . '/template/desaccount/contest.tpl';
		} else {
			$this->template = 'default/template/desaccount/contest.tpl';
		}
		
		$this->children = array(
			'common/column_left',
			'common/column_right',
			'common/content_top',
			'common/content_bottom',
			'common/footer',
			'common/header'	
		);
						
		$this->response->setOutput($this->render());	
	}

	private function validate() {
		if ((utf8_strlen($this->request->post['firstname']) < 1) || (utf8_strlen($this->request->post['firstname']) > 32)) {
			$this->error['firstname'] = $this->language->get('error_firstname');
		}

		if ((utf8_strlen($this->request->post['lastname']) < 1) || (utf8_strlen($this->request->post['lastname']) > 32)) {
			$this->error['lastname'] = $this->language->get('error_lastname');
		}

		if ((utf8_strlen($this->request->post['email']) > 96) || !preg_match('/^[^\@]+@.*\.[a-z]{2,6}$/i', $this->request->post['email'])) {
			$this->error['email'] = $this->language->get('error_email');
		}
		
		if (($this->designer->getEmail() != $this->request->post['email']) && $this->model_desaccount_designer->getTotaldesignersByEmail($this->request->post['email'])) {
			$this->error['warning'] = $this->language->get('error_exists');
		}


		if (!$this->error) {
			return true;
		} else {
			return false;
		}
	}
}
?>