<?php
class ControllerSaleRapnet extends Controller {
	private $error = array();

	public function index() {
		$this->load->language('sale/gemprice');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('sale/gemprice');

		$this->getList();
	}

	public function add() {
		$this->load->language('sale/gemprice');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('sale/gemprice');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
			$this->model_sale_gemprice->addgemprice($this->request->post);

			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			$this->response->redirect($this->url->link('sale/gemprice', 'user_token=' . $this->session->data['user_token'] . $url, true));
		}

		$this->getForm();
	}

	public function edit() {
		$this->load->language('sale/gemprice');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('sale/gemprice');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
			$this->model_sale_gemprice->editgemprice($this->request->get['gemstoneprice_id'], $this->request->post);

			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			$this->response->redirect($this->url->link('sale/gemprice', 'user_token=' . $this->session->data['user_token'] . $url, true));
		}

		$this->getForm();
	}

	public function delete() {
		$this->load->language('sale/gemprice');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('sale/gemprice');

		if (isset($this->request->post['selected']) && $this->validateDelete()) {
			foreach ($this->request->post['selected'] as $gemstoneprice_id) {
				$this->model_sale_gemprice->deletegemprice($gemstoneprice_id);
			}

			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			$this->response->redirect($this->url->link('sale/gemprice', 'user_token=' . $this->session->data['user_token'] . $url, true));
		}

		$this->getList();
	}

	protected function getList() {
		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'gemstoneprice_id';
		}

		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'ASC';
		}

		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

		$url = '';

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$data['breadcrumbs'] =   array();

		$data['breadcrumbs'][] =   array(
			'text' =>  $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] =   array(
			'text' =>  $this->language->get('heading_title'),
			'href' =>  $this->url->link('sale/gemprice', 'user_token=' . $this->session->data['user_token'] . $url, true)
		);

		$data['add'] = $this->url->link('sale/gemprice/add', 'user_token=' . $this->session->data['user_token'] . $url, true);
		$data['delete'] = $this->url->link('sale/gemprice/delete', 'user_token=' . $this->session->data['user_token'] . $url, true);

		$data['gemprice'] = array();

		$filter_data = array(
			'sort'  => $sort,
			'order' => $order,
			'start' => ($page - 1) * $this->config->get('config_limit_admin'),
			'limit' => $this->config->get('config_limit_admin')
		);

		$gemprice_total = $this->model_sale_gemprice->getTotalgemprices();

		$results = $this->model_sale_gemprice->getgemprices($filter_data);

		foreach ($results as $result) {
			$data['gemprice'][] =   array(
				'gemstoneprice_id' 			=> $result['gemstoneprice_id'],
				'price'        		=> $result['price'], 
				'pricetype'        		=> $result['pricetype'], 
				'gemstone_id'        		=> $result['gemstone_id'], 
				'gemname'        		=> $result['gemname'], 
				'lowclarity'     					=> $result['lowclarity'], 
				'lowweight'     					=> $result['lowweight'], 
				'highweight'     					=> $result['highweight'], 
				'edit'        		=> $this->url->link('sale/gemprice/edit', 'user_token=' . $this->session->data['user_token'] . '&gemstoneprice_id=' . $result['gemstoneprice_id'] . $url, true)
			);
		}

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		if (isset($this->session->data['success'])) {
			$data['success'] = $this->session->data['success'];

			unset($this->session->data['success']);
		} else {
			$data['success'] = '';
		}

		if (isset($this->request->post['selected'])) {
			$data['selected'] = (array)$this->request->post['selected'];
		} else {
			$data['selected'] = array();
		}

		$url = '';

		if ($order == 'ASC') {
			$url .= '&order=DESC';
		} else {
			$url .= '&order=ASC';
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$data['sort_price'] = $this->url->link('sale/gemprice', 'user_token=' . $this->session->data['user_token'] . '&sort=price' . $url, true);
		$data['sort_pricetype'] = $this->url->link('sale/gemprice', 'user_token=' . $this->session->data['user_token'] . '&sort=pricetype' . $url, true);
		$data['sort_gemname'] = $this->url->link('sale/gemprice', 'user_token=' . $this->session->data['user_token'] . '&sort=gemname' . $url, true);
		$data['sort_lowweight'] = $this->url->link('sale/gemprice', 'user_token=' . $this->session->data['user_token'] . '&sort=lowweight' . $url, true); 
		$data['sort_highweight'] = $this->url->link('sale/gemprice', 'user_token=' . $this->session->data['user_token'] . '&sort=highweight' . $url, true); 
		$data['sort_lowclarity'] = $this->url->link('sale/gemprice', 'user_token=' . $this->session->data['user_token'] . '&sort=lowclarity' . $url, true); 

		$url = '';

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		$pagination = new Pagination();
		$pagination->total = $gemprice_total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_limit_admin');
		$pagination->url = $this->url->link('sale/gemprice', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

		$data['pagination'] = $pagination->render();

		$data['results'] = sprintf($this->language->get('text_pagination'), ($gemprice_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($gemprice_total - $this->config->get('config_limit_admin'))) ? $gemprice_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $gemprice_total, ceil($gemprice_total / $this->config->get('config_limit_admin')));

		$data['sort'] = $sort;
		$data['order'] = $order;

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('sale/gemprice_list', $data));
	}

	protected function getForm() {
		$data['text_form'] = !isset($this->request->get['gemstoneprice_id']) ? $this->language->get('text_add') : $this->language->get('text_edit');

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		if (isset($this->error['price'])) {
			$data['error_price'] = $this->error['price'];
		} else {
			$data['error_price'] = '';
		}

		if (isset($this->error['pricetype'])) {
			$data['error_pricetype'] = $this->error['pricetype'];
		} else {
			$data['error_pricetype'] = '';
		}

		if (isset($this->error['lowweight'])) {
			$data['error_lowweight'] = $this->error['lowweight'];
		} else {
			$data['error_lowweight'] = '';
		} 
		if (isset($this->error['highweight'])) {
			$data['error_highweight'] = $this->error['highweight'];
		} else {
			$data['error_highweight'] = '';
		}  
		$url = '';

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('sale/gemprice', 'user_token=' . $this->session->data['user_token'] . $url, true)
		);

		if (!isset($this->request->get['gemstoneprice_id'])) {
			$data['action'] = $this->url->link('sale/gemprice/add', 'user_token=' . $this->session->data['user_token'] . $url, true);
		} else {
			$data['action'] = $this->url->link('sale/gemprice/edit', 'user_token=' . $this->session->data['user_token'] .  '&gemstoneprice_id=' . $this->request->get['gemstoneprice_id'] . $url, true);
		}

		$data['cancel'] = $this->url->link('sale/gemprice', 'user_token=' . $this->session->data['user_token'] . $url, true);

		if (isset($this->request->get['gemstoneprice_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
			$gemprice_info = $this->model_sale_gemprice->getgemprice($this->request->get['gemstoneprice_id']);
		}

		$data['user_token'] = $this->session->data['user_token'];

		$this->load->model('setting/store');
 
		if (isset($this->request->post['price'])) {
			$data['price'] = $this->request->post['price'];
		} elseif (!empty($gemprice_info)) {
			$data['price'] = $gemprice_info['price'];
		} else {
			$data['price'] =   '';
		}
		if (isset($this->request->post['pricetype'])) {
			$data['pricetype'] = $this->request->post['pricetype'];
		} elseif (!empty($gemprice_info)) {
			$data['pricetype'] = $gemprice_info['pricetype'];
		} else {
			$data['pricetype'] =   '';
		}
		
		if (isset($this->request->post['shape'])) {
			$data['shape'] = $this->request->post['shape'];
		} elseif (!empty($gemprice_info)) {
			$data['shape'] = $gemprice_info['shape'];
		} else {
			$data['shape'] =   '';
		}
		
		if (isset($this->request->post['ccurrency'])) {
			$data['ccurrency'] = $this->request->post['ccurrency'];
		} elseif (!empty($gemprice_info)) {
			$data['ccurrency'] = $gemprice_info['ccurrency'];
		} else {
			$data['ccurrency'] =   '';
		}
		
		if (isset($this->request->post['lowcolour'])) {
			$data['lowcolour'] = $this->request->post['lowcolour'];
		} elseif (!empty($gemprice_info)) {
			$data['lowcolour'] = $gemprice_info['lowcolour'];
		} else {
			$data['lowcolour'] = '';
		}
		if (isset($this->request->post['highcolour'])) {
			$data['highcolour'] = $this->request->post['highcolour'];
		} elseif (!empty($gemprice_info)) {
			$data['highcolour'] = $gemprice_info['highcolour'];
		} else {
			$data['highcolour'] = '';
		}
		if (isset($this->request->post['lowclarity'])) {
			$data['lowclarity'] = $this->request->post['lowclarity'];
		} elseif (!empty($gemprice_info)) {
			$data['lowclarity'] = $gemprice_info['lowclarity'];
		} else {
			$data['lowclarity'] = '';
		} 
		if (isset($this->request->post['highclarity'])) {
			$data['highclarity'] = $this->request->post['highclarity'];
		} elseif (!empty($gemprice_info)) {
			$data['highclarity'] = $gemprice_info['highclarity'];
		} else {
			$data['highclarity'] = '';
		} 
		if (isset($this->request->post['lowweight'])) {
			$data['lowweight'] = $this->request->post['lowweight'];
		} elseif (!empty($gemprice_info)) {
			$data['lowweight'] = $gemprice_info['lowweight'];
		} else {
			$data['lowweight'] = '';
		} 
		if (isset($this->request->post['highweight'])) {
			$data['highweight'] = $this->request->post['highweight'];
		} elseif (!empty($gemprice_info)) {
			$data['highweight'] = $gemprice_info['highweight'];
		} else {
			$data['highweight'] = '';
		} 

		if (isset($this->request->post['gemstone_id'])) {
			$data['gemstone_id'] = $this->request->post['gemstone_id'];
		} elseif (!empty($gemprice_info)) {
			$data['gemstone_id'] = $gemprice_info['gemstone_id'];
		} else {
			$data['gemstone_id'] = '';
		} 
		 
		$this->load->model('sale/claritycode'); 
		$data['claritycodes'] = $this->model_sale_claritycode->getclaritycodes();
		$this->load->model('sale/gemshape'); 
		$data['shapes'] = $this->model_sale_gemshape->getgemshapes();
		$this->load->model('localisation/currency'); 
		$data['currencies'] = $this->model_localisation_currency->getCurrencies();
		
		
		$this->load->model('sale/colourcode'); 
		$data['colors'] = $this->model_sale_colourcode->getcolourcodes(); 
		$this->load->model('sale/gemstone');
		$data['gemstones'] = $this->model_sale_gemstone->getgemstones();
  
		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('sale/gemprice_form', $data));
	}

	protected function validateForm() {
		if (!$this->user->hasPermission('modify', 'sale/gemprice')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		if ((utf8_strlen($this->request->post['price']) < 1) || (utf8_strlen($this->request->post['price']) > 32)) {
			$this->error['price'] = $this->language->get('error_price');
		} 
		if ((utf8_strlen($this->request->post['pricetype']) < 1) || (utf8_strlen($this->request->post['pricetype']) > 32)) {
			$this->error['pricetype'] = $this->language->get('error_pricetype');
		} 
		
		if ((utf8_strlen($this->request->post['lowweight']) < 1) || (utf8_strlen($this->request->post['lowweight']) > 128)) {
			$this->error['lowweight'] = $this->language->get('error_lowweight');
		}
		if ((utf8_strlen($this->request->post['highweight']) < 1) || (utf8_strlen($this->request->post['highweight']) > 128)) {
			$this->error['highweight'] = $this->language->get('error_highweight');
		}
 
		return !$this->error;
	}

	protected function validateDelete() {
		if (!$this->user->hasPermission('modify', 'sale/gemprice')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		return !$this->error;
	}
}