<?php
class ControllerSaleRingsize extends Controller {
	private $error = array();

	public function index() {
		$this->load->language('sale/ringsize');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('sale/ringsize');

		$this->getList();
	}

	public function add() {
		$this->load->language('sale/ringsize');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('sale/ringsize');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
			$this->model_sale_ringsize->addringsize($this->request->post);

			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			$this->response->redirect($this->url->link('sale/ringsize', 'user_token=' . $this->session->data['user_token'] . $url, true));
		}

		$this->getForm();
	}

	public function edit() {
		$this->load->language('sale/ringsize');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('sale/ringsize');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
			$this->model_sale_ringsize->editringsize($this->request->get['ring_size_id'], $this->request->post);

			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			$this->response->redirect($this->url->link('sale/ringsize', 'user_token=' . $this->session->data['user_token'] . $url, true));
		}

		$this->getForm();
	}

	public function delete() {
		$this->load->language('sale/ringsize');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('sale/ringsize');

		if (isset($this->request->post['selected']) && $this->validateDelete()) {
			foreach ($this->request->post['selected'] as $ring_size_id) {
				$this->model_sale_ringsize->deleteringsize($ring_size_id);
			}

			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			$this->response->redirect($this->url->link('sale/ringsize', 'user_token=' . $this->session->data['user_token'] . $url, true));
		}

		$this->getList();
	}

	protected function getList() {
		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'ring_size_id';
		}

		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'ASC';
		}

		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

		$url = '';

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$data['breadcrumbs'] =   array();

		$data['breadcrumbs'][] =   array(
			'text' =>  $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] =   array(
			'text' =>  $this->language->get('heading_title'),
			'href' =>  $this->url->link('sale/ringsize', 'user_token=' . $this->session->data['user_token'] . $url, true)
		);

		$data['add'] = $this->url->link('sale/ringsize/add', 'user_token=' . $this->session->data['user_token'] . $url, true);
		$data['delete'] = $this->url->link('sale/ringsize/delete', 'user_token=' . $this->session->data['user_token'] . $url, true);

		$data['ringsize'] = array();

		$filter_data = array(
			'sort'  => $sort,
			'order' => $order,
			'start' => ($page - 1) * $this->config->get('config_limit_admin'),
			'limit' => $this->config->get('config_limit_admin')
		);

		$ringsize_total = $this->model_sale_ringsize->getTotalringsizes();

		$results = $this->model_sale_ringsize->getringsizes($filter_data);

		foreach ($results as $result) {
			$data['ringsize'][] =   array(
				'ring_size_id' 			=> $result['ring_size_id'],
				'country'        		=> $result['country'],
				'status'     			=> $result['status'],
				'ring_size'     					=> $result['ring_size'], 
				'edit'        		=> $this->url->link('sale/ringsize/edit', 'user_token=' . $this->session->data['user_token'] . '&ring_size_id=' . $result['ring_size_id'] . $url, true)
			);
		}

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		if (isset($this->session->data['success'])) {
			$data['success'] = $this->session->data['success'];

			unset($this->session->data['success']);
		} else {
			$data['success'] = '';
		}

		if (isset($this->request->post['selected'])) {
			$data['selected'] = (array)$this->request->post['selected'];
		} else {
			$data['selected'] = array();
		}

		$url = '';

		if ($order == 'ASC') {
			$url .= '&order=DESC';
		} else {
			$url .= '&order=ASC';
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$data['sort_country'] = $this->url->link('sale/ringsize', 'user_token=' . $this->session->data['user_token'] . '&sort=country' . $url, true);
		$data['sort_status'] = $this->url->link('sale/ringsize', 'user_token=' . $this->session->data['user_token'] . '&sort=status' . $url, true); 
		$data['sort_ring_size'] = $this->url->link('sale/ringsize', 'user_token=' . $this->session->data['user_token'] . '&sort=ring_size' . $url, true); 

		$url = '';

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		$pagination = new Pagination();
		$pagination->total = $ringsize_total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_limit_admin');
		$pagination->url = $this->url->link('sale/ringsize', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

		$data['pagination'] = $pagination->render();

		$data['results'] = sprintf($this->language->get('text_pagination'), ($ringsize_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($ringsize_total - $this->config->get('config_limit_admin'))) ? $ringsize_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $ringsize_total, ceil($ringsize_total / $this->config->get('config_limit_admin')));

		$data['sort'] = $sort;
		$data['order'] = $order;

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('sale/ringsize_list', $data));
	}

	protected function getForm() {
		$data['text_form'] = !isset($this->request->get['ring_size_id']) ? $this->language->get('text_add') : $this->language->get('text_edit');

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}
 

		if (isset($this->error['ring_size'])) {
			$data['error_ring_size'] = $this->error['ring_size'];
		} else {
			$data['error_ring_size'] = '';
		} 

		$url = '';

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('sale/ringsize', 'user_token=' . $this->session->data['user_token'] . $url, true)
		);

		if (!isset($this->request->get['ring_size_id'])) {
			$data['action'] = $this->url->link('sale/ringsize/add', 'user_token=' . $this->session->data['user_token'] . $url, true);
		} else {
			$data['action'] = $this->url->link('sale/ringsize/edit', 'user_token=' . $this->session->data['user_token'] .  '&ring_size_id=' . $this->request->get['ring_size_id'] . $url, true);
		}

		$data['cancel'] = $this->url->link('sale/ringsize', 'user_token=' . $this->session->data['user_token'] . $url, true);

		if (isset($this->request->get['ring_size_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
			$ringsize_info = $this->model_sale_ringsize->getringsize($this->request->get['ring_size_id']);
		}

		$data['user_token'] = $this->session->data['user_token'];

		$this->load->model('setting/store');
  
		
		if (isset($this->request->post['country'])) {
			$data['country'] = $this->request->post['country'];
		} elseif (!empty($ringsize_info)) {
			$data['country'] = $ringsize_info['country'];
		} else {
			$data['country'] = '';
		}
		if (isset($this->request->post['ring_size'])) {
			$data['ring_size'] = $this->request->post['ring_size'];
		} elseif (!empty($ringsize_info)) {
			$data['ring_size'] = $ringsize_info['ring_size'];
		} else {
			$data['ring_size'] = '';
		} 

		if (isset($this->request->post['status'])) {
			$data['status'] = $this->request->post['status'];
		} elseif (!empty($ringsize_info)) {
			$data['status'] = $ringsize_info['status'];
		} else {
			$data['status'] = '';
		} 
		
		$this->load->model('localisation/country');

		$data['countries'] = $this->model_localisation_country->getCountries();
		 
  
		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('sale/ringsize_form', $data));
	}

	protected function validateForm() {
		if (!$this->user->hasPermission('modify', 'sale/ringsize')) {
			$this->error['warning'] = $this->language->get('error_permission');
		} 
		
		if ((utf8_strlen($this->request->post['ring_size']) < 1) || (utf8_strlen($this->request->post['ring_size']) > 128)) {
			$this->error['ring_size'] = $this->language->get('error_ring_size');
		}
 
		return !$this->error;
	}

	protected function validateDelete() {
		if (!$this->user->hasPermission('modify', 'sale/ringsize')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		return !$this->error;
	}
}