<?php
class ControllerReportProductMarkupAll extends Controller {
	public function index() {

		ini_set("max_execution_time", "3000");
		$this->load->language('report/product_report');

			$this->document->setTitle($this->language->get('heading_title'));

   		$data['breadcrumbs'] = array();
			$url = '';
   		$data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'user_token=' . $this->session->data['user_token'], 'SSL'),
      		'separator' => false
   		);

   		$data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('report/product_report', 'user_token=' . $this->session->data['user_token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);

		if(! isset($this->session->data['completedproducts'])){
				$this->session->data['completedproducts'] = '';
		}
		if(! isset($this->session->data['erroredproducts'])){
				$this->session->data['erroredproducts'] = '';
		}
		if(! isset($this->session->data['currentproduct'])){
				$this->session->data['currentproduct'] = '';
		}

		$this->load->model('report/product');

		$data['Excel'] = $this->url->link('report/product_report1', 'SSL');
		$data['products'] = array();

		$data = array(
			'filter_date_start'	 => '',
			'filter_date_end'	 => '',
			'filter_order_status_id' => '',
			'limit'                  => $this->config->get('config_admin_limit')
		);

		$product_total = $this->model_report_product->getTotalPurchased($data);
		$this->session->data['product_details'] = '';
		if (isset($this->request->get['product_id'])) {
			$product_id = $this->request->get['product_id'];
		} else {
			$product_id = 108;
		}

		$this->session->data['erroredproducts'] = $this->session->data['erroredproducts'] . ','. $this->session->data['currentproduct'] ;
 		$allproducts = $this->model_report_product->getAllMarkupProducts();

		foreach ($allproducts as $allproduct) {
			$additional=0;
			$product_cost_markup=0;
		  try {
			$product_cost = $allproduct['product_cost'];
/*			echo $allproduct['product_cost'].'<br>' . $product_cost .'<br>' 	;
			echo $this->config->get('additionalcost_five').'<br>';
			echo $this->config->get('pricelimit_four').'<br>';
			echo $this->config->get('pricelimit_three').'<br>';
			echo $this->config->get('pricelimit_two').'<br>';
			echo $this->config->get('pricelimit_one').'<br>';
*/
			if( (int)$this->config->get('pricelimit_four') <= (int)$product_cost  ){
				$additional = (int)$this->config->get('additionalcost_five') ;
			}else if( (int)$this->config->get('pricelimit_three') <= $product_cost ){
				$additional = (int)$this->config->get('additionalcost_four') ;
			}else if( (int)$this->config->get('pricelimit_two') <= $product_cost ){
				$additional = (int)$this->config->get('additionalcost_three') ;
			}else if( (int)$this->config->get('pricelimit_one') <= $product_cost ){
				$additional = (int)$this->config->get('additionalcost_two') ;
			}else{
				$additional = (int)$this->config->get('additionalcost_one') ;
			}

			$product_cost_addl = $additional ;
			$product_cost_markup = $this->model_report_product->getProductMarkupCost( $product_id , $product_cost + $additional );

			$insertsql = "update  product_combinations_testing set";
			$insertsql .= " additional_cost=" . $product_cost_addl  ;
			$insertsql .= ", final_price=". $product_cost_markup ;
			$insertsql .= " where product_id=". $allproduct['product_id'] . " and product_metalavail_id=". $allproduct['product_metalavail_id'] . " and product_gemavail_id=". $allproduct['product_gemavail_id'] ;

//			echo $insertsql .'<br>' ;
			$query = $this->db->query($insertsql);

			$data['allproducts_output'][] = array(
				'product_id'  =>  $product_id,
				'message'     =>  "Successfully Completed"
			);

		  } catch (Exception $e) {
			echo ' Failed to update<br> ';
			echo "===========================================================================<br>";
			echo "Caught exception: ".  $e->getMessage() . "<br>";
			echo "===========================================================================<br>";
		  }
		}
		$data['heading_title'] = $this->language->get('heading_title');

		$data['text_no_results'] = $this->language->get('text_no_results');
		$data['text_all_status'] = $this->language->get('text_all_status');

		$data['column_name'] = $this->language->get('column_name');
		$data['column_model'] = $this->language->get('column_model');
		$data['column_quantity'] = $this->language->get('column_quantity');
		$data['column_total'] = $this->language->get('column_total');

		$data['entry_date_start'] = $this->language->get('entry_date_start');
		$data['entry_date_end'] = $this->language->get('entry_date_end');
		$data['entry_status'] = $this->language->get('entry_status');

		$data['button_filter'] = $this->language->get('button_filter');

		$data['user_token'] = $this->session->data['user_token'];


		$url = '';
		$pagination = new Pagination();
		$pagination->total = $product_total;
		$pagination->page = '';
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('report/product_report', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}');

		$data['pagination'] = $pagination->render();

		$this->response->setOutput($this->load->view('report/product_report_all', $data));		
/*
		$this->template = 'report/product_report_all.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);

		$this->response->setOutput($this->render());
*/
	}

}
?>
