<?php
class ControllerSalecolourcode extends Controller {
	private $error = array();

	public function index() {
		$this->load->language('sale/colourcode');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('sale/colourcode');

		$this->getList();
	}

	public function add() {
		$this->load->language('sale/colourcode');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('sale/colourcode');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
			$this->model_sale_colourcode->addcolourcode($this->request->post);

			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			$this->response->redirect($this->url->link('sale/colourcode', 'user_token=' . $this->session->data['user_token'] . $url, true));
		}

		$this->getForm();
	}

	public function edit() {
		$this->load->language('sale/colourcode');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('sale/colourcode');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
			$this->model_sale_colourcode->editcolourcode($this->request->get['colour_id'], $this->request->post);

			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			$this->response->redirect($this->url->link('sale/colourcode', 'user_token=' . $this->session->data['user_token'] . $url, true));
		}

		$this->getForm();
	}

	public function delete() {
		$this->load->language('sale/colourcode');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('sale/colourcode');

		if (isset($this->request->post['selected']) && $this->validateDelete()) {
			foreach ($this->request->post['selected'] as $colour_id) {
				$this->model_sale_colourcode->deletecolourcode($colour_id);
			}

			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			$this->response->redirect($this->url->link('sale/colourcode', 'user_token=' . $this->session->data['user_token'] . $url, true));
		}

		$this->getList();
	}

	protected function getList() {
		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'colour_code';
		}

		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'ASC';
		}

		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

		$url = '';

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$data['breadcrumbs'] =   array();

		$data['breadcrumbs'][] =   array(
			'text' =>  $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] =   array(
			'text' =>  $this->language->get('heading_title'),
			'href' =>  $this->url->link('sale/colourcode', 'user_token=' . $this->session->data['user_token'] . $url, true)
		);

		$data['add'] = $this->url->link('sale/colourcode/add', 'user_token=' . $this->session->data['user_token'] . $url, true);
		$data['delete'] = $this->url->link('sale/colourcode/delete', 'user_token=' . $this->session->data['user_token'] . $url, true);

		$data['colourcode'] = array();

		$filter_data = array(
			'sort'  => $sort,
			'order' => $order,
			'start' => ($page - 1) * $this->config->get('config_limit_admin'),
			'limit' => $this->config->get('config_limit_admin')
		);

		$colourcode_total = $this->model_sale_colourcode->getTotalcolourcodes();

		$results = $this->model_sale_colourcode->getcolourcodes($filter_data);

		foreach ($results as $result) {
			$data['colourcode'][] =   array(
				'colour_id' 			=> $result['colour_id'],
				'colour_code'        		=> $result['colour_code'], 
				'edit'        		=> $this->url->link('sale/colourcode/edit', 'user_token=' . $this->session->data['user_token'] . '&colour_id=' . $result['colour_id'] . $url, true)
			);
		}

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		if (isset($this->session->data['success'])) {
			$data['success'] = $this->session->data['success'];

			unset($this->session->data['success']);
		} else {
			$data['success'] = '';
		}

		if (isset($this->request->post['selected'])) {
			$data['selected'] = (array)$this->request->post['selected'];
		} else {
			$data['selected'] = array();
		}

		$url = '';

		if ($order == 'ASC') {
			$url .= '&order=DESC';
		} else {
			$url .= '&order=ASC';
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$data['sort_colour_code'] = $this->url->link('sale/colourcode', 'user_token=' . $this->session->data['user_token'] . '&sort=colour_code' . $url, true); 

		$url = '';

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		$pagination = new Pagination();
		$pagination->total = $colourcode_total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_limit_admin');
		$pagination->url = $this->url->link('sale/colourcode', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

		$data['pagination'] = $pagination->render();

		$data['results'] = sprintf($this->language->get('text_pagination'), ($colourcode_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($colourcode_total - $this->config->get('config_limit_admin'))) ? $colourcode_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $colourcode_total, ceil($colourcode_total / $this->config->get('config_limit_admin')));

		$data['sort'] = $sort;
		$data['order'] = $order;

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('sale/colourcode_list', $data));
	}

	protected function getForm() {
		$data['text_form'] = !isset($this->request->get['colour_id']) ? $this->language->get('text_add') : $this->language->get('text_edit');

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		if (isset($this->error['colour_code'])) {
			$data['error_colour_code'] = $this->error['colour_code'];
		} else {
			$data['error_colour_code'] = '';
		}
		

		if (isset($this->error['colour_descr'])) {
			$data['error_colour_descr'] = $this->error['colour_descr'];
		} else {
			$data['error_colour_descr'] = '';
		}
		

		$url = '';

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('sale/colourcode', 'user_token=' . $this->session->data['user_token'] . $url, true)
		);

		if (!isset($this->request->get['colour_id'])) {
			$data['action'] = $this->url->link('sale/colourcode/add', 'user_token=' . $this->session->data['user_token'] . $url, true);
		} else {
			$data['action'] = $this->url->link('sale/colourcode/edit', 'user_token=' . $this->session->data['user_token'] .  '&colour_id=' . $this->request->get['colour_id'] . $url, true);
		}

		$data['cancel'] = $this->url->link('sale/colourcode', 'user_token=' . $this->session->data['user_token'] . $url, true);

		if (isset($this->request->get['colour_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
			$colourcode_info = $this->model_sale_colourcode->getcolourcode($this->request->get['colour_id']);
		}

		$data['user_token'] = $this->session->data['user_token'];

		$this->load->model('setting/store');

		if (isset($this->request->post['colour_code'])) {
			$data['colour_code'] = $this->request->post['colour_code'];
		} elseif (!empty($colourcode_info)) {
			$data['colour_code'] = $colourcode_info['colour_code'];
		} else {
			$data['colour_code'] =   '';
		} 
		if (isset($this->request->post['colour_descr'])) {
			$data['colour_descr'] = $this->request->post['colour_descr'];
		} elseif (!empty($colourcode_info)) {
			$data['colour_descr'] = $colourcode_info['colour_descr'];
		} else {
			$data['colour_descr'] =   '';
		} 

		if (isset($this->request->post['colour_id'])) {
			$data['colour_id'] = $this->request->post['colour_id'];
		} elseif (!empty($colourcode_info)) {
			$data['colour_id'] = $colourcode_info['colour_id'];
		} else {
			$data['colour_id'] = '';
		} 
		
		$this->load->model('localisation/currency');

		$data['currencies'] = $this->model_localisation_currency->getCurrencies();
  
		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('sale/colourcode_form', $data));
	}

	protected function validateForm() {
		if (!$this->user->hasPermission('modify', 'sale/colourcode')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		if ((utf8_strlen($this->request->post['colour_code']) < 1) || (utf8_strlen($this->request->post['colour_code']) > 32)) {
			$this->error['colour_code'] = $this->language->get('error_colour_code');
		} 
 
		if ((utf8_strlen($this->request->post['colour_descr']) < 1) || (utf8_strlen($this->request->post['colour_descr']) > 32)) {
			$this->error['colour_descr'] = $this->language->get('error_colour_descr');
		} 
 
 
		return !$this->error;
	}

	protected function validateDelete() {
		if (!$this->user->hasPermission('modify', 'sale/colourcode')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		return !$this->error;
	}
}