<?php
class ControllerSaleGemstone extends Controller {
	private $error = array();

	public function index() {
		$this->load->language('sale/gemstone');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('sale/gemstone');

		$this->getList();
	}

	public function add() {
		$this->load->language('sale/gemstone');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('sale/gemstone');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
			$this->model_sale_gemstone->addgemstone($this->request->post);

			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			$this->response->redirect($this->url->link('sale/gemstone', 'user_token=' . $this->session->data['user_token'] . $url, true));
		}

		$this->getForm();
	}

	public function edit() {
		$this->load->language('sale/gemstone');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('sale/gemstone');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
			$this->model_sale_gemstone->editgemstone($this->request->get['gemstone_id'], $this->request->post);

			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			$this->response->redirect($this->url->link('sale/gemstone', 'user_token=' . $this->session->data['user_token'] . $url, true));
		}

		$this->getForm();
	}

	public function delete() {
		$this->load->language('sale/gemstone');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('sale/gemstone');

		if (isset($this->request->post['selected']) && $this->validateDelete()) {
			foreach ($this->request->post['selected'] as $gemstone_id) {
				$this->model_sale_gemstone->deletegemstone($gemstone_id);
			}

			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			$this->response->redirect($this->url->link('sale/gemstone', 'user_token=' . $this->session->data['user_token'] . $url, true));
		}

		$this->getList();
	}

	protected function getList() {
		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'gemname';
		}

		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'ASC';
		}

		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

		$url = '';

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$data['breadcrumbs'] =   array();

		$data['breadcrumbs'][] =   array(
			'text' =>  $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] =   array(
			'text' =>  $this->language->get('heading_title'),
			'href' =>  $this->url->link('sale/gemstone', 'user_token=' . $this->session->data['user_token'] . $url, true)
		);

		$data['add'] = $this->url->link('sale/gemstone/add', 'user_token=' . $this->session->data['user_token'] . $url, true);
		$data['delete'] = $this->url->link('sale/gemstone/delete', 'user_token=' . $this->session->data['user_token'] . $url, true);

		$data['gemstone'] = array();

		$filter_data = array(
			'sort'  => $sort,
			'order' => $order,
			'start' => ($page - 1) * $this->config->get('config_limit_admin'),
			'limit' => $this->config->get('config_limit_admin')
		);

		$gemstone_total = $this->model_sale_gemstone->getTotalgemstones();

		$results = $this->model_sale_gemstone->getgemstones($filter_data);

		foreach ($results as $result) {
			$data['gemstone'][] =   array(
				'gemstone_id' 			=> $result['gemstone_id'],
				'gemname'        		=> $result['gemname'],
				'gemcode'     			=> $result['gemcode'],
				'edit'        		=> $this->url->link('sale/gemstone/edit', 'user_token=' . $this->session->data['user_token'] . '&gemstone_id=' . $result['gemstone_id'] . $url, true)
			);
		}

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		if (isset($this->session->data['success'])) {
			$data['success'] = $this->session->data['success'];

			unset($this->session->data['success']);
		} else {
			$data['success'] = '';
		}

		if (isset($this->request->post['selected'])) {
			$data['selected'] = (array)$this->request->post['selected'];
		} else {
			$data['selected'] = array();
		}

		$url = '';

		if ($order == 'ASC') {
			$url .= '&order=DESC';
		} else {
			$url .= '&order=ASC';
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$data['sort_gemname'] = $this->url->link('sale/gemstone', 'user_token=' . $this->session->data['user_token'] . '&sort=gemname' . $url, true);
		$data['sort_gemcode'] = $this->url->link('sale/gemstone', 'user_token=' . $this->session->data['user_token'] . '&sort=gemcode' . $url, true); 

		$url = '';

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		$pagination = new Pagination();
		$pagination->total = $gemstone_total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_limit_admin');
		$pagination->url = $this->url->link('sale/gemstone', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

		$data['pagination'] = $pagination->render();

		$data['results'] = sprintf($this->language->get('text_pagination'), ($gemstone_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($gemstone_total - $this->config->get('config_limit_admin'))) ? $gemstone_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $gemstone_total, ceil($gemstone_total / $this->config->get('config_limit_admin')));

		$data['sort'] = $sort;
		$data['order'] = $order;

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('sale/gemstone_list', $data));
	}

	protected function getForm() {
		$data['text_form'] = !isset($this->request->get['gemstone_id']) ? $this->language->get('text_add') : $this->language->get('text_edit');

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		if (isset($this->error['gemname'])) {
			$data['error_gemname'] = $this->error['gemname'];
		} else {
			$data['error_gemname'] = '';
		}
		if (isset($this->error['gemcode'])) {
			$data['error_gemcode'] = $this->error['gemcode'];
		} else {
			$data['error_gemcode'] = '';
		} 

		if (isset($this->error['sort_order'])) {
			$data['error_sort_order'] = $this->error['sort_order'];
		} else {
			$data['error_sort_order'] = '';
		} 

		$url = '';

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('sale/gemstone', 'user_token=' . $this->session->data['user_token'] . $url, true)
		);

		if (!isset($this->request->get['gemstone_id'])) {
			$data['action'] = $this->url->link('sale/gemstone/add', 'user_token=' . $this->session->data['user_token'] . $url, true);
		} else {
			$data['action'] = $this->url->link('sale/gemstone/edit', 'user_token=' . $this->session->data['user_token'] .  '&gemstone_id=' . $this->request->get['gemstone_id'] . $url, true);
		}

		$data['cancel'] = $this->url->link('sale/gemstone', 'user_token=' . $this->session->data['user_token'] . $url, true);

		if (isset($this->request->get['gemstone_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
			$gemstone_info = $this->model_sale_gemstone->getgemstone($this->request->get['gemstone_id']);
		}

		$data['user_token'] = $this->session->data['user_token'];

		$this->load->model('setting/store');

		if (isset($this->request->post['gemname'])) {
			$data['gemname'] = $this->request->post['gemname'];
		} elseif (!empty($gemstone_info)) {
			$data['gemname'] = $gemstone_info['gemname'];
		} else {
			$data['gemname'] =   '';
		}

		if (isset($this->request->post['gemdescr'])) {
			$data['gemdescr'] = $this->request->post['gemdescr'];
		} elseif (!empty($gemstone_info)) {
			$data['gemdescr'] = $gemstone_info['gemdescr'];
		} else {
			$data['gemdescr'] = '';
		}
		if (isset($this->request->post['gemdetail'])) {
			$data['gemdetail'] = $this->request->post['gemdetail'];
		} elseif (!empty($gemstone_info)) {
			$data['gemdetail'] = $gemstone_info['gemdetail'];
		} else {
			$data['gemdetail'] = '';
		}

		if (isset($this->request->post['gemcode'])) {
			$data['gemcode'] = $this->request->post['gemcode'];
		} elseif (!empty($gemstone_info)) {
			$data['gemcode'] = $gemstone_info['gemcode'];
		} else {
			$data['gemcode'] = '';
		}

		if (isset($this->request->post['birthstone'])) {
			$data['birthstone'] = $this->request->post['birthstone'];
		} elseif (!empty($gemstone_info)) {
			$data['birthstone'] = $gemstone_info['birthstone'];
		} else {
			$data['birthstone'] = '';
		}
		
		if (isset($this->request->post['anniversary'])) {
			$data['anniversary'] = $this->request->post['anniversary'];
		} elseif (!empty($gemstone_info)) {
			$data['anniversary'] = $gemstone_info['anniversary'];
		} else {
			$data['anniversary'] = '';
		}
		if (isset($this->request->post['sort_order'])) {
			$data['sort_order'] = $this->request->post['sort_order'];
		} elseif (!empty($gemstone_info)) {
			$data['sort_order'] = $gemstone_info['sort_order'];
		} else {
			$data['sort_order'] = '';
		}
		if (isset($this->request->post['species'])) {
			$data['species'] = $this->request->post['species'];
		} elseif (!empty($gemstone_info)) {
			$data['species'] = $gemstone_info['species'];
		} else {
			$data['species'] = '';
		}
		if (isset($this->request->post['zodiac'])) {
			$data['zodiac'] = $this->request->post['zodiac'];
		} elseif (!empty($gemstone_info)) {
			$data['zodiac'] = $gemstone_info['zodiac'];
		} else {
			$data['zodiac'] = '';
		}
		if (isset($this->request->post['mohshardness'])) {
			$data['mohshardness'] = $this->request->post['mohshardness'];
		} elseif (!empty($gemstone_info)) {
			$data['mohshardness'] = $gemstone_info['mohshardness'];
		} else {
			$data['mohshardness'] = '';
		}
		if (isset($this->request->post['specificgravity'])) {
			$data['specificgravity'] = $this->request->post['specificgravity'];
		} elseif (!empty($gemstone_info)) {
			$data['specificgravity'] = $gemstone_info['specificgravity'];
		} else {
			$data['specificgravity'] = '';
		}
		if (isset($this->request->post['refractiveindex'])) {
			$data['refractiveindex'] = $this->request->post['refractiveindex'];
		} elseif (!empty($gemstone_info)) {
			$data['refractiveindex'] = $gemstone_info['refractiveindex'];
		} else {
			$data['refractiveindex'] = '';
		} 
		if (isset($this->request->post['birefringence'])) {
			$data['birefringence'] = $this->request->post['birefringence'];
		} elseif (!empty($gemstone_info)) {
			$data['birefringence'] = $gemstone_info['birefringence'];
		} else {
			$data['birefringence'] = '';
		}
		if (isset($this->request->post['opticsign'])) {
			$data['opticsign'] = $this->request->post['opticsign'];
		} elseif (!empty($gemstone_info)) {
			$data['opticsign'] = $gemstone_info['opticsign'];
		} else {
			$data['opticsign'] = '';
		}
		if (isset($this->request->post['icacode'])) {
			$data['icacode'] = $this->request->post['icacode'];
		} elseif (!empty($gemstone_info)) {
			$data['icacode'] = $gemstone_info['icacode'];
		} else {
			$data['icacode'] = '';
		}
		if (isset($this->request->post['treatment'])) {
			$data['treatment'] = $this->request->post['treatment'];
		} elseif (!empty($gemstone_info)) {
			$data['treatment'] = $gemstone_info['treatment'];
		} else {
			$data['treatment'] = '';
		}
		if (isset($this->request->post['incidence'])) {
			$data['incidence'] = $this->request->post['incidence'];
		} elseif (!empty($gemstone_info)) {
			$data['incidence'] = $gemstone_info['incidence'];
		} else {
			$data['incidence'] = '';
		}
		if (isset($this->request->post['purpose'])) {
			$data['purpose'] = $this->request->post['purpose'];
		} elseif (!empty($gemstone_info)) {
			$data['purpose'] = $gemstone_info['purpose'];
		} else {
			$data['purpose'] = '';
		}
		if (isset($this->request->post['durability'])) {
			$data['durability'] = $this->request->post['durability'];
		} elseif (!empty($gemstone_info)) {
			$data['durability'] = $gemstone_info['durability'];
		} else {
			$data['durability'] = '';
		}
		if (isset($this->request->post['detection'])) {
			$data['detection'] = $this->request->post['detection'];
		} elseif (!empty($gemstone_info)) {
			$data['detection'] = $gemstone_info['detection'];
		} else {
			$data['detection'] = '';
		}
		if (isset($this->request->post['specialcare'])) {
			$data['specialcare'] = $this->request->post['specialcare'];
		} elseif (!empty($gemstone_info)) {
			$data['specialcare'] = $gemstone_info['specialcare'];
		} else {
			$data['specialcare'] = '';
		}
		if (isset($this->request->post['limitations'])) {
			$data['limitations'] = $this->request->post['limitations'];
		} elseif (!empty($gemstone_info)) {
			$data['limitations'] = $gemstone_info['limitations'];
		} else {
			$data['limitations'] = '';
		}
		if (isset($this->request->post['category_display'])) {
			$data['category_display'] = $this->request->post['category_display'];
		} elseif (!empty($gemstone_info)) {
			$data['category_display'] = $gemstone_info['category_display'];
		} else {
			$data['category_display'] = '';
		}
		if (isset($this->request->post['months'])) {
			$data['months'] = $this->request->post['months'];
		} elseif (!empty($gemstone_info)) {
			$data['months'] = $gemstone_info['months'];
		} else {
			$data['months'] = '';
		}
		if (isset($this->request->post['category_display'])) {
			$data['category_display'] = $this->request->post['category_display'];
		} elseif (!empty($gemstone_info)) {
			$data['category_display'] = $gemstone_info['category_display'];
		} else {
			$data['category_display'] = '';
		}
		
		if (isset($this->request->post['image'])) {
			$data['image'] = $this->request->post['image'];
		} elseif (!empty($gemstone_info)) {
			$data['image'] = $gemstone_info['image1'];
		} else {
			$data['image'] = '';
		}
		
		$this->load->model('localisation/currency');

		$data['currencies'] = $this->model_localisation_currency->getCurrencies();

		$this->load->model('tool/image');

		if (isset($this->request->post['image']) && is_file(DIR_IMAGE . $this->request->post['image'])) {
			$data['thumb'] = $this->model_tool_image->resize($this->request->post['image'], 100, 100);
		} elseif (!empty($gemstone_info) && is_file(DIR_IMAGE . $gemstone_info['image1'])) {
			$data['thumb'] = $this->model_tool_image->resize($gemstone_info['image1'], 100, 100);
		} else {
			$data['thumb'] = $this->model_tool_image->resize('no_image.png', 100, 100);
		}

		$data['placeholder'] = $this->model_tool_image->resize('no_image.png', 100, 100);
 
		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('sale/gemstone_form', $data));
	}

	protected function validateForm() {
		if (!$this->user->hasPermission('modify', 'sale/gemstone')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		if ((utf8_strlen($this->request->post['gemname']) < 1) || (utf8_strlen($this->request->post['gemname']) > 32)) {
			$this->error['gemname'] = $this->language->get('error_gemname');
		} 

		if ((utf8_strlen($this->request->post['gemdescr']) < 1) || (utf8_strlen($this->request->post['gemdescr']) > 128)) {
			$this->error['gemdescr'] = $this->language->get('error_gemdescr');
		}
 
		return !$this->error;
	}

	protected function validateDelete() {
		if (!$this->user->hasPermission('modify', 'sale/gemstone')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		return !$this->error;
	}
}