<?php
class ControllerSaleMetal extends Controller {
	private $error = array();

	public function index() {
		$this->load->language('sale/metal');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('sale/metal');

		$this->getList();
	}

	public function add() {
		$this->load->language('sale/metal');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('sale/metal');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
			$this->model_sale_metal->addmetal($this->request->post);

			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			$this->response->redirect($this->url->link('sale/metal', 'user_token=' . $this->session->data['user_token'] . $url, true));
		}

		$this->getForm();
	}

	public function edit() {
		$this->load->language('sale/metal');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('sale/metal');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
			$this->model_sale_metal->editmetal($this->request->get['metal_id'], $this->request->post);

			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			$this->response->redirect($this->url->link('sale/metal', 'user_token=' . $this->session->data['user_token'] . $url, true));
		}

		$this->getForm();
	}

	public function delete() {
		$this->load->language('sale/metal');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('sale/metal');

		if (isset($this->request->post['selected']) && $this->validateDelete()) {
			foreach ($this->request->post['selected'] as $metal_id) {
				$this->model_sale_metal->deletemetal($metal_id);
			}

			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			$this->response->redirect($this->url->link('sale/metal', 'user_token=' . $this->session->data['user_token'] . $url, true));
		}

		$this->getList();
	}

	protected function getList() {
		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'metalname';
		}

		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'ASC';
		}

		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

		$url = '';

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$data['breadcrumbs'] =   array();

		$data['breadcrumbs'][] =   array(
			'text' =>  $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] =   array(
			'text' =>  $this->language->get('heading_title'),
			'href' =>  $this->url->link('sale/metal', 'user_token=' . $this->session->data['user_token'] . $url, true)
		);

		$data['add'] = $this->url->link('sale/metal/add', 'user_token=' . $this->session->data['user_token'] . $url, true);
		$data['delete'] = $this->url->link('sale/metal/delete', 'user_token=' . $this->session->data['user_token'] . $url, true);

		$data['metal'] = array();

		$filter_data = array(
			'sort'  => $sort,
			'order' => $order,
			'start' => ($page - 1) * $this->config->get('config_limit_admin'),
			'limit' => $this->config->get('config_limit_admin')
		);

		$metal_total = $this->model_sale_metal->getTotalmetals();

		$results = $this->model_sale_metal->getmetals($filter_data);

		foreach ($results as $result) {
			$data['metal'][] =   array(
				'metal_id' 			=> $result['metal_id'],
				'metalname'        		=> $result['metalname'],
				'description'     	=> $result['description'],
				'priceperounce'     	=> $result['priceperounce'],
				'pricepergram'     	=> $result['pricepergram'],
				'edit'        		=> $this->url->link('sale/metal/edit', 'user_token=' . $this->session->data['user_token'] . '&metal_id=' . $result['metal_id'] . $url, true)
			);
		}

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		if (isset($this->session->data['success'])) {
			$data['success'] = $this->session->data['success'];

			unset($this->session->data['success']);
		} else {
			$data['success'] = '';
		}

		if (isset($this->request->post['selected'])) {
			$data['selected'] = (array)$this->request->post['selected'];
		} else {
			$data['selected'] = array();
		}

		$url = '';

		if ($order == 'ASC') {
			$url .= '&order=DESC';
		} else {
			$url .= '&order=ASC';
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$data['sort_metalname'] = $this->url->link('sale/metal', 'user_token=' . $this->session->data['user_token'] . '&sort=metalname' . $url, true);
		$data['sort_description'] = $this->url->link('sale/metal', 'user_token=' . $this->session->data['user_token'] . '&sort=description' . $url, true);
		$data['sort_pricepergram'] = $this->url->link('sale/metal', 'user_token=' . $this->session->data['user_token'] . '&sort=pricepergram' . $url, true);
		$data['sort_priceperounce'] = $this->url->link('sale/metal', 'user_token=' . $this->session->data['user_token'] . '&sort=priceperounce' . $url, true);

		$url = '';

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		$pagination = new Pagination();
		$pagination->total = $metal_total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_limit_admin');
		$pagination->url = $this->url->link('sale/metal', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

		$data['pagination'] = $pagination->render();

		$data['results'] = sprintf($this->language->get('text_pagination'), ($metal_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($metal_total - $this->config->get('config_limit_admin'))) ? $metal_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $metal_total, ceil($metal_total / $this->config->get('config_limit_admin')));

		$data['sort'] = $sort;
		$data['order'] = $order;

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('sale/metal_list', $data));
	}

	protected function getForm() {
		$data['text_form'] = !isset($this->request->get['metal_id']) ? $this->language->get('text_add') : $this->language->get('text_edit');

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		if (isset($this->error['metalname'])) {
			$data['error_metalname'] = $this->error['metalname'];
		} else {
			$data['error_metalname'] = '';
		}
		if (isset($this->error['metal_code'])) {
			$data['error_metal_code'] = $this->error['metal_code'];
		} else {
			$data['error_metal_code'] = '';
		}

		if (isset($this->error['description'])) {
			$data['error_description'] = $this->error['description'];
		} else {
			$data['error_description'] = '';
		}

		if (isset($this->error['silver_ratio'])) {
			$data['error_silver_ratio'] = $this->error['silver_ratio'];
		} else {
			$data['error_silver_ratio'] = '';
		}
		if (isset($this->error['pricepergram'])) {
			$data['error_pricepergram'] = $this->error['pricepergram'];
		} else {
			$data['error_pricepergram'] = '';
		}
		if (isset($this->error['sort_order'])) {
			$data['error_sort_order'] = $this->error['sort_order'];
		} else {
			$data['error_sort_order'] = '';
		}

		$url = '';

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('sale/metal', 'user_token=' . $this->session->data['user_token'] . $url, true)
		);

		if (!isset($this->request->get['metal_id'])) {
			$data['action'] = $this->url->link('sale/metal/add', 'user_token=' . $this->session->data['user_token'] . $url, true);
		} else {
			$data['action'] = $this->url->link('sale/metal/edit', 'user_token=' . $this->session->data['user_token'] .  '&metal_id=' . $this->request->get['metal_id'] . $url, true);
		}

		$data['cancel'] = $this->url->link('sale/metal', 'user_token=' . $this->session->data['user_token'] . $url, true);

		if (isset($this->request->get['metal_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
			$metal_info = $this->model_sale_metal->getmetal($this->request->get['metal_id']);
		}

		$data['user_token'] = $this->session->data['user_token'];

		$this->load->model('setting/store');

		if (isset($this->request->post['metalname'])) {
			$data['metalname'] = $this->request->post['metalname'];
		} elseif (!empty($metal_info)) {
			$data['metalname'] = $metal_info['metalname'];
		} else {
			$data['metalname'] =   '';
		}

		if (isset($this->request->post['description'])) {
			$data['description'] = $this->request->post['description'];
		} elseif (!empty($metal_info)) {
			$data['description'] = $metal_info['description'];
		} else {
			$data['description'] = '';
		}

		if (isset($this->request->post['metal_code'])) {
			$data['metal_code'] = $this->request->post['metal_code'];
		} elseif (!empty($metal_info)) {
			$data['metal_code'] = $metal_info['metal_code'];
		} else {
			$data['metal_code'] = '';
		}

		if (isset($this->request->post['silver_ratio'])) {
			$data['silver_ratio'] = $this->request->post['silver_ratio'];
		} elseif (!empty($metal_info)) {
			$data['silver_ratio'] = $metal_info['silver_ratio'];
		} else {
			$data['silver_ratio'] = '';
		}
		
		if (isset($this->request->post['pricepergram'])) {
			$data['pricepergram'] = $this->request->post['pricepergram'];
		} elseif (!empty($metal_info)) {
			$data['pricepergram'] = $metal_info['pricepergram'];
		} else {
			$data['pricepergram'] = '';
		}
		if (isset($this->request->post['sort_order'])) {
			$data['sort_order'] = $this->request->post['sort_order'];
		} elseif (!empty($metal_info)) {
			$data['sort_order'] = $metal_info['sort_order'];
		} else {
			$data['sort_order'] = '';
		}
		if (isset($this->request->post['ccurrency'])) {
			$data['ccurrency'] = $this->request->post['ccurrency'];
		} elseif (!empty($metal_info)) {
			$data['ccurrency'] = $metal_info['ccurrency'];
		} else {
			$data['ccurrency'] = '';
		}
		
		if (isset($this->request->post['image'])) {
			$data['image'] = $this->request->post['image'];
		} elseif (!empty($metal_info)) {
			$data['image'] = $metal_info['image'];
		} else {
			$data['image'] = '';
		}
		
		$this->load->model('localisation/currency');

		$data['currencies'] = $this->model_localisation_currency->getCurrencies();

		$this->load->model('tool/image');

		if (isset($this->request->post['image']) && is_file(DIR_IMAGE . $this->request->post['image'])) {
			$data['thumb'] = $this->model_tool_image->resize($this->request->post['image'], 100, 100);
		} elseif (!empty($metal_info) && is_file(DIR_IMAGE . $metal_info['image'])) {
			echo $metal_info['image'];
			$data['thumb'] = $this->model_tool_image->resize($metal_info['image'], 100, 100);
		} else {
			$data['thumb'] = $this->model_tool_image->resize('no_image.png', 100, 100);
		}

		$data['placeholder'] = $this->model_tool_image->resize('no_image.png', 100, 100);
 
		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('sale/metal_form', $data));
	}

	protected function validateForm() {
		if (!$this->user->hasPermission('modify', 'sale/metal')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		if ((utf8_strlen($this->request->post['metalname']) < 1) || (utf8_strlen($this->request->post['metalname']) > 32)) {
			$this->error['metalname'] = $this->language->get('error_metalname');
		}
		if ((utf8_strlen($this->request->post['metal_code']) < 1) || (utf8_strlen($this->request->post['metal_code']) > 32)) {
			$this->error['metal_code'] = $this->language->get('error_metal_code');
		}

		if ((utf8_strlen($this->request->post['description']) < 1) || (utf8_strlen($this->request->post['description']) > 128)) {
			$this->error['description'] = $this->language->get('error_description');
		}
 
		return !$this->error;
	}

	protected function validateDelete() {
		if (!$this->user->hasPermission('modify', 'sale/metal')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		return !$this->error;
	}
}