<?php
class ControllerSettingSetting extends Controller {
	private $error = array();

	public function index() {
		$this->load->language('setting/setting');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('setting/setting');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
			$this->model_setting_setting->editSetting('config', $this->request->post);
			//$this->log->write($this->request->post);

			if ($this->config->get('config_currency_auto')) {
				$this->load->model('localisation/currency');

				$this->model_localisation_currency->refresh();
			}

			$this->session->data['success'] = $this->language->get('text_success');

			$this->response->redirect($this->url->link('setting/store', 'user_token=' . $this->session->data['user_token'], true));
		}

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		if (isset($this->error['name'])) {
			$data['error_name'] = $this->error['name'];
		} else {
			$data['error_name'] = '';
		}

		if (isset($this->error['owner'])) {
			$data['error_owner'] = $this->error['owner'];
		} else {
			$data['error_owner'] = '';
		}

		if (isset($this->error['address'])) {
			$data['error_address'] = $this->error['address'];
		} else {
			$data['error_address'] = '';
		}

		if (isset($this->error['email'])) {
			$data['error_email'] = $this->error['email'];
		} else {
			$data['error_email'] = '';
		}

		if (isset($this->error['telephone'])) {
			$data['error_telephone'] = $this->error['telephone'];
		} else {
			$data['error_telephone'] = '';
		}

		if (isset($this->error['meta_title'])) {
			$data['error_meta_title'] = $this->error['meta_title'];
		} else {
			$data['error_meta_title'] = '';
		}

		if (isset($this->error['country'])) {
			$data['error_country'] = $this->error['country'];
		} else {
			$data['error_country'] = '';
		}

		if (isset($this->error['zone'])) {
			$data['error_zone'] = $this->error['zone'];
		} else {
			$data['error_zone'] = '';
		}

		if (isset($this->error['customer_group_display'])) {
			$data['error_customer_group_display'] = $this->error['customer_group_display'];
		} else {
			$data['error_customer_group_display'] = '';
		}

		if (isset($this->error['login_attempts'])) {
			$data['error_login_attempts'] = $this->error['login_attempts'];
		} else {
			$data['error_login_attempts'] = '';
		}

		if (isset($this->error['voucher_min'])) {
			$data['error_voucher_min'] = $this->error['voucher_min'];
		} else {
			$data['error_voucher_min'] = '';
		}

		if (isset($this->error['voucher_max'])) {
			$data['error_voucher_max'] = $this->error['voucher_max'];
		} else {
			$data['error_voucher_max'] = '';
		}

		if (isset($this->error['processing_status'])) {
			$data['error_processing_status'] = $this->error['processing_status'];
		} else {
			$data['error_processing_status'] = '';
		}

		if (isset($this->error['complete_status'])) {
			$data['error_complete_status'] = $this->error['complete_status'];
		} else {
			$data['error_complete_status'] = '';
		}

		if (isset($this->error['log'])) {
			$data['error_log'] = $this->error['log'];
		} else {
			$data['error_log'] = '';
		}

		if (isset($this->error['limit_admin'])) {
			$data['error_limit_admin'] = $this->error['limit_admin'];
		} else {
			$data['error_limit_admin'] = '';
		}

		if (isset($this->error['encryption'])) {
			$data['error_encryption'] = $this->error['encryption'];
		} else {
			$data['error_encryption'] = '';
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_stores'),
			'href' => $this->url->link('setting/store', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('setting/setting', 'user_token=' . $this->session->data['user_token'], true)
		);

		if (isset($this->session->data['success'])) {
			$data['success'] = $this->session->data['success'];

			unset($this->session->data['success']);
		} else {
			$data['success'] = '';
		}

		$data['action'] = $this->url->link('setting/setting', 'user_token=' . $this->session->data['user_token'], true);

		$data['cancel'] = $this->url->link('setting/store', 'user_token=' . $this->session->data['user_token'], true);
		
		$data['user_token'] = $this->session->data['user_token'];

		if (isset($this->request->post['config_meta_title'])) {
			$data['config_meta_title'] = $this->request->post['config_meta_title'];
		} else {
			$data['config_meta_title'] = $this->config->get('config_meta_title');
		}

		if (isset($this->request->post['config_meta_description'])) {
			$data['config_meta_description'] = $this->request->post['config_meta_description'];
		} else {
			$data['config_meta_description'] = $this->config->get('config_meta_description');
		}

		if (isset($this->request->post['config_meta_keyword'])) {
			$data['config_meta_keyword'] = $this->request->post['config_meta_keyword'];
		} else {
			$data['config_meta_keyword'] = $this->config->get('config_meta_keyword');
		}

		if (isset($this->request->post['config_theme'])) {
			$data['config_theme'] = $this->request->post['config_theme'];
		} else {
			$data['config_theme'] = $this->config->get('config_theme');
		}

		if ($this->request->server['HTTPS']) {
			$data['store_url'] = HTTPS_CATALOG;
		} else {
			$data['store_url'] = HTTP_CATALOG;
		}

		$data['themes'] = array();

		$this->load->model('setting/extension');

		$extensions = $this->model_setting_extension->getInstalled('theme');

		foreach ($extensions as $code) {
			$this->load->language('extension/theme/' . $code, 'extension');

			$data['themes'][] = array(
				'text'  => $this->language->get('extension')->get('heading_title'),
				'value' => $code
			);
		}

		if (isset($this->request->post['config_layout_id'])) {
			$data['config_layout_id'] = $this->request->post['config_layout_id'];
		} else {
			$data['config_layout_id'] = $this->config->get('config_layout_id');
		}

		$this->load->model('design/layout');

		$data['layouts'] = $this->model_design_layout->getLayouts();

		if (isset($this->request->post['config_name'])) {
			$data['config_name'] = $this->request->post['config_name'];
		} else {
			$data['config_name'] = $this->config->get('config_name');
		}

		if (isset($this->request->post['config_owner'])) {
			$data['config_owner'] = $this->request->post['config_owner'];
		} else {
			$data['config_owner'] = $this->config->get('config_owner');
		}

		if (isset($this->request->post['config_address'])) {
			$data['config_address'] = $this->request->post['config_address'];
		} else {
			$data['config_address'] = $this->config->get('config_address');
		}

		if (isset($this->request->post['config_geocode'])) {
			$data['config_geocode'] = $this->request->post['config_geocode'];
		} else {
			$data['config_geocode'] = $this->config->get('config_geocode');
		}

		if (isset($this->request->post['config_email'])) {
			$data['config_email'] = $this->request->post['config_email'];
		} else {
			$data['config_email'] = $this->config->get('config_email');
		}

		if (isset($this->request->post['config_telephone'])) {
			$data['config_telephone'] = $this->request->post['config_telephone'];
		} else {
			$data['config_telephone'] = $this->config->get('config_telephone');
		}

		if (isset($this->request->post['config_fax'])) {
			$data['config_fax'] = $this->request->post['config_fax'];
		} else {
			$data['config_fax'] = $this->config->get('config_fax');
		}

		if (isset($this->request->post['config_image'])) {
			$data['config_image'] = $this->request->post['config_image'];
		} else {
			$data['config_image'] = $this->config->get('config_image');
		}

		$this->load->model('tool/image');

		if (isset($this->request->post['config_image']) && is_file(DIR_IMAGE . $this->request->post['config_image'])) {
			$data['thumb'] = $this->model_tool_image->resize($this->request->post['config_image'], 100, 100);
		} elseif ($this->config->get('config_image') && is_file(DIR_IMAGE . $this->config->get('config_image'))) {
			$data['thumb'] = $this->model_tool_image->resize($this->config->get('config_image'), 100, 100);
		} else {
			$data['thumb'] = $this->model_tool_image->resize('no_image.png', 100, 100);
		}

		$data['placeholder'] = $this->model_tool_image->resize('no_image.png', 100, 100);

		if (isset($this->request->post['config_open'])) {
			$data['config_open'] = $this->request->post['config_open'];
		} else {
			$data['config_open'] = $this->config->get('config_open');
		}

		if (isset($this->request->post['config_comment'])) {
			$data['config_comment'] = $this->request->post['config_comment'];
		} else {
			$data['config_comment'] = $this->config->get('config_comment');
		}

		$this->load->model('localisation/location');

		$data['locations'] = $this->model_localisation_location->getLocations();

		if (isset($this->request->post['config_location'])) {
			$data['config_location'] = $this->request->post['config_location'];
		} elseif ($this->config->get('config_location')) {
			$data['config_location'] = $this->config->get('config_location');
		} else {
			$data['config_location'] = array();
		}

		if (isset($this->request->post['config_country_id'])) {
			$data['config_country_id'] = $this->request->post['config_country_id'];
		} else {
			$data['config_country_id'] = $this->config->get('config_country_id');
		}

		$this->load->model('localisation/country');

		$data['countries'] = $this->model_localisation_country->getCountries();

		if (isset($this->request->post['config_zone_id'])) {
			$data['config_zone_id'] = $this->request->post['config_zone_id'];
		} else {
			$data['config_zone_id'] = $this->config->get('config_zone_id');
		}

		if (isset($this->request->post['config_language'])) {
			$data['config_language'] = $this->request->post['config_language'];
		} else {
			$data['config_language'] = $this->config->get('config_language');
		}

		$this->load->model('localisation/language');

		$data['languages'] = $this->model_localisation_language->getLanguages();

		if (isset($this->request->post['config_admin_language'])) {
			$data['config_admin_language'] = $this->request->post['config_admin_language'];
		} else {
			$data['config_admin_language'] = $this->config->get('config_admin_language');
		}

		if (isset($this->request->post['config_currency'])) {
			$data['config_currency'] = $this->request->post['config_currency'];
		} else {
			$data['config_currency'] = $this->config->get('config_currency');
		}

		if (isset($this->request->post['config_currency_auto'])) {
			$data['config_currency_auto'] = $this->request->post['config_currency_auto'];
		} else {
			$data['config_currency_auto'] = $this->config->get('config_currency_auto');
		}

		$this->load->model('localisation/currency');

		$data['currencies'] = $this->model_localisation_currency->getCurrencies();

		if (isset($this->request->post['config_length_class_id'])) {
			$data['config_length_class_id'] = $this->request->post['config_length_class_id'];
		} else {
			$data['config_length_class_id'] = $this->config->get('config_length_class_id');
		}

		$this->load->model('localisation/length_class');

		$data['length_classes'] = $this->model_localisation_length_class->getLengthClasses();

		if (isset($this->request->post['config_weight_class_id'])) {
			$data['config_weight_class_id'] = $this->request->post['config_weight_class_id'];
		} else {
			$data['config_weight_class_id'] = $this->config->get('config_weight_class_id');
		}

		$this->load->model('localisation/weight_class');

		$data['weight_classes'] = $this->model_localisation_weight_class->getWeightClasses();

		if (isset($this->request->post['config_limit_admin'])) {
			$data['config_limit_admin'] = $this->request->post['config_limit_admin'];
		} else {
			$data['config_limit_admin'] = $this->config->get('config_limit_admin');
		}

		if (isset($this->request->post['config_product_count'])) {
			$data['config_product_count'] = $this->request->post['config_product_count'];
		} else {
			$data['config_product_count'] = $this->config->get('config_product_count');
		}

		if (isset($this->request->post['config_review_status'])) {
			$data['config_review_status'] = $this->request->post['config_review_status'];
		} else {
			$data['config_review_status'] = $this->config->get('config_review_status');
		}

		if (isset($this->request->post['config_review_guest'])) {
			$data['config_review_guest'] = $this->request->post['config_review_guest'];
		} else {
			$data['config_review_guest'] = $this->config->get('config_review_guest');
		}

		if (isset($this->request->post['config_voucher_min'])) {
			$data['config_voucher_min'] = $this->request->post['config_voucher_min'];
		} else {
			$data['config_voucher_min'] = $this->config->get('config_voucher_min');
		}

		if (isset($this->request->post['config_voucher_max'])) {
			$data['config_voucher_max'] = $this->request->post['config_voucher_max'];
		} else {
			$data['config_voucher_max'] = $this->config->get('config_voucher_max');
		}

		if (isset($this->request->post['config_tax'])) {
			$data['config_tax'] = $this->request->post['config_tax'];
		} else {
			$data['config_tax'] = $this->config->get('config_tax');
		}

		if (isset($this->request->post['config_tax_default'])) {
			$data['config_tax_default'] = $this->request->post['config_tax_default'];
		} else {
			$data['config_tax_default'] = $this->config->get('config_tax_default');
		}

		if (isset($this->request->post['config_tax_customer'])) {
			$data['config_tax_customer'] = $this->request->post['config_tax_customer'];
		} else {
			$data['config_tax_customer'] = $this->config->get('config_tax_customer');
		}

		if (isset($this->request->post['config_customer_online'])) {
			$data['config_customer_online'] = $this->request->post['config_customer_online'];
		} else {
			$data['config_customer_online'] = $this->config->get('config_customer_online');
		}

		if (isset($this->request->post['config_customer_activity'])) {
			$data['config_customer_activity'] = $this->request->post['config_customer_activity'];
		} else {
			$data['config_customer_activity'] = $this->config->get('config_customer_activity');
		}

		if (isset($this->request->post['config_customer_search'])) {
			$data['config_customer_search'] = $this->request->post['config_customer_search'];
		} else {
			$data['config_customer_search'] = $this->config->get('config_customer_search');
		}

		if (isset($this->request->post['config_customer_group_id'])) {
			$data['config_customer_group_id'] = $this->request->post['config_customer_group_id'];
		} else {
			$data['config_customer_group_id'] = $this->config->get('config_customer_group_id');
		}

		$this->load->model('customer/customer_group');

		$data['customer_groups'] = $this->model_customer_customer_group->getCustomerGroups();

		if (isset($this->request->post['config_customer_group_display'])) {
			$data['config_customer_group_display'] = $this->request->post['config_customer_group_display'];
		} elseif ($this->config->get('config_customer_group_display')) {
			$data['config_customer_group_display'] = $this->config->get('config_customer_group_display');
		} else {
			$data['config_customer_group_display'] = array();
		}

		if (isset($this->request->post['config_customer_price'])) {
			$data['config_customer_price'] = $this->request->post['config_customer_price'];
		} else {
			$data['config_customer_price'] = $this->config->get('config_customer_price');
		}

		if (isset($this->request->post['config_login_attempts'])) {
			$data['config_login_attempts'] = $this->request->post['config_login_attempts'];
		} elseif ($this->config->has('config_login_attempts')) {
			$data['config_login_attempts'] = $this->config->get('config_login_attempts');
		} else {
			$data['config_login_attempts'] = 5;
		}

		if (isset($this->request->post['config_account_id'])) {
			$data['config_account_id'] = $this->request->post['config_account_id'];
		} else {
			$data['config_account_id'] = $this->config->get('config_account_id');
		}

		$this->load->model('catalog/information');

		$data['informations'] = $this->model_catalog_information->getInformations();

		if (isset($this->request->post['config_cart_weight'])) {
			$data['config_cart_weight'] = $this->request->post['config_cart_weight'];
		} else {
			$data['config_cart_weight'] = $this->config->get('config_cart_weight');
		}

		if (isset($this->request->post['config_checkout_guest'])) {
			$data['config_checkout_guest'] = $this->request->post['config_checkout_guest'];
		} else {
			$data['config_checkout_guest'] = $this->config->get('config_checkout_guest');
		}

		if (isset($this->request->post['config_checkout_id'])) {
			$data['config_checkout_id'] = $this->request->post['config_checkout_id'];
		} else {
			$data['config_checkout_id'] = $this->config->get('config_checkout_id');
		}

		if (isset($this->request->post['config_invoice_prefix'])) {
			$data['config_invoice_prefix'] = $this->request->post['config_invoice_prefix'];
		} elseif ($this->config->get('config_invoice_prefix')) {
			$data['config_invoice_prefix'] = $this->config->get('config_invoice_prefix');
		} else {
			$data['config_invoice_prefix'] = 'INV-' . date('Y') . '-00';
		}

		if (isset($this->request->post['config_order_status_id'])) {
			$data['config_order_status_id'] = $this->request->post['config_order_status_id'];
		} else {
			$data['config_order_status_id'] = $this->config->get('config_order_status_id');
		}

		if (isset($this->request->post['config_processing_status'])) {
			$data['config_processing_status'] = $this->request->post['config_processing_status'];
		} elseif ($this->config->get('config_processing_status')) {
			$data['config_processing_status'] = $this->config->get('config_processing_status');
		} else {
			$data['config_processing_status'] = array();
		}

		if (isset($this->request->post['config_complete_status'])) {
			$data['config_complete_status'] = $this->request->post['config_complete_status'];
		} elseif ($this->config->get('config_complete_status')) {
			$data['config_complete_status'] = $this->config->get('config_complete_status');
		} else {
			$data['config_complete_status'] = array();
		}

		if (isset($this->request->post['config_fraud_status_id'])) {
			$data['config_fraud_status_id'] = $this->request->post['config_fraud_status_id'];
		} else {
			$data['config_fraud_status_id'] = $this->config->get('config_fraud_status_id');
		}

		$this->load->model('localisation/order_status');

		$data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();

		if (isset($this->request->post['config_api_id'])) {
			$data['config_api_id'] = $this->request->post['config_api_id'];
		} else {
			$data['config_api_id'] = $this->config->get('config_api_id');
		}

		$this->load->model('user/api');

		$data['apis'] = $this->model_user_api->getApis();

		if (isset($this->request->post['config_stock_display'])) {
			$data['config_stock_display'] = $this->request->post['config_stock_display'];
		} else {
			$data['config_stock_display'] = $this->config->get('config_stock_display');
		}

		if (isset($this->request->post['config_stock_warning'])) {
			$data['config_stock_warning'] = $this->request->post['config_stock_warning'];
		} else {
			$data['config_stock_warning'] = $this->config->get('config_stock_warning');
		}

		if (isset($this->request->post['config_stock_checkout'])) {
			$data['config_stock_checkout'] = $this->request->post['config_stock_checkout'];
		} else {
			$data['config_stock_checkout'] = $this->config->get('config_stock_checkout');
		}

		if (isset($this->request->post['config_affiliate_group_id'])) {
			$data['config_affiliate_group_id'] = $this->request->post['config_affiliate_group_id'];
		} else {
			$data['config_affiliate_group_id'] = $this->config->get('config_affiliate_group_id');
		}

		if (isset($this->request->post['config_affiliate_approval'])) {
			$data['config_affiliate_approval'] = $this->request->post['config_affiliate_approval'];
		} elseif ($this->config->has('config_affiliate_approval')) {
			$data['config_affiliate_approval'] = $this->config->get('config_affiliate_approval');
		} else {
			$data['config_affiliate_approval'] = '';
		}

		if (isset($this->request->post['config_affiliate_auto'])) {
			$data['config_affiliate_auto'] = $this->request->post['config_affiliate_auto'];
		} elseif ($this->config->has('config_affiliate_auto')) {
			$data['config_affiliate_auto'] = $this->config->get('config_affiliate_auto');
		} else {
			$data['config_affiliate_auto'] = '';
		}

		if (isset($this->request->post['config_affiliate_commission'])) {
			$data['config_affiliate_commission'] = $this->request->post['config_affiliate_commission'];
		} elseif ($this->config->has('config_affiliate_commission')) {
			$data['config_affiliate_commission'] = $this->config->get('config_affiliate_commission');
		} else {
			$data['config_affiliate_commission'] = '5.00';
		}

		if (isset($this->request->post['config_affiliate_id'])) {
			$data['config_affiliate_id'] = $this->request->post['config_affiliate_id'];
		} else {
			$data['config_affiliate_id'] = $this->config->get('config_affiliate_id');
		}

		if (isset($this->request->post['config_return_id'])) {
			$data['config_return_id'] = $this->request->post['config_return_id'];
		} else {
			$data['config_return_id'] = $this->config->get('config_return_id');
		}

		if (isset($this->request->post['config_return_status_id'])) {
			$data['config_return_status_id'] = $this->request->post['config_return_status_id'];
		} else {
			$data['config_return_status_id'] = $this->config->get('config_return_status_id');
		}

		$this->load->model('localisation/return_status');

		$data['return_statuses'] = $this->model_localisation_return_status->getReturnStatuses();

		if (isset($this->request->post['config_captcha'])) {
			$data['config_captcha'] = $this->request->post['config_captcha'];
		} else {
			$data['config_captcha'] = $this->config->get('config_captcha');
		}

		$this->load->model('setting/extension');

		$data['captchas'] = array();

		// Get a list of installed captchas
		$extensions = $this->model_setting_extension->getInstalled('captcha');

		foreach ($extensions as $code) {
			$this->load->language('extension/captcha/' . $code, 'extension');

			if ($this->config->get('captcha_' . $code . '_status')) {
				$data['captchas'][] = array(
					'text'  => $this->language->get('extension')->get('heading_title'),
					'value' => $code
				);
			}
		}

		if (isset($this->request->post['config_captcha_page'])) {
			$data['config_captcha_page'] = $this->request->post['config_captcha_page'];
		} elseif ($this->config->has('config_captcha_page')) {
		   	$data['config_captcha_page'] = $this->config->get('config_captcha_page');
		} else {
			$data['config_captcha_page'] = array();
		}

		$data['captcha_pages'] = array();

		$data['captcha_pages'][] = array(
			'text'  => $this->language->get('text_register'),
			'value' => 'register'
		);

		$data['captcha_pages'][] = array(
			'text'  => $this->language->get('text_guest'),
			'value' => 'guest'
		);

		$data['captcha_pages'][] = array(
			'text'  => $this->language->get('text_review'),
			'value' => 'review'
		);

		$data['captcha_pages'][] = array(
			'text'  => $this->language->get('text_return'),
			'value' => 'return'
		);

		$data['captcha_pages'][] = array(
			'text'  => $this->language->get('text_contact'),
			'value' => 'contact'
		);

		if (isset($this->request->post['config_logo'])) {
			$data['config_logo'] = $this->request->post['config_logo'];
		} else {
			$data['config_logo'] = $this->config->get('config_logo');
		}

		if (isset($this->request->post['config_logo']) && is_file(DIR_IMAGE . $this->request->post['config_logo'])) {
			$data['logo'] = $this->model_tool_image->resize($this->request->post['config_logo'], 100, 100);
		} elseif ($this->config->get('config_logo') && is_file(DIR_IMAGE . $this->config->get('config_logo'))) {
			$data['logo'] = $this->model_tool_image->resize($this->config->get('config_logo'), 100, 100);
		} else {
			$data['logo'] = $this->model_tool_image->resize('no_image.png', 100, 100);
		}

		if (isset($this->request->post['config_icon'])) {
			$data['config_icon'] = $this->request->post['config_icon'];
		} else {
			$data['config_icon'] = $this->config->get('config_icon');
		}

		if (isset($this->request->post['config_icon']) && is_file(DIR_IMAGE . $this->request->post['config_icon'])) {
			$data['icon'] = $this->model_tool_image->resize($this->request->post['config_icon'], 100, 100);
		} elseif ($this->config->get('config_icon') && is_file(DIR_IMAGE . $this->config->get('config_icon'))) {
			$data['icon'] = $this->model_tool_image->resize($this->config->get('config_icon'), 100, 100);
		} else {
			$data['icon'] = $this->model_tool_image->resize('no_image.png', 100, 100);
		}

		if (isset($this->request->post['config_mail_engine'])) {
			$data['config_mail_engine'] = $this->request->post['config_mail_engine'];
		} else {
			$data['config_mail_engine'] = $this->config->get('config_mail_engine');
		}

		if (isset($this->request->post['config_mail_parameter'])) {
			$data['config_mail_parameter'] = $this->request->post['config_mail_parameter'];
		} else {
			$data['config_mail_parameter'] = $this->config->get('config_mail_parameter');
		}

		if (isset($this->request->post['config_mail_smtp_hostname'])) {
			$data['config_mail_smtp_hostname'] = $this->request->post['config_mail_smtp_hostname'];
		} else {
			$data['config_mail_smtp_hostname'] = $this->config->get('config_mail_smtp_hostname');
		}

		if (isset($this->request->post['config_mail_smtp_username'])) {
			$data['config_mail_smtp_username'] = $this->request->post['config_mail_smtp_username'];
		} else {
			$data['config_mail_smtp_username'] = $this->config->get('config_mail_smtp_username');
		}

		if (isset($this->request->post['config_mail_smtp_password'])) {
			$data['config_mail_smtp_password'] = $this->request->post['config_mail_smtp_password'];
		} else {
			$data['config_mail_smtp_password'] = $this->config->get('config_mail_smtp_password');
		}

		if (isset($this->request->post['config_mail_smtp_port'])) {
			$data['config_mail_smtp_port'] = $this->request->post['config_mail_smtp_port'];
		} elseif ($this->config->has('config_mail_smtp_port')) {
			$data['config_mail_smtp_port'] = $this->config->get('config_mail_smtp_port');
		} else {
			$data['config_mail_smtp_port'] = 25;
		}

		if (isset($this->request->post['config_mail_smtp_timeout'])) {
			$data['config_mail_smtp_timeout'] = $this->request->post['config_mail_smtp_timeout'];
		} elseif ($this->config->has('config_mail_smtp_timeout')) {
			$data['config_mail_smtp_timeout'] = $this->config->get('config_mail_smtp_timeout');
		} else {
			$data['config_mail_smtp_timeout'] = 5;
		}

		if (isset($this->request->post['config_mail_alert'])) {
			$data['config_mail_alert'] = $this->request->post['config_mail_alert'];
		} elseif ($this->config->has('config_mail_alert')) {
		   	$data['config_mail_alert'] = $this->config->get('config_mail_alert');
		} else {
			$data['config_mail_alert'] = array();
		}

		$data['mail_alerts'] = array();

		$data['mail_alerts'][] = array(
			'text'  => $this->language->get('text_mail_account'),
			'value' => 'account'
		);

		$data['mail_alerts'][] = array(
			'text'  => $this->language->get('text_mail_affiliate'),
			'value' => 'affiliate'
		);

		$data['mail_alerts'][] = array(
			'text'  => $this->language->get('text_mail_order'),
			'value' => 'order'
		);

		$data['mail_alerts'][] = array(
			'text'  => $this->language->get('text_mail_review'),
			'value' => 'review'
		);

		if (isset($this->request->post['config_mail_alert_email'])) {
			$data['config_mail_alert_email'] = $this->request->post['config_mail_alert_email'];
		} else {
			$data['config_mail_alert_email'] = $this->config->get('config_mail_alert_email');
		}

		if (isset($this->request->post['config_secure'])) {
			$data['config_secure'] = $this->request->post['config_secure'];
		} else {
			$data['config_secure'] = $this->config->get('config_secure');
		}

		if (isset($this->request->post['config_shared'])) {
			$data['config_shared'] = $this->request->post['config_shared'];
		} else {
			$data['config_shared'] = $this->config->get('config_shared');
		}

		if (isset($this->request->post['config_robots'])) {
			$data['config_robots'] = $this->request->post['config_robots'];
		} else {
			$data['config_robots'] = $this->config->get('config_robots');
		}

		if (isset($this->request->post['config_seo_url'])) {
			$data['config_seo_url'] = $this->request->post['config_seo_url'];
		} else {
			$data['config_seo_url'] = $this->config->get('config_seo_url');
		}

		if (isset($this->request->post['config_file_max_size'])) {
			$data['config_file_max_size'] = $this->request->post['config_file_max_size'];
		} elseif ($this->config->get('config_file_max_size')) {
			$data['config_file_max_size'] = $this->config->get('config_file_max_size');
		} else {
			$data['config_file_max_size'] = 300000;
		}

		if (isset($this->request->post['config_file_ext_allowed'])) {
			$data['config_file_ext_allowed'] = $this->request->post['config_file_ext_allowed'];
		} else {
			$data['config_file_ext_allowed'] = $this->config->get('config_file_ext_allowed');
		}

		if (isset($this->request->post['config_file_mime_allowed'])) {
			$data['config_file_mime_allowed'] = $this->request->post['config_file_mime_allowed'];
		} else {
			$data['config_file_mime_allowed'] = $this->config->get('config_file_mime_allowed');
		}

		if (isset($this->request->post['config_maintenance'])) {
			$data['config_maintenance'] = $this->request->post['config_maintenance'];
		} else {
			$data['config_maintenance'] = $this->config->get('config_maintenance');
		}

		if (isset($this->request->post['config_password'])) {
			$data['config_password'] = $this->request->post['config_password'];
		} else {
			$data['config_password'] = $this->config->get('config_password');
		}

		if (isset($this->request->post['config_encryption'])) {
			$data['config_encryption'] = $this->request->post['config_encryption'];
		} else {
			$data['config_encryption'] = $this->config->get('config_encryption');
		}

		if (isset($this->request->post['config_compression'])) {
			$data['config_compression'] = $this->request->post['config_compression'];
		} else {
			$data['config_compression'] = $this->config->get('config_compression');
		}

		if (isset($this->request->post['config_error_display'])) {
			$data['config_error_display'] = $this->request->post['config_error_display'];
		} else {
			$data['config_error_display'] = $this->config->get('config_error_display');
		}

		if (isset($this->request->post['config_error_log'])) {
			$data['config_error_log'] = $this->request->post['config_error_log'];
		} else {
			$data['config_error_log'] = $this->config->get('config_error_log');
		}

		if (isset($this->request->post['config_error_filename'])) {
			$data['config_error_filename'] = $this->request->post['config_error_filename'];
		} else {
			$data['config_error_filename'] = $this->config->get('config_error_filename');
		}

/* Additional Setting Fields */

		if (isset($this->request->post['config_catalog_limit'])) {
			$data['config_catalog_limit'] = $this->request->post['config_catalog_limit'];
		} else {
			$data['config_catalog_limit'] = $this->config->get('config_catalog_limit');
		}
		if (isset($this->request->post['config_customer_approval'])) {
			$data['config_customer_approval'] = $this->request->post['config_customer_approval'];
		} else {
			$data['config_customer_approval'] = $this->config->get('config_customer_approval');
		}
		if (isset($this->request->post['config_download'])) {
			$data['config_download'] = $this->request->post['config_download'];
		} else {
			$data['config_download'] = $this->config->get('config_download');
		}
		if (isset($this->request->post['pricelimit_one'])) {
			$data['pricelimit_one'] = $this->request->post['pricelimit_one'];
		} else {
			$data['pricelimit_one'] = $this->config->get('pricelimit_one');
		}

		if (isset($this->request->post['pricelimit_two'])) {
			$data['pricelimit_two'] = $this->request->post['pricelimit_two'];
		} else {
			$data['pricelimit_two'] = $this->config->get('pricelimit_two');
		}

		if (isset($this->request->post['pricelimit_three'])) {
			$data['pricelimit_three'] = $this->request->post['pricelimit_three'];
		} else {
			$data['pricelimit_three'] = $this->config->get('pricelimit_three');
		}

		if (isset($this->request->post['pricelimit_four'])) {
			$data['pricelimit_four'] = $this->request->post['pricelimit_four'];
		} else {
			$data['pricelimit_four'] = $this->config->get('pricelimit_four');
		}

		if (isset($this->request->post['pricelimit_five'])) {
			$data['pricelimit_five'] = $this->request->post['pricelimit_five'];
		} else {
			$data['pricelimit_five'] = $this->config->get('pricelimit_five');
		}

		if (isset($this->request->post['additionalcost_one'])) {
			$data['additionalcost_one'] = $this->request->post['additionalcost_one'];
		} else {
			$data['additionalcost_one'] = $this->config->get('additionalcost_one');
		}

		if (isset($this->request->post['additionalcost_two'])) {
			$data['additionalcost_two'] = $this->request->post['additionalcost_two'];
		} else {
			$data['additionalcost_two'] = $this->config->get('additionalcost_two');
		}

		if (isset($this->request->post['additionalcost_three'])) {
			$data['additionalcost_three'] = $this->request->post['additionalcost_three'];
		} else {
			$data['additionalcost_three'] = $this->config->get('additionalcost_three');
		}

		if (isset($this->request->post['additionalcost_four'])) {
			$data['additionalcost_four'] = $this->request->post['additionalcost_four'];
		} else {
			$data['additionalcost_four'] = $this->config->get('additionalcost_four');
		}

		if (isset($this->request->post['additionalcost_five'])) {
			$data['additionalcost_five'] = $this->request->post['additionalcost_five'];
		} else {
			$data['additionalcost_five'] = $this->config->get('additionalcost_five');
		}

		if (isset($this->request->post['overriding_one'])) {
			$data['overriding_one'] = $this->request->post['overriding_one'];
		} else {
			$data['overriding_one'] = $this->config->get('overriding_one');
		}

		if (isset($this->request->post['overriding_two'])) {
			$data['overriding_two'] = $this->request->post['overriding_two'];
		} else {
			$data['overriding_two'] = $this->config->get('overriding_two');
		}

		if (isset($this->request->post['overriding_three'])) {
			$data['overriding_three'] = $this->request->post['overriding_three'];
		} else {
			$data['overriding_three'] = $this->config->get('overriding_three');
		}

		if (isset($this->request->post['overriding_four'])) {
			$data['overriding_four'] = $this->request->post['overriding_four'];
		} else {
			$data['overriding_four'] = $this->config->get('overriding_four');
		}

		if (isset($this->request->post['overriding_five'])) {
			$data['overriding_five'] = $this->request->post['overriding_five'];
		} else {
			$data['overriding_five'] = $this->config->get('overriding_five');
		}


		if (isset($this->request->post['wholeoverriding_one'])) {
			$data['wholeoverriding_one'] = $this->request->post['wholeoverriding_one'];
		} else {
			$data['wholeoverriding_one'] = $this->config->get('wholeoverriding_one');
		}

		if (isset($this->request->post['wholeoverriding_two'])) {
			$data['wholeoverriding_two'] = $this->request->post['wholeoverriding_two'];
		} else {
			$data['wholeoverriding_two'] = $this->config->get('wholeoverriding_two');
		}

		if (isset($this->request->post['wholeoverriding_three'])) {
			$data['wholeoverriding_three'] = $this->request->post['wholeoverriding_three'];
		} else {
			$data['wholeoverriding_three'] = $this->config->get('wholeoverriding_three');
		}

		if (isset($this->request->post['wholeoverriding_four'])) {
			$data['wholeoverriding_four'] = $this->request->post['wholeoverriding_four'];
		} else {
			$data['wholeoverriding_four'] = $this->config->get('wholeoverriding_four');
		}

		if (isset($this->request->post['wholeoverriding_five'])) {
			$data['wholeoverriding_five'] = $this->request->post['wholeoverriding_five'];
		} else {
			$data['wholeoverriding_five'] = $this->config->get('wholeoverriding_five');
		}


		if (isset($this->request->post['wholemarkup_one'])) {
			$data['wholemarkup_one'] = $this->request->post['wholemarkup_one'];
		} else {
			$data['wholemarkup_one'] = $this->config->get('wholemarkup_one');
		}

		if (isset($this->request->post['wholemarkup_two'])) {
			$data['wholemarkup_two'] = $this->request->post['wholemarkup_two'];
		} else {
			$data['wholemarkup_two'] = $this->config->get('wholemarkup_two');
		}

		if (isset($this->request->post['wholemarkup_three'])) {
			$data['wholemarkup_three'] = $this->request->post['wholemarkup_three'];
		} else {
			$data['wholemarkup_three'] = $this->config->get('wholemarkup_three');
		}

		if (isset($this->request->post['wholemarkup_four'])) {
			$data['wholemarkup_four'] = $this->request->post['wholemarkup_four'];
		} else {
			$data['wholemarkup_four'] = $this->config->get('wholemarkup_four');
		}

		if (isset($this->request->post['wholemarkup_five'])) {
			$data['wholemarkup_five'] = $this->request->post['wholemarkup_five'];
		} else {
			$data['wholemarkup_five'] = $this->config->get('wholemarkup_five');
		}

		if (isset($this->request->post['additionalCosts'])) {
			$data['additionalCosts'] = $this->request->post['additionalCosts'];
		} else {
			$data['additionalCosts'] = $this->config->get('additionalCosts');
		}
		// Diamond New Fields
		if (isset($this->request->post['overriding_markup_diamond_percentage'])) {
			$data['overriding_markup_diamond_percentage'] = $this->request->post['overriding_markup_diamond_percentage'];
		} else {
			$data['overriding_markup_diamond_percentage'] = $this->config->get('overriding_markup_diamond_percentage');
		}
		if (isset($this->request->post['additionalDiamondCosts'])) {
			$data['additionalDiamondCosts'] = $this->request->post['additionalDiamondCosts'];
		} else {
			$data['additionalDiamondCosts'] = $this->config->get('additionalDiamondCosts');
		}

		if (isset($this->request->post['pricelimit_1'])) {
			$data['pricelimit_1'] = $this->request->post['pricelimit_1'];
		} else {
			$data['pricelimit_1'] = $this->config->get('pricelimit_1');
		}

		if (isset($this->request->post['pricelimit_2'])) {
			$data['pricelimit_2'] = $this->request->post['pricelimit_2'];
		} else {
			$data['pricelimit_2'] = $this->config->get('pricelimit_2');
		}

		if (isset($this->request->post['pricelimit_3'])) {
			$data['pricelimit_3'] = $this->request->post['pricelimit_3'];
		} else {
			$data['pricelimit_3'] = $this->config->get('pricelimit_3');
		}

		if (isset($this->request->post['pricelimit_4'])) {
			$data['pricelimit_4'] = $this->request->post['pricelimit_4'];
		} else {
			$data['pricelimit_4'] = $this->config->get('pricelimit_4');
		}

		if (isset($this->request->post['pricelimit_5'])) {
			$data['pricelimit_5'] = $this->request->post['pricelimit_5'];
		} else {
			$data['pricelimit_5'] = $this->config->get('pricelimit_5');
		}
		if (isset($this->request->post['pricelimit_6'])) {
			$data['pricelimit_6'] = $this->request->post['pricelimit_6'];
		} else {
			$data['pricelimit_6'] = $this->config->get('pricelimit_6');
		}

		if (isset($this->request->post['pricelimit_7'])) {
			$data['pricelimit_7'] = $this->request->post['pricelimit_7'];
		} else {
			$data['pricelimit_7'] = $this->config->get('pricelimit_7');
		}

		if (isset($this->request->post['pricelimit_8'])) {
			$data['pricelimit_8'] = $this->request->post['pricelimit_8'];
		} else {
			$data['pricelimit_8'] = $this->config->get('pricelimit_8');
		}

		if (isset($this->request->post['pricelimit_9'])) {
			$data['pricelimit_9'] = $this->request->post['pricelimit_9'];
		} else {
			$data['pricelimit_9'] = $this->config->get('pricelimit_9');
		}

		if (isset($this->request->post['pricelimit_10'])) {
			$data['pricelimit_10'] = $this->request->post['pricelimit_10'];
		} else {
			$data['pricelimit_10'] = $this->config->get('pricelimit_10');
		}


		if (isset($this->request->post['additionalcost_1'])) {
			$data['additionalcost_1'] = $this->request->post['additionalcost_1'];
		} else {
			$data['additionalcost_1'] = $this->config->get('additionalcost_1');
		}

		if (isset($this->request->post['additionalcost_2'])) {
			$data['additionalcost_2'] = $this->request->post['additionalcost_2'];
		} else {
			$data['additionalcost_2'] = $this->config->get('additionalcost_2');
		}

		if (isset($this->request->post['additionalcost_3'])) {
			$data['additionalcost_3'] = $this->request->post['additionalcost_3'];
		} else {
			$data['additionalcost_3'] = $this->config->get('additionalcost_3');
		}

		if (isset($this->request->post['additionalcost_4'])) {
			$data['additionalcost_4'] = $this->request->post['additionalcost_4'];
		} else {
			$data['additionalcost_4'] = $this->config->get('additionalcost_4');
		}

		if (isset($this->request->post['additionalcost_5'])) {
			$data['additionalcost_5'] = $this->request->post['additionalcost_5'];
		} else {
			$data['additionalcost_5'] = $this->config->get('additionalcost_5');
		}
		if (isset($this->request->post['additionalcost_6'])) {
			$data['additionalcost_6'] = $this->request->post['additionalcost_6'];
		} else {
			$data['additionalcost_6'] = $this->config->get('additionalcost_6');
		}

		if (isset($this->request->post['additionalcost_7'])) {
			$data['additionalcost_7'] = $this->request->post['additionalcost_7'];
		} else {
			$data['additionalcost_7'] = $this->config->get('additionalcost_7');
		}

		if (isset($this->request->post['additionalcost_8'])) {
			$data['additionalcost_8'] = $this->request->post['additionalcost_8'];
		} else {
			$data['additionalcost_8'] = $this->config->get('additionalcost_8');
		}

		if (isset($this->request->post['additionalcost_9'])) {
			$data['additionalcost_9'] = $this->request->post['additionalcost_9'];
		} else {
			$data['additionalcost_9'] = $this->config->get('additionalcost_9');
		}

		if (isset($this->request->post['additionalcost_10'])) {
			$data['additionalcost_10'] = $this->request->post['additionalcost_10'];
		} else {
			$data['additionalcost_10'] = $this->config->get('additionalcost_10');
		}



		if (isset($this->request->post['additionalcostpercent_1'])) {
			$data['additionalcostpercent_1'] = $this->request->post['additionalcostpercent_1'];
		} else {
			$data['additionalcostpercent_1'] = $this->config->get('additionalcostpercent_1');
		}

		if (isset($this->request->post['additionalcostpercent_2'])) {
			$data['additionalcostpercent_2'] = $this->request->post['additionalcostpercent_2'];
		} else {
			$data['additionalcostpercent_2'] = $this->config->get('additionalcostpercent_2');
		}

		if (isset($this->request->post['additionalcostpercent_3'])) {
			$data['additionalcostpercent_3'] = $this->request->post['additionalcostpercent_3'];
		} else {
			$data['additionalcostpercent_3'] = $this->config->get('additionalcostpercent_3');
		}

		if (isset($this->request->post['additionalcostpercent_4'])) {
			$data['additionalcostpercent_4'] = $this->request->post['additionalcostpercent_4'];
		} else {
			$data['additionalcostpercent_4'] = $this->config->get('additionalcostpercent_4');
		}

		if (isset($this->request->post['additionalcostpercent_5'])) {
			$data['additionalcostpercent_5'] = $this->request->post['additionalcostpercent_5'];
		} else {
			$data['additionalcostpercent_5'] = $this->config->get('additionalcostpercent_5');
		}
		if (isset($this->request->post['additionalcostpercent_6'])) {
			$data['additionalcostpercent_6'] = $this->request->post['additionalcostpercent_6'];
		} else {
			$data['additionalcostpercent_6'] = $this->config->get('additionalcostpercent_6');
		}

		if (isset($this->request->post['additionalcostpercent_7'])) {
			$data['additionalcostpercent_7'] = $this->request->post['additionalcostpercent_7'];
		} else {
			$data['additionalcostpercent_7'] = $this->config->get('additionalcostpercent_7');
		}

		if (isset($this->request->post['additionalcostpercent_8'])) {
			$data['additionalcostpercent_8'] = $this->request->post['additionalcostpercent_8'];
		} else {
			$data['additionalcostpercent_8'] = $this->config->get('additionalcostpercent_8');
		}

		if (isset($this->request->post['additionalcostpercent_9'])) {
			$data['additionalcostpercent_9'] = $this->request->post['additionalcostpercent_9'];
		} else {
			$data['additionalcostpercent_9'] = $this->config->get('additionalcostpercent_9');
		}

		if (isset($this->request->post['additionalcostpercent_10'])) {
			$data['additionalcostpercent_10'] = $this->request->post['additionalcostpercent_10'];
		} else {
			$data['additionalcostpercent_10'] = $this->config->get('additionalcostpercent_10');
		}


		if (isset($this->request->post['overriding_1'])) {
			$data['overriding_1'] = $this->request->post['overriding_1'];
		} else {
			$data['overriding_1'] = $this->config->get('overriding_1');
		}

		if (isset($this->request->post['overriding_2'])) {
			$data['overriding_2'] = $this->request->post['overriding_2'];
		} else {
			$data['overriding_2'] = $this->config->get('overriding_2');
		}

		if (isset($this->request->post['overriding_3'])) {
			$data['overriding_3'] = $this->request->post['overriding_3'];
		} else {
			$data['overriding_3'] = $this->config->get('overriding_3');
		}

		if (isset($this->request->post['overriding_4'])) {
			$data['overriding_4'] = $this->request->post['overriding_4'];
		} else {
			$data['overriding_4'] = $this->config->get('overriding_4');
		}

		if (isset($this->request->post['overriding_5'])) {
			$data['overriding_5'] = $this->request->post['overriding_5'];
		} else {
			$data['overriding_5'] = $this->config->get('overriding_5');
		}
		if (isset($this->request->post['overriding_6'])) {
			$data['overriding_6'] = $this->request->post['overriding_6'];
		} else {
			$data['overriding_6'] = $this->config->get('overriding_6');
		}

		if (isset($this->request->post['overriding_7'])) {
			$data['overriding_7'] = $this->request->post['overriding_7'];
		} else {
			$data['overriding_7'] = $this->config->get('overriding_7');
		}

		if (isset($this->request->post['overriding_8'])) {
			$data['overriding_8'] = $this->request->post['overriding_8'];
		} else {
			$data['overriding_8'] = $this->config->get('overriding_8');
		}

		if (isset($this->request->post['overriding_9'])) {
			$data['overriding_9'] = $this->request->post['overriding_9'];
		} else {
			$data['overriding_9'] = $this->config->get('overriding_9');
		}

		if (isset($this->request->post['overriding_10'])) {
			$data['overriding_10'] = $this->request->post['overriding_10'];
		} else {
			$data['overriding_10'] = $this->config->get('overriding_10');
		}


		if (isset($this->request->post['wholeoverriding_1'])) {
			$data['wholeoverriding_1'] = $this->request->post['wholeoverriding_1'];
		} else {
			$data['wholeoverriding_1'] = $this->config->get('wholeoverriding_1');
		}

		if (isset($this->request->post['config_wholewholeoverriding_2'])) {
			$data['wholeoverriding_2'] = $this->request->post['wholeoverriding_2'];
		} else {
			$data['wholeoverriding_2'] = $this->config->get('wholeoverriding_2');
		}

		if (isset($this->request->post['wholeoverriding_3'])) {
			$data['wholeoverriding_3'] = $this->request->post['wholeoverriding_3'];
		} else {
			$data['wholeoverriding_3'] = $this->config->get('wholeoverriding_3');
		}

		if (isset($this->request->post['wholeoverriding_4'])) {
			$data['wholeoverriding_4'] = $this->request->post['wholeoverriding_4'];
		} else {
			$data['wholeoverriding_4'] = $this->config->get('wholeoverriding_4');
		}

		if (isset($this->request->post['wholeoverriding_5'])) {
			$data['wholeoverriding_5'] = $this->request->post['wholeoverriding_5'];
		} else {
			$data['wholeoverriding_5'] = $this->config->get('wholeoverriding_5');
		}
		if (isset($this->request->post['wholeoverriding_6'])) {
			$data['wholeoverriding_6'] = $this->request->post['wholeoverriding_6'];
		} else {
			$data['wholeoverriding_6'] = $this->config->get('wholeoverriding_6');
		}

		if (isset($this->request->post['wholeoverriding_7'])) {
			$data['wholeoverriding_7'] = $this->request->post['wholeoverriding_7'];
		} else {
			$data['wholeoverriding_7'] = $this->config->get('wholeoverriding_7');
		}

		if (isset($this->request->post['wholeoverriding_8'])) {
			$data['wholeoverriding_8'] = $this->request->post['wholeoverriding_8'];
		} else {
			$data['wholeoverriding_8'] = $this->config->get('wholeoverriding_8');
		}

		if (isset($this->request->post['wholeoverriding_9'])) {
			$data['wholeoverriding_9'] = $this->request->post['wholeoverriding_9'];
		} else {
			$data['wholeoverriding_9'] = $this->config->get('wholeoverriding_9');
		}

		if (isset($this->request->post['wholeoverriding_10'])) {
			$data['wholeoverriding_10'] = $this->request->post['wholeoverriding_10'];
		} else {
			$data['wholeoverriding_10'] = $this->config->get('wholeoverriding_10');
		}


		if (isset($this->request->post['pricelimit_11'])) {
			$data['pricelimit_11'] = $this->request->post['pricelimit_11'];
		} else {
			$data['pricelimit_11'] = $this->config->get('pricelimit_11');
		}

		if (isset($this->request->post['pricelimit_12'])) {
			$data['pricelimit_12'] = $this->request->post['pricelimit_12'];
		} else {
			$data['pricelimit_12'] = $this->config->get('pricelimit_12');
		}

		if (isset($this->request->post['pricelimit_13'])) {
			$data['pricelimit_13'] = $this->request->post['pricelimit_13'];
		} else {
			$data['pricelimit_13'] = $this->config->get('pricelimit_13');
		}

		if (isset($this->request->post['pricelimit_14'])) {
			$data['pricelimit_14'] = $this->request->post['pricelimit_14'];
		} else {
			$data['pricelimit_14'] = $this->config->get('pricelimit_14');
		}

		if (isset($this->request->post['additionalcost_11'])) {
			$data['additionalcost_11'] = $this->request->post['additionalcost_11'];
		} else {
			$data['additionalcost_11'] = $this->config->get('additionalcost_11');
		}

		if (isset($this->request->post['additionalcost_12'])) {
			$data['additionalcost_12'] = $this->request->post['additionalcost_12'];
		} else {
			$data['additionalcost_12'] = $this->config->get('additionalcost_12');
		}

		if (isset($this->request->post['additionalcost_13'])) {
			$data['additionalcost_13'] = $this->request->post['additionalcost_13'];
		} else {
			$data['additionalcost_13'] = $this->config->get('additionalcost_13');
		}

		if (isset($this->request->post['additionalcost_14'])) {
			$data['additionalcost_14'] = $this->request->post['additionalcost_14'];
		} else {
			$data['additionalcost_14'] = $this->config->get('additionalcost_14');
		}

		if (isset($this->request->post['additionalcostpercent_11'])) {
			$data['additionalcostpercent_11'] = $this->request->post['additionalcostpercent_11'];
		} else {
			$data['additionalcostpercent_11'] = $this->config->get('additionalcostpercent_11');
		}

		if (isset($this->request->post['additionalcostpercent_12'])) {
			$data['additionalcostpercent_12'] = $this->request->post['additionalcostpercent_12'];
		} else {
			$data['additionalcostpercent_12'] = $this->config->get('additionalcostpercent_12');
		}

		if (isset($this->request->post['additionalcostpercent_13'])) {
			$data['additionalcostpercent_13'] = $this->request->post['additionalcostpercent_13'];
		} else {
			$data['additionalcostpercent_13'] = $this->config->get('additionalcostpercent_13');
		}

		if (isset($this->request->post['additionalcostpercent_14'])) {
			$data['additionalcostpercent_14'] = $this->request->post['additionalcostpercent_14'];
		} else {
			$data['additionalcostpercent_14'] = $this->config->get('additionalcostpercent_14');
		}


		if (isset($this->request->post['overriding_11'])) {
			$data['overriding_11'] = $this->request->post['overriding_11'];
		} else {
			$data['overriding_11'] = $this->config->get('overriding_11');
		}

		if (isset($this->request->post['overriding_12'])) {
			$data['overriding_12'] = $this->request->post['overriding_12'];
		} else {
			$data['overriding_12'] = $this->config->get('overriding_12');
		}

		if (isset($this->request->post['overriding_13'])) {
			$data['overriding_13'] = $this->request->post['overriding_13'];
		} else {
			$data['overriding_13'] = $this->config->get('overriding_13');
		}

		if (isset($this->request->post['overriding_14'])) {
			$data['overriding_14'] = $this->request->post['overriding_14'];
		} else {
			$data['overriding_14'] = $this->config->get('overriding_14');
		}
		if (isset($this->request->post['wholeoverriding_11'])) {
			$data['wholeoverriding_11'] = $this->request->post['wholeoverriding_11'];
		} else {
			$data['wholeoverriding_11'] = $this->config->get('wholeoverriding_11');
		}

		if (isset($this->request->post['wholeoverriding_12'])) {
			$data['wholeoverriding_12'] = $this->request->post['wholeoverriding_12'];
		} else {
			$data['wholeoverriding_12'] = $this->config->get('wholeoverriding_12');
		}

		if (isset($this->request->post['wholeoverriding_13'])) {
			$data['wholeoverriding_13'] = $this->request->post['wholeoverriding_13'];
		} else {
			$data['wholeoverriding_13'] = $this->config->get('wholeoverriding_13');
		}

		if (isset($this->request->post['wholeoverriding_14'])) {
			$data['wholeoverriding_14'] = $this->request->post['wholeoverriding_14'];
		} else {
			$data['wholeoverriding_14'] = $this->config->get('wholeoverriding_14');
		}

		if (isset($this->request->post['rapneturl'])) {
			$data['rapneturl'] = $this->request->post['rapneturl'];
		} else {
			$data['rapneturl'] = $this->config->get('rapneturl');
		}
		if (isset($this->request->post['designer_reward_sale_based'])) {
			$data['designer_reward_sale_based'] = $this->request->post['designer_reward_sale_based'];
		} else {
			$data['designer_reward_sale_based'] = $this->config->get('designer_reward_sale_based');
		}
		if (isset($this->request->post['customer_reward_sale_based'])) {
			$data['customer_reward_sale_based'] = $this->request->post['customer_reward_sale_based'];
		} else {
			$data['customer_reward_sale_based'] = $this->config->get('customer_reward_sale_based');
		}
		if (isset($this->request->post['group_reward_sale_based'])) {
			$data['group_reward_sale_based'] = $this->request->post['group_reward_sale_based'];
		} else {
			$data['group_reward_sale_based'] = $this->config->get('group_reward_sale_based');
		}

		if (isset($this->request->post['overriding_mark_up_ubsolute'])) {
			$data['overriding_mark_up_ubsolute'] = $this->request->post['overriding_mark_up_ubsolute'];
		} else {
			$data['overriding_mark_up_ubsolute'] = $this->config->get('overriding_mark_up_ubsolute');
		}

		if (isset($this->request->post['overriding_markup_percentage'])) {
			$data['overriding_markup_percentage'] = $this->request->post['overriding_markup_percentage'];
		} else {
			$data['overriding_markup_percentage'] = $this->config->get('overriding_markup_percentage');
		}

		if (isset($this->request->post['config_admin_limit'])) {
			$data['config_admin_limit'] = $this->request->post['config_admin_limit'];
		} else {
			$data['config_admin_limit'] = $this->config->get('config_admin_limit');
		}

		if (isset($this->request->post['config_alert_emails'])) {
			$data['config_alert_emails'] = $this->request->post['config_alert_emails'];
		} else {
			$data['config_alert_emails'] = $this->config->get('config_alert_emails');
		}

		if (isset($this->request->post['config_commission'])) {
			$data['config_commission'] = $this->request->post['config_commission'];
		} else {
			$data['config_commission'] = $this->config->get('config_commission');
		}

		if (isset($this->request->post['config_complete_status_id'])) {
			$data['config_complete_status_id'] = $this->request->post['config_complete_status_id'];
		} else {
			$data['config_complete_status_id'] = $this->config->get('config_complete_status_id');
		}

		if (isset($this->request->post['config_language_id'])) {
			$data['config_language_id'] = $this->request->post['config_language_id'];
		} else {
			$data['config_language_id'] = $this->config->get('config_language_id');
		}

		if (isset($this->request->post['config_smtp_host'])) {
			$data['config_smtp_host'] = $this->request->post['config_smtp_host'];
		} else {
			$data['config_smtp_host'] = $this->config->get('config_smtp_host');
		}

		if (isset($this->request->post['config_smtp_password'])) {
			$data['config_smtp_password'] = $this->request->post['config_smtp_password'];
		} else {
			$data['config_smtp_password'] = $this->config->get('config_smtp_password');
		}

		if (isset($this->request->post['config_smtp_port'])) {
			$data['config_smtp_port'] = $this->request->post['config_smtp_port'];
		} else {
			$data['config_smtp_port'] = $this->config->get('config_smtp_port');
		}

		if (isset($this->request->post['config_smtp_timeout'])) {
			$data['config_smtp_timeout'] = $this->request->post['config_smtp_timeout'];
		} else {
			$data['config_smtp_timeout'] = $this->config->get('config_smtp_timeout');
		}

		if (isset($this->request->post['config_smtp_username'])) {
			$data['config_smtp_username'] = $this->request->post['config_smtp_username'];
		} else {
			$data['config_smtp_username'] = $this->config->get('config_smtp_username');
		}

		if (isset($this->request->post['config_stock_status_id'])) {
			$data['config_stock_status_id'] = $this->request->post['config_stock_status_id'];
		} else {
			$data['config_stock_status_id'] = $this->config->get('config_stock_status_id');
		}

		if (isset($this->request->post['config_upload_allowed'])) {
			$data['config_upload_allowed'] = $this->request->post['config_upload_allowed'];
		} else {
			$data['config_upload_allowed'] = $this->config->get('config_upload_allowed');
		}






		/* Additional Setting Fields END */

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('setting/setting', $data));
	}

	protected function validate() {
		if (!$this->user->hasPermission('modify', 'setting/setting')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		if (!$this->request->post['config_meta_title']) {
			$this->error['meta_title'] = $this->language->get('error_meta_title');
		}

		if (!$this->request->post['config_name']) {
			$this->error['name'] = $this->language->get('error_name');
		}

		if ((utf8_strlen($this->request->post['config_owner']) < 3) || (utf8_strlen($this->request->post['config_owner']) > 64)) {
			$this->error['owner'] = $this->language->get('error_owner');
		}

		if ((utf8_strlen($this->request->post['config_address']) < 3) || (utf8_strlen($this->request->post['config_address']) > 256)) {
			$this->error['address'] = $this->language->get('error_address');
		}

		if ((utf8_strlen($this->request->post['config_email']) > 96) || !filter_var($this->request->post['config_email'], FILTER_VALIDATE_EMAIL)) {
			$this->error['email'] = $this->language->get('error_email');
		}

		if ((utf8_strlen($this->request->post['config_telephone']) < 3) || (utf8_strlen($this->request->post['config_telephone']) > 32)) {
			$this->error['telephone'] = $this->language->get('error_telephone');
		}

		if (!empty($this->request->post['config_customer_group_display']) && !in_array($this->request->post['config_customer_group_id'], $this->request->post['config_customer_group_display'])) {
			$this->error['customer_group_display'] = $this->language->get('error_customer_group_display');
		}

		if (!$this->request->post['config_limit_admin']) {
			$this->error['limit_admin'] = $this->language->get('error_limit');
		}

		if ($this->request->post['config_login_attempts'] < 1) {
			$this->error['login_attempts'] = $this->language->get('error_login_attempts');
		}

		if (!$this->request->post['config_voucher_min']) {
			$this->error['voucher_min'] = $this->language->get('error_voucher_min');
		}

		if (!$this->request->post['config_voucher_max']) {
			$this->error['voucher_max'] = $this->language->get('error_voucher_max');
		}

		if (!isset($this->request->post['config_processing_status'])) {
			$this->error['processing_status'] = $this->language->get('error_processing_status');
		}

		if (!isset($this->request->post['config_complete_status'])) {
			$this->error['complete_status'] = $this->language->get('error_complete_status');
		}

		if (!$this->request->post['config_error_filename']) {
			$this->error['log'] = $this->language->get('error_log_required');
		} elseif (preg_match('/\.\.[\/\\\]?/', $this->request->post['config_error_filename'])) {
			$this->error['log'] = $this->language->get('error_log_invalid');
		} elseif (substr($this->request->post['config_error_filename'], strrpos($this->request->post['config_error_filename'], '.')) != '.log') {
			$this->error['log'] = $this->language->get('error_log_extension');
		}

		if ((utf8_strlen($this->request->post['config_encryption']) < 32) || (utf8_strlen($this->request->post['config_encryption']) > 1024)) {
			$this->error['encryption'] = $this->language->get('error_encryption');
		}

		if ($this->error && !isset($this->error['warning'])) {
			$this->error['warning'] = $this->language->get('error_warning');
		}

		return !$this->error;
	}

	public function theme() {
		if ($this->request->server['HTTPS']) {
			$server = HTTPS_CATALOG;
		} else {
			$server = HTTP_CATALOG;
		}

		// This is only here for compatibility with old themes.
		if ($this->request->get['theme'] == 'theme_default') {
			$theme = $this->config->get('theme_default_directory');
		} else {
			$theme = basename($this->request->get['theme']);
		}

		if (is_file(DIR_CATALOG . 'view/theme/' . $theme . '/image/' . $theme . '.png')) {
			$this->response->setOutput($server . 'catalog/view/theme/' . $theme . '/image/' . $theme . '.png');
		} else {
			$this->response->setOutput($server . 'image/no_image.png');
		}
	}
}
