<?php
class ModelSaleGemstone extends Model {
	public function addgemstone($data) {
		$this->db->query("INSERT INTO " . DB_PREFIX . "gemstone SET gemname = '" . $this->db->escape($data['gemname']) . "', gemdescr = '" . $this->db->escape($data['gemdescr']) . "', gemdetail = '" . $this->db->escape($data['gemdetail']) . "', birthstone = '" . $this->db->escape($data['birthstone']) . "', anniversary = '" . $this->db->escape($data['anniversary']) . "', species = '" . $this->db->escape($data['species']) . "', zodiac = '" . $this->db->escape($data['zodiac']) . "', mohshardness = '" . $this->db->escape($data['mohshardness']) . "', specificgravity = '" . $this->db->escape($data['specificgravity']) . "', refractiveindex = '" . $this->db->escape($data['refractiveindex']) . "', birefringence = '" . $this->db->escape($data['birefringence']) . "', opticsign = '" . $this->db->escape($data['opticsign']) . "', icacode = '" . $this->db->escape($data['icacode']) . "', treatment = '" . $this->db->escape($data['treatment']) . "', incidence = '" . $this->db->escape($data['incidence']) . "', purpose = '" . $this->db->escape($data['purpose']) . "', durability = '" . $this->db->escape($data['durability']) . "', detection = '" . $this->db->escape($data['detection']) . "', specialcare = '" . $this->db->escape($data['specialcare']) . "', limitations = '" . $this->db->escape($data['limitations']) . "', category_display = '" . $this->db->escape($data['category_display']) . "', months = '" . $this->db->escape($data['months']) . "', image1 = '" . $this->db->escape($data['image']) . "', sort_order = '" . $this->db->escape($data['sort_order']) . "'");

		return $this->db->getLastId();
	}

	public function editgemstone($gemstone_id, $data) {
		$this->db->query("UPDATE " . DB_PREFIX . "gemstone SET gemname = '" . $this->db->escape($data['gemname']) . "', gemdescr = '" . $this->db->escape($data['gemdescr']) . "', gemdetail = '" . $this->db->escape($data['gemdetail']) . "', birthstone = '" . $this->db->escape($data['birthstone']) . "', anniversary = '" . $this->db->escape($data['anniversary']) . "', species = '" . $this->db->escape($data['species']) . "', zodiac = '" . $this->db->escape($data['zodiac']) . "', mohshardness = '" . $this->db->escape($data['mohshardness']) . "', specificgravity = '" . $this->db->escape($data['specificgravity']) . "', refractiveindex = '" . $this->db->escape($data['refractiveindex']) . "', birefringence = '" . $this->db->escape($data['birefringence']) . "', opticsign = '" . $this->db->escape($data['opticsign']) . "', icacode = '" . $this->db->escape($data['icacode']) . "', treatment = '" . $this->db->escape($data['treatment']) . "', incidence = '" . $this->db->escape($data['incidence']) . "', purpose = '" . $this->db->escape($data['purpose']) . "', durability = '" . $this->db->escape($data['durability']) . "', detection = '" . $this->db->escape($data['detection']) . "', specialcare = '" . $this->db->escape($data['specialcare']) . "', limitations = '" . $this->db->escape($data['limitations']) . "', category_display = '" . $this->db->escape($data['category_display']) . "', months = '" . $this->db->escape($data['months']) . "', image1 = '" . $this->db->escape($data['image']) . "', sort_order = '" . $this->db->escape($data['sort_order']) . "' WHERE gemstone_id = '" . (int)$gemstone_id . "'");
	}

	public function deletegemstone($gemstone_id) {
		$this->db->query("DELETE FROM " . DB_PREFIX . "gemstone WHERE gemstone_id = " . (int)$gemstone_id);
	}

	public function getgemstone($gemstone_id) {
		$query = $this->db->query("SELECT DISTINCT * FROM " . DB_PREFIX . "gemstone WHERE gemstone_id = '" . (int)$gemstone_id . "'");

		return $query->row;
	}

	public function getSizebyName($data = array()) {
		$sql = "SELECT size_id,size_code FROM " . DB_PREFIX . "size";

		$sql .= " ORDER BY size_code";

		if (isset($data['order']) && ($data['order'] == 'DESC')) {
			$sql .= " DESC";
		} else {
			$sql .= " ASC";
		}

		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}

		$query = $this->db->query($sql);

		return $query->rows;
	}

	public function getgemstones($data = array()) {
		$sql = "SELECT gemstone_id, gemname, gemcode FROM " . DB_PREFIX . "gemstone";

		$sort_data = array(
			'gemname',
			'gemcode',
		);

		if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
			$sql .= " ORDER BY " . $data['sort'];
		} else {
			$sql .= " ORDER BY gemname";
		}

		if (isset($data['order']) && ($data['order'] == 'DESC')) {
			$sql .= " DESC";
		} else {
			$sql .= " ASC";
		}

		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}

		$query = $this->db->query($sql);

		return $query->rows;
	}

	public function getTotalgemstones() {
		$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "gemstone");

		return $query->row['total'];
	}
}
