<?php
class ModelSaleRapnet extends Model {
	public function addgemprice($data) {
		$this->db->query("INSERT INTO " . DB_PREFIX . "gemstone_price SET price = '" . $this->db->escape($data['price']) . "',pricetype = '" . $this->db->escape($data['pricetype']) . "',shape = '" . $this->db->escape($data['shape']) . "',ccurrency = '" . $this->db->escape($data['ccurrency']) . "', highclarity = '" . $this->db->escape($data['highclarity']) . "',lowclarity = '" . $this->db->escape($data['lowclarity']) . "',lowweight = '" . $this->db->escape($data['lowweight']) . "',highweight = '" . $this->db->escape($data['highweight']) . "', lowcolour = '" . $this->db->escape($data['lowcolour']) . "', gemstone_id = '" . $this->db->escape($data['gemstone_id']) . "'");
	
		return $this->db->getLastId();
	}

	public function editgemprice($gemstoneprice_id, $data) {
		$this->db->query("UPDATE " . DB_PREFIX . "gemstone_price SET price = '" . $this->db->escape($data['price']) . "',pricetype = '" . $this->db->escape($data['pricetype']) . "',shape = '" . $this->db->escape($data['shape']) . "',ccurrency = '" . $this->db->escape($data['ccurrency']) . "', highclarity = '" . $this->db->escape($data['lowclarity']) . "',highclarity = '" . $this->db->escape($data['lowclarity']) . "', lowweight = '" . $this->db->escape($data['lowweight']) . "',highweight = '" . $this->db->escape($data['highweight']) . "', lowcolour = '" . $this->db->escape($data['lowcolour']) . "', gemstone_id = '" . $this->db->escape($data['gemstone_id']) . "' WHERE gemstoneprice_id = '" . (int)$gemstoneprice_id . "'");
	}

	public function deletegemprice($gemstoneprice_id) {
		$this->db->query("DELETE FROM " . DB_PREFIX . "gemstone_price WHERE gemstoneprice_id = " . (int)$gemstoneprice_id);
	}

	public function getgemprice($gemstoneprice_id) {
		$query = $this->db->query("SELECT DISTINCT * FROM " . DB_PREFIX . "gemstone_price WHERE gemstoneprice_id = '" . (int)$gemstoneprice_id . "'");

		return $query->row;
	}

	public function getgemprices($data = array()) {
		$sql = "SELECT gemstoneprice_id,gemstone_id,(select gs.gemname from gemstone gs where gs.gemstone_id = gp.gemstone_id) as gemname, pricetype, price,lowweight,highweight,lowclarity FROM " . DB_PREFIX . "gemstone_price gp";

		$sort_data = array(
			'gemstoneprice_id',
			'gemstone_id',
			'lowclarity',
			'pricetype',
			'lowweight',
			'highweight',
		);

		if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
			$sql .= " ORDER BY " . $data['sort'];
		} else {
			$sql .= " ORDER BY gemname";
		}

		if (isset($data['order']) && ($data['order'] == 'DESC')) {
			$sql .= " DESC";
		} else {
			$sql .= " ASC";
		}

		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}

		$query = $this->db->query($sql);

		return $query->rows;
	}

	public function getTotalgemprices() {
		$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "gemstone_price");

		return $query->row['total'];
	}
}
