<?php
class ControllerProductProduct extends Controller {
	private $error = array();

	// Retrofitted Newer Version
	public function index() {

		if (isset($this->request->get['product_id'])) {
			$product_id = $this->request->get['product_id'];
		} else {
			$product_id = 0;
		}

		if (file_exists(DIR_VIDEO . $product_id . ".mp4" )) {
			$data['productVideo'] = $product_id . ".mp4";
		} else {
			$data['productVideo'] = "";
		}

		$this->session->data['diamondselected'] = 0;
    	$data['currencyLeftSymbol'] = $this->currency->getSymbolLeft($this->session->data['currency']);
		$data['currencyLeftSymbolLength'] = strlen($data['currencyLeftSymbol']);

		$this->load->model('catalog/product');
		$this->load->model('information/myown');


		$product_info = $this->model_catalog_product->getProduct($product_id);
		if($product_info['type']>0){
			// $this->redirect($this->url->link('product/product', $url . '&product_id=' . $product_id));
		}
		$data['isRing']=$this->model_catalog_product->isRing($product_id);
    	$data['ringsizes'] = $this->model_information_myown->getRingsizes();
		$data['HTTP_IMAGE'] = HTTP_IMAGE;
		$data['HTTPS_IMAGE'] = HTTPS_IMAGE;


		$data['customer_id'] =  $this->customer->getId() ;
		if ($this->customer->isLogged()) {
			$data['customer_group_id'] = $this->customer->getCustomerGroupId();
		} else {
			$data['customer_group_id'] = $this->config->get('config_customer_group_id');
		}


		$data['stockists'] = $this->model_catalog_product->getStockists();

		$this->load->language('product/product');

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/home')
		);

		$this->load->model('catalog/category');

		/* Select123 Coding Here to reset back link - Starts */
				$backSettingurl = '';
				$backSettingurl = $backSettingurl . "&gemstone_id=9";
				if( isset($this->request->get['shape_id']) ) {
						$backSettingurl = $backSettingurl . "&shape_id=" . $this->request->get['shape_id'];
				}
				if( isset($this->request->get['rno']) ) {
						$backSettingurl = $backSettingurl . "&rno=" . $this->request->get['rno'];
				}
				if( isset($this->session->data['Ring_Setting_pid']) ) {
						$data['removeSettingLink'] = "collections/wolf-and-stone-engagement-collection" . $backSettingurl ;
				}
				if( isset($this->session->data['Earrings_Setting_pid']) ) {
						$data['removeSettingLink'] = "create-your-own/necklace" . $backSettingurl ;
				}
		/* Select123 Coding Here - Starts */


		//  Affiliate System -- Add on Starts Here

		if($this->config->get('config_affiliatepoints'))
		{
			if(isset($this->request->get['tracking']))
			{
				$this->load->model('affiliate/affiliate');
				$this->session->data['referral_code'] = $this->request->get['tracking'];
				$affiliate_id=$this->model_affiliate_affiliate->getAffiliateId($this->session->data['referral_code']);
				if($affiliate_id){
					$this->session->data['referral_id'] = $affiliate_id;
					$this->model_affiliate_affiliate->AddUrlCount($affiliate_id);
					$data['mybanner'] = $this->model_affiliate_affiliate->getBannerURL($affiliate_id);
					if(strpos($data['mybanner'],'home')===false){
						//$this->redirect($data['mybanner']);
					}
				}
			}
		}
		//  Affiliate System -- Add on Ends   Here
		$categoryname='';
		if (isset($this->request->get['path'])) {
			$path = '';

			$parts = explode('_', (string)$this->request->get['path']);

			$category_id = (int)array_pop($parts);

			foreach ($parts as $path_id) {
				if (!$path) {
					$path = $path_id;
				} else {
					$path .= '_' . $path_id;
				}

				$category_info = $this->model_catalog_category->getCategory($path_id);
				$categoryname = $category_info['name'];
				if ($category_info) {
					$data['breadcrumbs'][] = array(
						'text' => $category_info['name'],
						'href' => $this->url->link('product/category', 'path=' . $path)
					);
				}
			}

			// Set the last category breadcrumb
			$category_info = $this->model_catalog_category->getCategory($category_id);

			if ($category_info) {
				$url = '';

				if (isset($this->request->get['sort'])) {
					$url .= '&sort=' . $this->request->get['sort'];
				}

				if (isset($this->request->get['order'])) {
					$url .= '&order=' . $this->request->get['order'];
				}

				if (isset($this->request->get['page'])) {
					$url .= '&page=' . $this->request->get['page'];
				}

				if (isset($this->request->get['limit'])) {
					$url .= '&limit=' . $this->request->get['limit'];
				}

				$data['breadcrumbs'][] = array(
					'text' => $category_info['name'],
					'href' => $this->url->link('product/category', 'path=' . $this->request->get['path'] . $url)
				);
			}
		}


// tab section code starts
		$this->load->model('catalog/category');

		$data['newdetailinformation1'] = array();
		$data['newdetailinformation1'] = html_entity_decode($this->model_catalog_category->getnewdetailinformation1());

		$data['newdetailinformation2'] = array();
		$data['newdetailinformation2'] = html_entity_decode($this->model_catalog_category->getnewdetailinformation2());

		$data['newdetailinformation3'] = array();
		$data['newdetailinformation3'] = 	html_entity_decode($this->model_catalog_category->getnewdetailinformation3());

	// tab section code ends

		$this->load->model('catalog/manufacturer');

		if (isset($this->request->get['manufacturer_id'])) {
			$data['breadcrumbs'][] = array(
				'text' => $this->language->get('text_brand'),
				'href' => $this->url->link('product/manufacturer')
			);

			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			if (isset($this->request->get['limit'])) {
				$url .= '&limit=' . $this->request->get['limit'];
			}

			$manufacturer_info = $this->model_catalog_manufacturer->getManufacturer($this->request->get['manufacturer_id']);

			if ($manufacturer_info) {
				$data['breadcrumbs'][] = array(
					'text' => $manufacturer_info['name'],
					'href' => $this->url->link('product/manufacturer/info', 'manufacturer_id=' . $this->request->get['manufacturer_id'] . $url)
				);
			}
		}

		if (isset($this->request->get['search']) || isset($this->request->get['tag'])) {
			$url = '';

			if (isset($this->request->get['search'])) {
				$url .= '&search=' . $this->request->get['search'];
			}

			if (isset($this->request->get['tag'])) {
				$url .= '&tag=' . $this->request->get['tag'];
			}

			if (isset($this->request->get['description'])) {
				$url .= '&description=' . $this->request->get['description'];
			}

			if (isset($this->request->get['category_id'])) {
				$url .= '&category_id=' . $this->request->get['category_id'];
			}

			if (isset($this->request->get['sub_category'])) {
				$url .= '&sub_category=' . $this->request->get['sub_category'];
			}

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			if (isset($this->request->get['limit'])) {
				$url .= '&limit=' . $this->request->get['limit'];
			}

			$data['breadcrumbs'][] = array(
				'text' => $this->language->get('text_search'),
				'href' => $this->url->link('product/search', $url)
			);
		}

		if (isset($this->request->get['product_id'])) {
			$product_id = (int)$this->request->get['product_id'];
		} else {
			$product_id = 0;
		}

		$data['product_info'] = $product_info;
		$data['product_type'] = $product_info['type'];

		$DefaultMetal1Name='';
		$DefaultGem1Name='';
		$this->session->data['DefaultGem1Name']='';
		$this->session->data['DefaultMetal1Name']='';

		// echo "product_inf type" . $product_info['type'];
		if($product_info['type'] == 0)
		{
			$this->defaultProductData();
		}

		$DefaultMetal1Name=$this->session->data['DefaultMetal1Name'];
		$DefaultGem1Name=$this->session->data['DefaultGem1Name'];

		$this->document->setTitle($product_info['name'] . ' ' . $DefaultMetal1Name. ' ' . $DefaultGem1Name . $categoryname . ' | Customise Your Own on ' . $this->config->get('config_name') );
		$data['categoryname'] = $categoryname;

		if ($product_info) {
			$url = '';

			if (isset($this->request->get['path'])) {
				$url .= '&path=' . $this->request->get['path'];
			}

			if (isset($this->request->get['filter'])) {
				$url .= '&filter=' . $this->request->get['filter'];
			}

			if (isset($this->request->get['manufacturer_id'])) {
				$url .= '&manufacturer_id=' . $this->request->get['manufacturer_id'];
			}

			if (isset($this->request->get['search'])) {
				$url .= '&search=' . $this->request->get['search'];
			}

			if (isset($this->request->get['tag'])) {
				$url .= '&tag=' . $this->request->get['tag'];
			}

			if (isset($this->request->get['description'])) {
				$url .= '&description=' . $this->request->get['description'];
			}

			if (isset($this->request->get['category_id'])) {
				$url .= '&category_id=' . $this->request->get['category_id'];
			}

			if (isset($this->request->get['sub_category'])) {
				$url .= '&sub_category=' . $this->request->get['sub_category'];
			}

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			if (isset($this->request->get['limit'])) {
				$url .= '&limit=' . $this->request->get['limit'];
			}

			$data['breadcrumbs'][] = array(
				'text' => $product_info['name'],
				'href' => $this->url->link('product/product', $url . '&product_id=' . $this->request->get['product_id'])
			);

			$caturl="";
			if (isset($this->request->get['cat'])) {
				$caturl .= '&cat=' . $this->request->get['cat'];
			}
			if (isset($this->request->get['m1'])) {
				$caturl .= '&m1=' . $this->request->get['m1'];
			}
			if (isset($this->request->get['g1'])) {
				$caturl .= '&g1=' . $this->request->get['g1'];
			}

//			$this->document->setTitle($product_info['meta_title']);
			$this->document->setTitle($product_info['name'] . ' ' . $DefaultMetal1Name. ' ' . $DefaultGem1Name . $categoryname . ' | Customise Your Own on ' . $this->config->get('config_name') );

			$this->document->setDescription($product_info['meta_description']);
			$this->document->setKeywords($product_info['meta_keyword']);
			$this->document->addLink($this->url->link('product/product', 'product_id=' . $this->request->get['product_id']), 'canonical');
			$this->document->addScript('catalog/view/javascript/jquery/magnific/jquery.magnific-popup.min.js');
			$this->document->addStyle('catalog/view/javascript/jquery/magnific/magnific-popup.css');
			$this->document->addScript('catalog/view/javascript/jquery/datetimepicker/moment/moment.min.js');
			$this->document->addScript('catalog/view/javascript/jquery/datetimepicker/moment/moment-with-locales.min.js');
			$this->document->addScript('catalog/view/javascript/jquery/datetimepicker/bootstrap-datetimepicker.min.js');
			$this->document->addStyle('catalog/view/javascript/jquery/datetimepicker/bootstrap-datetimepicker.min.css');

			$data['heading_title'] = $product_info['name'];

			$data['text_minimum'] = sprintf($this->language->get('text_minimum'), $product_info['minimum']);
			$data['text_login'] = sprintf($this->language->get('text_login'), $this->url->link('account/login', '', true), $this->url->link('account/register', '', true));

			$this->load->model('catalog/review');

			$data['tab_review'] = sprintf($this->language->get('tab_review'), $product_info['reviews']);

			$data['product_id'] = (int)$this->request->get['product_id'];
			$data['manufacturer'] = $product_info['manufacturer'];
			$data['manufacturers'] = $this->url->link('product/manufacturer/info', 'manufacturer_id=' . $product_info['manufacturer_id']);
			$data['model'] = $product_info['model'];
			$data['reward'] = $product_info['reward'];
			$data['points'] = $product_info['points'];
			$data['description'] = html_entity_decode($product_info['description'], ENT_QUOTES, 'UTF-8');

			if(isset($this->request->get['shape_id'])){
				$data['shape_id'] = $this->request->get['shape_id'];
			}

			if ($product_info['quantity'] <= 0) {
				$data['stock'] = $product_info['stock_status'];
			} elseif ($this->config->get('config_stock_display')) {
				$data['stock'] = $product_info['quantity'];
			} else {
				$data['stock'] = $this->language->get('text_instock');
			}

			$this->load->model('tool/image');

			if ($product_info['image']) {
				$data['popup'] = $this->model_tool_image->resize($product_info['image'], $this->config->get('theme_' . $this->config->get('config_theme') . '_image_popup_width'), $this->config->get('theme_' . $this->config->get('config_theme') . '_image_popup_height'));
			} else {
				$data['popup'] = '';
			}

			$data['realImage'] = '';
			if ($product_info['image']) {
				$data['thumb'] = $this->model_tool_image->resize($product_info['image'], $this->config->get('theme_' . $this->config->get('config_theme') . '_image_thumb_width'), $this->config->get('theme_' . $this->config->get('config_theme') . '_image_thumb_height'));
				$data['realImage'] = $product_info['image'];
				if($product_info['image']==''){
					if(isset($this->session->data[$this->request->get['product_id'].'new_product_image_jpg'])){
						$data['realImage'] = $this->session->data[$this->request->get['product_id'].'new_product_image_jpg'];
					}
				}
			} else {
				if(isset($this->session->data[$this->request->get['product_id'].'new_product_image_jpg'])){
					$data['realImage'] = $this->session->data[$this->request->get['product_id'].'new_product_image_jpg'];
				}
				$data['thumb'] = '';
			}

			if (isset($this->request->get['image'])) {
				$data['realImage'] = 'TEMP/' . $this->request->get['image'] . '.png.jpg';
			}
			if(isset($this->request->get['m1']) || isset($this->request->get['g1'])){
				$data['realImage'] = str_replace('image/','',$this->session->data[$this->request->get['product_id'].'new_product_image']) ;
			}

			if($product_info['type'] == 0)
			{
				if(isset($this->session->data[$this->request->get['product_id'].'new_product_image']))
				{
					//echo '<br>--'.$this->session->data[$this->request->get['product_id'].'new_product_image'];
					$data['popup'] = $this->model_tool_image->resize(str_replace('image/catalog/','',$this->session->data[$this->request->get['product_id'].'new_product_image']), $this->config->get('config_image_popup_width'), $this->config->get('config_image_popup_height'));
					//	echo '<br>--'.$data['popup']  . $this->config->get('config_image_popup_width');
					$data['thumb'] = $this->model_tool_image->resize(str_replace('image/catalog/','',$this->session->data[$this->request->get['product_id'].'new_product_image']), $this->config->get('config_image_thumb_width'), $this->config->get('config_image_thumb_height'));
				}
			}

   		$data['images'] = array();

			$data['add_images'] = array();


			$results = $this->model_catalog_product->getProductImages($this->request->get['product_id']);

			foreach ($results as $result) {
				$data['add_images'][] = array(
					'popup' => $this->model_tool_image->resize($result['image'], $this->config->get('theme_' . $this->config->get('config_theme') . '_image_popup_width'), $this->config->get('theme_' . $this->config->get('config_theme') . '_image_popup_height')),
					'thumb' => $this->model_tool_image->resize($result['image'], $this->config->get('theme_' . $this->config->get('config_theme') . '_image_additional_width'), $this->config->get('theme_' . $this->config->get('config_theme') . '_image_additional_height'))
				);
			}
			if ($this->customer->isLogged() || !$this->config->get('config_customer_price')) {
				$data['price'] = $this->currency->format($this->tax->calculate($product_info['price'], $product_info['tax_class_id'], $this->config->get('config_tax')), $this->session->data['currency']);
			} else {
				$data['price'] = false;
			}

			if ((float)$product_info['special']) {
				$data['special'] = $this->currency->format($this->tax->calculate($product_info['special'], $product_info['tax_class_id'], $this->config->get('config_tax')), $this->session->data['currency']);
			} else {
				$data['special'] = false;
			}

			$results = $this->model_catalog_product->getProductImages($this->request->get['product_id']);
			$resultcount=2;


			foreach ($results as $result) {
				if (strpos('test'.$result['image'], 'no_image') !== false) {
					$result['image'] = str_replace(".png.jpg",  $resultcount . ".png.jpg", $data['realImage']);
					$resultcount++;
				}
				$data['images'][] = array(
					'popup' => $this->model_tool_image->resize($result['image'], $this->config->get('config_image_popup_width'), $this->config->get('config_image_popup_height')),
					'thumb' => $this->model_tool_image->resize($result['image'], $this->config->get('config_image_additional_width'), $this->config->get('config_image_additional_height')),
					'name' => str_replace(".png.jpg", "1.png.jpg",$data['realImage'])
				);
			}


			$realImage = $data['realImage'];
			$additionalImages = array();

			$additionalImages[] = str_replace(".png", "1.png.jpg",$realImage);
			$additionalImages[] = str_replace(".png", "3.png.jpg",$realImage);
			$additionalImages[] = str_replace(".png", "4.png.jpg",$realImage);
			$additionalImages[] = str_replace(".png", "5.png.jpg",$realImage);
			$additionalImages[] = str_replace(".png", "2.png.jpg",$realImage);
			$additionalImages[] = str_replace(".png", "3.png1.jpg",$realImage);
			$additionalImages[] = str_replace(".png.", "4.png1.jpg",$realImage);

			foreach ($additionalImages as $additionalImage) {
				// echo 		DIR_IMAGE .			$additionalImage . " ------- <br>";
				if (file_exists(DIR_IMAGE . $additionalImage )) {
					// echo 		DIR_IMAGE .			$additionalImage . " -- <br>";
					if (strpos('test'.$additionalImage, 'no_image') !== false) {
						$result['image'] = str_replace(".png.jpg",  $resultcount . ".png.jpg", $data['realImage']);
						$resultcount++;
					}
					$data['images'][] = array(
						'popup' => $this->model_tool_image->resize($additionalImage, $this->config->get('config_image_popup_width'), $this->config->get('config_image_popup_height')),
						'thumb' => $this->model_tool_image->resize($additionalImage, $this->config->get('config_image_additional_width'), $this->config->get('config_image_additional_height')),
						'name' => str_replace(".png.jpg", "1.png.jpg",$data['realImage'])
					);
					//echo '<br>'.$additionalImage;
				}
			}


			if (($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) {
				$data['price'] = $this->currency->format($this->tax->calculate($product_info['price'], $product_info['tax_class_id'], $this->config->get('config_tax')));
				$data['price_exclude_markup'] = round($this->session->data[$this->request->get['product_id'].'new_price_exclude_markup']);

				$data['finalprdprice'] = $this->tax->calculate($product_info['price'], $product_info['tax_class_id'], $this->config->get('config_tax'));
				if(isset($this->session->data[$this->request->get['product_id'].'new_product_image'])){
					if(isset($this->session->data[$this->request->get['product_id'].'new_price'])){
						$data['price'] = 	$this->currency->format($this->tax->calculate($this->session->data[$this->request->get['product_id'].'new_price'] , $product_info['tax_class_id'], $this->config->get('config_tax')))  ;
						$data['pricewhole'] =  'AJ_'.$this->session->data[$this->request->get['product_id'].'new_price_whole']   ;
						$data['finalprdprice'] = 	$this->tax->calculate($this->session->data[$this->request->get['product_id'].'new_price'], $product_info['tax_class_id'], $this->config->get('config_tax')) ;

						$data['product_cost_excl_diamond'] =  $this->session->data[$this->request->get['product_id'].'product_cost_excl_diamond'];
						$data['product_cost_excl_wholesaler'] =  $this->session->data[$this->request->get['product_id'].'product_cost_excl_wholesaler'];
						$data['diamond_only_cost'] =  $this->session->data[$this->request->get['product_id'].'diamond_only_cost'];
						$data['diamond_only_cost_wholesale'] =  $this->session->data[$this->request->get['product_id'].'diamond_only_cost_wholesale'] ;

						$data['product_cost_excl_diamond_Formatted'] =  	$this->currency->format($this->session->data[$this->request->get['product_id'].'product_cost_excl_diamond']);
						$data['product_cost_excl_wholesaler_Formatted'] =  	$this->currency->format($this->session->data[$this->request->get['product_id'].'product_cost_excl_wholesaler']);
						$data['diamond_only_cost_Formatted'] =  	$this->currency->format($this->session->data[$this->request->get['product_id'].'diamond_only_cost']);
						$data['diamond_only_cost_wholesale_Formatted'] = 	$this->currency->format( $this->session->data[$this->request->get['product_id'].'diamond_only_cost']);

						// $data['price'] = 	1010;

					}
				}

			} else {
				$data['price'] = false;
				$data['finalprdprice'] = false;
			}
			if(isset($this->session->data[$this->request->get['product_id'].'prdoptionname'])){
				$data['prdoptionname'] = $this->session->data[$this->request->get['product_id'].'prdoptionname'];
			}

			if ($this->config->get('config_tax')) {
				$data['tax'] = $this->currency->format((float)$product_info['special'] ? $product_info['special'] : $product_info['price'], $this->session->data['currency']);
			} else {
				$data['tax'] = false;
			}

			$discounts = $this->model_catalog_product->getProductDiscounts($this->request->get['product_id']);

			$data['discounts'] = array();

			foreach ($discounts as $discount) {
				$data['discounts'][] = array(
					'quantity' => $discount['quantity'],
					'price'    => $this->currency->format($this->tax->calculate($discount['price'], $product_info['tax_class_id'], $this->config->get('config_tax')), $this->session->data['currency'])
				);
			}

			$data['options'] = array();

			$data['rnoExist'] = 0;
			if( isset($this->request->get[ 'rno' ]) ){
				$SelectedDiamondData = $this->model_catalog_product->getRapnetDiamond($this->request->get[ 'rno' ]);
				$data['SelectedDiamondData'] = $SelectedDiamondData[0];
				$data['rnoExist'] = 1;
			}

			foreach ($this->model_catalog_product->getProductOptions($this->request->get['product_id']) as $option) {
				$product_option_value_data = array();

				foreach ($option['product_option_value'] as $option_value) {
					if (!$option_value['subtract'] || ($option_value['quantity'] > 0)) {
						if ((($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) && (float)$option_value['price']) {
							$price = $this->currency->format($this->tax->calculate($option_value['price'], $product_info['tax_class_id'], $this->config->get('config_tax') ? 'P' : false), $this->session->data['currency']);
						} else {
							$price = false;
						}

						$product_option_value_data[] = array(
							'product_option_value_id' => $option_value['product_option_value_id'],
							'option_value_id'         => $option_value['option_value_id'],
							'name'                    => $option_value['name'],
							'image'                   => $this->model_tool_image->resize($option_value['image'], 50, 50),
							'price'                   => $price,
							'price_prefix'            => $option_value['price_prefix']
						);
					}
				}

				$data['options'][] = array(
					'product_option_id'    => $option['product_option_id'],
					'product_option_value' => $product_option_value_data,
					'option_id'            => $option['option_id'],
					'name'                 => $option['name'],
					'type'                 => $option['type'],
					'value'                => $option['value'],
					'required'             => $option['required']
				);
			}

			//New Codes Starts
			$data['metals'] = array();
			foreach ($this->model_catalog_product->getProductMetal($data['product_id']) as $metal) {
				$metal_available = array();
				foreach ($this->model_catalog_product->getProductMetalAvail($data['product_id'],$metal['metal']) as $metalavail) {
					$metal_available[] = array(
						'product_metalavail_id'  => $metalavail['product_metalavail_id'],
						'metal'  			 => $metalavail['metal'],
						'metal_id'           => $metalavail['metal_id'],
						'metal_code'         => $metalavail['metal_code'],
						'image'  			 => $metalavail['image'],
						'metal_image'  		 => $metalavail['metal_image'],
						'imgdescription'  	 => htmlspecialchars('<span class="short-body">'.$metalavail['metalname'].'<br/>'.$metalavail['description'].'</span>'),
						'metalDescContent'   => ($metal['metal']==1?'Primary Metal : ':'Other Metals : ') .  $metalavail['metalname'].'<br />Weight : ' . round(($metal['weight'] *  $metalavail['silver_ratio']),2) . ' gm (approx.)<br /><br />',
						'defaultnew'         => $metalavail['defaultnew'],
						'metalName'          => $metalavail['metalname'],
						'metalWeight'        => $metal['weight'] *  $metalavail['silver_ratio'],
						'price'  			 => $metalavail['price'],
						'currency'           => $metalavail['currency']
					);
//					if($metalavail['defaultnew']==1){
					if( ($metalavail['metal']!=1 && $metalavail['defaultnew']) ||
						($metalavail['metal'] ==1 && isset($this->request->get['m1']) && $metalavail['metal_id']== $this->request->get['m1']) ||
						($metalavail['metal'] ==1 && !isset($this->request->get['m1']) && $metalavail['defaultnew'] ))
					{
						$metalBoxImage   = $metalavail['image'];
						$metalName   	 = $metalavail['metalname'];
						$metalWeight   	 = $metal['weight'] *  $metalavail['silver_ratio'];
						$metalBoxId      = $metalavail['metal_id'];
						$metalBoxContent = '<span class="short-body">'.$metalavail['metalname'].'<br/>'.$metalavail['description'].'</span>';
						$metalBoxContent1 = $metalavail['metalname'];
					}
				}

				$data['metals'][] = array(
						'metal'  			=> $metal['metal'],
						'weight'            => $metal['weight'],
						'metalName'    		=> $metalName,
						'metalWeight'    	=> $metalWeight,
						'metalBoxImage'     => $metalBoxImage,
						'metal_id'          => $metalBoxId,
						'metalBoxContent'   => $metalBoxContent,
						'metalBoxContent1'  => $metalBoxContent1,
						'metal_available'   => $metal_available
				);

					if($metal['metal']==1){
						$data['PrimaryMetal'] = $metalName;
					}
			}

			$data['diamondCertificate'] =  "https://www.certifiedstone.info/certificate/LD180922787.pdf";
			$data['diamondImage'] =  "https://www.certifiedstone.info/diamondimages/LD180922787/LD180922787_1.jpg";
			$data['diamondVideoURL'] =  "https://www.certifiedstone.info/viewer/vision360.html?d=LD180922787&s=-20&h=540&w=510&bp=l";
			$data['diamondShape1'] =  "diamondShape1";
			$data['diamondShape2'] =  "diamondShape2";
			$data['gemstones'] = array();
			$data['diamondrapnet'] = 0;
			$diamondrapnet = 0;
			$gemstonedefaultid  = 1000;
			foreach ($this->model_catalog_product->getProductGemstones($data['product_id']) as $gemstone) {
				$gemstone_available = array();
				$rapnetFlag = 0;
				foreach ($this->model_catalog_product->getProductGemstonesAvail($data['product_id'],$gemstone['gem'],"DEFAULT") as $gemstone_avail) {
					$gemQuality = $this->model_catalog_product->getGemQuality($gemstone_avail['gemstone_id']);
					$gemWeight = round($this->model_catalog_product->getGemWeight($gemstone_avail['product_gemavail_id']),2);
					$rapnet_url = '';


					if($gemstone_avail['rapnet']==1 && isset($gemstone_avail['rapnet_quality'])){
						// echo '<br>' . $gemstone['count'] . ' - ' . $gemstone_avail['rapnet_weight'];
						$gemQuality_1 = $gemstone_avail['rapnet_quality'];
						$gemSize_1 = $gemstone_avail['rapnet_size'];
						$gem_rapnet_weight = str_replace('  mm ','',$gemstone_avail['rapnet_weight']);
						$gemWeight_1 = round($gemstone['count'] * $gem_rapnet_weight  ,2);
						$rapnet_url = $gemstone_avail['rapnet_url'] ;
						$diamondImage = $gemstone_avail['diamondImage'] ;
						$diamondCertificate = trim($gemstone_avail['diamondCertificate']) ;
						$rapnet_lot_no = $gemstone_avail['rapnet_lot_no'] ;
						$diamondVideoURL = trim($gemstone_avail['diamondVideoURL']) ;
						$data['diamondCertificate'] =  trim($gemstone_avail['diamondCertificate']) ;
						$data['rapnet_lot_no'] =  $gemstone_avail['rapnet_lot_no'] ;
						$data['diamondImage'] =  $gemstone_avail['diamondImage'] ;
						$data['diamondVideoURL'] =  trim($gemstone_avail['diamondVideoURL']) ;
						$data['DiamondShape'] =  ucfirst(strtolower($gemstone_avail['shape']));
						$data['measwidth'] =  $gemstone_avail['measwidth'] ;
						$data['measdepth'] =  $gemstone_avail['measdepth'] ;
						$data['measlength'] =  $gemstone_avail['measlength'] ;
						$data['table'] =  $gemstone_avail['table'] ;
						$data['girdle'] =  $gemstone_avail['girdle'] ;
						$data['culet'] =  $gemstone_avail['culet'] ;
						$data['depthper'] =  $gemstone_avail['depth_percentage'] ;
					}else{
						$gemQuality_1 = $gemQuality;
						$gemSize_1 = $gemstone['size'];
						$gemWeight_1 = $gemWeight;
						$rapnet_url = '<br />Quality : ' . $gemQuality_1 .'<br />Size : ' . $gemSize_1 .'<br />Total Weight : ' . $gemWeight_1 .' carats (approx.)<br />';
					}
					if($gemstone_avail['gem']==1 && $gemstone_avail['gemstone_id']==9 && $gemstone_avail['rapnet']==1 ){

						$rapnetFlag = $gemstone_avail['rapnet'];
						$data['diamondrapnet'] = 1;
						$diamondrapnet = 1;

						if(isset($this->request->get['errorlog']))$this->log->write("GemWeights : "  . $gemWeight );

						if($gemWeight > 0){


							$data['caratvalue'] = 0; //3;

							$data['caratminvalue'] = 0;
							$data['caratmaxvalue'] = 4;

							$gemWeightDia = $gemWeight / $gemstone['count'] ;
							$gemWeightmin = $gemWeightDia - $gemWeightDia * 0.5;
							$gemWeight1 = $gemWeightDia - $gemWeightDia * 0.25;
							$gemWeight2 = $gemWeightDia + $gemWeightDia * 0.25;
							$gemWeightmax = $gemWeightDia + $gemWeightDia * 0.5;
							$data['caratvalues'] =  array(    $gemWeightmax, $gemWeight2, $gemWeightDia, $gemWeight1, $gemWeightmin);
							$this->log->write( " Getting Diamond Table of Data for shape : " . $gemstone['shape'] . " with weight " .  $gemWeightDia );
							$data['diamondData'] = $this->model_catalog_product->getDiamondData( $gemstone['shape'] ,  $gemWeightmin , $gemWeightmax, $gemWeightDia  );

							if(isset($this->request->get['errorlog']))$this->log->write( " == gemstone shape : " . $gemstone['shape'] . "   ; Weight: " . $gemWeightmin . " - " . $gemWeightmax );

							$gemRapnetMinMaxData =  $this->model_catalog_product->getMaxColorClarityValues( $gemstone['shape'] ,  $gemWeightmin , $gemWeightmax  );

							//$data['colorminvalue'] = $gemRapnetMinMaxData['mincolour'];
							$data['colormaxvalue'] = $gemRapnetMinMaxData[0]['maxcolour'];;

							//$data['clarityminvalue'] = $gemRapnetMinMaxData['minclarity'];;
							$data['claritymaxvalue'] = $gemRapnetMinMaxData[0]['maxclarity'];;


							if(isset($this->request->get['errorlog']))$this->log->write("GemWeights : " . $gemWeightmin . " == " . $gemWeight1. " == " .  $gemWeightDia. " == " . $gemWeight2. " == " . $gemWeightmax);
						}

					}

					$gemstone_available[] = array(
						'product_gemavail_id' => $gemstone_avail['product_gemavail_id'],
						'gem'  			 	 => $gemstone_avail['gem'],
						'gemstone_id'    	 => $gemstone_avail['gemstone_id'],
						'image'  			 => $gemstone_avail['image'],
						'image1'  			 => $gemstone_avail['image1'],
						'gemName'         	 => $gemstone_avail['gemname'],
						'rapnet'         	 => $rapnetFlag,
						'gemQuality'         => $gemQuality_1,
						'gemSize'            => $gemSize_1,
						'gemCount'           => $gemstone['count'],
						'gemShape'           => $gemstone['shape'],
						'gemWeight'          => $gemWeight_1,
						'gemSetting'         => $gemstone['setting'],
						'imgdescription'  	 => htmlspecialchars('<div class="short-title">'. strtoupper($gemstone_avail['gemdescr']) .'</div>Birthstone: '. $gemstone_avail['birthstone'] .'<br><span class="short-body">Anniversary: '. $gemstone_avail['anniversary']  .'</span>'),
						'defaultnew'         => $gemstone_avail['defaultnew'],
						//'gemDescContent'     => ($gemstone['gem']==1?'Center Gemstone : ':'Accent Gemstone : ' ) . $gemstone_avail['gemname']  . $rapnet_url .'<br />Quality : ' . $gemQuality_1 .'<br />Size : ' . $gemSize_1 .'<br />Shape : ' . $gemstone['shape'] .'<br />Total Weight : ' . $gemWeight_1 .' carats (approx.)<br />Count : ' . $gemstone['count'] .' pc<br />Setting : ' . $gemstone['setting'] . '<br /><br />'
						'gemDescContent'     => ($gemstone['gem']==1?'Center Gemstone : ':'Accent Gemstone : ' ) . $gemstone_avail['gemname']  . $rapnet_url .'Shape : ' . $gemstone['shape'] .'<br />Count : ' . $gemstone['count'] .' pc<br />Setting : ' . $gemstone['setting'] . '<br /><br />'

					);


//					if($gemstone_avail['defaultnew']==1){
					if( ($gemstone_avail['gem'] !=1 && $gemstone_avail['defaultnew']) ||
						($gemstone_avail['gem'] ==1 && isset($this->request->get['g1']) && $gemstone_avail['gemstone_id']== $this->request->get['g1']) ||
						($gemstone_avail['gem'] ==1 && !isset($this->request->get['g1']) && $gemstone_avail['defaultnew'] ))
					{
						$gemName = $gemstone_avail['gemname'] . $rapnet_url;
						$gemNameHeader = $gemstone_avail['gemname'] ;
						$gemBoxImage = $gemstone_avail['image1'];
						$gemBoxContent = '<div class="short-title">'. strtoupper($gemstone_avail['gemdescr']) .'</div>Birthstone: '. $gemstone_avail['birthstone'] .'<br><span class="short-body">Anniversary: '. $gemstone_avail['anniversary']  .'</span>';
						$gemBoxContent1 = strtoupper($gemstone_avail['gemdescr']);
						$gemstonedefaultid  = $gemstone_avail['gemstone_id'];
						$gemQuality         = $gemQuality_1;
						$gemSize            = $gemSize_1;
						$gemShape           = $gemstone['shape'];
						$gemWeightFinal     = round($this->model_catalog_product->getGemWeight($gemstone_avail['product_gemavail_id']),2);
						$gemQualityFinal     = $this->model_catalog_product->getGemQuality($gemstone_avail['gemstone_id']);
						$gemSetting         = $gemstone['setting'];
					}
					if($gemstone_avail['rapnet']==1 ){
						$gemWeightFinal = $gemWeight_1;
						$gemQualityFinal = $gemQuality_1;
					}
				}
				$data['gemstones'][] = array(
						'gem'  		         => $gemstone['gem'],
						'weight'             => $gemstone['weight'],
						'gemName'            => $gemName,
						'gemNameHeader'      => $gemNameHeader,
						'gemQuality'         => $gemQualityFinal,
						'gemSize'            => $gemSize,
						'gemCount'           => $gemstone['count'],
						'gemShape'           => $gemShape,
						'gemWeight'          => $gemWeightFinal,
						'gemSetting'         => $gemSetting,
						'gemstone_id'        => $gemstonedefaultid,
						'gemBoxContent'      => $gemBoxContent,
						'gemBoxContent1'     => $gemBoxContent1,
						'gemBoxImage'        => $gemBoxImage,
						'gemstone_available' => $gemstone_available
				);

					if($gemstone['gem']==1){
						$data['DiamondShape'] = ucfirst(strtolower($gemstone['shape']));
						$data['CenterGemstone'] = $gemNameHeader;
						$data['CenterGemSetting'] = $gemSetting;
					}
			}
			//New Codes Ends



			$data['NotNoneGemstoneProduct'] = $this->model_catalog_product->isProductGemstonesNone($this->request->get['product_id']);
			$data['product_engrave'] = $this->model_catalog_product->getProductEngraves($this->request->get['product_id']);
			/*
			$engrave = $this->model_catalog_product->getProductEngraves($this->request->get['product_id']);
			//foreach ($engrave as $product_engraves) {
				$data['product_engrave'] = array(
					'product_id'  => $engrave['product_id'],
					'field1'      => split(";",$engrave['field1']),
					'field2'      => split(";",$engrave['field2']),
					'field3'      => split(";",$engrave['field3']),
					'field4'      => $split(";",engrave['field4']),
					'field5'      => split(";",$engrave['field5']),
					'field6'      => split(";",$engrave['field6']),
					'field7'      => split(";",$engrave['field7']),
					'field8'      => split(";",$engrave['field8'])
				);
			}
			*/

			$data['review_status'] = $this->config->get('config_review_status');
			$data['reviews'] = sprintf($this->language->get('text_reviews'), (int)$product_info['reviews']);
			$data['rating'] = (int)$product_info['rating'];
			$data['description'] = html_entity_decode($product_info['description'], ENT_QUOTES, 'UTF-8');
			$data['attribute_groups'] = $this->model_catalog_product->getProductAttributes($this->request->get['product_id']);

			if ($product_info['minimum']) {
				$data['minimum'] = $product_info['minimum'];
			} else {
				$data['minimum'] = 1;
			}

			$data['review_status'] = $this->config->get('config_review_status');

			if ($this->config->get('config_review_guest') || $this->customer->isLogged()) {
				$data['review_guest'] = true;
			} else {
				$data['review_guest'] = false;
			}

			if ($this->customer->isLogged()) {
				$data['customer_name'] = $this->customer->getFirstName() . '&nbsp;' . $this->customer->getLastName();
			} else {
				$data['customer_name'] = '';
			}

			$data['reviews'] = sprintf($this->language->get('text_reviews'), (int)$product_info['reviews']);
			$data['rating'] = (int)$product_info['rating'];

			// Captcha
			if ($this->config->get('captcha_' . $this->config->get('config_captcha') . '_status') && in_array('review', (array)$this->config->get('config_captcha_page'))) {
				$data['captcha'] = $this->load->controller('extension/captcha/' . $this->config->get('config_captcha'));
			} else {
				$data['captcha'] = '';
			}

			$data['share'] = $this->url->link('product/product', 'product_id=' . (int)$this->request->get['product_id']);

			$data['attribute_groups'] = $this->model_catalog_product->getProductAttributes($this->request->get['product_id']);

			$data['products'] = array();

			$results = $this->model_catalog_product->getProductRelated($this->request->get['product_id']);

			foreach ($results as $result) {
				if ($result['image']) {
					$image = $this->model_tool_image->resize($result['image'], $this->config->get('theme_' . $this->config->get('config_theme') . '_image_related_width'), $this->config->get('theme_' . $this->config->get('config_theme') . '_image_related_height'));
				} else {
					$image = $this->model_tool_image->resize('placeholder.png', $this->config->get('theme_' . $this->config->get('config_theme') . '_image_related_width'), $this->config->get('theme_' . $this->config->get('config_theme') . '_image_related_height'));
				}

				if ($this->customer->isLogged() || !$this->config->get('config_customer_price')) {
					$price = $this->currency->format($this->tax->calculate($result['price'], $result['tax_class_id'], $this->config->get('config_tax')), $this->session->data['currency']);
				} else {
					$price = false;
				}

				if ((float)$result['special']) {
					$special = $this->currency->format($this->tax->calculate($result['special'], $result['tax_class_id'], $this->config->get('config_tax')), $this->session->data['currency']);
				} else {
					$special = false;
				}

				if ($this->config->get('config_tax')) {
					$tax = $this->currency->format((float)$result['special'] ? $result['special'] : $result['price'], $this->session->data['currency']);
				} else {
					$tax = false;
				}

				if ($this->config->get('config_review_status')) {
					$rating = (int)$result['rating'];
				} else {
					$rating = false;
				}



				$data['products'][] = array(
					'product_id'  => $result['product_id'],
					'thumb'       => $image,
					'name'        => $result['name'],
					'description' => utf8_substr(trim(strip_tags(html_entity_decode($result['description'], ENT_QUOTES, 'UTF-8'))), 0, $this->config->get('theme_' . $this->config->get('config_theme') . '_product_description_length')) . '..',
					'price'       => $price,
					'special'     => $special,
					'tax'         => $tax,
					'minimum'     => $result['minimum'] > 0 ? $result['minimum'] : 1,
					'rating'      => $rating,
					'href'        => $this->url->link('product/product', 'product_id=' . $result['product_id'])
				);
			}

			$data['tags'] = array();

			if ($product_info['tag']) {
				$tags = explode(',', $product_info['tag']);

				foreach ($tags as $tag) {
					$data['tags'][] = array(
						'tag'  => trim($tag),
						'href' => $this->url->link('product/search', 'tag=' . trim($tag))
					);
				}
			}

			$data['recurrings'] = $this->model_catalog_product->getProfiles($this->request->get['product_id']);

			$this->model_catalog_product->updateViewed($this->request->get['product_id']);



						$data['Module123_Enable'] = 0;
						$data['Selection123'] = '';
						if( ( isset($this->session->data['Ring_Diamond_RNO']) || isset($this->session->data['Earrings_Diamond_RNO']) ) && (isset($this->session->data['Earrings_Setting_pid']) ||  isset($this->session->data['Ring_Setting_pid']) ) ) {
								$data['Module123_Enable'] = 1;

								if( isset($this->session->data['Ring_Diamond_RNO']) ) {
										$data['Selected_Diamond'] = $this->session->data['Ring_Diamond_RNO'];
								}

								if( isset($this->session->data['Earrings_Diamond_RNO']) ) {
										$data['Selected_Diamond'] = $this->session->data['Earrings_Diamond_RNO'];
								}
								$data['Selection123'] = $this->load->controller('product/selection123');
						}


			$data['column_left'] = $this->load->controller('common/column_left');
			$data['column_right'] = $this->load->controller('common/column_right');
			$data['content_top'] = $this->load->controller('common/content_top');
			$data['content_bottom'] = $this->load->controller('common/content_bottom');
			$data['footer'] = $this->load->controller('common/footer');
			$data['header'] = $this->load->controller('common/header');

			$this->response->setOutput($this->load->view('product/product', $data));
		} else {
			$url = '';

			if (isset($this->request->get['path'])) {
				$url .= '&path=' . $this->request->get['path'];
			}

			if (isset($this->request->get['filter'])) {
				$url .= '&filter=' . $this->request->get['filter'];
			}

			if (isset($this->request->get['manufacturer_id'])) {
				$url .= '&manufacturer_id=' . $this->request->get['manufacturer_id'];
			}

			if (isset($this->request->get['search'])) {
				$url .= '&search=' . $this->request->get['search'];
			}

			if (isset($this->request->get['tag'])) {
				$url .= '&tag=' . $this->request->get['tag'];
			}

			if (isset($this->request->get['description'])) {
				$url .= '&description=' . $this->request->get['description'];
			}

			if (isset($this->request->get['category_id'])) {
				$url .= '&category_id=' . $this->request->get['category_id'];
			}

			if (isset($this->request->get['sub_category'])) {
				$url .= '&sub_category=' . $this->request->get['sub_category'];
			}

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			if (isset($this->request->get['limit'])) {
				$url .= '&limit=' . $this->request->get['limit'];
			}

			$data['breadcrumbs'][] = array(
				'text' => $this->language->get('text_error'),
				'href' => $this->url->link('product/product', $url . '&product_id=' . $product_id)
			);

			$this->document->setTitle($this->language->get('text_error'));

			$data['continue'] = $this->url->link('common/home');

			$this->response->addHeader($this->request->server['SERVER_PROTOCOL'] . ' 404 Not Found');


			$data['column_left'] = $this->load->controller('common/column_left');
			$data['column_right'] = $this->load->controller('common/column_right');
			$data['content_top'] = $this->load->controller('common/content_top');
			$data['content_bottom'] = $this->load->controller('common/content_bottom');
			$data['footer'] = $this->load->controller('common/footer');
			$data['header'] = $this->load->controller('common/header');

			$this->response->setOutput($this->load->view('error/not_found', $data));
		}
	}

	public function review() {
		$this->load->language('product/product');

		$this->load->model('catalog/review');

		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

		$data['reviews'] = array();

		$review_total = $this->model_catalog_review->getTotalReviewsByProductId($this->request->get['product_id']);

		$results = $this->model_catalog_review->getReviewsByProductId($this->request->get['product_id'], ($page - 1) * 5, 5);

		foreach ($results as $result) {
			$data['reviews'][] = array(
				'author'     => $result['author'],
				'text'       => nl2br($result['text']),
				'rating'     => (int)$result['rating'],
				'date_added' => date($this->language->get('date_format_short'), strtotime($result['date_added']))
			);
		}

		$pagination = new Pagination();
		$pagination->total = $review_total;
		$pagination->page = $page;
		$pagination->limit = 5;
		$pagination->url = $this->url->link('product/product/review', 'product_id=' . $this->request->get['product_id'] . '&page={page}');

		$data['pagination'] = $pagination->render();

		$data['results'] = sprintf($this->language->get('text_pagination'), ($review_total) ? (($page - 1) * 5) + 1 : 0, ((($page - 1) * 5) > ($review_total - 5)) ? $review_total : ((($page - 1) * 5) + 5), $review_total, ceil($review_total / 5));

		$this->response->setOutput($this->load->view('product/review', $data));
	}

	public function write() {
		$this->load->language('product/product');

		$json = array();

		if ($this->request->server['REQUEST_METHOD'] == 'POST') {
			if ((utf8_strlen($this->request->post['name']) < 3) || (utf8_strlen($this->request->post['name']) > 25)) {
				$json['error'] = $this->language->get('error_name');
			}

			if ((utf8_strlen($this->request->post['text']) < 25) || (utf8_strlen($this->request->post['text']) > 1000)) {
				$json['error'] = $this->language->get('error_text');
			}

			if (empty($this->request->post['rating']) || $this->request->post['rating'] < 0 || $this->request->post['rating'] > 5) {
				$json['error'] = $this->language->get('error_rating');
			}

			// Captcha
			if ($this->config->get('captcha_' . $this->config->get('config_captcha') . '_status') && in_array('review', (array)$this->config->get('config_captcha_page'))) {
				$captcha = $this->load->controller('extension/captcha/' . $this->config->get('config_captcha') . '/validate');

				if ($captcha) {
					$json['error'] = $captcha;
				}
			}

			if (!isset($json['error'])) {
				$this->load->model('catalog/review');

				$this->model_catalog_review->addReview($this->request->get['product_id'], $this->request->post);

				$json['success'] = $this->language->get('text_success');
			}
		}

		$this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));
	}

	public function getRecurringDescription() {
		$this->load->language('product/product');
		$this->load->model('catalog/product');

		if (isset($this->request->post['product_id'])) {
			$product_id = $this->request->post['product_id'];
		} else {
			$product_id = 0;
		}

		if (isset($this->request->post['recurring_id'])) {
			$recurring_id = $this->request->post['recurring_id'];
		} else {
			$recurring_id = 0;
		}

		if (isset($this->request->post['quantity'])) {
			$quantity = $this->request->post['quantity'];
		} else {
			$quantity = 1;
		}

		$product_info = $this->model_catalog_product->getProduct($product_id);

		$recurring_info = $this->model_catalog_product->getProfile($product_id, $recurring_id);

		$json = array();

		if ($product_info && $recurring_info) {
			if (!$json) {
				$frequencies = array(
					'day'        => $this->language->get('text_day'),
					'week'       => $this->language->get('text_week'),
					'semi_month' => $this->language->get('text_semi_month'),
					'month'      => $this->language->get('text_month'),
					'year'       => $this->language->get('text_year'),
				);

				if ($recurring_info['trial_status'] == 1) {
					$price = $this->currency->format($this->tax->calculate($recurring_info['trial_price'] * $quantity, $product_info['tax_class_id'], $this->config->get('config_tax')), $this->session->data['currency']);
					$trial_text = sprintf($this->language->get('text_trial_description'), $price, $recurring_info['trial_cycle'], $frequencies[$recurring_info['trial_frequency']], $recurring_info['trial_duration']) . ' ';
				} else {
					$trial_text = '';
				}

				$price = $this->currency->format($this->tax->calculate($recurring_info['price'] * $quantity, $product_info['tax_class_id'], $this->config->get('config_tax')), $this->session->data['currency']);

				if ($recurring_info['duration']) {
					$text = $trial_text . sprintf($this->language->get('text_payment_description'), $price, $recurring_info['cycle'], $frequencies[$recurring_info['frequency']], $recurring_info['duration']);
				} else {
					$text = $trial_text . sprintf($this->language->get('text_payment_cancel'), $price, $recurring_info['cycle'], $frequencies[$recurring_info['frequency']], $recurring_info['duration']);
				}

				$json['success'] = $text;
			}
		}

		$this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));
	}

// Old Controller Functions added here

	public function review_Old() {
    	$this->language->load('product/product');

		$this->load->model('catalog/review');

		$this->data['text_no_reviews'] = $this->language->get('text_no_reviews');

		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

		$this->data['reviews'] = array();

		$review_total = $this->model_catalog_review->getTotalReviewsByProductId($this->request->get['product_id']);

		$results = $this->model_catalog_review->getReviewsByProductId($this->request->get['product_id'], ($page - 1) * 5, 5);

		foreach ($results as $result) {
        	$this->data['reviews'][] = array(
        		'author'     => $result['author'],
				'text'       => strip_tags($result['text']),
				'rating'     => (int)$result['rating'],
        		'reviews'    => sprintf($this->language->get('text_reviews'), (int)$review_total),
        		'date_added' => date($this->language->get('date_format_short'), strtotime($result['date_added']))
        	);
      	}

		$pagination = new Pagination();
		$pagination->total = $review_total;
		$pagination->page = $page;
		$pagination->limit = 5;
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('product/product/review', 'product_id=' . $this->request->get['product_id'] . '&page={page}');

		$this->data['pagination'] = $pagination->render();

		if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/product/review.tpl')) {
			$this->template = $this->config->get('config_template') . '/template/product/review.tpl';
		} else {
			$this->template = 'default/template/product/review.tpl';
		}

		$this->response->setOutput($this->render());
	}

	public function write_Old() {
		$this->language->load('product/product');

		$this->load->model('catalog/review');

		$json = array();

		if ((utf8_strlen($this->request->post['name']) < 3) || (utf8_strlen($this->request->post['name']) > 25)) {
			$json['error'] = $this->language->get('error_name');
		}

		if ((utf8_strlen($this->request->post['text']) < 25) || (utf8_strlen($this->request->post['text']) > 1000)) {
			$json['error'] = $this->language->get('error_text');
		}

		if (!$this->request->post['rating']) {
			$json['error'] = $this->language->get('error_rating');
		}

		if (!isset($this->session->data['captcha']) || ($this->session->data['captcha'] != $this->request->post['captcha'])) {
			$json['error'] = $this->language->get('error_captcha');
		}

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && !isset($json['error'])) {
			$this->model_catalog_review->addReview($this->request->get['product_id'], $this->request->post);

			$json['success'] = $this->language->get('text_success');
		}

		$this->response->setOutput(json_encode($json));
	}


	public function newproduct() {

		if (isset($this->request->get['product_id'])){
			$product_id = $this->request->get['product_id'];
		} else {
			$product_id = 0;
		}

		$this->load->model('catalog/product');

		$results = $this->model_catalog_product->getProductnewproduct($product_id);
		$newproductprice=$this->request->post['newproductprice'];
		$newproductimage=$this->request->post['newproductimage'];
		$optionname=$this->request->post['optionname'];
		$svgContents=$this->request->post['svgContents'];
		$rapnet_lot_no=$this->request->post['rapnet_lot_no'];
		$settingcost=$this->request->post['settingcost'];

		if(isset($this->request->get['errorlog']))$this->log->write('In New Product Price Section : ' . $newproductprice );
		if(isset($this->request->get['errorlog']))$this->log->write('In New Product Image   : ' . $newproductimage );
		if(isset($this->request->get['errorlog']))$this->log->write('In Option   : ' . $optionname );

		$newproduct_id=$this->model_catalog_product->updateProductnewproduct($product_id,$newproductprice,$newproductimage,$optionname,$svgContents,$rapnet_lot_no,$settingcost);

		$json = array();

		$json['product_id'] = $newproduct_id;
		if(isset($this->request->get['errorlog']))$this->log->write(' New Product ID CReated --------   : ' . $json['product_id']  );

		$this->response->setOutput(json_encode($json));

	}

	public function defaultProductData() {

		$prdimage = array();
		$metals_array =  array();
		$gemstones_array =  array();
		$product_details =  array();
		$new_product_details =  array();
		$cartImage='';
		$prdname = $this->request->get['product_id'] ;

		if (isset($this->request->get['image'])) {
			$cartImage = $this->request->get['image'] ;
		}

		$imageCount = $this->model_catalog_product->getProductImageCount($this->request->get['product_id']);
		$prdoptionname = '';

	if($cartImage==''){
		$metals = $this->model_catalog_product->getProductMetalAvalability($this->request->get['product_id']);
		foreach ($metals as $metal) {	// Load Default Metal Data

			if( ($metal['metal']!=1 && $metal['defaultnew']) ||
				($metal['metal'] ==1 && isset($this->request->get['m1']) && $metal['metal_id']== $this->request->get['m1']) ||
				($metal['metal'] ==1 && !isset($this->request->get['m1']) && $metal['defaultnew'] ))
			//	if( $metal['defaultnew'] )
			{
				$product_details[] = array(
					'type' => 'M',
					'id' => $metal['metal'],
					'value' => $metal['product_metalavail_id'],
					'image' => $metal['image'],
					'price' => $metal['price'],
					'name' => $metal['description']
				);
				$prdname = $prdname . '_M' . $metal['metal'] . '-' . $metal['product_metalavail_id'];
				if($metal['metal']==1){
					$this->session->data['DefaultMetal1Name']=$metal['description'];
					$prdoptionname .= '\n Primary Metal ' . ' - ' . $metal['description'] ;
				}else{
					$prdoptionname .= '\n Other Metal ' . $metal['metal'] . ' - ' . $metal['description'] ;
				}
			}

		}
		$this->session->data[ 'LotNoCost-' . $this->request->get['product_id'] .'-1' ] = 0;
		$gemstones = $this->model_catalog_product->getProductGemstonesAvalability($this->request->get['product_id']);
		foreach ($gemstones as $gemstone) {	// Load Gemstone Metal Data
			if( ($gemstone['gem'] !=1 && $gemstone['defaultnew']) ||
				($gemstone['gem'] ==1 && isset($this->request->get['g1']) && ( $gemstone['gemstone_id'] == $this->request->get['g1']) ) ||
				($gemstone['gem'] ==1 && !isset($this->request->get['g1']) && $gemstone['defaultnew'] ))
			//	if( $gemstone['defaultnew'] )
			{
				//echo '<br>session gem1:' . '-' . $gemstone['gem'] . '-'  . $this->request->get['g1'] . '-' . $gemstone['product_gemavail_id'];

				$product_details[] = array(
					'type' => 'G',
					'id' => $gemstone['gem'],
					'value' => $gemstone['product_gemavail_id'],
					'image' => $gemstone['image'],
					'name' => $gemstone['gemname']

				);
				$prdname = $prdname . '_G' . $gemstone['gem'] . '-' . $gemstone['product_gemavail_id'];
				if($gemstone['gem']==1){
					$this->session->data['DefaultGem1Name']=$gemstone['gemname'];
					$prdoptionname .= '\n Centre Gemstone ' . ' - ' . $gemstone['gemname'] ;
				}else{
					$prdoptionname .= '\n Accent Gemstones ' . $gemstone['gem'] . ' - ' . $gemstone['gemname'] ;
				}
				//echo '<br>session gem1:'. $gemstone['gem'] . $gemstone['image'];
			}
		}
	}else{

		$metals = $this->model_catalog_product->getProductMetalAvalability($this->request->get['product_id']);
		foreach ($metals as $metal) {	// Load Default Metal Data
			$pos = strpos($cartImage, $metal['product_metalavail_id'] );
			if ($pos !== false)
			{
				$product_details[] = array(
					'type' => 'M',
					'id' => $metal['metal'],
					'value' => $metal['product_metalavail_id'],
					'image' => $metal['image'],
					'price' => $metal['price'],
					'name' => $metal['description']

				);
				//if(isset($this->request->get['errorlog']))$this->log->write('xxx - '. $metal['metal'] . '='. $metal['product_metalavail_id'] );
				$prdname = $prdname . '_M' . $metal['metal'] . '-' . $metal['product_metalavail_id'];
				if($metal['metal']==1){
					$this->session->data['DefaultMetal1Name']=$metal['description'];
					$prdoptionname .= '\n Primary Metal' . ' - ' . $metal['description'] ;
				}else{
					$prdoptionname .= '\n Other Metal ' . $metal['metal'] . ' - ' . $metal['description'] ;
				}
			}
		}
		$gemstones = $this->model_catalog_product->getProductGemstonesAvalability($this->request->get['product_id']);
		foreach ($gemstones as $gemstone) {	// Load Gemstone Metal Data
			$pos = strpos($cartImage, $gemstone['product_gemavail_id'] );
			if ($pos !== false) {
				$product_details[] = array(
					'type' => 'G',
					'id' => $gemstone['gem'],
					'value' => $gemstone['product_gemavail_id'],
					'image' => $gemstone['image'],
					'name' => $gemstone['gemname']
				);
//					if(isset($this->request->get['errorlog']))$this->log->write('xxx - '. $gemstone['gem'] . '=' . $gemstone['product_gemavail_id'] );
				$prdname = $prdname . '_G' . $gemstone['gem'] . '-' . $gemstone['product_gemavail_id'];
				if($gemstone['gem']==1){
					$this->session->data['DefaultGem1Name']=$gemstone['gemname'];
					$prdoptionname .= '\n  Center Gemstone ' .' - ' . $gemstone['gemname'] ;
				}else{
					$prdoptionname .= '\n  Accent Gemstone ' . $gemstone['gem'] . ' - ' . $gemstone['gemname'] ;
				}
			}
		}
	}





		for($i=1;$i<=$imageCount;$i++){
			$prdname_AddlImage[$i] = $prdname . $i .'.png';
		}
		$prdname = $prdname .'.png';


		$this->session->data['product_details']=$product_details;

		//	$product_db_image = $this->session->data[$this->request->get['product_id'].'new_product_image'];
		//	if(isset($this->request->get['errorlog']))$this->log->write($product_db_image . " === " . 'data/'. $prdname );
		//	if( isset($this->session->data[$this->request->get['product_id'].'new_product_image']) ) // && (strlen($this->session->data[$this->request->get['product_id'].'new_product_image'])-strlen($prdname) <= 3)  )

		if(true){

			//$this->load->model('tool/image1');
			$RRPVarcost = 0;
			$WPVarcost = 0;
			$im ='';
			$stamp='';
			$product_cost=0;
			$im = imagecreatefrompng('./image/catalog/no_image-400x400.png');


			for($i=1;$i<=$imageCount;$i++){
				//$im_AddlImage[$i] = imagecreatefrompng('./image/catalog/no_image.png');
				$im_AddlImage[$i] = imagecreatefrompng('./image/catalog/no_image-400x400.png');
			}

			// Create a New Product Image and update this to database
			$ix=0;
			foreach ($product_details as $product_detail) {
				$cost=0;
				if($product_detail['type']=='M')	// Process the selected metal
			  	{
					$cost = $this->model_catalog_product->getProductMetalCost($product_detail['value']);
					$RRPcost = $this->model_catalog_product->getProductMetalRRPVarCost($product_detail['value']);
					$WPcost = $this->model_catalog_product->getProductMetalWPVarCost($product_detail['value']);
					//$weightcost = $this->model_catalog_product->getMetalWeightCost($product_detail['value']);
					if(isset($this->request->get['errorlog']))$this->log->write(' Select Metal Cost (' . $product_detail['type'] . ' - ' . $product_detail['id'] . ') : ' . $cost );
					//$cost = $metal['price'];
				}else{									// if Metal Selected;
					//$cost = $this->model_catalog_product->getProductGemstoneCost($product_detail['value']);
					//$this->session->data[ 'LotNoCost-' . $this->request->get['product_id'] .'-1' ] = 0;
					if( isset($this->request->get[ 'rno' ]) && $product_detail['id'] == 1) {
						// echo isset($this->request->get[ 'rno' ]) . ' - ' . $product_detail['id'] ;
						$cost = $this->model_catalog_product->getProductGemstoneCostNewV2($product_detail['value'] , "0;3;18;8;0;4;" . $this->request->get[ 'rno' ],"DEFAULT");
					}else{
						$cost = $this->model_catalog_product->getProductGemstoneCostNewV2($product_detail['value'] , "0;3;18;8;0;4;0","DEFAULT");
					}

					$RRPcost = $this->model_catalog_product->getProductGemstoneRRPVarCost($product_detail['value']);
					$WPcost = $this->model_catalog_product->getProductGemstoneWPVarCost($product_detail['value']);
					//$weightcost = $this->model_catalog_product->getGemStoneWeightCost($product_detail['value']);
					if(isset($this->request->get['errorlog']))$this->log->write(' Select Gem Cost (' . $product_detail['type'] . ' - ' . $product_detail['id'] . ') : ' . $cost );
					//$cost = $gemstone['price'];
				}

				$RRPVarcost += $RRPcost;
				$WPVarcost += $WPcost;
				$product_cost += $cost ;
				if(isset($this->request->get['errorlog']))$this->log->write('RRPVar Cost : ' . $RRPVarcost . '   ;   WPVar cost : ' . $WPVarcost);
				$new_product_details[] = array(
					'type'  => $product_detail['type'],
					'id' 	  => $product_detail['id'],
					'value' => $product_detail['value'],
					'name'  => $product_detail['name'],
					'price' => $cost
				);

				// Creating New Product Images
				$new_image  = $this->resize( $product_detail['image'], $this->config->get('config_image_thumb_width'), $this->config->get('config_image_thumb_height') );

				//$stamp = imagecreatefrompng('image/' . $new_image );
				//echo '<br>merging....'.DIR_IMAGE . $new_image;
				$stamp = imagecreatefrompng(DIR_IMAGE . $new_image );
				//$stamp->resize(400, 400);

				$stamp_AddlImage[] = '';

				for($i=1;$i<=$imageCount;$i++){
					$stamp_AddlImage[$i] = '';
					//echo $product_detail['image']. "<br>" . $i . ' - ' . $this->config->get('config_image_thumb_width') . ' - ' . $this->config->get('config_image_thumb_height') . "<br>";
					//echo '<br>xx-'.$this->resize( str_replace('V1','V'.($i+1),$product_detail['image']), $this->config->get('config_image_thumb_width'), $this->config->get('config_image_thumb_height') );
					$new_image  = $this->resize( str_replace('V1','V'.($i+1),$product_detail['image']), $this->config->get('config_image_thumb_width'), $this->config->get('config_image_thumb_height') );
					//$stamp_AddlImage[$i] = imagecreatefrompng('image/' . $new_image );
					if($new_image != ''){
						//echo '<br>new_image - ' . $new_image . '<br>' . ' $product_detail[image] - ' . $product_detail['image'];
						$TImage = trim(DIR_IMAGE . $new_image);
						//echo '<br>TImage - ' . $TImage . '<br>' . ' $product_detail[image] - ' . $product_detail['image'];
						$stamp_AddlImage[$i] = imagecreatefrompng( $TImage );
					}
				}

				$marge_right = 0;
				$marge_bottom = 0;
				$sx = imagesx($stamp);
				$sy = imagesy($stamp);
				imagecopy($im, $stamp, imagesx($im) - $sx - $marge_right, imagesy($im) - $sy - $marge_bottom, 0, 0, imagesx($stamp), imagesy($stamp));
				if(isset($this->request->get['errorlog']))$this->log->write( 'imageCount : '. $imageCount );
				for($i=1;$i<=$imageCount;$i++){
					// echo "<br>xx---- " . DIR_IMAGE . $im_AddlImage[$i];
					 if (!file_exists(DIR_IMAGE . $im_AddlImage[$i]) || !is_file(DIR_IMAGE . $im_AddlImage[$i] )) continue;
					// if($new_image != ''){}
					$sx = imagesx($stamp_AddlImage[$i]);
					$sy = imagesy($stamp_AddlImage[$i]);
					imagecopy($im_AddlImage[$i], $stamp_AddlImage[$i], imagesx($im_AddlImage[$i]) - $sx - $marge_right, imagesy($im_AddlImage[$i]) - $sy - $marge_bottom, 0, 0, imagesx($stamp_AddlImage[$i]), imagesy($stamp_AddlImage[$i]));
				}
				$ix++ ;
			}

			$this->session->data['product_details']=$new_product_details;
			if(isset($this->request->get['errorlog']))$this->log->write( 'Product cost : '. $product_cost );

			$product_SettingCost=$this->model_catalog_product->getProductSettingCost($this->request->get['product_id']);
			$product_cost += $product_SettingCost;
			if(isset($this->request->get['errorlog']))$this->log->write( 'Labour Setting Cost Calculated : '. $product_SettingCost );

			$product_weightCost=$this->model_catalog_product->getProductWeightCost($this->request->get['product_id']);
			$product_cost += $product_weightCost;

			if(isset($this->request->get['errorlog']))$this->log->write( 'WeightCost Calculated : '. $product_weightCost );
			if(isset($this->request->get['errorlog']))$this->log->write( 'Login Product Cost : '. $product_cost );

			$product_cost = $this->currency->convert($product_cost, $this->currency->getCode(),$this->config->get('config_currency'));
			if(isset($this->request->get['errorlog']))$this->log->write('AUD Product Cost :' . $product_cost );

			if( (int)$this->config->get('pricelimit_four') <= (int)$product_cost  ){
				$additional = (int)$this->config->get('additionalcost_five') ;
			}else if( (int)$this->config->get('pricelimit_three') <= $product_cost ){
				$additional = (int)$this->config->get('additionalcost_four') ;
			}else if( (int)$this->config->get('pricelimit_two') <= $product_cost ){
				$additional = (int)$this->config->get('additionalcost_three') ;
			}else if( (int)$this->config->get('pricelimit_one') <= $product_cost ){
				$additional = (int)$this->config->get('additionalcost_two') ;
			}else{
				$additional = (int)$this->config->get('additionalcost_one') ;
			}

			$product_cost = $additional  + $product_cost ;
		 	if(isset($this->request->get['errorlog']))$this->log->write( 'Additional Cost  : '. $additional . ' ; Additional Cost Added : '. $product_cost );
			$product_cost_withoutmarkup = $product_cost;

			$product_cost=$this->model_catalog_product->getProductMarkupCost($this->request->get['product_id'],$product_cost );
			$product_cost_wholesaler=$this->model_catalog_product->getProductMarkupCostWholesaler($this->request->get['product_id'],$product_cost_withoutmarkup );

			if(isset($this->request->get['errorlog']))$this->log->write( 'Product WP Price  : '. $product_cost_wholesaler . ' ; WPVarcost ' . $WPVarcost );
			$product_cost_wholesaler=$this->model_catalog_product->getRoundUp5Cost($product_cost_wholesaler + $WPVarcost );
			if(isset($this->request->get['errorlog']))$this->log->write( 'Before RRPVarcost Price  : '. $product_cost  . ' ; RRPVarcost ' . $RRPVarcost  );

			$product_cost=$this->model_catalog_product->getRoundUp5Cost($product_cost + $RRPVarcost);
			$product_cost_excl_diamond = $product_cost ;
			$diamond_only_cost = 0;
			$diamond_only_cost_wholesale = 0;
			$product_cost_excl_wholesaler=0;
			if(isset($this->request->get['errorlog']))$this->log->write( 'diamondPrice - '. $this->session->data[ 'LotNoCost-' . $this->request->get['product_id'] .'-1' ]);

			if(isset($this->session->data[ 'LotNoCost-' . $this->request->get['product_id'] .'-1' ]) && $this->session->data[ 'LotNoCost-' . $this->request->get['product_id'] .'-1' ] != '0'){
				$diamondPrice=explode(";",$this->session->data[ 'LotNoCost-' . $this->request->get['product_id'] .'-1' ]);
				$data['rapnet_lot_no'] = $this->session->data[ 'LotNo-' . $this->request->get['product_id'] .'-1' ];
				$prdoptionname = $prdoptionname . ' \n Diamond Stock ID : ' . $data['rapnet_lot_no'];
				if(isset($this->request->get['errorlog']))$this->log->write( 'Calculated Diamond Price - '. $diamondPrice[0]	);
				$product_cost = $product_cost + $diamondPrice[0];
				$product_cost_excl_wholesaler = $product_cost_wholesaler ;
				$product_cost_wholesaler= $product_cost_wholesaler + $diamondPrice[1];

				//$product_cost_excl_diamond = $product_cost ;
				$diamond_only_cost = $diamondPrice[0];
				$diamond_only_cost_wholesale = $diamondPrice[1];
			}

			if(isset($this->request->get['errorlog']))$this->log->write( '-------------------------------------------' );
			if(isset($this->request->get['errorlog']))$this->log->write( 'Product Final Price (D) : '. $product_cost );
			if(isset($this->request->get['errorlog']))$this->log->write( 'Product Final Price (Wholesaler) (D) : '. $product_cost_wholesaler );
			if(isset($this->request->get['errorlog']))$this->log->write( '-------------------------------------------' );
			// echo  $product_cost . ' ' .  $product_cost_wholesaler ; 
			$this->model_catalog_product->updateProductPrice($this->request->get['product_id'],$product_cost,$prdoptionname);

			// Additional Image Generation - Initial Page Load
			//$newimagename = 'image/TEMP/'. $prdname;
			$newimagename = DIR_IMAGE . 'TEMP/' . $prdname;
			//echo '<br>im....'.$im;
			/*imagepng($im , $newimagename);
			$this->png2jpg(DIR_IMAGE . 'TEMP/' .  $prdname, DIR_IMAGE . 'TEMP/' . $prdname . '.jpg'  , 75);
			imagedestroy($im); */

			/*
			for($i=1;$i<=$imageCount;$i++){
				//$newimagename_1 = 'image/TEMP/'. $prdname_AddlImage[$i];
				$newimagename_1 = DIR_IMAGE. 'TEMP/'. $prdname_AddlImage[$i];
				// echo "<br>". $imageCount . "-". $i. DIR_IMAGE. 'TEMP/'. $prdname_AddlImage[$i];
				imagepng($im_AddlImage[$i] , $newimagename_1);

				if($i>=3){
					// $this->png2jpg(DIR_IMAGE. 'TEMP/' .  $prdname_AddlImage[$i], DIR_IMAGE. 'TEMP/' . $prdname_AddlImage[$i] . '1.jpg'  , 75);
				}else{
					// $this->png2jpg(DIR_IMAGE. 'TEMP/' .  $prdname_AddlImage[$i], DIR_IMAGE. 'TEMP/' . $prdname_AddlImage[$i] . '.jpg'  , 75);
				}
				imagedestroy($im_AddlImage[$i]);
			}
			*/

			$product_cost = round($product_cost);
			$prdname_nopng=str_replace(".png", "", $prdname );

			/*
			$this->ImageFlip(DIR_IMAGE. 'TEMP/' . $prdname_nopng  . "3.png.jpg" , 2  );
			copy(DIR_IMAGE. 'TEMP/' . $prdname_nopng . "2.png.jpg" ,  DIR_IMAGE. 'TEMP/' . $prdname_nopng . "4.png.jpg" );
			$this->rotateImage(DIR_IMAGE. 'TEMP/' . $prdname_nopng . "2.png.jpg", DIR_IMAGE. 'TEMP/' . $prdname_nopng . "4.png.jpg" , 90);
			copy(DIR_IMAGE. 'TEMP/' . $prdname_nopng . "1.png.jpg" ,  DIR_IMAGE. 'TEMP/' . $prdname_nopng . "5.png.jpg" );
			$this->ImageFlip(DIR_IMAGE. 'TEMP/' . $prdname_nopng . "5.png.jpg" , 1  );
			*/

			$this->session->data[$this->request->get['product_id'].'new_price']= $product_cost;
			$this->session->data[$this->request->get['product_id'].'new_price_whole']= $product_cost_wholesaler;
			$this->session->data[$this->request->get['product_id'].'new_price_exclude_markup']= $product_cost_withoutmarkup;
			$this->session->data[$this->request->get['product_id'].'prdoptionname']= $prdoptionname;
			//echo '<br>session image:'.$this->session->data[$this->request->get['product_id'].'new_product_image'];
			$this->session->data[$this->request->get['product_id'].'new_product_image']= 'TEMP/' . $prdname ;
			$this->session->data[$this->request->get['product_id'].'new_product_image_jpg']= 'TEMP/' . $prdname . '.jpg' ;

			$this->session->data[$this->request->get['product_id'].'product_cost_excl_diamond']= $product_cost_excl_diamond;
			$this->session->data[$this->request->get['product_id'].'diamond_only_cost']= $diamond_only_cost;
			$this->session->data[$this->request->get['product_id'].'product_cost_excl_wholesaler']= $product_cost_excl_wholesaler;
			$this->session->data[$this->request->get['product_id'].'diamond_only_cost_wholesale']= $diamond_only_cost_wholesale;
		}
	}

	public function rotateImage($source, $target, $angle) {
			$rotate_source = imagecreatefromjpeg($source);			// Load
			$rotate = imagerotate($rotate_source, $angle, 0);														// Rotate
			imagejpeg($rotate,$target );								// Output
	}

	public function resize($filename, $width, $height) {
		if(isset($this->request->get['errorlog']))$this->log->write( $filename );
		// $json['newimage'] = str_replace('/home3/','/home5/',$json['newimage']);

		$filename=str_replace('/home5/astral/public_html/chameleonrocks/', '', $filename);
		if(isset($this->request->get['errorlog']))$this->log->write(  $filename );

		if (!file_exists(DIR_IMAGE . $filename) || !is_file(DIR_IMAGE . $filename)) {
			if(isset($this->request->get['errorlog']))$this->log->write(' Image Not found : ' . DIR_IMAGE . $filename );
			$this->log->write('File Missing: ' . DIR_IMAGE . $filename);
			return ;
		}

		//$this->log->write( DIR_IMAGE . $filename );
		$info = pathinfo($filename);
		$extension = $info['extension'];

		$old_image = $filename;
		//$new_image = 'cache/' . utf8_substr($filename, 0, strrpos($filename, '.')) . '-' . $width . 'x' . $height . '.' . $extension;
		$new_image = 'cache/' . utf8_substr($filename, 0, strrpos($filename, '.')) . '-' . $width . 'x' . $height . '.' . $extension;
		//echo '<br>old-'.$old_image;
		//echo '<br>new- ' . $new_image. '<br>';

		if (!file_exists(DIR_IMAGE . $new_image) || (filemtime(DIR_IMAGE . $old_image) > filemtime(DIR_IMAGE . $new_image))) {
			$path = '';

			$directories = explode('/', dirname(str_replace('../', '', $new_image)));

			foreach ($directories as $directory) {
				$path = $path . '/' . $directory;

				if (!file_exists(DIR_IMAGE . $path)) {
					@mkdir(DIR_IMAGE . $path, 0777);
				}
			}

			//echo '<br>--'.DIR_IMAGE . $old_image ;

			$image = new Image(DIR_IMAGE . $old_image);
			$image->resize($width, $height);
			$image->save(DIR_IMAGE . $new_image);
		}


		if (isset($this->request->server['HTTPS']) && (($this->request->server['HTTPS'] == 'on') || ($this->request->server['HTTPS'] == '1'))) {
			//echo '<br> newreturn -'.$new_image . '<br>';
			return   $new_image;
		} else {
			//echo '<br> newreturnElse -'.$new_image . '<br>';
			return   $new_image;
		}
	}



	public function vflipImage($source,$target) {

		 $flimage = new Gmagick();
		 $flimage->readImage($source);			// read image file
  		 $flimage->flipImage();					// flip image vertically
  		 $flimage->writeImage($target); 		// write new image file
		 $image->destroy();
	}

	public function hflipImage($source,$target) {

		 $flimage = new Gmagick();
		 $flimage->readImage($source);			// read image file
  		 $flimage->flopImage();					// flip image vertically
  		 $flimage->writeImage($target); 		// write new image file
		 $flimage->destroy();

	}

	public function ImageFlip( $source, $mode ){
		$source = str_replace('/home3/','/home5/',$source );
		//echo '---'.$source;
		if(isset($this->request->get['errorlog']))$this->log->write( 'Flipping : ' . $source );
		if (!file_exists($source) )return;
		$imgsrc = ImageCreateFromJpeg(  $source );

		$width                        =    imagesx ( $imgsrc );
		$height                       =    imagesy ( $imgsrc );

		$src_x                        =    0;
		$src_y                        =    0;
		$src_width                    =    $width;
		$src_height                   =    $height;

		switch ( (int) $mode )
		{
			case 1:
				$src_y                =    $height -1;
				$src_height           =    -$height;
			break;

			case 2:
				$src_x                =    $width -1 ;
				$src_width            =    -$width;
			break;

			case 3:
				$src_x                =    $width;
				$src_y                =    $height;
				$src_width            =    0-$width;
				$src_height           =    0-$height;
			break;

			default:
				return $imgsrc;
		}
		$imgdest = imagecreatetruecolor ( $width, $height );
		imagecopyresampled( $imgdest, $imgsrc, 0, 0, $src_x, $src_y, $width, $height, $src_width, $src_height )  ;
		imagejpeg( $imgdest, $source, 100 );
		//$this->log->write( 'Flipping : ' . $imgdest );
    }


	public function imagechange() {
		if(isset($this->request->get['errorlog']))$this->log->write(  $this->request->post['metal_number'] . ' is metal number' );
		$addImage=$this->request->post['myimg'];
		$addImage = str_replace('http://www.chameleon.rocks/','',$addImage);
		$addImage = str_replace('http://chameleon.rocks/','',$addImage);
		$product_cost_data=explode(';',$this->AddImage($addImage,$this->request->post['metal_number'],$this->request->post['rapnetdata'] ) );
		$product_cost=$product_cost_data[0];
		$prdcost_wholesale = 'AJ_' . $product_cost_data[1];
		$prdcost_excl_diamond = $product_cost_data[2];
		$prdcost_diamond_cost = $product_cost_data[3];
		$product_cost_excl_wholesaler = $product_cost_data[4];
		//if(isset($this->request->get['errorlog']))$this->log->write(' prdcost_wholesale - '.$prdcost_wholesale );
		/*
		$product_costdata=$this->AddImage($addImage,$this->request->post['metal_number']);
		$product_cost=explode(';',$product_costdata,0);
		$product_cost=explode(';',$product_costdata,0);
		$product_cost_whole=explode(';',$product_costdata,1);
		*/
		$json = array();
		$json['url'] = "";
		$json['diamondCertificate'] =  "";
		$json['rapnet_lot_no'] =  0;
		$json['diamondVideoURL'] =  "";
		$json['diamondImage'] =  "";
		$json['color'] = "";
		$json['clarity'] = "";
		$json['weight'] = "";
		$json['prdcost_excl_diamond'] = "";
		$json['prdcost_diamond_cost'] = "";
		$json['product_cost_excl_wholesaler'] = "";

		if(isset($this->request->get['errorlog']))$this->log->write(  $this->request->post['metal_number'] . ' is metal number' );

		if(isset($this->request->post['metal_number'])){
		  $gemNumber = trim($this->request->post['metal_number']);
		  if(isset($this->request->get['errorlog']))$this->log->write( 'LotNo-' . $this->request->get['product_id'] . '-' . $gemNumber . '-' . substr($gemNumber, 0,1) );
		  if(substr($gemNumber, 0, 1) == 'G' ){
				if(isset($this->request->get['errorlog']))$this->log->write(  $this->request->post['metal_number'] . ' is metal number' );

				$gemstone_selected=1;
				$selgemstone=explode("-",$gemNumber);
				$id=$selgemstone[1];
				$selected_gemstone_id=$selgemstone[2];
		    if(isset($this->session->data[ 'LotNo-' . $this->request->get['product_id'] . '-' . $selected_gemstone_id]) ){
				if(isset($this->request->get['errorlog']))$this->log->write( 'LotNo-' . $this->request->get['product_id'] . '-' . $selected_gemstone_id . ' session value is ' . $this->session->data[ 'LotNo-' . $this->request->get['product_id'] . '-' . $selected_gemstone_id]  );
				$diamondDetails = array();
				$diamondDetails = $this->model_catalog_product->getRapnetData( $this->session->data[ 'LotNo-' . $this->request->get['product_id'] . '-' . $selected_gemstone_id] );
				$json['diamondDetails'] = $diamondDetails ;

				 //. '<br />Quality : ' . $row['rapnet_quality'] .'<br />Size : ' . $row['rapnet_size'] .'<br />Total Weight : ' . $row['rapnet_weight'] .' carats (approx.)</div>

					$rapnet_url_json  =  '<br />Quality : ' . $diamondDetails['color'] . ' colour ; '  .  $diamondDetails['clarity'] . ' clarity ' ;
					$rapnet_url_json .=  '<br />Size: ' . $diamondDetails['measlength'] . ' x '  .  $diamondDetails['measwidth'] . '  mm ' ;
					$rapnet_url_json .=  '<br />Total Weight : ' . round($diamondDetails['weight'],2)  . '  mm carats (approx.)' ;


				//$json['url'] = $diamondDetails['url'] ;
				if(isset($this->request->get['errorlog']))$this->log->write( 'Certificate URL : '. $diamondDetails['url'] . '-' . $diamondDetails['cert_no']);
				$diamondDetails_url = str_replace("\\", "/", $diamondDetails['url']);
				if($diamondDetails['url']!=''){
					$json['url'] =  "<a onClick=window.open('". $diamondDetails_url . "','Certification','height=550,width=920,top=100,left=200,toolbars=no,menubar=no,location=no,scrollbars=yes,resizable=yes,status=yes')>".$diamondDetails['lab']. ' Certificate: ' . $diamondDetails['cert_no'] ."</a> " . $rapnet_url_json ;
					$json['diamondCertificate'] =  $diamondDetails_url;
				}else{
					$json['url'] =  $diamondDetails['lab']. ' Certificate: ' . $diamondDetails['cert_no'] . $rapnet_url_json ;
				}

				$json['rapnet_lot_no'] =  $diamondDetails['rapnet_lot_no']; ;
				$json['diamondVideoURL'] =  str_replace("\\", "/", $diamondDetails['diamondVideoURL']);
				$json['diamondImage'] = str_replace("\\", "/", $diamondDetails['diamondImage']);
				$json['diamondVideoURL'] =  str_replace("\\", "/", $diamondDetails['diamond_video_url']);
				$json['diamondImage'] = str_replace("\\", "/", $diamondDetails['diamond_image_url']);
				$json['shape'] = str_replace("\\", "/", $diamondDetails['shape']);
				$json['measwidth'] = $diamondDetails['measwidth'];
				$json['measdepth'] = $diamondDetails['measdepth'];
				$json['measlength'] = $diamondDetails['measlength'];
				$json['table'] = round($diamondDetails['table']);
				$json['girdle'] = $diamondDetails['girdle'];
				$json['culet'] = $diamondDetails['culet'];
				$json['depthper'] = round($diamondDetails['depth_percentage']);


				$json['color'] = $diamondDetails['color']  .  " | ";
				$json['clarity'] = $diamondDetails['clarity']  .  " | ";
				$json['weight'] = round($diamondDetails['weight'],2)  .  " CT | " ;
				if(isset($this->request->get['errorlog']))$this->log->write(  'LotNo-' . $this->request->get['product_id'] . '-' . $selected_gemstone_id . "  == lot no == " .  $this->session->data[ 'LotNo-' . $this->request->get['product_id'] . '-' . $selected_gemstone_id] );
				if(isset($this->request->get['errorlog']))$this->log->write(  " URL Value => " . $diamondDetails['seller'] );
				//$value=$selected_gemstone_id;
			}
		  }
		}
		//	$diamondDetails = "Center Gemstone : Diamond <br/>Quality : " . $diamondDetails['clarity'] .'<br />Size : ' . $diamondDetails['size'] .'<br />Shape : ' . $diamondDetails['shape'] .'<br />Total Weight : ' . $diamondDetails['weight'] . ' carats (approx.)<br />Count : ' .  $product_detail['weight'] .' pc<br />Setting : ' . $product_detail['setting'] . '<br /><br />'

		$json['newimage'] = $this->session->data[$this->request->get['product_id'].'new_product_image_jpg'];
		if(isset($this->request->get['errorlog']))$this->log->write('%%%%%%%%%%%%%%%%%%%%%%'. $json['newimage'] . '');
		$json['newimage'] = str_replace('/home3/','/home5/',$json['newimage']);
		$json['newimage'] = str_replace('/home5/astral/public_html/chameleonrocks/image/TEMP/image/',HTTP_IMAGE,$json['newimage']);
		$json['newimage'] = str_replace('/home5/astral/public_html/chameleonrocks/image/',HTTP_IMAGE,$json['newimage']);
		$json['newimage'] = str_replace(DIR_IMAGE,HTTP_IMAGE,$json['newimage']) ;
		if(isset($this->request->get['errorlog']))$this->log->write('%%%%%%%%%%%%%%%%%%%%%%'. $json['newimage'] . '');

		$json['product_cost'] = $this->currency->format($product_cost)  ;
		//$json['product_cost'] = $this->currency->format($this->currency->convert($product_cost,$this->config->get('config_currency'), $this->currency->getCode()), $this->currency->getCode(),'',true);
		//$this->log->write($json['product_cost']. ' -##########- ' . $this->config->get('config_currency') . ' - ' . $this->currency->getCode() . ' - ' . $product_cost );
		$json['prdcost_wholesale'] = $prdcost_wholesale  ;
		if(isset($this->request->get['errorlog']))$this->log->write(' prdcost_wholesale - '.$prdcost_wholesale );

		//$json['prdcost_excl_diamond'] = $prdcost_excl_diamond;
		//$json['prdcost_diamond_cost'] = $prdcost_diamond_cost;
		//$json['product_cost_excl_wholesaler'] = $product_cost_excl_wholesaler;

		$json['prdcost_excl_diamond'] = $this->currency->format($prdcost_excl_diamond);
		$json['prdcost_diamond_cost'] = $this->currency->format($prdcost_diamond_cost);
		$json['product_cost_excl_wholesaler'] = $product_cost_excl_wholesaler;
		$json['product_cost_excl_wholesaler_formatted'] = $this->currency->format($product_cost_excl_wholesaler);

		$json['prdcost'] = $product_cost ;
		$json['optionname'] = $this->session->data[$this->request->get['product_id'].'prdoptionname'] ;
		$this->session->data[$this->request->get['product_id'].'new_price']  = $product_cost ;
		if(isset($this->request->get['errorlog']))$this->log->write( 'back here' );
		if(isset($this->request->get['errorlog']))$this->log->write( $json );



		$this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));
		//$this->response->setOutput(json_encode($json));

	}

	public function AddImage( $addimage,$modelnum , $rapnetdata ) {

		$this->load->model('catalog/product');
		$this->load->model('tool/image');
		$stamp ='';
		$im ='';
		$rotation = $this->model_catalog_product->getProductRotation($this->request->get['product_id']);
		$selected_gemstone_id= 0;
		if(substr($modelnum,  0, 1)=='M'){
			$metal_selected=1;
			$selmetal=explode("-",$modelnum);
			$id=$selmetal[1];
			$selected_metal_id=$selmetal[2];
			$value=$selected_metal_id;
		}else{
			$gemstone_selected=1;
			$selgemstone=explode("-",$modelnum);
			$id=$selgemstone[1];
			$selected_gemstone_id=$selgemstone[2];
			$value=$selected_gemstone_id;
		}
		unset($product_details);

		if(isset($this->session->data[$this->request->get['product_id'].'new_product_image']))
		//if(0)					// Use the Session Data if presents
		{
			$product_details =  array();
			$product_details =  $this->session->data['product_details'];
			//echo "image new_product_image:" . $this->session->data[$this->request->get['product_id'].'new_product_image'];
			if(isset($this->request->get['errorlog']))$this->log->write(' $this->session->data '. $this->session->data[$this->request->get['product_id'].'new_product_image']);
			$product_magex = str_replace( DIR_IMAGE ,'',$this->session->data[$this->request->get['product_id'].'new_product_image']);
			$product_magex = str_replace( 'image/' ,'',$product_magex);
			//echo "image product_magex:" . $product_magex;
			$product_mage  = $this->resize( $product_magex , $this->config->get('config_image_thumb_width'), $this->config->get('config_image_thumb_height') );
			//echo "image product_mage:" . $product_mage;
			$im = imagecreatefrompng(DIR_IMAGE . $product_mage );


	/*
			$product_magex1 = str_replace(".png", "1.png",str_replace(DIR_IMAGE,'',$this->session->data[$this->request->get['product_id'].'new_product_image']));
			$product_magex1 = str_replace('image/','',$product_magex1);
			$product_mage1  = $this->resize( $product_magex1 , $this->config->get('config_image_thumb_width'), $this->config->get('config_image_thumb_height') );
			$im1 = imagecreatefrompng(DIR_IMAGE . $product_mage1 );

			$product_magex2 = str_replace(".png", "2.png",str_replace(DIR_IMAGE,'',$this->session->data[$this->request->get['product_id'].'new_product_image']));
			$product_magex2 = str_replace('image/','',$product_magex2);
			$product_mage2  = $this->resize( $product_magex2 , $this->config->get('config_image_thumb_width'), $this->config->get('config_image_thumb_height') );
			$im2 = imagecreatefrompng(DIR_IMAGE . $product_mage2 );

			if($rotation==1){
			$product_magex3 = str_replace(".png", "3.png",str_replace(DIR_IMAGE,'',$this->session->data[$this->request->get['product_id'].'new_product_image']));
			$product_magex3 = str_replace('image/','',$product_magex3);
			$product_mage3  = $this->resize( $product_magex3 , $this->config->get('config_image_thumb_width'), $this->config->get('config_image_thumb_height') );
			$im3 = imagecreatefrompng( DIR_IMAGE . $product_mage3 );


			$product_magex4 = str_replace(".png", "4.png",str_replace(DIR_IMAGE,'',$this->session->data[$this->request->get['product_id'].'new_product_image']));
			$product_magex4 = str_replace('image/','',$product_magex4);
			$product_mage4  = $this->resize( $product_magex4 , $this->config->get('config_image_thumb_width'), $this->config->get('config_image_thumb_height') );
			$im4 = imagecreatefrompng( DIR_IMAGE . $product_mage4 );
			}

			*/
			if(isset($this->request->get['errorlog']))$this->log->write('In Session Image : ' . $product_mage);
		}else{					// Creates the Session Data

		}

		// Product Details ready for usage
		unset($new_product_details);
		$prdname=$this->request->get['product_id'];
		//if(isset($this->request->get['errorlog']))$this->log->write('Size Of :'.sizeof($product_details));
		$product_cost=0;
		$WPVarcost = 0;
		$RRPVarcost = 0;
		if(isset($this->request->get['errorlog']))$this->log->write('--------------------------------------' );
		$prdoptionname='';
		foreach ($product_details as $product_detail) {

			if($product_detail['type']==substr($modelnum,0, 1) && $product_detail['id']==$id)	// Process the selected metal
			{
				$cost=0;
				if(substr($modelnum,0, 1)=='M'){		// if Metal Selected;
					$metals = $this->model_catalog_product->getProductMetalAvalability($this->request->get['product_id']);
					foreach ($metals as $metal) {
						//if(isset($this->request->get['errorlog']))$this->log->write( $metal['product_metalavail_id'] .' == '. $value);
						if( $metal['product_metalavail_id'] == $value )
						{
							if($metal['metal']==1){
								$prdoptionname .= '\n Primary Metal ' . ' - ' . $metal['description']   ;
							}else{
								$prdoptionname .= '\n Other Metal ' . $metal['metal'] . ' - ' . $metal['description']   ;
							}
							$name =  $metal['description'] ;
							$cost = $this->model_catalog_product->getProductMetalCost($value);
							$RRPcost = $this->model_catalog_product->getProductMetalRRPVarCost($value);
							$WPcost = $this->model_catalog_product->getProductMetalWPVarCost($value);
							if(isset($this->request->get['errorlog']))$this->log->write(' Select Metal Cost (' . $product_detail['type'] . ' - ' . $product_detail['id'] . ') : ' . $cost );
							//$cost = $metal['price'];
						}
					}
				}else{									// if Gemstone Selected;
					$gemstones = $this->model_catalog_product->getProductGemstonesAvalability($this->request->get['product_id']);
					foreach ($gemstones as $gemstone) {
						if( $gemstone['product_gemavail_id'] ==  $value  )
						{
							$name =  $gemstone['gemname'] ;
							if(isset($this->request->get['errorlog']))$this->log->write( 'Cost : ' . $value . ' ' . $modelnum );
							if($gemstone['gem']==1){
								$prdoptionname .= '\n Center Gemstone ' . ' - ' . $gemstone['gemname']   ;
								$this->session->data[ 'LotNoCost-' . $this->request->get['product_id'] .'-1' ] = 0;
							}else{
								$prdoptionname .= '\n Accent Gemstone ' . $gemstone['gem'] . ' - ' . $gemstone['gemname']   ;
							}
							//$cost = $this->model_catalog_product->getProductGemstoneCost($value);
							$cost = $this->model_catalog_product->getProductGemstoneCostNewV2($value, $rapnetdata);
							$RRPcost = $this->model_catalog_product->getProductGemstoneRRPVarCost($value);
							$WPcost = $this->model_catalog_product->getProductGemstoneWPVarCost($value);
							if($gemstone['gem']==1 && $gemstone['gemstone_id']  != 9){
								if(isset($this->request->get['errorlog']))$this->log->write(' resetting session variable  ' . $gemstone['gem'] . ' ' . $value . ' ' . $gemstone['gemstone_id'] );
								$this->session->data[ 'LotNoCost-' . $this->request->get['product_id'] .'-1' ] = 0;
								if(isset($this->request->get['errorlog']))$this->log->write(' session variable resetted ');
							}
							if(isset($this->request->get['errorlog']))$this->log->write(' Select Gem Cost (' . $product_detail['type'] . ' - ' . $product_detail['id'] . ') : ' . $cost  );
							//$cost = $gemstone['price'];
						}
					}
				}


				//$product_cost += $product_detail['price'];
				$prdname = $prdname . '_' . substr($modelnum,0,1) . $id . '-' . $value;
				//if(isset($this->request->get['errorlog']))$this->log->write( 'Cost : ' . $cost );
				$product_cost += $cost ;
				$RRPVarcost += $RRPcost ;
				$WPVarcost += $WPcost ;
				if(isset($this->request->get['errorlog']))$this->log->write('RRPVar Cost : ' . $RRPVarcost . '   ;   WPVar cost : ' . $WPVarcost);

				$new_product_details[] = array(
					'type' => $product_detail['type'],
					'id' => $product_detail['id'],
					'value' => $value,
					'name' => $name,
					'price' => $cost
				);

			}else{
//				if(isset($this->request->get['errorlog']))$this->log->write('xxx - '.$product_detail['type'] . $product_detail['id'] . $product_detail['value'] );

				//if($product_detail['price']){
				if(0){
					$itemprice = $product_detail['price'];
				}else{
					if( $product_detail['type']  == 'M'){
						$itemprice = $this->model_catalog_product->getProductMetalCost($product_detail['value']);
						$RRPcost = $this->model_catalog_product->getProductMetalRRPVarCost($product_detail['value']);
						$WPcost = $this->model_catalog_product->getProductMetalWPVarCost($product_detail['value']);
						if(isset($this->request->get['errorlog']))$this->log->write(' Metal Cost (' . $product_detail['type'] . ' - ' . $product_detail['id'] . ') : ' . $itemprice );
						if($product_detail['id']==1){
							$prdoptionname .= '\n Primary Metal - ' . $product_detail['name'] ;
						}else{
							$prdoptionname .= '\n Metal ' . $product_detail['id'] . ' - ' . $product_detail['name'] ;
						}
					}else{

						if(isset($this->request->get['errorlog']))$this->log->write( 'Cost : ' . $product_detail['value'] );
						if($product_detail['id']==1){
							$prdoptionname .= '\n Center Gemstone - ' . $product_detail['name'] ;
						}else{
							$prdoptionname .= '\n Accent Gemstones ' . $product_detail['id'] . ' - ' . $product_detail['name'] ;
						}
						$itemprice = $this->model_catalog_product->getProductGemstoneCost($product_detail['value']);
						//if($diamondrapnet)
						{
//							$diamondDetails = $this->model_catalog_product->getRapnetData( $this->session->data[ 'LotNo-' . $query->row['product_id'] . '-' . $product_detail['value'] ] );
//							$diamondDetails = "Center Gemstone : Diamond <br/>Quality : " . $diamondDetails['clarity'] .'<br />Size : ' . $diamondDetails['size'] .'<br />Shape : ' . $diamondDetails['shape'] .'<br />Total Weight : ' . $diamondDetails['weight'] . ' carats (approx.)<br />Count : ' .  $product_detail['weight'] .' pc<br />Setting : ' . $product_detail['setting'] . '<br /><br />'
						}
						$itemprice = $this->model_catalog_product->getProductGemstoneCostNewV2($product_detail['value'], $rapnetdata);
						$RRPcost = $this->model_catalog_product->getProductGemstoneRRPVarCost($product_detail['value']);
						$WPcost = $this->model_catalog_product->getProductGemstoneWPVarCost($product_detail['value']);

						//if($product_detail['id']==1 && $product_detail['gemstone_id']  != 9){
						if( $selected_gemstone_id == 1 && $product_detail['gemstone_id']  != 9){

							if(isset($this->request->get['errorlog']))$this->log->write(' resetting session variable at $product_detail  ' . $product_detail['id'] . ' ' . $value . ' ' . $product_detail['gemstone_id'] );
							$this->session->data[ 'LotNoCost-' . $this->request->get['product_id'] .'-1' ] = 0;
							if(isset($this->request->get['errorlog']))$this->log->write(' session variable resetted ');
						}


						if(isset($this->request->get['errorlog']))$this->log->write('RRPVar Cost : ' . $RRPVarcost . '   ;   WPVar cost : ' . $WPVarcost);

						if(isset($this->request->get['errorlog']))$this->log->write(' Gem Cost (' . $product_detail['type'] . ' - ' . $product_detail['id'] . ') : ' . $itemprice );
					}
				}
				$new_product_details[] = array(
					'type' => $product_detail['type'],
					'id' => $product_detail['id'],
					'value' =>  $product_detail['value'],
					'name' =>  $product_detail['name'],
					'price' => $itemprice
				);
				$product_cost += $itemprice;
				$RRPVarcost += $RRPcost ;
				$WPVarcost += $WPcost ;

				$prdname = $prdname . '_' . $product_detail['type'] . $product_detail['id'] . '-' . $product_detail['value'];
			}
		}

/*
		$string1=substr($modelnum,0, 1) . $id . '-';
		$start_pos=strpos($prdname, $string1 );
		$next_pos=strpos( $prdname , '_' , $start_pos  );
		$source = substr($prdname,$start_pos ,$next_pos-$start_pos);
		$prdname = str_replace($source, $string1.$value,$prdname );
*/
		$prdname = $prdname . '.png' ;
		$prdname_jpg = $prdname . '.jpg' ;

		/*
		$prdname1 =  str_replace(".png", "1.png",$prdname) ;
		$prdname_jpg1 = str_replace(".jpg", "1.jpg",$prdname_jpg) ;
		$prdname2 =  str_replace(".png", "2.png",$prdname) ;
		$prdname_jpg2 = str_replace(".jpg", "2.jpg",$prdname_jpg) ;

		if($rotation==1){
			$prdname3 =  str_replace(".png", "3.png",$prdname) ;
			$prdname_jpg3 = str_replace(".jpg", "3.jpg",$prdname_jpg) ;
			$prdname4 =  str_replace(".png", "4.png",$prdname) ;
			$prdname_jpg4 = str_replace(".jpg", "4.jpg",$prdname_jpg) ;
		}
		*/

		if(isset($this->request->get['errorlog']))$this->log->write($prdname  . ' vs ' . $prdname_jpg);
		$product_details = $new_product_details;

		unset($this->session->data['product_details']);
		$this->session->data['product_details']=$new_product_details;

	//	$stamp = imagecreatefrompng('./'.$addimage);
		//$stamp = imagecreatefrompng($addimage);

		//$stamp1 = imagecreatefrompng(str_replace("V1", "V2",$addimage));
		//$stamp2 = imagecreatefrompng(str_replace("V1", "V2",$addimage));


		$addimageX  = $this->resize(str_replace('image/','', $addimage ), $this->config->get('config_image_thumb_width'), $this->config->get('config_image_thumb_height') );
		if(isset($this->request->get['errorlog']))$this->log->write('------------'.DIR_IMAGE . $addimageX);
		//$stamp = imagecreatefrompng(  'image/' . $addimageX );
		$stamp = imagecreatefrompng( DIR_IMAGE . $addimageX );
		//echo DIR_IMAGE . $addimageX . '<br>' .   $addimage . '<br>';

		/*
		$addimageX1  = $this->resize(str_replace('image/','', str_replace("V1", "V2",$addimage) ), $this->config->get('config_image_thumb_width'), $this->config->get('config_image_thumb_height') );
		//$stamp1 = imagecreatefrompng(  'image/' . $addimageX1 );
		//echo DIR_IMAGE . $addimageX . '<br>' .   $addimageX1 . '<br>';

		if (file_exists(DIR_IMAGE . $addimageX1 ) && $addimageX1 != '') 	$stamp1 = imagecreatefrompng(  DIR_IMAGE . $addimageX1 );

		$addimageX2 = $this->resize(str_replace('image/','', str_replace("V1", "V3",$addimage) ), $this->config->get('config_image_thumb_width'), $this->config->get('config_image_thumb_height') );
		//$stamp2 = imagecreatefrompng(  'image/' . $addimageX2 );
		if (file_exists(DIR_IMAGE . $addimageX2 ) && $addimageX2 != '') $stamp2 = imagecreatefrompng(  DIR_IMAGE . $addimageX2 );

		if($rotation==1){
			$addimageX3 = $this->resize(str_replace('image/','', str_replace("V1", "V4",$addimage) ), $this->config->get('config_image_thumb_width'), $this->config->get('config_image_thumb_height') );
			//$stamp3 = imagecreatefrompng(  'image/' . $addimageX3 );
			if (file_exists(DIR_IMAGE . $addimageX3 ) && $addimageX3 != '') $stamp3 = imagecreatefrompng(  DIR_IMAGE . $addimageX3 );

			$addimageX4 = $this->resize(str_replace('image/','', str_replace("V1", "V5",$addimage) ), $this->config->get('config_image_thumb_width'), $this->config->get('config_image_thumb_height') );
			//$stamp4 = imagecreatefrompng(  'image/' . $addimageX4);
			if (file_exists(DIR_IMAGE . $addimageX4 ) && $addimageX4 != '') 	$stamp4 = imagecreatefrompng(  DIR_IMAGE . $addimageX4);
		}
		*/

		$marge_right = 0;
		$marge_bottom = 0;
		$sx = imagesx($stamp);
		$sy = imagesy($stamp);
		imagecopy($im, $stamp, imagesx($im) - $sx - $marge_right, imagesy($im) - $sy - $marge_bottom, 0, 0, imagesx($stamp), imagesy($stamp));

		/*
		if (file_exists(DIR_IMAGE . $addimageX1 )  && $addimageX1 != '') 	{
			$sx1 = imagesx($stamp1);
			$sy1 = imagesy($stamp1);
			imagecopy($im1, $stamp1, imagesx($im1) - $sx1 - $marge_right, imagesy($im1) - $sy1 - $marge_bottom, 0, 0, imagesx($stamp1), imagesy($stamp1));
		}


		if (file_exists(DIR_IMAGE . $addimageX2 )  && $addimageX2 != '') 	{
			$sx2 = imagesx($stamp2);
			$sy2 = imagesy($stamp2);
			imagecopy($im2, $stamp2, imagesx($im2) - $sx2 - $marge_right, imagesy($im2) - $sy2 - $marge_bottom, 0, 0, imagesx($stamp2), imagesy($stamp2));
		}

		if($rotation==1){
			if (file_exists(DIR_IMAGE . $addimageX3 )  && $addimageX3 != '') 	{
				$sx3 = imagesx($stamp3);
				$sy3 = imagesy($stamp3);
				imagecopy($im3, $stamp3, imagesx($im3) - $sx3 - $marge_right, imagesy($im3) - $sy3 - $marge_bottom, 0, 0, imagesx($stamp3), imagesy($stamp3));
			}
			if (file_exists(DIR_IMAGE . $addimageX4 )  && $addimageX4 != '	') 	{
				$sx4 = imagesx($stamp4);
				$sy4 = imagesy($stamp4);
				imagecopy($im4, $stamp4, imagesx($im4) - $sx4 - $marge_right, imagesy($im4) - $sy4 - $marge_bottom, 0, 0, imagesx($stamp4), imagesy($stamp4));
			}
		}
		*/

		if(isset($this->request->get['errorlog']))$this->log->write( 'Metal and Gem : '. $product_cost );

		$product_SettingCost=$this->model_catalog_product->getProductSettingCost($this->request->get['product_id']);
		$product_cost += $product_SettingCost;
		if(isset($this->request->get['errorlog']))$this->log->write( 'Setting Cost Calculated : '. $product_SettingCost );

		$product_weightCost=$this->model_catalog_product->getProductWeightCost($this->request->get['product_id']);
		$product_cost += $product_weightCost;

		if(isset($this->request->get['errorlog']))$this->log->write( 'WeightCost Calculated : '. $product_weightCost );
		if(isset($this->request->get['errorlog']))$this->log->write( 'Login Product Cost : '. $product_cost );


		//$product_cost = $this->currency->convert($product_cost, $this->currency->getCode(),'AUD');
		$product_cost = $this->currency->convert($product_cost, $this->currency->getCode(),$this->config->get('config_currency'));
		if(isset($this->request->get['errorlog']))$this->log->write('AUD Product Cost :' . $product_cost );

		if( (int)$this->config->get('pricelimit_four') <= $product_cost ){
			$additional = (int)$this->config->get('additionalcost_five') ;
		}else if( (int)$this->config->get('pricelimit_three') <= $product_cost ){
			$additional = (int)$this->config->get('additionalcost_four') ;
		}else if( (int)$this->config->get('pricelimit_two') <= $product_cost ){
			$additional = (int)$this->config->get('additionalcost_three') ;
		}else if( (int)$this->config->get('pricelimit_one') <= $product_cost ){
			$additional = (int)$this->config->get('additionalcost_two') ;
		}else{
			$additional = (int)$this->config->get('additionalcost_one') ;
		}


		//$product_cost = $this->config->get('additionalCosts')  + $product_cost ;
		$product_cost = $additional  + $product_cost ;
		if(isset($this->request->get['errorlog']))$this->log->write( 'Additional Cost  : '. $additional . ' ; Additional Cost Added : '. $product_cost );
		$product_cost_wholesaler = $product_cost;
		$product_cost=$this->model_catalog_product->getProductMarkupCost($this->request->get['product_id'],$product_cost );
		$product_cost_wholesaler=$this->model_catalog_product->getProductMarkupCostWholesaler($this->request->get['product_id'],$product_cost_wholesaler );

		if(isset($this->request->get['errorlog']))$this->log->write( 'Product WP Price  : '. $product_cost_wholesaler . ' ; WPVarcost ' . $WPVarcost );
		$product_cost_wholesaler=$this->model_catalog_product->getRoundUp5Cost($product_cost_wholesaler + $WPVarcost );
		if(isset($this->request->get['errorlog']))$this->log->write( 'Before RRPVarcost Price  : '. $product_cost  . ' ; RRPVarcost ' . $RRPVarcost  );
		$product_cost=$this->model_catalog_product->getRoundUp5Cost($product_cost + $RRPVarcost);

		if(isset($this->request->get['errorlog']))$this->log->write( 'diamondPrice - '. $this->session->data[ 'LotNoCost-' . $this->request->get['product_id'] .'-1' ]);
		$product_cost_excl_diamond = $product_cost;
		$diamond_only_cost = 0;
		$product_cost_excl_wholesaler = 0;
		if(isset($this->session->data[ 'LotNoCost-' . $this->request->get['product_id'] .'-1' ]) && $this->session->data[ 'LotNoCost-' . $this->request->get['product_id'] .'-1' ] != '0'){
			$diamondPrice=explode(";",$this->session->data[ 'LotNoCost-' . $this->request->get['product_id'] .'-1' ]);
			if(isset($this->request->get['errorlog']))$this->log->write( 'Calculated Diamond Price - '. $diamondPrice[0]	);
			$product_cost = $product_cost + $diamondPrice[0];

			$product_cost_excl_wholesaler = $product_cost_wholesaler ;
			if(isset($this->request->get['errorlog']))$this->log->write( ' product_cost_excl_wholesaler: ' . $product_cost_excl_wholesaler . ' , product_cost_excl_diamond: '. $product_cost_excl_diamond);
			$product_cost_wholesaler= $product_cost_wholesaler + $diamondPrice[1];

			//$product_cost_excl_diamond = $product_cost ;
			$diamond_only_cost = $diamondPrice[0];
		}

		if(isset($this->request->get['errorlog']))$this->log->write( '-------------------------------------------' );
		if(isset($this->request->get['errorlog']))$this->log->write( 'Product Final Price : '. $product_cost );
		if(isset($this->request->get['errorlog']))$this->log->write( 'Product Final Price (Wholesaler) : '. $product_cost_wholesaler );
		if(isset($this->request->get['errorlog']))$this->log->write( '-------------------------------------------' );

		//$newimagename=$this->request->get['product_id']. '-' . $modelnum .'-newimage1.png';
		$newimagename=$prdname;
		$newimagename_jpg=$prdname_jpg;

		//$newimagename='image/TEMP/'.$newimagename;
		$newimagename=DIR_IMAGE.'TEMP/'.$newimagename;
		//$newimagename_jpg='image/TEMP/'.$newimagename_jpg;
		$newimagename_jpg=DIR_IMAGE.'TEMP/'.$newimagename_jpg;
		$newimage = $newimagename;
		imagepng($im , $newimage);

		/*
		 if(isset($this->request->get['errorlog']))$this->log->write( DIR_IMAGE . '----image/TEMP/'.$prdname1 . '  ------' . $im);
		imagepng($im1 , DIR_IMAGE.'TEMP/'.$prdname1 );
		imagepng($im2 , DIR_IMAGE.'TEMP/'.$prdname2 );
		if($rotation==1){
			imagepng($im3 , DIR_IMAGE.'/TEMP/'.$prdname3 );
			imagepng($im4 , DIR_IMAGE.'/TEMP/'.$prdname4 );
		}
		*/

		//if($extension=='PNG' || $extension=='png'){
			$this->png2jpg(DIR_IMAGE. 'TEMP/' .  $prdname, DIR_IMAGE. 'TEMP/' . $prdname_jpg , 75);

			/*
			$this->png2jpg(DIR_IMAGE. 'TEMP/' .  str_replace(".png", "1.png",$prdname)  , DIR_IMAGE. 'TEMP/' . str_replace(".jpg", "1.jpg",$prdname_jpg) , 75);

			$this->png2jpg(DIR_IMAGE. 'TEMP/' .  str_replace(".png", "2.png",$prdname)  , DIR_IMAGE. 'TEMP/' . str_replace(".jpg", "2.jpg",$prdname_jpg) , 75);
			if($rotation==1){
				$this->png2jpg(DIR_IMAGE. 'TEMP/' .  str_replace(".png", "3.png",$prdname)  , DIR_IMAGE. 'TEMP/' . str_replace(".jpg", "11.jpg",$prdname_jpg) , 75);
				$this->png2jpg(DIR_IMAGE. 'TEMP/' .  str_replace(".png", "4.png",$prdname)  , DIR_IMAGE. 'TEMP/' . str_replace(".jpg", "12.jpg",$prdname_jpg) , 75);
			}

			$prdname_nopng=str_replace(".png", "", $prdname );
			copy(DIR_IMAGE. 'TEMP/' . $prdname . '.jpg' ,  DIR_IMAGE. 'TEMP/' . $prdname_nopng . ".png3.jpg" );
			$this->ImageFlip(DIR_IMAGE. 'TEMP/' . $prdname_nopng  .".png3.jpg" , 2  );

			copy(DIR_IMAGE. 'TEMP/' . $prdname_nopng . ".png2.jpg" ,  DIR_IMAGE. 'TEMP/' . $prdname_nopng . ".png4.jpg" );
			$this->rotateImage(DIR_IMAGE. 'TEMP/' . $prdname_nopng . ".png2.jpg", DIR_IMAGE. 'TEMP/' . $prdname_nopng . ".png4.jpg" , 90);

			copy(DIR_IMAGE. 'TEMP/' . $prdname_nopng . ".png1.jpg" ,  DIR_IMAGE. 'TEMP/' . $prdname_nopng . ".png5.jpg" );
			$this->ImageFlip(DIR_IMAGE. 'TEMP/' . $prdname_nopng . ".png5.jpg" , 1  );
			*/


		//}

		//$newimagename_jpg = $this->model_tool_image->resize($product_info['image'], $this->config->get('config_image_thumb_width'), $this->config->get('config_image_thumb_height'));

		imagedestroy($im);
//		unset($this->session->data['product_details']);
//		$this->session->data['product_details']=$new_product_details;
		$this->session->data[$this->request->get['product_id'].'new_product_image']=$newimagename;
		$this->session->data[$this->request->get['product_id'].'new_product_image_jpg']=$newimagename_jpg;
		$this->session->data[$this->request->get['product_id'].'prdoptionname']=$prdoptionname;
		$product_cost = round($product_cost);
		return $product_cost.';'. $product_cost_wholesaler . ';' . $product_cost_excl_diamond . ';' . $diamond_only_cost . ';' . $product_cost_excl_wholesaler ;
	}

	public	function png2jpg($originalFile, $outputFile, $quality) {
			//echo '<br>png2jpg...'.$originalFile;
    		$image = imagecreatefrompng($originalFile);
    		imagejpeg($image, $outputFile, $quality);
    		imagedestroy($image);
	}

	public function captcha() {
		$this->load->library('captcha');
		$captcha = new Captcha();
		$this->session->data['captcha'] = $captcha->getCode();
		$captcha->showImage();
	}



	public function upload() {
		$this->language->load('product/product');

		$json = array();

		if (!empty($this->request->files['file']['name'])) {
			$filename = basename(html_entity_decode($this->request->files['file']['name'], ENT_QUOTES, 'UTF-8'));

			if ((strlen($filename) < 3) || (strlen($filename) > 128)) {
        		$json['error'] = $this->language->get('error_filename');
	  		}

			$allowed = array();

			$filetypes = explode(',', $this->config->get('config_upload_allowed'));

			foreach ($filetypes as $filetype) {
				$allowed[] = trim($filetype);
			}

			if (!in_array(substr(strrchr($filename, '.'), 1), $allowed)) {
				$json['error'] = $this->language->get('error_filetype');
       		}

			if ($this->request->files['file']['error'] != UPLOAD_ERR_OK) {
				$json['error'] = $this->language->get('error_upload_' . $this->request->files['file']['error']);
			}
		} else {
			$json['error'] = $this->language->get('error_upload');
		}

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && !isset($json['error'])) {
			if (is_uploaded_file($this->request->files['file']['tmp_name']) && file_exists($this->request->files['file']['tmp_name'])) {
				$file = basename($filename) . '.' . md5(rand());

				// Hide the uploaded file name sop people can not link to it directly.
				$this->load->library('encryption');

				$encryption = new Encryption($this->config->get('config_encryption'));

				$json['file'] = $encryption->encrypt($file);

				move_uploaded_file($this->request->files['file']['tmp_name'], DIR_DOWNLOAD . $file);
			}

			$json['success'] = $this->language->get('text_upload');
		}

		$this->response->setOutput(json_encode($json));
	}

	public function OrderNowMail() {

				$this->load->model('catalog/product');

				$insertData = '';
				if( isset($this->request->post['Gem1Id']) ){
					$insertData = $insertData . ", G1 = '" . $this->request->post['Gem1Id'] . "', `G1#` = '" . $this->request->post['Gem1Count'] . "', G1WT = '" . $this->request->post['Gem1Wt'] . "'";
				}
				if( isset($this->request->post['Gem2Id']) ) {
					$insertData = $insertData . ", G2 = '" . $this->request->post['Gem2Id'] . "', `G2#` = '" . $this->request->post['Gem2Count'] . "', G2WT = '" . $this->request->post['Gem2Wt'] . "'";
				}
				if( isset($this->request->post['Gem3Id']) ) {
					$insertData = $insertData . ", G3 = '" . $this->request->post['Gem3Id'] . "', `G3#` = '" . $this->request->post['Gem3Count'] . "', G3WT = '" . $this->request->post['Gem3Wt'] . "'";
				}
				if( isset($this->request->post['Gem4Id']) ) {
					$insertData = $insertData . ", G4 = '" . $this->request->post['Gem4Id'] . "', `G4#` = '" . $this->request->post['Gem4Count'] . "', G4WT = '" . $this->request->post['Gem4Wt'] . "'";
				}
				if( isset($this->request->post['Gem5Id']) )	{
					$insertData = $insertData . ", G5 = '" . $this->request->post['Gem5Id'] . "', `G5#` = '" . $this->request->post['Gem5Count'] . "', G5WT = '" . $this->request->post['Gem5Wt'] . "'";
				}
				if( isset($this->request->post['Metal1Id']) ) {
					//$insertData = $insertData . ", M1 = '" . $this->request->post['Metal1Id'] . "', M1Wt = '" . $this->request->post['Metal1Wt'] . "'";
					$insertData = $insertData . ", M1 = '" . $this->request->post['Metal1Id'] . "', M1GrossWt = '" . $this->request->post['Metal1Wt'] . "'";
				}
				if( isset($this->request->post['Metal2Id']) ) {
					//$insertData = $insertData . ", M2 = '" . $this->request->post['Metal2Id'] . "', M2Wt  = '" . $this->request->post['Metal2Wt'] . "'";
					$insertData = $insertData . ", M2 = '" . $this->request->post['Metal2Id'] . "', M2GrossWt  = '" . $this->request->post['Metal2Wt'] . "'";
				}
				//if( isset($this->request->post['Metal3Id']) ) insertData = insertData . ", M3 = '" . $this->request->post['Metal3Id'] . "'";
				//if( isset($this->request->get['Metal4Id']) ) insertData = insertData . ", M4 = '" . $this->request->get['Metal4Id'] . "'";
				$this->log->write('Order Now - insertData : ' . $insertData  );

				$customer_id = $this->request->post['stockist'];


				$this->db->query("INSERT INTO " . DB_PREFIX . "order_stockist SET customized = 0 , image= '". $this->request->post['finalimage'] ."' ,customer_id	 = '" . $customer_id . "', product_id		 = '" . $this->request->get['product_id'] . "',comment	 = '" . $this->request->post['ringcomment'] . "',descr	 = '" . html_entity_decode($this->request->post['productminidescr']) . "',AJ_price	 = '" . $this->request->post['price'] . "' " . $insertData );
				$orderid = $this->db->getLastId();

				$this->db->query("update order_stockist as os, (select o.order_id , round(o.AJ_price * b.gstrate / (100+b.gstrate),2) as gst from order_stockist o, custom_customer_details a, custom_currency_tax b where o.customer_id = a.customerid and a.billingcurrency = b.billingcurrency) as price SET os.gst=price.gst where os.order_id=price.order_id and os.order_id=" . $orderid);

				$customerorderemail = "";
				$customercode = "";

				$CATEGORYLETTER = "";
				$CATEGORYLETTER = $this->model_catalog_product->getProductCategoryCode( $this->request->get['product_id'] );

				$customerDetails = $this->model_catalog_product->getCustomerCode( $customer_id );
				$customized = $this->model_catalog_product->isProductCustomized($orderid, $this->request->get['product_id']);

				$customerEmail = $this->model_catalog_product->getCustomerEmail($customer_id);

				// $this->db->query("update order_stockist set image='". $this->request->post['finalimage'] ."' where order_id= " . $orderid);


				if($customized){
					$this->db->query("update order_stockist set customized=1 where order_id=" . $orderid);
				}else{
					if( $this->request->post['ringsize'] != ' RESTOCK' && $this->request->post['ringsize'] != 'undefined'){
						$this->log->write("Selected Ring Size is " . $this->request->post['ringsize']);
						$this->db->query("update order_stockist set customized = 1 where order_id = '" . $orderid . "'");
					}
				}
				// Below function used to update OrderStockist Gemstone Shapes after new rows are inserted into order stockist table
				// $this->model_catalog_product->updateGemstoneShapes();
				$this->model_catalog_product->updateGemstoneShapes($orderid);

				$customercode = $customerDetails['customercode'];
				$customerorderemail = $customerDetails['orderemail'];

				$mail = new Mail();
				$mail->protocol = $this->config->get('config_mail_protocol');
				$mail->parameter = $this->config->get('config_mail_parameter');
				$mail->hostname = $this->config->get('config_smtp_host');
				$mail->username = $this->config->get('config_smtp_username');
				$mail->password = $this->config->get('config_smtp_password');
				$mail->port = $this->config->get('config_smtp_port');
				$mail->timeout = $this->config->get('config_smtp_timeout');

//				$mail->setTo('soft.technee@gmail.com');
//				$mail->setFrom('soft.technee@gmail.com');

				$mail->setTo($this->config->get('config_email'));
				$mail->setFrom($this->config->get('config_email'));
				$mail->setSender($this->config->get('config_name'));

//				$mail->setTo('soft.technee@gmail.com');
				$subject = str_replace("<br>", "| ", html_entity_decode($this->request->post['productminidescr'])) ;
				$subject = str_replace(" | Center Gemstone", " " . $CATEGORYLETTER  . " | Center",$subject);
				//$subject = ucfirst(str_replace(",", " ",$this->customer->getName())) . ' | Order ' . $orderid . ' | '  . $subject ;
				$subject = date('dMy') . " | " . $customercode . ' | #' . $orderid . ' | '  . $subject ;


				$subject = str_replace("GemStone","",$subject);
				$subject = str_replace("Primary ","",$subject);
				$subject = $subject . " | " . html_entity_decode($this->request->post['ringcomment']);
				//$subject = $subject ;
				$subject = str_replace("Ring Size :","Ring Size:",$subject);
				$subject = str_replace(" | ","|",$subject);
				$subject = str_replace("  "," ",$subject);


				$message = '';
//				$message = 'Dear ' . $this->config->get('config_name') . ' Owner,';
//				$message .= '<br><br>One of Your Stockist clicked <B>ORDER NOW</B> button for the following product. Please review and confirm about this product details.';
				//$message .= '<br><br><b>Name of Stockist:</b> ' . $this->customer->getName() ;
//				$message .= '<br><b>Stockist Id:</b> ' . $this->customer->getId() ;
				//$message .= '<br><b>Stockist Mail:</b> ' . $this->customer->getEmail() ;
				//$message .= '<br><b>Stockist Telephone:</b> ' . $this->customer->getTelephone() ;
				$message .= '<br><b>Product URL:</b> ' . $this->url->link('product/product1', $url . '&product_id=' . $this->request->get['product_id'] ) ;
				$message .= '<br><b>Product Image:</b> ' . $this->request->post['finalimage'] ;
				$message .= '<br><br><b>Order:</b><br> ' . html_entity_decode($this->request->post['productminidescr']) ;
				$message .= '<br><br><br><b>Comments:</b> ' . html_entity_decode($this->request->post['ringcomment']) ;
//				$message .= '<br><br><br>Regards, <br>' . $this->config->get('config_name') . ' Owner' ;
				if(isset($this->request->get['errorlog']))$this->log->write('Order Now - Message : ' . $message  );

				$message = str_replace(" <br>Center Gemstone", " " . $CATEGORYLETTER  . " <br>Center Gemstone",$message);

				$mail->setSubject($subject);
				$mail->setHtml($message);
				$mail->setText(html_entity_decode($message, ENT_QUOTES, 'UTF-8'));
				$mail->send();

				//$mail->setTo( $this->customer->getEmail() );
				$mail->setTo( $customerEmail  );
				$mail->setHtml($message);
				$mail->setText(html_entity_decode($message, ENT_QUOTES, 'UTF-8'));
				$mail->send();

				if($customerorderemail != ""){
					$mail->setTo($customerorderemail);
					$mail->send();
				}

				//$mail->setTo('soft.technee@yahoo.com');
				//$mail->send();

				$ProcurementEmails = $this->db->query("SELECT email FROM `customer` where customer_group_id = 9" );
				foreach($ProcurementEmails->rows as $emails) {
					$mail->setTo($emails['email']);
					$mail->setText(html_entity_decode($message, ENT_QUOTES, 'UTF-8'));
					$mail->send();
				}

				$json = array();
				$json['success'] = 'success';
				$this->response->setOutput(json_encode($json));
	}

	public function PrepareInvoice() {

		//call the FPDF library
		require('./fpdf181/fpdf.php');

		//A4 width : 219mm
		//default margin : 10mm each side
		//writable horizontal : 219-(10*2)=189mm

		//create pdf object
		$pdf = new FPDF('P','mm','A4');

		//add new page
		$pdf->AddPage();

		 $pdf->Cell(10 ,10,'',0,0);

		//set font to arial, bold, 14pt
$pdf->SetFont('Arial','B',16);

$pdf->Image('./image/Invoicelogo.png',160,15,30,30);
$pdf->Ln();


$pdf->Cell(10 ,5,'Astral Jewels Pty Ltd',0,1);

$pdf->Cell(10,3,'',0,1);
//set font to arial, regular, 12pt
$pdf->SetFont('Arial','B',12);

$pdf->Cell(10 ,5,'ATF Dreamers Family Trust  T/A Portobello Camberwell',0,1);

$pdf->Cell(10 ,5,'ABN 50 500 435 027',0,1);
$pdf->Ln();

$pdf->SetFont('Arial','',10);
$pdf->Cell(10 ,5,'PO Box 1099, Surrey Hills North VIC 3127 | sales@portobellojewellery.com.au | 0432 444 267',0,1);
$pdf->Ln();

$pdf->SetFillColor(255,253,253);
$pdf->SetFont('Arial','B',12);
$pdf->Cell(190 ,8,'TAX INVOICE',1,1,'C',true);

// Billing address
$pdf->Ln();
$pdf->Cell(120 ,5,'Bill to',0,0);
$pdf->SetFont('Arial','',12);
$pdf->Cell(30,5,'Invoice No.',0,0);
$pdf->Cell(50,5,'JE1520A190502',0,1);
$pdf->SetFont('Arial','',12);
$pdf->Cell(10,8,'',0,0);
$pdf->Cell(110,5,'Leading Edge Group Limited',0,0);
$pdf->Cell(30 ,5,'Invoice Date:',0,0);
$pdf->Cell(50 ,5,'2-May-2019',0,1);

$pdf->Cell(10 ,5,'',0,0);
$pdf->Cell(110,5,'72 Archer Street, Chatswood, NSW 2067',0,1);
$pdf->Ln();

// Shipping address
$pdf->SetFont('Arial','B',12);
$pdf->Cell(10 ,5,'Ship to',0,1);
$pdf->Cell(10 ,8,'',0,0);
$pdf->SetFont('Arial','',12);
$pdf->Cell(15 ,5,'Almas Gold Centre',0,1);
$pdf->Cell(10 ,5,'',0,0);
$pdf->Cell(15 ,5,'Shop 25A Churchill Shopping Centre, KILBURN, SA 5084',0,1);
$pdf->Cell(10 ,5,'',0,0);
$pdf->Cell(15 ,5,'JE1520A',0,1);

$pdf->Ln();
//invoice contents
$pdf->SetFillColor(220,220,220);
$pdf->SetFont('Arial','B',12);
$pdf->Cell(60 ,8,'Code',1,0,'',true);
$pdf->Cell(30 ,8,'Order #',1,0,'C',true);
$pdf->Cell(15 ,8,'Qty',1,0,'C',true);
$pdf->Cell(25 ,8,'Price',1,0,'C',true);
$pdf->Cell(25 ,8,'GST',1,0,'C',true);
$pdf->Cell(35 ,8,'Total (AUD)',1,1,'C',true);//end of line

$pdf->SetFont('Arial','',12);

//Numbers are right-aligned so we give 'R' after new line parameter

$pdf->Cell(60 ,7,'UltraCool Fridge',1,0);
$pdf->Cell(30 ,7,'100',  1,0,'C');
$pdf->Cell(15 ,7,'100',  1,0,'C');
$pdf->Cell(25 ,7,'100',  1,0,'R');
$pdf->Cell(25 ,7,'100',  1,0,'R');
$pdf->Cell(35 ,7,'3,250',1,1,'R');

$pdf->Cell(60 ,6,'UltraCool Fridge',1,0);
$pdf->Cell(30 ,6,'100', 1  , 0,'C');
$pdf->Cell(15 ,6,'100', 1  , 0,'C');
$pdf->Cell(25 ,6,'100', 1  , 0,'R');
$pdf->Cell(25 ,6,'100', 1  , 0,'R');
$pdf->Cell(35 ,6,'3,250', 1,1,'R');

$pdf->Cell(60 ,7,'',1,0);
$pdf->Cell(30 ,7,'', 1  , 0,'C');
$pdf->Cell(15 ,7,'', 1  , 0,'C');
$pdf->Cell(25 ,7,'', 1  , 0,'R');
$pdf->Cell(25 ,7,'', 1  , 0,'R');
$pdf->Cell(35 ,7,'', 1,1,'R');

$pdf->Cell(60 ,7,'',1,0);
$pdf->Cell(30 ,7,'', 1  , 0,'C');
$pdf->Cell(15 ,7,'', 1  , 0,'C');
$pdf->Cell(25 ,7,'', 1  , 0,'R');
$pdf->Cell(25 ,7,'', 1  , 0,'R');
$pdf->Cell(35 ,7,'', 1,1,'R');


$pdf->Cell(60 ,7,'',1,0);
$pdf->Cell(30 ,7,'', 1  , 0,'C');
$pdf->Cell(15 ,7,'', 1  , 0,'C');
$pdf->Cell(25 ,7,'', 1  , 0,'R');
$pdf->Cell(25 ,7,'', 1  , 0,'R');
$pdf->Cell(35 ,7,'', 1,1,'R');

$pdf->Cell(105 ,7,'(-) Discount 3%',1,0,'R');
$pdf->Cell(25 ,7,'-43.23', 1  , 0,'R');
$pdf->Cell(25 ,7,'-43.23', 1  , 0,'R');
$pdf->Cell(35 ,7,'-47.55', 1,1,'R');

$pdf->Cell(105 ,7,'Shipping',1,0,'R');
$pdf->Cell(25 ,7,'12', 1  , 0,'R');
$pdf->Cell(25 ,7,'12', 1  , 0,'R');
$pdf->Cell(35 ,7,'13.20', 1,1,'R');

$pdf->SetFont('Arial','B',12);
$pdf->Cell(105 ,8,'Total',1,0,'R');
$pdf->Cell(25 ,8,'$1,409.67', 1  ,0,'R');
$pdf->Cell(25 ,8,'$140.98', 1  , 0,'R');
$pdf->Cell(35 ,8,'$1,550.65', 1,1,'R');

$pdf->Ln();

$pdf->SetFont('Arial','',12);
$pdf->Cell(10 ,15,'Please pay using credit card or transfer funds to:',0,1);
$pdf->Cell(12 ,5,'',0,0);
$pdf->Cell(30,5,'Westpac Bank',0,1);
$pdf->Cell(12 ,5,'',0,0);
$pdf->Cell(30,5,'BSB: 033-089',0,1);
$pdf->Cell(12 ,5,'',0,0);
$pdf->Cell(30,5,'Account: 468320',0,1);

$pdf->Ln();
$pdf->Ln();

//$pdf->Cell(10 ,10);
$pdf->SetFont('Arial','B',12);
$pdf->Cell(50 ,5,'For Astral Jewels Pty Ltd',0,1);
$pdf->Ln();

$pdf->Image('./image/Invoicelogo.png',10,$pdf->GetY(),45,10);
$pdf->Ln();
$pdf->Ln();
$pdf->Ln();
$pdf->Cell(10 ,5,'SIGNED',0,1);

		//output the result
		$pdf->Output("F","./invoices/SamplePDF.pdf");

	}

	public function SendLinkMail() {

				$this->db->query("INSERT INTO " . DB_PREFIX . "linksubscription SET customer_id	 = '" . $this->customer->getId() . "', product_id		 = '" . $this->request->get['product_id'] . "',url	 = '" . $this->request->post['url'] . "',phone	 = '" . $this->request->post['phonenumber'] . "'" );

				$mail = new Mail();
				$mail->protocol = $this->config->get('config_mail_protocol');
				$mail->parameter = $this->config->get('config_mail_parameter') ;
				$mail->hostname = $this->config->get('config_smtp_host');
				$mail->username = $this->config->get('config_smtp_username');
				$mail->password = $this->config->get('config_smtp_password');
				$mail->port = $this->config->get('config_smtp_port');
				$mail->timeout = $this->config->get('config_smtp_timeout');

				$mail->setTo($this->config->get('config_email'));
				$mail->setFrom($this->config->get('config_email'));
				$mail->setSender($this->config->get('config_name'));

//				$mail->setTo('soft.technee@gmail.com');
//				$mail->setFrom('soft.technee@gmail.com');

				$subject = 'Send the Link to Stockist - ' . $this->customer->getName() ;

/*				$message = 'Hello ' . $this->config->get('config_name') . ' Owner,';
				$message .= '<br><br>One of Your Stockist clicked <B>SEND THE LINK</B> button for the following product. Please review and confirm about this product details.';

				$message .= '<br><br><b>Name of Stockist:</b> ' . $this->customer->getName() ;
				$message .= '<br><b>Stockist Id:</b> ' . $this->customer->getId() ;
				$message .= '<br><b>Stockist Mail:</b> ' . $this->customer->getEmail() ;
				$message .= '<br><b>Stockist Contact Number:</b> ' . $this->customer->getTelephone() ;

//				$message .= '<br><br><b>Order details:</b> ' . $this->request->post['productminidescr'] ;
				$message .= '<br><br><b>Product URL:</b> ' . $this->request->post['url'] ;
				$message .= '<br><b>Product ID:</b> ' . $this->request->get['product_id'] ;
				$message .= '<br><b>Stockist/Customer Phone Number:</b> ' . $this->request->post['phonenumber'] ;
				$message .= '<br><br><br>Regards, <br>' . $this->config->get('config_name') . ' Owner' ;
*/
				$message = '<br><b>Stockist/Customer Phone Number:</b> ' . $this->request->post['phonenumber'] ;
				$message .= '<br><br><br>Hello! <br><br>Here’s a link to the design that you liked at ' . $this->customer->getName() . ',<br><br>';
				$message .= $this->request->post['url'] ;
				$message .= '<br><br>Have fun customising:-)';

				$mail->setSubject($subject);
				$mail->setHtml($message);
				$mail->setText(html_entity_decode($message, ENT_QUOTES, 'UTF-8'));
				$mail->send();

				$json = array();
				$json['success'] = 'success';
				$this->response->setOutput(json_encode($json));

	}

}
