<?php  
class ControllerModuleCategory extends Controller {
	protected $category_id = 0;
	protected $path = array();
	
	protected function index() {
		$this->language->load('module/category');
		
    	$this->data['heading_title'] = $this->language->get('heading_title');
		
		$this->load->model('catalog/category');
		$this->load->model('tool/seo_url');
		
		if (isset($this->request->get['path'])) {
			$this->path = explode('_', $this->request->get['path']);
			
			$this->category_id = end($this->path);
		}
		
		//$this->data['category'] = $this->getCategories(0);
		
		//$this->data['category'] = $this->getCategoriesCombo(0); //Maneeram: to show category in dropdown box
		$this->data['category'] = $this->getShopByCategories(0);
												
		$this->id = 'category';

		if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/module/category.tpl')) {
			$this->template = $this->config->get('config_template') . '/template/module/category.tpl';
		} else {
			$this->template = 'default/template/module/category.tpl';
		}
		
		$this->render();
  	}
	
	protected function getCategories($parent_id, $current_path = '') {
		$category_id = array_shift($this->path);
		
		$output = '';
		
		//$results = $this->model_catalog_category->getCategories($parent_id);
		$results = $this->model_catalog_category->getParentCategories($parent_id); //print_r($results);
		
		if ($results) { 
			$output .= '<ul>';
    	}
		
		foreach ($results as $result) {	
			if (!$current_path) {
				$new_path = $result['category_id'];
			} else {
				$new_path = $current_path . '_' . $result['category_id'];
			}
			
			$output .= '<li>';
			
			$children = '';
			
			if ($category_id == $result['category_id']) {
				$children = $this->getCategories($result['category_id'], $new_path);
			}
			
			if ($this->category_id == $result['category_id']) {
				$output .= '<a href="' . $this->model_tool_seo_url->rewrite(HTTP_SERVER . 'index.php?route=product/category&amp;path=' . $new_path)  . '"><b>' . $result['name'] . '</b></a>';
			} else {
				$output .= '<a href="' . $this->model_tool_seo_url->rewrite(HTTP_SERVER . 'index.php?route=product/category&amp;path=' . $new_path)  . '">' . $result['name'] . '</a>';
			}
			
        	$output .= $children;
        
        	$output .= '</li>'; 
		}
 
		if ($results) {
			$output .= '</ul>';
		}
		
		return $output;
	}
	
	/* ----------------Maneeram: to show category in dropdown box ----------------------*/
	/*protected function getCategoriesCombo($parent_id, $current_path = '') {
		$category_id = array_shift($this->path);
		
		$output = '';
		
		$results = $this->model_catalog_category->getCategories($parent_id);
		
		if ($results) { 
			$output .= '<form>';
    	}
		
		foreach ($results as $result) {	
			if (!$current_path) {
				$new_path = $result['category_id'];
			} else {
				$new_path = $current_path . '_' . $result['category_id'];
			}
			
			$output .= '<select onchange="location = this.value">';
			
			$children = '';
			
			if ($category_id == $result['category_id']) {
				$children = $this->getCategoriesCombo($result['category_id'], $new_path);
			}
			
			if ($this->category_id == $result['category_id']) {
				$output .= '<option value="' . $this->model_tool_seo_url->rewrite(HTTP_SERVER . 'index.php?route=product/category&amp;path=' . $new_path)  . '" selected="selected">' . $result['name'] .'</option>';
			} else {
				$output .= '<option value="' . $this->model_tool_seo_url->rewrite(HTTP_SERVER . 'index.php?route=product/category&amp;path=' . $new_path)  . '">' . $result['name'] .'</option>';
			}
			
        	$output .= $children;
        
        	$output .= '</select>'; 
		}
 
		if ($results) {
			$output .= '</form>';
		}
		
		return $output;
	}*/
	
	protected function getShopByCategories($parent_id, $current_path = '') {
	
		$output = '';
		$results = $this->model_catalog_category->getParentCategories($parent_id);
		
		foreach ($results as $result) {	
			
			//$output .= '<form id=frm'.$result['category_id'].'> <select style=\'width:150px;\' onchange=\'$(#frm'.$result['category_id'].').submit()\'>';
			$output .= '<form id=frm'.$result['category_id'].'> <select style=\'width:150px;\' onchange=\'location = this.value\'>';
			//$output .= '<option> mytest </option>';
			$output .= '<option value="' . $this->model_tool_seo_url->rewrite(HTTP_SERVER . 'index.php?route=product/category&amp;path=' . $result['category_id'])  . '">' . $result['name'].'</option>';
			
			$child_results = $this->model_catalog_category->getCategories($result['category_id']);
			//for($i=0; $i < $this->model_catalog_category->getTotalCategoriesByCategoryId($result['category_id']); $i++) {
			foreach ( $child_results as $child_result) {
				if (!$current_path) {
				$new_path = $child_result['category_id'];
			} else {
				$new_path = $current_path . '_' . $child_child_result['category_id'];
			}
				$output .= '<option value="' . $this->model_tool_seo_url->rewrite(HTTP_SERVER . 'index.php?route=product/category&amp;path=' . $new_path)  . '">' . $child_result['name'] .'</option>';
			}
			$output .= '</select></form><br />';
		}
		return $output;
	}
	/*-------------Maneeram: to show category in dropdown box End-------------------*/
			
}
?>